/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.co.fujiric.star.gui.gef.swing.EmptyAnchoredShapeModelImpl;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalLinkWithCircleModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalNameModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueModel;
import jp.sbi.celldesigner.blockDiagram.table.ModifierTableValue;

public class ExternalNameForResidueModel
extends ExternalNameModel {
    private Set residueModelSet = new TreeSet();
    private EmptyAnchoredShapeModelImpl basemOnHaloWest = null;
    private Map linkgmMapByResidueModel = new TreeMap();
    private ModifierTableValue modifierTableValue = null;
    private boolean predefined;
    private boolean loaded;

    public ExternalNameForResidueModel(boolean predefined, boolean loaded) {
        super(1);
        this.predefined = predefined;
        this.loaded = loaded;
        this.setEditable(!predefined);
    }

    public void add(ResidueModel rm, ExternalLinkWithCircleModel linkgm) {
        this.residueModelSet.add(rm);
        this.linkgmMapByResidueModel.put(rm, linkgm);
    }

    public boolean contains(ResidueModel rm) {
        return this.residueModelSet.contains(rm);
    }

    public Set getKeySetOfRtmMapByResidueModel() {
        return Collections.unmodifiableSet(this.linkgmMapByResidueModel.keySet());
    }

    public ExternalLinkWithCircleModel getExternalLinkWithCircleModelByResidueModel(ResidueModel rm) {
        ExternalLinkWithCircleModel rtm = (ExternalLinkWithCircleModel)this.linkgmMapByResidueModel.get(rm);
        return rtm;
    }

    public void setRemoveMessage(ResidueModel rm) {
        ExternalLinkWithCircleModel linkgm = (ExternalLinkWithCircleModel)this.linkgmMapByResidueModel.get(rm);
        if (linkgm != null) {
            this.removeRemoveShape(linkgm);
        }
        this.residueModelSet.remove(rm);
        if (this.residueModelSet.size() <= 0) {
            this.remove();
        }
    }

    public EmptyAnchoredShapeModelImpl getBasemOnHaloWest() {
        return this.basemOnHaloWest;
    }

    public void setBasemOnHaloWest(EmptyAnchoredShapeModelImpl basem) {
        this.basemOnHaloWest = basem;
    }

    @Override
    protected void removeSelf() {
        this.basemOnHaloWest.remove();
        super.removeSelf();
    }

    @Override
    protected boolean needToSetNameInitially() {
        return !this.predefined && !this.loaded;
    }

    protected void setRemovable(boolean flag) {
        this.setDirectRemovable(flag);
        this.basemOnHaloWest.setDirectRemovable(flag);
    }

    public void setModifierTableValue(ModifierTableValue mtv) {
        this.modifierTableValue = mtv;
    }

    public ModifierTableValue getModifierTableValue() {
        return this.modifierTableValue;
    }
}

