/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import jp.co.fujiric.star.gui.gef.swing.CircleVC;
import jp.co.fujiric.star.gui.gef.swing.Point;
import jp.co.fujiric.star.gui.gef.swing.RoundRectVC;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteVC;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalCircleModel;

public class ExternalInhibitionCircleVC
extends CircleVC {
    private boolean hilited = false;

    @Override
    protected Class getExpectedModelClass() {
        return ExternalCircleModel.class;
    }

    @Override
    protected void paintGUIComponent(Graphics2D g2) {
        ShapeModelImpl m = (ShapeModelImpl)this.getModel();
        Color foreColor = g2.getColor();
        g2.setColor(this.getForeColorBySelectStatus(m.getSelectState()));
        g2.setStroke(this.getStroke());
        g2.draw(this.getShape());
        g2.setColor(foreColor);
    }

    private Shape getShape() {
        Rectangle rc = this.getGUIComponentBounds();
        Rectangle r = this.getGUIBounds();
        float x = r.x - rc.x;
        float y = r.y - rc.y;
        float w = r.width;
        float h = r.height;
        GeneralPath gp = new GeneralPath();
        gp.moveTo(x, y);
        gp.lineTo(x + w, y + h);
        gp.moveTo(x + w, y);
        gp.lineTo(x, y + h);
        return gp;
    }

    @Override
    protected double getCrossPoint(Point ps, Point pe) {
        Rectangle r = this.getGUIBounds();
        double x = r.x;
        double y = r.y;
        double w = r.width;
        double h = r.height;
        double cx = x + w * 0.5;
        double cy = y + h * 0.5;
        return RoundRectVC.getCrossPointForQuadrantCircle(ps, pe, null, cx - 0.5, cy - 0.5, cx + 0.5, cy + 0.5);
    }

    public void setHilited(boolean b) {
        this.hilited = b;
        this.visualUpdate();
    }

    @Override
    protected Color getForeColorBySelectStatus(int selectStatus) {
        Color c = super.getForeColorBySelectStatus(selectStatus);
        if (this.hilited) {
            c = BindingSiteVC.getForeColorConsideringHilited(this.hilited, c, this);
        }
        return c;
    }
}

