/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import jp.co.fujiric.star.gui.gef.swing.AnchoredShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteVC;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradeTriangleModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperationalVC;

public class DegradeTriangleVC
extends AnchoredShapeVCImpl
implements InternalOperationalVC {
    private boolean hilited = false;

    @Override
    protected Class getExpectedModelClass() {
        return DegradeTriangleModel.class;
    }

    @Override
    protected void paintGUIComponent(Graphics2D g2) {
        ShapeModelImpl m = (ShapeModelImpl)this.getModel();
        Color foreColor = g2.getColor();
        g2.setColor(this.getForeColorBySelectStatus(m.getSelectState()));
        g2.fill(this.getTriangleShape());
        g2.setColor(foreColor);
    }

    protected Shape getTriangleShape() {
        Rectangle r = this.getGUIBounds();
        Rectangle rc = this.getGUIComponentBounds();
        int x = r.x - rc.x;
        int y = r.y - rc.y;
        int w = r.width;
        int h = r.height;
        GeneralPath gp = new GeneralPath();
        gp.moveTo(x, y);
        gp.lineTo(x, y + h);
        gp.lineTo(x + w, (float)h * 0.5f + (float)y);
        gp.lineTo(x, y);
        return gp;
    }

    @Override
    public boolean canBeAEndPoint() {
        return true;
    }

    @Override
    public boolean canBeAStartPoint() {
        return false;
    }

    public void setHilited(boolean b) {
        this.hilited = b;
        this.visualUpdate();
    }

    @Override
    protected Color getForeColorBySelectStatus(int selectStatus) {
        Color c = super.getForeColorBySelectStatus(selectStatus);
        if (this.hilited) {
            c = BindingSiteVC.getForeColorConsideringHilited(this.hilited, c, this);
        }
        return c;
    }
}

