/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeWithHandleVCImpl;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradeShapeModel;

public class DegradeShapeVC
extends ShapeWithHandleVCImpl {
    protected static final float MARGIN = 4.0f;

    @Override
    protected Class getExpectedModelClass() {
        return DegradeShapeModel.class;
    }

    @Override
    protected void paintGUIComponent(Graphics2D g2) {
        ShapeModelImpl m = (ShapeModelImpl)this.getModel();
        Color foreColor = g2.getColor();
        g2.setColor(this.getForeColorBySelectStatus(m.getSelectState()));
        g2.setStroke(this.getStroke());
        g2.draw(this.getShape());
        g2.setColor(foreColor);
    }

    protected Shape getShape() {
        Rectangle r = this.getGUIBounds();
        Rectangle rc = this.getGUIComponentBounds();
        float margin = 4.0f;
        if ((float)r.width < 2.0f * margin) {
            margin = (float)(r.width - 1) * 0.5f;
        }
        if ((float)r.height < 2.0f * margin) {
            margin = (float)(r.height - 1) * 0.5f;
        }
        float x0 = r.x - rc.x;
        float y0 = r.y - rc.y;
        float x = x0 + margin;
        float y = y0 + margin;
        float w0 = r.width;
        float h0 = r.height;
        float w = w0 - 2.0f * margin;
        float h = h0 - 2.0f * margin;
        GeneralPath gp = new GeneralPath();
        if (w >= h) {
            float dx = (w - h) * 0.5f;
            Ellipse2D.Float e = new Ellipse2D.Float(x += dx, y, h, h);
            gp.append(e, false);
            gp.moveTo(x + h * 0.7f, y - margin);
            gp.lineTo(x + h * 0.3f, y + h + margin);
        } else {
            float dy = (h - w) * 0.5f;
            Ellipse2D.Float e = new Ellipse2D.Float(x, y += dy, w, w);
            gp.append(e, false);
            gp.moveTo(x + w * 0.7f, y - margin);
            gp.lineTo(x + w * 0.3f, y + w + margin);
        }
        return gp;
    }
}

