/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import jp.co.fujiric.star.gui.gef.swing.AnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.AnchoredShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.CanvasVCImpl;
import jp.co.fujiric.star.gui.gef.swing.CompositeShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.CompositeShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.EmptyAnchoredShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.EmptyAnchoredShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapePlacerByClick;
import jp.co.fujiric.star.gui.gef.swing.ShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.SimpleAnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.SwingVCImpl;
import jp.co.fujiric.star.gui.gef.swing.XYAnchorImpl;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSitePlacer;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockVC;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasVC;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradeLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradeLinkVC;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradeShapeModel;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradeShapeVC;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradeTriangleModel;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradeTriangleVC;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloEastEdgeModel;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloEastEdgeVC;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloModel;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloVC;
import jp.sbi.celldesigner.blockDiagram.diagram.RestrictedInShapeMover;

public class DegradePlacer
extends ShapePlacerByClick {
    private AbstractButton pointerButton;

    public DegradePlacer(CanvasVCImpl canvasvc, AbstractButton pointerButton) {
        super(canvasvc);
        this.pointerButton = pointerButton;
    }

    @Override
    protected boolean isCreateShape(MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        BlockVC blockvc = ((CanvasVC)this.canvasvc).getBlockvc();
        return blockvc.isOnTheEdge(canvasx, canvasy, 3, 6, 6);
    }

    @Override
    protected boolean isCreateShapeWithAnchoring(MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        return true;
    }

    @Override
    protected ShapeModelImpl anchorToTheTarget(ShapeModelImpl shape, SwingVCImpl sourcevc) {
        return this.anchorToTheTarget(shape, null, false, 0.0, 0, 0, 0.0, 0.0);
    }

    protected ShapeModelImpl anchorToTheTarget(ShapeModelImpl shape, List dList, boolean loaded, double dtmOffsetY, int dsmWidth, int dsmHeight, double dsmOffsetX, double dsmOffsetY) {
        BlockVC blockvc = ((CanvasVC)this.canvasvc).getBlockvc();
        BlockModel blockm = (BlockModel)blockvc.getModel();
        HaloVC halovc = ((CanvasVC)this.canvasvc).getHalovc();
        HaloModel halom = (HaloModel)halovc.getModel();
        HaloEastEdgeVC heevc = ((CanvasVC)this.canvasvc).getHaloEastEdgevc();
        HaloEastEdgeModel heem = (HaloEastEdgeModel)heevc.getModel();
        if (!(shape instanceof DegradeTriangleModel)) {
            return null;
        }
        DegradeTriangleModel dtm = (DegradeTriangleModel)shape;
        dtm.setProteinActivityList(dList);
        EmptyAnchoredShapeModelImpl tailbasem = new EmptyAnchoredShapeModelImpl();
        tailbasem.initialize(this.canvasm);
        this.canvasm.addLast(tailbasem);
        int cx = shape.getCenterX();
        int cy = shape.getCenterY();
        int y1 = BindingSitePlacer.calcTheNearestYCoordOnTheBlock(((CanvasVC)this.canvasvc).getBlockvc(), cy);
        int xOfBlockEastEdge = blockm.getX() + blockm.getWidth() - 1;
        if (cy != y1 || cx != xOfBlockEastEdge) {
            int dx = xOfBlockEastEdge - cx;
            int dy = y1 - cy;
            shape.move(dx, dy);
            cy = y1;
            cx = xOfBlockEastEdge;
        }
        int targetCy = blockm.getCenterY();
        double dx = -1.0;
        double dy = loaded ? dtmOffsetY : (double)(cy - targetCy);
        SimpleAnchorImpl anchor = new SimpleAnchorImpl(3, 10, dx, dy);
        ((AnchorImpl)anchor).initialize(blockm);
        dtm.addLastAnchor(anchor);
        if (loaded) {
            dtm.setLocationByShape(blockm);
            cy = dtm.getCenterY();
        }
        int dx2 = 0;
        int dy2 = 0;
        SimpleAnchorImpl yAnchor = new SimpleAnchorImpl(3, 10, dx2, dy2);
        yAnchor.initialize(dtm);
        dx2 = -1;
        dy2 = cy - halom.getCenterY();
        SimpleAnchorImpl xAnchor = new SimpleAnchorImpl(3, 10, dx2, dy2);
        xAnchor.initialize(halom);
        XYAnchorImpl xyAnchor = new XYAnchorImpl(xAnchor, yAnchor);
        tailbasem.addLastAnchor(xyAnchor);
        DegradeShapeModel dsm = new DegradeShapeModel();
        int x = heem.getX() - 1;
        int y = y1;
        if (loaded) {
            dsm.initialize(this.canvasm, x, y, dsmWidth, dsmHeight);
        } else {
            dsm.initialize(this.canvasm, x, y);
        }
        this.canvasm.addLast(dsm);
        int h = dsm.getHeight();
        dsm.move(0, -h / 2);
        double dx3 = loaded ? dsmOffsetX : (double)(dsm.getCenterX() - x);
        double dy3 = loaded ? dsmOffsetY : (double)(dsm.getCenterY() - y);
        SimpleAnchorImpl a = new SimpleAnchorImpl(0, 10, dx3, dy3);
        dsm.addLastShape(tailbasem, a);
        if (loaded) {
            dsm.setLocationByShape(tailbasem);
        }
        DegradeLinkModel tailm = new DegradeLinkModel();
        int x2 = dtm.getX() + dtm.getWidth() - 1;
        int y2 = dtm.getCenterY();
        int h2 = 0;
        int w = tailbasem.getX() - x2;
        tailm.initialize(this.canvasm, x2, y2, w, h2, false);
        tailm.addLastShape(dtm, new SimpleAnchorImpl(0, 11));
        tailm.addLastShape(tailbasem, new SimpleAnchorImpl(0, 11));
        this.canvasm.addLast(tailm);
        CompositeShapeModelImpl groupm = new CompositeShapeModelImpl();
        groupm.initialize(this.canvasm);
        LinkedList<AnchoredShapeModelImpl> shapes = new LinkedList<AnchoredShapeModelImpl>();
        shapes.addLast(dtm);
        shapes.addLast(tailm);
        groupm.add(shapes);
        dsm.addRemoveShape(groupm);
        dsm.addRemoveShape(tailbasem);
        dsm.addRemoveShape(dtm);
        dtm.setRelatedModels(tailm, dsm, groupm);
        if (dtm.isPredefined()) {
            dtm.setRemovable(false);
        }
        return blockm;
    }

    private void clickPointerButton() {
        if (this.pointerButton != null) {
            this.pointerButton.doClick();
        }
    }

    @Override
    public ShapeModelImpl createShape() {
        return this.createShape(null);
    }

    protected ShapeModelImpl createShape(DegradeTriangleModel dtm) {
        BlockVC blockvc = ((CanvasVC)this.canvasvc).getBlockvc();
        BlockModel blockm = (BlockModel)blockvc.getModel();
        if (dtm == null) {
            dtm = (DegradeTriangleModel)super.createShape();
        }
        blockm.setDegradeTriangleModel(dtm);
        dtm.setBlockModel(blockm);
        ShapeVCImpl vc = this.canvasvc.getFromShapeVCByModel(dtm);
        vc.setMover(new RestrictedInShapeMover(blockm, 2));
        return dtm;
    }

    @Override
    protected void handlerAfterCreateShape() {
        this.clickPointerButton();
    }

    @Override
    public String getMainShapeModelClassName() {
        String mcname = DegradeTriangleModel.class.getName();
        return mcname;
    }

    @Override
    public Map getShapeMVCClassNamesMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.getMainShapeModelClassName(), DegradeTriangleVC.class.getName());
        map.put(DegradeLinkModel.class.getName(), DegradeLinkVC.class.getName());
        map.put(EmptyAnchoredShapeModelImpl.class.getName(), EmptyAnchoredShapeVCImpl.class.getName());
        map.put(DegradeShapeModel.class.getName(), DegradeShapeVC.class.getName());
        map.put(CompositeShapeModelImpl.class.getName(), CompositeShapeVCImpl.class.getName());
        return map;
    }

    public DegradeTriangleModel createDegradeTriangleModel(int x, int y) {
        DegradeTriangleModel dtm = new DegradeTriangleModel();
        dtm.initialize(this.canvasm, x, y);
        this.canvasm.addLast(dtm);
        return dtm;
    }
}

