/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import jp.co.fujiric.star.gui.gef.ModelImpl;
import jp.co.fujiric.star.gui.gef.swing.CanvasModelImpl;
import jp.co.fujiric.star.gui.gef.swing.CanvasVCImpl;
import jp.co.fujiric.star.gui.gef.swing.EmptyAnchoredShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.EmptyAnchoredShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.EmptyLinkModelImpl;
import jp.co.fujiric.star.gui.gef.swing.EmptyLinkVCImpl;
import jp.co.fujiric.star.gui.gef.swing.LinkModelImpl;
import jp.co.fujiric.star.gui.gef.swing.LinkVCImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.SimpleAnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.XYAnchorImpl;
import jp.sbi.celldesigner.blockDiagram.diagram.Annotation;
import jp.sbi.celldesigner.blockDiagram.diagram.AspectConstants;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSitePlacer;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockNameModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockNameVC;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockSouthEdgeModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockSouthEdgeVC;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockVC;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasModel;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradePlacer;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradeTriangleModel;
import jp.sbi.celldesigner.blockDiagram.diagram.EffectSiteInvisibleLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.EffectSiteModel;
import jp.sbi.celldesigner.blockDiagram.diagram.EffectSitePlacer;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalLinkPlacer;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalNameForResidueModel;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloEastEdgeModel;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloEastEdgeVC;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloModel;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloVC;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloWestEdgeModel;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloWestEdgeVC;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalLinkPlacer;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperationalModel;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorModel;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorPlacer;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResiduePlacer;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueTailModel;
import jp.sbi.celldesigner.blockDiagram.table.ComparableProteinSet;
import jp.sbi.celldesigner.blockDiagram.table.ModificationWrapper;
import jp.sbi.celldesigner.blockDiagram.table.ModifierTableValue;
import jp.sbi.celldesigner.blockDiagram.table.ProteinActivity;
import jp.sbi.celldesigner.blockDiagram.table.ProteinState;
import jp.sbi.celldesigner.blockDiagram.table.ResidueState;
import jp.sbi.celldesigner.blockDiagram.table.TableValues;
import jp.sbi.celldesigner.sbmlExtension.Modification;

public class CanvasVC
extends CanvasVCImpl
implements AspectConstants {
    private HaloWestEdgeVC haloWestvc;
    private HaloEastEdgeVC haloEastvc;
    private HaloVC halovc;
    private LinkVCImpl haloNorthWestvc;
    private BlockVC blockvc;
    private BlockSouthEdgeVC blockSouthvc;
    private AbstractButton updateButton;
    private int initialPreferredWidth;
    private int initialPreferredHeight;

    public void initializevc(ModelImpl model, Annotation annotation, AbstractButton updateButton) {
        super.initializevc(model);
        this.updateButton = updateButton;
        try {
            this.setupBlock(annotation);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupMVCMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(HaloModel.class.getName(), HaloVC.class.getName());
        map.put(BlockModel.class.getName(), BlockVC.class.getName());
        map.put(HaloWestEdgeModel.class.getName(), HaloWestEdgeVC.class.getName());
        map.put(HaloWestEdgeModel.class.getName(), HaloWestEdgeVC.class.getName());
        map.put(HaloEastEdgeModel.class.getName(), HaloEastEdgeVC.class.getName());
        map.put(BlockSouthEdgeModel.class.getName(), BlockSouthEdgeVC.class.getName());
        map.put(EmptyAnchoredShapeModelImpl.class.getName(), EmptyAnchoredShapeVCImpl.class.getName());
        map.put(BlockNameModel.class.getName(), BlockNameVC.class.getName());
        map.put(EmptyLinkModelImpl.class.getName(), EmptyLinkVCImpl.class.getName());
        this.setShapeMVCClassNames(map, null);
    }

    public void setTableValues(TableValues values) {
        CanvasModel cm = (CanvasModel)this.getModel();
        cm.setTableValues(values);
    }

    public TableValues getTableValues() {
        CanvasModel cm = (CanvasModel)this.getModel();
        return cm.getTableValues();
    }

    @Override
    protected Class getExpectedModelClass() {
        return CanvasModel.class;
    }

    private void setupBlock(Annotation annotation) {
        TableValues values = this.getTableValues();
        String id = values.getSBaseId();
        Annotation.BlockDiagramInfo bdinfo = annotation.createBlockDiagramFromDOMForProtein(id);
        this.setupBlock(bdinfo);
    }

    public void clearBlock() {
        CanvasModel cm = (CanvasModel)this.getModel();
        cm.clearBlock();
    }

    public void setupBlock(Annotation.BlockDiagramInfo bdinfo) {
        int my2temp;
        int my2;
        int h1;
        int bh;
        this.setupMVCMap();
        this.setInitialPreferredSize(bdinfo);
        CanvasModel cm = (CanvasModel)this.getModel();
        TableValues values = cm.getTableValues();
        List bsList = values.getProteinStateListForBinding();
        List esList = values.getProteinActivityListForEffectSite();
        Map rMap = values.getResidueStateMapForResidueSite();
        List dList = values.getProteinActivityListForDegraded();
        Map mtvMap = values.getMtvMapByMpset();
        Map mtvMapByString = this.createMtvMapByString(mtvMap);
        int nbs = bsList.size();
        int nes = esList.size();
        int nr = this.calcNumberOfCreateResidueModel(rMap, false);
        int nmtvKey = mtvMapByString.size();
        int bx = 100;
        int by = 50;
        int bw = 140;
        int w1 = (nr + 1) * 30;
        if (bw < w1) {
            bw = w1;
        }
        if (bw < (w1 = (nes + 1) * 30)) {
            bw = w1;
        }
        if ((bh = 90) < (h1 = (nbs + 1) * 30)) {
            bh = h1;
        }
        int mx = 30;
        int my1 = 30;
        int my1temp = (nmtvKey + 1) * 16 + ResidueModel.getDefaultHeightStatic() / 2;
        if (my1 < my1temp) {
            my1 = my1temp;
        }
        if ((my2 = 30) < (my2temp = (nes + 1) * 16 + EffectSiteModel.getDefaultHeightStatic() / 2)) {
            my2 = my2temp;
        }
        int hx = bx - mx;
        int hy = by - my1;
        if (hy < 5) {
            by += 5 - hy;
            hy = 5;
        }
        int hw = bw + 2 * mx;
        int hh = bh + my1 + my2;
        if (bdinfo.isLoaded()) {
            bx = bdinfo.getBlockX();
            by = bdinfo.getBlockY();
            bw = bdinfo.getBlockWidth();
            bh = bdinfo.getBlockHeight();
            hx = bdinfo.getHaloX();
            hy = bdinfo.getHaloY();
            hw = bdinfo.getHaloWidth();
            hh = bdinfo.getHaloHeight();
        }
        HaloModel hm = new HaloModel();
        hm.initialize((CanvasModelImpl)this.getModel(), hx, hy, hw, hh);
        ((CanvasModelImpl)this.getModel()).addLast(hm);
        this.halovc = (HaloVC)this.getFromShapeVCByModel(hm);
        BlockModel bm = new BlockModel();
        bm.initialize((CanvasModelImpl)this.getModel(), bx, by, bw, bh);
        ((CanvasModelImpl)this.getModel()).addLast(bm);
        this.blockvc = (BlockVC)this.getFromShapeVCByModel(bm);
        this.halovc.setBlockVC(this.blockvc);
        this.blockvc.setHaloVC(this.halovc);
        int hmx = hm.getX();
        int hmy = hm.getY();
        EmptyAnchoredShapeModelImpl hmnw = new EmptyAnchoredShapeModelImpl();
        hmnw.initialize((CanvasModelImpl)this.getModel(), hmx, hmy);
        ((CanvasModelImpl)this.getModel()).addLast(hmnw);
        hmnw.addLastShape(hm, new SimpleAnchorImpl(5));
        this.createBlockName(bdinfo, bm);
        this.createHaloWestEdge(hm, hmnw);
        this.createHaloEastEdge(hm);
        this.createBlockSouthEdge(bm);
        this.createHaloNorthWestLink(bm, hm, hmnw);
        boolean added = false;
        if (bdinfo.isLoaded()) {
            Map rmMap2;
            Map restOfRMap;
            List restOfEsList;
            boolean restOfDtm;
            Map bsmMap = this.createPredefinedBindingSitesWithBDInfo(bdinfo, bm, hm, bsList);
            Map dtmMap = this.createPredefinedDegradedShapeWithBDInfo(bdinfo, bm, hm, dList);
            Map esmMap = this.createPredefinedEffectSitesWithBDInfo(bdinfo, bm, hm, esList);
            Map[] rmMap = this.createPredefinedResiduesWithBDInfo(bdinfo, bm, hm, nr, rMap);
            Map[] enMap = this.createPredefinedExtNamesForResidueWithBDInfo(bdinfo, bm, hm, rmMap[0], mtvMapByString);
            Map omMap = this.createPredefinedOperatorsWithBDInfo(bdinfo, bm, hm);
            this.createPredefinedInternalLinksWithBDInfo(bdinfo, bm, hm, bsmMap, dtmMap, esmMap, rmMap[0], omMap);
            List restOfBsList = this.createRestOfBsList(bsmMap, bsList);
            if (restOfBsList.size() > 0) {
                added = true;
                this.createPredefinedBindingSites(bm, hm, restOfBsList, bsmMap);
            }
            if (restOfDtm = this.createRestOfDtm(dtmMap, dList)) {
                added = true;
                this.createPredefinedDegradedShape(bm, hm, dList);
            }
            if ((restOfEsList = this.createRestOfEsList(esmMap, esList)).size() > 0) {
                added = true;
                this.createPredefinedEffectSites(bm, hm, restOfEsList, esmMap);
            }
            if ((restOfRMap = this.createRestOfRMap(rmMap[0], rMap)).size() > 0) {
                added = true;
                int nr1 = this.calcNumberOfCreateResidueModel(restOfRMap, true);
                rmMap2 = this.createPredefinedResidues(bm, hm, nr1, restOfRMap, rmMap[0], rmMap[1]);
            } else {
                rmMap2 = rmMap[1];
            }
            Map restOfMtvMap = this.createRestOfMtvMap(enMap, mtvMapByString);
            if (restOfMtvMap.size() > 0) {
                this.createPredefinedExternalNamesForResidue(bm, hm, restOfMtvMap, rMap, rmMap2);
            }
        } else {
            this.createPredefinedBindingSites(bm, hm, bsList, null);
            this.createPredefinedDegradedShape(bm, hm, dList);
            this.createPredefinedEffectSites(bm, hm, esList, null);
            Map rmMap2 = this.createPredefinedResidues(bm, hm, nr, rMap, null, null);
            this.createPredefinedExternalNamesForResidue(bm, hm, mtvMapByString, rMap, rmMap2);
            added = true;
        }
        if (added) {
            cm.setEdited();
        } else {
            cm.clearEdited();
        }
    }

    private Map createMtvMapByString(Map mtvMap) {
        TreeMap map = new TreeMap();
        for (ComparableProteinSet set : mtvMap.keySet()) {
            map.put(set.toStringOfId(), mtvMap.get(set));
        }
        return map;
    }

    private Map createRestOfMtvMap(Map[] enMap, Map mtvMap) {
        TreeMap<String, ModifierTableValue> map = new TreeMap<String, ModifierTableValue>();
        for (String key : mtvMap.keySet()) {
            ModifierTableValue mtv1;
            Object obj;
            String key1;
            Modification m;
            ModifierTableValue mtv = (ModifierTableValue)mtvMap.get(key);
            Set set = mtv.getActivateResidueSet();
            for (ModificationWrapper mw : set) {
                m = mw.getModification();
                key1 = CanvasVC.getStringForKey(key, 1, m.getResidue(), m.getState());
                obj = enMap[1].get(key1);
                if (obj != null) continue;
                mtv1 = (ModifierTableValue)map.get(key);
                if (mtv1 == null) {
                    mtv1 = new ModifierTableValue(mtv.getModifiers());
                    map.put(key, mtv1);
                }
                mtv1.appendActivateResidue(mw);
            }
            set = mtv.getDeactivateResidueSet();
            for (ModificationWrapper mw : set) {
                m = mw.getModification();
                key1 = CanvasVC.getStringForKey(key, 3, m.getResidue(), m.getState());
                obj = enMap[1].get(key1);
                if (obj != null) continue;
                mtv1 = (ModifierTableValue)map.get(key);
                if (mtv1 == null) {
                    mtv1 = new ModifierTableValue(mtv.getModifiers());
                    map.put(key, mtv1);
                }
                mtv1.appendDeactivateResidue(mw);
            }
        }
        return map;
    }

    private void createPredefinedExternalNamesForResidue(BlockModel bm, HaloModel hm, Map mtvMapByString, Map rMap, Map rmMap2) {
        int y1 = hm.getY();
        int y2 = bm.getY() - ResidueModel.getDefaultHeightStatic() / 2;
        double y2_y1 = y2 - y1;
        int cy = (int)(y2_y1 * 0.5 + (double)y1);
        int nNames = mtvMapByString.size();
        double dy = (double)(y2 - y1) / (double)(nNames + 1);
        double offsetY = -(cy - y1);
        boolean predefined = true;
        boolean loaded = false;
        for (Object key : mtvMapByString.keySet()) {
            Set deactivateResidueSet;
            int y = (int)((double)cy + (offsetY += dy));
            ModifierTableValue mtv = (ModifierTableValue)mtvMapByString.get(key);
            String name = mtv.getModifiersProteinName();
            ExternalNameForResidueModel namem = null;
            Set activateResidueSet = mtv.getActivateResidueSet();
            if (!activateResidueSet.isEmpty()) {
                int type = 1;
                ExternalLinkPlacer placer = new ExternalLinkPlacer(this.canvasVC, type);
                this.canvasVC.setPlacer(placer);
                for (ModificationWrapper mw : activateResidueSet) {
                    Modification m = mw.getModification();
                    String residueId = m.getResidue();
                    String state = m.getState();
                    Set set = (Set)rMap.get(residueId);
                    if (set == null) continue;
                    String key1 = CanvasVC.getStringForKey(residueId, state);
                    ResidueModel rm = (ResidueModel)rmMap2.get(key1);
                    ResidueTailModel tailm = rm.getTailModel();
                    ExternalLinkModel linkm = (ExternalLinkModel)placer.createLink(namem, predefined, tailm, y, predefined, loaded, 0.0, name, 0.0, 0.0);
                    namem = linkm.getNameModel();
                    namem.setModifierTableValue(mtv);
                }
            }
            if ((deactivateResidueSet = mtv.getDeactivateResidueSet()).isEmpty()) continue;
            int type = 3;
            ExternalLinkPlacer placer = new ExternalLinkPlacer(this.canvasVC, type);
            this.canvasVC.setPlacer(placer);
            for (ModificationWrapper mw : deactivateResidueSet) {
                Modification m = mw.getModification();
                String residueId = m.getResidue();
                String state = m.getState();
                Set set = (Set)rMap.get(residueId);
                if (set == null) continue;
                String key1 = CanvasVC.getStringForKey(residueId, state);
                ResidueModel rm = (ResidueModel)rmMap2.get(key1);
                ResidueTailModel tailm = rm.getTailModel();
                ExternalLinkModel linkm = (ExternalLinkModel)placer.createLink(namem, predefined, tailm, y, predefined, loaded, 0.0, name, 0.0, 0.0);
                namem = linkm.getNameModel();
                namem.setModifierTableValue(mtv);
            }
        }
    }

    private int calcNumberOfCreateResidueModel(Map rMap, boolean createAllEmptyResidues) {
        int nr = 0;
        for (String residueId : rMap.keySet()) {
            Set set1 = (Set)rMap.get(residueId);
            int count = 0;
            boolean findEmpty = false;
            for (ResidueState rs : set1) {
                if (!createAllEmptyResidues && rs.isEmptyResidue()) {
                    findEmpty = true;
                    continue;
                }
                ++count;
            }
            if (count == 0 && findEmpty) {
                count = 1;
            }
            nr += count;
        }
        return nr;
    }

    private Map createRestOfRMap(Map rmMap, Map rMap) {
        TreeSet<ResidueState> set = new TreeSet<ResidueState>();
        for (Object key : rmMap.keySet()) {
            ResidueModel rm = (ResidueModel)rmMap.get(key);
            ResidueState rs = rm.getResidueState();
            if (rs == null) continue;
            set.add(rs);
        }
        TreeMap map = new TreeMap();
        for (String residueId : rMap.keySet()) {
            Set set1 = (Set)rMap.get(residueId);
            TreeSet<ResidueState> set2 = new TreeSet<ResidueState>();
            ResidueState rsForEmpty = null;
            int count = 0;
            for (ResidueState rs : set1) {
                if (rs.isEmptyResidue()) {
                    rsForEmpty = rs;
                    continue;
                }
                if (!set.contains(rs)) {
                    set2.add(rs);
                }
                ++count;
            }
            if (count == 0 && rsForEmpty != null && !set.contains(rsForEmpty)) {
                set2.add(rsForEmpty);
            }
            if (set2.isEmpty()) continue;
            map.put(residueId, set2);
        }
        return map;
    }

    private List createRestOfEsList(Map esmMap, List esList) {
        TreeSet<ProteinActivity> set = new TreeSet<ProteinActivity>();
        for (Object key : esmMap.keySet()) {
            EffectSiteModel esm = (EffectSiteModel)esmMap.get(key);
            ProteinActivity pa = esm.getProteinActivity();
            if (pa == null) continue;
            set.add(pa);
        }
        LinkedList<ProteinActivity> list = new LinkedList<ProteinActivity>();
        for (ProteinActivity pa : esList) {
            if (set.contains(pa)) continue;
            list.add(pa);
        }
        return list;
    }

    private boolean createRestOfDtm(Map dtmMap, List dList) {
        return dtmMap.isEmpty() && !dList.isEmpty();
    }

    private List createRestOfBsList(Map bsmMap, List bsList) {
        TreeSet<String> set = new TreeSet<String>();
        for (Object key : bsmMap.keySet()) {
            BindingSiteModel bsm = (BindingSiteModel)bsmMap.get(key);
            ProteinState ps = bsm.getProteinState();
            if (ps == null) continue;
            String id = ps.getProtein().getId();
            set.add(id);
        }
        LinkedList<ProteinState> list = new LinkedList<ProteinState>();
        for (ProteinState ps : bsList) {
            String id = ps.getProtein().getId();
            if (set.contains(id)) continue;
            list.add(ps);
        }
        return list;
    }

    private void createPredefinedInternalLinksWithBDInfo(Annotation.BlockDiagramInfo bdinfo, BlockModel bm, HaloModel hm, Map bsmMap, Map dtmMap, Map esmMap, Map rmMap, Map omMap) {
        boolean loop;
        TreeMap<String, LinkModelImpl> ilmMap = new TreeMap<String, LinkModelImpl>();
        do {
            loop = false;
            for (Annotation.InternalLinkInfo ili : bdinfo.getInternalLinkInfoList()) {
                int type = ili.getType();
                String id = ili.getId();
                if (ilmMap.get(id) != null) continue;
                InternalLinkPlacer placer = new InternalLinkPlacer(this.canvasVC, type);
                this.canvasVC.setPlacer(placer);
                Annotation.LinkPointInfo s = ili.getStartPoint();
                Annotation.LinkPointInfo e = ili.getEndPoint();
                InternalOperationalModel start = this.getTargetInstance(s.getIdRef(), s.getTarget(), bsmMap, dtmMap, esmMap, rmMap, omMap, ilmMap);
                InternalOperationalModel end = this.getTargetInstance(e.getIdRef(), e.getTarget(), bsmMap, dtmMap, esmMap, rmMap, omMap, ilmMap);
                if (start == null || end == null) {
                    loop = true;
                    continue;
                }
                double sdx = s.getOffsetX();
                double sdy = s.getOffsetY();
                double edx = e.getOffsetX();
                double edy = e.getOffsetY();
                LinkModelImpl linkm = placer.createLinkWhenLoaded(start, end, sdx, sdy, edx, edy);
                ilmMap.put(id, linkm);
            }
        } while (loop);
    }

    private InternalOperationalModel getTargetInstance(String idref, Class clazz, Map bsmMap, Map dtmMap, Map esmMap, Map rmMap, Map omMap, Map ilmMap) {
        if (clazz.equals(BindingSiteModel.class)) {
            return (InternalOperationalModel)bsmMap.get(idref);
        }
        if (clazz.equals(DegradeTriangleModel.class)) {
            return (InternalOperationalModel)dtmMap.get(idref);
        }
        if (clazz.equals(EffectSiteModel.class)) {
            return (InternalOperationalModel)esmMap.get(idref);
        }
        if (clazz.equals(ResidueModel.class)) {
            return (InternalOperationalModel)rmMap.get(idref);
        }
        if (clazz.equals(OperatorModel.class)) {
            return (InternalOperationalModel)omMap.get(idref);
        }
        if (clazz.equals(InternalLinkModel.class)) {
            return (InternalOperationalModel)ilmMap.get(idref);
        }
        throw new IllegalArgumentException("invalid class=" + clazz.getName());
    }

    private Map createPredefinedOperatorsWithBDInfo(Annotation.BlockDiagramInfo bdinfo, BlockModel bm, HaloModel hm) {
        TreeMap<String, OperatorModel> map = new TreeMap<String, OperatorModel>();
        int cx = bm.getCenterX();
        int cy = bm.getCenterY();
        for (Annotation.OperatorInfo oi : bdinfo.getOperatorInfoList()) {
            int type = oi.getType();
            String id = oi.getId();
            OperatorPlacer placer = new OperatorPlacer(this.canvasVC, type);
            this.canvasVC.setPlacer(placer);
            double offsetX = oi.getOffsetX();
            double offsetY = oi.getOffsetY();
            int x = (int)((double)cx + offsetX);
            int y = (int)((double)cy + offsetY);
            String value = oi.getValue();
            double valueOffsetX = oi.getValueOffsetX();
            double valueOffsetY = oi.getValueOffsetY();
            int subType = oi.getSubType();
            OperatorModel om = placer.createOperatorModel(x, y);
            map.put(id, om);
            ShapeModelImpl shape = placer.createShape(om);
            placer.anchorToTheTarget(shape, true, offsetX, offsetY, value, valueOffsetX, valueOffsetY, subType);
        }
        return map;
    }

    private Map createPredefinedEffectSitesWithBDInfo(Annotation.BlockDiagramInfo bdinfo, BlockModel bm, HaloModel hm, List esList) {
        TreeMap<String, EffectSiteModel> map = new TreeMap<String, EffectSiteModel>();
        EffectSitePlacer placer = new EffectSitePlacer(this.canvasVC);
        this.canvasVC.setPlacer(placer);
        int y1 = bm.getY() + bm.getHeight() + EffectSiteModel.getDefaultHeightStatic() / 2;
        int y2 = hm.getY() + hm.getHeight();
        double cy = (double)(y1 + y2) * 0.5;
        for (Annotation.EffectSiteInfo esi : bdinfo.getEffectSiteInfoList()) {
            double offsetX = esi.getOffsetX();
            double offsetY = esi.getOffsetY();
            String name = esi.getName();
            double nameOffsetX = esi.getNameOffsetX();
            double nameOffsetY = esi.getNameOffsetY();
            String id = esi.getId();
            int x = (int)((double)bm.getCenterX() + offsetX);
            int y = (int)(cy + offsetY);
            ProteinActivity pa = this.getProteinActivityBySpeciesIdAndReactionId(esList, esi.getSpeciesId(), esi.getReactionId());
            EffectSiteInvisibleLinkModel linkm = (EffectSiteInvisibleLinkModel)placer.createLink(x, y, pa, true, offsetX, offsetY, name, nameOffsetX, nameOffsetY);
            EffectSiteModel esm = (EffectSiteModel)linkm.getShapeOf(0);
            map.put(id, esm);
        }
        return map;
    }

    private ProteinActivity getProteinActivityBySpeciesIdAndReactionId(List esList, String speciesId, String reactionId) {
        for (ProteinActivity pa : esList) {
            if (!pa.getReactionId().equals(reactionId) || !pa.getSpeciesId().equals(speciesId)) continue;
            return pa;
        }
        return null;
    }

    private Map createPredefinedDegradedShapeWithBDInfo(Annotation.BlockDiagramInfo bdinfo, BlockModel bm, HaloModel hm, List dList) {
        TreeMap<String, DegradeTriangleModel> map = new TreeMap<String, DegradeTriangleModel>();
        if (!bdinfo.hasDegraded()) {
            return map;
        }
        DegradePlacer placer = new DegradePlacer(this.canvasVC, null);
        this.canvasVC.setPlacer(placer);
        double dtmOffsetY = bdinfo.getDegradedOffsetY();
        int dsmWidth = bdinfo.getDegradedShapeWidth();
        int dsmHeight = bdinfo.getDegradedShapeHeight();
        double dsmOffsetX = bdinfo.getDegradedShapeOffsetX();
        double dsmOffsetY = bdinfo.getDegradedShapeOffsetY();
        int x = hm.getX() + hm.getWidth() - DegradeTriangleModel.getDefaultWidthStatic() / 2;
        int y = (int)((double)bm.getCenterY() + dtmOffsetY - (double)(DegradeTriangleModel.getDefaultHeightStatic() / 2));
        DegradeTriangleModel dtm = placer.createDegradeTriangleModel(x, y);
        ShapeModelImpl shape = placer.createShape(dtm);
        placer.anchorToTheTarget(shape, dList, true, dtmOffsetY, dsmWidth, dsmHeight, dsmOffsetX, dsmOffsetY);
        map.put("0", dtm);
        return map;
    }

    private Map createPredefinedBindingSitesWithBDInfo(Annotation.BlockDiagramInfo bdinfo, BlockModel bm, HaloModel hm, List bsList) {
        TreeMap<String, BindingSiteModel> map = new TreeMap<String, BindingSiteModel>();
        BindingSitePlacer placer = new BindingSitePlacer(this.canvasVC);
        this.canvasVC.setPlacer(placer);
        int x = bm.getX() - BindingSiteModel.getDefaultWidthStatic() / 2;
        for (Annotation.BindingSiteInfo bsi : bdinfo.getBindingSiteInfoList()) {
            String id = bsi.getId();
            String name = bsi.getName();
            double nameOffsetX = bsi.getNameOffsetX();
            double nameOffsetY = bsi.getNameOffsetY();
            double offsetY = bsi.getOffsetY();
            String proteinId = bsi.getProteinId();
            int y = (int)((double)bm.getCenterY() + offsetY - (double)(BindingSiteModel.getDefaultHeightStatic() / 2));
            ProteinState ps = proteinId == null ? null : this.getProteinStateForBSByProteinId(bsList, proteinId);
            BindingSiteModel bsm = placer.createBindingSiteModel(x, y);
            map.put(id, bsm);
            ShapeModelImpl shape = placer.createShape(bsm);
            placer.anchorToTheTarget(shape, ps, true, offsetY, name, nameOffsetX, nameOffsetY);
        }
        return map;
    }

    private ProteinState getProteinStateForBSByProteinId(List bsList, String proteinId) {
        for (ProteinState ps : bsList) {
            if (!proteinId.equals(ps.getProtein().getId())) continue;
            return ps;
        }
        return null;
    }

    private Map[] createPredefinedResiduesWithBDInfo(Annotation.BlockDiagramInfo bdinfo, BlockModel bm, HaloModel hm, int nr, Map rMap) {
        Map[] map2 = new Map[]{new TreeMap(), new TreeMap()};
        for (Annotation.ResidueInfo ri : bdinfo.getResidueInfoList()) {
            String id = ri.getId();
            int type = ri.getType();
            String name = ri.getName();
            double nameOffsetX = ri.getNameOffsetX();
            double nameOffsetY = ri.getNameOffsetY();
            double offsetX = ri.getOffsetX();
            String residueId = ri.getResidueId();
            Set set = residueId == null ? null : (Set)rMap.get(residueId);
            ResiduePlacer placer = new ResiduePlacer(this.canvasVC, type);
            this.canvasVC.setPlacer(placer);
            int x = (int)((double)bm.getCenterX() + offsetX - (double)(ResidueModel.getDefaultWidthStatic() / 2));
            int y = bm.getY() - ResidueModel.getDefaultHeightStatic() / 2;
            ResidueModel rm = placer.createResidueModel(x, y, type);
            map2[0].put(id, rm);
            ShapeModelImpl shape = placer.createShape(rm);
            ResidueState rs = this.getResidueStateByType(set, type);
            placer.anchorToTheTarget(shape, rs, true, offsetX, name, nameOffsetX, nameOffsetY);
            String key = CanvasVC.getStringForKey(rs.getResidueId(), rs.getModificationState());
            map2[1].put(key, rm);
        }
        return map2;
    }

    private Map[] createPredefinedExtNamesForResidueWithBDInfo(Annotation.BlockDiagramInfo bdinfo, BlockModel bm, HaloModel hm, Map residueModelMapByIdOfXML, Map mtvMapByString) {
        boolean loaded = true;
        Map[] map2 = new Map[]{new TreeMap(), new TreeMap()};
        LinkVCImpl hnwevc = ((CanvasVC)this.canvasVC).getHaloNorthWestvc();
        LinkModelImpl hnwem = (LinkModelImpl)hnwevc.getModel();
        int cy = hnwem.getCenterY();
        for (Annotation.ExternalNameInfo eni : bdinfo.getExternalNameInfoList()) {
            String name = eni.getName();
            String getProteinForMtv = eni.getProteinForMtv();
            double nameOffsetX = eni.getNameOffsetX();
            double nameOffsetY = eni.getNameOffsetY();
            double offsetY = eni.getOffsetY();
            String proteinForMtv = eni.getProteinForMtv();
            ModifierTableValue mtv = proteinForMtv != null ? mtvMapByString.get(proteinForMtv) : null;
            int count = 0;
            ExternalNameForResidueModel namem = null;
            for (Annotation.ExternalConnectionInfo eci : eni.getConnectionList()) {
                int type = eci.getType();
                ExternalLinkPlacer placer = new ExternalLinkPlacer(this.canvasVC, type);
                this.canvasVC.setPlacer(placer);
                String idref = eci.getIdref();
                ResidueModel rm = (ResidueModel)residueModelMapByIdOfXML.get(idref);
                ResidueTailModel tailm = rm.getTailModel();
                int y = (int)((double)cy + offsetY);
                boolean predefinedOfNamem = mtv != null;
                boolean predefined1 = eci.isPredefined();
                ExternalLinkModel linkm = (ExternalLinkModel)placer.createLink(namem, predefinedOfNamem, tailm, y, predefined1, loaded, offsetY, name, nameOffsetX, nameOffsetY);
                namem = linkm.getNameModel();
                if (predefinedOfNamem) {
                    map2[0].put(namem.getName(), namem);
                    namem.setModifierTableValue(mtv);
                }
                if (predefined1) {
                    String key = CanvasVC.getStringForKey(getProteinForMtv, type, rm);
                    map2[1].put(key, linkm);
                }
                ++count;
            }
        }
        return map2;
    }

    private ResidueState getResidueStateByType(Set set, int type) {
        if (set != null) {
            for (ResidueState rs : set) {
                if (rs.getResidueType() != type) continue;
                return rs;
            }
        }
        return null;
    }

    private Map createPredefinedResidues(BlockModel bm, HaloModel hm, int nr, Map rMap, Map rmMap, Map rmMap2) {
        TreeMap<String, ResidueModel> map;
        TreeMap<String, ResidueModel> treeMap = map = rmMap2 != null ? new TreeMap<String, ResidueModel>(rmMap2) : new TreeMap();
        if (nr == 0) {
            return map;
        }
        int x1 = bm.getX() - ResidueModel.getDefaultWidthStatic() / 2;
        int x2 = x1 + bm.getWidth();
        if (rmMap != null) {
            for (Object key : rmMap.keySet()) {
                ResidueModel rm = (ResidueModel)rmMap.get(key);
                int xtemp = rm.getX();
                if (xtemp <= x1) continue;
                x1 = xtemp;
            }
            if (x1 > x2) {
                x1 = x2;
            }
        }
        double dx = (double)(x2 - x1) / (double)(nr + 1);
        int y = bm.getY() - ResidueModel.getDefaultHeightStatic() / 2;
        int ir = 0;
        for (String residueId : rMap.keySet()) {
            boolean needToCreateEmptyResidue;
            Set set = (Set)rMap.get(residueId);
            if (rmMap == null) {
                needToCreateEmptyResidue = false;
                int count = 0;
                boolean findEmpty = false;
                for (ResidueState rs : set) {
                    if (rs.isEmptyResidue()) {
                        findEmpty = true;
                        continue;
                    }
                    ++count;
                }
                if (count == 0 && findEmpty) {
                    needToCreateEmptyResidue = true;
                }
            } else {
                needToCreateEmptyResidue = true;
            }
            for (ResidueState rs : set) {
                if (rs.isEmptyResidue() && !needToCreateEmptyResidue) continue;
                int type = rs.getResidueType();
                ResiduePlacer placer = new ResiduePlacer(this.canvasVC, type);
                this.canvasVC.setPlacer(placer);
                int x = x1 + (int)Math.floor((double)(++ir) * dx + 0.5);
                ResidueModel rm = placer.createResidueModel(x, y, type);
                ShapeModelImpl shape = placer.createShape(rm);
                placer.anchorToTheTarget(shape, rs, false, 0.0, null, 0.0, 0.0);
                String key = CanvasVC.getStringForKey(rm);
                map.put(key, rm);
            }
        }
        return map;
    }

    private static String getStringForKey(String proteinIds, int type, ResidueModel rm) {
        return String.valueOf(proteinIds) + ":" + type + ":" + CanvasVC.getStringForKey(rm);
    }

    private static String getStringForKey(String proteinIds, int type, String residueId, String modificationState) {
        return String.valueOf(proteinIds) + ":" + type + ":" + CanvasVC.getStringForKey(residueId, modificationState);
    }

    private static String getStringForKey(ResidueModel rm) {
        return CanvasVC.getStringForKey(rm.getResidueState().getResidueId(), rm.getResidueState().getModificationState());
    }

    private static String getStringForKey(String residueId, String modificationState) {
        return String.valueOf(residueId) + ":" + modificationState;
    }

    private void createPredefinedEffectSites(BlockModel bm, HaloModel hm, List esList, Map esmMap) {
        if (esList.isEmpty()) {
            return;
        }
        EffectSitePlacer placer = new EffectSitePlacer(this.canvasVC);
        this.canvasVC.setPlacer(placer);
        int x1 = bm.getX();
        int x2 = x1 + bm.getWidth();
        int y1 = bm.getY() + bm.getHeight() + EffectSiteModel.getDefaultHeightStatic() / 2;
        int y2 = hm.getY() + hm.getHeight();
        if (esmMap != null) {
            for (Object key : esmMap.keySet()) {
                EffectSiteModel esm = (EffectSiteModel)esmMap.get(key);
                int xtemp = esm.getX();
                int ytemp = esm.getCornerm().getY();
                if (xtemp < x2) {
                    x2 = xtemp;
                }
                if (ytemp <= y1) continue;
                y1 = ytemp;
            }
            if (y1 > y2) {
                y1 = y2;
            }
            if (x2 < x1) {
                x2 = x1;
            }
        }
        double dx = (double)(x2 - x1) / (double)(esList.size() + 1);
        double dy = (double)(y2 - y1) / (double)(esList.size() + 1);
        int i = 0;
        for (ProteinActivity pa : esList) {
            int x = x1 + (int)Math.floor((double)(++i) * dx + 0.5);
            int y = y2 - (int)Math.floor((double)i * dy + 0.5);
            placer.createLink(x, y, pa, false, 0.0, 0.0, null, 0.0, 0.0);
        }
    }

    private void createPredefinedBindingSites(BlockModel bm, HaloModel hm, List bsList, Map bsmMap) {
        if (bsList.isEmpty()) {
            return;
        }
        BindingSitePlacer placer = new BindingSitePlacer(this.canvasVC);
        this.canvasVC.setPlacer(placer);
        int y1 = bm.getY() - BindingSiteModel.getDefaultHeightStatic() / 2;
        int y2 = y1 + bm.getHeight();
        if (bsmMap != null) {
            for (Object key : bsmMap.keySet()) {
                BindingSiteModel bsm = (BindingSiteModel)bsmMap.get(key);
                int ytemp = bsm.getY();
                if (ytemp <= y1) continue;
                y1 = ytemp;
            }
            if (y1 > y2) {
                y1 = y2;
            }
        }
        double dy = (double)(y2 - y1) / (double)(bsList.size() + 1);
        int x = bm.getX() - BindingSiteModel.getDefaultWidthStatic() / 2;
        int i = 0;
        for (ProteinState ps : bsList) {
            int y = y1 + (int)Math.floor((double)(++i) * dy + 0.5);
            BindingSiteModel bsm = placer.createBindingSiteModel(x, y);
            ShapeModelImpl shape = placer.createShape(bsm);
            placer.anchorToTheTarget(shape, ps, false, 0.0, null, 0.0, 0.0);
        }
    }

    private void createPredefinedDegradedShape(BlockModel bm, HaloModel hm, List dList) {
        if (dList.isEmpty()) {
            return;
        }
        DegradePlacer placer = new DegradePlacer(this.canvasVC, null);
        this.canvasVC.setPlacer(placer);
        int x = hm.getX() + hm.getWidth() - DegradeTriangleModel.getDefaultWidthStatic() / 2;
        int y = bm.getCenterY() - DegradeTriangleModel.getDefaultHeightStatic() / 2;
        DegradeTriangleModel dtm = placer.createDegradeTriangleModel(x, y);
        ShapeModelImpl shape = placer.createShape(dtm);
        placer.anchorToTheTarget(shape, dList, false, 0.0, 0, 0, 0.0, 0.0);
    }

    private void createHaloNorthWestLink(BlockModel bm, HaloModel hm, EmptyAnchoredShapeModelImpl p1) {
        int marginY = 10;
        int x = hm.getX();
        int y = bm.getY() - marginY;
        EmptyAnchoredShapeModelImpl p2 = new EmptyAnchoredShapeModelImpl();
        p2.initialize((CanvasModelImpl)this.getModel(), x, y);
        ((CanvasModelImpl)this.getModel()).addLast(p2);
        boolean dx = false;
        int dy = 0;
        SimpleAnchorImpl xAnchor = new SimpleAnchorImpl(4, 10, (double)dx, dy);
        xAnchor.initialize(hm);
        dx = false;
        dy = -marginY;
        SimpleAnchorImpl yAnchor = new SimpleAnchorImpl(1, 10, (double)dx, dy);
        yAnchor.initialize(bm);
        XYAnchorImpl xyAnchor = new XYAnchorImpl(xAnchor, yAnchor);
        p2.addLastAnchor(xyAnchor);
        EmptyLinkModelImpl edgem = new EmptyLinkModelImpl();
        edgem.initialize((CanvasModelImpl)this.getModel(), p1.getCenterX(), p1.getCenterY(), 0, p2.getCenterX() - p1.getCenterX());
        edgem.addLastShape(p1, new SimpleAnchorImpl(0, 11));
        edgem.addLastShape(p2, new SimpleAnchorImpl(0, 11));
        ((CanvasModelImpl)this.getModel()).addLast(edgem);
        this.haloNorthWestvc = (LinkVCImpl)this.getFromShapeVCByModel(edgem);
    }

    private void createBlockName(Annotation.BlockDiagramInfo bdinfo, BlockModel bm) {
        BlockNameModel namem = new BlockNameModel();
        int x = bm.getX() + bm.getWidth();
        int y = bm.getY();
        namem.initialize((CanvasModelImpl)this.getModel(), x, y);
        String str = ((CanvasModel)this.getModel()).getBlockName();
        ((CanvasModelImpl)this.getModel()).addLast(namem);
        namem.setName(str);
        if (bdinfo.isLoaded()) {
            double dx = bdinfo.getBlockNameOffsetX();
            double dy = bdinfo.getBlockNameOffsetY();
            SimpleAnchorImpl a = new SimpleAnchorImpl(6, 10, dx, dy);
            namem.addLastShape(bm, a);
            namem.setLocationByShape(bm);
        } else {
            int w = namem.getWidth();
            int h = namem.getHeight();
            int dx = x - namem.getX() - w;
            int dy = -h;
            namem.move(dx, dy);
            int cx = namem.getCenterX();
            int cy = namem.getCenterY();
            SimpleAnchorImpl a = new SimpleAnchorImpl(6, 10, cx - x, cy - y);
            namem.addLastShape(bm, a);
        }
        bm.setBlockNameModel(namem);
    }

    private void createHaloWestEdge(HaloModel hm, EmptyAnchoredShapeModelImpl p1) {
        int x = hm.getX();
        int y = hm.getY();
        int h = hm.getHeight();
        EmptyAnchoredShapeModelImpl p2 = new EmptyAnchoredShapeModelImpl();
        p2.initialize((CanvasModelImpl)this.getModel(), x, y + h);
        ((CanvasModelImpl)this.getModel()).addLast(p2);
        p2.addLastShape(hm, new SimpleAnchorImpl(7));
        HaloWestEdgeModel edgem = new HaloWestEdgeModel();
        edgem.initialize((CanvasModelImpl)this.getModel(), x, y, 0, h);
        edgem.addLastShape(p1, new SimpleAnchorImpl(0, 11));
        edgem.addLastShape(p2, new SimpleAnchorImpl(0, 11));
        ((CanvasModelImpl)this.getModel()).addLast(edgem);
        this.haloWestvc = (HaloWestEdgeVC)this.getFromShapeVCByModel(edgem);
    }

    private void createHaloEastEdge(HaloModel hm) {
        int x = hm.getX() + hm.getWidth();
        int y = hm.getY();
        int h = hm.getHeight();
        EmptyAnchoredShapeModelImpl p1 = new EmptyAnchoredShapeModelImpl();
        p1.initialize((CanvasModelImpl)this.getModel(), x, y);
        ((CanvasModelImpl)this.getModel()).addLast(p1);
        EmptyAnchoredShapeModelImpl p2 = new EmptyAnchoredShapeModelImpl();
        p2.initialize((CanvasModelImpl)this.getModel(), x, y + h);
        ((CanvasModelImpl)this.getModel()).addLast(p2);
        p1.addLastShape(hm, new SimpleAnchorImpl(6));
        p2.addLastShape(hm, new SimpleAnchorImpl(8));
        HaloEastEdgeModel edgem = new HaloEastEdgeModel();
        edgem.initialize((CanvasModelImpl)this.getModel(), x, y, 0, h);
        edgem.addLastShape(p1, new SimpleAnchorImpl(0, 11));
        edgem.addLastShape(p2, new SimpleAnchorImpl(0, 11));
        ((CanvasModelImpl)this.getModel()).addLast(edgem);
        this.haloEastvc = (HaloEastEdgeVC)this.getFromShapeVCByModel(edgem);
    }

    private void createBlockSouthEdge(BlockModel bm) {
        int x = bm.getX();
        int y = bm.getY() + bm.getHeight();
        int w = bm.getWidth();
        EmptyAnchoredShapeModelImpl p1 = new EmptyAnchoredShapeModelImpl();
        p1.initialize((CanvasModelImpl)this.getModel(), x, y);
        ((CanvasModelImpl)this.getModel()).addLast(p1);
        EmptyAnchoredShapeModelImpl p2 = new EmptyAnchoredShapeModelImpl();
        p2.initialize((CanvasModelImpl)this.getModel(), x + w, y);
        ((CanvasModelImpl)this.getModel()).addLast(p2);
        p1.addLastShape(bm, new SimpleAnchorImpl(7));
        p2.addLastShape(bm, new SimpleAnchorImpl(8));
        BlockSouthEdgeModel edgem = new BlockSouthEdgeModel();
        edgem.initialize((CanvasModelImpl)this.getModel(), x, y, w, 0);
        edgem.addLastShape(p1, new SimpleAnchorImpl(0, 11));
        edgem.addLastShape(p2, new SimpleAnchorImpl(0, 11));
        ((CanvasModelImpl)this.getModel()).addLast(edgem);
        this.blockSouthvc = (BlockSouthEdgeVC)this.getFromShapeVCByModel(edgem);
    }

    public BlockVC getBlockvc() {
        return this.blockvc;
    }

    public HaloVC getHalovc() {
        return this.halovc;
    }

    public HaloWestEdgeVC getHaloWestEdgevc() {
        return this.haloWestvc;
    }

    public HaloEastEdgeVC getHaloEastEdgevc() {
        return this.haloEastvc;
    }

    public BlockSouthEdgeVC getBlockSouthEdgevc() {
        return this.blockSouthvc;
    }

    public LinkVCImpl getHaloNorthWestvc() {
        return this.haloNorthWestvc;
    }

    private void setInitialPreferredSize(Annotation.BlockDiagramInfo bdinfo) {
        if (bdinfo != null) {
            this.initialPreferredWidth = bdinfo.getCanvasWidth();
            this.initialPreferredHeight = bdinfo.getCanvasHeight();
        } else {
            this.initialPreferredWidth = 300;
            this.initialPreferredHeight = 200;
        }
    }

    public Dimension getInitialPreferredSize() {
        return new Dimension(this.initialPreferredWidth, this.initialPreferredHeight);
    }

    @Override
    public void update(Observable observable, Object aspect) {
        switch (((ModelImpl.AspectWrapper)aspect).getAspectInt()) {
            case 101: {
                CanvasModel cm = (CanvasModel)this.getModel();
                this.updateButton.setEnabled(cm.isEdited());
                break;
            }
            default: {
                super.update(observable, aspect);
            }
        }
    }
}

