/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import jp.co.fujiric.star.gui.gef.swing.AnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.AnchoredShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.CanvasVCImpl;
import jp.co.fujiric.star.gui.gef.swing.EmptyAnchoredShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.EmptyAnchoredShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapePlacerByClick;
import jp.co.fujiric.star.gui.gef.swing.ShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.SimpleAnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.SwingVCImpl;
import jp.co.fujiric.star.gui.gef.swing.XYAnchorImpl;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteLinkVC;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteVC;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteWithLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteWithLinkVC;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockVC;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasModel;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasVC;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalNameForBidingSiteModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalNameForBidingSiteVC;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloModel;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloVC;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloWestEdgeModel;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloWestEdgeVC;
import jp.sbi.celldesigner.blockDiagram.diagram.RestrictedInShapeMover;
import jp.sbi.celldesigner.blockDiagram.table.ProteinState;

public class BindingSitePlacer
extends ShapePlacerByClick {
    public BindingSitePlacer(CanvasVCImpl canvasvc) {
        super(canvasvc);
    }

    @Override
    protected boolean isCreateShape(MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        BlockVC blockvc = ((CanvasVC)this.canvasvc).getBlockvc();
        return blockvc.isOnTheEdge(canvasx, canvasy, 4, 6, 6);
    }

    @Override
    protected boolean isCreateShapeWithAnchoring(MouseEvent e, SwingVCImpl sourcevc, int canvasx, int canvasy) {
        return true;
    }

    @Override
    protected ShapeModelImpl anchorToTheTarget(ShapeModelImpl shape, SwingVCImpl sourcevc) {
        return this.anchorToTheTarget(shape, null, false, 0.0, null, 0.0, 0.0);
    }

    protected ShapeModelImpl anchorToTheTarget(ShapeModelImpl shape, ProteinState ps, boolean loaded, double offsetY, String name, double nameOffsetX, double nameOffsetY) {
        BlockVC blockvc = ((CanvasVC)this.canvasvc).getBlockvc();
        BlockModel blockm = (BlockModel)blockvc.getModel();
        HaloVC halovc = ((CanvasVC)this.canvasvc).getHalovc();
        HaloModel halom = (HaloModel)halovc.getModel();
        HaloWestEdgeVC hwevc = ((CanvasVC)this.canvasvc).getHaloWestEdgevc();
        HaloWestEdgeModel hwem = (HaloWestEdgeModel)hwevc.getModel();
        if (!(shape instanceof BindingSiteModel)) {
            return null;
        }
        BindingSiteModel bsm = (BindingSiteModel)shape;
        if (ps != null) {
            bsm.setProteinState(ps);
            CanvasModel cm = (CanvasModel)this.canvasvc.getModel();
            bsm.setCanvasModel(cm);
        }
        EmptyAnchoredShapeModelImpl tailbasem = new EmptyAnchoredShapeModelImpl();
        tailbasem.initialize(this.canvasm);
        this.canvasm.addLast(tailbasem);
        int cx = bsm.getCenterX();
        int cy = bsm.getCenterY();
        int y1 = BindingSitePlacer.calcTheNearestYCoordOnTheBlock(((CanvasVC)this.canvasvc).getBlockvc(), cy);
        if (cy != y1 || cx != blockm.getX()) {
            int dx = blockm.getX() - cx;
            int dy = y1 - cy;
            bsm.move(dx, dy);
            cy = y1;
            cx = blockm.getX();
        }
        int targetCy = blockm.getCenterY();
        double dx = 0.0;
        double dy = loaded ? offsetY : (double)(cy - targetCy);
        SimpleAnchorImpl anchor = new SimpleAnchorImpl(4, 10, dx, dy);
        ((AnchorImpl)anchor).initialize(blockm);
        bsm.addLastAnchor(anchor);
        if (loaded) {
            bsm.setLocationByShape(blockm);
            cy = bsm.getCenterY();
        }
        boolean dx2 = false;
        int dy2 = 0;
        SimpleAnchorImpl yAnchor = new SimpleAnchorImpl(4, 10, (double)dx2, dy2);
        yAnchor.initialize(bsm);
        dx2 = false;
        dy2 = cy - halom.getCenterY();
        SimpleAnchorImpl xAnchor = new SimpleAnchorImpl(4, 10, (double)dx2, dy2);
        xAnchor.initialize(halom);
        XYAnchorImpl xyAnchor = new XYAnchorImpl(xAnchor, yAnchor);
        tailbasem.addLastAnchor(xyAnchor);
        ExternalNameForBidingSiteModel namem = new ExternalNameForBidingSiteModel(ps != null, loaded);
        int x = hwem.getX();
        int y = y1;
        int w = 50;
        int h = 14;
        namem.initialize(this.canvasm, x -= w, y -= h / 2, w, h);
        this.canvasm.addLast(namem);
        if (name != null) {
            namem.setName(name);
        } else if (ps != null) {
            namem.setName(ps.getProtein().getName());
        } else {
            String defaultName = "name";
            namem.setDefaultName(defaultName);
        }
        double dx3 = name != null ? nameOffsetX : (double)(namem.getCenterX() - tailbasem.getCenterX());
        double dy3 = name != null ? nameOffsetY : (double)(namem.getCenterY() - tailbasem.getCenterY());
        SimpleAnchorImpl a = new SimpleAnchorImpl(0, 10, dx3, dy3);
        namem.addLastShape(tailbasem, a);
        if (name != null) {
            namem.setLocationByShape(tailbasem);
        }
        BindingSiteLinkModel tailm = new BindingSiteLinkModel();
        tailm.setHeadless(true);
        y = bsm.getCenterY();
        int x2 = halom.getX();
        h = 0;
        int w2 = blockm.getX() - x2 - bsm.getWidth() / 2;
        tailm.initialize(this.canvasm, x2, y, w2, h, false);
        tailm.addLastShape(tailbasem, new SimpleAnchorImpl(0, 11));
        tailm.addLastShape(bsm, new SimpleAnchorImpl(4, 11));
        this.canvasm.addLast(tailm);
        BindingSiteWithLinkModel bswlm = new BindingSiteWithLinkModel();
        bswlm.initialize(this.canvasm);
        LinkedList<AnchoredShapeModelImpl> shapes = new LinkedList<AnchoredShapeModelImpl>();
        shapes.addLast(bsm);
        shapes.addLast(tailm);
        bswlm.add(shapes);
        namem.addRemoveShape(bswlm);
        namem.addRemoveShape(tailbasem);
        bsm.setRelatedModels(tailm, namem, bswlm);
        if (ps != null) {
            bsm.setRemovable(false);
        }
        return blockm;
    }

    @Override
    public ShapeModelImpl createShape() {
        return this.createShape(null);
    }

    protected ShapeModelImpl createShape(BindingSiteModel bsm) {
        BlockVC blockvc = ((CanvasVC)this.canvasvc).getBlockvc();
        BlockModel blockm = (BlockModel)blockvc.getModel();
        if (bsm == null) {
            bsm = (BindingSiteModel)super.createShape();
        }
        ShapeVCImpl vc = this.canvasvc.getFromShapeVCByModel(bsm);
        vc.setMover(new RestrictedInShapeMover(blockm, 2));
        return bsm;
    }

    protected static int calcTheNearestYCoordOnTheBlock(ShapeVCImpl blockvc, int y) {
        BlockModel blockm = (BlockModel)blockvc.getModel();
        int yb = blockm.getY();
        int hb = blockm.getHeight();
        if (y < yb) {
            y = yb;
        } else if (y > yb + hb - 1) {
            y = yb + hb - 1;
        }
        return y;
    }

    @Override
    public String getMainShapeModelClassName() {
        return BindingSiteModel.class.getName();
    }

    @Override
    public Map getShapeMVCClassNamesMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.getMainShapeModelClassName(), BindingSiteVC.class.getName());
        map.put(BindingSiteWithLinkModel.class.getName(), BindingSiteWithLinkVC.class.getName());
        map.put(EmptyAnchoredShapeModelImpl.class.getName(), EmptyAnchoredShapeVCImpl.class.getName());
        map.put(BindingSiteLinkModel.class.getName(), BindingSiteLinkVC.class.getName());
        map.put(ExternalNameForBidingSiteModel.class.getName(), ExternalNameForBidingSiteVC.class.getName());
        return map;
    }

    public BindingSiteModel createBindingSiteModel(int x, int y) {
        BindingSiteModel bsm = new BindingSiteModel();
        bsm.initialize(this.canvasm, x, y);
        this.canvasm.addLast(bsm);
        return bsm;
    }
}

