/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.co.fujiric.star.gui.gef.swing.NameModelImpl;
import jp.co.fujiric.star.gui.gef.swing.RectangleModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteWithLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalNameForBidingSiteModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperation;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperationalException;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperationalModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperatorTraceStack;
import jp.sbi.celldesigner.blockDiagram.table.ProteinInstanceState;
import jp.sbi.celldesigner.blockDiagram.table.ProteinState;
import jp.sbi.celldesigner.blockDiagram.table.TableColumnValue;

public class BindingSiteModel
extends RectangleModel
implements InternalOperationalModel {
    private BindingSiteLinkModel tailm;
    private ExternalNameForBidingSiteModel namem;
    private BindingSiteWithLinkModel groupm;
    private ProteinState proteinState;
    private CanvasModel canvasModel;
    private Set outputLinkSet = new HashSet();
    private Set inputLinkSet = new HashSet();
    private static final int DEFAULT_WIDTH = 16;
    private static final int DEFAULT_HEIGHT = 16;

    @Override
    public void addOutputLink(InternalLinkModel linkm) {
        this.outputLinkSet.add(linkm);
    }

    @Override
    public void removeOutputLink(InternalLinkModel linkm) {
        this.outputLinkSet.remove(linkm);
    }

    @Override
    public void addInputLink(InternalLinkModel linkm) {
        this.inputLinkSet.add(linkm);
    }

    @Override
    public void removeInputLink(InternalLinkModel linkm) {
        this.inputLinkSet.remove(linkm);
    }

    @Override
    public Set getInputLinkSet() {
        return Collections.unmodifiableSet(this.inputLinkSet);
    }

    @Override
    public Set getOutputLinkSet() {
        return Collections.unmodifiableSet(this.outputLinkSet);
    }

    @Override
    protected int getDefaultHeight() {
        return BindingSiteModel.getDefaultHeightStatic();
    }

    @Override
    protected int getDefaultWidth() {
        return BindingSiteModel.getDefaultWidthStatic();
    }

    protected static int getDefaultWidthStatic() {
        return 16;
    }

    protected static int getDefaultHeightStatic() {
        return 16;
    }

    protected void setRelatedModels(BindingSiteLinkModel tailm, ExternalNameForBidingSiteModel namem, BindingSiteWithLinkModel groupm) {
        this.tailm = tailm;
        this.namem = namem;
        this.groupm = groupm;
    }

    protected void setRemovable(boolean flag) {
        this.setDirectRemovable(flag);
        this.tailm.setDirectRemovable(flag);
        this.namem.setDirectRemovable(flag);
        this.groupm.setDirectRemovable(flag);
    }

    public void setProteinState(ProteinState ps) {
        this.proteinState = ps;
    }

    public void setCanvasModel(CanvasModel cm) {
        this.canvasModel = cm;
    }

    @Override
    public double getOperatedValue(InternalOperatorTraceStack parent) throws InternalOperationalException {
        ProteinInstanceState pis;
        List list;
        String sid = parent.getSpeciesId();
        TableColumnValue tcv = this.canvasModel.getTableValues().getTalbeColumnValue(sid);
        String pid = this.proteinState.getProtein().getId();
        ProteinState ps = tcv.getProteinState(pid);
        double initialValue = 0.0;
        if (ps != null && !(list = ps.getProteinInstanceStateList()).isEmpty() && (pis = (ProteinInstanceState)list.iterator().next()).getNmer() > 0) {
            initialValue = pis.getResidueCount() > 0 ? Double.NaN : 1.0;
        }
        double outputValue = 1.0;
        return InternalOperation.getOperatedValueOrWithInitialValue(this, parent, initialValue, outputValue);
    }

    public ProteinState getProteinState() {
        return this.proteinState;
    }

    public NameModelImpl getNameModel() {
        return this.namem;
    }

    public boolean isPredefined() {
        return this.proteinState != null;
    }
}

