/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.diagram;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.co.fujiric.star.gui.gef.ViewControllerImpl;
import jp.co.fujiric.star.gui.gef.swing.AnchorImpl;
import jp.co.fujiric.star.gui.gef.swing.AnchoredShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.EmptyAnchoredShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.NameModelImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.co.fujiric.star.gui.gef.swing.SimpleAnchorImpl;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteWithLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteWithLinkVC;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockNameModel;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasVC;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradeShapeModel;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradeTriangleModel;
import jp.sbi.celldesigner.blockDiagram.diagram.EffectSiteModel;
import jp.sbi.celldesigner.blockDiagram.diagram.EffectSiteWithLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.EffectSiteWithLinkVC;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalCircleModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalLinkWithCircleModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalNameForEffectSiteModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalNameForResidueModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalNameForResidueVC;
import jp.sbi.celldesigner.blockDiagram.diagram.HaloModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalLinkVC;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorModel;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorThresholdModel;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorVC;
import jp.sbi.celldesigner.blockDiagram.diagram.OperatorValueModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueNameModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueWithTailModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueWithTailVC;
import jp.sbi.celldesigner.blockDiagram.table.ModifierTableValue;
import jp.sbi.celldesigner.blockDiagram.table.ProteinActivity;
import jp.sbi.celldesigner.blockDiagram.table.ProteinState;
import jp.sbi.celldesigner.blockDiagram.table.ProteinWrapper;
import jp.sbi.celldesigner.blockDiagram.table.ResidueState;
import jp.sbi.celldesigner.blockDiagram.table.TableValues;
import jp.sbi.celldesigner.sbmlExtension.BlockDiagramAnnotation;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Annotation
extends BlockDiagramAnnotation {
    private TreeMap docMapBySBase = new TreeMap();
    private static final String ns = String.valueOf(ModelAnnotation.getOutputNamespace()) + ":";
    private static final String uri = "http://www.sbml.org/2001/ns/celldesigner";
    private static final String TAG_LISTOFBLOCKDIAGRAMS = "listOfBlockDiagrams";
    private static final String TAG_BLOCKDIAGRAM = "blockDiagram";
    private static final String TAG_CANVAS = "canvas";
    private static final String TAG_BLOCK = "block";
    private static final String TAG_HALO = "halo";
    private static final String TAG_LISTOFRESIDUES = "listOfResiduesInBlockDiagram";
    private static final String TAG_RESIDUE = "residueInBlockDiagram";
    private static final String TAG_LISTOFEXTNAMESFORRESIDUE = "listOfExternalNamesForResidue";
    private static final String TAG_EXTNAMEFORRESIDUE = "externalNameForResidue";
    private static final String TAG_LISTOFEXTCONNECTIONS = "listOfExternalConnectionsInBlockDiagram";
    private static final String TAG_EXTCONNECTION = "externalConnectionInBlockDiagram";
    private static final String TAG_LISTOFBINDINGSITES = "listOfBindingSitesInBlockDiagram";
    private static final String TAG_BINDINGSITE = "bindingSiteInBlockDiagram";
    private static final String TAG_LISTOFEFFECTSITES = "listOfEffectSitesInBlockDiagram";
    private static final String TAG_EFFECTSITE = "effectSiteInBlockDiagram";
    private static final String TAG_LISTOFOPERATORS = "listOfInternalOperatorsInBlockDiagram";
    private static final String TAG_OPERATOR = "internalOperatorInBlockDiagram";
    private static final String TAG_OPERATORVALUE = "internalOperatorValueInBlockDiagram";
    private static final String TAG_EFFECT = "effectInBlockDiagram";
    private static final String TAG_EFFECTTARGET = "effectTargetInBlockDiagram";
    private static final String TAG_DEGRADED = "degradedInBlockDiagram";
    private static final String TAG_DEGRADEDSHAPE = "degradedShapeInBlockDiagram";
    private static final String TAG_LISTOFINTERNALLINKS = "listOfInternalLinksInBlockDiagram";
    private static final String TAG_INTERNALLINK = "internalLinkInBlockDiagram";
    private static final String TAG_STARTPOINT = "startingPointInBlockDiagram";
    private static final String TAG_ENDPOINT = "endPointInBlockDiagram";
    private static final String ATTR_IDREF_PROTEIN = "protein";
    private static final String ATTR_X = "x";
    private static final String ATTR_Y = "y";
    private static final String ATTR_WIDTH = "width";
    private static final String ATTR_HEIGHT = "height";
    private static final String ATTR_NAMEOFFSETX = "nameOffsetX";
    private static final String ATTR_NAMEOFFSETY = "nameOffsetY";
    private static final String ATTR_OFFSETX = "offsetX";
    private static final String ATTR_OFFSETY = "offsetY";
    private static final String ATTR_IDREF_RESIDUE = "residue";
    private static final String ATTR_IDREF_BINDINGSITE = "bindingSite";
    private static final String ATTR_IDREF_EFFECTSITE = "effectSite";
    private static final String ATTR_IDREF_OPERATOR = "operator";
    private static final String ATTR_IDREF_LINK = "link";
    private static final String ATTR_IDREF_DEGRADE = "degrade";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_IDREF_SPECIES = "species";
    private static final String ATTR_IDREF_REACTION = "reaction";
    private static final String ATTR_ID = "id";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_SUBTYPE = "subType";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_PREDEFINED = "predefined";
    private static String KEYPREFIX_PROTEIN = "protein:";

    @Override
    public void writeDOMTree(Node node) {
        Document doc = node.getOwnerDocument();
        Element e1 = doc.createElementNS(uri, String.valueOf(ns) + TAG_LISTOFBLOCKDIAGRAMS);
        node.appendChild(e1);
        for (Object key : this.docMapBySBase.keySet()) {
            Document doc1 = (Document)this.docMapBySBase.get(key);
            Element root1 = doc1.getDocumentElement();
            e1.appendChild(doc.importNode(root1, true));
        }
    }

    public static void updateAnnotation(StringBuffer buf, Annotation blockDiagramAnnotation, ListOf listOfProtein) {
        buf.append("<celldesigner:listOfBlockDiagrams>\n");
        int i = 0;
        while ((long)i < listOfProtein.size()) {
            Species sp = (Species)listOfProtein.get((long)i);
            String key = String.valueOf(KEYPREFIX_PROTEIN) + sp.getId();
            Document doc = (Document)blockDiagramAnnotation.docMapBySBase.get(key);
            if (doc != null) {
                int j;
                int k;
                Annotation annotation = blockDiagramAnnotation;
                annotation.getClass();
                BlockDiagramInfo bdi = annotation.new BlockDiagramInfo(doc);
                buf.append("<celldesigner:blockDiagram protein=\"" + sp.getId() + "\">\n");
                buf.append("<celldesigner:canvas height=\"" + bdi.canvasHeight + "\" " + ATTR_WIDTH + "=\"" + bdi.canvasWidth + "\"/>\n");
                buf.append("<celldesigner:block height=\"" + bdi.blockHeight + "\" " + ATTR_NAMEOFFSETX + "=\"" + bdi.blockNameOffsetX + "\" " + ATTR_NAMEOFFSETY + "=\"" + bdi.blockNameOffsetY + "\" " + ATTR_WIDTH + "=\"" + bdi.blockWidth + "\" " + ATTR_X + "=\"" + bdi.blockX + "\" " + ATTR_Y + "=\"" + bdi.blockY + "\"/>\n");
                buf.append("<celldesigner:halo height=\"" + bdi.haloHeight + "\" " + ATTR_WIDTH + "=\"" + bdi.haloWidth + "\" " + ATTR_X + "=\"" + bdi.haloX + "\" " + ATTR_Y + "=\"" + bdi.haloY + "\"/>\n");
                if (bdi.residueInfoList.size() > 0) {
                    buf.append("<celldesigner:listOfResiduesInBlockDiagram>\n");
                    k = 0;
                    while (k < bdi.residueInfoList.size()) {
                        ResidueInfo ri = (ResidueInfo)bdi.residueInfoList.get(k);
                        buf.append("<celldesigner:residueInBlockDiagram id=\"" + ri.id + "\" ");
                        if (ri.name != null && !ri.name.equals("")) {
                            buf.append("name=\"" + ri.name + "\" " + ATTR_NAMEOFFSETX + "=\"" + ri.nameOffsetX + "\" " + ATTR_NAMEOFFSETY + "=\"" + ri.nameOffsetY + "\" ");
                        }
                        buf.append("offsetX=\"" + ri.offsetX + "\" ");
                        if (ri.residueId != null && !ri.residueId.equals("")) {
                            buf.append("residue=\"" + ri.residueId + "\" ");
                        }
                        buf.append("type=\"" + ri.type + "\"/>\n");
                        ++k;
                    }
                    buf.append("</celldesigner:listOfResiduesInBlockDiagram>\n");
                } else {
                    buf.append("<celldesigner:listOfResiduesInBlockDiagram/>\n");
                }
                if (bdi.extNameInfoList.size() > 0) {
                    buf.append("<celldesigner:listOfExternalNamesForResidue>\n");
                    k = 0;
                    while (k < bdi.extNameInfoList.size()) {
                        ExternalNameInfo xn = (ExternalNameInfo)bdi.extNameInfoList.get(k);
                        buf.append("<celldesigner:externalNameForResidue id=\"" + xn.id + "\" ");
                        if (xn.name != null && !xn.name.equals("")) {
                            buf.append("name=\"" + xn.name + "\" " + ATTR_NAMEOFFSETX + "=\"" + xn.nameOffsetX + "\" " + ATTR_NAMEOFFSETY + "=\"" + xn.nameOffsetY + "\" ");
                        }
                        buf.append("offsetY=\"" + xn.offsetY + "\" ");
                        if (xn.proteinForMtv != null && !xn.proteinForMtv.equals("")) {
                            buf.append("protein=\"" + xn.proteinForMtv + "\" ");
                        }
                        buf.append(">\n");
                        if (xn.connectionList.size() > 0) {
                            buf.append("<celldesigner:listOfExternalConnectionsInBlockDiagram>\n");
                            j = 0;
                            while (j < xn.connectionList.size()) {
                                ExternalConnectionInfo xc = (ExternalConnectionInfo)xn.connectionList.get(j);
                                buf.append("<celldesigner:externalConnectionInBlockDiagram predefined=\"" + xc.predefined + "\" " + ATTR_IDREF_RESIDUE + "=\"" + xc.residueIdrefInDOM + "\" " + ATTR_TYPE + " =\"" + ExternalCircleModel.getTypeFromInt(xc.type) + "\"/>\n");
                                ++j;
                            }
                            buf.append("</celldesigner:listOfExternalConnectionsInBlockDiagram>\n");
                        }
                        buf.append("</celldesigner:externalNameForResidue>\n");
                        ++k;
                    }
                    buf.append("</celldesigner:listOfExternalNamesForResidue>\n");
                } else {
                    buf.append("<celldesigner:listOfExternalNamesForResidue/>\n");
                }
                if (bdi.bindingSiteInfoList.size() > 0) {
                    buf.append("<celldesigner:listOfBindingSitesInBlockDiagram>\n");
                    k = 0;
                    while (k < bdi.bindingSiteInfoList.size()) {
                        BindingSiteInfo bs = (BindingSiteInfo)bdi.bindingSiteInfoList.get(k);
                        buf.append("<celldesigner:bindingSitesInBlockDiagram id=\"" + bs.id + "\" ");
                        if (bs.name != null && !bs.name.equals("")) {
                            buf.append("name=\"" + bs.name + "\" " + ATTR_NAMEOFFSETX + "=\"" + bs.nameOffsetX + "\" " + ATTR_NAMEOFFSETY + "=\"" + bs.nameOffsetY + "\" ");
                        }
                        buf.append("offsetY=\"" + bs.offsetY + "\" ");
                        if (bs.proteinId != null && !bs.proteinId.equals("")) {
                            buf.append("protein=\"" + bs.proteinId + "\" ");
                        }
                        buf.append("/>\n");
                        ++k;
                    }
                    buf.append("</celldesigner:listOfBindingSitesInBlockDiagram>\n");
                } else {
                    buf.append("<celldesigner:listOfBindingSitesInBlockDiagram/>\n");
                }
                if (bdi.effectSiteInfoList.size() > 0) {
                    buf.append("<celldesigner:listOfEffectSitesInBlockDiagram>\n");
                    k = 0;
                    while (k < bdi.effectSiteInfoList.size()) {
                        EffectSiteInfo fs = (EffectSiteInfo)bdi.effectSiteInfoList.get(k);
                        buf.append("<celldesigner:effectSiteInBlockDiagram id=\"" + fs.id + "\" ");
                        if (fs.name != null && !fs.name.equals("")) {
                            buf.append("name=\"" + fs.name + "\" " + ATTR_NAMEOFFSETX + "=\"" + fs.nameOffsetX + "\" " + ATTR_NAMEOFFSETY + "=\"" + fs.nameOffsetY + "\" ");
                        }
                        buf.append("offsetX=\"" + fs.offsetX + "\" " + ATTR_OFFSETY + "=\"" + fs.offsetY + "\" ");
                        if (fs.reactionId != null && !fs.reactionId.equals("")) {
                            buf.append("reaction=\"" + fs.reactionId + "\" ");
                        }
                        if (fs.speciesId != null && !fs.speciesId.equals("")) {
                            buf.append("species=\"" + fs.speciesId + "\" ");
                        }
                        buf.append(">\n");
                        if (fs.effectList.size() > 0) {
                            j = 0;
                            while (j < fs.effectList.size()) {
                                EffectInfo ef = (EffectInfo)fs.effectList.get(j);
                                buf.append("<celldesigner:effectInBlockDiagram type=\"" + ef.getType() + "\">\n");
                                if (ef.targetList.size() > 0) {
                                    int m = 0;
                                    while (m < ef.targetList.size()) {
                                        EffectTargetInfo et = (EffectTargetInfo)ef.targetList.get(m);
                                        buf.append("<celldesigner:effectTargetInBlockDiagram protein=\"" + et.id + "\"/>\n");
                                        ++m;
                                    }
                                }
                                buf.append("</celldesigner:effectInBlockDiagram>\n");
                                ++j;
                            }
                        }
                        buf.append("</celldesigner:effectSiteInBlockDiagram>\n");
                        ++k;
                    }
                    buf.append("</celldesigner:listOfEffectSitesInBlockDiagram>\n");
                } else {
                    buf.append("<celldesigner:listOfEffectSitesInBlockDiagram/>\n");
                }
                if (bdi.operatorInfoList.size() > 0) {
                    buf.append("<celldesigner:listOfInternalOperatorsInBlockDiagram>\n");
                    k = 0;
                    while (k < bdi.operatorInfoList.size()) {
                        OperatorInfo io = (OperatorInfo)bdi.operatorInfoList.get(k);
                        buf.append("<celldesigner:internalOperatorsInBlockDiagram id=\"" + io.id + "\" ");
                        if (io.value != null && !io.value.equals("")) {
                            buf.append("value=\"" + io.value + "\" valueOffsetX=\"" + io.valueOffsetX + "\" valueOffsetY=\"" + io.valueOffsetY + "\" ");
                        }
                        buf.append("offsetX=\"" + io.offsetX + "\" " + ATTR_OFFSETY + "=\"" + io.offsetY + "\" ");
                        buf.append("type=\"" + OperatorModel.getTypeFromInt(io.type) + "\" " + ATTR_SUBTYPE + "=\"" + OperatorThresholdModel.getRelationalOperatorString(io.subType) + "\" ");
                        buf.append("/>\n");
                        ++k;
                    }
                    buf.append("</celldesigner:listOfInternalOperatorsInBlockDiagram>\n");
                } else {
                    buf.append("<celldesigner:listOfInternalOperatorsInBlockDiagram/>\n");
                }
                if (bdi.linkInfoList.size() > 0) {
                    buf.append("<celldesigner:listOfInternalLinksInBlockDiagram>\n");
                    k = 0;
                    while (k < bdi.linkInfoList.size()) {
                        InternalLinkInfo link = (InternalLinkInfo)bdi.operatorInfoList.get(k);
                        buf.append("<celldesigner:internalLinksInBlockDiagram id=\"" + link.id + "\" type=\"" + InternalLinkModel.getTypeFromInt(link.type) + "\">\n");
                        if (link.start != null) {
                            buf.append("<celldesigner:startingPointInBlockDiagram id=\"" + link.start.idref + "\" " + ATTR_OFFSETX + "=\"" + link.start.offsetX + "\" " + ATTR_OFFSETY + "=\"" + link.start.offsetY + "\" target=\"" + link.start.target + "\"/>\n");
                        }
                        if (link.end != null) {
                            buf.append("<celldesigner:endPointInBlockDiagram id=\"" + link.end.idref + "\" " + ATTR_OFFSETX + "=\"" + link.end.offsetX + "\" " + ATTR_OFFSETY + "=\"" + link.end.offsetY + "\" target=\"" + link.end.target + "\"/>\n");
                        }
                        ++k;
                    }
                    buf.append("</celldesigner:listOfInternalLinksInBlockDiagram>\n");
                } else {
                    buf.append("<celldesigner:listOfInternalLinksInBlockDiagram/>\n");
                }
                buf.append("</celldesigner:blockDiagram>\n");
            }
            ++i;
        }
        buf.append("</celldesigner:listOfBlockDiagrams>\n");
    }

    @Override
    public void readDOMTree(NodeList childlist) {
        this.docMapBySBase.clear();
        if (childlist != null) {
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Element elem;
                String tag;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(uri) && (tag = (elem = (Element)node).getLocalName()).equals(TAG_LISTOFBLOCKDIAGRAMS)) {
                    NodeList childlist1 = elem.getChildNodes();
                    int childsize1 = childlist1.getLength();
                    int i1 = 0;
                    while (i1 < childsize1) {
                        Element elem1;
                        String tag1;
                        Node node1 = childlist1.item(i1);
                        if (node1.getNodeType() == 1 && node1.getNamespaceURI().equals(uri) && (tag1 = (elem1 = (Element)node1).getLocalName()).equals(TAG_BLOCKDIAGRAM)) {
                            this.readDOMTreeOfBlockDiagram(elem1);
                        }
                        ++i1;
                    }
                }
                ++i;
            }
        }
    }

    private void readDOMTreeOfBlockDiagram(Element elem) {
        Attr attr = elem.getAttributeNode(ATTR_IDREF_PROTEIN);
        if (attr == null) {
            return;
        }
        String id = attr.getValue();
        String key = String.valueOf(KEYPREFIX_PROTEIN) + id;
        Document doc = this.createEmptyDocument();
        doc.appendChild(doc.importNode(elem, true));
        this.docMapBySBase.put(key, doc);
    }

    public void createTemporaryDOMTree(TableValues values, CanvasVC canvasvc) {
        SBase sb = values.getSBase();
        String key = null;
        if (!(sb instanceof Protein)) {
            throw new IllegalArgumentException("unsupported sbase for createTemporaryDOMTree");
        }
        key = String.valueOf(KEYPREFIX_PROTEIN) + ((Protein)sb).getId();
        Document doc = this.setupTemporaryDocument(values, canvasvc);
        this.docMapBySBase.put(key, doc);
    }

    public BlockDiagramInfo createTemporaryBDInfo(TableValues values, CanvasVC canvasvc) {
        Document doc = this.setupTemporaryDocument(values, canvasvc);
        return new BlockDiagramInfo(doc);
    }

    private Document createEmptyDocument() {
        try {
            DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
            docfactory.setNamespaceAware(true);
            DocumentBuilder builder = docfactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            return doc;
        }
        catch (ParserConfigurationException e) {
            return null;
        }
    }

    private Document setupTemporaryDocument(TableValues values, CanvasVC canvasvc) {
        Document doc = this.createEmptyDocument();
        Element root = doc.createElementNS(uri, String.valueOf(ns) + TAG_BLOCKDIAGRAM);
        doc.appendChild(root);
        SBase sb = values.getSBase();
        if (sb instanceof Protein) {
            root.setAttributeNS(uri, ATTR_IDREF_PROTEIN, ((Protein)sb).getId());
        }
        JComponent jc = canvasvc.getGuiComponent();
        Rectangle r = jc.getBounds();
        Element e = doc.createElementNS(uri, String.valueOf(ns) + TAG_CANVAS);
        root.appendChild(e);
        e.setAttributeNS(uri, ATTR_WIDTH, Integer.toString(r.width));
        e.setAttributeNS(uri, ATTR_HEIGHT, Integer.toString(r.height));
        BlockModel bm = (BlockModel)canvasvc.getBlockvc().getModel();
        BlockNameModel namem = bm.getBlockNameModel();
        e = doc.createElementNS(uri, String.valueOf(ns) + TAG_BLOCK);
        root.appendChild(e);
        this.appendAttrXY(e, bm);
        this.appendAttrWH(e, bm);
        this.appendAttrNameOffset(e, namem);
        HaloModel hm = (HaloModel)canvasvc.getHalovc().getModel();
        Element e2 = doc.createElementNS(uri, String.valueOf(ns) + TAG_HALO);
        root.appendChild(e2);
        this.appendAttrXY(e2, hm);
        this.appendAttrWH(e2, hm);
        TreeMap residueIdMapByResidue = this.setupTemporaryDocumentResidues(canvasvc, doc, root);
        this.setupTemporaryDocumentExtNamesForResidue(canvasvc, doc, root, residueIdMapByResidue);
        Map bindingSiteIdMapByBindingSite = this.setupTemporaryDocumentBindingSites(canvasvc, doc, root);
        Map effectSiteIdMapByEffectSite = this.setupTemporaryDocumentEffectSites(canvasvc, doc, root);
        this.setupTemporaryDocumentDegrade(canvasvc, doc, root);
        Map operatorIdMapByOperator = this.setupTemporaryDocumentOperators(canvasvc, doc, root);
        this.setupTemporaryDocumentInternalLinks(canvasvc, doc, root, residueIdMapByResidue, bindingSiteIdMapByBindingSite, effectSiteIdMapByEffectSite, operatorIdMapByOperator);
        return doc;
    }

    private Map setupTemporaryDocumentInternalLinks(CanvasVC canvasvc, Document doc, Element root, Map residueIdMapByResidue, Map bindingSiteIdMapByBindingSite, Map effectSiteIdMapByEffectSite, Map operatorIdMapByOperator) {
        InternalLinkModel linkm;
        ViewControllerImpl vc;
        TreeMap<InternalLinkModel, String> map = new TreeMap<InternalLinkModel, String>();
        Element e = doc.createElementNS(uri, String.valueOf(ns) + TAG_LISTOFINTERNALLINKS);
        root.appendChild(e);
        int id = 0;
        Iterator it = canvasvc.getSubsIterator();
        while (it.hasNext()) {
            vc = (ViewControllerImpl)it.next();
            if (!(vc instanceof InternalLinkVC)) continue;
            linkm = (InternalLinkModel)vc.getModel();
            map.put(linkm, Integer.toString(id++));
        }
        id = 0;
        it = canvasvc.getSubsIterator();
        while (it.hasNext()) {
            vc = (ViewControllerImpl)it.next();
            if (!(vc instanceof InternalLinkVC)) continue;
            linkm = (InternalLinkModel)vc.getModel();
            Element e1 = doc.createElementNS(uri, String.valueOf(ns) + TAG_INTERNALLINK);
            e.appendChild(e1);
            this.appendAttrId(e1, id);
            e1.setAttributeNS(uri, ATTR_TYPE, linkm.getTypeString());
            Element e2 = doc.createElementNS(uri, String.valueOf(ns) + TAG_STARTPOINT);
            e1.appendChild(e2);
            this.saveAboutLinkedPoint(e2, linkm.getShapeOf(0), linkm.getAnchorOf(0), residueIdMapByResidue, bindingSiteIdMapByBindingSite, effectSiteIdMapByEffectSite, operatorIdMapByOperator, map);
            e2 = doc.createElementNS(uri, String.valueOf(ns) + TAG_ENDPOINT);
            e1.appendChild(e2);
            this.saveAboutLinkedPoint(e2, linkm.getShapeOf(1), linkm.getAnchorOf(1), residueIdMapByResidue, bindingSiteIdMapByBindingSite, effectSiteIdMapByEffectSite, operatorIdMapByOperator, map);
            ++id;
        }
        return map;
    }

    private void saveAboutLinkedPoint(Element elem, ShapeModelImpl shape, AnchorImpl anchor, Map residueIdMapByResidue, Map bindingSiteIdMapByBindingSite, Map effectSiteIdMapByEffectSite, Map operatorIdMapByOperator, Map linkIdMapByLink) {
        String id;
        if (shape instanceof ResidueModel) {
            id = (String)residueIdMapByResidue.get(shape);
            elem.setAttributeNS(uri, ATTR_IDREF_RESIDUE, id);
        } else if (shape instanceof BindingSiteModel) {
            id = (String)bindingSiteIdMapByBindingSite.get(shape);
            elem.setAttributeNS(uri, ATTR_IDREF_BINDINGSITE, id);
        } else if (shape instanceof EffectSiteModel) {
            id = (String)effectSiteIdMapByEffectSite.get(shape);
            elem.setAttributeNS(uri, ATTR_IDREF_EFFECTSITE, id);
        } else if (shape instanceof OperatorModel) {
            id = (String)operatorIdMapByOperator.get(shape);
            elem.setAttributeNS(uri, ATTR_IDREF_OPERATOR, id);
        } else if (shape instanceof InternalLinkModel) {
            id = (String)linkIdMapByLink.get(shape);
            elem.setAttributeNS(uri, ATTR_IDREF_LINK, id);
        } else if (shape instanceof DegradeTriangleModel) {
            elem.setAttributeNS(uri, ATTR_IDREF_DEGRADE, "0");
        }
        double dx = anchor.getOffsetX();
        double dy = anchor.getOffsetY();
        elem.setAttributeNS(uri, ATTR_OFFSETX, Double.toString(dx));
        elem.setAttributeNS(uri, ATTR_OFFSETY, Double.toString(dy));
    }

    private Map setupTemporaryDocumentOperators(CanvasVC canvasvc, Document doc, Element root) {
        TreeMap<OperatorModel, String> map = new TreeMap<OperatorModel, String>();
        Element e = doc.createElementNS(uri, String.valueOf(ns) + TAG_LISTOFOPERATORS);
        root.appendChild(e);
        int id = 0;
        Iterator it = canvasvc.getSubsIterator();
        while (it.hasNext()) {
            OperatorValueModel ovm;
            ViewControllerImpl vc = (ViewControllerImpl)it.next();
            if (!(vc instanceof OperatorVC)) continue;
            OperatorModel om = (OperatorModel)vc.getModel();
            Element e1 = doc.createElementNS(uri, String.valueOf(ns) + TAG_OPERATOR);
            e.appendChild(e1);
            this.appendAttrId(e1, id);
            this.appendAttrAnchoringOffsetX(e1, om);
            this.appendAttrAnchoringOffsetY(e1, om);
            String type = om.getTypeString();
            e1.setAttributeNS(uri, ATTR_TYPE, type);
            if (om instanceof OperatorThresholdModel) {
                OperatorThresholdModel otm = (OperatorThresholdModel)om;
                String str = otm.getRelationalOperatorTypeString();
                e1.setAttributeNS(uri, ATTR_SUBTYPE, str);
            }
            if ((ovm = om.getValueModel()) != null) {
                Element e2 = doc.createElementNS(uri, String.valueOf(ns) + TAG_OPERATORVALUE);
                e1.appendChild(e2);
                String value = om.getDoubleValueString();
                e2.setAttributeNS(uri, ATTR_VALUE, value);
                this.appendAttrAnchoringOffsetX(e2, ovm);
                this.appendAttrAnchoringOffsetY(e2, ovm);
            }
            map.put(om, Integer.toString(id++));
        }
        return map;
    }

    private void setupTemporaryDocumentDegrade(CanvasVC canvasvc, Document doc, Element root) {
        BlockModel bm = (BlockModel)canvasvc.getBlockvc().getModel();
        if (!bm.hasDegradeTriangleModel()) {
            return;
        }
        DegradeTriangleModel dtm = bm.getDegradeTriangleModel();
        Element e = doc.createElementNS(uri, String.valueOf(ns) + TAG_DEGRADED);
        root.appendChild(e);
        int id = 0;
        this.appendAttrId(e, id);
        this.appendAttrAnchoringOffsetY(e, dtm);
        DegradeShapeModel dsm = dtm.getDegradeShapeModel();
        Element e1 = doc.createElementNS(uri, String.valueOf(ns) + TAG_DEGRADEDSHAPE);
        e.appendChild(e1);
        this.appendAttrWH(e1, dsm);
        this.appendAttrAnchoringOffsetX(e1, dsm);
        this.appendAttrAnchoringOffsetY(e1, dsm);
    }

    private Map setupTemporaryDocumentEffectSites(CanvasVC canvasvc, Document doc, Element root) {
        TreeMap<EffectSiteModel, String> map = new TreeMap<EffectSiteModel, String>();
        Element e = doc.createElementNS(uri, String.valueOf(ns) + TAG_LISTOFEFFECTSITES);
        root.appendChild(e);
        int id = 0;
        Iterator it = canvasvc.getSubsIterator();
        while (it.hasNext()) {
            ViewControllerImpl vc = (ViewControllerImpl)it.next();
            if (!(vc instanceof EffectSiteWithLinkVC)) continue;
            EffectSiteWithLinkModel groupm = (EffectSiteWithLinkModel)vc.getModel();
            EffectSiteModel esm = groupm.getEffectSiteModel();
            Element e1 = doc.createElementNS(uri, String.valueOf(ns) + TAG_EFFECTSITE);
            e.appendChild(e1);
            this.appendAttrId(e1, id);
            this.appendAttrAnchoringOffsetX(e1, esm);
            ExternalNameForEffectSiteModel namem = (ExternalNameForEffectSiteModel)esm.getNameModel();
            AnchoredShapeModelImpl cornerm = namem.getCornerModel();
            this.appendAttrAnchoringOffsetY(e1, cornerm);
            e1.setAttributeNS(uri, ATTR_NAME, namem.getName());
            this.appendAttrNameOffset(e1, namem);
            ProteinActivity pa = esm.getProteinActivity();
            if (pa != null) {
                String sid = pa.getSpeciesId();
                String rid = pa.getReactionId();
                e1.setAttributeNS(uri, ATTR_IDREF_SPECIES, sid);
                e1.setAttributeNS(uri, ATTR_IDREF_REACTION, rid);
                Set set = pa.getTypeSet();
                for (String type : set) {
                    if (type == null || type.length() <= 0) continue;
                    Element e2 = doc.createElementNS(uri, String.valueOf(ns) + TAG_EFFECT);
                    e1.appendChild(e2);
                    e2.setAttributeNS(uri, ATTR_TYPE, type);
                    Set proteinSet = pa.getTargetProteinSet2ByType(type);
                    for (ProteinWrapper pw : proteinSet) {
                        Protein p = pw.getProtein();
                        Element e3 = doc.createElementNS(uri, String.valueOf(ns) + TAG_EFFECTTARGET);
                        e2.appendChild(e3);
                        e3.setAttributeNS(uri, ATTR_IDREF_PROTEIN, p.getId());
                    }
                }
            }
            map.put(esm, Integer.toString(id++));
        }
        return map;
    }

    private Map setupTemporaryDocumentBindingSites(CanvasVC canvasvc, Document doc, Element root) {
        TreeMap<BindingSiteModel, String> map = new TreeMap<BindingSiteModel, String>();
        Element e = doc.createElementNS(uri, String.valueOf(ns) + TAG_LISTOFBINDINGSITES);
        root.appendChild(e);
        int id = 0;
        Iterator it = canvasvc.getSubsIterator();
        while (it.hasNext()) {
            ViewControllerImpl vc = (ViewControllerImpl)it.next();
            if (!(vc instanceof BindingSiteWithLinkVC)) continue;
            BindingSiteWithLinkModel linkm = (BindingSiteWithLinkModel)vc.getModel();
            BindingSiteModel bsm = linkm.getBindingSiteModel();
            Element e1 = doc.createElementNS(uri, String.valueOf(ns) + TAG_BINDINGSITE);
            e.appendChild(e1);
            this.appendAttrId(e1, id);
            this.appendAttrAnchoringOffsetY(e1, bsm);
            NameModelImpl namem = bsm.getNameModel();
            e1.setAttributeNS(uri, ATTR_NAME, namem.getName());
            this.appendAttrNameOffset(e1, namem);
            ProteinState ps = bsm.getProteinState();
            if (ps != null) {
                Protein p = ps.getProtein();
                e1.setAttributeNS(uri, ATTR_IDREF_PROTEIN, p.getId());
            }
            map.put(bsm, Integer.toString(id++));
        }
        return map;
    }

    private TreeMap setupTemporaryDocumentResidues(CanvasVC canvasvc, Document doc, Element root) {
        TreeMap<ResidueModel, String> map = new TreeMap<ResidueModel, String>();
        Element e = doc.createElementNS(uri, String.valueOf(ns) + TAG_LISTOFRESIDUES);
        root.appendChild(e);
        int id = 0;
        Iterator it = canvasvc.getSubsIterator();
        while (it.hasNext()) {
            ResidueNameModel namem;
            ViewControllerImpl vc = (ViewControllerImpl)it.next();
            if (!(vc instanceof ResidueWithTailVC)) continue;
            ResidueWithTailModel m = (ResidueWithTailModel)vc.getModel();
            ResidueModel rm = m.getResidueModel();
            Element e1 = doc.createElementNS(uri, String.valueOf(ns) + TAG_RESIDUE);
            e.appendChild(e1);
            this.appendAttrId(e1, id);
            this.appendAttrAnchoringOffsetX(e1, rm);
            String type = rm.getTypeString();
            e1.setAttributeNS(uri, ATTR_TYPE, type);
            ResidueState rs = rm.getResidueState();
            if (rs != null) {
                String residueId = rs.getResidueId();
                e1.setAttributeNS(uri, ATTR_IDREF_RESIDUE, residueId);
            }
            if ((namem = rm.getNameModel()) != null) {
                e1.setAttributeNS(uri, ATTR_NAME, namem.getName());
                this.appendAttrNameOffset(e1, namem);
            }
            map.put(rm, Integer.toString(id++));
        }
        return map;
    }

    private Map setupTemporaryDocumentExtNamesForResidue(CanvasVC canvasvc, Document doc, Element root, Map residueIdMapByResidue) {
        TreeMap<String, ExternalNameForResidueModel> map = new TreeMap<String, ExternalNameForResidueModel>();
        Element e = doc.createElementNS(uri, String.valueOf(ns) + TAG_LISTOFEXTNAMESFORRESIDUE);
        root.appendChild(e);
        int id = 0;
        Iterator it = canvasvc.getSubsIterator();
        while (it.hasNext()) {
            ViewControllerImpl vc = (ViewControllerImpl)it.next();
            if (!(vc instanceof ExternalNameForResidueVC)) continue;
            ExternalNameForResidueModel m = (ExternalNameForResidueModel)vc.getModel();
            EmptyAnchoredShapeModelImpl basem = m.getBasemOnHaloWest();
            Element e1 = doc.createElementNS(uri, String.valueOf(ns) + TAG_EXTNAMEFORRESIDUE);
            e.appendChild(e1);
            this.appendAttrId(e1, id);
            ModifierTableValue mtv = m.getModifierTableValue();
            if (mtv != null) {
                this.appendProteinNames(e1, mtv);
            }
            this.appendAttrAnchoringOffsetY(e1, basem);
            e1.setAttributeNS(uri, ATTR_NAME, m.getName());
            this.appendAttrNameOffset(e1, m);
            Element e2 = doc.createElementNS(uri, String.valueOf(ns) + TAG_LISTOFEXTCONNECTIONS);
            e1.appendChild(e2);
            for (ResidueModel rm : m.getKeySetOfRtmMapByResidueModel()) {
                String residueId = (String)residueIdMapByResidue.get(rm);
                Element e3 = doc.createElementNS(uri, String.valueOf(ns) + TAG_EXTCONNECTION);
                e2.appendChild(e3);
                e3.setAttributeNS(uri, ATTR_IDREF_RESIDUE, residueId);
                ExternalLinkWithCircleModel linkgm = m.getExternalLinkWithCircleModelByResidueModel(rm);
                e3.setAttributeNS(uri, ATTR_TYPE, linkgm.getTypeString());
                if (!linkgm.isPredefined()) continue;
                e3.setAttributeNS(uri, ATTR_PREDEFINED, "true");
            }
            map.put(Integer.toString(id++), m);
        }
        return map;
    }

    private void appendProteinNames(Element e, ModifierTableValue mtv) {
        e.setAttributeNS(uri, ATTR_IDREF_PROTEIN, mtv.getModifiersProteinId());
    }

    private void appendAttrId(Element e, int id) {
        e.setAttributeNS(uri, ATTR_ID, Integer.toString(id));
    }

    private void appendAttrXY(Element e, ShapeModelImpl m) {
        int x = m.getX();
        int y = m.getY();
        e.setAttributeNS(uri, ATTR_X, Integer.toString(x));
        e.setAttributeNS(uri, ATTR_Y, Integer.toString(y));
    }

    private void appendAttrWH(Element e, ShapeModelImpl m) {
        int w = m.getWidth();
        int h = m.getHeight();
        e.setAttributeNS(uri, ATTR_WIDTH, Integer.toString(w));
        e.setAttributeNS(uri, ATTR_HEIGHT, Integer.toString(h));
    }

    private void appendAttrNameOffset(Element e, NameModelImpl namem) {
        SimpleAnchorImpl a0 = (SimpleAnchorImpl)namem.getAnchorOf(0);
        double dx = a0.getOffsetX();
        double dy = a0.getOffsetY();
        e.setAttributeNS(uri, ATTR_NAMEOFFSETX, Double.toString(dx));
        e.setAttributeNS(uri, ATTR_NAMEOFFSETY, Double.toString(dy));
    }

    private void appendAttrAnchoringOffsetX(Element e, AnchoredShapeModelImpl m) {
        AnchorImpl a0 = m.getAnchorOf(0);
        double dx = a0.getOffsetX();
        e.setAttributeNS(uri, ATTR_OFFSETX, Double.toString(dx));
    }

    private void appendAttrAnchoringOffsetY(Element e, AnchoredShapeModelImpl m) {
        AnchorImpl a0 = m.getAnchorOf(0);
        double dy = a0.getOffsetY();
        e.setAttributeNS(uri, ATTR_OFFSETY, Double.toString(dy));
    }

    private String readStringAttr(Element elem, String attrName) {
        Attr attr = elem.getAttributeNode(attrName);
        if (attr != null) {
            String value = attr.getValue();
            return value;
        }
        return null;
    }

    private double readDoubleAttr(Element elem, String attrName, double defaultValue) {
        Attr attr = elem.getAttributeNode(attrName);
        if (attr != null) {
            String value = attr.getValue();
            try {
                double ans = Double.parseDouble(value);
                return ans;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private int readIntAttr(Element elem, String attrName, int defaultValue) {
        Attr attr = elem.getAttributeNode(attrName);
        if (attr != null) {
            String value = attr.getValue();
            try {
                int ans = Integer.parseInt(value);
                return ans;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public BlockDiagramInfo createBlockDiagramFromDOMForProtein(String id) {
        String key = String.valueOf(KEYPREFIX_PROTEIN) + id;
        Document doc = (Document)this.docMapBySBase.get(key);
        if (doc == null) {
            return new BlockDiagramInfo();
        }
        return new BlockDiagramInfo(doc);
    }

    public class BindingSiteInfo {
        private String id;
        private String name = null;
        private double nameOffsetX = 0.0;
        private double nameOffsetY = 0.0;
        private double offsetY = 0.0;
        private String proteinId = null;

        BindingSiteInfo(Element elem) {
            this.id = Annotation.this.readStringAttr(elem, Annotation.ATTR_ID);
            this.name = Annotation.this.readStringAttr(elem, Annotation.ATTR_NAME);
            this.proteinId = Annotation.this.readStringAttr(elem, Annotation.ATTR_IDREF_PROTEIN);
            this.offsetY = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_OFFSETY, this.offsetY);
            this.nameOffsetX = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_NAMEOFFSETX, this.nameOffsetX);
            this.nameOffsetY = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_NAMEOFFSETY, this.nameOffsetY);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public double getNameOffsetX() {
            return this.nameOffsetX;
        }

        public double getNameOffsetY() {
            return this.nameOffsetY;
        }

        public double getOffsetY() {
            return this.offsetY;
        }

        public String getProteinId() {
            return this.proteinId;
        }
    }

    public class BlockDiagramInfo {
        private List residueInfoList = new LinkedList();
        private List bindingSiteInfoList = new LinkedList();
        private List effectSiteInfoList = new LinkedList();
        private List extNameInfoList = new LinkedList();
        private List operatorInfoList = new LinkedList();
        private List linkInfoList = new LinkedList();
        private boolean loaded = false;
        private int canvasWidth = 300;
        private int canvasHeight = 200;
        private int blockX = 100;
        private int blockY = 50;
        private int blockWidth = 140;
        private int blockHeight = 90;
        private double blockNameOffsetX = 0.0;
        private double blockNameOffsetY = 0.0;
        private int haloX = 70;
        private int haloY = 20;
        private int haloWidth = 200;
        private int haloHeight = 150;
        private boolean hasDegraded = false;
        private double degradedOffsetY = 0.0;
        private int degradedShapeWidth = 22;
        private int degradedShapeHeight = 22;
        private double degradedShapeOffsetX = 0.0;
        private double degradedShapeOffsetY = 0.0;

        BlockDiagramInfo() {
        }

        BlockDiagramInfo(Document doc) {
            this.append(doc);
        }

        public void append(Document doc) {
            this.loaded = true;
            Element root = doc.getDocumentElement();
            NodeList childlist = root.getChildNodes();
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(Annotation.uri)) {
                    Element elem = (Element)node;
                    String tag = elem.getLocalName();
                    if (tag.equals(Annotation.TAG_CANVAS)) {
                        this.loadCanvasTag(elem);
                    } else if (tag.equals(Annotation.TAG_BLOCK)) {
                        this.loadBlockTag(elem);
                    } else if (tag.equals(Annotation.TAG_HALO)) {
                        this.loadHaloTag(elem);
                    } else if (tag.equals(Annotation.TAG_LISTOFRESIDUES)) {
                        this.loadListOfResidues(elem);
                    } else if (tag.equals(Annotation.TAG_LISTOFEXTNAMESFORRESIDUE)) {
                        this.loadListOfExtNames(elem);
                    } else if (tag.equals(Annotation.TAG_LISTOFBINDINGSITES)) {
                        this.loadListOfBindingSites(elem);
                    } else if (tag.equals(Annotation.TAG_LISTOFEFFECTSITES)) {
                        this.loadListOfEffectSites(elem);
                    } else if (tag.equals(Annotation.TAG_DEGRADED)) {
                        this.loadDegradedTag(elem);
                    } else if (tag.equals(Annotation.TAG_LISTOFOPERATORS)) {
                        this.loadListOfOperators(elem);
                    } else if (tag.equals(Annotation.TAG_LISTOFINTERNALLINKS)) {
                        this.loadListOfInternalLinks(elem);
                    }
                }
                ++i;
            }
        }

        private void loadListOfInternalLinks(Element elem) {
            NodeList childlist = elem.getChildNodes();
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Element e;
                String tag;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(Annotation.uri) && (tag = (e = (Element)node).getLocalName()).equals(Annotation.TAG_INTERNALLINK)) {
                    this.linkInfoList.add(new InternalLinkInfo(e));
                }
                ++i;
            }
        }

        private void loadListOfOperators(Element elem) {
            NodeList childlist = elem.getChildNodes();
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Element e;
                String tag;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(Annotation.uri) && (tag = (e = (Element)node).getLocalName()).equals(Annotation.TAG_OPERATOR)) {
                    this.operatorInfoList.add(new OperatorInfo(e));
                }
                ++i;
            }
        }

        private void loadListOfExtNames(Element elem) {
            NodeList childlist = elem.getChildNodes();
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Element e;
                String tag;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(Annotation.uri) && (tag = (e = (Element)node).getLocalName()).equals(Annotation.TAG_EXTNAMEFORRESIDUE)) {
                    this.extNameInfoList.add(new ExternalNameInfo(e));
                }
                ++i;
            }
        }

        private void loadListOfEffectSites(Element elem) {
            NodeList childlist = elem.getChildNodes();
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Element e;
                String tag;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(Annotation.uri) && (tag = (e = (Element)node).getLocalName()).equals(Annotation.TAG_EFFECTSITE)) {
                    this.effectSiteInfoList.add(new EffectSiteInfo(e));
                }
                ++i;
            }
        }

        private void loadDegradedTag(Element elem) {
            this.hasDegraded = true;
            this.degradedOffsetY = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_OFFSETY, this.degradedOffsetY);
            NodeList childlist = elem.getChildNodes();
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Element elem1;
                String tag1;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(Annotation.uri) && (tag1 = (elem1 = (Element)node).getLocalName()).equals(Annotation.TAG_DEGRADEDSHAPE)) {
                    this.degradedShapeWidth = Annotation.this.readIntAttr(elem1, Annotation.ATTR_WIDTH, this.degradedShapeWidth);
                    this.degradedShapeHeight = Annotation.this.readIntAttr(elem1, Annotation.ATTR_HEIGHT, this.degradedShapeHeight);
                    this.degradedShapeOffsetX = Annotation.this.readDoubleAttr(elem1, Annotation.ATTR_OFFSETX, this.degradedShapeOffsetX);
                    this.degradedShapeOffsetY = Annotation.this.readDoubleAttr(elem1, Annotation.ATTR_OFFSETY, this.degradedShapeOffsetY);
                }
                ++i;
            }
        }

        private void loadListOfBindingSites(Element elem) {
            NodeList childlist = elem.getChildNodes();
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Element e;
                String tag;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(Annotation.uri) && (tag = (e = (Element)node).getLocalName()).equals(Annotation.TAG_BINDINGSITE)) {
                    this.bindingSiteInfoList.add(new BindingSiteInfo(e));
                }
                ++i;
            }
        }

        private void loadListOfResidues(Element elem) {
            NodeList childlist = elem.getChildNodes();
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Element e;
                String tag;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(Annotation.uri) && (tag = (e = (Element)node).getLocalName()).equals(Annotation.TAG_RESIDUE)) {
                    ResidueInfo ri = new ResidueInfo(e);
                    this.residueInfoList.add(ri);
                }
                ++i;
            }
        }

        private void loadCanvasTag(Element elem) {
            this.canvasWidth = Annotation.this.readIntAttr(elem, Annotation.ATTR_WIDTH, this.canvasWidth);
            this.canvasHeight = Annotation.this.readIntAttr(elem, Annotation.ATTR_HEIGHT, this.canvasHeight);
        }

        private void loadBlockTag(Element elem) {
            this.blockX = Annotation.this.readIntAttr(elem, Annotation.ATTR_X, this.blockX);
            this.blockY = Annotation.this.readIntAttr(elem, Annotation.ATTR_Y, this.blockY);
            this.blockWidth = Annotation.this.readIntAttr(elem, Annotation.ATTR_WIDTH, this.blockWidth);
            this.blockHeight = Annotation.this.readIntAttr(elem, Annotation.ATTR_HEIGHT, this.blockHeight);
            this.blockNameOffsetX = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_NAMEOFFSETX, this.blockNameOffsetX);
            this.blockNameOffsetY = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_NAMEOFFSETY, this.blockNameOffsetY);
        }

        private void loadHaloTag(Element elem) {
            this.haloX = Annotation.this.readIntAttr(elem, Annotation.ATTR_X, this.haloX);
            this.haloY = Annotation.this.readIntAttr(elem, Annotation.ATTR_Y, this.haloY);
            this.haloWidth = Annotation.this.readIntAttr(elem, Annotation.ATTR_WIDTH, this.haloWidth);
            this.haloHeight = Annotation.this.readIntAttr(elem, Annotation.ATTR_HEIGHT, this.haloHeight);
        }

        public List getResidueInfoList() {
            return Collections.unmodifiableList(this.residueInfoList);
        }

        public List getBindingSiteInfoList() {
            return Collections.unmodifiableList(this.bindingSiteInfoList);
        }

        public List getEffectSiteInfoList() {
            return Collections.unmodifiableList(this.effectSiteInfoList);
        }

        public List getExternalNameInfoList() {
            return Collections.unmodifiableList(this.extNameInfoList);
        }

        public List getOperatorInfoList() {
            return Collections.unmodifiableList(this.operatorInfoList);
        }

        public List getInternalLinkInfoList() {
            return Collections.unmodifiableList(this.linkInfoList);
        }

        public int getCanvasHeight() {
            return this.canvasHeight;
        }

        public int getCanvasWidth() {
            return this.canvasWidth;
        }

        public int getBlockHeight() {
            return this.blockHeight;
        }

        public double getBlockNameOffsetX() {
            return this.blockNameOffsetX;
        }

        public double getBlockNameOffsetY() {
            return this.blockNameOffsetY;
        }

        public int getBlockWidth() {
            return this.blockWidth;
        }

        public int getBlockX() {
            return this.blockX;
        }

        public int getBlockY() {
            return this.blockY;
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public int getHaloHeight() {
            return this.haloHeight;
        }

        public int getHaloWidth() {
            return this.haloWidth;
        }

        public int getHaloX() {
            return this.haloX;
        }

        public int getHaloY() {
            return this.haloY;
        }

        public double getDegradedOffsetY() {
            return this.degradedOffsetY;
        }

        public int getDegradedShapeHeight() {
            return this.degradedShapeHeight;
        }

        public double getDegradedShapeOffsetX() {
            return this.degradedShapeOffsetX;
        }

        public double getDegradedShapeOffsetY() {
            return this.degradedShapeOffsetY;
        }

        public int getDegradedShapeWidth() {
            return this.degradedShapeWidth;
        }

        public boolean hasDegraded() {
            return this.hasDegraded;
        }
    }

    public class EffectInfo {
        private String type;
        private List targetList = new LinkedList();

        EffectInfo(Element elem) {
            this.type = Annotation.this.readStringAttr(elem, Annotation.ATTR_TYPE);
            NodeList childlist = elem.getChildNodes();
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Element e;
                String tag;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(Annotation.uri) && (tag = (e = (Element)node).getLocalName()).equals(Annotation.TAG_EFFECTTARGET)) {
                    this.targetList.add(new EffectTargetInfo(e));
                }
                ++i;
            }
        }

        public String getType() {
            return this.type;
        }

        public List getTargetList() {
            return Collections.unmodifiableList(this.targetList);
        }
    }

    public class EffectSiteInfo {
        private String id;
        private String name;
        private double nameOffsetX = 0.0;
        private double nameOffsetY = 0.0;
        private double offsetX = 0.0;
        private double offsetY = 0.0;
        private String reactionId = null;
        private String speciesId = null;
        private List effectList = new LinkedList();

        EffectSiteInfo(Element elem) {
            this.id = Annotation.this.readStringAttr(elem, Annotation.ATTR_ID);
            this.name = Annotation.this.readStringAttr(elem, Annotation.ATTR_NAME);
            this.reactionId = Annotation.this.readStringAttr(elem, Annotation.ATTR_IDREF_REACTION);
            this.speciesId = Annotation.this.readStringAttr(elem, Annotation.ATTR_IDREF_SPECIES);
            this.offsetX = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_OFFSETX, this.offsetX);
            this.offsetY = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_OFFSETY, this.offsetY);
            this.nameOffsetX = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_NAMEOFFSETX, this.nameOffsetX);
            this.nameOffsetY = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_NAMEOFFSETY, this.nameOffsetY);
            NodeList childlist = elem.getChildNodes();
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Element e;
                String tag;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(Annotation.uri) && (tag = (e = (Element)node).getLocalName()).equals(Annotation.TAG_EFFECT)) {
                    this.effectList.add(new EffectInfo(e));
                }
                ++i;
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public double getNameOffsetX() {
            return this.nameOffsetX;
        }

        public double getNameOffsetY() {
            return this.nameOffsetY;
        }

        public double getOffsetX() {
            return this.offsetX;
        }

        public double getOffsetY() {
            return this.offsetY;
        }

        public String getReactionId() {
            return this.reactionId;
        }

        public String getSpeciesId() {
            return this.speciesId;
        }

        public List getEffectList() {
            return Collections.unmodifiableList(this.effectList);
        }
    }

    public class EffectTargetInfo {
        private String id;

        EffectTargetInfo(Element elem) {
            this.id = Annotation.this.readStringAttr(elem, Annotation.ATTR_IDREF_PROTEIN);
        }

        public String getId() {
            return this.id;
        }
    }

    public class ExternalConnectionInfo {
        private String residueIdrefInDOM;
        private int type;
        private boolean predefined;

        ExternalConnectionInfo(Element elem) {
            this.residueIdrefInDOM = Annotation.this.readStringAttr(elem, Annotation.ATTR_IDREF_RESIDUE);
            String str = Annotation.this.readStringAttr(elem, Annotation.ATTR_TYPE);
            this.type = ExternalCircleModel.getTypeFromString(str);
            String predef = Annotation.this.readStringAttr(elem, Annotation.ATTR_PREDEFINED);
            this.predefined = predef != null && predef.equalsIgnoreCase("true");
        }

        public String getIdref() {
            return this.residueIdrefInDOM;
        }

        public int getType() {
            return this.type;
        }

        public boolean isPredefined() {
            return this.predefined;
        }
    }

    public class ExternalNameInfo {
        private List connectionList = new LinkedList();
        private String id;
        private String name = null;
        private String proteinForMtv = null;
        private double nameOffsetX = 0.0;
        private double nameOffsetY = 0.0;
        private double offsetY = 0.0;

        ExternalNameInfo(Element elem) {
            this.id = Annotation.this.readStringAttr(elem, Annotation.ATTR_ID);
            this.name = Annotation.this.readStringAttr(elem, Annotation.ATTR_NAME);
            this.offsetY = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_OFFSETY, this.offsetY);
            this.nameOffsetX = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_NAMEOFFSETX, this.nameOffsetX);
            this.nameOffsetY = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_NAMEOFFSETY, this.nameOffsetY);
            this.proteinForMtv = Annotation.this.readStringAttr(elem, Annotation.ATTR_IDREF_PROTEIN);
            NodeList childlist = elem.getChildNodes();
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Element e;
                String tag;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(Annotation.uri) && (tag = (e = (Element)node).getLocalName()).equals(Annotation.TAG_LISTOFEXTCONNECTIONS)) {
                    this.loadListOfExtConnection(e);
                }
                ++i;
            }
        }

        private void loadListOfExtConnection(Element elem) {
            NodeList childlist = elem.getChildNodes();
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Element e;
                String tag;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(Annotation.uri) && (tag = (e = (Element)node).getLocalName()).equals(Annotation.TAG_EXTCONNECTION)) {
                    this.connectionList.add(new ExternalConnectionInfo(e));
                }
                ++i;
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public double getNameOffsetX() {
            return this.nameOffsetX;
        }

        public double getNameOffsetY() {
            return this.nameOffsetY;
        }

        public double getOffsetY() {
            return this.offsetY;
        }

        public String getProteinForMtv() {
            return this.proteinForMtv;
        }

        public List getConnectionList() {
            return Collections.unmodifiableList(this.connectionList);
        }
    }

    public class InternalLinkInfo {
        private String id;
        private int type;
        private LinkPointInfo start;
        private LinkPointInfo end;

        InternalLinkInfo(Element elem) {
            this.id = Annotation.this.readStringAttr(elem, Annotation.ATTR_ID);
            String str = Annotation.this.readStringAttr(elem, Annotation.ATTR_TYPE);
            this.type = InternalLinkModel.getTypeFromString(str);
            NodeList childlist = elem.getChildNodes();
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(Annotation.uri)) {
                    Element e = (Element)node;
                    String tag = e.getLocalName();
                    if (tag.equals(Annotation.TAG_STARTPOINT)) {
                        this.start = new LinkPointInfo(e);
                    } else if (tag.equals(Annotation.TAG_ENDPOINT)) {
                        this.end = new LinkPointInfo(e);
                    }
                }
                ++i;
            }
        }

        public String getId() {
            return this.id;
        }

        public int getType() {
            return this.type;
        }

        public LinkPointInfo getStartPoint() {
            return this.start;
        }

        public LinkPointInfo getEndPoint() {
            return this.end;
        }
    }

    public class LinkPointInfo {
        private Class target;
        private String idref;
        private double offsetX = 0.0;
        private double offsetY = 0.0;

        LinkPointInfo(Element elem) {
            this.offsetX = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_OFFSETX, this.offsetX);
            this.offsetY = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_OFFSETY, this.offsetY);
            String str = Annotation.this.readStringAttr(elem, Annotation.ATTR_IDREF_RESIDUE);
            if (str != null) {
                this.target = ResidueModel.class;
                this.idref = str;
                return;
            }
            str = Annotation.this.readStringAttr(elem, Annotation.ATTR_IDREF_BINDINGSITE);
            if (str != null) {
                this.target = BindingSiteModel.class;
                this.idref = str;
                return;
            }
            str = Annotation.this.readStringAttr(elem, Annotation.ATTR_IDREF_EFFECTSITE);
            if (str != null) {
                this.target = EffectSiteModel.class;
                this.idref = str;
                return;
            }
            str = Annotation.this.readStringAttr(elem, Annotation.ATTR_IDREF_OPERATOR);
            if (str != null) {
                this.target = OperatorModel.class;
                this.idref = str;
                return;
            }
            str = Annotation.this.readStringAttr(elem, Annotation.ATTR_IDREF_LINK);
            if (str != null) {
                this.target = InternalLinkModel.class;
                this.idref = str;
                return;
            }
            str = Annotation.this.readStringAttr(elem, Annotation.ATTR_IDREF_DEGRADE);
            if (str != null) {
                this.target = DegradeTriangleModel.class;
                this.idref = str;
                return;
            }
        }

        public double getOffsetX() {
            return this.offsetX;
        }

        public double getOffsetY() {
            return this.offsetY;
        }

        public Class getTarget() {
            return this.target;
        }

        public String getIdRef() {
            return this.idref;
        }
    }

    public class OperatorInfo {
        private String id;
        private int type;
        private int subType;
        private String value;
        private double valueOffsetX = 0.0;
        private double valueOffsetY = 0.0;
        private double offsetX = 0.0;
        private double offsetY = 0.0;

        OperatorInfo(Element elem) {
            this.id = Annotation.this.readStringAttr(elem, Annotation.ATTR_ID);
            this.offsetX = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_OFFSETX, this.offsetX);
            this.offsetY = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_OFFSETY, this.offsetY);
            String str = Annotation.this.readStringAttr(elem, Annotation.ATTR_TYPE);
            this.type = OperatorModel.getTypeFromString(str);
            if (this.type == 5) {
                str = Annotation.this.readStringAttr(elem, Annotation.ATTR_SUBTYPE);
                this.subType = OperatorThresholdModel.getRelationalOperatorTypeStringFromString(str);
            }
            NodeList childlist = elem.getChildNodes();
            int childsize = childlist.getLength();
            int i = 0;
            while (i < childsize) {
                Element e;
                String tag;
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals(Annotation.uri) && (tag = (e = (Element)node).getLocalName()).equals(Annotation.TAG_OPERATORVALUE)) {
                    this.value = Annotation.this.readStringAttr(e, Annotation.ATTR_VALUE);
                    this.valueOffsetX = Annotation.this.readDoubleAttr(e, Annotation.ATTR_OFFSETX, this.valueOffsetX);
                    this.valueOffsetY = Annotation.this.readDoubleAttr(e, Annotation.ATTR_OFFSETY, this.valueOffsetY);
                }
                ++i;
            }
        }

        public String getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }

        public double getOffsetX() {
            return this.offsetX;
        }

        public double getOffsetY() {
            return this.offsetY;
        }

        public int getSubType() {
            return this.subType;
        }

        public int getType() {
            return this.type;
        }

        public double getValueOffsetX() {
            return this.valueOffsetX;
        }

        public double getValueOffsetY() {
            return this.valueOffsetY;
        }
    }

    public class ResidueInfo {
        private String id;
        private String type;
        private String name = null;
        private double nameOffsetX = 0.0;
        private double nameOffsetY = 0.0;
        private double offsetX = 0.0;
        private String residueId = null;

        ResidueInfo(Element elem) {
            this.id = Annotation.this.readStringAttr(elem, Annotation.ATTR_ID);
            this.type = Annotation.this.readStringAttr(elem, Annotation.ATTR_TYPE);
            this.name = Annotation.this.readStringAttr(elem, Annotation.ATTR_NAME);
            this.residueId = Annotation.this.readStringAttr(elem, Annotation.ATTR_IDREF_RESIDUE);
            this.offsetX = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_OFFSETX, this.offsetX);
            this.nameOffsetX = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_NAMEOFFSETX, this.nameOffsetX);
            this.nameOffsetY = Annotation.this.readDoubleAttr(elem, Annotation.ATTR_NAMEOFFSETY, this.nameOffsetY);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public double getNameOffsetX() {
            return this.nameOffsetX;
        }

        public double getNameOffsetY() {
            return this.nameOffsetY;
        }

        public double getOffsetX() {
            return this.offsetX;
        }

        public String getResidueId() {
            return this.residueId;
        }

        public int getType() {
            return ResidueModel.getTypeFromString(this.type);
        }
    }
}

