/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractAction;
import jp.co.fujiric.star.gui.gef.ViewControllerImpl;
import jp.co.fujiric.star.gui.gef.swing.CompositeShapeVCImpl;
import jp.co.fujiric.star.gui.gef.swing.ShapeModelImpl;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasVC;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradeTriangleModel;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradeTriangleVC;
import jp.sbi.celldesigner.blockDiagram.diagram.EffectSiteModel;
import jp.sbi.celldesigner.blockDiagram.diagram.EffectSiteVC;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperationalException;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperationalModel;
import jp.sbi.celldesigner.blockDiagram.diagram.InternalOperatorTraceStack;
import jp.sbi.celldesigner.blockDiagram.table.ProteinActivity;
import jp.sbi.celldesigner.blockDiagram.table.TableColumnValue;

public class VerifyAction
extends AbstractAction {
    private CanvasVC canvasvc;

    public VerifyAction(CanvasVC canvasvc) {
        this.canvasvc = canvasvc;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Set speciesIdSet = this.canvasvc.getTableValues().getSpeciesIdSet();
        LinkedList shapes = this.getOutputSiteShapes();
        for (ShapeModelImpl shape : shapes) {
            this.doVerify(speciesIdSet, shape);
        }
    }

    private void doVerify(Set speciesIdSet, ShapeModelImpl shape) {
        if (shape instanceof EffectSiteModel) {
            EffectSiteModel esm;
            EffectSiteModel iom = esm = (EffectSiteModel)shape;
            ProteinActivity pa = esm.getProteinActivity();
            this.doVerify(speciesIdSet, iom, pa);
        } else {
            DegradeTriangleModel dtm;
            DegradeTriangleModel iom = dtm = (DegradeTriangleModel)shape;
            for (ProteinActivity pa : dtm.getProteinActivityList()) {
                this.doVerify(speciesIdSet, iom, pa);
            }
        }
    }

    private void doVerify(Set speciesIdSet, InternalOperationalModel iom, ProteinActivity pa) {
        String speciesId = pa.getSpeciesId();
        String reactionId = pa.getReactionId();
        for (String sid : speciesIdSet) {
            boolean expected = sid.equals(speciesId) ? pa.getExpectedBooleanValue() : false;
            this.doVerifyCell(iom, expected, sid, reactionId);
        }
        int irow = this.canvasvc.getTableValues().getTableRowIndexForReaction(reactionId);
        this.canvasvc.getTableValues().fireTableRowsUpdated(irow, irow);
    }

    private void doVerifyCell(InternalOperationalModel iom, boolean expected, String speciesId, String reactionId) {
        int verified = 2;
        try {
            double value = iom.getOperatedValue(new InternalOperatorTraceStack(speciesId));
            if (Double.isNaN(value)) {
                verified = 1;
            } else if (expected && value > 0.0 || !expected && value == 0.0) {
                verified = 0;
            }
        }
        catch (InternalOperationalException value) {
            // empty catch block
        }
        TableColumnValue tcv = this.canvasvc.getTableValues().getTalbeColumnValue(speciesId);
        ProteinActivity pa1 = tcv.getProteinActivity(reactionId);
        pa1.setTableCellErrorLevel(verified);
    }

    private LinkedList getOutputSiteShapes() {
        LinkedList<ShapeModelImpl> list = new LinkedList<ShapeModelImpl>();
        Iterator it = this.canvasvc.getSubsIterator();
        while (it.hasNext()) {
            ShapeModelImpl m;
            ViewControllerImpl vc1 = (ViewControllerImpl)it.next();
            if (!(vc1 instanceof CompositeShapeVCImpl) || (m = this.getOutputSiteModel(vc1)) == null) continue;
            list.addLast(m);
        }
        return list;
    }

    private ShapeModelImpl getOutputSiteModel(ViewControllerImpl vc) {
        Iterator it = vc.getSubsIterator();
        while (it.hasNext()) {
            DegradeTriangleModel dtm;
            ViewControllerImpl vc1 = (ViewControllerImpl)it.next();
            if (vc1 instanceof EffectSiteVC) {
                EffectSiteModel esm = (EffectSiteModel)vc1.getModel();
                if (esm.getProteinActivity() == null) continue;
                return esm;
            }
            if (!(vc1 instanceof DegradeTriangleVC) || (dtm = (DegradeTriangleModel)vc1.getModel()).getProteinActivityList() == null) continue;
            return dtm;
        }
        return null;
    }
}

