/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import jp.sbi.celldesigner.blockDiagram.BlockDiagramDialog;
import jp.sbi.celldesigner.blockDiagram.diagram.Annotation;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasModel;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasVC;
import jp.sbi.celldesigner.blockDiagram.table.TableValues;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;

public class UpdateAction
extends AbstractAction {
    private BlockDiagramDialog blockDiagramDialog;
    private CanvasVC canvasvc;
    private ModelAnnotation modelAnnotation;
    private Annotation annotation;
    private AbstractButton pointerButton;

    public UpdateAction(BlockDiagramDialog bdd, CanvasVC canvasvc, ModelAnnotation modelAnnotation, AbstractButton pointerButton) {
        this.blockDiagramDialog = bdd;
        this.canvasvc = canvasvc;
        this.modelAnnotation = modelAnnotation;
        this.annotation = (Annotation)modelAnnotation.getBlockDiagramAnnotation();
        this.pointerButton = pointerButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CanvasModel cm = (CanvasModel)this.canvasvc.getModel();
        boolean edited = cm.isEdited();
        TableValues tv = this.blockDiagramDialog.updateTableValues();
        this.canvasvc.setTableValues(tv);
        this.pointerButton.doClick();
        Annotation.BlockDiagramInfo bdinfo1 = this.annotation.createTemporaryBDInfo(tv, this.canvasvc);
        this.canvasvc.clearBlock();
        this.canvasvc.setupBlock(bdinfo1);
        this.pointerButton.doClick();
        this.blockDiagramDialog.updateTablePanel(tv);
        if (edited) {
            cm.setEdited();
        }
    }
}

