/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import jp.co.fujiric.star.gui.gef.ViewControllerImpl;
import jp.co.fujiric.star.gui.gef.swing.CircleVC;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteVC;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteWithLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.BindingSiteWithLinkVC;
import jp.sbi.celldesigner.blockDiagram.diagram.BlockModel;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasVC;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradeTriangleModel;
import jp.sbi.celldesigner.blockDiagram.diagram.DegradeTriangleVC;
import jp.sbi.celldesigner.blockDiagram.diagram.EffectSiteModel;
import jp.sbi.celldesigner.blockDiagram.diagram.EffectSiteVC;
import jp.sbi.celldesigner.blockDiagram.diagram.EffectSiteWithLinkModel;
import jp.sbi.celldesigner.blockDiagram.diagram.EffectSiteWithLinkVC;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalActivationCircleVC;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalInhibitionCircleVC;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalLinkWithCircleModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ExternalLinkWithCircleVC;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueVC;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueWithTailModel;
import jp.sbi.celldesigner.blockDiagram.diagram.ResidueWithTailVC;

public class HiliteSymbolsAction
extends AbstractAction {
    private CanvasVC canvasvc;
    private AbstractButton button;

    public HiliteSymbolsAction(CanvasVC canvasvc, AbstractButton button) {
        this.canvasvc = canvasvc;
        this.button = button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean hilited = this.button.isSelected();
        this.hiliteBindingSites(hilited);
        this.hiliteDegradeSymbols(hilited);
        this.hiliteEffectSites(hilited);
        this.hiliteResidues(hilited);
        this.hiliteExternalCircles(hilited);
    }

    private void hiliteExternalCircles(boolean hilited) {
        Iterator it = this.canvasvc.getSubsIterator();
        while (it.hasNext()) {
            ExternalLinkWithCircleModel m;
            ViewControllerImpl vc = (ViewControllerImpl)it.next();
            if (!(vc instanceof ExternalLinkWithCircleVC) || !(m = (ExternalLinkWithCircleModel)vc.getModel()).isPredefined()) continue;
            Iterator it1 = vc.getSubsIterator();
            while (it1.hasNext()) {
                CircleVC cvc;
                ViewControllerImpl vc1 = (ViewControllerImpl)it1.next();
                if (vc1 instanceof ExternalActivationCircleVC) {
                    cvc = (ExternalActivationCircleVC)vc1;
                    ((ExternalActivationCircleVC)cvc).setHilited(hilited);
                    continue;
                }
                if (!(vc1 instanceof ExternalInhibitionCircleVC)) continue;
                cvc = (ExternalInhibitionCircleVC)vc1;
                ((ExternalInhibitionCircleVC)cvc).setHilited(hilited);
            }
        }
    }

    private void hiliteResidues(boolean hilited) {
        Iterator it = this.canvasvc.getSubsIterator();
        while (it.hasNext()) {
            ResidueWithTailModel m;
            ResidueModel rm;
            ViewControllerImpl vc = (ViewControllerImpl)it.next();
            if (!(vc instanceof ResidueWithTailVC) || !(rm = (m = (ResidueWithTailModel)vc.getModel()).getResidueModel()).isPredefined()) continue;
            ResidueVC rvc = (ResidueVC)this.canvasvc.getFromShapeVCByModel(rm);
            rvc.setHilited(hilited);
        }
    }

    private void hiliteEffectSites(boolean hilited) {
        Iterator it = this.canvasvc.getSubsIterator();
        while (it.hasNext()) {
            EffectSiteWithLinkModel groupm;
            EffectSiteModel esm;
            ViewControllerImpl vc = (ViewControllerImpl)it.next();
            if (!(vc instanceof EffectSiteWithLinkVC) || !(esm = (groupm = (EffectSiteWithLinkModel)vc.getModel()).getEffectSiteModel()).isPredefined()) continue;
            EffectSiteVC esvc = (EffectSiteVC)this.canvasvc.getFromShapeVCByModel(esm);
            esvc.setHilited(hilited);
        }
    }

    private void hiliteDegradeSymbols(boolean hilited) {
        BlockModel bm = (BlockModel)this.canvasvc.getBlockvc().getModel();
        if (!bm.hasDegradeTriangleModel()) {
            return;
        }
        DegradeTriangleModel dtm = bm.getDegradeTriangleModel();
        if (dtm.isPredefined()) {
            DegradeTriangleVC dtvc = (DegradeTriangleVC)this.canvasvc.getFromShapeVCByModel(dtm);
            dtvc.setHilited(hilited);
        }
    }

    private void hiliteBindingSites(boolean hilited) {
        Iterator it = this.canvasvc.getSubsIterator();
        while (it.hasNext()) {
            BindingSiteWithLinkModel linkm;
            BindingSiteModel bsm;
            ViewControllerImpl vc = (ViewControllerImpl)it.next();
            if (!(vc instanceof BindingSiteWithLinkVC) || !(bsm = (linkm = (BindingSiteWithLinkModel)vc.getModel()).getBindingSiteModel()).isPredefined()) continue;
            BindingSiteVC bsvc = (BindingSiteVC)this.canvasvc.getFromShapeVCByModel(bsm);
            bsvc.setHilited(hilited);
        }
    }
}

