/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram.actions;

import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JRootPane;
import jp.fric.io.util.FilePather;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasVC;

public class ExportImageAction
extends AbstractAction {
    private CanvasVC canvasvc;
    private AbstractButton pointerButton;

    public ExportImageAction(CanvasVC canvasvc, AbstractButton pointerButton) {
        this.canvasvc = canvasvc;
        this.pointerButton = pointerButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int type;
        File file = this.getFile();
        if (file == null) {
            return;
        }
        String extension = this.getExtension(file);
        if (!this.getSupport(extension)) {
            return;
        }
        if (extension.matches("(p|P)(n|N)(g|G)")) {
            type = 3;
        } else if (extension.matches("(j|J)(p|P)(e|E)?(g|G)")) {
            type = 1;
        } else {
            return;
        }
        BufferedImage bi = this.canvasvc.getBufferedImage(type);
        try {
            ImageIO.write((RenderedImage)bi, extension, file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private File getFile() {
        String modelname = this.canvasvc.getTableValues().getBlockName();
        FilePather imageFilePather = MainWindow.getLastInstance().getExportFilePather();
        JRootPane c = this.canvasvc.getGuiComponent().getRootPane();
        File file = imageFilePather.getUserSelection(c, 2, new int[]{201, 200, 999}, modelname);
        return file;
    }

    private String getExtension(File file) {
        String filepath = file.getPath();
        String extension = "";
        int dotposition = filepath.lastIndexOf(".");
        if (dotposition != -1) {
            extension = filepath.substring(dotposition + 1);
        }
        return extension;
    }

    private boolean getSupport(String extension) {
        String[] formats = ImageIO.getWriterFormatNames();
        int i = 0;
        while (i < formats.length) {
            if (extension.equals(formats[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

