/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner.blockDiagram;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import jp.co.fujiric.star.gui.swing.IconUtil;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.blockDiagram.actions.ApplyChangesAction;
import jp.sbi.celldesigner.blockDiagram.actions.BindingSiteAction;
import jp.sbi.celldesigner.blockDiagram.actions.DegradePlaceAction;
import jp.sbi.celldesigner.blockDiagram.actions.DeleteAction;
import jp.sbi.celldesigner.blockDiagram.actions.EffectSiteAction;
import jp.sbi.celldesigner.blockDiagram.actions.ExportImageAction;
import jp.sbi.celldesigner.blockDiagram.actions.ExternalLinkAction;
import jp.sbi.celldesigner.blockDiagram.actions.HiliteSymbolsAction;
import jp.sbi.celldesigner.blockDiagram.actions.InternalLinkAction;
import jp.sbi.celldesigner.blockDiagram.actions.OperatorPlaceAction;
import jp.sbi.celldesigner.blockDiagram.actions.PointerAction;
import jp.sbi.celldesigner.blockDiagram.actions.PrintAction;
import jp.sbi.celldesigner.blockDiagram.actions.ResiduePlaceAction;
import jp.sbi.celldesigner.blockDiagram.actions.UpdateAction;
import jp.sbi.celldesigner.blockDiagram.actions.VerifyAction;
import jp.sbi.celldesigner.blockDiagram.diagram.Annotation;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasModel;
import jp.sbi.celldesigner.blockDiagram.diagram.CanvasVC;
import jp.sbi.celldesigner.blockDiagram.table.MainTable;
import jp.sbi.celldesigner.blockDiagram.table.RowHeaderTable;
import jp.sbi.celldesigner.blockDiagram.table.TableValues;
import jp.sbi.celldesigner.blockDiagram.table.TableValuesFactory;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.celldesigner.util.AKBorderLayout;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfReactions;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;

public class BlockDiagramDialog
extends JDialog {
    private CanvasVC canvasvc;
    private ModelAnnotation annotation;
    private SBase sb;
    private SBModel sbmodel;
    private String sbaseId;
    private AbstractButton pointerButton = new JToggleButton(IconUtil.getIcon(BlockDiagramDialog.class, "pointer.png"));
    private JButton applyChangesButton = new JButton("apply");
    private ApplyChangesAction applyChangesAction;
    private JPanel tablePanel;

    public BlockDiagramDialog(Dialog d, TableValues tv, ModelAnnotation annotation, SBase sb, SBModel sbmodel) throws HeadlessException {
        super(d);
        this.myInit(tv, annotation, sb, sbmodel);
    }

    public BlockDiagramDialog(Frame f, TableValues tv, ModelAnnotation annotation, SBase sb, SBModel sbmodel) throws HeadlessException {
        super(f);
        this.myInit(tv, annotation, sb, sbmodel);
    }

    private void myInit(TableValues tv, ModelAnnotation annotation, SBase sb, SBModel sbmodel) {
        this.annotation = annotation;
        this.sb = sb;
        this.sbmodel = sbmodel;
        this.sbaseId = tv.getSBaseId();
        this.setupBasePane(tv);
        this.setupMainPanel(tv);
        this.setupToolbars();
        this.setModal(false);
        this.pack();
    }

    private void setupBasePane(TableValues tv) {
        this.setTitle("BlockDiagramDialog " + tv.getTitle());
        JComponent c = (JComponent)this.getContentPane();
        c.setLayout(new AKBorderLayout());
        c.setPreferredSize(new Dimension(480, 500));
    }

    private void setupToolbars() {
        ButtonGroup bg = new ButtonGroup();
        this.setupToolbar1(bg);
        this.setupToolbar2(bg);
        this.setupToolbar3(bg);
        this.setupToolbar4(bg);
        this.setupToolbar5();
    }

    private void setButtonsToTB(ButtonGroup bg, JToolBar tb, Vector v, String placement) {
        Insets zeroInsets = new Insets(0, 0, 0, 0);
        int i = 0;
        while (i < v.size()) {
            AbstractButton b = (AbstractButton)v.elementAt(i);
            b.setMargin(zeroInsets);
            tb.add(b);
            if (bg != null) {
                bg.add(b);
            }
            ++i;
        }
        this.getContentPane().add((Component)tb, placement);
    }

    private JToolBar prepareToolBar() {
        JToolBar tb = new JToolBar();
        Insets zeroInsets = new Insets(0, 0, 0, 0);
        tb.setMargin(zeroInsets);
        tb.setRollover(true);
        return tb;
    }

    private void setupToolbar1(ButtonGroup bg) {
        JToolBar tb = this.prepareToolBar();
        Vector<AbstractButton> v = new Vector<AbstractButton>();
        v.addElement(this.pointerButton);
        this.pointerButton.setFocusable(false);
        this.pointerButton.addActionListener(new PointerAction(this.canvasvc));
        this.pointerButton.setToolTipText("pointer");
        this.pointerButton.doClick();
        JToggleButton b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "residuep.png"));
        b.addActionListener(new ResiduePlaceAction(this.canvasvc, 1));
        b.setToolTipText("phosphorylated residue");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "residueac.png"));
        b.addActionListener(new ResiduePlaceAction(this.canvasvc, 2));
        b.setToolTipText("acetylated residue");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "residueub.png"));
        b.addActionListener(new ResiduePlaceAction(this.canvasvc, 3));
        b.setToolTipText("ubiquitinated residue");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "residueme.png"));
        b.addActionListener(new ResiduePlaceAction(this.canvasvc, 4));
        b.setToolTipText("methylated residue");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "residueoh.png"));
        b.addActionListener(new ResiduePlaceAction(this.canvasvc, 5));
        b.setToolTipText("hydroxylated residue");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "residueempty.png"));
        b.addActionListener(new ResiduePlaceAction(this.canvasvc, 6));
        b.setToolTipText("empty residue");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "residuedontcare.png"));
        b.addActionListener(new ResiduePlaceAction(this.canvasvc, 7));
        b.setToolTipText("don't care");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "residueunknown.png"));
        b.addActionListener(new ResiduePlaceAction(this.canvasvc, 8));
        b.setToolTipText("unknown");
        v.addElement(b);
        this.setButtonsToTB(bg, tb, v, "North");
    }

    private void setupToolbar2(ButtonGroup bg) {
        JToolBar tb = this.prepareToolBar();
        Vector<JToggleButton> v = new Vector<JToggleButton>();
        JToggleButton b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "sitebinding.png"));
        b.addActionListener(new BindingSiteAction(this.canvasvc));
        b.setToolTipText("binding site");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "siteeffect.png"));
        b.addActionListener(new EffectSiteAction(this.canvasvc));
        b.setToolTipText("effect site");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "degrade.png"));
        b.addActionListener(new DegradePlaceAction(this.canvasvc, this.pointerButton));
        b.setToolTipText("degrade");
        v.addElement(b);
        this.setButtonsToTB(bg, tb, v, "North");
    }

    private void setupToolbar3(ButtonGroup bg) {
        JToolBar tb = this.prepareToolBar();
        Vector<JToggleButton> v = new Vector<JToggleButton>();
        JToggleButton b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "operatorand.png"));
        b.addActionListener(new OperatorPlaceAction(this.canvasvc, 1));
        b.setToolTipText("and");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "operatoror.png"));
        b.addActionListener(new OperatorPlaceAction(this.canvasvc, 2));
        b.setToolTipText("or");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "operatoradd.png"));
        b.addActionListener(new OperatorPlaceAction(this.canvasvc, 3));
        b.setToolTipText("add");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "residuedontcare.png"));
        b.addActionListener(new OperatorPlaceAction(this.canvasvc, 4));
        b.setToolTipText("multiply");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "operatorthreshold.png"));
        b.addActionListener(new OperatorPlaceAction(this.canvasvc, 5));
        b.setToolTipText("threshold");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "operatorautoactivate.png"));
        b.addActionListener(new OperatorPlaceAction(this.canvasvc, 6));
        b.setToolTipText("auto activate");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "operatorassign.png"));
        b.addActionListener(new OperatorPlaceAction(this.canvasvc, 7));
        b.setToolTipText("assign");
        v.addElement(b);
        this.setButtonsToTB(bg, tb, v, "North");
    }

    private void setupToolbar4(ButtonGroup bg) {
        JToolBar tb = this.prepareToolBar();
        Vector<JToggleButton> v = new Vector<JToggleButton>();
        JToggleButton b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "activation.png"));
        b.addActionListener(new InternalLinkAction(this.canvasvc, 1));
        b.setToolTipText("activation");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "absoluteactivation.png"));
        b.addActionListener(new InternalLinkAction(this.canvasvc, 2));
        b.setToolTipText("absolute activation");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "inhibition.png"));
        b.addActionListener(new InternalLinkAction(this.canvasvc, 3));
        b.setToolTipText("inhibition");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "absoluteinhibition.png"));
        b.addActionListener(new InternalLinkAction(this.canvasvc, 4));
        b.setToolTipText("absolute inhibition");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "extactivation.png"));
        b.addActionListener(new ExternalLinkAction(this.canvasvc, 1));
        b.setToolTipText("external activation");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "extactivationmaybe.png"));
        b.addActionListener(new ExternalLinkAction(this.canvasvc, 2));
        b.setToolTipText("external activation maybe");
        v.addElement(b);
        b = new JToggleButton(null, IconUtil.getIcon(BlockDiagramDialog.class, "extinhibition.png"));
        b.addActionListener(new ExternalLinkAction(this.canvasvc, 3));
        b.setToolTipText("external inhibition");
        v.addElement(b);
        this.setButtonsToTB(bg, tb, v, "North");
    }

    private void setupToolbar5() {
        JToolBar tb = this.prepareToolBar();
        Vector<AbstractButton> v = new Vector<AbstractButton>();
        AbstractButton b = new JButton(IconUtil.getIcon(BlockDiagramDialog.class, "delete.png"));
        b.addActionListener(new DeleteAction(this.canvasvc));
        b.setFocusable(false);
        b.setToolTipText("delete selected shapes");
        v.addElement(b);
        b = new JButton(IconUtil.getIcon(BlockDiagramDialog.class, "export.png"));
        b.addActionListener(new ExportImageAction(this.canvasvc, this.pointerButton));
        b.setFocusable(false);
        b.setToolTipText("export image file");
        v.addElement(b);
        b = new JButton(IconUtil.getIcon(BlockDiagramDialog.class, "print.png"));
        b.addActionListener(new PrintAction(this.canvasvc));
        b.setFocusable(false);
        b.setToolTipText("print block diagram");
        v.addElement(b);
        b = new JToggleButton(IconUtil.getIcon(BlockDiagramDialog.class, "hilitesymbols.png"));
        b.addActionListener(new HiliteSymbolsAction(this.canvasvc, b));
        b.setFocusable(false);
        b.setToolTipText("highlight symbols that are derived from the process diagram");
        v.addElement(b);
        this.setButtonsToTB(null, tb, v, "North");
    }

    private void setupMainPanel(TableValues tv) {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JSplitPane sp = new JSplitPane(0);
        sp.setResizeWeight(1.0);
        JComponent c1 = this.createCanvasPanel(tv);
        this.tablePanel = this.createTablePanel(tv);
        sp.add((Component)c1, "top");
        sp.add((Component)this.tablePanel, "bottom");
        JPanel p3 = this.createButtonPanel();
        p.add((Component)sp, "Center");
        p.add((Component)p3, "South");
        this.getContentPane().add((Component)p, "Center");
    }

    private JPanel createButtonPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JButton b = new JButton("verify");
        b.addActionListener(new VerifyAction(this.canvasvc));
        b.setToolTipText("verify the internal connections and show erros on the truth table");
        c.insets = new Insets(5, 5, 5, 20);
        p.add((Component)b, c);
        b = new JButton("update");
        b.addActionListener(new UpdateAction(this, this.canvasvc, this.annotation, this.pointerButton));
        b.setToolTipText("update using the changes of the process diagram");
        c.gridx = 1;
        c.insets = new Insets(5, 5, 5, 0);
        p.add((Component)b, c);
        this.applyChangesAction = new ApplyChangesAction(this.canvasvc, this.annotation, this.pointerButton, this.sbmodel);
        this.applyChangesButton.addActionListener(this.applyChangesAction);
        this.applyChangesButton.setToolTipText("apply changes");
        c.gridx = 2;
        c.insets = new Insets(5, 5, 5, 0);
        p.add((Component)this.applyChangesButton, c);
        b = new JButton("close");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean ans = BlockDiagramDialog.this.doClose();
                if (!ans) {
                    return;
                }
                BlockDiagramDialog.this.cancel();
            }
        });
        b.setToolTipText("close this dialog");
        c.gridx = 3;
        p.add((Component)b, c);
        return p;
    }

    public TableValues updateTableValues() {
        Model model = this.sbmodel.getModel();
        ListOfReactions rl = model.getListOfReactions();
        ListOfSpecies sl = model.getListOfSpecies();
        TableValues tv = TableValuesFactory.createTableValues(this.sb, (ListOf)rl, (ListOf)sl, this.sbmodel);
        return tv;
    }

    private JPanel createTablePanel(TableValues tv) {
        JPanel pane = new JPanel();
        pane.setPreferredSize(new Dimension(400, 180));
        pane.setLayout(new BorderLayout());
        this.setupTablePanel(pane, tv);
        return pane;
    }

    private void setupTablePanel(JPanel pane, TableValues tv) {
        MainTable table = new MainTable(tv);
        table.setTableHeader(new JTableHeader(table.getColumnModel()){

            @Override
            public String getToolTipText() {
                return "species";
            }
        });
        JViewport jvp = new JViewport();
        jvp.setView(new RowHeaderTable(tv));
        TableScrollPane jsp = new TableScrollPane(table);
        jsp.setRowHeader(jvp);
        pane.add((Component)jsp, "Center");
        pane.setPreferredSize(new Dimension(400, 100));
    }

    public void updateTablePanel(TableValues tv) {
        this.tablePanel.removeAll();
        this.setupTablePanel(this.tablePanel, tv);
        this.pack();
        this.tablePanel.repaint();
    }

    private JComponent createCanvasPanel(TableValues tv) {
        CanvasModel cm = new CanvasModel(tv);
        this.canvasvc = new CanvasVC();
        this.canvasvc.initializevc(cm, (Annotation)this.annotation.getBlockDiagramAnnotation(), this.applyChangesButton);
        JComponent p = this.canvasvc.getGuiComponent();
        p.setPreferredSize(this.canvasvc.getInitialPreferredSize());
        CanvasScrollPane jsp = new CanvasScrollPane(this.canvasvc);
        return jsp;
    }

    private boolean doClose() {
        CanvasModel cm = (CanvasModel)this.canvasvc.getModel();
        if (cm.isEdited()) {
            int ans = JOptionPane.showConfirmDialog(null, "Block diagram has been changed. Apply the changes?", "Confirmation", 1);
            if (ans == 0) {
                this.applyChangesAction.actionPerformed(null);
            } else {
                if (ans == 2) {
                    return false;
                }
                if (ans != 1) {
                    return false;
                }
            }
        }
        return true;
    }

    private void cancel() {
        this.annotation.removeBlockDiagramDialog(this.sbaseId);
        this.dispose();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        boolean ans;
        if (e.getID() == 201 && !(ans = this.doClose())) {
            return;
        }
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.cancel();
        }
    }

    class CanvasScrollPane
    extends JScrollPane {
        private CanvasVC vc;
        private JComponent c;

        public CanvasScrollPane(CanvasVC vc) {
            super(vc.getGuiComponent());
            this.vc = vc;
            this.c = vc.getGuiComponent();
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int maxh;
                    int maxw;
                    Dimension maxcd;
                    int w = CanvasScrollPane.this.getViewport().getWidth();
                    int h = CanvasScrollPane.this.getViewport().getHeight();
                    Dimension cd = CanvasScrollPane.this.c.getPreferredSize();
                    if (!cd.equals(maxcd = new Dimension(maxw = w < cd.width ? cd.width : w, maxh = h < cd.height ? cd.height : h))) {
                        CanvasScrollPane.this.c.setPreferredSize(maxcd);
                        CanvasScrollPane.this.c.setSize(maxcd);
                    }
                }
            });
        }
    }

    class TableScrollPane
    extends JScrollPane {
        private MainTable mt;

        public TableScrollPane(MainTable table) {
            super(table);
            this.mt = table;
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = TableScrollPane.this.getViewport().getWidth();
                    if (w >= TableScrollPane.this.mt.getMinWidth()) {
                        TableScrollPane.this.mt.setAutoResizeMode(4);
                    } else {
                        TableScrollPane.this.mt.setAutoResizeMode(0);
                    }
                }
            });
        }
    }
}

