/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.SpeciesShape;
import jp.sbi.celldesigner.sbmlExtension.SameIDAutoTag;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public abstract class SpeciesPropertyDialog
extends JDialog {
    public static final int CHANGE_ALL = 1;
    public static final int CHANGE_ONE_IN_ALL = 2;
    public static final int CHANGE_ONE = 3;
    JFrame owner;
    SBModel sbmodel;
    private boolean isFirstShowing = true;
    private SpeciesAlias showingSpecieAlias = null;

    public SpeciesPropertyDialog(JFrame owner, SBModel sbmodel) {
        super(owner);
        this.owner = owner;
        this.sbmodel = sbmodel;
    }

    public void releaseAll() {
        this.sbmodel = null;
        this.owner = null;
    }

    @Override
    public void show() {
        if (this.isFirstShowing) {
            Point p = this.owner.getLocation();
            Dimension he = this.owner.getSize();
            Dimension me = this.getSize();
            int x = p.x + (he.width - me.width) / 2;
            int y = p.y + (he.height - me.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.setLocation(x, y);
            this.isFirstShowing = false;
        }
        super.show();
    }

    public boolean setTarget(SpeciesAlias alias) {
        SpeciesShape shape = (SpeciesShape)((Object)alias.getGFramedShape());
        SpeciesProperty property = shape.getProperty().deepClone();
        boolean isValid = this.setSpeciesProperty(property);
        this.showingSpecieAlias = isValid ? alias : null;
        return isValid;
    }

    public boolean notifyApply(SpeciesProperty newProperty, SameIDAutoTag newautotag) {
        block13: {
            if (this.showingSpecieAlias == null) {
                JOptionPane.showMessageDialog(this, "showingSpecieAlias is null", "Error", 2);
                return true;
            }
            Species species = this.showingSpecieAlias.getOriginalSpecies();
            if (species == null) {
                JOptionPane.showMessageDialog(this, "original species of alias is null", "Error", 2);
                return true;
            }
            int flag = 3;
            SpeciesAnnotation sExt = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null);
            if (sExt.getReferingAliases().size() > 1) {
                String msg = "Do you want to reflect the change to all the same species in this model?";
                String title = "The same species exists.";
                int ans = JOptionPane.showConfirmDialog(this, msg, title, 1, 3, null);
                if (ans == 2) {
                    return false;
                }
                if (ans == 0) {
                    flag = 1;
                }
                if (ans == 1) {
                    flag = 2;
                }
            }
            try {
                try {
                    this.sbmodel.eventGroupBegan(null);
                    this.sbmodel.changeSpeciesAliasStructuralStateAngle(this.showingSpecieAlias, newProperty, flag);
                    this.sbmodel.changeSpeciesProperty(this.showingSpecieAlias, newProperty, flag);
                    if (newautotag == null) break block13;
                    this.sbmodel.changeSpeciesAutoTagAngle(this.showingSpecieAlias, newautotag, flag);
                    try {
                        this.sbmodel.getGStructure().reconfirmSameIDAutoTagNeedToPaint();
                        this.sbmodel.getSbframe().repaintLogicalArea(this.sbmodel.getSbframe().getLogicalViewArea());
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exception) {
                    this.sbmodel.eventGroupEnded(null);
                }
            }
            finally {
                this.sbmodel.eventGroupEnded(null);
            }
        }
        return true;
    }

    public abstract boolean setSpeciesProperty(SpeciesProperty var1);

    public abstract void updateDialog();

    protected SpeciesAlias getShowingSpecieAlias() {
        return this.showingSpecieAlias;
    }
}

