/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GElement;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.SpeciesShape;
import jp.sbi.celldesigner.sbmlExtension.Notes;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.XMLNode;

public class SpeciesProfile {
    private SpeciesProperty property = null;
    private String compartment = "";
    private int positionToCompartment = 0;
    private String complexSpecies = "";
    private Notes notes = null;
    private XMLNode annotation = null;

    private SpeciesProfile() {
    }

    public static SpeciesProfile createProfile(SpeciesAlias alias) throws Exception {
        SpeciesProfile profile = new SpeciesProfile();
        SpeciesShape shape = (SpeciesShape)((Object)alias.getGFramedShape());
        profile.property = shape.getProperty();
        GContainer container = alias.getContainer();
        if (container == null) {
            profile.compartment = "default";
            profile.positionToCompartment = 4;
        } else if (container instanceof CompartmentAlias) {
            CompartmentAlias outsideAlias = (CompartmentAlias)((Object)container);
            Compartment c = outsideAlias.getOriginalCompartment();
            if (c == null) {
                throw new Exception("[SpeciesProfile]createProfile(), original compartment is null, alias=" + ((GElement)((Object)outsideAlias)).getName());
            }
            profile.compartment = c.getId();
            profile.positionToCompartment = ((GContainer)((Object)outsideAlias)).includes(alias);
        } else if (container instanceof ComplexSpeciesAlias) {
            ComplexSpeciesAlias complex = (ComplexSpeciesAlias)container;
            Species s = complex.getOriginalSpecies();
            if (s == null) {
                throw new Exception("[SpeciesProfile]createProfile(), original species is null, alias=" + complex.getName());
            }
            profile.complexSpecies = s.getId();
        }
        Species sp = alias.getOriginalSpecies();
        if (sp != null) {
            profile.notes = (Notes)LibSBMLUtil.getNotes((SBase)sp, null);
            if (sp.getAnnotationString() != null) {
                XMLNode node;
                profile.annotation = node = XMLNode.convertStringToXMLNode((String)sp.getAnnotationString());
            }
        }
        return profile;
    }

    public static SpeciesProfile createProfile(Species species) {
        SpeciesProfile profile = new SpeciesProfile();
        SpeciesAnnotation sExt = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null);
        profile.property = sExt.getSpeciesProperty();
        profile.compartment = species.getCompartment();
        profile.positionToCompartment = sExt.getPositionToCompartment();
        profile.complexSpecies = sExt.getComplexSpecies();
        profile.notes = (Notes)LibSBMLUtil.getNotes((SBase)species, null);
        if (species != null && species.getAnnotationString() != null) {
            XMLNode node;
            profile.annotation = node = XMLNode.convertStringToXMLNode((String)species.getAnnotationString());
        }
        return profile;
    }

    public void setSpeciesProperty(SpeciesProperty property) {
        this.property = property;
    }

    public SpeciesProperty getSpeciesProperty() {
        return this.property;
    }

    public void setCompartment(String compartment) {
        this.compartment = compartment;
    }

    public String getCompartment() {
        return this.compartment;
    }

    public void setPositionToCompartment(int i) {
        this.positionToCompartment = i;
    }

    public int getPositionToCompartment() {
        return this.positionToCompartment;
    }

    public String toString() {
        String s = "SpeciesProfile: Compartment(" + this.compartment + ":" + SpeciesAnnotation.getPositionString(this.positionToCompartment) + ")/ ComplexSpecies(" + this.complexSpecies + ")/";
        s = this.property == null ? String.valueOf(s) + "property==null" : String.valueOf(s) + this.property.toString();
        return s;
    }

    public boolean corresponds(SpeciesProfile profile) {
        if (this.property.equals(profile.property)) {
            if (this.compartment.equals(profile.compartment)) {
                if (this.positionToCompartment == profile.positionToCompartment) {
                    if (this.complexSpecies.equals(profile.complexSpecies)) {
                        return true;
                    }
                    if (Preference.isDebug) {
                        System.out.println("complexSpecies not equals");
                    }
                } else if (Preference.isDebug) {
                    System.out.println("positionToCompartment not equals");
                }
            } else if (Preference.isDebug) {
                System.out.println("compartment not equals");
            }
        } else if (Preference.isDebug) {
            System.out.println("property not equals");
        }
        return false;
    }

    public String getComplexSpecies() {
        return this.complexSpecies;
    }

    public void setComplexSpecies(String complexSpecies) {
        this.complexSpecies = complexSpecies;
    }

    public Notes getNotes() {
        return this.notes;
    }

    public static Species createSpeciesWith(SpeciesProfile profile) throws Exception {
        Species s = new Species();
        SpeciesAnnotation sa = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)s, null);
        s.setCompartment(profile.compartment);
        sa.setPositionToCompartment(profile.positionToCompartment);
        sa.setComplexSpecies(profile.complexSpecies);
        sa.setSpeciesProperty(profile.property.deepClone());
        return s;
    }

    public void setNotes(Notes newnotes) {
        this.notes = newnotes;
    }

    public XMLNode getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(XMLNode annotation) {
        this.annotation = annotation;
    }
}

