/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jp.sbi.celldesigner.MainWindow;

public class SpeciesAliasPopupMenu
extends JPopupMenu {
    private static SpeciesAliasPopupMenu uniqueInstance = null;
    private HashMap menuReservoir = null;

    private SpeciesAliasPopupMenu() {
    }

    public static SpeciesAliasPopupMenu getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new SpeciesAliasPopupMenu();
            uniqueInstance.initItems();
            int menucount = uniqueInstance.getComponentCount();
            int i = 0;
            while (i < menucount) {
                uniqueInstance.getComponent(i).setVisible(true);
                ++i;
            }
        }
        return uniqueInstance;
    }

    private void initItems() {
        MainWindow mw = MainWindow.getLastInstance();
        if (mw == null) {
            return;
        }
        Class[] actionClasses = new Class[]{MainWindow.ChangeIdentityAction.class, MainWindow.InfoBoxEditAction.class, MainWindow.OpenSBMLEditDialogAction.class, MainWindow.OpenProteinEtcEditDialogAction.class, MainWindow.GeneralNotesAction.class, MainWindow.ProteinNotesAction.class, MainWindow.ChangeColorAndShapeAction.class, MainWindow.ChangeSpeciesNameFontSize.class, MainWindow.AddTextAction.class};
        this.menuReservoir = new HashMap();
        int i = 0;
        while (i < actionClasses.length) {
            MainWindow.MyAbstractAction action = mw.getAction(actionClasses[i]);
            if (action != null) {
                JMenuItem menu = new JMenuItem(action);
                this.add(menu);
                this.menuReservoir.put(actionClasses[i], menu);
            }
            if (actionClasses[i] == MainWindow.OpenProteinEtcEditDialogAction.class || actionClasses[i] == MainWindow.ProteinNotesAction.class) {
                this.addSeparator();
            }
            ++i;
        }
        JMenu changeComplexViewMenu = mw.getChangeComplexViewMenu();
        this.add(changeComplexViewMenu);
        this.setItemText(MainWindow.OpenSBMLEditDialogAction.class, "Edit Species...");
        this.setItemText(MainWindow.OpenProteinEtcEditDialogAction.class, "Edit...");
        this.setItemText(MainWindow.GeneralNotesAction.class, "Species Notes...");
        this.setItemText(MainWindow.ProteinNotesAction.class, "Notes...");
    }

    public void setItemText(Class cl, String text) {
        JMenuItem menu = (JMenuItem)this.menuReservoir.get(cl);
        if (menu != null) {
            menu.setText(text);
        }
    }

    public void changeUnitInfoBoxActionShow(boolean enabled) {
        Action action = ((JMenuItem)this.menuReservoir.get(MainWindow.InfoBoxEditAction.class)).getAction();
        action.setEnabled(enabled);
    }

    public void changeEditSpeciesActionEnable(boolean enabled) {
        Action action = ((JMenuItem)this.menuReservoir.get(MainWindow.OpenSBMLEditDialogAction.class)).getAction();
        action.setEnabled(enabled);
    }
}

