/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jp.sbi.celldesigner.Preference;

public class SetIconSizeDialog
extends JDialog {
    private static SetIconSizeDialog instance = null;
    private JPanel dialogPanel;
    private JPanel buttonPanel;
    private JButton buttonOK;
    private JButton buttonClose;
    private ButtonGroup radioGrp = new ButtonGroup();
    private JRadioButton radioSmall = new JRadioButton(" 16X16 Pixel");
    private JRadioButton radioLarge = new JRadioButton(" 24X24 Pixel");
    private int dialogWidth = 200;
    private int dialogHeight = 150;

    public static SetIconSizeDialog getInstance(Frame frame) {
        if (instance == null) {
            instance = new SetIconSizeDialog(frame);
        }
        return instance;
    }

    private SetIconSizeDialog(Frame frame) {
        super(frame);
        this.init();
    }

    private void init() {
        this.setModal(true);
        this.setTitle("Icon Size Setting");
        this.setSize(this.dialogWidth, this.dialogHeight);
        this.setResizable(false);
        this.setContentPane(this.getDialogPanel());
    }

    private JPanel getDialogPanel() {
        int x = 40;
        int y = 20;
        int width = this.dialogWidth;
        int height = 15;
        int space = 10;
        if (this.dialogPanel == null) {
            this.dialogPanel = new JPanel();
            this.dialogPanel.setLayout(null);
            this.radioSmall.setName(String.valueOf(16));
            this.radioSmall.setBounds(new Rectangle(x, y, width, height));
            this.radioGrp.add(this.radioSmall);
            this.dialogPanel.add(this.radioSmall);
            this.radioLarge.setName(String.valueOf(24));
            this.radioLarge.setBounds(new Rectangle(x, y + height + space, width, height));
            this.radioGrp.add(this.radioLarge);
            this.dialogPanel.add(this.radioLarge);
            this.dialogPanel.add((Component)this.getButtonPanel(), "South");
            this.resetRadio();
        }
        return this.dialogPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBounds(new Rectangle(0, 70, this.dialogWidth, 35));
            this.buttonOK = new JButton("OK");
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SetIconSizeDialog.this.getSelectedIconSize();
                    SetIconSizeDialog.this.setVisible(false);
                }
            });
            this.buttonClose = new JButton("Close");
            this.buttonClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SetIconSizeDialog.this.resetRadio();
                    SetIconSizeDialog.this.dispose();
                }
            });
            this.buttonPanel.add(this.buttonOK);
            this.buttonPanel.add(this.buttonClose);
        }
        return this.buttonPanel;
    }

    private void resetRadio() {
        this.radioSmall.setSelected(false);
        this.radioLarge.setSelected(false);
        if (Preference.iconSize == 24) {
            this.radioLarge.setSelected(true);
        } else {
            this.radioSmall.setSelected(true);
        }
    }

    private int getSelectedIconSize() {
        Enumeration<AbstractButton> em = this.radioGrp.getElements();
        while (em.hasMoreElements()) {
            JRadioButton radioBtn = (JRadioButton)em.nextElement();
            if (!radioBtn.isSelected()) continue;
            Preference.iconSize = Integer.parseInt(radioBtn.getName());
        }
        return Preference.iconSize;
    }
}

