/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.sbi.celldesigner.MainWindow;

public class SelectResidueModificationDialog
extends JDialog {
    private static SelectResidueModificationDialog instance = null;
    private JPanel dialogPanel;
    private JPanel buttonPanel;
    private JButton buttonOK;
    private JButton buttonClose;
    private JComboBox comboModification = new JComboBox();
    private int dialogWidth = 260;
    private int dialogHeight = 150;
    private boolean isOK = false;
    private String modificationState = "empty";

    public static SelectResidueModificationDialog getInstance(Frame frame) {
        if (instance == null) {
            instance = new SelectResidueModificationDialog(frame);
        }
        return instance;
    }

    public boolean isOK() {
        return this.isOK;
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.doClose();
            return;
        }
        super.processWindowEvent(e);
    }

    public String getSelectedModification() {
        return this.modificationState;
    }

    private SelectResidueModificationDialog(Frame frame) {
        super(frame);
        this.init();
    }

    private void init() {
        this.setModal(true);
        this.setTitle("Select Residue Modification");
        this.setLocation(350, 300);
        this.setSize(this.dialogWidth, this.dialogHeight);
        this.setResizable(false);
        this.setContentPane(this.getDialogPanel());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SelectResidueModificationDialog.this.buttonOK.requestFocusInWindow();
            }
        });
    }

    private JPanel getDialogPanel() {
        int x = 50;
        int y = 10;
        int height = 20;
        int space = 5;
        if (this.dialogPanel == null) {
            this.dialogPanel = new JPanel();
            this.dialogPanel.setLayout(null);
            JLabel stateLabel = new JLabel("Residue Modification Type");
            stateLabel.setBounds(new Rectangle(x, y, 180, height));
            this.dialogPanel.add(stateLabel);
            this.comboModification.setBounds(new Rectangle(x, y + height + space, 160, 20));
            this.setComboBoxValues();
            this.dialogPanel.add(this.comboModification);
            this.dialogPanel.add((Component)this.getButtonPanel(), "South");
        }
        return this.dialogPanel;
    }

    private void setComboBoxValues() {
        this.comboModification.addItem("empty");
        this.comboModification.addItem("phosphorylated");
        this.comboModification.addItem("acetylated");
        this.comboModification.addItem("ubiquitinated");
        this.comboModification.addItem("methylated");
        this.comboModification.addItem("hydroxylated");
        this.comboModification.addItem("glycosylated");
        this.comboModification.addItem("myristoylated");
        this.comboModification.addItem("palmytoylated");
        this.comboModification.addItem("prenylated");
        this.comboModification.addItem("protonated");
        this.comboModification.addItem("sulfated");
        this.comboModification.addItem("don't care");
        this.comboModification.addItem("unknown");
        this.comboModification.setSelectedIndex(0);
        this.comboModification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectResidueModificationDialog.this.buttonOK.requestFocusInWindow();
            }
        });
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBounds(new Rectangle(0, 70, this.dialogWidth, 35));
            this.buttonOK = new JButton("OK");
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectResidueModificationDialog.this.doOK();
                }
            });
            this.buttonClose = new JButton("Cancel");
            this.buttonClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectResidueModificationDialog.this.doClose();
                }
            });
            this.buttonPanel.add(this.buttonOK);
            this.buttonPanel.add(this.buttonClose);
        }
        return this.buttonPanel;
    }

    private void doOK() {
        this.isOK = true;
        this.modificationState = (String)this.comboModification.getSelectedItem();
        this.setVisible(false);
    }

    private void doClose() {
        this.isOK = false;
        this.resetComboBox();
        this.dispose();
    }

    private void resetComboBox() {
        MainWindow mWin = MainWindow.getLastInstance();
        mWin.resetComboBox();
    }
}

