/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import jp.fric.graphics.draw.GColoredShape;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GLinkedCurveAndLine;
import jp.fric.graphics.draw.GMouseInterpreter;
import jp.fric.graphics.draw.GPointedShape;
import jp.fric.graphics.draw.PaintScheme;
import jp.fric.graphics.draw.PaintSchemeFactory;
import jp.sbi.celldesigner.ColorChangeListener;
import jp.sbi.celldesigner.CompartmentSymbol;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MyColorChooser;
import jp.sbi.celldesigner.PainterChangeListener;
import jp.sbi.celldesigner.PainterChooser;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.ReactionSymbol;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SBSymbolEditDialog;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.symbol.color.CompartmentColorScheme;
import jp.sbi.celldesigner.symbol.color.ReactionColorScheme;
import jp.sbi.celldesigner.symbol.color.SpeciesColorScheme;
import jp.sbi.celldesigner.symbol.compartment.Membrane;

public class SBSymbolPaletteDialog
extends JDialog {
    private MainWindow mainwindow = null;
    private static final String DEFAULT_TITLE = "Palette option";
    private SpeciesPanel speciesPanel = null;
    private CompartmentPanel compartmentPanel = null;
    private ReactionPanel reactionPanel = null;
    private GridSizePanel gridSizePanel = null;
    private NoOptionPanel noOptionPanel = null;
    private boolean isFirstShowing = true;
    private final Insets INSETS = SBSymbolEditDialog.INSETS;
    private final Dimension PREVIEW = SBSymbolEditDialog.PREVIEW;
    private final Dimension PAINTER = SBSymbolEditDialog.PAINTER;
    private final Dimension CHOOSER = SBSymbolEditDialog.CHOOSER;
    private final Dimension BUTTONS = SBSymbolEditDialog.BUTTONS;
    private final Dimension THICKNESS = SBSymbolEditDialog.THICKNESS;
    private final Dimension LINEWIDTH = SBSymbolEditDialog.LINEWIDTH;
    private final Dimension LINE = SBSymbolEditDialog.LINE;
    private final Dimension SIZE = SBSymbolEditDialog.SIZE;
    private final Dimension LINETYPE = SBSymbolEditDialog.LINETYPE;
    private static final int SPECIES_PANEL = 1;
    private static final int GRID_SIZE_PANEL = 2;
    private static final int NO_OPTION_PANEL = 3;
    private static final int COMPARTMENT_PANEL = 4;
    private static final int REACTION_PANEL = 5;

    public SBSymbolPaletteDialog(MainWindow mainwindow) {
        super(mainwindow);
        this.mainwindow = mainwindow;
        this.setResizable(false);
        this.setModal(false);
        this.setTitle(DEFAULT_TITLE);
        this.speciesPanel = new SpeciesPanel();
        this.speciesPanel.setOpaque(true);
        this.compartmentPanel = new CompartmentPanel();
        this.reactionPanel = new ReactionPanel();
        this.gridSizePanel = new GridSizePanel();
        this.noOptionPanel = new NoOptionPanel();
        super.addNotify();
    }

    @Override
    public void show() {
        if (this.isFirstShowing) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension me = this.getSize();
            this.setLocation(screen.width - me.width, 0);
            this.isFirstShowing = false;
        }
        super.show();
    }

    public void showGridSizePanel(GMouseInterpreter mouseInterpreter) {
        this.setTitle("Setting of grid snap size");
        this.gridSizePanel.initPanel(mouseInterpreter);
        this.setPanel(2);
    }

    public void setPanel(Object obj) {
        if (obj instanceof SpeciesSymbol) {
            this.speciesPanel.setSpeciesSymbol((SpeciesSymbol)obj);
            this.setTitle("Defaut setting of " + ((SBSymbol)obj).getCode());
            this.setPanel(1);
        } else if (obj instanceof CompartmentSymbol) {
            this.compartmentPanel.setCompartmentSymbol((CompartmentSymbol)obj);
            this.setTitle("Defaut setting of " + ((SBSymbol)obj).getCode());
            this.setPanel(4);
        } else if (obj instanceof ReactionSymbol) {
            this.reactionPanel.setReactionSymbol((ReactionSymbol)obj);
            this.setTitle("Defaut setting of " + ((SBSymbol)obj).getCode());
            this.setPanel(5);
        } else {
            this.setTitle(DEFAULT_TITLE);
            this.setPanel(3);
        }
    }

    private void setPanel(int target) {
        Container c = this.getContentPane();
        boolean isSpeciesPanelAdded = false;
        boolean isCompartmentPanelAdded = false;
        boolean isReactionPanelAdded = false;
        boolean isGridSizePanelAdded = false;
        boolean isNoOptionPanelAdded = false;
        Component[] comp = c.getComponents();
        int i = 0;
        while (i < comp.length) {
            if (comp[i] == this.speciesPanel) {
                isSpeciesPanelAdded = true;
            }
            if (comp[i] == this.compartmentPanel) {
                isCompartmentPanelAdded = true;
            }
            if (comp[i] == this.reactionPanel) {
                isReactionPanelAdded = true;
            }
            if (comp[i] == this.gridSizePanel) {
                isGridSizePanelAdded = true;
            }
            if (comp[i] == this.noOptionPanel) {
                isNoOptionPanelAdded = true;
            }
            ++i;
        }
        switch (target) {
            case 1: {
                if (!isSpeciesPanelAdded) {
                    if (isCompartmentPanelAdded) {
                        c.remove(this.compartmentPanel);
                    }
                    if (isReactionPanelAdded) {
                        c.remove(this.reactionPanel);
                    }
                    if (isGridSizePanelAdded) {
                        c.remove(this.gridSizePanel);
                    }
                    if (isNoOptionPanelAdded) {
                        c.remove(this.noOptionPanel);
                    }
                    c.add((Component)this.speciesPanel, "Center");
                    this.pack();
                    Insets insets = this.getInsets();
                    Dimension paneldim = this.speciesPanel.getPreferredSize();
                    Dimension size = new Dimension(insets.left + insets.right + paneldim.width, insets.top + insets.bottom + paneldim.height);
                    this.setSize(size);
                }
                this.validate();
                break;
            }
            case 4: {
                if (!isCompartmentPanelAdded) {
                    if (isSpeciesPanelAdded) {
                        c.remove(this.speciesPanel);
                    }
                    if (isReactionPanelAdded) {
                        c.remove(this.reactionPanel);
                    }
                    if (isGridSizePanelAdded) {
                        c.remove(this.gridSizePanel);
                    }
                    if (isNoOptionPanelAdded) {
                        c.remove(this.noOptionPanel);
                    }
                    c.add((Component)this.compartmentPanel, "Center");
                    this.pack();
                    Insets insets = this.getInsets();
                    Dimension paneldim = this.compartmentPanel.getPreferredSize();
                    Dimension size = new Dimension(insets.left + insets.right + paneldim.width, insets.top + insets.bottom + paneldim.height);
                    this.setSize(size);
                }
                this.validate();
                break;
            }
            case 5: {
                if (!isReactionPanelAdded) {
                    if (isSpeciesPanelAdded) {
                        c.remove(this.speciesPanel);
                    }
                    if (isCompartmentPanelAdded) {
                        c.remove(this.compartmentPanel);
                    }
                    if (isGridSizePanelAdded) {
                        c.remove(this.gridSizePanel);
                    }
                    if (isNoOptionPanelAdded) {
                        c.remove(this.noOptionPanel);
                    }
                    c.add((Component)this.reactionPanel, "Center");
                    this.pack();
                    Insets insets = this.getInsets();
                    Dimension paneldim = this.reactionPanel.getPreferredSize();
                    Dimension size = new Dimension(insets.left + insets.right + paneldim.width, insets.top + insets.bottom + paneldim.height);
                    this.setSize(size);
                }
                this.validate();
                break;
            }
            case 2: {
                if (!isGridSizePanelAdded) {
                    if (isSpeciesPanelAdded) {
                        c.remove(this.speciesPanel);
                    }
                    if (isCompartmentPanelAdded) {
                        c.remove(this.compartmentPanel);
                    }
                    if (isReactionPanelAdded) {
                        c.remove(this.reactionPanel);
                    }
                    if (isNoOptionPanelAdded) {
                        c.remove(this.noOptionPanel);
                    }
                    c.add((Component)this.gridSizePanel, "Center");
                    this.pack();
                    Insets insets = this.getInsets();
                    Dimension paneldim = this.gridSizePanel.getPreferredSize();
                    Dimension size = new Dimension(insets.left + insets.right + paneldim.width, insets.top + insets.bottom + paneldim.height);
                    this.setSize(size);
                }
                this.validate();
                break;
            }
            case 3: {
                if (!isNoOptionPanelAdded) {
                    if (isSpeciesPanelAdded) {
                        c.remove(this.speciesPanel);
                    }
                    if (isCompartmentPanelAdded) {
                        c.remove(this.compartmentPanel);
                    }
                    if (isReactionPanelAdded) {
                        c.remove(this.reactionPanel);
                    }
                    if (isGridSizePanelAdded) {
                        c.remove(this.gridSizePanel);
                    }
                    this.setSize(280, 210);
                    c.add((Component)this.noOptionPanel, "Center");
                }
                this.validate();
            }
        }
        this.repaint();
    }

    private class CompartmentPanel
    extends JPanel {
        KeyAdapter keyListener;
        JPanel previewPanel = null;
        PainterChooser painterPanel = null;
        MyColorChooser chooser = null;
        JPanel buttonPanel = null;
        final int width = 150;
        final int height = 100;
        CompartmentSymbol symbol = null;
        Membrane membrane = null;
        Color color = null;
        PaintScheme painter = null;
        private JTextField defaultThicknessField;
        private JTextField outerLineWidthField;
        private JTextField innerLineWidthField;
        private JButton initButton;
        private JButton applyButton;
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");

        public CompartmentPanel() {
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    CompartmentPanel.this.updateSize();
                }
            };
            super.setLayout(null);
            int x = ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.left;
            int y = ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.top;
            this.previewPanel = new JPanel();
            this.previewPanel.setBounds(x, y, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PREVIEW.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PREVIEW.height);
            this.previewPanel.setBackground(Color.white);
            this.previewPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Preview"));
            this.add((Component)this.previewPanel, null);
            JPanel thicknessPanel = new JPanel(null);
            thicknessPanel.setBounds(x += ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PREVIEW.width + 6, y, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).THICKNESS.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).THICKNESS.height);
            thicknessPanel.setOpaque(false);
            thicknessPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Membrane"));
            this.add((Component)thicknessPanel, null);
            JLabel labelThicknessField = new JLabel("Thickness");
            labelThicknessField.setBounds(10, 20, 70, 20);
            thicknessPanel.add((Component)labelThicknessField, null);
            this.defaultThicknessField = new JTextField();
            this.defaultThicknessField.setBounds(80, 20, 40, 20);
            this.defaultThicknessField.setEditable(true);
            this.defaultThicknessField.addKeyListener(this.keyListener);
            thicknessPanel.add((Component)this.defaultThicknessField, null);
            JPanel lineWidthPanel = new JPanel(null);
            lineWidthPanel.setOpaque(false);
            lineWidthPanel.setBounds(x, y += ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).THICKNESS.height, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).LINEWIDTH.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).LINEWIDTH.height);
            lineWidthPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Line Width"));
            this.add((Component)lineWidthPanel, null);
            JLabel labelThickWidthField = new JLabel("Outer");
            labelThickWidthField.setBounds(10, 20, 40, 20);
            lineWidthPanel.add((Component)labelThickWidthField, null);
            this.outerLineWidthField = new JTextField();
            this.outerLineWidthField.setBounds(50, 20, 40, 20);
            this.outerLineWidthField.setEditable(true);
            this.outerLineWidthField.addKeyListener(this.keyListener);
            lineWidthPanel.add((Component)this.outerLineWidthField, null);
            JLabel labelThinWidthField = new JLabel("Inner");
            labelThinWidthField.setBounds(110, 20, 40, 20);
            lineWidthPanel.add((Component)labelThinWidthField, null);
            this.innerLineWidthField = new JTextField();
            this.innerLineWidthField.setBounds(150, 20, 40, 20);
            this.innerLineWidthField.setEditable(true);
            this.innerLineWidthField.addKeyListener(this.keyListener);
            lineWidthPanel.add((Component)this.innerLineWidthField, null);
            this.painterPanel = new PainterChooser();
            this.painterPanel.setOpaque(false);
            this.painterPanel.setBounds(x, y += ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).LINEWIDTH.height, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PAINTER.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PAINTER.height);
            this.painterPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Paint"));
            this.add((Component)this.painterPanel, null);
            this.painterPanel.addPainterChangeListener(new PainterChangeListener(){

                @Override
                public void painterChanged(String command) {
                    CompartmentPanel.this.painter_painterChangeDetected(command);
                }
            });
            x = ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.left;
            y = ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.top + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PREVIEW.height;
            this.chooser = new MyColorChooser();
            this.chooser.setBounds(x, y, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).CHOOSER.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).CHOOSER.height);
            this.chooser.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Color"));
            this.add((Component)this.chooser, null);
            this.chooser.addColorChangeListener(new ColorChangeListener(){

                @Override
                public void colorChanged(Color colorin) {
                    CompartmentPanel.this.chooser_colorChangeDetected(colorin);
                }
            });
            this.buttonPanel = new JPanel(new FlowLayout());
            this.buttonPanel.setBounds(x, y += ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).CHOOSER.height, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).BUTTONS.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).BUTTONS.height);
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.buttonPanel, null);
            this.initButton = new JButton("Restore Default");
            this.initButton.setMnemonic(68);
            this.initButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompartmentPanel.this.initButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.initButton, null);
            this.applyButton = new JButton("Apply");
            this.applyButton.setMnemonic(65);
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompartmentPanel.this.applyButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.applyButton, null);
            this.okButton.setMnemonic(79);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompartmentPanel.this.okButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.okButton, null);
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompartmentPanel.this.cancelButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.cancelButton, null);
            this.setPreferredSize(new Dimension(((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.left + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.right + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).CHOOSER.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.top + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.bottom + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PREVIEW.height + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).CHOOSER.height + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).BUTTONS.height));
        }

        private void updateSize() {
            String thick_str = this.defaultThicknessField.getText();
            String w1_str = this.outerLineWidthField.getText();
            String w2_str = this.innerLineWidthField.getText();
            if (thick_str.equals("") || w1_str.equals("") || w2_str.equals("")) {
                return;
            }
            double thickness = this.membrane.getThickness();
            double outerLineWidth = this.membrane.getOuterLineWidth();
            double innerLineWidth = this.membrane.getInnerLineWidth();
            double input_thick = 0.0;
            double input_w1 = 0.0;
            double input_w2 = 0.0;
            try {
                input_thick = Double.parseDouble(thick_str);
                input_w1 = Double.parseDouble(w1_str);
                input_w2 = Double.parseDouble(w2_str);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "input must be a number.", "bad number", 2);
                this.defaultThicknessField.setText("" + thickness);
                this.outerLineWidthField.setText("" + outerLineWidth);
                this.innerLineWidthField.setText("" + innerLineWidth);
                return;
            }
            if (input_thick <= 0.0 || input_w1 <= 0.0 || input_w2 <= 0.0) {
                JOptionPane.showMessageDialog(this, "input must be > 0.", "bad number", 2);
                this.defaultThicknessField.setText("" + thickness);
                this.outerLineWidthField.setText("" + outerLineWidth);
                this.innerLineWidthField.setText("" + innerLineWidth);
                return;
            }
            this.membrane.setThickness(input_thick);
            this.membrane.setOuterLineWidth(input_w1);
            this.membrane.setInnerLineWidth(input_w2);
            this.repaint();
        }

        public void setCompartmentSymbol(CompartmentSymbol symbol) {
            this.symbol = symbol;
            String code = ((SBSymbol)((Object)symbol)).getCode();
            this.initialize(CompartmentColorScheme.getMembrane(code), CompartmentColorScheme.getColor(code), CompartmentColorScheme.getScheme(code));
        }

        private void initialize(Membrane membranein, Color colorin, PaintScheme painterin) {
            this.membrane = membranein;
            this.defaultThicknessField.setText(Double.toString(this.membrane.getThickness()));
            this.outerLineWidthField.setText(Double.toString(this.membrane.getOuterLineWidth()));
            this.innerLineWidthField.setText(Double.toString(this.membrane.getInnerLineWidth()));
            this.color = colorin;
            this.chooser.setColor(this.color);
            this.painter = painterin;
            this.painterPanel.setSelected(this.painter.getCode());
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.symbol != null) {
                Graphics2D g2 = (Graphics2D)g;
                Dimension d = this.previewPanel.getSize();
                Insets i = new Insets(8, 3, 3, 4);
                Rectangle bounds = this.previewPanel.getBounds();
                double cx = (double)(bounds.x + i.left) + (double)(d.width - i.left - i.right) / 2.0;
                double cy = (double)(bounds.y + i.top) + (double)(d.height - i.top - i.bottom) / 2.0;
                this.symbol.setMembrane(this.membrane);
                ((GColoredShape)((Object)this.symbol)).setColor(this.color);
                ((GColoredShape)((Object)this.symbol)).setPaintScheme(this.painter);
                if (this.symbol instanceof GFramedShape) {
                    double x = cx - 75.0;
                    double y = cy - 50.0;
                    ((GFramedShape)((Object)this.symbol)).updateShape(x, y, 150.0, 100.0);
                    ((GFramedShape)((Object)this.symbol)).drawShape(g2, 1);
                } else if (this.symbol instanceof GPointedShape) {
                    Rectangle2D.Double rect = new Rectangle2D.Double();
                    rect.setFrame(bounds.x + i.left, bounds.y + i.top, d.width - i.left - i.right, d.height - i.top - i.bottom);
                    ((GPointedShape)((Object)this.symbol)).updateShape(cx, cy, rect);
                    ((GPointedShape)((Object)this.symbol)).drawShape(g2, 1);
                }
            }
        }

        private void initButton_actionPerformed(ActionEvent e) {
            String code = ((SBSymbol)((Object)this.symbol)).getCode();
            this.membrane = CompartmentColorScheme.resetMembrane(code);
            this.color = CompartmentColorScheme.resetColor(code);
            this.painter = CompartmentColorScheme.resetScheme(code);
            this.defaultThicknessField.setText(Double.toString(this.membrane.getThickness()));
            this.outerLineWidthField.setText(Double.toString(this.membrane.getOuterLineWidth()));
            this.innerLineWidthField.setText(Double.toString(this.membrane.getInnerLineWidth()));
            this.chooser.setColor(this.color);
            this.painterPanel.setSelected(this.painter.getCode());
            this.repaint();
        }

        private void applyButton_actionPerformed(ActionEvent e) {
            boolean bShowMsg;
            String w2_str;
            String w1_str;
            String thick_str = this.defaultThicknessField.getText();
            if (!this.membrane.isAllHaveBeenInputed(thick_str, w1_str = this.outerLineWidthField.getText(), w2_str = this.innerLineWidthField.getText(), bShowMsg = true)) {
                return;
            }
            if (!this.membrane.isValid(bShowMsg)) {
                return;
            }
            String code = ((SBSymbol)((Object)this.symbol)).getCode();
            CompartmentColorScheme.setMembrane(code, this.membrane);
            CompartmentColorScheme.setColor(code, this.color);
            CompartmentColorScheme.setScheme(code, this.painter);
        }

        private void okButton_actionPerformed(ActionEvent e) {
            boolean bShowMsg;
            String w2_str;
            String w1_str;
            String thick_str = this.defaultThicknessField.getText();
            if (!this.membrane.isAllHaveBeenInputed(thick_str, w1_str = this.outerLineWidthField.getText(), w2_str = this.innerLineWidthField.getText(), bShowMsg = true)) {
                return;
            }
            if (!this.membrane.isValid(bShowMsg)) {
                return;
            }
            String code = ((SBSymbol)((Object)this.symbol)).getCode();
            CompartmentColorScheme.setMembrane(code, this.membrane);
            CompartmentColorScheme.setColor(code, this.color);
            CompartmentColorScheme.setScheme(code, this.painter);
            SBSymbolPaletteDialog.this.dispose();
        }

        private void cancelButton_actionPerformed(ActionEvent e) {
            this.defaultThicknessField.setText("");
            this.outerLineWidthField.setText("");
            this.innerLineWidthField.setText("");
            this.chooser.setColor(null);
            this.painterPanel.setSelected(null);
            SBSymbolPaletteDialog.this.dispose();
        }

        private void chooser_colorChangeDetected(Color colorin) {
            this.color = colorin;
            this.repaint();
        }

        private void painter_painterChangeDetected(String code) {
            String scheme = PaintSchemeFactory.getName(code);
            this.painter = PaintSchemeFactory.create(scheme);
            this.repaint();
        }
    }

    private class GridSizePanel
    extends JPanel {
        private final Insets INSETS = new Insets(4, 4, 4, 4);
        private final Dimension PANEL = new Dimension(240, 100);
        private final Dimension BUTTONS = new Dimension(240, 34);
        static final int DEFAULT_W = 10;
        static final int DEFAULT_H = 10;
        KeyAdapter keyListener;
        JPanel previewPanel;
        int w = 10;
        int h = 10;
        Line2D.Double line = new Line2D.Double();
        private JTextField defaultWidthField;
        private JTextField defaultHeightField;
        private JButton initButton;
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");

        public GridSizePanel() {
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    GridSizePanel.this.updateSize();
                }
            };
            super.setLayout(null);
            int x = this.INSETS.left;
            int y = this.INSETS.top;
            this.previewPanel = new JPanel();
            this.previewPanel.setBounds(new Rectangle(x, y, this.PANEL.width, this.PANEL.height));
            Border etched = BorderFactory.createEtchedBorder();
            this.previewPanel.setBorder(etched);
            this.add((Component)this.previewPanel, null);
            JLabel labelWidthField = new JLabel("Width");
            labelWidthField.setBounds(new Rectangle(x + 10, y += this.PANEL.height + 10, 40, 20));
            this.add((Component)labelWidthField, null);
            this.defaultWidthField = new JTextField();
            this.defaultWidthField.setBounds(new Rectangle(x + 50, y, 60, 20));
            this.defaultWidthField.setEditable(true);
            this.defaultWidthField.addKeyListener(this.keyListener);
            this.add((Component)this.defaultWidthField, null);
            JLabel labelHeightField = new JLabel("Height");
            labelHeightField.setBounds(new Rectangle(x + 125, y, 45, 20));
            this.add((Component)labelHeightField, null);
            this.defaultHeightField = new JTextField();
            this.defaultHeightField.setBounds(new Rectangle(x + 170, y, 60, 20));
            this.defaultHeightField.setEditable(true);
            this.defaultHeightField.addKeyListener(this.keyListener);
            this.add((Component)this.defaultHeightField, null);
            this.initButton = new JButton("Init");
            this.initButton.setMnemonic(73);
            this.initButton.setBounds(new Rectangle(x, y += this.BUTTONS.height, 80, 25));
            this.initButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GridSizePanel.this.initButton_actionPerformed(e);
                }
            });
            this.add((Component)this.initButton, null);
            this.okButton.setMnemonic(79);
            this.okButton.setBounds(new Rectangle(x + 80, y, 70, 25));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GridSizePanel.this.okButton_actionPerformed(e);
                }
            });
            this.add((Component)this.okButton, null);
            this.cancelButton.setMnemonic(67);
            this.cancelButton.setBounds(new Rectangle(x + 150, y, 90, 25));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GridSizePanel.this.cancelButton_actionPerformed(e);
                }
            });
            this.add((Component)this.cancelButton, null);
            this.setPreferredSize(new Dimension(this.INSETS.left + this.INSETS.right + this.PANEL.width, this.INSETS.top + this.INSETS.bottom + this.PANEL.height + 2 * this.BUTTONS.height + 10));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSize() {
            GridSizePanel gridSizePanel = this;
            synchronized (gridSizePanel) {
                String w_str = this.defaultWidthField.getText();
                String h_str = this.defaultHeightField.getText();
                if (w_str.equals("") || h_str.equals("")) {
                    return;
                }
                int input_w = 0;
                int input_h = 0;
                try {
                    input_w = Integer.parseInt(w_str);
                    input_h = Integer.parseInt(h_str);
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "input must be a number.", "bad number", 2);
                    this.defaultWidthField.setText("" + this.w);
                    this.defaultHeightField.setText("" + this.h);
                    return;
                }
                if (input_w <= 0 || input_h <= 0) {
                    JOptionPane.showMessageDialog(this, "input must be > 0.", "bad number", 2);
                    this.defaultWidthField.setText("" + this.w);
                    this.defaultHeightField.setText("" + this.h);
                    return;
                }
                if (this.w > 0 && this.h > 0) {
                    this.w = input_w;
                    this.h = input_h;
                    this.repaint();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initPanel(GMouseInterpreter mouseInterpreter) {
            GridSizePanel gridSizePanel = this;
            synchronized (gridSizePanel) {
                this.w = (int)mouseInterpreter.getGridWidth();
                this.h = (int)mouseInterpreter.getGridHeight();
                this.defaultWidthField.setText("" + this.w);
                this.defaultHeightField.setText("" + this.h);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            GridSizePanel gridSizePanel = this;
            synchronized (gridSizePanel) {
                super.paint(g);
                Graphics2D g2 = (Graphics2D)g;
                Rectangle r = this.previewPanel.getBounds();
                g2.setClip(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
                g2.setColor(Color.white);
                g2.fill(r);
                g2.setColor(SBModelFrame.GRID_COLOR);
                Dimension d = this.getSize();
                double maxX = d.width;
                double maxY = d.height;
                double x = 0.0;
                while (x < maxX) {
                    this.line.setLine(x, 0.0, x, maxY);
                    g2.draw(this.line);
                    x += (double)this.w;
                }
                double y = 0.0;
                while (y < maxY) {
                    this.line.setLine(0.0, y, maxX, y);
                    g2.draw(this.line);
                    y += (double)this.h;
                }
            }
        }

        private void initButton_actionPerformed(ActionEvent e) {
            this.w = 10;
            this.h = 10;
            this.defaultWidthField.setText("" + this.w);
            this.defaultHeightField.setText("" + this.h);
            this.repaint();
        }

        private void okButton_actionPerformed(ActionEvent e) {
            if (SBSymbolPaletteDialog.this.mainwindow != null) {
                SBSymbolPaletteDialog.this.mainwindow.changeGridSize(this.w, this.h);
            }
            SBSymbolPaletteDialog.this.dispose();
        }

        private void cancelButton_actionPerformed(ActionEvent e) {
            this.defaultWidthField.setText("");
            this.defaultHeightField.setText("");
            SBSymbolPaletteDialog.this.dispose();
        }
    }

    private class NoOptionPanel
    extends JPanel {
        private NoOptionPanel() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.drawString("Selected tool has no option.", 0, 12);
        }
    }

    private class ReactionPanel
    extends JPanel {
        KeyAdapter keyListener;
        JPanel previewPanel = null;
        JPanel linePanel = null;
        MyColorChooser chooser = null;
        JPanel buttonPanel = null;
        ReactionSymbol symbol = null;
        Color color = null;
        double lineWidth = 0.0;
        private JTextField lineWidthField;
        private JButton initButton;
        private JButton applyButton;
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");
        private JRadioButton curveLineButton;
        private JRadioButton straightLineButton;
        private JPanel lineTypePanel;

        public ReactionPanel() {
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    ReactionPanel.this.updateSize();
                }
            };
            super.setLayout(null);
            int x = ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.left;
            int y = ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.top;
            this.previewPanel = new JPanel();
            this.previewPanel.setBounds(new Rectangle(x, y, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PREVIEW.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PREVIEW.height));
            this.previewPanel.setBackground(Color.white);
            this.previewPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Preview"));
            this.add((Component)this.previewPanel, null);
            this.linePanel = new JPanel();
            this.linePanel.setLayout(null);
            this.linePanel.setOpaque(false);
            this.linePanel.setBounds(x += ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PREVIEW.width + 6, y, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).LINE.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).LINE.height);
            this.linePanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Line"));
            this.add((Component)this.linePanel, null);
            JLabel labelLineWidthField = new JLabel("Width");
            labelLineWidthField.setBounds(10, 20, 40, 20);
            this.linePanel.add((Component)labelLineWidthField, null);
            this.lineWidthField = new JTextField();
            this.lineWidthField.setBounds(50, 20, 40, 20);
            this.lineWidthField.setEditable(true);
            this.lineWidthField.addKeyListener(this.keyListener);
            this.linePanel.add((Component)this.lineWidthField, null);
            this.lineTypePanel = new JPanel();
            this.lineTypePanel.setLayout(null);
            this.lineTypePanel.setOpaque(false);
            this.lineTypePanel.setBounds(x, y += this.linePanel.getHeight() + 4, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).LINETYPE.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).LINETYPE.height);
            this.lineTypePanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Type"));
            this.lineTypePanel.setVisible(false);
            this.add((Component)this.lineTypePanel, null);
            this.straightLineButton = new JRadioButton("Straight Line");
            this.curveLineButton = new JRadioButton("Curve Line");
            this.straightLineButton.setBounds(25, 20, 150, 20);
            this.curveLineButton.setBounds(25, 44, 150, 20);
            ButtonGroup activeGroup = new ButtonGroup();
            activeGroup.add(this.straightLineButton);
            activeGroup.add(this.curveLineButton);
            this.lineTypePanel.add((Component)this.straightLineButton, null);
            this.lineTypePanel.add((Component)this.curveLineButton, null);
            x = ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.left;
            y = ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.top + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PREVIEW.height;
            this.chooser = new MyColorChooser();
            this.chooser.setBounds(x, y, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).CHOOSER.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).CHOOSER.height);
            this.chooser.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Color"));
            this.add((Component)this.chooser, null);
            this.chooser.addColorChangeListener(new ColorChangeListener(){

                @Override
                public void colorChanged(Color colorin) {
                    ReactionPanel.this.chooser_colorChangeDetected(colorin);
                }
            });
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBounds(x, y += ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).CHOOSER.height, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).BUTTONS.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).BUTTONS.height);
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.buttonPanel, null);
            this.initButton = new JButton("Restore Default");
            this.initButton.setMnemonic(68);
            this.initButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactionPanel.this.initButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.initButton, null);
            this.applyButton = new JButton("Apply");
            this.applyButton.setMnemonic(65);
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactionPanel.this.applyButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.applyButton, null);
            this.okButton.setMnemonic(79);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactionPanel.this.okButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.okButton, null);
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactionPanel.this.cancelButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.cancelButton, null);
            this.setPreferredSize(new Dimension(((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.left + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.right + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).CHOOSER.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.top + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.bottom + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PREVIEW.height + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).CHOOSER.height + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).BUTTONS.height));
        }

        private void updateSize() {
            String linew_str = this.lineWidthField.getText();
            if (linew_str.equals("")) {
                return;
            }
            double input_linew = 0.0;
            try {
                input_linew = Double.parseDouble(linew_str);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "input must be a number.", "bad number", 2);
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                return;
            }
            if (input_linew < 0.0) {
                JOptionPane.showMessageDialog(this, "line width must be >= 0.", "bad number", 2);
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                return;
            }
            if (input_linew >= 0.0) {
                this.lineWidth = input_linew;
                this.repaint();
            }
        }

        public void setReactionSymbol(ReactionSymbol symbol) {
            this.symbol = symbol;
            String code = ((SBSymbol)((Object)symbol)).getCode();
            this.initialize(ReactionColorScheme.getLineWidth(code), ReactionColorScheme.getColor(code), ReactionColorScheme.getLineType(code), code);
            this.lineTypePanel.setVisible(symbol instanceof GLinkedCurveAndLine);
        }

        protected void initialize(double linewidth, Color colorin, int lineType, String code) {
            this.color = colorin;
            this.chooser.setColor(this.color);
            this.lineWidth = linewidth;
            this.lineWidthField.setText(Double.toString(this.lineWidth));
            if (code.equals("UNKNOWN")) {
                this.lineWidthField.setEnabled(false);
            } else {
                this.lineWidthField.setEnabled(true);
            }
            this.straightLineButton.setSelected(lineType == 1);
            this.curveLineButton.setSelected(lineType == 0);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.symbol != null) {
                Graphics2D g2 = (Graphics2D)g;
                Dimension d = this.previewPanel.getSize();
                Rectangle bounds = this.previewPanel.getBounds();
                Insets i = new Insets(8, 3, 3, 4);
                bounds.x += i.left;
                bounds.y += i.top;
                bounds.width = d.width - i.left - i.right;
                bounds.height = d.height - i.top - i.bottom;
                this.symbol.drawPreview(g2, bounds, this.color, this.lineWidth);
            }
        }

        protected void initButton_actionPerformed(ActionEvent e) {
            String code = ((SBSymbol)((Object)this.symbol)).getCode();
            this.color = ReactionColorScheme.resetColor(code);
            this.lineWidth = ReactionColorScheme.resetLineWidth(code);
            this.chooser.setColor(this.color);
            this.lineWidthField.setText(Double.toString(this.lineWidth));
            this.straightLineButton.setSelected(ReactionColorScheme.resetLineType(code) == 1);
            this.curveLineButton.setSelected(ReactionColorScheme.resetLineType(code) == 0);
            this.repaint();
        }

        protected void applyButton_actionPerformed(ActionEvent e) {
            String code = ((SBSymbol)((Object)this.symbol)).getCode();
            ReactionColorScheme.setColor(code, this.color);
            ReactionColorScheme.setLineWidth(code, this.lineWidth);
            ReactionColorScheme.setLineType(code, this.getCurrentLineType());
        }

        protected void okButton_actionPerformed(ActionEvent e) {
            String code = ((SBSymbol)((Object)this.symbol)).getCode();
            ReactionColorScheme.setColor(code, this.color);
            ReactionColorScheme.setLineWidth(code, this.lineWidth);
            ReactionColorScheme.setLineType(code, this.getCurrentLineType());
            SBSymbolPaletteDialog.this.dispose();
        }

        protected void cancelButton_actionPerformed(ActionEvent e) {
            this.chooser.setColor(null);
            this.lineWidthField.setText("");
            SBSymbolPaletteDialog.this.dispose();
        }

        private void chooser_colorChangeDetected(Color colorin) {
            this.color = colorin;
            this.repaint();
        }

        private int getCurrentLineType() {
            if (!(this.symbol instanceof GLinkedCurveAndLine)) {
                return 1;
            }
            if (this.straightLineButton.isSelected()) {
                return 1;
            }
            if (this.curveLineButton.isSelected()) {
                return 0;
            }
            return 1;
        }
    }

    private class SpeciesPanel
    extends JPanel {
        KeyAdapter keyListener;
        JPanel previewPanel = null;
        JPanel sizePanel = null;
        JPanel linePanel = null;
        PainterChooser painterPanel = null;
        MyColorChooser chooser = null;
        JPanel buttonPanel = null;
        SpeciesSymbol symbol = null;
        int w = 0;
        int h = 0;
        Color color = null;
        PaintScheme painter = null;
        double lineWidth = 0.0;
        private JTextField defaultWidthField;
        private JTextField defaultHeightField;
        private JTextField lineWidthField;
        private JButton initButton;
        private JButton applyButton;
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");

        public SpeciesPanel() {
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    SpeciesPanel.this.updateSize();
                }
            };
            super.setLayout(null);
            int x = ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.left;
            int y = ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.top;
            this.previewPanel = new JPanel();
            this.previewPanel.setBounds(new Rectangle(x, y, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PREVIEW.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PREVIEW.height));
            this.previewPanel.setBackground(Color.white);
            this.previewPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Preview"));
            this.add((Component)this.previewPanel, null);
            this.sizePanel = new JPanel();
            this.sizePanel.setLayout(null);
            this.sizePanel.setOpaque(false);
            this.sizePanel.setBounds(new Rectangle(x += ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PREVIEW.width + 6, y, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).SIZE.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).SIZE.height));
            this.sizePanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Size"));
            this.add((Component)this.sizePanel, null);
            JLabel labelWidthField = new JLabel("Width");
            labelWidthField.setBounds(10, 20, 40, 20);
            this.sizePanel.add((Component)labelWidthField, null);
            this.defaultWidthField = new JTextField();
            this.defaultWidthField.setBounds(50, 20, 40, 20);
            this.defaultWidthField.setEditable(true);
            this.defaultWidthField.addKeyListener(this.keyListener);
            this.sizePanel.add((Component)this.defaultWidthField, null);
            JLabel labelHeightField = new JLabel("Height");
            labelHeightField.setBounds(110, 20, 50, 20);
            this.sizePanel.add((Component)labelHeightField, null);
            this.defaultHeightField = new JTextField();
            this.defaultHeightField.setBounds(160, 20, 40, 20);
            this.defaultHeightField.setEditable(true);
            this.defaultHeightField.addKeyListener(this.keyListener);
            this.sizePanel.add((Component)this.defaultHeightField, null);
            this.linePanel = new JPanel();
            this.linePanel.setLayout(null);
            this.linePanel.setOpaque(false);
            this.linePanel.setBounds(x, y += ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).SIZE.height, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).LINE.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).LINE.height);
            this.linePanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Line"));
            this.add((Component)this.linePanel, null);
            JLabel labelLineWidthField = new JLabel("Width");
            labelLineWidthField.setBounds(10, 20, 40, 20);
            this.linePanel.add((Component)labelLineWidthField, null);
            this.lineWidthField = new JTextField();
            this.lineWidthField.setBounds(50, 20, 40, 20);
            this.lineWidthField.setEditable(true);
            this.lineWidthField.addKeyListener(this.keyListener);
            this.linePanel.add((Component)this.lineWidthField, null);
            this.painterPanel = new PainterChooser();
            this.painterPanel.setOpaque(false);
            this.painterPanel.setBounds(x, y += ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).LINE.height, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PAINTER.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PAINTER.height);
            this.painterPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Paint"));
            this.add((Component)this.painterPanel, null);
            this.painterPanel.addPainterChangeListener(new PainterChangeListener(){

                @Override
                public void painterChanged(String command) {
                    SpeciesPanel.this.painter_painterChangeDetected(command);
                }
            });
            x = ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.left;
            y = ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.top + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PREVIEW.height;
            this.chooser = new MyColorChooser();
            this.chooser.setBounds(x, y, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).CHOOSER.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).CHOOSER.height);
            this.chooser.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Color"));
            this.add((Component)this.chooser, null);
            this.chooser.addColorChangeListener(new ColorChangeListener(){

                @Override
                public void colorChanged(Color colorin) {
                    SpeciesPanel.this.chooser_colorChangeDetected(colorin);
                }
            });
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBounds(x, y += ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).CHOOSER.height, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).BUTTONS.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).BUTTONS.height);
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.buttonPanel, null);
            this.initButton = new JButton("Restore Default");
            this.initButton.setMnemonic(68);
            this.initButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpeciesPanel.this.initButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.initButton, null);
            this.applyButton = new JButton("Apply");
            this.applyButton.setMnemonic(65);
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpeciesPanel.this.applyButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.applyButton, null);
            this.okButton.setMnemonic(79);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpeciesPanel.this.okButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.okButton, null);
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpeciesPanel.this.cancelButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.cancelButton, null);
            this.setPreferredSize(new Dimension(((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.left + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.right + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).CHOOSER.width, ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.top + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).INSETS.bottom + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).PREVIEW.height + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).CHOOSER.height + ((SBSymbolPaletteDialog)SBSymbolPaletteDialog.this).BUTTONS.height));
        }

        private void updateSize() {
            String w_str = this.defaultWidthField.getText();
            String h_str = this.defaultHeightField.getText();
            String linew_str = this.lineWidthField.getText();
            if (w_str.equals("") || h_str.equals("") || linew_str.equals("")) {
                return;
            }
            int input_w = 0;
            int input_h = 0;
            double input_linew = 0.0;
            try {
                input_w = Integer.parseInt(w_str);
                input_h = Integer.parseInt(h_str);
                input_linew = Double.parseDouble(linew_str);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "input must be a number.", "bad number", 2);
                this.defaultWidthField.setText("" + this.w);
                this.defaultHeightField.setText("" + this.h);
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                return;
            }
            if (input_w <= 0 || input_h <= 0) {
                JOptionPane.showMessageDialog(this, "widht and height must be > 0.", "bad number", 2);
                this.defaultWidthField.setText("" + this.w);
                this.defaultHeightField.setText("" + this.h);
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                return;
            }
            if (input_linew < 0.0) {
                JOptionPane.showMessageDialog(this, "line width must be >= 0.", "bad number", 2);
                this.defaultWidthField.setText("" + this.w);
                this.defaultHeightField.setText("" + this.h);
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                return;
            }
            if (input_w > 0 && input_h > 0 && input_linew >= 0.0) {
                this.w = input_w;
                this.h = input_h;
                this.lineWidth = input_linew;
                this.repaint();
            }
        }

        public void setSpeciesSymbol(SpeciesSymbol symbol) {
            this.symbol = symbol;
            String code = ((SBSymbol)((Object)symbol)).getCode();
            Dimension d = (Dimension)Preference.defaultSpeciesSize.get(code);
            if (d == null) {
                d = symbol.defaultSize();
            }
            this.initialize(d.width, d.height, SpeciesColorScheme.getLineWidth(code), SpeciesColorScheme.getColor(code), SpeciesColorScheme.getScheme(code), code);
        }

        protected void initialize(int width, int height, double linewidth, Color colorin, PaintScheme painterin, String code) {
            this.w = width;
            this.h = height;
            this.defaultWidthField.setText("" + this.w);
            this.defaultHeightField.setText("" + this.h);
            this.color = colorin;
            this.chooser.setColor(this.color);
            this.painter = painterin;
            this.painterPanel.setSelected(this.painter.getCode());
            this.lineWidth = linewidth;
            this.lineWidthField.setText(Double.toString(this.lineWidth));
            if (code.equals("UNKNOWN")) {
                this.lineWidthField.setEnabled(false);
            } else {
                this.lineWidthField.setEnabled(true);
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.symbol != null) {
                Graphics2D g2 = (Graphics2D)g;
                Dimension d = this.previewPanel.getSize();
                Rectangle bounds = this.previewPanel.getBounds();
                Insets i = new Insets(10, 5, 5, 5);
                Rectangle clipBounds = new Rectangle(bounds.x + i.left, bounds.y + i.top, bounds.width - i.left - i.right, bounds.height - i.top - i.bottom);
                double x = (double)(bounds.x + i.left) + (double)(d.width - i.left - i.right - this.w) / 2.0;
                double y = (double)(bounds.y + i.top) + (double)(d.height - i.top - i.bottom - this.h) / 2.0;
                if (x + (double)this.w + this.lineWidth / 2.0 > (double)(clipBounds.x + clipBounds.width)) {
                    x = (double)(clipBounds.x + clipBounds.width - this.w) - this.lineWidth / 2.0;
                }
                if (y + (double)this.h + this.lineWidth / 2.0 > (double)(clipBounds.y + clipBounds.height)) {
                    y = (double)(clipBounds.y + clipBounds.height - this.h) - this.lineWidth / 2.0;
                }
                this.symbol.setSymbolBounds(x, y, this.w, this.h);
                this.painter.setColor(this.color);
                this.painter.setStroke(new BasicStroke((float)this.lineWidth, 0, 1));
                this.symbol.setPaintScheme(this.painter);
                g2.setClip(clipBounds);
                this.symbol.drawInner(g2, 1);
            }
        }

        protected void initButton_actionPerformed(ActionEvent e) {
            Dimension d = this.symbol.defaultSize();
            String code = ((SBSymbol)((Object)this.symbol)).getCode();
            this.w = d.width;
            this.h = d.height;
            Preference.defaultSpeciesSize.put(code, d);
            this.color = SpeciesColorScheme.resetColor(code);
            this.painter = SpeciesColorScheme.resetScheme(code);
            this.lineWidth = SpeciesColorScheme.resetLineWidth(code);
            this.defaultWidthField.setText("" + this.w);
            this.defaultHeightField.setText("" + this.h);
            this.chooser.setColor(this.color);
            this.painterPanel.setSelected(this.painter.getCode());
            this.lineWidthField.setText(Double.toString(this.lineWidth));
            this.repaint();
        }

        protected void applyButton_actionPerformed(ActionEvent e) {
            String code = ((SBSymbol)((Object)this.symbol)).getCode();
            Preference.defaultSpeciesSize.put(code, new Dimension(this.w, this.h));
            SpeciesColorScheme.setColor(code, this.color);
            SpeciesColorScheme.setScheme(code, this.painter);
            SpeciesColorScheme.setLineWidth(code, this.lineWidth);
        }

        protected void okButton_actionPerformed(ActionEvent e) {
            String code = ((SBSymbol)((Object)this.symbol)).getCode();
            Preference.defaultSpeciesSize.put(code, new Dimension(this.w, this.h));
            SpeciesColorScheme.setColor(code, this.color);
            SpeciesColorScheme.setScheme(code, this.painter);
            SpeciesColorScheme.setLineWidth(code, this.lineWidth);
            SBSymbolPaletteDialog.this.dispose();
        }

        protected void cancelButton_actionPerformed(ActionEvent e) {
            this.defaultWidthField.setText("");
            this.defaultHeightField.setText("");
            this.chooser.setColor(null);
            this.painterPanel.setSelected(null);
            this.lineWidthField.setText("");
            SBSymbolPaletteDialog.this.dispose();
        }

        private void chooser_colorChangeDetected(Color colorin) {
            this.color = colorin;
            this.repaint();
        }

        private void painter_painterChangeDetected(String code) {
            String scheme = PaintSchemeFactory.getName(code);
            this.painter = PaintSchemeFactory.create(scheme);
            this.repaint();
        }
    }
}

