/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jp.fric.graphics.draw.GMouseInterpreter;

public class SBSymbolPaletteCombo2 {
    JComboBox jcombobox;
    GMouseInterpreter mouseInterpreter = null;
    private int currentMode = 2;
    private int continueMode = 100;
    private String currentType = "";
    private Vector buttons = new Vector();
    private static Vector images = new Vector();
    private static Vector explains = new Vector();
    String[] names = new String[]{"SQUARE", "OVAL", "SQUARE_CLOSEUP_NORTHWEST", "SQUARE_CLOSEUP_NORTHEAST", "SQUARE_CLOSEUP_SOUTHWEST", "SQUARE_CLOSEUP_SOUTHEAST", "SQUARE_CLOSEUP_WEST", "SQUARE_CLOSEUP_NORTH", "SQUARE_CLOSEUP_SOUTH", "SQUARE_CLOSEUP_EAST"};

    public SBSymbolPaletteCombo2(JComboBox combobox, GMouseInterpreter mouseinterpreter) {
        this.jcombobox = combobox;
        this.mouseInterpreter = mouseinterpreter;
        ImageIcon normalImage = null;
        int i = 0;
        while (i < this.names.length) {
            String normalName = "icons2/" + this.names[i] + ".png";
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                normalImage = new ImageIcon(tk.getImage(this.getClass().getResource(normalName)));
            }
            catch (Exception e) {
                System.out.println("cannnot load icon: " + this.names[i]);
            }
            images.add(normalImage);
            ++i;
        }
        int j = 0;
        while (j < this.names.length) {
            explains.add(this.names[j]);
            ++j;
        }
        int k = 0;
        while (k < images.size()) {
            this.jcombobox.addItem(images.elementAt(k));
            ++k;
        }
        MyCellRenderer renderer = new MyCellRenderer(explains);
        this.jcombobox.setRenderer(renderer);
        int imageheight = normalImage.getIconHeight();
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        int heightMax = screensize.height - 26;
        int rowcount = heightMax / (imageheight + 4);
        this.jcombobox.setMaximumRowCount(rowcount);
    }

    public void setMouseInterpreter(GMouseInterpreter mouseInterpreter) {
        this.mouseInterpreter = mouseInterpreter;
    }

    private void setParams() {
        if (this.mouseInterpreter != null && !this.currentType.equals("")) {
            this.mouseInterpreter.setType(this.currentType);
            this.mouseInterpreter.setMode(2 + this.continueMode);
        }
    }

    public void statusChanged() {
        int index = this.jcombobox.getSelectedIndex();
        this.currentMode = 2;
        this.currentType = this.names[index];
        this.setParams();
    }

    public String getCurrentExplain() {
        int index = this.jcombobox.getSelectedIndex();
        return (String)explains.elementAt(index);
    }

    private class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Vector explains = null;

        public MyCellRenderer(Vector explains) {
            this.explains = explains;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setIcon((Icon)value);
            if (index >= 0) {
                this.setToolTipText((String)this.explains.elementAt(index));
            }
            if (isSelected) {
                this.setBackground(Color.lightGray);
            } else {
                this.setBackground(Color.white);
            }
            return this;
        }
    }
}

