/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jp.fric.graphics.draw.GMouseInterpreter;
import jp.sbi.celldesigner.SBFactory;

public class SBSymbolPaletteCombo {
    JComboBox jcombobox;
    GMouseInterpreter mouseInterpreter = null;
    private String currentType = "";
    private int currentMode = 2;
    private int continueMode = 100;
    private Vector images = new Vector();
    private Vector symbols = new Vector();
    private Vector symbolcodes = new Vector();
    private Vector explains = new Vector();
    private int oldSelectedIndex = 0;
    private int mymode = 0;
    public static final int SPECIESCOMBO = 1;
    public static final int REACTIONCOMBO = 2;

    public SBSymbolPaletteCombo(JComboBox combobox, int combotype, GMouseInterpreter mouseinterpreter) {
        MyCellRenderer renderer;
        int i;
        this.jcombobox = combobox;
        this.mouseInterpreter = mouseinterpreter;
        ImageIcon normalImage = null;
        Vector speciesCodes = SBFactory.getSpeciesCodesForPalette();
        if (combotype == 1) {
            this.mymode = 1;
            int j = 0;
            while (j < speciesCodes.size()) {
                String code = (String)speciesCodes.elementAt(j);
                String normalName = "icons/" + code + ".png";
                this.symbolcodes.add(code);
                try {
                    Toolkit tk = Toolkit.getDefaultToolkit();
                    normalImage = new ImageIcon(tk.getImage(this.getClass().getResource(normalName)));
                }
                catch (Exception e) {
                    System.out.println("cannnot load icon: " + code);
                }
                this.images.add(normalImage);
                this.symbols.add(SBFactory.createSymbol(code));
                ++j;
            }
            String normalName = "icons/SELECT_MODE.png";
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                normalImage = new ImageIcon(tk.getImage(this.getClass().getResource(normalName)));
            }
            catch (Exception e) {
                System.out.println("cannnot load icon: SELECT_MODE");
            }
            this.jcombobox.addItem(normalImage);
            this.explains.add("select/mode");
            this.explains.add("protein generic");
            this.explains.add("protein receptor");
            this.explains.add("protein ion channel");
            this.explains.add("protein truncated");
            this.explains.add("gene");
            this.explains.add("RNA");
            this.explains.add("Anti-sense RNA");
            this.explains.add("phenotype");
            this.explains.add("ion");
            this.explains.add("simple molecule");
            this.explains.add("unknown");
            this.explains.add("create heteromultimer");
            this.explains.add("release heteromultimer");
            i = 0;
            i = 0;
            while (i < this.images.size()) {
                this.jcombobox.addItem(this.images.elementAt(i));
                ++i;
            }
            this.currentMode = 1;
            this.setParams();
            renderer = new MyCellRenderer(this.explains);
            combobox.setRenderer(renderer);
        } else if (combotype == 2) {
            this.mymode = 2;
            Vector reactionCodes = SBFactory.getReactionCodesForPalette();
            int j = 0;
            while (j < reactionCodes.size()) {
                String code = (String)reactionCodes.elementAt(j);
                String normalName = "icons/" + code + ".png";
                this.symbolcodes.add(code);
                try {
                    Toolkit tk = Toolkit.getDefaultToolkit();
                    normalImage = new ImageIcon(tk.getImage(this.getClass().getResource(normalName)));
                }
                catch (Exception e) {
                    System.out.println("cannnot load icon: " + code);
                }
                this.images.add(normalImage);
                this.symbols.add(SBFactory.createSymbol(code));
                ++j;
            }
            this.explains.add("transcriptional activation");
            this.explains.add("transcriptional inhibition");
            this.explains.add("translational activation");
            this.explains.add("translational inhibition");
            this.explains.add("catalysis");
            this.explains.add("unknown catalysis");
            this.explains.add("inhibition");
            this.explains.add("unknown inhibition");
            this.explains.add("state transition");
            this.explains.add("known transition omitted");
            this.explains.add("unknown transition");
            this.explains.add("transport");
            this.explains.add("heterodimer association");
            this.explains.add("dissociation");
            this.explains.add("truncation");
            this.explains.add("homodimer formation");
            this.explains.add("degradation");
            this.explains.add("add reactant");
            this.explains.add("add product");
            i = 0;
            i = 0;
            while (i < this.images.size()) {
                this.jcombobox.addItem(this.images.elementAt(i));
                ++i;
            }
            renderer = new MyCellRenderer(this.explains);
            combobox.setRenderer(renderer);
        }
        int imageheight = normalImage.getIconHeight();
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        int heightMax = screensize.height - 26;
        int rowcount = heightMax / (imageheight + 4);
        this.jcombobox.setMaximumRowCount(rowcount);
    }

    public void setMouseInterpreter(GMouseInterpreter mouseInterpreter) {
        this.mouseInterpreter = mouseInterpreter;
        this.setParams();
    }

    private void setParams() {
        if (this.mouseInterpreter != null) {
            this.mouseInterpreter.setType(this.currentType);
            this.mouseInterpreter.setMode(this.currentMode + this.continueMode);
        }
    }

    public void statusChanged() {
        int index = this.jcombobox.getSelectedIndex();
        if (this.mymode == 1 && index == 0) {
            this.currentMode = 1;
        } else {
            this.currentMode = 2;
            this.currentType = this.mymode == 1 ? (String)this.symbolcodes.elementAt(index - 1) : (String)this.symbolcodes.elementAt(index);
        }
        this.setParams();
        this.oldSelectedIndex = index;
    }

    public String getCurrentExplain() {
        int index = this.jcombobox.getSelectedIndex();
        return (String)this.explains.elementAt(index);
    }

    public void resetItem() {
        this.currentMode = 1;
        this.setParams();
        this.jcombobox.setSelectedIndex(0);
    }

    public void setContinueMode(int mode) {
        this.continueMode = mode;
    }

    private class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Vector explains = null;

        public MyCellRenderer(Vector explains) {
            this.explains = explains;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setIcon((Icon)value);
            if (index >= 0) {
                this.setToolTipText((String)this.explains.elementAt(index));
            }
            if (isSelected) {
                this.setBackground(Color.lightGray);
            } else {
                this.setBackground(Color.white);
            }
            return this;
        }
    }
}

