/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import jp.fric.graphics.draw.GColoredShape;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GLinkedCurveAndLine;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GPointedShape;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.PaintScheme;
import jp.fric.graphics.draw.PaintSchemeFactory;
import jp.sbi.celldesigner.ColorChangeListener;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.CompartmentShapePainting;
import jp.sbi.celldesigner.CompartmentSymbol;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.EditComponentsDialog2;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.MyColorChooser;
import jp.sbi.celldesigner.PainterChangeListener;
import jp.sbi.celldesigner.PainterChooser;
import jp.sbi.celldesigner.PopupSpeciesNameFontDialog;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.ReactionSymbol;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesShapePainting;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerCompartmentAlias;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerCompartmentSymbol;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionLink;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionSymbol;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerTagFreeLineSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerMonoSpeciesShape;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesAlias;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerTagSymbol;
import jp.sbi.celldesigner.sbmlExtension.CompartmentAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.celldesigner.symbol.color.CompartmentColorScheme;
import jp.sbi.celldesigner.symbol.color.ReactionColorScheme;
import jp.sbi.celldesigner.symbol.color.SpeciesColorScheme;
import jp.sbi.celldesigner.symbol.compartment.Membrane;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.celldesigner.symbol.species.Complex;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class SBSymbolEditDialog
extends JDialog {
    public static final int CHANGE_ALL = 1;
    public static final int CHANGE_ONE_IN_ALL = 2;
    public static final int CHANGE_ONE = 3;
    public static final String OPTION = "option";
    private JFrame owner = null;
    private SBModel sbmodel = null;
    private SpeciesPanel speciesPanel = null;
    private CompartmentPanel compartmentPanel = null;
    private ReactionPanel reactionPanel = null;
    private NoOptionPanel noOptionPanel = null;
    private LayerSpeciesPanel layerTextPanel = null;
    private LayerCompartmentPanel layerCompartmentPanel = null;
    private LayerReactionPanel layerReactionPanel = null;
    private SpeciesChangeNameFontSizePanel speciesChangeNamePanel = null;
    private TagPanel tagPanel = null;
    private boolean isFirstShowing = true;
    private boolean isDoShape;
    private boolean isDoColor;
    public static final int adjustment = 38;
    public static final Insets INSETS = new Insets(4, 4, 4, 4);
    public static final Dimension PREVIEW = new Dimension(272, 160);
    public static final Dimension PAINTER = new Dimension(238, 60);
    public static final Dimension CHOOSER = new Dimension(516, 278);
    public static final Dimension BUTTONS = new Dimension(516, 34);
    public static final Dimension OTHER = new Dimension(238, 50);
    public static final Dimension THICKNESS = new Dimension(OTHER);
    public static final Dimension LINEWIDTH = new Dimension(OTHER);
    public static final Dimension LINE = new Dimension(OTHER);
    public static final Dimension SIZE = new Dimension(OTHER);
    public static final Dimension LINETYPE = new Dimension(SBSymbolEditDialog.OTHER.width, 80);
    private boolean isChangeSpeciesNameFontSizeFlag = false;
    private static final int SPECIES_PANEL = 1;
    private static final int GRID_SIZE_PANEL = 2;
    private static final int NO_OPTION_PANEL = 3;
    private static final int COMPARTMENT_PANEL = 4;
    private static final int REACTION_PANEL = 5;
    private static final int LAYER_SPECIES_PANEL = 6;
    private static final int LAYER_COMPARTMENT_PANEL = 7;
    private static final int LAYER_REACTION_PANEL = 8;
    private static final int TAG_PANEL = 9;
    private static final int SPECIESCHANGENAME_PANEL = 10;
    private boolean isInner = false;

    public SBSymbolEditDialog(JFrame owner, SBModel sbmodel, String title) {
        super(owner);
        this.owner = owner;
        this.sbmodel = sbmodel;
        this.setResizable(false);
        this.setModal(true);
        this.setTitle(title);
        this.speciesPanel = new SpeciesPanel();
        this.speciesPanel.setOpaque(true);
        this.compartmentPanel = new CompartmentPanel();
        this.compartmentPanel.setOpaque(true);
        this.reactionPanel = new ReactionPanel();
        this.reactionPanel.setOpaque(true);
        this.noOptionPanel = new NoOptionPanel();
        this.noOptionPanel.setOpaque(true);
        this.layerTextPanel = new LayerSpeciesPanel();
        this.layerCompartmentPanel = new LayerCompartmentPanel();
        this.layerReactionPanel = new LayerReactionPanel();
        this.speciesChangeNamePanel = new SpeciesChangeNameFontSizePanel();
        this.tagPanel = new TagPanel();
        super.addNotify();
    }

    @Override
    public void show() {
        if (this.isFirstShowing) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension me = this.getSize();
            this.setCenterLocation();
            this.isFirstShowing = false;
        }
        MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure().setTemp_dx(0.0);
        MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure().setTemp_dy(0.0);
        super.show();
    }

    public void setComponentsEnable(Component com, boolean enable) {
        if (com instanceof Container) {
            Container c = (Container)com;
            if (c instanceof JTabbedPane) {
                Container tab;
                c.setEnabled(enable);
                if (enable) {
                    ((JTabbedPane)c).setSelectedIndex(0);
                    tab = (Container)((JTabbedPane)c).getSelectedComponent();
                } else {
                    ((JTabbedPane)c).setSelectedIndex(2);
                    tab = (Container)((JTabbedPane)c).getSelectedComponent();
                }
            }
            int i = 0;
            while (i < c.getComponentCount()) {
                this.setComponentsEnable(c.getComponent(i), enable);
                ++i;
            }
        }
        if (com instanceof JSlider) {
            com.setEnabled(enable);
        }
        if (com instanceof JSpinner) {
            com.setEnabled(enable);
        }
    }

    public void setShapeEnable(boolean enable) {
        this.speciesPanel.defaultWidthField.setEnabled(enable);
        this.speciesPanel.defaultHeightField.setEnabled(enable);
    }

    public void setColorEnable(boolean enable) {
        this.setComponentsEnable(this.speciesPanel.chooser, enable);
        this.speciesPanel.painterPanel.setGradationButtonEnable(enable);
        this.speciesPanel.painterPanel.setColorButtonEnable(enable);
    }

    public void setShapeAndColorEnable(boolean isDoShape, boolean isDoColor) {
        this.isDoShape = isDoShape;
        this.isDoColor = isDoColor;
    }

    public boolean isDoShape() {
        return this.isDoShape;
    }

    public boolean isDoColor() {
        return this.isDoColor;
    }

    public void setPanel(Object obj) {
        if (obj instanceof SpeciesAlias) {
            if (this.isChangeSpeciesNameFontSize()) {
                this.speciesChangeNamePanel.setSpeciesAlias((SpeciesAlias)obj);
                this.setPanel(10);
            } else {
                this.speciesPanel.setSpeciesAlias((SpeciesAlias)obj);
                this.setPanel(1);
            }
        } else if (obj instanceof CompartmentAlias) {
            this.compartmentPanel.setCompartmentAlias((CompartmentAlias)obj);
            this.setPanel(4);
        } else if (obj instanceof ReactionLink) {
            this.reactionPanel.setReactionLink((ReactionLink)obj);
            this.setPanel(5);
        } else if (obj instanceof LayerSpeciesAlias) {
            LayerMonoSpeciesShape monoShape = (LayerMonoSpeciesShape)((LayerSpeciesAlias)obj).getGFramedShape();
            if (monoShape.getSpeciesSymbol() instanceof LayerTagSymbol) {
                this.tagPanel.setSpeciesAlias((LayerSpeciesAlias)obj);
                this.setPanel(9);
            } else {
                this.layerTextPanel.setSpeciesAlias((LayerSpeciesAlias)obj);
                this.setPanel(6);
            }
        } else if (obj instanceof LayerCompartmentAlias) {
            this.layerCompartmentPanel.setCompartmentAlias((LayerCompartmentAlias)obj, this.isInner);
            this.setPanel(7);
        } else if (obj instanceof LayerReactionLink) {
            this.layerReactionPanel.setReactionLink((LayerReactionLink)obj);
            this.setPanel(8);
        } else {
            this.setPanel(3);
        }
    }

    public boolean isChangeSpeciesNameFontSize() {
        return this.isChangeSpeciesNameFontSizeFlag;
    }

    public void setChangeSpeciesNameFontSizeFlag(boolean isChangeSpeciesNameFontSizeFlag) {
        this.isChangeSpeciesNameFontSizeFlag = isChangeSpeciesNameFontSizeFlag;
    }

    public void resetChangeSpeciesNameFontSizeFlag() {
        this.isChangeSpeciesNameFontSizeFlag = false;
    }

    public void setPanel(Object type, Vector objs) {
        LayerMonoSpeciesShape monoShape;
        if (SBSymbolEditDialog.canChangeLayerComponentShapeColorAllOf(objs)) {
            int iSize = objs.size();
            Object objtmp = objs.get(0);
            if (objtmp instanceof LayerSpeciesAlias) {
                LayerSpeciesAlias[] ltxtAliases = new LayerSpeciesAlias[iSize];
                int i = 0;
                while (i < iSize) {
                    ltxtAliases[i] = (LayerSpeciesAlias)objs.get(i);
                    ++i;
                }
                LayerMonoSpeciesShape monoShape2 = (LayerMonoSpeciesShape)((LayerSpeciesAlias)objtmp).getGFramedShape();
                if (monoShape2.getSpeciesSymbol() instanceof LayerTagSymbol) {
                    this.tagPanel.setSpeciesAlias(ltxtAliases);
                    this.setPanel(9);
                } else {
                    this.layerTextPanel.setSpeciesAlias(ltxtAliases);
                    this.setPanel(6);
                }
            } else if (objtmp instanceof LayerCompartmentAlias) {
                LayerCompartmentAlias[] lcmpxAliases = new LayerCompartmentAlias[iSize];
                int i = 0;
                while (i < iSize) {
                    lcmpxAliases[i] = (LayerCompartmentAlias)objs.get(i);
                    ++i;
                }
                this.layerCompartmentPanel.setCompartmentAlias(lcmpxAliases, this.isInner);
                this.setPanel(7);
            } else if (objtmp instanceof LayerReactionLink) {
                LayerReactionLink[] layerlines = new LayerReactionLink[iSize];
                int i = 0;
                while (i < iSize) {
                    layerlines[i] = (LayerReactionLink)objs.get(i);
                    ++i;
                }
                this.layerReactionPanel.setReactionLink(layerlines);
                this.setPanel(8);
            }
            return;
        }
        SpeciesAlias[] speciesAlias = null;
        CompartmentAlias[] compartmentAlias = null;
        ReactionLink[] reactionLink = null;
        LayerSpeciesAlias[] tagAliases = null;
        if (type instanceof SpeciesAlias) {
            speciesAlias = new SpeciesAlias[objs.size()];
        } else if (type instanceof CompartmentAlias) {
            compartmentAlias = new CompartmentAlias[objs.size()];
        } else if (type instanceof ReactionLink) {
            reactionLink = new ReactionLink[objs.size()];
        } else if (type instanceof LayerSpeciesAlias && (monoShape = (LayerMonoSpeciesShape)((LayerSpeciesAlias)type).getGFramedShape()).getSpeciesSymbol() instanceof LayerTagSymbol) {
            tagAliases = new LayerSpeciesAlias[objs.size()];
        }
        int i = 0;
        while (i < objs.size()) {
            LayerMonoSpeciesShape monoShape3;
            Object obj = objs.get(i);
            if (obj instanceof SpeciesAlias) {
                speciesAlias[i] = (SpeciesAlias)obj;
            } else if (obj instanceof CompartmentAlias) {
                compartmentAlias[i] = (CompartmentAlias)obj;
            } else if (obj instanceof ReactionLink) {
                reactionLink[i] = (ReactionLink)obj;
            } else if (obj instanceof LayerSpeciesAlias && (monoShape3 = (LayerMonoSpeciesShape)((LayerSpeciesAlias)obj).getGFramedShape()).getSpeciesSymbol() instanceof LayerTagSymbol) {
                tagAliases[i] = (LayerSpeciesAlias)obj;
            }
            ++i;
        }
        if (type instanceof SpeciesAlias) {
            if (this.isChangeSpeciesNameFontSize()) {
                this.speciesChangeNamePanel.setSpeciesAlias(speciesAlias);
                this.setPanel(10);
            } else {
                this.speciesPanel.setSpeciesAlias(speciesAlias);
                this.setPanel(1);
            }
        } else if (type instanceof CompartmentAlias) {
            this.compartmentPanel.setCompartmentAlias(compartmentAlias);
            this.setPanel(4);
        } else if (type instanceof ReactionLink) {
            this.reactionPanel.setReactionLink(reactionLink);
            this.setPanel(5);
        } else if (type instanceof LayerSpeciesAlias) {
            monoShape = (LayerMonoSpeciesShape)((LayerSpeciesAlias)type).getGFramedShape();
            if (monoShape.getSpeciesSymbol() instanceof LayerTagSymbol) {
                this.tagPanel.setSpeciesAlias(tagAliases);
                this.setPanel(9);
            }
        } else {
            this.setPanel(3);
        }
    }

    private void setPanel(int target) {
        Container c = this.getContentPane();
        boolean isSpeciesPanelAdded = false;
        boolean isCompartmentPanelAdded = false;
        boolean isReactionPanelAdded = false;
        boolean isNoOptionPanelAdded = false;
        boolean isLayerSpeciesPanelAdded = false;
        boolean isLayerCompartmentPanelAdded = false;
        boolean isLayerReactionPanelAdded = false;
        boolean isTagPanelAdded = false;
        boolean isSpeciesChangeNamePanelAdded = false;
        Component[] comp = c.getComponents();
        int i = 0;
        while (i < comp.length) {
            if (comp[i] == this.speciesPanel) {
                isSpeciesPanelAdded = true;
            }
            if (comp[i] == this.compartmentPanel) {
                isCompartmentPanelAdded = true;
            }
            if (comp[i] == this.reactionPanel) {
                isReactionPanelAdded = true;
            }
            if (comp[i] == this.noOptionPanel) {
                isNoOptionPanelAdded = true;
            }
            if (comp[i] == this.layerTextPanel) {
                isLayerSpeciesPanelAdded = true;
            }
            if (comp[i] == this.layerCompartmentPanel) {
                isLayerCompartmentPanelAdded = true;
            }
            if (comp[i] == this.layerReactionPanel) {
                isLayerReactionPanelAdded = true;
            }
            if (comp[i] == this.tagPanel) {
                isTagPanelAdded = true;
            }
            if (comp[i] == this.speciesChangeNamePanel) {
                isSpeciesChangeNamePanelAdded = true;
            }
            ++i;
        }
        switch (target) {
            case 1: {
                if (!isSpeciesPanelAdded) {
                    if (isCompartmentPanelAdded) {
                        c.remove(this.compartmentPanel);
                    }
                    if (isReactionPanelAdded) {
                        c.remove(this.reactionPanel);
                    }
                    if (isNoOptionPanelAdded) {
                        c.remove(this.noOptionPanel);
                    }
                    if (isLayerSpeciesPanelAdded) {
                        c.remove(this.layerTextPanel);
                    }
                    if (isLayerCompartmentPanelAdded) {
                        c.remove(this.layerCompartmentPanel);
                    }
                    if (isLayerReactionPanelAdded) {
                        c.remove(this.layerReactionPanel);
                    }
                    if (isTagPanelAdded) {
                        c.remove(this.tagPanel);
                    }
                    if (isSpeciesChangeNamePanelAdded) {
                        c.remove(this.speciesChangeNamePanel);
                    }
                    c.add((Component)this.speciesPanel, "Center");
                    this.pack();
                    Insets insets = this.getInsets();
                    Dimension paneldim = this.speciesPanel.getPreferredSize();
                    Dimension size = new Dimension(insets.left + insets.right + paneldim.width, insets.top + insets.bottom + paneldim.height);
                    this.setSize(size);
                }
                this.validate();
                break;
            }
            case 4: {
                if (!isCompartmentPanelAdded) {
                    if (isSpeciesPanelAdded) {
                        c.remove(this.speciesPanel);
                    }
                    if (isReactionPanelAdded) {
                        c.remove(this.reactionPanel);
                    }
                    if (isNoOptionPanelAdded) {
                        c.remove(this.noOptionPanel);
                    }
                    if (isLayerSpeciesPanelAdded) {
                        c.remove(this.layerTextPanel);
                    }
                    if (isLayerCompartmentPanelAdded) {
                        c.remove(this.layerCompartmentPanel);
                    }
                    if (isLayerReactionPanelAdded) {
                        c.remove(this.layerReactionPanel);
                    }
                    if (isTagPanelAdded) {
                        c.remove(this.tagPanel);
                    }
                    if (isSpeciesChangeNamePanelAdded) {
                        c.remove(this.speciesChangeNamePanel);
                    }
                    c.add((Component)this.compartmentPanel, "Center");
                    this.pack();
                    Insets insets = this.getInsets();
                    Dimension paneldim = this.compartmentPanel.getPreferredSize();
                    Dimension size = new Dimension(insets.left + insets.right + paneldim.width, insets.top + insets.bottom + paneldim.height);
                    this.setSize(size);
                }
                this.validate();
                break;
            }
            case 5: {
                if (!isReactionPanelAdded) {
                    if (isSpeciesPanelAdded) {
                        c.remove(this.speciesPanel);
                    }
                    if (isCompartmentPanelAdded) {
                        c.remove(this.compartmentPanel);
                    }
                    if (isNoOptionPanelAdded) {
                        c.remove(this.noOptionPanel);
                    }
                    if (isLayerSpeciesPanelAdded) {
                        c.remove(this.layerTextPanel);
                    }
                    if (isLayerCompartmentPanelAdded) {
                        c.remove(this.layerCompartmentPanel);
                    }
                    if (isLayerReactionPanelAdded) {
                        c.remove(this.layerReactionPanel);
                    }
                    if (isTagPanelAdded) {
                        c.remove(this.tagPanel);
                    }
                    if (isSpeciesChangeNamePanelAdded) {
                        c.remove(this.speciesChangeNamePanel);
                    }
                    c.add((Component)this.reactionPanel, "Center");
                    this.pack();
                    Insets insets = this.getInsets();
                    Dimension paneldim = this.reactionPanel.getPreferredSize();
                    Dimension size = new Dimension(insets.left + insets.right + paneldim.width, insets.top + insets.bottom + paneldim.height);
                    this.setSize(size);
                }
                this.validate();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (!isNoOptionPanelAdded) {
                    if (isSpeciesPanelAdded) {
                        c.remove(this.speciesPanel);
                    }
                    if (isCompartmentPanelAdded) {
                        c.remove(this.compartmentPanel);
                    }
                    if (isReactionPanelAdded) {
                        c.remove(this.reactionPanel);
                    }
                    if (isLayerSpeciesPanelAdded) {
                        c.remove(this.layerTextPanel);
                    }
                    if (isLayerCompartmentPanelAdded) {
                        c.remove(this.layerCompartmentPanel);
                    }
                    if (isLayerReactionPanelAdded) {
                        c.remove(this.layerReactionPanel);
                    }
                    if (isTagPanelAdded) {
                        c.remove(this.tagPanel);
                    }
                    if (isSpeciesChangeNamePanelAdded) {
                        c.remove(this.speciesChangeNamePanel);
                    }
                    c.add((Component)this.noOptionPanel, "Center");
                }
                this.validate();
                break;
            }
            case 6: {
                if (!isLayerSpeciesPanelAdded) {
                    if (isSpeciesPanelAdded) {
                        c.remove(this.speciesPanel);
                    }
                    if (isCompartmentPanelAdded) {
                        c.remove(this.compartmentPanel);
                    }
                    if (isReactionPanelAdded) {
                        c.remove(this.reactionPanel);
                    }
                    if (isNoOptionPanelAdded) {
                        c.remove(this.noOptionPanel);
                    }
                    if (isLayerCompartmentPanelAdded) {
                        c.remove(this.layerCompartmentPanel);
                    }
                    if (isLayerReactionPanelAdded) {
                        c.remove(this.layerReactionPanel);
                    }
                    if (isTagPanelAdded) {
                        c.remove(this.tagPanel);
                    }
                    if (isSpeciesChangeNamePanelAdded) {
                        c.remove(this.speciesChangeNamePanel);
                    }
                    c.add((Component)this.layerTextPanel, "Center");
                    this.pack();
                    Insets insets = this.getInsets();
                    Dimension paneldim = this.layerTextPanel.getPreferredSize();
                    Dimension size = new Dimension(insets.left + insets.right + paneldim.width, insets.top + insets.bottom + paneldim.height);
                    this.setSize(size);
                }
                this.validate();
                break;
            }
            case 7: {
                if (!isLayerCompartmentPanelAdded) {
                    if (isSpeciesPanelAdded) {
                        c.remove(this.speciesPanel);
                    }
                    if (isCompartmentPanelAdded) {
                        c.remove(this.compartmentPanel);
                    }
                    if (isReactionPanelAdded) {
                        c.remove(this.reactionPanel);
                    }
                    if (isNoOptionPanelAdded) {
                        c.remove(this.noOptionPanel);
                    }
                    if (isLayerSpeciesPanelAdded) {
                        c.remove(this.layerTextPanel);
                    }
                    if (isLayerReactionPanelAdded) {
                        c.remove(this.layerReactionPanel);
                    }
                    if (isTagPanelAdded) {
                        c.remove(this.tagPanel);
                    }
                    if (isSpeciesChangeNamePanelAdded) {
                        c.remove(this.speciesChangeNamePanel);
                    }
                    c.add((Component)this.layerCompartmentPanel, "Center");
                    this.pack();
                    Insets insets = this.getInsets();
                    Dimension paneldim = this.layerCompartmentPanel.getPreferredSize();
                    Dimension size = new Dimension(insets.left + insets.right + paneldim.width, insets.top + insets.bottom + paneldim.height);
                    this.setSize(size);
                }
                this.validate();
                break;
            }
            case 8: {
                if (!isLayerReactionPanelAdded) {
                    if (isSpeciesPanelAdded) {
                        c.remove(this.speciesPanel);
                    }
                    if (isCompartmentPanelAdded) {
                        c.remove(this.compartmentPanel);
                    }
                    if (isReactionPanelAdded) {
                        c.remove(this.reactionPanel);
                    }
                    if (isNoOptionPanelAdded) {
                        c.remove(this.noOptionPanel);
                    }
                    if (isLayerSpeciesPanelAdded) {
                        c.remove(this.layerTextPanel);
                    }
                    if (isLayerCompartmentPanelAdded) {
                        c.remove(this.layerCompartmentPanel);
                    }
                    if (isTagPanelAdded) {
                        c.remove(this.tagPanel);
                    }
                    if (isSpeciesChangeNamePanelAdded) {
                        c.remove(this.speciesChangeNamePanel);
                    }
                    c.add((Component)this.layerReactionPanel, "Center");
                    this.pack();
                    Insets insets = this.getInsets();
                    Dimension paneldim = this.layerReactionPanel.getPreferredSize();
                    Dimension size = new Dimension(insets.left + insets.right + paneldim.width, insets.top + insets.bottom + paneldim.height);
                    this.setSize(size);
                }
                this.validate();
                break;
            }
            case 9: {
                if (!isTagPanelAdded) {
                    if (isSpeciesPanelAdded) {
                        c.remove(this.speciesPanel);
                    }
                    if (isCompartmentPanelAdded) {
                        c.remove(this.compartmentPanel);
                    }
                    if (isReactionPanelAdded) {
                        c.remove(this.reactionPanel);
                    }
                    if (isNoOptionPanelAdded) {
                        c.remove(this.noOptionPanel);
                    }
                    if (isLayerSpeciesPanelAdded) {
                        c.remove(this.layerTextPanel);
                    }
                    if (isLayerCompartmentPanelAdded) {
                        c.remove(this.layerCompartmentPanel);
                    }
                    if (isLayerReactionPanelAdded) {
                        c.remove(this.layerReactionPanel);
                    }
                    if (isSpeciesChangeNamePanelAdded) {
                        c.remove(this.speciesChangeNamePanel);
                    }
                    c.add((Component)this.tagPanel, "Center");
                    this.pack();
                    Insets insets = this.getInsets();
                    Dimension paneldim = this.tagPanel.getPreferredSize();
                    Dimension size = new Dimension(insets.left + insets.right + paneldim.width, insets.top + insets.bottom + paneldim.height);
                    this.setSize(size);
                }
                this.validate();
                break;
            }
            case 10: {
                if (!isSpeciesChangeNamePanelAdded) {
                    if (isSpeciesPanelAdded) {
                        c.remove(this.speciesPanel);
                    }
                    if (isCompartmentPanelAdded) {
                        c.remove(this.compartmentPanel);
                    }
                    if (isReactionPanelAdded) {
                        c.remove(this.reactionPanel);
                    }
                    if (isNoOptionPanelAdded) {
                        c.remove(this.noOptionPanel);
                    }
                    if (isLayerSpeciesPanelAdded) {
                        c.remove(this.layerTextPanel);
                    }
                    if (isLayerCompartmentPanelAdded) {
                        c.remove(this.layerCompartmentPanel);
                    }
                    if (isLayerReactionPanelAdded) {
                        c.remove(this.layerReactionPanel);
                    }
                    if (isTagPanelAdded) {
                        c.remove(this.tagPanel);
                    }
                    c.add((Component)this.speciesChangeNamePanel, "Center");
                    this.pack();
                    Insets insets = this.getInsets();
                    Dimension paneldim = this.speciesChangeNamePanel.getPreferredSize();
                    Dimension size = new Dimension(insets.left + insets.right + paneldim.width, insets.top + insets.bottom + paneldim.height);
                    this.setSize(size);
                }
                this.validate();
            }
        }
        this.repaint();
    }

    public boolean isInner() {
        return this.isInner;
    }

    public void setInnerFlg(boolean boo) {
        this.isInner = boo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean canChangeLayerComponentShapeColorAllOf(Vector objs) {
        if (objs == null) {
            return false;
        }
        if (objs.size() == 1) {
            return true;
        }
        int iSize = objs.size();
        int iMix = 0;
        int iLayerTag = 0;
        int iLayerAlias = 0;
        int iLayerCompartment = 0;
        int iLayerLinkline = 0;
        int iOther = 0;
        int i = 0;
        while (i < iSize) {
            Object objtmp = objs.get(i);
            if (objtmp instanceof LayerSpeciesAlias) {
                LayerMonoSpeciesShape monoShape = (LayerMonoSpeciesShape)((LayerSpeciesAlias)objtmp).getGFramedShape();
                if (monoShape.getSpeciesSymbol() instanceof LayerTagSymbol) {
                    ++iLayerTag;
                } else {
                    ++iLayerAlias;
                }
            } else if (objtmp instanceof LayerCompartmentAlias) {
                ++iLayerCompartment;
            } else if (objtmp instanceof LayerReactionLink) {
                SBSymbol sbml = ((LayerReactionLink)objtmp).getSymbol();
                if (sbml instanceof LayerTagFreeLineSymbol) {
                    return false;
                }
                if (!(sbml instanceof LayerReactionSymbol)) return false;
                ++iLayerLinkline;
            } else {
                ++iOther;
            }
            ++i;
        }
        if (iLayerTag == iSize) {
            return true;
        }
        if (iLayerAlias == iSize) {
            return true;
        }
        if (iLayerCompartment == iSize) {
            return true;
        }
        if (iLayerLinkline == iSize) {
            return true;
        }
        if (iLayerTag > 0) {
            ++iMix;
        }
        if (iLayerAlias > 0) {
            ++iMix;
        }
        if (iLayerCompartment > 0) {
            ++iMix;
        }
        if (iLayerLinkline > 0) {
            ++iMix;
        }
        if (iMix > 1) {
            return false;
        }
        if (iMix != 1 || iOther <= 0) return false;
        return false;
    }

    private void setCenterLocation() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension thisSize = this.getSize();
        if (thisSize.height > screenSize.height) {
            thisSize.height = screenSize.height;
        }
        if (thisSize.width > screenSize.width) {
            thisSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - thisSize.width) / 2, (screenSize.height - thisSize.height) / 2);
    }

    private class CompartmentPanel
    extends JPanel {
        KeyAdapter keyListener;
        JPanel previewPanel = null;
        PainterChooser painterPanel = null;
        MyColorChooser chooser = null;
        JPanel buttonPanel = null;
        final int width = 150;
        final int height = 100;
        CompartmentSymbol symbol = null;
        CompartmentAlias editingAlias = null;
        CompartmentAlias[] editingAliases = null;
        Membrane membrane = null;
        Color color = null;
        PaintScheme painter = null;
        private JTextField defaultThicknessField;
        private JTextField outerLineWidthField;
        private JTextField innerLineWidthField;
        private JButton initButton;
        private JButton applyButton;
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");

        public CompartmentPanel() {
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    CompartmentPanel.this.updateSize();
                }
            };
            super.setLayout(null);
            int x = SBSymbolEditDialog.INSETS.left;
            int y = SBSymbolEditDialog.INSETS.top;
            this.previewPanel = new JPanel();
            this.previewPanel.setBounds(x, y, SBSymbolEditDialog.PREVIEW.width, SBSymbolEditDialog.PREVIEW.height);
            this.previewPanel.setBackground(Color.white);
            this.previewPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Preview"));
            this.add((Component)this.previewPanel, null);
            JPanel thicknessPanel = new JPanel(null);
            thicknessPanel.setBounds(x += SBSymbolEditDialog.PREVIEW.width + 6, y, SBSymbolEditDialog.THICKNESS.width, SBSymbolEditDialog.THICKNESS.height);
            thicknessPanel.setOpaque(false);
            thicknessPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Membrane"));
            this.add((Component)thicknessPanel, null);
            JLabel labelThicknessField = new JLabel("Thickness");
            labelThicknessField.setBounds(10, 20, 70, 20);
            thicknessPanel.add((Component)labelThicknessField, null);
            this.defaultThicknessField = new JTextField();
            this.defaultThicknessField.setBounds(80, 20, 40, 20);
            this.defaultThicknessField.setEditable(true);
            this.defaultThicknessField.addKeyListener(this.keyListener);
            thicknessPanel.add((Component)this.defaultThicknessField, null);
            JPanel lineWidthPanel = new JPanel(null);
            lineWidthPanel.setOpaque(false);
            lineWidthPanel.setBounds(x, y += SBSymbolEditDialog.THICKNESS.height, SBSymbolEditDialog.LINEWIDTH.width, SBSymbolEditDialog.LINEWIDTH.height);
            lineWidthPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Line Width"));
            this.add((Component)lineWidthPanel, null);
            JLabel labelThickWidthField = new JLabel("Outer");
            labelThickWidthField.setBounds(10, 20, 40, 20);
            lineWidthPanel.add((Component)labelThickWidthField, null);
            this.outerLineWidthField = new JTextField();
            this.outerLineWidthField.setBounds(50, 20, 40, 20);
            this.outerLineWidthField.setEditable(true);
            this.outerLineWidthField.addKeyListener(this.keyListener);
            lineWidthPanel.add((Component)this.outerLineWidthField, null);
            JLabel labelThinWidthField = new JLabel("Inner");
            labelThinWidthField.setBounds(110, 20, 40, 20);
            lineWidthPanel.add((Component)labelThinWidthField, null);
            this.innerLineWidthField = new JTextField();
            this.innerLineWidthField.setBounds(150, 20, 40, 20);
            this.innerLineWidthField.setEditable(true);
            this.innerLineWidthField.addKeyListener(this.keyListener);
            lineWidthPanel.add((Component)this.innerLineWidthField, null);
            this.painterPanel = new PainterChooser();
            this.painterPanel.setOpaque(false);
            this.painterPanel.setBounds(x, y += SBSymbolEditDialog.LINEWIDTH.height, SBSymbolEditDialog.PAINTER.width, SBSymbolEditDialog.PAINTER.height);
            this.painterPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Paint"));
            this.add((Component)this.painterPanel, null);
            this.painterPanel.addPainterChangeListener(new PainterChangeListener(){

                @Override
                public void painterChanged(String command) {
                    CompartmentPanel.this.painter_painterChangeDetected(command);
                }
            });
            x = SBSymbolEditDialog.INSETS.left;
            y = SBSymbolEditDialog.INSETS.top + SBSymbolEditDialog.PREVIEW.height;
            this.chooser = new MyColorChooser();
            this.chooser.setBounds(x, y, SBSymbolEditDialog.CHOOSER.width, SBSymbolEditDialog.CHOOSER.height);
            this.chooser.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Color"));
            this.add((Component)this.chooser, null);
            this.chooser.addColorChangeListener(new ColorChangeListener(){

                @Override
                public void colorChanged(Color colorin) {
                    CompartmentPanel.this.chooser_colorChangeDetected(colorin);
                }
            });
            this.buttonPanel = new JPanel(new FlowLayout());
            this.buttonPanel.setBounds(x, y += SBSymbolEditDialog.CHOOSER.height, SBSymbolEditDialog.BUTTONS.width, SBSymbolEditDialog.BUTTONS.height);
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.buttonPanel, null);
            this.initButton = new JButton("Default");
            this.initButton.setMnemonic(68);
            this.initButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompartmentPanel.this.initButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.initButton, null);
            this.applyButton = new JButton("Apply");
            this.applyButton.setMnemonic(65);
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompartmentPanel.this.applyButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.applyButton, null);
            this.okButton.setMnemonic(79);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompartmentPanel.this.okButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.okButton, null);
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CompartmentPanel.this.cancelButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.cancelButton, null);
            this.setPreferredSize(new Dimension(SBSymbolEditDialog.INSETS.left + SBSymbolEditDialog.INSETS.right + SBSymbolEditDialog.CHOOSER.width, SBSymbolEditDialog.INSETS.top + SBSymbolEditDialog.INSETS.bottom + SBSymbolEditDialog.PREVIEW.height + SBSymbolEditDialog.CHOOSER.height + SBSymbolEditDialog.BUTTONS.height));
        }

        private void updateSize() {
            String thick_str = this.defaultThicknessField.getText();
            String w1_str = this.outerLineWidthField.getText();
            String w2_str = this.innerLineWidthField.getText();
            if (thick_str.equals("") || w1_str.equals("") || w2_str.equals("")) {
                return;
            }
            double thickness = this.membrane.getThickness();
            double outerLineWidth = this.membrane.getOuterLineWidth();
            double innerLineWidth = this.membrane.getInnerLineWidth();
            double input_thick = 0.0;
            double input_w1 = 0.0;
            double input_w2 = 0.0;
            try {
                input_thick = Double.parseDouble(thick_str);
                input_w1 = Double.parseDouble(w1_str);
                input_w2 = Double.parseDouble(w2_str);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "input must be a number.", "bad number", 2);
                this.defaultThicknessField.setText("" + thickness);
                this.outerLineWidthField.setText("" + outerLineWidth);
                this.innerLineWidthField.setText("" + innerLineWidth);
                return;
            }
            if (input_thick <= 0.0 || input_w1 <= 0.0 || input_w2 <= 0.0) {
                JOptionPane.showMessageDialog(this, "input must be > 0.", "bad number", 2);
                this.defaultThicknessField.setText("" + thickness);
                this.outerLineWidthField.setText("" + outerLineWidth);
                this.innerLineWidthField.setText("" + innerLineWidth);
                return;
            }
            this.membrane.setThickness(input_thick);
            this.membrane.setOuterLineWidth(input_w1);
            this.membrane.setInnerLineWidth(input_w2);
            this.repaint();
        }

        public void setCompartmentAlias(CompartmentAlias alias) {
            this.editingAliases = null;
            this.editingAlias = alias;
            CompartmentSymbol csymbol = (CompartmentSymbol)((Object)alias.getSymbol());
            if (csymbol instanceof GFramedShape) {
                this.symbol = (CompartmentSymbol)((Object)((GFramedShape)((Object)csymbol)).createCopy());
            } else if (csymbol instanceof GPointedShape) {
                this.symbol = (CompartmentSymbol)((Object)((GPointedShape)((Object)csymbol)).createCopy());
            }
            CompartmentShapePainting painting = new CompartmentShapePainting(csymbol.getComparmentShapePainting());
            this.initialize(painting.getMembrane(), painting.getColor(), painting.getPaintScheme());
        }

        public void setCompartmentAlias(CompartmentAlias[] aliases) {
            this.setCompartmentAlias(aliases[0]);
            this.editingAliases = aliases;
        }

        private void initialize(Membrane membranein, Color colorin, PaintScheme painterin) {
            this.membrane = membranein;
            this.defaultThicknessField.setText(Double.toString(this.membrane.getThickness()));
            this.outerLineWidthField.setText(Double.toString(this.membrane.getOuterLineWidth()));
            this.innerLineWidthField.setText(Double.toString(this.membrane.getInnerLineWidth()));
            this.color = colorin;
            this.chooser.setColor(this.color);
            this.painter = painterin;
            this.painterPanel.setSelected(this.painter.getCode());
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.symbol != null) {
                Graphics2D g2 = (Graphics2D)g;
                if (Preference.antialias) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                } else {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                Dimension d = this.previewPanel.getSize();
                Insets i = new Insets(8, 3, 3, 4);
                Rectangle bounds = this.previewPanel.getBounds();
                double cx = (double)(bounds.x + i.left) + (double)(d.width - i.left - i.right) / 2.0;
                double cy = (double)(bounds.y + i.top) + (double)(d.height - i.top - i.bottom) / 2.0;
                this.symbol.setMembrane(this.membrane);
                ((GColoredShape)((Object)this.symbol)).setColor(this.color);
                ((GColoredShape)((Object)this.symbol)).setPaintScheme(this.painter);
                if (this.symbol instanceof GFramedShape) {
                    double x = cx - 75.0;
                    double y = cy - 50.0;
                    ((GFramedShape)((Object)this.symbol)).updateShape(x, y, 150.0, 100.0);
                    ((GFramedShape)((Object)this.symbol)).drawShape(g2, 1);
                } else if (this.symbol instanceof GPointedShape) {
                    Rectangle2D.Double rect = new Rectangle2D.Double();
                    rect.setFrame(bounds.x + i.left, bounds.y + i.top, d.width - i.left - i.right, d.height - i.top - i.bottom);
                    ((GPointedShape)((Object)this.symbol)).updateShape(cx, cy, rect);
                    ((GPointedShape)((Object)this.symbol)).drawShape(g2, 1);
                }
            }
        }

        private void initButton_actionPerformed(ActionEvent e) {
            String code = ((SBSymbol)((Object)this.symbol)).getCode();
            this.initialize(CompartmentColorScheme.getMembrane(code), CompartmentColorScheme.getColor(code), CompartmentColorScheme.getScheme(code));
            this.repaint();
        }

        private void applyButton_actionPerformed(ActionEvent e) {
            boolean bShowMsg;
            String w2_str;
            String w1_str;
            String thick_str = this.defaultThicknessField.getText();
            if (!this.membrane.isAllHaveBeenInputed(thick_str, w1_str = this.outerLineWidthField.getText(), w2_str = this.innerLineWidthField.getText(), bShowMsg = true)) {
                return;
            }
            if (!this.membrane.isValid(bShowMsg)) {
                return;
            }
            this.applyChange();
        }

        private void okButton_actionPerformed(ActionEvent e) {
            boolean bShowMsg;
            String w2_str;
            String w1_str;
            String thick_str = this.defaultThicknessField.getText();
            if (!this.membrane.isAllHaveBeenInputed(thick_str, w1_str = this.outerLineWidthField.getText(), w2_str = this.innerLineWidthField.getText(), bShowMsg = true)) {
                return;
            }
            if (!this.membrane.isValid(bShowMsg)) {
                return;
            }
            this.applyChange();
            SBSymbolEditDialog.this.dispose();
        }

        private void cancelButton_actionPerformed(ActionEvent e) {
            this.defaultThicknessField.setText("");
            this.outerLineWidthField.setText("");
            this.innerLineWidthField.setText("");
            this.chooser.setColor(null);
            this.painterPanel.setSelected(null);
            SBSymbolEditDialog.this.dispose();
        }

        private void chooser_colorChangeDetected(Color colorin) {
            this.color = colorin;
            this.repaint();
        }

        private void painter_painterChangeDetected(String code) {
            String scheme = PaintSchemeFactory.getName(code);
            this.painter = PaintSchemeFactory.create(scheme);
            this.repaint();
        }

        private boolean applyChange() {
            boolean isChanged;
            CompartmentSymbol shape = (CompartmentSymbol)((Object)this.editingAlias.getSymbol());
            CompartmentShapePainting painting = shape.getComparmentShapePainting();
            boolean bl = isChanged = !this.membrane.equals(painting.getMembrane()) || !this.color.equals(painting.getColor()) || !this.painter.getCode().equals(painting.getPaintScheme().getCode());
            if (isChanged) {
                CompartmentAlias ca;
                Rectangle2D.Double redrawarea = null;
                Vector aliasesL = new Vector();
                Point2D.Double pnt = null;
                boolean isChangedM = false;
                boolean isChangedMt = false;
                boolean isChangedMo = false;
                boolean isChangedMi = false;
                boolean isChangedC = false;
                boolean isChangedP = false;
                HashMap<String, String> mapCompartment = new HashMap<String, String>();
                if (!this.membrane.equals(painting.getMembrane())) {
                    if (this.membrane.getThickness() != painting.getMembrane().getThickness()) {
                        isChangedMt = true;
                    }
                    if (this.membrane.getOuterLineWidth() != painting.getMembrane().getOuterLineWidth()) {
                        isChangedMo = true;
                    }
                    if (this.membrane.getInnerLineWidth() != painting.getMembrane().getInnerLineWidth()) {
                        isChangedMi = true;
                    }
                    isChangedM = true;
                }
                if (!this.color.equals(painting.getColor())) {
                    isChangedC = true;
                }
                if (!this.painter.getCode().equals(painting.getPaintScheme().getCode())) {
                    isChangedP = true;
                }
                Compartment compartment = this.editingAlias.getOriginalCompartment();
                CompartmentAnnotation sExt = (CompartmentAnnotation)LibSBMLUtil.getAnnotation((SBase)compartment, null);
                int flag = 3;
                if (sExt.getReferingAliases().size() > 1) {
                    String title = "The same compartments exist.";
                    String msg = "Change all the same " + compartment.getId() + " in this model?";
                    int ans = JOptionPane.showConfirmDialog(this, msg, title, 1, 3, null);
                    if (ans == 2) {
                        return false;
                    }
                    if (ans == 0) {
                        flag = 1;
                    }
                    if (ans == 1) {
                        flag = 2;
                    }
                    mapCompartment.put(compartment.getName(), compartment.getName());
                }
                aliasesL = sExt.getReferingAliases();
                try {
                    int j = 0;
                    while (j < aliasesL.size()) {
                        ca = (CompartmentAlias)aliasesL.elementAt(j);
                        Rectangle2D redrawareatmp = ca.getCompartmentMaxRepaintBounds();
                        redrawarea = GUtil.union(redrawarea, redrawareatmp);
                        ++j;
                    }
                }
                catch (Exception j) {
                    // empty catch block
                }
                if (this.editingAliases == null || this.editingAliases.length == 0) {
                    SBSymbolEditDialog.this.sbmodel.changeCompartmentShapePainting(this.editingAlias, new CompartmentShapePainting(this.membrane, this.color, this.painter), flag);
                    try {
                        int j = 0;
                        while (j < aliasesL.size()) {
                            ca = (CompartmentAlias)aliasesL.elementAt(j);
                            Rectangle2D redrawareatmp = ca.getCompartmentMaxRepaintBounds();
                            redrawarea = GUtil.union(redrawarea, redrawareatmp);
                            pnt = (Point2D.Double)ca.getCompartmentNameImage().getFramePosition().clone();
                            pnt = ca.recalCompartmentNameDisplayPostion(new Point2D.Double(pnt.x, pnt.y));
                            ca.getCompartmentNameImage().setFramePositionWithoutRecalcPostion(pnt.x, pnt.y);
                            redrawareatmp = ca.getCompartmentMaxRepaintBounds();
                            redrawarea = GUtil.union(redrawarea, redrawareatmp);
                            ++j;
                        }
                        SBSymbolEditDialog.this.sbmodel.getGStructure().callbyuserRepaint(redrawarea);
                    }
                    catch (Exception j) {
                        // empty catch block
                    }
                    try {
                        SBSymbolEditDialog.this.sbmodel.getGStructure().callbyuserRepaint(redrawarea);
                    }
                    catch (Exception j) {
                        // empty catch block
                    }
                    return isChanged;
                }
                Vector aliases = new Vector();
                Vector oldpaintings = new Vector();
                Vector newpaintings = new Vector();
                boolean doFlg = false;
                SBSymbolEditDialog.this.sbmodel.changeCompartmentShapePainting(this.editingAlias, new CompartmentShapePainting(this.membrane, this.color, this.painter), flag, doFlg, aliases, oldpaintings, newpaintings, isChangedM, isChangedC, isChangedP, isChangedMt, isChangedMo, isChangedMi);
                try {
                    int j = 0;
                    while (j < aliasesL.size()) {
                        CompartmentAlias ca2 = (CompartmentAlias)aliasesL.elementAt(j);
                        Rectangle2D redrawareatmp = ca2.getCompartmentMaxRepaintBounds();
                        redrawarea = GUtil.union(redrawarea, redrawareatmp);
                        pnt = (Point2D.Double)ca2.getCompartmentNameImage().getFramePosition().clone();
                        pnt = ca2.recalCompartmentNameDisplayPostion(new Point2D.Double(pnt.x, pnt.y));
                        ca2.getCompartmentNameImage().setFramePositionWithoutRecalcPostion(pnt.x, pnt.y);
                        redrawareatmp = ca2.getCompartmentMaxRepaintBounds();
                        redrawarea = GUtil.union(redrawarea, redrawareatmp);
                        ++j;
                    }
                }
                catch (Exception j) {
                    // empty catch block
                }
                int i = 1;
                while (i < this.editingAliases.length) {
                    CompartmentAlias ca3;
                    compartment = this.editingAliases[i].getOriginalCompartment();
                    sExt = (CompartmentAnnotation)LibSBMLUtil.getAnnotation((SBase)compartment, null);
                    flag = 3;
                    if (sExt.getReferingAliases().size() > 1 && !mapCompartment.containsKey(compartment.getName())) {
                        String title = "The same compartments exist.";
                        String msg = "Change all the same " + compartment.getId() + " in this model?";
                        int ans = JOptionPane.showConfirmDialog(this, msg, title, 1, 3, null);
                        if (ans == 2) {
                            return false;
                        }
                        if (ans == 0) {
                            flag = 1;
                        }
                        if (ans == 1) {
                            flag = 2;
                        }
                        mapCompartment.put(compartment.getName(), compartment.getName());
                    }
                    try {
                        aliasesL = sExt.getReferingAliases();
                        int j = 0;
                        while (j < aliasesL.size()) {
                            ca3 = (CompartmentAlias)aliasesL.elementAt(j);
                            Rectangle2D redrawareatmp = ca3.getCompartmentMaxRepaintBounds();
                            redrawarea = GUtil.union(redrawarea, redrawareatmp);
                            ++j;
                        }
                    }
                    catch (Exception j) {
                        // empty catch block
                    }
                    if (i == this.editingAliases.length - 1) {
                        doFlg = true;
                    }
                    SBSymbolEditDialog.this.sbmodel.changeCompartmentShapePainting(this.editingAliases[i], new CompartmentShapePainting(this.membrane, this.color, this.painter), flag, doFlg, aliases, oldpaintings, newpaintings, isChangedM, isChangedC, isChangedP, isChangedMt, isChangedMo, isChangedMi);
                    try {
                        aliasesL = sExt.getReferingAliases();
                        int j = 0;
                        while (j < aliasesL.size()) {
                            ca3 = (CompartmentAlias)aliasesL.elementAt(j);
                            Rectangle2D redrawareatmp = ca3.getCompartmentMaxRepaintBounds();
                            redrawarea = GUtil.union(redrawarea, redrawareatmp);
                            pnt = (Point2D.Double)ca3.getCompartmentNameImage().getFramePosition().clone();
                            pnt = ca3.recalCompartmentNameDisplayPostion(new Point2D.Double(pnt.x, pnt.y));
                            ca3.getCompartmentNameImage().setFramePositionWithoutRecalcPostion(pnt.x, pnt.y);
                            redrawareatmp = ca3.getCompartmentMaxRepaintBounds();
                            redrawarea = GUtil.union(redrawarea, redrawareatmp);
                            ++j;
                        }
                        SBSymbolEditDialog.this.sbmodel.getGStructure().callbyuserRepaint(redrawarea);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                try {
                    SBSymbolEditDialog.this.sbmodel.getGStructure().callbyuserRepaint(redrawarea);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return isChanged;
        }
    }

    private class LayerCompartmentPanel
    extends JPanel {
        KeyAdapter keyListener;
        JPanel previewPanel = null;
        PainterChooser painterPanel = null;
        MyColorChooser chooser = null;
        JPanel buttonPanel = null;
        JCheckBox checkPaintInner = null;
        final int width = 150;
        final int height = 100;
        LayerCompartmentSymbol symbol = null;
        LayerCompartmentAlias editingAlias = null;
        LayerCompartmentAlias[] editingAliases = null;
        Membrane membrane = null;
        Color color = null;
        PaintScheme painter = null;
        private JButton initButton;
        private JButton applyButton;
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");

        public LayerCompartmentPanel() {
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    LayerCompartmentPanel.this.updateSize();
                }
            };
            super.setLayout(null);
            int x = SBSymbolEditDialog.INSETS.left;
            int y = SBSymbolEditDialog.INSETS.top;
            this.previewPanel = new JPanel();
            this.previewPanel.setBounds(x, y, SBSymbolEditDialog.PREVIEW.width, SBSymbolEditDialog.PREVIEW.height);
            this.previewPanel.setBackground(Color.white);
            this.previewPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Preview"));
            this.add((Component)this.previewPanel, null);
            this.checkPaintInner = new JCheckBox("fill inner");
            this.checkPaintInner.setBounds(SBSymbolEditDialog.PREVIEW.width + 6, y, 100, 30);
            this.checkPaintInner.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayerCompartmentPanel.this.painterPanel.setEnabled(LayerCompartmentPanel.this.checkPaintInner.isSelected());
                    LayerCompartmentPanel.this.painterPanel.setGradationButtonEnable(LayerCompartmentPanel.this.checkPaintInner.isSelected());
                    LayerCompartmentPanel.this.painterPanel.setColorButtonEnable(LayerCompartmentPanel.this.checkPaintInner.isSelected());
                    LayerCompartmentPanel.this.symbol.setPaintInnerFlg(LayerCompartmentPanel.this.checkPaintInner.isSelected());
                    LayerCompartmentPanel.this.painter_innerChange(null);
                }
            });
            this.add(this.checkPaintInner);
            this.painterPanel = new PainterChooser();
            this.painterPanel.setOpaque(false);
            this.painterPanel.setBounds(SBSymbolEditDialog.PREVIEW.width + 6, y += SBSymbolEditDialog.LINE.height, SBSymbolEditDialog.PAINTER.width, SBSymbolEditDialog.PAINTER.height);
            this.painterPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Paint"));
            this.add((Component)this.painterPanel, null);
            this.painterPanel.addPainterChangeListener(new PainterChangeListener(){

                @Override
                public void painterChanged(String command) {
                    LayerCompartmentPanel.this.painter_innerChange(command);
                }
            });
            x = SBSymbolEditDialog.INSETS.left;
            y = SBSymbolEditDialog.INSETS.top + SBSymbolEditDialog.PREVIEW.height;
            this.chooser = new MyColorChooser();
            this.chooser.setBounds(x, y, SBSymbolEditDialog.CHOOSER.width, SBSymbolEditDialog.CHOOSER.height);
            this.chooser.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Color"));
            this.add((Component)this.chooser, null);
            this.chooser.addColorChangeListener(new ColorChangeListener(){

                @Override
                public void colorChanged(Color colorin) {
                    LayerCompartmentPanel.this.chooser_colorChangeDetected(colorin);
                }
            });
            this.buttonPanel = new JPanel(new FlowLayout());
            this.buttonPanel.setBounds(x, y += SBSymbolEditDialog.CHOOSER.height, SBSymbolEditDialog.BUTTONS.width, SBSymbolEditDialog.BUTTONS.height);
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.buttonPanel, null);
            this.initButton = new JButton("Default");
            this.initButton.setMnemonic(68);
            this.initButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayerCompartmentPanel.this.initButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.initButton, null);
            this.applyButton = new JButton("Apply");
            this.applyButton.setMnemonic(65);
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayerCompartmentPanel.this.applyButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.applyButton, null);
            this.okButton.setMnemonic(79);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayerCompartmentPanel.this.okButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.okButton, null);
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayerCompartmentPanel.this.cancelButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.cancelButton, null);
            this.setPreferredSize(new Dimension(SBSymbolEditDialog.INSETS.left + SBSymbolEditDialog.INSETS.right + SBSymbolEditDialog.CHOOSER.width, SBSymbolEditDialog.INSETS.top + SBSymbolEditDialog.INSETS.bottom + SBSymbolEditDialog.PREVIEW.height + SBSymbolEditDialog.CHOOSER.height + SBSymbolEditDialog.BUTTONS.height));
        }

        private void updateSize() {
            this.repaint();
        }

        private void painter_innerChange(String code) {
            if (code != null) {
                String scheme = PaintSchemeFactory.getName(code);
                this.painter = PaintSchemeFactory.create(scheme);
                this.symbol.setPaintScheme(this.painter, true);
            }
            this.repaint();
        }

        public void setCompartmentAlias(LayerCompartmentAlias alias, boolean inner) {
            this.editingAliases = null;
            this.editingAlias = alias;
            LayerCompartmentSymbol csymbol = (LayerCompartmentSymbol)((Object)alias.getSymbol());
            this.symbol = (LayerCompartmentSymbol)((Object)((GFramedShape)((Object)csymbol)).createCopy());
            this.checkPaintInner.setVisible(SBSymbolEditDialog.this.isInner);
            this.painterPanel.setVisible(SBSymbolEditDialog.this.isInner);
            if (SBSymbolEditDialog.this.isInner && this.symbol != null && this.symbol instanceof LayerCompartmentSymbol) {
                LayerCompartmentSymbol layerSymbol = this.symbol;
                this.checkPaintInner.setSelected(this.symbol.isPaintInner());
                if (layerSymbol.isPaintInner()) {
                    if (this.painter == null) {
                        this.painter = this.symbol.getPaintScheme(SBSymbolEditDialog.this.isInner);
                    }
                    this.painterPanel.setSelected(this.painter.getCode());
                }
                this.painterPanel.setGradationButtonEnable(this.symbol.isPaintInner());
                this.painterPanel.setColorButtonEnable(this.symbol.isPaintInner());
                this.painterPanel.setEnabled(this.symbol.isPaintInner());
            }
            CompartmentShapePainting painting = new CompartmentShapePainting(csymbol.getCompartmentShapePainting(SBSymbolEditDialog.this.isInner));
            this.initialize(painting.getMembrane(), painting.getColor(), painting.getPaintScheme());
        }

        public void setCompartmentAlias(LayerCompartmentAlias[] aliases, boolean inner) {
            this.setCompartmentAlias(aliases[0], inner);
            this.editingAliases = aliases;
        }

        private void initialize(Membrane membranein, Color colorin, PaintScheme painterin) {
            this.membrane = membranein;
            this.color = colorin;
            this.chooser.setColor(this.color);
            this.painter = painterin;
            this.painterPanel.setSelected(this.painter.getCode());
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.symbol != null) {
                Graphics2D g2 = (Graphics2D)g;
                if (Preference.antialias) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                } else {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                Dimension d = this.previewPanel.getSize();
                Insets i = new Insets(8, 3, 3, 4);
                Rectangle bounds = this.previewPanel.getBounds();
                double cx = (double)(bounds.x + i.left) + (double)(d.width - i.left - i.right) / 2.0;
                double cy = (double)(bounds.y + i.top) + (double)(d.height - i.top - i.bottom) / 2.0;
                if (this.symbol instanceof LayerCompartmentSymbol) {
                    this.symbol.setColor(this.color, SBSymbolEditDialog.this.isInner);
                    this.symbol.setPaintScheme(this.painter, SBSymbolEditDialog.this.isInner);
                } else {
                    ((GColoredShape)((Object)this.symbol)).setColor(this.color);
                    ((GColoredShape)((Object)this.symbol)).setPaintScheme(this.painter);
                }
                if (this.symbol instanceof GFramedShape) {
                    double x = cx - 75.0;
                    double y = cy - 50.0;
                    ((GFramedShape)((Object)this.symbol)).updateShape(x, y, 150.0, 100.0);
                    ((GFramedShape)((Object)this.symbol)).drawShape(g2, 1);
                } else if (this.symbol instanceof GPointedShape) {
                    Rectangle2D.Double rect = new Rectangle2D.Double();
                    rect.setFrame(bounds.x + i.left, bounds.y + i.top, d.width - i.left - i.right, d.height - i.top - i.bottom);
                    ((GPointedShape)((Object)this.symbol)).updateShape(cx, cy, rect);
                    ((GPointedShape)((Object)this.symbol)).drawShape(g2, 1);
                }
            }
        }

        private void initButton_actionPerformed(ActionEvent e) {
            String code = ((SBSymbol)((Object)this.symbol)).getCode();
            this.initialize(CompartmentColorScheme.getMembrane(code), CompartmentColorScheme.getColor(code), CompartmentColorScheme.getScheme(code));
            if (this.symbol != null && this.symbol instanceof LayerCompartmentSymbol && SBSymbolEditDialog.this.isInner) {
                LayerCompartmentSymbol layerSymbol = this.symbol;
                layerSymbol.initInnerPaintColor();
                this.initialize(CompartmentColorScheme.getMembrane(code), layerSymbol.getColor(true), layerSymbol.getPaintScheme(true));
            }
            this.repaint();
        }

        private void applyButton_actionPerformed(ActionEvent e) {
            this.applyChange();
        }

        private void okButton_actionPerformed(ActionEvent e) {
            this.applyChange();
            SBSymbolEditDialog.this.dispose();
        }

        private void cancelButton_actionPerformed(ActionEvent e) {
            this.chooser.setColor(null);
            this.painterPanel.setSelected(null);
            SBSymbolEditDialog.this.dispose();
        }

        private void chooser_colorChangeDetected(Color colorin) {
            this.color = colorin;
            this.repaint();
        }

        private void painter_painterChangeDetected(String code) {
            String scheme = PaintSchemeFactory.getName(code);
            this.painter = PaintSchemeFactory.create(scheme);
            this.repaint();
        }

        private boolean applyChange() {
            LayerCompartmentSymbol shape = (LayerCompartmentSymbol)((Object)this.editingAlias.getSymbol());
            CompartmentShapePainting painting = shape.getCompartmentShapePainting(SBSymbolEditDialog.this.isInner);
            boolean isChanged = false;
            if (this.symbol.isPaintInner() != shape.isPaintInner()) {
                isChanged = true;
            }
            if (!isChanged) {
                if (this.symbol.isPaintInner()) {
                    if (!this.color.equals(painting.getColor()) || !this.painter.getCode().equals(painting.getPaintScheme().getCode())) {
                        isChanged = true;
                    }
                } else {
                    boolean bl = isChanged = !this.color.equals(painting.getColor());
                }
            }
            if (isChanged) {
                int flag = 3;
                CompartmentShapePainting newpaint = new CompartmentShapePainting(this.membrane, this.color, this.painter);
                try {
                    try {
                        SBSymbolEditDialog.this.sbmodel.eventGroupBegan(null);
                        boolean bPInner = this.symbol.isPaintInner();
                        SBSymbolEditDialog.this.sbmodel.changeCompartmentShapePainting(this.editingAlias, newpaint, flag, SBSymbolEditDialog.this.isInner, bPInner);
                        if (this.editingAliases != null && this.editingAliases.length > 1) {
                            int i = 1;
                            while (i < this.editingAliases.length) {
                                LayerCompartmentSymbol csymbol = (LayerCompartmentSymbol)((Object)this.editingAliases[i].getSymbol());
                                Membrane mbr = csymbol.getCompartmentShapePainting().getMembrane();
                                newpaint = new CompartmentShapePainting(mbr, this.color, this.painter);
                                if (!SBSymbolEditDialog.this.isInner) {
                                    bPInner = csymbol.isPaintInner();
                                }
                                SBSymbolEditDialog.this.sbmodel.changeCompartmentShapePainting(this.editingAliases[i], newpaint, flag, SBSymbolEditDialog.this.isInner, bPInner);
                                ++i;
                            }
                        }
                    }
                    catch (Exception exception) {
                        SBSymbolEditDialog.this.sbmodel.eventGroupEnded(null);
                    }
                }
                finally {
                    SBSymbolEditDialog.this.sbmodel.eventGroupEnded(null);
                }
            }
            return isChanged;
        }
    }

    private class LayerReactionPanel
    extends JPanel {
        KeyAdapter keyListener;
        JPanel previewPanel = null;
        JPanel sizePanel = null;
        JPanel linePanel = null;
        PainterChooser painterPanel = null;
        MyColorChooser chooser = null;
        JPanel buttonPanel = null;
        MonoSpeciesShape monoshape = null;
        SpeciesAlias editingAlias = null;
        LayerReactionSymbol symbol;
        LayerReactionLink link;
        LayerReactionLink[] editingLinkes = null;
        Color color = null;
        double lineWidth = 0.0;
        boolean isDotted = false;
        private JTextField lineWidthField;
        private JButton initButton;
        private JButton applyButton;
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");

        public LayerReactionPanel() {
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    LayerReactionPanel.this.updateSize();
                }
            };
            super.setLayout(null);
            int x = SBSymbolEditDialog.INSETS.left;
            int y = SBSymbolEditDialog.INSETS.top;
            this.previewPanel = new JPanel();
            this.previewPanel.setBounds(new Rectangle(x, y, SBSymbolEditDialog.PREVIEW.width, SBSymbolEditDialog.PREVIEW.height));
            this.previewPanel.setBackground(Color.white);
            this.previewPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Preview"));
            this.add((Component)this.previewPanel, null);
            this.linePanel = new JPanel();
            this.linePanel.setLayout(null);
            this.linePanel.setOpaque(false);
            this.linePanel.setBounds(x += SBSymbolEditDialog.PREVIEW.width + 6, y, SBSymbolEditDialog.LINE.width, SBSymbolEditDialog.LINE.height);
            this.linePanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Line"));
            this.add((Component)this.linePanel, null);
            JLabel labelLineWidthField = new JLabel("Width");
            labelLineWidthField.setBounds(10, 20, 40, 20);
            this.linePanel.add((Component)labelLineWidthField, null);
            this.lineWidthField = new JTextField();
            this.lineWidthField.setBounds(50, 20, 40, 20);
            this.lineWidthField.setEditable(true);
            this.lineWidthField.addKeyListener(this.keyListener);
            this.linePanel.add((Component)this.lineWidthField, null);
            this.painterPanel = new PainterChooser("normal", "dot");
            this.painterPanel.setOpaque(false);
            this.painterPanel.setBounds(x, y += SBSymbolEditDialog.LINE.height, SBSymbolEditDialog.PAINTER.width, SBSymbolEditDialog.PAINTER.height);
            this.painterPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Type"));
            this.add((Component)this.painterPanel, null);
            this.painterPanel.addPainterChangeListener(new PainterChangeListener(){

                @Override
                public void painterChanged(String command) {
                    LayerReactionPanel.this.painter_painterChangeDetected(command);
                }
            });
            x = SBSymbolEditDialog.INSETS.left;
            y = SBSymbolEditDialog.INSETS.top + SBSymbolEditDialog.PREVIEW.height;
            this.chooser = new MyColorChooser();
            this.chooser.setBounds(x, y, SBSymbolEditDialog.CHOOSER.width, SBSymbolEditDialog.CHOOSER.height);
            this.chooser.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Color"));
            this.add((Component)this.chooser, null);
            this.chooser.addColorChangeListener(new ColorChangeListener(){

                @Override
                public void colorChanged(Color colorin) {
                    LayerReactionPanel.this.chooser_colorChangeDetected(colorin);
                }
            });
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBounds(x, y += SBSymbolEditDialog.CHOOSER.height, SBSymbolEditDialog.BUTTONS.width, SBSymbolEditDialog.BUTTONS.height);
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.buttonPanel, null);
            this.initButton = new JButton("Default");
            this.initButton.setMnemonic(68);
            this.initButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayerReactionPanel.this.initButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.initButton, null);
            this.applyButton = new JButton("Apply");
            this.applyButton.setMnemonic(65);
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayerReactionPanel.this.applyButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.applyButton, null);
            this.okButton.setMnemonic(79);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayerReactionPanel.this.okButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.okButton, null);
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayerReactionPanel.this.cancelButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.cancelButton, null);
            this.setPreferredSize(new Dimension(SBSymbolEditDialog.INSETS.left + SBSymbolEditDialog.INSETS.right + SBSymbolEditDialog.CHOOSER.width, SBSymbolEditDialog.INSETS.top + SBSymbolEditDialog.INSETS.bottom + SBSymbolEditDialog.PREVIEW.height + SBSymbolEditDialog.CHOOSER.height + SBSymbolEditDialog.BUTTONS.height));
        }

        private void updateSize() {
            String linew_str = this.lineWidthField.getText();
            if (linew_str.equals("")) {
                return;
            }
            double input_linew = 0.0;
            try {
                input_linew = Double.parseDouble(linew_str);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "input must be a number.", "bad number", 2);
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                return;
            }
            if (input_linew < 1.0) {
                JOptionPane.showMessageDialog(this, "line width must be >= 1.", "bad number", 2);
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                return;
            }
            if (input_linew >= 1.0) {
                this.lineWidth = input_linew;
                this.repaint();
            }
        }

        public void setReactionLink(LayerReactionLink link_object) {
            this.editingLinkes = null;
            this.link = link_object;
            String code = this.link.getSymbol().getCode();
            this.symbol = (LayerReactionSymbol)((Object)EditComponentsDialog2.getSymbolByCode(code));
            Color color = new Color(0, 0, 0);
            color = this.link.getGLinkedShape().getColor();
            this.lineWidth = this.link.getGLinkedShape().getLineWidth();
            this.isDotted = ((LayerReactionSymbol)((Object)this.link.getSymbol())).isDotted();
            this.initialize(this.lineWidth, color, code, this.isDotted);
        }

        public void setReactionLink(LayerReactionLink[] link_object) {
            this.setReactionLink(link_object[0]);
            this.editingLinkes = link_object;
        }

        protected void initialize(double linewidth, Color colorin, String code, boolean isDotted) {
            this.color = colorin;
            this.chooser.setColor(this.color);
            this.lineWidth = linewidth;
            this.lineWidthField.setText(Double.toString(this.lineWidth));
            if (code.equals("UNKNOWN")) {
                this.lineWidthField.setEnabled(false);
            } else {
                this.lineWidthField.setEnabled(true);
            }
            if (isDotted) {
                this.painter_painterChangeDetected("dot");
                this.painterPanel.setSelected("dot");
            } else {
                this.painter_painterChangeDetected("normal");
                this.painterPanel.setSelected("normal");
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.symbol != null) {
                Graphics2D g2 = (Graphics2D)g;
                if (Preference.antialias) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                } else {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                Dimension d = this.previewPanel.getSize();
                Rectangle bounds = this.previewPanel.getBounds();
                Insets i = new Insets(8, 3, 3, 4);
                bounds.x += i.left;
                bounds.y += i.top;
                bounds.width = d.width - i.left - i.right;
                bounds.height = d.height - i.top - i.bottom;
                this.symbol.drawPreview(g2, bounds, this.color, this.lineWidth);
            }
        }

        protected void initButton_actionPerformed(ActionEvent e) {
            String code = ((SBSymbol)((Object)this.symbol)).getCode();
            this.color = ReactionColorScheme.getColor(code);
            this.lineWidth = ReactionColorScheme.getLineWidth(code);
            this.chooser.setColor(this.color);
            this.lineWidthField.setText(Double.toString(this.lineWidth));
            this.repaint();
        }

        protected void applyButton_actionPerformed(ActionEvent e) {
            this.applyChange();
        }

        protected void okButton_actionPerformed(ActionEvent e) {
            this.applyChange();
            SBSymbolEditDialog.this.dispose();
        }

        protected void cancelButton_actionPerformed(ActionEvent e) {
            this.chooser.setColor(null);
            this.lineWidthField.setText("");
            SBSymbolEditDialog.this.dispose();
        }

        private void chooser_colorChangeDetected(Color colorin) {
            this.color = colorin;
            this.repaint();
        }

        private void painter_painterChangeDetected(String code) {
            if (code.equals("dot")) {
                this.symbol.setIsDotted(true);
            } else {
                this.symbol.setIsDotted(false);
            }
            this.repaint();
        }

        private boolean applyChange() {
            boolean isChanged;
            boolean bl = isChanged = this.lineWidth != this.link.getGLinkedShape().getLineWidth() || !this.color.equals(this.link.getGLinkedShape().getColor()) || this.isDotted != this.symbol.isDotted();
            if (isChanged) {
                try {
                    try {
                        SBSymbolEditDialog.this.sbmodel.eventGroupBegan(null);
                        SBSymbolEditDialog.this.sbmodel.changeLayerLinkPainting(this.link, this.lineWidth, this.color, this.symbol.isDotted(), null);
                        if (this.editingLinkes != null && this.editingLinkes.length > 1) {
                            int i = 1;
                            while (i < this.editingLinkes.length) {
                                SBSymbolEditDialog.this.sbmodel.changeLayerLinkPainting(this.editingLinkes[i], this.lineWidth, this.color, this.symbol.isDotted(), null);
                                ++i;
                            }
                        }
                    }
                    catch (Exception exception) {
                        SBSymbolEditDialog.this.sbmodel.eventGroupEnded(null);
                    }
                }
                finally {
                    SBSymbolEditDialog.this.sbmodel.eventGroupEnded(null);
                }
            }
            return isChanged;
        }
    }

    private class LayerSpeciesPanel
    extends JPanel {
        KeyAdapter keyListener;
        JPanel previewPanel = null;
        PainterChooser painterPanel = null;
        MyColorChooser chooser = null;
        JPanel buttonPanel = null;
        LayerSpeciesSymbol symbol = null;
        LayerSpeciesAlias editingAlias = null;
        LayerSpeciesAlias[] editingAliases = null;
        LayerMonoSpeciesShape monoshape = null;
        Color color = null;
        int iFntSz = 11;
        PaintScheme painter = null;
        private int[] iFsizeArr = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
        private String[] strFsizeArr = new String[this.iFsizeArr.length];
        JComboBox jcmbbxFntsize;
        int w = 0;
        int h = 0;
        private JButton initButton;
        private JButton applyButton;
        private JButton okButton;
        private JButton cancelButton;

        public LayerSpeciesPanel() {
            int i = 0;
            while (i < this.iFsizeArr.length) {
                this.strFsizeArr[i] = "" + this.iFsizeArr[i];
                ++i;
            }
            this.jcmbbxFntsize = new JComboBox<String>(this.strFsizeArr);
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    LayerSpeciesPanel.this.updateSize();
                }
            };
            super.setLayout(null);
            int x = SBSymbolEditDialog.INSETS.left;
            int y = SBSymbolEditDialog.INSETS.top;
            this.previewPanel = new JPanel();
            this.previewPanel.setBounds(x, y, SBSymbolEditDialog.PREVIEW.width, SBSymbolEditDialog.PREVIEW.height);
            this.previewPanel.setBackground(Color.white);
            this.previewPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Preview"));
            this.add((Component)this.previewPanel, null);
            JLabel fntsizeLabel = new JLabel("Font Size");
            fntsizeLabel.setBounds(283, 10, 60, 20);
            this.add(fntsizeLabel);
            this.jcmbbxFntsize.setMaximumRowCount(10);
            this.jcmbbxFntsize.setBounds(348, 10, 100, 20);
            this.jcmbbxFntsize.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    LayerSpeciesPanel.this.iFntSz = LayerSpeciesPanel.this.iFsizeArr[((JComboBox)e.getSource()).getSelectedIndex()];
                    LayerSpeciesPanel.this.fntsizeChangeDetected();
                    ((JComboBox)e.getSource()).transferFocus();
                }
            });
            this.add((Component)this.jcmbbxFntsize, null);
            this.painterPanel = new PainterChooser();
            this.painterPanel.setOpaque(false);
            this.painterPanel.setBounds(x, y += SBSymbolEditDialog.LINE.height, SBSymbolEditDialog.PAINTER.width, SBSymbolEditDialog.PAINTER.height);
            this.painterPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Paint"));
            this.add((Component)this.painterPanel, null);
            this.painterPanel.addPainterChangeListener(new PainterChangeListener(){

                @Override
                public void painterChanged(String command) {
                    LayerSpeciesPanel.this.painter_painterChangeDetected(command);
                }
            });
            x = SBSymbolEditDialog.INSETS.left;
            y = SBSymbolEditDialog.INSETS.top + SBSymbolEditDialog.PREVIEW.height;
            this.chooser = new MyColorChooser();
            this.chooser.setBounds(x, y, SBSymbolEditDialog.CHOOSER.width, SBSymbolEditDialog.CHOOSER.height);
            this.chooser.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Color"));
            this.add((Component)this.chooser, null);
            this.chooser.addColorChangeListener(new ColorChangeListener(){

                @Override
                public void colorChanged(Color colorin) {
                    LayerSpeciesPanel.this.chooser_colorChangeDetected(colorin);
                }
            });
            this.buttonPanel = new JPanel(new FlowLayout());
            this.buttonPanel.setBounds(x, y += SBSymbolEditDialog.CHOOSER.height, SBSymbolEditDialog.BUTTONS.width, SBSymbolEditDialog.BUTTONS.height);
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.buttonPanel, null);
            this.initButton = new JButton("Default");
            this.initButton.setMnemonic(68);
            this.initButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayerSpeciesPanel.this.initButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.initButton, null);
            this.applyButton = new JButton("Apply");
            this.applyButton.setMnemonic(65);
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayerSpeciesPanel.this.applyButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.applyButton, null);
            this.okButton.setMnemonic(79);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayerSpeciesPanel.this.okButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.okButton, null);
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LayerSpeciesPanel.this.cancelButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.cancelButton, null);
            this.setPreferredSize(new Dimension(SBSymbolEditDialog.INSETS.left + SBSymbolEditDialog.INSETS.right + SBSymbolEditDialog.CHOOSER.width, SBSymbolEditDialog.INSETS.top + SBSymbolEditDialog.INSETS.bottom + SBSymbolEditDialog.PREVIEW.height + SBSymbolEditDialog.CHOOSER.height + SBSymbolEditDialog.BUTTONS.height));
        }

        private void updateSize() {
            this.repaint();
        }

        public void setSpeciesAlias(LayerSpeciesAlias alias) {
            this.editingAliases = null;
            this.editingAlias = alias;
            LayerMonoSpeciesShape shape = (LayerMonoSpeciesShape)alias.getGFramedShape();
            this.iFntSz = shape.getLayerTextFontSize();
            try {
                this.painter = (PaintScheme)shape.getPaintScheme().getClass().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Color color = new Color(shape.getSpeciesSymbol().getFontColor().getRed(), shape.getSpeciesSymbol().getFontColor().getGreen(), shape.getSpeciesSymbol().getFontColor().getBlue(), shape.getSpeciesSymbol().getFontColor().getAlpha());
            BasicStroke stroke = new BasicStroke((float)shape.getLineWidth(), 0, 1);
            this.painter.setColor(color);
            this.painter.setStroke(stroke);
            this.painterPanel.setVisible(false);
            String code = ((SBSymbol)((Object)shape.getSpeciesSymbol())).getCode();
            Point2D.Double size = alias.getFrameSize();
            this.monoshape = (LayerMonoSpeciesShape)shape.duplicate();
            this.monoshape.setActive(shape.isActive());
            this.initialize((int)size.x, (int)size.y, this.monoshape.getLineWidth(), color, this.monoshape.getPaintScheme(), code);
        }

        public void setSpeciesAlias(LayerSpeciesAlias[] aliases) {
            this.setSpeciesAlias(aliases[0]);
            this.editingAliases = aliases;
        }

        protected void initialize(int width, int height, double linewidth, Color colorin, PaintScheme painterin, String code) {
            this.w = width;
            this.h = height;
            this.jcmbbxFntsize.setSelectedItem("" + this.iFntSz);
            this.jcmbbxFntsize.transferFocus();
            this.color = colorin;
            this.chooser.setColor(this.color);
            this.painter = painterin;
            this.painterPanel.setSelected(this.painter.getCode());
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            if (Preference.antialias) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            Dimension d = this.previewPanel.getSize();
            Rectangle bounds = this.previewPanel.getBounds();
            Insets i = new Insets(10, 5, 5, 5);
            Rectangle clipBounds = new Rectangle(bounds.x + i.left, bounds.y + i.top, bounds.width - i.left - i.right, bounds.height - i.top - i.bottom);
            double x = (double)(bounds.x + i.left) + (double)(d.width - i.left - i.right - this.w) / 2.0;
            double y = (double)(bounds.y + i.top) + (double)(d.height - i.top - i.bottom - this.h) / 2.0;
            if (x + (double)this.w + 0.0 > (double)(clipBounds.x + clipBounds.width)) {
                x = clipBounds.x + clipBounds.width - this.w - 0;
            }
            if (y + (double)this.h + 0.0 > (double)(clipBounds.y + clipBounds.height)) {
                y = clipBounds.y + clipBounds.height - this.h - 0;
            }
            double border_X = x;
            double border_Y = y;
            double border_W = this.w;
            double border_H = this.h;
            if (border_X < 10.0) {
                border_X = 10.0;
            }
            if (border_Y < 20.0) {
                border_Y = 20.0;
            }
            if (border_W > 220.0) {
                border_W = 220.0;
            }
            if (border_H > 135.0) {
                border_H = 135.0;
            }
            this.monoshape.updateShape(border_X, border_Y, border_W, border_H);
            this.monoshape.setColor(this.color);
            this.monoshape.setLayerTextFontSize(this.iFntSz);
            this.monoshape.setLineWidth(1.0);
            this.monoshape.setPaintScheme(this.painter);
            this.monoshape.getSpeciesSymbol().setFontColor(this.color);
            g2.setClip(clipBounds);
            this.monoshape.drawShape(g2, 1);
        }

        protected void initButton_actionPerformed(ActionEvent e) {
            LayerSpeciesSymbol symbol = this.monoshape.getSpeciesSymbol();
            Dimension d = symbol.defaultSize();
            String code = ((SBSymbol)((Object)symbol)).getCode();
            this.w = d.width;
            this.h = d.height;
            this.jcmbbxFntsize.setSelectedItem("11");
            this.color = SpeciesColorScheme.getColor(code);
            this.painter = SpeciesColorScheme.getScheme(code);
            this.chooser.setColor(this.color);
            this.painterPanel.setSelected(this.painter.getCode());
            this.repaint();
        }

        private void applyButton_actionPerformed(ActionEvent e) {
            this.applyChange();
        }

        private void okButton_actionPerformed(ActionEvent e) {
            this.applyChange();
            SBSymbolEditDialog.this.dispose();
        }

        private void cancelButton_actionPerformed(ActionEvent e) {
            this.chooser.setColor(null);
            this.painterPanel.setSelected(null);
            SBSymbolEditDialog.this.dispose();
        }

        private void fntsizeChangeDetected() {
            this.repaint();
        }

        private void chooser_colorChangeDetected(Color colorin) {
            this.color = colorin;
            this.repaint();
        }

        private void painter_painterChangeDetected(String code) {
            String scheme = PaintSchemeFactory.getName(code);
            this.painter = PaintSchemeFactory.create(scheme);
            this.repaint();
        }

        private boolean applyChange() {
            boolean isChanged;
            LayerMonoSpeciesShape shape = (LayerMonoSpeciesShape)this.editingAlias.getGFramedShape();
            Rectangle2D.Double bounds = this.editingAlias.getFrameBounds();
            int iFs = this.iFsizeArr[this.jcmbbxFntsize.getSelectedIndex()];
            boolean bl = isChanged = this.w != (int)bounds.width || this.h != (int)bounds.height || iFs != shape.getLayerTextFontSize() || 1.0 != shape.getLineWidth() || !this.color.equals(shape.getColor()) || !this.painter.getClass().equals(shape.getPaintScheme().getClass());
            if (isChanged) {
                int flag = 3;
                Dimension dimsn = new Dimension(this.w, this.h);
                SpeciesShapePainting newpaint = new SpeciesShapePainting(1.0, this.color, this.painter);
                try {
                    try {
                        SBSymbolEditDialog.this.sbmodel.eventGroupBegan(null);
                        SBSymbolEditDialog.this.sbmodel.changeSpeciesShapePainting(this.editingAlias, dimsn, newpaint, iFs, flag);
                        if (this.editingAliases != null && this.editingAliases.length > 1) {
                            int i = 1;
                            while (i < this.editingAliases.length) {
                                bounds = this.editingAliases[i].getFrameBounds();
                                dimsn = new Dimension((int)bounds.width, (int)bounds.height);
                                SBSymbolEditDialog.this.sbmodel.changeSpeciesShapePainting(this.editingAliases[i], dimsn, newpaint, iFs, flag);
                                ++i;
                            }
                        }
                    }
                    catch (Exception exception) {
                        SBSymbolEditDialog.this.sbmodel.eventGroupEnded(null);
                    }
                }
                finally {
                    SBSymbolEditDialog.this.sbmodel.eventGroupEnded(null);
                }
            }
            return isChanged;
        }
    }

    private class NoOptionPanel
    extends JPanel {
        private NoOptionPanel() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.drawString("Selected tool has no option.", 0, 12);
        }
    }

    private class ReactionPanel
    extends JPanel {
        KeyAdapter keyListener;
        JPanel previewPanel = null;
        JPanel sizePanel = null;
        JPanel linePanel = null;
        PainterChooser painterPanel = null;
        MyColorChooser chooser = null;
        JPanel buttonPanel = null;
        MonoSpeciesShape monoshape = null;
        SpeciesAlias editingAlias = null;
        ReactionSymbol symbol;
        ReactionLink link;
        Color color = null;
        double lineWidth = 0.0;
        private JTextField lineWidthField;
        private JButton initButton;
        private JButton applyButton;
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");
        private JRadioButton curveLineButton;
        private JRadioButton straightLineButton;
        private JPanel lineTypePanel;
        ReactionLink[] editingLinkes = null;

        public ReactionPanel() {
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    ReactionPanel.this.updateSize();
                }
            };
            super.setLayout(null);
            int x = SBSymbolEditDialog.INSETS.left;
            int y = SBSymbolEditDialog.INSETS.top;
            this.previewPanel = new JPanel();
            this.previewPanel.setBounds(new Rectangle(x, y, SBSymbolEditDialog.PREVIEW.width, SBSymbolEditDialog.PREVIEW.height));
            this.previewPanel.setBackground(Color.white);
            this.previewPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Preview"));
            this.add((Component)this.previewPanel, null);
            this.linePanel = new JPanel();
            this.linePanel.setLayout(null);
            this.linePanel.setOpaque(false);
            this.linePanel.setBounds(x += SBSymbolEditDialog.PREVIEW.width + 6, y, SBSymbolEditDialog.LINE.width, SBSymbolEditDialog.LINE.height);
            this.linePanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Line"));
            this.add((Component)this.linePanel, null);
            JLabel labelLineWidthField = new JLabel("Width");
            labelLineWidthField.setBounds(10, 20, 40, 20);
            this.linePanel.add((Component)labelLineWidthField, null);
            this.lineWidthField = new JTextField();
            this.lineWidthField.setBounds(50, 20, 40, 20);
            this.lineWidthField.setEditable(true);
            this.lineWidthField.addKeyListener(this.keyListener);
            this.linePanel.add((Component)this.lineWidthField, null);
            this.lineTypePanel = new JPanel();
            this.lineTypePanel.setLayout(null);
            this.lineTypePanel.setOpaque(false);
            this.lineTypePanel.setBounds(x, y += this.linePanel.getHeight() + 4, SBSymbolEditDialog.LINETYPE.width, SBSymbolEditDialog.LINETYPE.height);
            this.lineTypePanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Type"));
            this.lineTypePanel.setVisible(false);
            this.add((Component)this.lineTypePanel, null);
            this.straightLineButton = new JRadioButton("Straight Line");
            this.curveLineButton = new JRadioButton("Curve Line");
            this.straightLineButton.setBounds(25, 20, 150, 20);
            this.curveLineButton.setBounds(25, 44, 150, 20);
            ButtonGroup activeGroup = new ButtonGroup();
            activeGroup.add(this.straightLineButton);
            activeGroup.add(this.curveLineButton);
            this.lineTypePanel.add((Component)this.straightLineButton, null);
            this.lineTypePanel.add((Component)this.curveLineButton, null);
            x = SBSymbolEditDialog.INSETS.left;
            y = SBSymbolEditDialog.INSETS.top + SBSymbolEditDialog.PREVIEW.height;
            this.chooser = new MyColorChooser();
            this.chooser.setBounds(x, y, SBSymbolEditDialog.CHOOSER.width, SBSymbolEditDialog.CHOOSER.height);
            this.chooser.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Color"));
            this.add((Component)this.chooser, null);
            this.chooser.addColorChangeListener(new ColorChangeListener(){

                @Override
                public void colorChanged(Color colorin) {
                    ReactionPanel.this.chooser_colorChangeDetected(colorin);
                }
            });
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBounds(x, y += SBSymbolEditDialog.CHOOSER.height, SBSymbolEditDialog.BUTTONS.width, SBSymbolEditDialog.BUTTONS.height);
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.buttonPanel, null);
            this.initButton = new JButton("Default");
            this.initButton.setMnemonic(68);
            this.initButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactionPanel.this.initButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.initButton, null);
            this.applyButton = new JButton("Apply");
            this.applyButton.setMnemonic(65);
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactionPanel.this.applyButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.applyButton, null);
            this.okButton.setMnemonic(79);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactionPanel.this.okButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.okButton, null);
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactionPanel.this.cancelButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.cancelButton, null);
            this.setPreferredSize(new Dimension(SBSymbolEditDialog.INSETS.left + SBSymbolEditDialog.INSETS.right + SBSymbolEditDialog.CHOOSER.width, SBSymbolEditDialog.INSETS.top + SBSymbolEditDialog.INSETS.bottom + SBSymbolEditDialog.PREVIEW.height + SBSymbolEditDialog.CHOOSER.height + SBSymbolEditDialog.BUTTONS.height));
        }

        private void updateSize() {
            String linew_str = this.lineWidthField.getText();
            if (linew_str.equals("")) {
                return;
            }
            double input_linew = 0.0;
            try {
                input_linew = Double.parseDouble(linew_str);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "input must be a number.", "bad number", 2);
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                return;
            }
            if (input_linew < 1.0) {
                JOptionPane.showMessageDialog(this, "line width must be >= 1.", "bad number", 2);
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                return;
            }
            if (input_linew >= 1.0) {
                this.lineWidth = input_linew;
                this.repaint();
            }
        }

        public void setReactionLink(ReactionLink link_object) {
            this.editingLinkes = null;
            this.link = link_object;
            String code = this.link.getSymbol().getCode();
            this.symbol = (ReactionSymbol)((Object)EditComponentsDialog2.getSymbolByCode(code));
            if (this.symbol instanceof GLinkedShape) {
                LinkedCreaseLine lcsln;
                boolean uitypeflag = this.link.getGLinkedShape().isInSBGNViewer();
                GLinkedShape shp = (GLinkedShape)((Object)this.symbol);
                shp.setIsInSBGNViewer(uitypeflag);
                if (shp instanceof GLinkedLineComplex3) {
                    GLinkedLineComplex3 cmplx3 = (GLinkedLineComplex3)shp;
                    cmplx3.getProcessNode().setIsInSBGNViewer(uitypeflag);
                } else if (shp instanceof GLogicGate && (lcsln = ((GLogicGate)shp).getRealLine()) != null) {
                    lcsln.setIsInSBGNViewer(uitypeflag);
                }
            }
            if (this.symbol instanceof GLogicGate) {
                int iPolicyBak = GLinkedLine.getDefaultConnectPolicy();
                GLinkedLine.setDefaultConnectPolicy(0);
                int iPntsNumBak = GLinkedLine.getDefaultCreasePointNumber();
                GLinkedLine.setDefaultCreasePointNumber(0);
                int iType = ((GLogicGate)this.link.getSymbol()).getModificationType();
                ((GLogicGate)this.symbol).setModificationType(iType);
                GLinkedLine.setDefaultConnectPolicy(iPolicyBak);
                GLinkedLine.setDefaultCreasePointNumber(iPntsNumBak);
            }
            Color color = new Color(0, 0, 0);
            color = this.link.getGLinkedShape().getColor();
            this.lineWidth = this.link.getGLinkedShape().getLineWidth();
            GLinkedShape shape = this.link.getGLinkedShape();
            this.lineTypePanel.setVisible(shape instanceof GLinkedCurveAndLine);
            int lineType = shape.getLineType();
            this.initialize(this.lineWidth, color, code, lineType);
        }

        public void setReactionLink(ReactionLink[] link_object) {
            this.setReactionLink(link_object[0]);
            this.editingLinkes = link_object;
        }

        protected void initialize(double linewidth, Color colorin, String code, int lineType) {
            GLinkedCurveAndLine gcl;
            this.color = colorin;
            this.chooser.setColor(this.color);
            this.lineWidth = linewidth;
            this.lineWidthField.setText(Double.toString(this.lineWidth));
            if (code.equals("UNKNOWN")) {
                this.lineWidthField.setEnabled(false);
            } else {
                this.lineWidthField.setEnabled(true);
            }
            this.straightLineButton.setSelected(lineType == 1);
            this.curveLineButton.setSelected(lineType == 0);
            this.straightLineButton.setEnabled(true);
            this.curveLineButton.setEnabled(true);
            if (this.link.getGLinkedShape() instanceof GLinkedCurveAndLine && (gcl = (GLinkedCurveAndLine)this.link.getGLinkedShape()).getConnectPolicy() == 1) {
                this.straightLineButton.setEnabled(false);
                this.curveLineButton.setEnabled(false);
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.symbol != null) {
                Graphics2D g2 = (Graphics2D)g;
                if (Preference.antialias) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                } else {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                }
                Dimension d = this.previewPanel.getSize();
                Rectangle bounds = this.previewPanel.getBounds();
                Insets i = new Insets(8, 3, 3, 4);
                bounds.x += i.left;
                bounds.y += i.top;
                bounds.width = d.width - i.left - i.right;
                bounds.height = d.height - i.top - i.bottom;
                this.symbol.drawPreview(g2, bounds, this.color, this.lineWidth);
            }
        }

        protected void initButton_actionPerformed(ActionEvent e) {
            String code = ((SBSymbol)((Object)this.symbol)).getCode();
            this.color = ReactionColorScheme.getColor(code);
            this.lineWidth = ReactionColorScheme.getLineWidth(code);
            this.chooser.setColor(this.color);
            this.lineWidthField.setText(Double.toString(this.lineWidth));
            this.straightLineButton.setSelected(ReactionColorScheme.getLineType(code) == 1);
            this.curveLineButton.setSelected(ReactionColorScheme.getLineType(code) == 0);
            this.repaint();
        }

        protected void applyButton_actionPerformed(ActionEvent e) {
            this.applyChange();
        }

        protected void okButton_actionPerformed(ActionEvent e) {
            this.applyChange();
            SBSymbolEditDialog.this.dispose();
        }

        protected void cancelButton_actionPerformed(ActionEvent e) {
            this.chooser.setColor(null);
            this.lineWidthField.setText("");
            SBSymbolEditDialog.this.dispose();
        }

        private void chooser_colorChangeDetected(Color colorin) {
            this.color = colorin;
            this.repaint();
        }

        private int getCurrentLineType() {
            if (!(this.link.getGLinkedShape() instanceof GLinkedCurveAndLine)) {
                return 1;
            }
            if (this.straightLineButton.isSelected()) {
                return 1;
            }
            if (this.curveLineButton.isSelected()) {
                return 0;
            }
            return 1;
        }

        private boolean applyChange() {
            boolean isChanged = this.lineWidth != this.link.getGLinkedShape().getLineWidth() || !this.color.equals(this.link.getGLinkedShape().getColor()) || this.getCurrentLineType() != this.link.getGLinkedShape().getLineType();
            Reaction reaction = this.link.getParentReaction();
            if (isChanged) {
                boolean isChangedLW = false;
                boolean isChangedC = false;
                if (this.lineWidth != this.link.getGLinkedShape().getLineWidth()) {
                    isChangedLW = true;
                }
                if (!this.color.equals(this.link.getGLinkedShape().getColor())) {
                    isChangedC = true;
                }
                if (this.editingLinkes == null || this.editingLinkes.length == 0) {
                    SBSymbolEditDialog.this.sbmodel.changeLinkPainting(this.link, this.lineWidth, this.color, this.getCurrentLineType(), null);
                    return isChanged;
                }
                boolean doFlg = false;
                Vector oldObjectes = new Vector();
                Vector newObjectes = new Vector();
                Vector linkes = new Vector();
                SBSymbolEditDialog.this.sbmodel.changeLinkPainting(this.link, this.lineWidth, this.color, this.getCurrentLineType(), null, doFlg, oldObjectes, newObjectes, linkes);
                int i = 1;
                while (i < this.editingLinkes.length) {
                    if (!isChangedLW) {
                        this.lineWidth = this.editingLinkes[i].getGLinkedShape().getLineWidth();
                    }
                    if (!isChangedC) {
                        this.color = this.editingLinkes[i].getGLinkedShape().getColor();
                    }
                    if (i == this.editingLinkes.length - 1) {
                        doFlg = true;
                    }
                    SBSymbolEditDialog.this.sbmodel.changeLinkPainting(this.editingLinkes[i], this.lineWidth, this.color, this.getCurrentLineType(), null, doFlg, oldObjectes, newObjectes, linkes);
                    ++i;
                }
            }
            return isChanged;
        }
    }

    private class SpeciesChangeNameFontSizePanel
    extends JPanel {
        JPanel previewPanel = null;
        JPanel buttonPanel = null;
        MonoSpeciesShape monoshape = null;
        SpeciesAlias editingAlias = null;
        SpeciesAlias[] editingAliases = null;
        int w = 0;
        int h = 0;
        PaintScheme painter = null;
        double lineWidth = 0.0;
        int iFntSz = Preference.speciesNameFont;
        private String[] strFsizeArr = new String[PopupSpeciesNameFontDialog.iFsizeArr.length];
        JComboBox jcmbbxFntsize;
        private JButton initButton;
        private JButton applyButton;
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");

        public SpeciesChangeNameFontSizePanel() {
            int i = 0;
            while (i < PopupSpeciesNameFontDialog.iFsizeArr.length) {
                this.strFsizeArr[i] = "" + PopupSpeciesNameFontDialog.iFsizeArr[i];
                ++i;
            }
            this.jcmbbxFntsize = new JComboBox<String>(this.strFsizeArr);
            super.setLayout(null);
            int x = SBSymbolEditDialog.INSETS.left;
            int y = SBSymbolEditDialog.INSETS.top;
            this.previewPanel = new JPanel();
            this.previewPanel.setBounds(new Rectangle(x, y, SBSymbolEditDialog.PREVIEW.width, SBSymbolEditDialog.PREVIEW.height));
            this.previewPanel.setBackground(Color.white);
            this.previewPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Preview"));
            this.add((Component)this.previewPanel, null);
            JLabel fntsizeLabel = new JLabel("Font Size");
            fntsizeLabel.setBounds(283, 10, 60, 20);
            this.add(fntsizeLabel);
            this.jcmbbxFntsize.setMaximumRowCount(10);
            this.jcmbbxFntsize.setBounds(348, 10, 100, 20);
            this.jcmbbxFntsize.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SpeciesChangeNameFontSizePanel.this.iFntSz = PopupSpeciesNameFontDialog.iFsizeArr[((JComboBox)e.getSource()).getSelectedIndex()];
                    SpeciesChangeNameFontSizePanel.this.fntsizeChangeDetected();
                    ((JComboBox)e.getSource()).transferFocus();
                }
            });
            this.add((Component)this.jcmbbxFntsize, null);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBounds(x, y += this.previewPanel.getHeight(), SBSymbolEditDialog.BUTTONS.width, SBSymbolEditDialog.BUTTONS.height);
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.buttonPanel, null);
            this.initButton = new JButton("Default");
            this.initButton.setMnemonic(68);
            this.initButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpeciesChangeNameFontSizePanel.this.initButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.initButton, null);
            this.applyButton = new JButton("Apply");
            this.applyButton.setMnemonic(65);
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpeciesChangeNameFontSizePanel.this.applyButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.applyButton, null);
            this.okButton.setMnemonic(79);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpeciesChangeNameFontSizePanel.this.okButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.okButton, null);
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SBSymbolEditDialog.this.dispose();
                }
            });
            this.buttonPanel.add((Component)this.cancelButton, null);
            this.setPreferredSize(new Dimension(SBSymbolEditDialog.INSETS.left + SBSymbolEditDialog.INSETS.right + SBSymbolEditDialog.CHOOSER.width, SBSymbolEditDialog.INSETS.top + SBSymbolEditDialog.INSETS.bottom + SBSymbolEditDialog.PREVIEW.height + SBSymbolEditDialog.BUTTONS.height));
        }

        private void fntsizeChangeDetected() {
            this.repaint();
        }

        public void setSpeciesAlias(SpeciesAlias alias) {
            this.editingAliases = null;
            this.editingAlias = alias;
            if (!(alias.getGFramedShape() instanceof MonoSpeciesShape)) {
                return;
            }
            MonoSpeciesShape shape = (MonoSpeciesShape)alias.getGFramedShape();
            this.iFntSz = shape.getNameFontSize();
            try {
                this.painter = (PaintScheme)shape.getPaintScheme().getClass().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Color color = shape.getColor();
            BasicStroke stroke = new BasicStroke((float)shape.getLineWidth(), 0, 1);
            this.painter.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
            this.painter.setStroke(stroke);
            String code = ((SBSymbol)((Object)shape.getSpeciesSymbol())).getCode();
            Point2D.Double size = alias.getFrameSize();
            this.monoshape = (MonoSpeciesShape)shape.duplicate();
            this.monoshape.setActive(shape.isActive());
            this.initialize((int)size.x, (int)size.y, this.monoshape.getLineWidth(), code);
        }

        public void setSpeciesAlias(SpeciesAlias[] aliases) {
            this.setSpeciesAlias(aliases[0]);
            this.editingAliases = aliases;
        }

        protected void initialize(int width, int height, double linewidth, String code) {
            this.w = width;
            this.h = height;
            this.jcmbbxFntsize.setSelectedItem("" + this.iFntSz);
            this.jcmbbxFntsize.transferFocus();
            this.lineWidth = linewidth;
            if (code.equals("UNKNOWN")) {
                this.lineWidth = 0.0;
            } else if (this.lineWidth < 1.0) {
                this.lineWidth = 1.0;
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            if (Preference.antialias) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            Dimension d = this.previewPanel.getSize();
            Rectangle bounds = this.previewPanel.getBounds();
            Insets i = new Insets(10, 5, 5, 5);
            Rectangle clipBounds = new Rectangle(bounds.x + i.left, bounds.y + i.top, bounds.width - i.left - i.right, bounds.height - i.top - i.bottom);
            double x = (double)(bounds.x + i.left) + (double)(d.width - i.left - i.right - this.w) / 2.0;
            double y = (double)(bounds.y + i.top) + (double)(d.height - i.top - i.bottom - this.h) / 2.0;
            if (x + (double)this.w + this.monoshape.getLineWidth() / 2.0 > (double)(clipBounds.x + clipBounds.width)) {
                x = (double)(clipBounds.x + clipBounds.width - this.w) - this.monoshape.getLineWidth() / 2.0;
            }
            if (y + (double)this.h + this.monoshape.getLineWidth() / 2.0 > (double)(clipBounds.y + clipBounds.height)) {
                y = (double)(clipBounds.y + clipBounds.height - this.h) - this.monoshape.getLineWidth() / 2.0;
            }
            this.monoshape.setNameFontSize(this.iFntSz);
            this.monoshape.updateShape(x, y, this.w, this.h);
            this.monoshape.setLineWidth(this.monoshape.getLineWidth());
            this.monoshape.setPaintScheme(this.painter);
            g2.setClip(clipBounds);
            this.monoshape.drawShape(g2, 1);
        }

        protected void initButton_actionPerformed(ActionEvent e) {
            this.iFntSz = 12;
            int i = 0;
            while (i < PopupSpeciesNameFontDialog.iFsizeArr.length) {
                if (this.iFntSz == PopupSpeciesNameFontDialog.iFsizeArr[i]) {
                    this.jcmbbxFntsize.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }

        protected void applyButton_actionPerformed(ActionEvent e) {
            this.applyChange();
        }

        protected void okButton_actionPerformed(ActionEvent e) {
            this.applyChange();
            SBSymbolEditDialog.this.dispose();
        }

        private String getMessage(SpeciesAlias alias) {
            Species species = alias.getOriginalSpecies();
            String msg = "Change all the same " + species.getId() + " in this model?";
            if (alias instanceof ComplexSpeciesAlias) {
                msg = "Change all(" + species.getId() + ") which is in same ComplexView in this model?";
            }
            return msg;
        }

        private boolean applyChange() {
            boolean isChanged;
            block15: {
                MonoSpeciesShape shape = (MonoSpeciesShape)this.editingAlias.getGFramedShape();
                boolean bl = isChanged = shape.getNameFontSize() != this.iFntSz;
                if (!isChanged) break block15;
                boolean isChangedW = true;
                boolean isChangedH = true;
                boolean isChangedLW = true;
                boolean isChangedC = true;
                boolean isChangedP = true;
                HashMap<String, Map<Object, Object>> mapSpecies = new HashMap<String, Map<Object, Object>>();
                Species species = this.editingAlias.getOriginalSpecies();
                SpeciesAnnotation sExt = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null);
                int flag = 3;
                boolean multiRefsFlag = false;
                if (sExt.getReferingAliases().size() > 1) {
                    multiRefsFlag = true;
                }
                if (multiRefsFlag) {
                    String title = "The same species exist.";
                    String msg = this.getMessage(this.editingAlias);
                    int ans = JOptionPane.showConfirmDialog(this, msg, title, 0, 3, null);
                    if (ans == 0) {
                        flag = 1;
                    }
                    if (ans == 1) {
                        flag = 2;
                    }
                }
                int fs = this.iFntSz;
                Point2D.Double size = this.editingAlias.getFrameSize();
                if (this.editingAliases == null || this.editingAliases.length == 0) {
                    SBSymbolEditDialog.this.sbmodel.changeSpeciesShapePainting(this.editingAlias, new Dimension((int)size.x, (int)size.y), new SpeciesShapePainting(this.monoshape.getLineWidth(), this.monoshape.getColor(), this.painter), fs, flag, isChangedW, isChangedH, isChangedLW, isChangedC, isChangedP);
                    return isChanged;
                }
                Vector aliases = new Vector();
                Vector olddimensions = new Vector();
                Vector oldpaintings = new Vector();
                Vector oldpNameFontSize = new Vector();
                Vector newdimensions = new Vector();
                Vector newpaintings = new Vector();
                Vector newpNameFontSize = new Vector();
                SBSymbolEditDialog.this.sbmodel.changeSpeciesShapePainting(this.editingAlias, new Dimension((int)size.x, (int)size.y), new SpeciesShapePainting(this.monoshape.getLineWidth(), this.monoshape.getColor(), this.painter), fs, flag, aliases, olddimensions, oldpaintings, oldpNameFontSize, newdimensions, newpaintings, newpNameFontSize, isChangedW, isChangedH, isChangedLW, isChangedC, isChangedP);
                Map<String, String> mapValue = new HashMap<String, String>();
                mapValue.put(SBSymbolEditDialog.OPTION, String.valueOf(flag));
                if (this.editingAlias instanceof ComplexSpeciesAlias) {
                    mapValue.put(this.editingAlias.getCurrentViewString(), "");
                }
                mapSpecies.put(species.getId(), mapValue);
                int i = 1;
                while (i < this.editingAliases.length) {
                    block19: {
                        block17: {
                            block18: {
                                block16: {
                                    species = this.editingAliases[i].getOriginalSpecies();
                                    sExt = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null);
                                    flag = 3;
                                    multiRefsFlag = false;
                                    if (mapSpecies.containsKey(species.getId())) break block16;
                                    if (sExt.getReferingAliases().size() > 1) {
                                        multiRefsFlag = true;
                                    }
                                    break block17;
                                }
                                Map value = (Map)mapSpecies.get(species.getId());
                                if (!value.get(SBSymbolEditDialog.OPTION).equals(String.valueOf(1))) break block18;
                                if (!(this.editingAliases[i] instanceof ComplexSpeciesAlias) || value.containsKey(this.editingAliases[i].getCurrentViewString())) break block19;
                                flag = 1;
                                break block17;
                            }
                            flag = 2;
                        }
                        if (multiRefsFlag) {
                            String title = "The same species exist.";
                            String msg = this.getMessage(this.editingAliases[i]);
                            int ans = JOptionPane.showConfirmDialog(this, msg, title, 0, 3, null);
                            if (ans == 0) {
                                flag = 1;
                            }
                            if (ans == 1) {
                                flag = 2;
                            }
                        }
                        shape = (MonoSpeciesShape)this.editingAliases[i].getGFramedShape();
                        Point2D.Double sizeI = this.editingAliases[i].getFrameSize();
                        SBSymbolEditDialog.this.sbmodel.changeSpeciesShapePainting(this.editingAliases[i], new Dimension((int)sizeI.x, (int)sizeI.y), new SpeciesShapePainting(shape.getLineWidth(), shape.getColor(), this.painter), fs, flag, aliases, olddimensions, oldpaintings, oldpNameFontSize, newdimensions, newpaintings, newpNameFontSize, isChangedW, isChangedH, isChangedLW, isChangedC, isChangedP);
                        if (!mapSpecies.containsKey(species.getId())) {
                            mapValue = new HashMap();
                            mapValue.put(SBSymbolEditDialog.OPTION, String.valueOf(flag));
                            if (this.editingAliases[i] instanceof ComplexSpeciesAlias) {
                                mapValue.put(this.editingAliases[i].getCurrentViewString(), "");
                            }
                            mapSpecies.put(species.getId(), mapValue);
                        } else if (this.editingAliases[i] instanceof ComplexSpeciesAlias && !(mapValue = (Map)mapSpecies.get(species.getId())).containsKey(this.editingAliases[i].getCurrentViewString())) {
                            mapValue.put(this.editingAliases[i].getCurrentViewString(), "");
                        }
                    }
                    ++i;
                }
                SBSymbolEditDialog.this.sbmodel.doChange(aliases, olddimensions, oldpaintings, oldpNameFontSize, newdimensions, newpaintings, newpNameFontSize);
            }
            return isChanged;
        }
    }

    private class SpeciesPanel
    extends JPanel {
        KeyAdapter keyListener;
        JPanel previewPanel = null;
        JPanel sizePanel = null;
        JPanel linePanel = null;
        PainterChooser painterPanel = null;
        MyColorChooser chooser = null;
        JPanel buttonPanel = null;
        MonoSpeciesShape monoshape = null;
        SpeciesAlias editingAlias = null;
        SpeciesAlias[] editingAliases = null;
        int w = 0;
        int h = 0;
        Color color = null;
        PaintScheme painter = null;
        double lineWidth = 0.0;
        private JTextField defaultWidthField;
        private JTextField defaultHeightField;
        private JTextField lineWidthField;
        private JButton initButton;
        private JButton applyButton;
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");

        public SpeciesPanel() {
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    SpeciesPanel.this.updateSize();
                }
            };
            super.setLayout(null);
            int x = SBSymbolEditDialog.INSETS.left;
            int y = SBSymbolEditDialog.INSETS.top;
            this.previewPanel = new JPanel();
            this.previewPanel.setBounds(new Rectangle(x, y, SBSymbolEditDialog.PREVIEW.width, SBSymbolEditDialog.PREVIEW.height));
            this.previewPanel.setBackground(Color.white);
            this.previewPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Preview"));
            this.add((Component)this.previewPanel, null);
            this.sizePanel = new JPanel();
            this.sizePanel.setLayout(null);
            this.sizePanel.setOpaque(false);
            this.sizePanel.setBounds(new Rectangle(x += SBSymbolEditDialog.PREVIEW.width + 6, y, SBSymbolEditDialog.SIZE.width, SBSymbolEditDialog.SIZE.height));
            this.sizePanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Size"));
            this.add((Component)this.sizePanel, null);
            JLabel labelWidthField = new JLabel("Width");
            labelWidthField.setBounds(10, 20, 40, 20);
            this.sizePanel.add((Component)labelWidthField, null);
            this.defaultWidthField = new JTextField();
            this.defaultWidthField.setBounds(50, 20, 40, 20);
            this.defaultWidthField.setEditable(true);
            this.defaultWidthField.addKeyListener(this.keyListener);
            this.sizePanel.add((Component)this.defaultWidthField, null);
            JLabel labelHeightField = new JLabel("Height");
            labelHeightField.setBounds(110, 20, 50, 20);
            this.sizePanel.add((Component)labelHeightField, null);
            this.defaultHeightField = new JTextField();
            this.defaultHeightField.setBounds(160, 20, 40, 20);
            this.defaultHeightField.setEditable(true);
            this.defaultHeightField.addKeyListener(this.keyListener);
            this.sizePanel.add((Component)this.defaultHeightField, null);
            this.linePanel = new JPanel();
            this.linePanel.setLayout(null);
            this.linePanel.setOpaque(false);
            this.linePanel.setBounds(x, y += SBSymbolEditDialog.SIZE.height, SBSymbolEditDialog.LINE.width, SBSymbolEditDialog.LINE.height);
            this.linePanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Line"));
            this.add((Component)this.linePanel, null);
            JLabel labelLineWidthField = new JLabel("Width");
            labelLineWidthField.setBounds(10, 20, 40, 20);
            this.linePanel.add((Component)labelLineWidthField, null);
            this.lineWidthField = new JTextField();
            this.lineWidthField.setBounds(50, 20, 40, 20);
            this.lineWidthField.setEditable(true);
            this.lineWidthField.addKeyListener(this.keyListener);
            this.linePanel.add((Component)this.lineWidthField, null);
            this.painterPanel = new PainterChooser();
            this.painterPanel.setOpaque(false);
            this.painterPanel.setBounds(x, y += SBSymbolEditDialog.LINE.height, SBSymbolEditDialog.PAINTER.width, SBSymbolEditDialog.PAINTER.height);
            this.painterPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Paint"));
            this.add((Component)this.painterPanel, null);
            this.painterPanel.addPainterChangeListener(new PainterChangeListener(){

                @Override
                public void painterChanged(String command) {
                    SpeciesPanel.this.painter_painterChangeDetected(command);
                }
            });
            x = SBSymbolEditDialog.INSETS.left;
            y = SBSymbolEditDialog.INSETS.top + SBSymbolEditDialog.PREVIEW.height;
            this.chooser = new MyColorChooser();
            this.chooser.setBounds(x, y, SBSymbolEditDialog.CHOOSER.width, SBSymbolEditDialog.CHOOSER.height);
            this.chooser.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Color"));
            this.add((Component)this.chooser, null);
            this.chooser.addColorChangeListener(new ColorChangeListener(){

                @Override
                public void colorChanged(Color colorin) {
                    SpeciesPanel.this.chooser_colorChangeDetected(colorin);
                }
            });
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBounds(x, y += SBSymbolEditDialog.CHOOSER.height, SBSymbolEditDialog.BUTTONS.width, SBSymbolEditDialog.BUTTONS.height);
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.buttonPanel, null);
            this.initButton = new JButton("Default");
            this.initButton.setMnemonic(68);
            this.initButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpeciesPanel.this.initButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.initButton, null);
            this.applyButton = new JButton("Apply");
            this.applyButton.setMnemonic(65);
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpeciesPanel.this.applyButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.applyButton, null);
            this.okButton.setMnemonic(79);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpeciesPanel.this.okButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.okButton, null);
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpeciesPanel.this.cancelButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.cancelButton, null);
            this.setPreferredSize(new Dimension(SBSymbolEditDialog.INSETS.left + SBSymbolEditDialog.INSETS.right + SBSymbolEditDialog.CHOOSER.width, SBSymbolEditDialog.INSETS.top + SBSymbolEditDialog.INSETS.bottom + SBSymbolEditDialog.PREVIEW.height + SBSymbolEditDialog.CHOOSER.height + SBSymbolEditDialog.BUTTONS.height));
        }

        private void updateSize() {
            String w_str = this.defaultWidthField.getText();
            String h_str = this.defaultHeightField.getText();
            String linew_str = this.lineWidthField.getText();
            if (w_str.equals("") || h_str.equals("") || linew_str.equals("")) {
                return;
            }
            int input_w = 0;
            int input_h = 0;
            double input_linew = 0.0;
            try {
                input_w = Integer.parseInt(w_str);
                input_h = Integer.parseInt(h_str);
                input_linew = Double.parseDouble(linew_str);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "input must be a number.", "bad number", 2);
                this.defaultWidthField.setText("" + this.w);
                this.defaultHeightField.setText("" + this.h);
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                return;
            }
            if (input_w <= 0 || input_h <= 0) {
                JOptionPane.showMessageDialog(this, "widht and height must be > 0.", "bad number", 2);
                this.defaultWidthField.setText("" + this.w);
                this.defaultHeightField.setText("" + this.h);
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                return;
            }
            if (this.lineWidthField.isEnabled() && input_linew < 1.0) {
                JOptionPane.showMessageDialog(this, "line width must be >= 1.", "bad number", 2);
                this.defaultWidthField.setText("" + this.w);
                this.defaultHeightField.setText("" + this.h);
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                return;
            }
            this.w = input_w;
            this.h = input_h;
            this.lineWidth = input_linew;
            this.repaint();
        }

        public void setSpeciesAlias(SpeciesAlias alias) {
            this.editingAliases = null;
            this.editingAlias = alias;
            if (!(alias.getGFramedShape() instanceof MonoSpeciesShape)) {
                return;
            }
            MonoSpeciesShape shape = (MonoSpeciesShape)alias.getGFramedShape();
            try {
                this.painter = (PaintScheme)shape.getPaintScheme().getClass().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Color color = shape.getColor();
            BasicStroke stroke = new BasicStroke((float)shape.getLineWidth(), 0, 1);
            this.painter.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
            this.painter.setStroke(stroke);
            String code = ((SBSymbol)((Object)shape.getSpeciesSymbol())).getCode();
            Point2D.Double size = alias.getFrameSize();
            this.monoshape = (MonoSpeciesShape)shape.duplicate();
            this.monoshape.setActive(shape.isActive());
            this.initialize((int)size.x, (int)size.y, this.monoshape.getLineWidth(), this.monoshape.getColor(), this.monoshape.getPaintScheme(), code);
        }

        public void setSpeciesAlias(SpeciesAlias[] aliases) {
            this.setSpeciesAlias(aliases[0]);
            this.editingAliases = aliases;
        }

        protected void initialize(int width, int height, double linewidth, Color colorin, PaintScheme painterin, String code) {
            this.w = width;
            this.h = height;
            this.defaultWidthField.setText("" + this.w);
            this.defaultHeightField.setText("" + this.h);
            this.color = colorin;
            this.chooser.setColor(this.color);
            this.painter = painterin;
            this.painterPanel.setSelected(this.painter.getCode());
            this.lineWidth = linewidth;
            if (code.equals("UNKNOWN")) {
                this.lineWidthField.setEnabled(false);
                this.lineWidth = 0.0;
                this.lineWidthField.setText(Double.toString(this.lineWidth));
            } else {
                if (this.lineWidth < 1.0) {
                    this.lineWidth = 1.0;
                }
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                this.lineWidthField.setEnabled(true);
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            if (Preference.antialias) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            Dimension d = this.previewPanel.getSize();
            Rectangle bounds = this.previewPanel.getBounds();
            Insets i = new Insets(10, 5, 5, 5);
            Rectangle clipBounds = new Rectangle(bounds.x + i.left, bounds.y + i.top, bounds.width - i.left - i.right, bounds.height - i.top - i.bottom);
            double x = (double)(bounds.x + i.left) + (double)(d.width - i.left - i.right - this.w) / 2.0;
            double y = (double)(bounds.y + i.top) + (double)(d.height - i.top - i.bottom - this.h) / 2.0;
            if (x + (double)this.w + this.lineWidth / 2.0 > (double)(clipBounds.x + clipBounds.width)) {
                x = (double)(clipBounds.x + clipBounds.width - this.w) - this.lineWidth / 2.0;
            }
            if (y + (double)this.h + this.lineWidth / 2.0 > (double)(clipBounds.y + clipBounds.height)) {
                y = (double)(clipBounds.y + clipBounds.height - this.h) - this.lineWidth / 2.0;
            }
            this.monoshape.updateShape(x, y, this.w, this.h);
            this.monoshape.setColor(this.color);
            this.monoshape.setLineWidth(this.lineWidth);
            this.monoshape.setPaintScheme(this.painter);
            g2.setClip(clipBounds);
            this.monoshape.drawShape(g2, 1);
        }

        protected void initButton_actionPerformed(ActionEvent e) {
            SpeciesSymbol symbol = this.monoshape.getSpeciesSymbol();
            Dimension d = symbol.defaultSize();
            String code = ((SBSymbol)((Object)symbol)).getCode();
            if (SBSymbolEditDialog.this.isDoShape()) {
                this.w = d.width;
                this.h = d.height;
            }
            if (SBSymbolEditDialog.this.isDoColor()) {
                this.color = SpeciesColorScheme.getColor(code);
                this.painter = SpeciesColorScheme.getScheme(code);
            }
            this.lineWidth = SpeciesColorScheme.getLineWidth(code);
            this.defaultWidthField.setText("" + this.w);
            this.defaultHeightField.setText("" + this.h);
            this.chooser.setColor(this.color);
            this.painterPanel.setSelected(this.painter.getCode());
            this.lineWidthField.setText(Double.toString(this.lineWidth));
            this.repaint();
        }

        protected void applyButton_actionPerformed(ActionEvent e) {
            this.applyChange();
        }

        protected void okButton_actionPerformed(ActionEvent e) {
            this.applyChange();
            SBSymbolEditDialog.this.dispose();
        }

        protected void cancelButton_actionPerformed(ActionEvent e) {
            this.defaultWidthField.setText("");
            this.defaultHeightField.setText("");
            this.chooser.setColor(null);
            this.painterPanel.setSelected(null);
            this.lineWidthField.setText("");
            SBSymbolEditDialog.this.dispose();
        }

        private void chooser_colorChangeDetected(Color colorin) {
            this.color = colorin;
            this.repaint();
        }

        private void painter_painterChangeDetected(String code) {
            String scheme = PaintSchemeFactory.getName(code);
            this.painter = PaintSchemeFactory.create(scheme);
            this.repaint();
        }

        private boolean isToChangeRelationship(SpeciesAlias alias, SpeciesAlias[] aliases, boolean isChangedWH, boolean isDisplay) {
            String title;
            String msg;
            if (!isChangedWH) {
                return true;
            }
            try {
                if (SBSymbolEditDialog.this.sbmodel.getSbframe().getUIType() == 2) {
                    return true;
                }
            }
            catch (Exception ex) {
                return false;
            }
            SpeciesAlias csa = null;
            SpeciesAlias esa = null;
            try {
                Vector sameViewAsSelectedComplex = new Vector();
                sameViewAsSelectedComplex = this.getAllSameViewAsSelectedComplex(alias, aliases);
                csa = this.getComplexContainRelationWillChangeAlias(sameViewAsSelectedComplex, this.w, this.h);
                Vector sameAliasesAsSelectedSpecies = new Vector();
                sameAliasesAsSelectedSpecies = this.getAllAliasesAsSelectedElementSpecies(alias, aliases);
                esa = this.getContainRelationWillChangeElementSpecies(sameAliasesAsSelectedSpecies, this.w, this.h);
            }
            catch (Exception ex) {
                return false;
            }
            return csa == null && esa == null || !isDisplay || JOptionPane.showConfirmDialog(this, msg = "The new size seems to cannot keep included relationship any more.\nAre you sure to change the size?", title = "Included relationship warning", 0, 2, null) != 1;
        }

        private Vector getAllSameViewAsSelectedComplex(SpeciesAlias alias, SpeciesAlias[] aliases) {
            Vector<Vector> vctComplex;
            block6: {
                block2: {
                    HashMap<String, Map<String, String>> mapId = new HashMap<String, Map<String, String>>();
                    Map<String, String> mapView = new HashMap();
                    vctComplex = new Vector<Vector>();
                    if (aliases == null || aliases.length <= 1) break block2;
                    int i = 0;
                    while (i < aliases.length) {
                        block3: {
                            SpeciesAlias csa;
                            block5: {
                                String id;
                                block4: {
                                    csa = aliases[i];
                                    if (!(csa instanceof ComplexSpeciesAlias)) break block3;
                                    id = csa.getOriginalSpecies().getId();
                                    if (!mapId.containsKey(id)) break block4;
                                    mapView = (Map)mapId.get(id);
                                    if (mapView.containsKey(csa.getCurrentViewString())) break block3;
                                    mapView.put(csa.getCurrentViewString(), "");
                                    break block5;
                                }
                                mapView = new HashMap();
                                mapView.put(csa.getCurrentViewString(), "");
                                mapId.put(id, mapView);
                            }
                            vctComplex.add(SBSymbolEditDialog.this.sbmodel.getGStructure().getSameIDAndViewComplexAlias((ComplexSpeciesAlias)csa));
                        }
                        ++i;
                    }
                    break block6;
                }
                if (alias instanceof ComplexSpeciesAlias) {
                    vctComplex.add(SBSymbolEditDialog.this.sbmodel.getGStructure().getSameIDAndViewComplexAlias((ComplexSpeciesAlias)alias));
                }
            }
            return vctComplex;
        }

        private SpeciesAlias getComplexContainRelationWillChangeAlias(Vector vctComplex, int w, int h) throws Exception {
            int i = 0;
            while (i < vctComplex.size()) {
                Vector complexSpeciesAliases = (Vector)vctComplex.get(i);
                int j = 0;
                while (j < complexSpeciesAliases.size()) {
                    ComplexSpeciesAlias parent;
                    ComplexSpeciesAlias csa = (ComplexSpeciesAlias)complexSpeciesAliases.get(j);
                    MonoSpeciesShape monoShape = (MonoSpeciesShape)csa.getGFramedShape();
                    Rectangle2D.Double bounds = monoShape.getSpeciesSymbol().getSymbolBounds();
                    Rectangle2D.Double newBounds = new Rectangle2D.Double(bounds.x, bounds.y, w, h);
                    if (((double)w > bounds.width || (double)h > bounds.height) && (parent = this.getContainRelationWillChangeParentAlias(csa, newBounds)) != null) {
                        return csa;
                    }
                    if (!(csa.getCurrentView() != 0 && csa.getCurrentView() != 2 || (double)w > bounds.width && (double)h > bounds.height)) {
                        Vector targets = csa.getTargets();
                        int k = 0;
                        while (k < targets.size()) {
                            GElement gelement = (GElement)targets.get(k);
                            monoShape = (MonoSpeciesShape)((SpeciesAlias)gelement).getGFramedShape();
                            Point2D.Double[] points = monoShape.getEdgePoints();
                            int m = 0;
                            while (m < points.length) {
                                if (!newBounds.contains(points[m])) {
                                    return csa;
                                }
                                ++m;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            return null;
        }

        private Vector getAllAliasesAsSelectedElementSpecies(SpeciesAlias alias, SpeciesAlias[] aliases) throws Exception {
            HashMap<String, String> mapId = new HashMap<String, String>();
            Vector<Vector> vctAliases = new Vector<Vector>();
            try {
                if (aliases != null && aliases.length > 1) {
                    int i = 0;
                    while (i < aliases.length) {
                        String id;
                        SpeciesAlias sa = aliases[i];
                        if (sa instanceof ElementSpeciesAlias && !mapId.containsKey(id = sa.getOriginalSpecies().getId())) {
                            mapId.put(id, "");
                            vctAliases.add(SBSymbolEditDialog.this.sbmodel.getGStructure().getSameIDElementSpeciesAliases((ElementSpeciesAlias)sa));
                        }
                        ++i;
                    }
                } else if (alias instanceof ElementSpeciesAlias) {
                    vctAliases.add(SBSymbolEditDialog.this.sbmodel.getGStructure().getSameIDElementSpeciesAliases((ElementSpeciesAlias)alias));
                }
            }
            catch (Exception ex) {
                vctAliases = new Vector();
                throw ex;
            }
            return vctAliases;
        }

        private SpeciesAlias getContainRelationWillChangeElementSpecies(Vector vctSpeciesAliases, int w, int h) throws Exception {
            int i = 0;
            while (i < vctSpeciesAliases.size()) {
                Vector elementSpeciesAliases = (Vector)vctSpeciesAliases.get(i);
                int j = 0;
                while (j < elementSpeciesAliases.size()) {
                    ElementSpeciesAlias sa = (ElementSpeciesAlias)elementSpeciesAliases.get(j);
                    if (sa.getCurrentView() == 0) {
                        ComplexSpeciesAlias parent;
                        MonoSpeciesShape monoShape = (MonoSpeciesShape)sa.getGFramedShape();
                        Rectangle2D.Double bounds = monoShape.getSpeciesSymbol().getSymbolBounds();
                        Rectangle2D.Double newBounds = new Rectangle2D.Double(bounds.x, bounds.y, w, h);
                        if (((double)w > bounds.width || (double)h > bounds.height) && (parent = this.getContainRelationWillChangeParentAlias(sa, newBounds)) != null) {
                            return sa;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            return null;
        }

        private ComplexSpeciesAlias getContainRelationWillChangeParentAlias(SpeciesAlias sa, Rectangle2D.Double newBounds) throws Exception {
            ComplexSpeciesAlias parent;
            MonoSpeciesShape parentShape;
            Polygon inner;
            if (sa.getContainer() instanceof ComplexSpeciesAlias && (inner = ((Complex)(parentShape = (MonoSpeciesShape)(parent = (ComplexSpeciesAlias)sa.getContainer()).getGFramedShape()).getSpeciesSymbol()).getInner()) != null && !inner.contains(newBounds)) {
                return parent;
            }
            return null;
        }

        private boolean isComplexHaveMutiRefsOfSelectedView(ComplexSpeciesAlias alias, SpeciesAlias[] aliases) {
            Vector vctComplex = new Vector();
            if (aliases == null) {
                vctComplex = SBSymbolEditDialog.this.sbmodel.getGStructure().getSameIDAndViewComplexAlias(alias);
                return vctComplex.size() > 1;
            }
            HashMap<String, String> mapView = new HashMap<String, String>();
            String id = alias.getOriginalSpecies().getId();
            int i = 0;
            while (i < aliases.length) {
                String tmpId;
                if (aliases[i] instanceof ComplexSpeciesAlias && (aliases[i].getCurrentView() == 0 || aliases[i].getCurrentView() == 1 || aliases[i].getCurrentView() == 2) && id.equals(tmpId = aliases[i].getOriginalSpecies().getId()) && !mapView.containsKey(aliases[i].getCurrentViewString())) {
                    vctComplex = SBSymbolEditDialog.this.sbmodel.getGStructure().getSameIDAndViewComplexAlias((ComplexSpeciesAlias)aliases[i]);
                    if (vctComplex.size() > 1) {
                        return true;
                    }
                    mapView.put(aliases[i].getCurrentViewString(), "");
                    if (mapView.size() == 3) {
                        return false;
                    }
                }
                ++i;
            }
            return false;
        }

        private String getMessage(SpeciesAlias alias) {
            Species species = alias.getOriginalSpecies();
            String msg = "Change all the same " + species.getId() + " in this model?";
            if (alias instanceof ComplexSpeciesAlias) {
                msg = "Change all(" + species.getId() + ") which is in same ComplexView in this model?";
            }
            return msg;
        }

        private boolean applyChange() {
            boolean isChanged;
            block21: {
                Vector newNameFontSize;
                Vector oldNameFontSize;
                Vector newpaintings;
                Vector newdimensions;
                Vector oldpaintings;
                Vector olddimensions;
                Vector aliases;
                block22: {
                    MonoSpeciesShape shape = (MonoSpeciesShape)this.editingAlias.getGFramedShape();
                    Rectangle2D.Double bounds = this.editingAlias.getFrameBounds();
                    String code = null;
                    if (shape != null && shape.getSpeciesSymbol() instanceof SBSymbol) {
                        code = ((SBSymbol)((Object)shape.getSpeciesSymbol())).getCode();
                    }
                    boolean bl = isChanged = this.w != (int)bounds.width || this.h != (int)bounds.height || this.lineWidth != shape.getLineWidth() && !"UNKNOWN".equals(code) || !this.color.equals(shape.getColor()) || !this.painter.getClass().equals(shape.getPaintScheme().getClass());
                    if (!isChanged) break block21;
                    HashMap<String, Map<Object, Object>> mapSpecies = new HashMap<String, Map<Object, Object>>();
                    boolean isChangedW = true;
                    boolean isChangedH = true;
                    boolean isChangedLW = true;
                    boolean isChangedC = true;
                    boolean isChangedP = true;
                    Species species = this.editingAlias.getOriginalSpecies();
                    SpeciesAnnotation sExt = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null);
                    int flag = 3;
                    if (!this.isToChangeRelationship(this.editingAlias, this.editingAliases, isChangedW || isChangedH, true)) {
                        return false;
                    }
                    boolean multiRefsFlag = false;
                    if (sExt.getReferingAliases().size() > 1) {
                        multiRefsFlag = true;
                        if (this.editingAlias instanceof ComplexSpeciesAlias) {
                            flag = 2;
                            multiRefsFlag = this.isComplexHaveMutiRefsOfSelectedView((ComplexSpeciesAlias)this.editingAlias, this.editingAliases);
                        }
                    }
                    if (multiRefsFlag) {
                        String title = "The same species exist.";
                        String msg = this.getMessage(this.editingAlias);
                        int ans = JOptionPane.showConfirmDialog(this, msg, title, 1, 3, null);
                        if (ans == 2) {
                            return false;
                        }
                        if (ans == 0) {
                            flag = 1;
                        }
                        if (ans == 1) {
                            flag = 2;
                        }
                    }
                    int fs = -1;
                    if (this.editingAliases == null || this.editingAliases.length == 0) {
                        SBSymbolEditDialog.this.sbmodel.changeSpeciesShapePainting(this.editingAlias, new Dimension(this.w, this.h), new SpeciesShapePainting(this.lineWidth, this.color, this.painter), fs, flag, isChangedW, isChangedH, isChangedLW, isChangedC, isChangedP);
                        return isChanged;
                    }
                    aliases = new Vector();
                    olddimensions = new Vector();
                    oldpaintings = new Vector();
                    newdimensions = new Vector();
                    newpaintings = new Vector();
                    oldNameFontSize = new Vector();
                    newNameFontSize = new Vector();
                    SBSymbolEditDialog.this.sbmodel.changeSpeciesShapePainting(this.editingAlias, new Dimension(this.w, this.h), new SpeciesShapePainting(this.lineWidth, this.color, this.painter), fs, flag, aliases, olddimensions, oldpaintings, oldNameFontSize, newdimensions, newpaintings, newNameFontSize, isChangedW, isChangedH, isChangedLW, isChangedC, isChangedP);
                    Map<String, String> mapValue = new HashMap<String, String>();
                    mapValue.put(SBSymbolEditDialog.OPTION, String.valueOf(flag));
                    if (this.editingAlias instanceof ComplexSpeciesAlias) {
                        mapValue.put(this.editingAlias.getCurrentViewString(), "");
                    }
                    mapSpecies.put(species.getId(), mapValue);
                    if (this.editingAliases == null || this.editingAliases.length <= 1) break block22;
                    int i = 1;
                    while (i < this.editingAliases.length) {
                        block26: {
                            block24: {
                                block25: {
                                    block23: {
                                        species = this.editingAliases[i].getOriginalSpecies();
                                        sExt = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null);
                                        flag = 3;
                                        multiRefsFlag = false;
                                        if (mapSpecies.containsKey(species.getId())) break block23;
                                        if (sExt.getReferingAliases().size() > 1) {
                                            multiRefsFlag = true;
                                            if (this.editingAliases[i] instanceof ComplexSpeciesAlias) {
                                                flag = 2;
                                                multiRefsFlag = this.isComplexHaveMutiRefsOfSelectedView((ComplexSpeciesAlias)this.editingAliases[i], this.editingAliases);
                                            }
                                        }
                                        break block24;
                                    }
                                    Map value = (Map)mapSpecies.get(species.getId());
                                    if (!value.get(SBSymbolEditDialog.OPTION).equals(String.valueOf(1))) break block25;
                                    if (!(this.editingAliases[i] instanceof ComplexSpeciesAlias) || value.containsKey(this.editingAliases[i].getCurrentViewString())) break block26;
                                    flag = 1;
                                    break block24;
                                }
                                flag = 2;
                            }
                            if (multiRefsFlag) {
                                String title = "The same species exist.";
                                String msg = this.getMessage(this.editingAliases[i]);
                                int ans = JOptionPane.showConfirmDialog(this, msg, title, 1, 3, null);
                                if (ans == 2) {
                                    return false;
                                }
                                if (ans == 0) {
                                    flag = 1;
                                }
                                if (ans == 1) {
                                    flag = 2;
                                }
                            }
                            shape = (MonoSpeciesShape)this.editingAliases[i].getGFramedShape();
                            bounds = this.editingAliases[i].getFrameBounds();
                            SBSymbolEditDialog.this.sbmodel.changeSpeciesShapePainting(this.editingAliases[i], new Dimension(this.w, this.h), new SpeciesShapePainting(this.lineWidth, this.color, this.painter), fs, flag, aliases, olddimensions, oldpaintings, oldNameFontSize, newdimensions, newpaintings, newNameFontSize, isChangedW, isChangedH, isChangedLW, isChangedC, isChangedP);
                            if (!mapSpecies.containsKey(species.getId())) {
                                mapValue = new HashMap();
                                mapValue.put(SBSymbolEditDialog.OPTION, String.valueOf(flag));
                                if (this.editingAliases[i] instanceof ComplexSpeciesAlias) {
                                    mapValue.put(this.editingAliases[i].getCurrentViewString(), "");
                                }
                                mapSpecies.put(species.getId(), mapValue);
                            } else if (this.editingAliases[i] instanceof ComplexSpeciesAlias && !(mapValue = (Map)mapSpecies.get(species.getId())).containsKey(this.editingAliases[i].getCurrentViewString())) {
                                mapValue.put(this.editingAliases[i].getCurrentViewString(), "");
                            }
                        }
                        ++i;
                    }
                }
                SBSymbolEditDialog.this.sbmodel.doChange(aliases, olddimensions, oldpaintings, oldNameFontSize, newdimensions, newpaintings, newNameFontSize);
            }
            return isChanged;
        }
    }

    private class TagPanel
    extends JPanel {
        KeyAdapter keyListener;
        JPanel previewPanel = null;
        JPanel sizePanel = null;
        JPanel linePanel = null;
        PainterChooser painterPanel = null;
        MyColorChooser chooser = null;
        JPanel buttonPanel = null;
        LayerSpeciesSymbol symbol = null;
        LayerSpeciesAlias editingAlias = null;
        LayerMonoSpeciesShape monoshape = null;
        LayerSpeciesAlias[] editingAliases = null;
        int w = 0;
        int h = 0;
        Color color = null;
        PaintScheme painter = null;
        double lineWidth = 0.0;
        String tagDirect = "RIGHT";
        private JTextField defaultWidthField;
        private JTextField defaultHeightField;
        private JTextField lineWidthField;
        private JButton initButton;
        private JButton applyButton;
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");

        public TagPanel() {
            this.keyListener = new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    TagPanel.this.updateSize();
                }
            };
            super.setLayout(null);
            int x = SBSymbolEditDialog.INSETS.left;
            int y = SBSymbolEditDialog.INSETS.top;
            this.previewPanel = new JPanel();
            this.previewPanel.setBounds(x, y, SBSymbolEditDialog.PREVIEW.width, SBSymbolEditDialog.PREVIEW.height);
            this.previewPanel.setBackground(Color.white);
            this.previewPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Preview"));
            this.add((Component)this.previewPanel, null);
            this.sizePanel = new JPanel();
            this.sizePanel.setLayout(null);
            this.sizePanel.setOpaque(false);
            this.sizePanel.setBounds(new Rectangle(x += SBSymbolEditDialog.PREVIEW.width + 6, y, SBSymbolEditDialog.SIZE.width, SBSymbolEditDialog.SIZE.height));
            this.sizePanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Size"));
            this.add((Component)this.sizePanel, null);
            JLabel labelWidthField = new JLabel("Width");
            labelWidthField.setBounds(10, 20, 40, 20);
            this.sizePanel.add((Component)labelWidthField, null);
            this.defaultWidthField = new JTextField();
            this.defaultWidthField.setBounds(50, 20, 40, 20);
            this.defaultWidthField.setEditable(true);
            this.defaultWidthField.addKeyListener(this.keyListener);
            this.sizePanel.add((Component)this.defaultWidthField, null);
            JLabel labelHeightField = new JLabel("Height");
            labelHeightField.setBounds(110, 20, 50, 20);
            this.sizePanel.add((Component)labelHeightField, null);
            this.defaultHeightField = new JTextField();
            this.defaultHeightField.setBounds(160, 20, 40, 20);
            this.defaultHeightField.setEditable(true);
            this.defaultHeightField.addKeyListener(this.keyListener);
            this.sizePanel.add((Component)this.defaultHeightField, null);
            this.linePanel = new JPanel();
            this.linePanel.setLayout(null);
            this.linePanel.setOpaque(false);
            this.linePanel.setBounds(x, y += SBSymbolEditDialog.SIZE.height, SBSymbolEditDialog.LINE.width, SBSymbolEditDialog.LINE.height);
            this.linePanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Line"));
            this.add((Component)this.linePanel, null);
            JLabel labelLineWidthField = new JLabel("Width");
            labelLineWidthField.setBounds(10, 20, 40, 20);
            this.linePanel.add((Component)labelLineWidthField, null);
            this.lineWidthField = new JTextField();
            this.lineWidthField.setBounds(50, 20, 40, 20);
            this.lineWidthField.setEditable(true);
            this.lineWidthField.addKeyListener(this.keyListener);
            this.linePanel.add((Component)this.lineWidthField, null);
            this.painterPanel = new PainterChooser();
            this.painterPanel.setOpaque(false);
            this.painterPanel.setBounds(x, y += SBSymbolEditDialog.LINE.height, SBSymbolEditDialog.PAINTER.width, SBSymbolEditDialog.PAINTER.height);
            this.painterPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Paint"));
            this.add((Component)this.painterPanel, null);
            this.painterPanel.addPainterChangeListener(new PainterChangeListener(){

                @Override
                public void painterChanged(String command) {
                    TagPanel.this.painter_painterChangeDetected(command);
                }
            });
            x = SBSymbolEditDialog.INSETS.left;
            y = SBSymbolEditDialog.INSETS.top + SBSymbolEditDialog.PREVIEW.height;
            this.chooser = new MyColorChooser();
            this.chooser.setBounds(x, y, SBSymbolEditDialog.CHOOSER.width, SBSymbolEditDialog.CHOOSER.height);
            this.chooser.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(1), "Color"));
            this.add((Component)this.chooser, null);
            this.chooser.addColorChangeListener(new ColorChangeListener(){

                @Override
                public void colorChanged(Color colorin) {
                    TagPanel.this.chooser_colorChangeDetected(colorin);
                }
            });
            this.buttonPanel = new JPanel(new FlowLayout());
            this.buttonPanel.setBounds(x, y += SBSymbolEditDialog.CHOOSER.height, SBSymbolEditDialog.BUTTONS.width, SBSymbolEditDialog.BUTTONS.height);
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.buttonPanel, null);
            this.initButton = new JButton("Default");
            this.initButton.setMnemonic(68);
            this.initButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TagPanel.this.initButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.initButton, null);
            this.applyButton = new JButton("Apply");
            this.applyButton.setMnemonic(65);
            this.applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TagPanel.this.applyButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.applyButton, null);
            this.okButton.setMnemonic(79);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TagPanel.this.okButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.okButton, null);
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TagPanel.this.cancelButton_actionPerformed(e);
                }
            });
            this.buttonPanel.add((Component)this.cancelButton, null);
            this.setPreferredSize(new Dimension(SBSymbolEditDialog.INSETS.left + SBSymbolEditDialog.INSETS.right + SBSymbolEditDialog.CHOOSER.width, SBSymbolEditDialog.INSETS.top + SBSymbolEditDialog.INSETS.bottom + SBSymbolEditDialog.PREVIEW.height + SBSymbolEditDialog.CHOOSER.height + SBSymbolEditDialog.BUTTONS.height));
        }

        private void updateSize() {
            String w_str = this.defaultWidthField.getText();
            String h_str = this.defaultHeightField.getText();
            String linew_str = this.lineWidthField.getText();
            if (w_str.equals("") || h_str.equals("") || linew_str.equals("")) {
                return;
            }
            int input_w = 0;
            int input_h = 0;
            double input_linew = 0.0;
            try {
                input_w = Integer.parseInt(w_str);
                input_h = Integer.parseInt(h_str);
                input_linew = Double.parseDouble(linew_str);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "input must be a number.", "bad number", 2);
                this.defaultWidthField.setText("" + this.w);
                this.defaultHeightField.setText("" + this.h);
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                return;
            }
            if (input_w <= 0 || input_h <= 0) {
                JOptionPane.showMessageDialog(this, "widht and height must be > 0.", "bad number", 2);
                this.defaultWidthField.setText("" + this.w);
                this.defaultHeightField.setText("" + this.h);
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                return;
            }
            if (input_linew < 1.0) {
                JOptionPane.showMessageDialog(this, "line width must be >= 1.", "bad number", 2);
                this.defaultWidthField.setText("" + this.w);
                this.defaultHeightField.setText("" + this.h);
                this.lineWidthField.setText(Double.toString(this.lineWidth));
                return;
            }
            if (input_w > 0 && input_h > 0 && input_linew >= 1.0) {
                this.w = input_w;
                this.h = input_h;
                this.lineWidth = input_linew;
                this.repaint();
            }
        }

        public void setSpeciesAlias(LayerSpeciesAlias alias) {
            this.editingAlias = alias;
            this.editingAliases = new LayerSpeciesAlias[1];
            this.editingAliases[0] = this.editingAlias;
            if (!(alias.getGFramedShape() instanceof LayerMonoSpeciesShape)) {
                SBSymbolEditDialog.this.setPanel(3);
                return;
            }
            LayerMonoSpeciesShape shape = (LayerMonoSpeciesShape)alias.getGFramedShape();
            if (!(shape.getSpeciesSymbol() instanceof LayerTagSymbol)) {
                SBSymbolEditDialog.this.setPanel(3);
                return;
            }
            try {
                this.painter = (PaintScheme)shape.getPaintScheme().getClass().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Color color = shape.getColor();
            BasicStroke stroke = new BasicStroke((float)shape.getLineWidth(), 0, 1);
            this.painter.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
            this.painter.setStroke(stroke);
            Point2D.Double size = alias.getFrameSize();
            this.monoshape = (LayerMonoSpeciesShape)shape.duplicate();
            this.monoshape.setActive(shape.isActive());
            this.tagDirect = ((LayerTagSymbol)shape.getSpeciesSymbol()).getTagDirect();
            this.initialize((int)size.x, (int)size.y, this.monoshape.getLineWidth(), this.monoshape.getColor(), this.monoshape.getPaintScheme());
        }

        public void setSpeciesAlias(LayerSpeciesAlias[] aliases) {
            this.setSpeciesAlias(aliases[0]);
            this.editingAliases = aliases;
        }

        protected void initialize(int width, int height, double linewidth, Color colorin, PaintScheme painterin) {
            this.w = width;
            this.h = height;
            this.defaultWidthField.setText("" + this.w);
            this.defaultHeightField.setText("" + this.h);
            this.color = colorin;
            this.chooser.setColor(this.color);
            this.painter = painterin;
            this.painterPanel.setSelected(this.painter.getCode());
            this.lineWidth = linewidth;
            if (this.lineWidth < 1.0) {
                this.lineWidth = 1.0;
            }
            this.lineWidthField.setText(Double.toString(this.lineWidth));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            if (Preference.antialias) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            Dimension d = this.previewPanel.getSize();
            Rectangle bounds = this.previewPanel.getBounds();
            Insets i = new Insets(10, 5, 5, 5);
            Rectangle clipBounds = new Rectangle(bounds.x + i.left, bounds.y + i.top, bounds.width - i.left - i.right, bounds.height - i.top - i.bottom);
            double x = (double)(bounds.x + i.left) + (double)(d.width - i.left - i.right - this.w) / 2.0;
            double y = (double)(bounds.y + i.top) + (double)(d.height - i.top - i.bottom - this.h) / 2.0;
            if (x + (double)this.w + this.lineWidth / 2.0 > (double)(clipBounds.x + clipBounds.width)) {
                x = (double)(clipBounds.x + clipBounds.width - this.w) - this.lineWidth / 2.0;
            }
            if (y + (double)this.h + this.lineWidth / 2.0 > (double)(clipBounds.y + clipBounds.height)) {
                y = (double)(clipBounds.y + clipBounds.height - this.h) - this.lineWidth / 2.0;
            }
            this.monoshape.updateShape(x, y, this.w, this.h);
            if (this.monoshape.getSpeciesSymbol() instanceof LayerTagSymbol) {
                ((LayerTagSymbol)this.monoshape.getSpeciesSymbol()).setTagDirect(this.tagDirect);
                this.monoshape.updateShape(x, y, this.w, this.h);
            }
            this.monoshape.setColor(this.color);
            this.monoshape.setLineWidth(this.lineWidth);
            this.monoshape.setPaintScheme(this.painter);
            g2.setClip(clipBounds);
            this.monoshape.drawShape(g2, 1);
        }

        protected void initButton_actionPerformed(ActionEvent e) {
            LayerSpeciesSymbol symbol = this.monoshape.getSpeciesSymbol();
            Dimension d = symbol.defaultSize();
            String code = ((SBSymbol)((Object)symbol)).getCode();
            this.w = d.width;
            this.h = d.height;
            this.color = SpeciesColorScheme.getColor(code);
            this.painter = SpeciesColorScheme.getScheme(code);
            this.lineWidth = SpeciesColorScheme.getLineWidth(code);
            this.defaultWidthField.setText("" + this.w);
            this.defaultHeightField.setText("" + this.h);
            this.chooser.setColor(this.color);
            this.painterPanel.setSelected(this.painter.getCode());
            this.lineWidthField.setText(Double.toString(this.lineWidth));
            this.repaint();
        }

        private void applyButton_actionPerformed(ActionEvent e) {
            this.applyChange();
        }

        private void okButton_actionPerformed(ActionEvent e) {
            this.applyChange();
            SBSymbolEditDialog.this.dispose();
        }

        private void cancelButton_actionPerformed(ActionEvent e) {
            this.defaultWidthField.setText("");
            this.defaultHeightField.setText("");
            this.chooser.setColor(null);
            this.painterPanel.setSelected(null);
            this.lineWidthField.setText("");
            SBSymbolEditDialog.this.dispose();
        }

        private void chooser_colorChangeDetected(Color colorin) {
            this.color = colorin;
            this.repaint();
        }

        private void painter_painterChangeDetected(String code) {
            String scheme = PaintSchemeFactory.getName(code);
            this.painter = PaintSchemeFactory.create(scheme);
            this.repaint();
        }

        private boolean applyChange() {
            boolean isChanged;
            LayerMonoSpeciesShape shape = (LayerMonoSpeciesShape)this.editingAlias.getGFramedShape();
            Rectangle2D.Double bounds = this.editingAlias.getFrameBounds();
            boolean bl = isChanged = this.w != (int)bounds.width || this.h != (int)bounds.height || this.lineWidth != shape.getLineWidth() || !this.color.equals(shape.getColor()) || !this.painter.getClass().equals(shape.getPaintScheme().getClass());
            if (isChanged) {
                boolean isChangedW = true;
                boolean isChangedH = true;
                boolean isChangedLW = true;
                boolean isChangedC = true;
                boolean isChangedP = true;
                SBSymbolEditDialog.this.sbmodel.changeTagShapePainting(this.editingAliases, new Dimension(this.w, this.h), new SpeciesShapePainting(this.lineWidth, this.color, this.painter), isChangedW, isChangedH, isChangedLW, isChangedC, isChangedP);
                return isChanged;
            }
            return isChanged;
        }
    }
}

