/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.util.Vector;
import jp.sbi.celldesigner.ComplexSpeciesProperty;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesProfile;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNA;
import jp.sbi.celldesigner.sbmlExtension.Gene;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.RNA;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesReferenceAnnotation;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfCompartments;
import org.sbml.libsbml.ListOfReactions;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.ListOfSpeciesReferences;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.ModifierSpeciesReference;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesReference;

public class SBModelNamespace {
    private Model model = null;
    private String speciesNametag = null;
    private int speciesCnt = 0;
    private String compartmentNametag = null;
    private int compartmentCnt = 0;
    private String reactionNametag = null;
    private int reactionCnt = 0;
    private String proteinNametag = null;
    private int proteinCnt = 0;
    private String geneNametag = null;
    private int geneCnt = 0;
    private String rnaNametag = null;
    private int rnaCnt = 0;
    private String antisensernaNametag = null;
    private int antisensernaCnt = 0;

    public SBModelNamespace(Model model) {
        this.model = model;
    }

    public void dispose() {
        this.model = null;
    }

    public void setSpeciesNameTag(String nameTag) {
        this.speciesNametag = nameTag;
    }

    public void setCompartmentNameTag(String nameTag) {
        this.compartmentNametag = nameTag;
    }

    public void setReactionNameTag(String nameTag) {
        this.reactionNametag = nameTag;
    }

    public void setProteinNameTag(String nameTag) {
        this.proteinNametag = nameTag;
    }

    public void setGeneNameTag(String nameTag) {
        this.geneNametag = nameTag;
    }

    public void setRNANameTag(String nameTag) {
        this.rnaNametag = nameTag;
    }

    public void setAntiSenseRNANameTag(String nameTag) {
        this.antisensernaNametag = nameTag;
    }

    public void initCounters(SBModel sbModel) throws Exception {
        if (this.speciesNametag == null || this.compartmentNametag == null || this.reactionNametag == null || this.proteinNametag == null || this.geneNametag == null || this.rnaNametag == null || this.antisensernaNametag == null) {
            throw new Exception("init namespace, nameTags are void");
        }
        this.checkSpeciesMaxId(sbModel, this.model);
        this.checkCompartmentMaxId(this.model);
        this.checkReactionMaxId(this.model);
        this.checkProteinMaxId(sbModel, this.model);
        this.checkGeneMaxId(sbModel, this.model);
        this.checkRNAMaxId(sbModel, this.model);
        this.checkAntiSenseRNAMaxId(sbModel, this.model);
    }

    private void checkSpeciesMaxId(SBModel sbModel, Model model) {
        this.speciesCnt = 0;
        int maxCnt = 0;
        ListOfSpecies listOfSpecies = model.getListOfSpecies();
        int i = 0;
        while ((long)i < listOfSpecies.size()) {
            SpeciesAnnotation sExt;
            SpeciesProperty property;
            Species s = (Species)listOfSpecies.get((long)i);
            ++this.speciesCnt;
            String id = s.getId();
            String cntStr = id.substring(this.speciesNametag.length());
            if (!cntStr.equals("")) {
                try {
                    int cnt = Integer.parseInt(cntStr);
                    if (cnt > maxCnt) {
                        maxCnt = cnt;
                    }
                }
                catch (Exception cnt) {
                    // empty catch block
                }
            }
            if ((property = (sExt = (SpeciesAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)s, null)).getSpeciesProperty()) instanceof ComplexSpeciesProperty) {
                Vector aliases = ((ComplexSpeciesProperty)property).getSpeciesAliases();
                int k = 0;
                while (k < aliases.size()) {
                    SpeciesAlias alias = (SpeciesAlias)aliases.elementAt(k);
                    Species original = alias.getOriginalSpecies();
                    if (original != null && !(cntStr = (id = original.getId()).substring(this.speciesNametag.length())).equals("")) {
                        try {
                            int cnt = Integer.parseInt(cntStr);
                            if (cnt > maxCnt) {
                                maxCnt = cnt;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++k;
                }
            }
            ++i;
        }
        if (this.speciesCnt < maxCnt) {
            this.speciesCnt = maxCnt;
        }
    }

    private void checkCompartmentMaxId(Model model) {
        this.compartmentCnt = 0;
        int maxCnt = 0;
        ListOfCompartments listOfCompartments = model.getListOfCompartments();
        int i = 0;
        while ((long)i < listOfCompartments.size()) {
            Compartment c = (Compartment)listOfCompartments.get((long)i);
            if (!c.getId().equals("default")) {
                ++this.compartmentCnt;
                String id = c.getId();
                String cntStr = id.substring(this.compartmentNametag.length());
                if (!cntStr.equals("")) {
                    try {
                        int cnt = Integer.parseInt(cntStr);
                        if (cnt > maxCnt) {
                            maxCnt = cnt;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        if (this.compartmentCnt < maxCnt) {
            this.compartmentCnt = maxCnt;
        }
    }

    private void checkReactionMaxId(Model model) {
        this.reactionCnt = 0;
        int maxCnt = 0;
        ListOfReactions list = model.getListOfReactions();
        int i = 0;
        while ((long)i < list.size()) {
            Reaction r = (Reaction)list.get((long)i);
            ++this.reactionCnt;
            String id = r.getId();
            try {
                String cntStr = id.substring(this.reactionNametag.length());
                int cnt = Integer.parseInt(cntStr);
                if (cnt > maxCnt) {
                    maxCnt = cnt;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        if (this.reactionCnt < maxCnt) {
            this.reactionCnt = maxCnt;
        }
    }

    private void checkProteinMaxId(SBModel sbModel, Model model) {
        this.proteinCnt = 0;
        int maxCnt = 0;
        ListOf list = ((ModelAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)model, null)).getListOfProteins();
        int i = 0;
        while ((long)i < list.size()) {
            Species p = (Species)list.get((long)i);
            ++this.proteinCnt;
            String id = p.getId();
            String cntStr = id.substring(this.proteinNametag.length());
            if (!cntStr.equals("")) {
                try {
                    int cnt = Integer.parseInt(cntStr);
                    if (cnt > maxCnt) {
                        maxCnt = cnt;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (this.proteinCnt < maxCnt) {
            this.proteinCnt = maxCnt;
        }
    }

    private void checkGeneMaxId(SBModel sbModel, Model model) {
        this.geneCnt = 0;
        int maxCnt = 0;
        ListOf list = ((ModelAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)model, null)).getListOfGenes();
        int i = 0;
        while ((long)i < list.size()) {
            Species p = (Species)list.get((long)i);
            ++this.geneCnt;
            String id = p.getId();
            String cntStr = id.substring(this.geneNametag.length());
            if (!cntStr.equals("")) {
                try {
                    int cnt = Integer.parseInt(cntStr);
                    if (cnt > maxCnt) {
                        maxCnt = cnt;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (this.geneCnt < maxCnt) {
            this.geneCnt = maxCnt;
        }
    }

    private void checkRNAMaxId(SBModel sbModel, Model model) {
        this.rnaCnt = 0;
        int maxCnt = 0;
        ListOf list = ((ModelAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)model, null)).getListOfRNAs();
        int i = 0;
        while ((long)i < list.size()) {
            Species p = (Species)list.get((long)i);
            ++this.rnaCnt;
            String id = p.getId();
            String cntStr = id.substring(this.rnaNametag.length());
            if (!cntStr.equals("")) {
                try {
                    int cnt = Integer.parseInt(cntStr);
                    if (cnt > maxCnt) {
                        maxCnt = cnt;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (this.rnaCnt < maxCnt) {
            this.rnaCnt = maxCnt;
        }
    }

    private void checkAntiSenseRNAMaxId(SBModel sbModel, Model model) {
        this.antisensernaCnt = 0;
        int maxCnt = 0;
        ListOf list = ((ModelAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)model, null)).getListOfAntiSenseRNAs();
        int i = 0;
        while ((long)i < list.size()) {
            Species p = (Species)list.get((long)i);
            ++this.antisensernaCnt;
            String id = p.getId();
            String cntStr = id.substring(this.antisensernaNametag.length());
            if (!cntStr.equals("")) {
                try {
                    int cnt = Integer.parseInt(cntStr);
                    if (cnt > maxCnt) {
                        maxCnt = cnt;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (this.antisensernaCnt < maxCnt) {
            this.antisensernaCnt = maxCnt;
        }
    }

    public String createNewSpeciesId() {
        String id = "";
        do {
            ++this.speciesCnt;
        } while (this.isSameSpeciesIDExists(id = String.valueOf(this.speciesNametag) + this.speciesCnt));
        return id;
    }

    public String nextNewSpeciesId() {
        String id = "";
        int cnt = this.speciesCnt;
        while (this.isSameSpeciesIDExists(id = String.valueOf(this.speciesNametag) + ++cnt)) {
        }
        return id;
    }

    public String createNewCompartmentId() {
        String id = "";
        do {
            ++this.compartmentCnt;
        } while (this.isSameCompartmentIDExists(id = String.valueOf(this.compartmentNametag) + this.compartmentCnt));
        return id;
    }

    public String nextNewCompartmentId() {
        String id = "";
        int cnt = this.compartmentCnt;
        while (this.isSameCompartmentIDExists(id = String.valueOf(this.compartmentNametag) + ++cnt)) {
        }
        return id;
    }

    public String createNewReactionId() {
        ++this.reactionCnt;
        return String.valueOf(this.reactionNametag) + this.reactionCnt;
    }

    public String nextNewReactionId() {
        String id = "";
        int cnt = this.reactionCnt;
        while (this.isSameReactionIDExists(id = String.valueOf(this.reactionNametag) + ++cnt)) {
        }
        return id;
    }

    public String createNewProteinId() {
        String id = "";
        do {
            ++this.proteinCnt;
        } while (this.isSameProteinIDExists(id = String.valueOf(this.proteinNametag) + this.proteinCnt));
        return id;
    }

    public String nextNewProteinId() {
        String id = "";
        int cnt = this.proteinCnt;
        while (this.isSameProteinIDExists(id = String.valueOf(this.proteinNametag) + ++cnt)) {
        }
        return id;
    }

    public String createNewGeneId() {
        String id = "";
        do {
            ++this.geneCnt;
        } while (this.isSameGeneIDExists(id = String.valueOf(this.geneNametag) + this.geneCnt));
        return id;
    }

    public String nextNewGeneId() {
        String id = "";
        int cnt = this.geneCnt;
        while (this.isSameGeneIDExists(id = String.valueOf(this.geneNametag) + ++cnt)) {
        }
        return id;
    }

    public String createNewRNAId() {
        String id = "";
        do {
            ++this.rnaCnt;
        } while (this.isSameRNAIDExists(id = String.valueOf(this.rnaNametag) + this.rnaCnt));
        return id;
    }

    public String nextNewRNAId() {
        String id = "";
        int cnt = this.rnaCnt;
        while (this.isSameRNAIDExists(id = String.valueOf(this.rnaNametag) + ++cnt)) {
        }
        return id;
    }

    public String createNewAntiSenseRNAId() {
        String id = "";
        do {
            ++this.antisensernaCnt;
        } while (this.isSameAntiSenseRNAIDExists(id = String.valueOf(this.antisensernaNametag) + this.antisensernaCnt));
        return id;
    }

    public String nextNewAntiSenseRNAId() {
        String id = "";
        int cnt = this.rnaCnt;
        do {
            ++this.antisensernaCnt;
        } while (this.isSameAntiSenseRNAIDExists(id = String.valueOf(this.antisensernaNametag) + cnt));
        return id;
    }

    public boolean isSameSpeciesIDExists(String id) {
        boolean rtn = false;
        ListOfSpecies list = this.model.getListOfSpecies();
        int i = 0;
        while ((long)i < list.size()) {
            Species s = (Species)list.get((long)i);
            if (s.getId().equals(id)) {
                rtn = true;
                break;
            }
            ++i;
        }
        return rtn;
    }

    public boolean isSameReactionIDExists(String id) {
        boolean rtn = false;
        ListOfReactions list = this.model.getListOfReactions();
        int i = 0;
        while ((long)i < list.size()) {
            Reaction c = (Reaction)list.get((long)i);
            if (c.getId().equals(id)) {
                rtn = true;
                break;
            }
            ++i;
        }
        return rtn;
    }

    public boolean isSameCompartmentIDExists(String id) {
        boolean rtn = false;
        ListOfCompartments list = this.model.getListOfCompartments();
        int i = 0;
        while ((long)i < list.size()) {
            Compartment c = (Compartment)list.get((long)i);
            if (c.getId().equals(id)) {
                rtn = true;
                break;
            }
            ++i;
        }
        return rtn;
    }

    public boolean isSameProteinIDExists(String id) {
        boolean rtn = false;
        ListOf list = ((ModelAnnotation)LibSBMLUtil.getAnnotation((SBase)this.model, null)).getListOfProteins();
        int i = 0;
        while ((long)i < list.size()) {
            Species p = (Species)list.get((long)i);
            if (p.getId().equals(id)) {
                rtn = true;
                break;
            }
            ++i;
        }
        return rtn;
    }

    public boolean isSameGeneIDExists(String id) {
        boolean rtn = false;
        ListOf list = ((ModelAnnotation)LibSBMLUtil.getAnnotation((SBase)this.model, null)).getListOfGenes();
        int i = 0;
        while ((long)i < list.size()) {
            Species p = (Species)list.get((long)i);
            if (p.getId().equals(id)) {
                rtn = true;
                break;
            }
            ++i;
        }
        return rtn;
    }

    public boolean isSameRNAIDExists(String id) {
        boolean rtn = false;
        ListOf list = ((ModelAnnotation)LibSBMLUtil.getAnnotation((SBase)this.model, null)).getListOfRNAs();
        int i = 0;
        while ((long)i < list.size()) {
            Species p = (Species)list.get((long)i);
            if (p.getId().equals(id)) {
                rtn = true;
                break;
            }
            ++i;
        }
        return rtn;
    }

    public boolean isSameAntiSenseRNAIDExists(String id) {
        boolean rtn = false;
        ListOf list = ((ModelAnnotation)LibSBMLUtil.getAnnotation((SBase)this.model, null)).getListOfAntiSenseRNAs();
        int i = 0;
        while ((long)i < list.size()) {
            Species p = (Species)list.get((long)i);
            if (p.getId().equals(id)) {
                rtn = true;
                break;
            }
            ++i;
        }
        return rtn;
    }

    public Species getCorrespondingSpecies(SpeciesProfile profile) {
        Species rtn = null;
        ListOfSpecies list = this.model.getListOfSpecies();
        int i = 0;
        while ((long)i < list.size()) {
            Species s = (Species)list.get((long)i);
            SpeciesProfile s_profile = SpeciesProfile.createProfile(s);
            if (profile.corresponds(s_profile)) {
                rtn = s;
                break;
            }
            ++i;
        }
        return rtn;
    }

    public Compartment getCorrespondingCompartment(String name) {
        Compartment rtn = null;
        ListOfCompartments list = this.model.getListOfCompartments();
        int i = 0;
        while ((long)i < list.size()) {
            Compartment c = (Compartment)list.get((long)i);
            if (name.equals(c.getName())) {
                rtn = c;
                break;
            }
            ++i;
        }
        return rtn;
    }

    public Protein getCorrespondingProtein(String name) {
        return this.getCorrespondingProtein(name, null);
    }

    public Protein getCorrespondingProtein(String name, Protein skipping) {
        Protein rtn = null;
        ListOf list = ((ModelAnnotation)LibSBMLUtil.getAnnotation((SBase)this.model, null)).getListOfProteins();
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        int i = 0;
        while ((long)i < list.size()) {
            Species s = (Species)list.get((long)i);
            Protein p = sbModel.getProtein(s.getId());
            if (p != skipping && p.getName().equals(name)) {
                rtn = p;
                break;
            }
            ++i;
        }
        return rtn;
    }

    public Gene getCorrespondingGene(String name) {
        return this.getCorrespondingGene(name, null);
    }

    public Gene getCorrespondingGene(String name, Gene skipping) {
        Gene rtn = null;
        ListOf list = ((ModelAnnotation)LibSBMLUtil.getAnnotation((SBase)this.model, null)).getListOfGenes();
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        int i = 0;
        while ((long)i < list.size()) {
            Species s = (Species)list.get((long)i);
            Gene p = sbModel.getGene(s.getId());
            if (p != skipping && p.getName().equals(name)) {
                rtn = p;
                break;
            }
            ++i;
        }
        return rtn;
    }

    public RNA getCorrespondingRNA(String name) {
        return this.getCorrespondingRNA(name, null);
    }

    public RNA getCorrespondingRNA(String name, RNA skipping) {
        RNA rtn = null;
        ListOf list = ((ModelAnnotation)LibSBMLUtil.getAnnotation((SBase)this.model, null)).getListOfRNAs();
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        int i = 0;
        while ((long)i < list.size()) {
            Species s = (Species)list.get((long)i);
            RNA p = sbModel.getRNA(s.getId());
            if (p != skipping && p.getName().equals(name)) {
                rtn = p;
                break;
            }
            ++i;
        }
        return rtn;
    }

    public AntiSenseRNA getCorrespondingAntiSenseRNA(String name) {
        return this.getCorrespondingAntiSenseRNA(name, null);
    }

    public AntiSenseRNA getCorrespondingAntiSenseRNA(String name, AntiSenseRNA skipping) {
        AntiSenseRNA rtn = null;
        ListOf list = ((ModelAnnotation)LibSBMLUtil.getAnnotation((SBase)this.model, null)).getListOfAntiSenseRNAs();
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        int i = 0;
        while ((long)i < list.size()) {
            Species s = (Species)list.get((long)i);
            AntiSenseRNA p = sbModel.getAntiSenseRNA(s.getId());
            if (p != skipping && p.getName().equals(name)) {
                rtn = p;
                break;
            }
            ++i;
        }
        return rtn;
    }

    public void changeSpeciesReferenceIds(SpeciesAlias alias) {
        String aliasName = alias.getName();
        String newSpeciesId = alias.getOriginalSpecies().getId();
        ListOfReactions listOfReactions = this.model.getListOfReactions();
        int i = 0;
        while ((long)i < listOfReactions.size()) {
            Reaction r = (Reaction)listOfReactions.get((long)i);
            ListOfSpeciesReferences listOfReactants = r.getListOfReactants();
            int j = 0;
            while ((long)j < listOfReactants.size()) {
                SpeciesReference ref = (SpeciesReference)listOfReactants.get((long)j);
                SpeciesReferenceAnnotation refExt = (SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(r, (SBase)ref, "Reactants", j, null);
                if (refExt.getTmpAliasId().equals(aliasName)) {
                    ref.setSpecies(newSpeciesId);
                }
                ++j;
            }
            ListOfSpeciesReferences listOfProducts = r.getListOfProducts();
            int j2 = 0;
            while ((long)j2 < listOfProducts.size()) {
                SpeciesReference ref = (SpeciesReference)listOfProducts.get((long)j2);
                SpeciesReferenceAnnotation refExt = (SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(r, (SBase)ref, "Products", j2, null);
                if (refExt.getTmpAliasId().equals(aliasName)) {
                    ref.setSpecies(newSpeciesId);
                }
                ++j2;
            }
            ListOfSpeciesReferences listOfModifires = r.getListOfModifiers();
            int j3 = 0;
            while ((long)j3 < listOfModifires.size()) {
                ModifierSpeciesReference ref = (ModifierSpeciesReference)listOfModifires.get((long)j3);
                SpeciesReferenceAnnotation refExt = (SpeciesReferenceAnnotation)LibSBMLUtil.getAnnotation(r, (SBase)ref, null, j3, null);
                if (refExt.getTmpAliasId().equals(aliasName)) {
                    ref.setSpecies(newSpeciesId);
                }
                ++j3;
            }
            ++i;
        }
    }

    public int getIndexOf(Species species) {
        ListOfSpecies list = this.model.getListOfSpecies();
        int index = -1;
        int i = 0;
        while ((long)i < list.size()) {
            Species s = (Species)list.get((long)i);
            if (species.getId().equals(s.getId())) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public int getIndexOf(Compartment compartment) {
        ListOfCompartments list = this.model.getListOfCompartments();
        int index = -1;
        int i = 0;
        while ((long)i < list.size()) {
            Compartment c = (Compartment)list.get((long)i);
            if (compartment.getId().equals(c.getId())) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public int getIndexOf(Reaction reaction) {
        ListOfReactions list = this.model.getListOfReactions();
        int index = -1;
        int i = 0;
        while ((long)i < list.size()) {
            Reaction r = (Reaction)list.get((long)i);
            if (reaction.getId().equals(r.getId())) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public String badIdMessage(String id) {
        return "Malformed name input : " + id + "\nPlease see \"Help\" menu -> \"Name Expression\".";
    }
}

