/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Vector;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.fric.util.StopWatch;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MyTreePanel;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.sbmlExtension.CompartmentAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.sbml.util.EventDialog;
import jp.sbi.sbml.util.KineticLawDialog;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.MathEditor;
import jp.sbi.sbml.util.ObservableAspect;
import jp.sbi.sbml.util.ReactionDialog;
import jp.sbi.sbml.util.SBMLPanelLists;
import jp.sbi.sbml.util.SBaseDialog;
import jp.sbi.sbml.util.SBaseListPanel;
import jp.sbi.sbml.util.SBaseListPanelListener;
import jp.sbi.sbml.util.SpeciesListPanel;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.ListOfCompartments;
import org.sbml.libsbml.ListOfReactions;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class SBModelHighlighter {
    private SBModelFrame sbframe;
    private Model model;
    private GStructure gStructure;
    SpeciesHighlighter sh;
    CompartmentHighlighter ch;
    ReactionHighlighter rh;
    ParameterHighlighter ph;
    private boolean isSelectingStructureByMe = false;
    SBMLPanelLists sbmlPanelLists;
    BaseHightlighter proteinH;
    BaseHightlighter geneH;
    BaseHightlighter ranH;
    BaseHightlighter antiRNAH;
    SBaseListPanel proteinListPanel;
    SBaseListPanel geneListPanel;
    SBaseListPanel rnaListPanel;
    SBaseListPanel antisensernaListPanel;
    MyTreePanel mytree;

    public SBModelHighlighter(Model model, GStructure gStructure, SBMLPanelLists sbmlPanelLists, SBaseListPanel proteinListPanel, SBaseListPanel geneListPanel, SBaseListPanel rnaListPanel, SBaseListPanel antisensernaListPanel, MyTreePanel mytree) {
        this.sbmlPanelLists = sbmlPanelLists;
        this.proteinListPanel = proteinListPanel;
        this.geneListPanel = geneListPanel;
        this.rnaListPanel = rnaListPanel;
        this.antisensernaListPanel = antisensernaListPanel;
        this.mytree = mytree;
        this.model = model;
        this.gStructure = gStructure;
        Vector<SBaseDialog> mathEditors = new Vector<SBaseDialog>();
        ReactionDialog rd = (ReactionDialog)sbmlPanelLists.getElementDialog(6);
        mathEditors.addElement(rd.getSBaseListPanel(0).getElementDialog());
        mathEditors.addElement(rd.getSBaseListPanel(1).getElementDialog());
        mathEditors.addElement(rd.getKineticLawDialog());
        mathEditors.addElement(sbmlPanelLists.getElementDialog(0));
        mathEditors.addElement(sbmlPanelLists.getElementDialog(5));
        EventDialog ed = (EventDialog)sbmlPanelLists.getElementDialog(7);
        mathEditors.addElement(ed);
        mathEditors.addElement(ed.getSBaseListDialog(0).getElementDialog());
        mathEditors.addElement(sbmlPanelLists.getElementDialog(16));
        mathEditors.addElement(sbmlPanelLists.getElementDialog(17));
        this.sh = new SpeciesHighlighter(sbmlPanelLists.getSBaseListPanel(3), ((KineticLawDialog)rd.getKineticLawDialog()).getSBaseListPanel(0), mathEditors);
        this.ch = new CompartmentHighlighter(sbmlPanelLists.getSBaseListPanel(2), mathEditors);
        this.rh = new ReactionHighlighter(sbmlPanelLists.getSBaseListPanel(6));
        this.ph = new ParameterHighlighter(sbmlPanelLists.getSBaseListPanel(4), mathEditors);
        this.proteinH = new BaseHightlighter(proteinListPanel, mathEditors, "Protein");
        this.geneH = new BaseHightlighter(geneListPanel, mathEditors, "Gene");
        this.ranH = new BaseHightlighter(rnaListPanel, mathEditors, "RNA");
        this.antiRNAH = new BaseHightlighter(antisensernaListPanel, mathEditors, "AntiSenseRNA");
    }

    public void setSBModelFrame(SBModelFrame sbframe) {
        this.sbframe = sbframe;
    }

    public void dispose() {
        this.sh.dispose();
        this.ch.dispose();
        this.rh.dispose();
        this.ph.dispose();
        this.proteinH.dispose();
        this.geneH.dispose();
        this.ranH.dispose();
        this.antiRNAH.dispose();
        this.sh = null;
        this.ch = null;
        this.rh = null;
        this.ph = null;
        this.proteinH = null;
        this.geneH = null;
        this.ranH = null;
        this.antiRNAH = null;
        this.model = null;
        this.gStructure = null;
        this.sbframe = null;
    }

    public void elementSelected(GElement element) {
        if (this.isSelectingStructureByMe) {
            return;
        }
        this.sh.clearHighlightDialog();
        this.ch.clearHighlightDialog();
        this.proteinH.clearHighlightDialog();
        this.geneH.clearHighlightDialog();
        this.ranH.clearHighlightDialog();
        this.antiRNAH.clearHighlightDialog();
        this.rh.clearHighlightDialog();
        if (element == null) {
            return;
        }
        if (element instanceof SpeciesAlias) {
            this.sh.highlightDialog((SpeciesAlias)element);
        }
        if (element instanceof CompartmentAlias) {
            this.ch.highlightDialog((CompartmentAlias)((Object)element));
        }
        if (element instanceof ReactionLink) {
            this.rh.highlightDialog((ReactionLink)element);
        }
    }

    public void elementsSelected(Vector elements) {
        if (this.isSelectingStructureByMe) {
            return;
        }
        if (elements == null || elements.size() == 0) {
            this.sh.clearHighlightDialog();
            this.ch.clearHighlightDialog();
            this.rh.clearHighlightDialog();
            return;
        }
        if (elements.get(0) instanceof SpeciesAlias) {
            StopWatch.start("sh");
            this.sh.highlightsDialog(elements);
            StopWatch.stop("sh");
        }
        if (elements.get(0) instanceof CompartmentAlias) {
            StopWatch.start("ch");
            this.ch.highlightsDialog(elements);
            StopWatch.stop("ch");
        }
        if (elements.get(0) instanceof ReactionLink) {
            StopWatch.start("rh");
            this.rh.highlightsDialog(elements);
            StopWatch.stop("rh");
        }
    }

    private void notifyComponentSelectionChanged() {
        this.sbframe.getSBModel().fireComponentSelectionChanged();
    }

    public void reNotifyObservers(int selectmode, Object object) {
        if (selectmode == 9) {
            this.sh.reNotifyObservers(new ObservableAspect(9));
        } else {
            this.sh.reNotifyObservers(new ObservableAspect(selectmode, object));
        }
    }

    public boolean isSameGStructure(GStructure structure) {
        if (structure == null) {
            return false;
        }
        return structure == this.gStructure;
    }

    private class BaseHightlighter
    extends Observable
    implements SBaseListPanelListener {
        SBaseListPanel pnl;
        SpeciesListPanel sp = null;
        String type = "";
        private boolean isSelectingDlgByMe = false;

        private BaseHightlighter(SBaseListPanel pnl, Vector mathEditors, String value) {
            this.pnl = pnl;
            this.type = value;
            this.sp = (SpeciesListPanel)SBModelHighlighter.this.sbmlPanelLists.getSBaseListPanel(3);
            int i = 0;
            while (i < mathEditors.size()) {
                MathEditor me = (MathEditor)mathEditors.elementAt(i);
                this.addObserver(me.getMathEditPanel());
                ++i;
            }
            pnl.addSBaseListPanelListener(this);
        }

        private void dispose() {
            this.pnl.removeSBaseListPanelListener(this);
            this.deleteObservers();
            this.pnl = null;
            this.deleteObservers();
        }

        @Override
        public void elementAdded(SBase sbase) {
        }

        @Override
        public void elementUpdated(SBase sbase, String[] oldValues) {
        }

        @Override
        public void elementsRemoved(SBase[] sbases, int[] index) {
        }

        @Override
        public void elementsDeselected() {
            this.setChanged();
            this.notifyObservers(new ObservableAspect(9));
            this.clearChanged();
            SBModelHighlighter.this.notifyComponentSelectionChanged();
        }

        @Override
        public void elementsDeselectedByList() {
            SBModelHighlighter.this.gStructure.deselectAll();
            this.setChanged();
            this.notifyObservers(new ObservableAspect(9));
            this.clearChanged();
            SBModelHighlighter.this.notifyComponentSelectionChanged();
        }

        @Override
        public void elementsSelected(SBase[] sbases) {
            Object[] rb = null;
            try {
                rb = SBModelHighlighter.this.sbframe.getSelectedProteinEtcByID(sbases, this.type).toArray();
            }
            catch (Exception ex) {
                return;
            }
            if (!this.isSelectingDlgByMe) {
                Rectangle2D.Double rect = null;
                boolean deselectflg = true;
                int i = 0;
                while (i < rb.length) {
                    rect = GUtil.union(this.higlightAliases((Species)rb[i], deselectflg), rect);
                    deselectflg = false;
                    ++i;
                }
                SBModelHighlighter.this.isSelectingStructureByMe = true;
                rect = GUtil.union(SBModelHighlighter.this.gStructure.highlightChainedLinks(), rect);
                SBModelHighlighter.this.gStructure.notifyChangeSelected();
                SBModelHighlighter.this.sbframe.needsRepaint(rect);
                SBModelHighlighter.this.isSelectingStructureByMe = false;
            }
            SBModelHighlighter.this.notifyComponentSelectionChanged();
            this.sp.selectElement(rb);
            SBModelHighlighter.this.mytree.setProteinEtcSelectNode(rb);
            int j = 0;
            while (j < rb.length) {
                SBModelHighlighter.this.mytree.selectNode(3, ((Species)rb[j]).getId());
                ++j;
            }
        }

        private Rectangle2D higlightAliases(Species species, boolean deselectflg) {
            SBModelHighlighter.this.isSelectingStructureByMe = true;
            if (deselectflg) {
                SBModelHighlighter.this.gStructure.deselectAll();
            }
            Rectangle2D.Double rect = null;
            Vector aliases = ((SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null)).getReferingAliases();
            int i = 0;
            while (i < aliases.size()) {
                SpeciesAlias alias = (SpeciesAlias)aliases.elementAt(i);
                rect = GUtil.union(SBModelHighlighter.this.gStructure.select(alias, false, false, false), rect);
                ++i;
            }
            SBModelHighlighter.this.isSelectingStructureByMe = false;
            return rect;
        }

        private void clearHighlightDialog() {
            this.pnl.clearSelectElement();
        }

        @Override
        public void elementMousePressed(SBase sb) {
            if (!(sb instanceof Species)) {
                return;
            }
            SBModelHighlighter.this.notifyComponentSelectionChanged();
        }
    }

    private class CompartmentHighlighter
    extends Observable
    implements SBaseListPanelListener {
        SBaseListPanel pnl;
        private boolean isSelectingDlgByMe = false;

        private CompartmentHighlighter(SBaseListPanel pnl, Vector mathEditors) {
            this.pnl = pnl;
            int i = 0;
            while (i < mathEditors.size()) {
                MathEditor me = (MathEditor)mathEditors.elementAt(i);
                this.addObserver(me.getMathEditPanel());
                ++i;
            }
            pnl.addSBaseListPanelListener(this);
        }

        private void dispose() {
            this.pnl.removeSBaseListPanelListener(this);
            this.deleteObservers();
            this.pnl = null;
        }

        @Override
        public void elementAdded(SBase sbase) {
        }

        @Override
        public void elementUpdated(SBase sbase, String[] oldValues) {
        }

        @Override
        public void elementsRemoved(SBase[] sbases, int[] index) {
        }

        @Override
        public void elementsDeselected() {
            this.setChanged();
            this.notifyObservers(new ObservableAspect(9));
            this.clearChanged();
            SBModelHighlighter.this.notifyComponentSelectionChanged();
        }

        @Override
        public void elementsDeselectedByList() {
            SBModelHighlighter.this.gStructure.deselectAll();
            this.setChanged();
            this.notifyObservers(new ObservableAspect(9));
            this.clearChanged();
            SBModelHighlighter.this.notifyComponentSelectionChanged();
        }

        @Override
        public void elementsSelected(SBase[] sbases) {
            if (MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure() != SBModelHighlighter.this.gStructure) {
                return;
            }
            if (!this.isSelectingDlgByMe) {
                Rectangle2D.Double rect = null;
                boolean deselectflg = true;
                int i = 0;
                while (i < sbases.length) {
                    Compartment c = (Compartment)sbases[i];
                    rect = GUtil.union(this.higlightAliases(c, deselectflg), rect);
                    deselectflg = false;
                    ++i;
                }
                SBModelHighlighter.this.isSelectingStructureByMe = true;
                SBModelHighlighter.this.gStructure.notifyChangeSelected();
                SBModelHighlighter.this.sbframe.needsRepaint(rect);
                SBModelHighlighter.this.isSelectingStructureByMe = false;
            }
            Compartment compartment = (Compartment)sbases[sbases.length - 1];
            this.setChanged();
            this.notifyObservers(new ObservableAspect(4, compartment));
            this.clearChanged();
            SBModelHighlighter.this.notifyComponentSelectionChanged();
            ListOfCompartments list = SBModelHighlighter.this.model.getListOfCompartments();
            Vector comps = SBModelHighlighter.this.gStructure.getSelecteds();
            Vector<String> ids = new Vector<String>();
            Vector<Integer> indexs = new Vector<Integer>();
            int i = 0;
            while ((long)i < list.size()) {
                int j = 0;
                while (j < comps.size()) {
                    Compartment c = (Compartment)list.get((long)i);
                    CompartmentAlias alias = (CompartmentAlias)comps.get(j);
                    Compartment compartment2 = alias.getOriginalCompartment();
                    if (compartment2.getId().equals(c.getId())) {
                        indexs.add(new Integer(i));
                        ids.add(c.getId());
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            if (ids.size() > 0) {
                int[] idarray = new int[indexs.size()];
                int k = 0;
                while (k < ids.size()) {
                    Integer id = (Integer)indexs.elementAt(k);
                    idarray[k] = id;
                    ++k;
                }
                this.pnl.setFromCanvasEvent(true);
                this.pnl.setFromTreeEvent(false);
                this.pnl.selectElement(idarray);
            }
        }

        private Rectangle2D higlightAliases(Compartment compartment, boolean deselectflg) {
            SBModelHighlighter.this.isSelectingStructureByMe = true;
            if (deselectflg) {
                SBModelHighlighter.this.gStructure.deselectAll();
            }
            Rectangle2D.Double rect = null;
            Vector aliases = ((CompartmentAnnotation)LibSBMLUtil.getAnnotation((SBase)compartment, null)).getReferingAliases();
            int i = 0;
            while (i < aliases.size()) {
                CompartmentAlias alias = (CompartmentAlias)aliases.elementAt(i);
                rect = GUtil.union(SBModelHighlighter.this.gStructure.select((GElement)((Object)alias), false, false, false), rect);
                ++i;
            }
            SBModelHighlighter.this.isSelectingStructureByMe = false;
            return rect;
        }

        private void highlightDialog(CompartmentAlias alias) {
            this.isSelectingDlgByMe = true;
            Compartment compartment = alias.getOriginalCompartment();
            if (compartment == null) {
                return;
            }
            ListOfCompartments list = SBModelHighlighter.this.model.getListOfCompartments();
            int index = -1;
            int i = 0;
            while ((long)i < list.size()) {
                Compartment c = (Compartment)list.get((long)i);
                if (compartment.getId().equals(c.getId())) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index != -1 && this.pnl != null) {
                this.pnl.setFromCanvasEvent(true);
                this.pnl.setFromTreeEvent(false);
                this.pnl.selectElement(new int[]{index});
            }
            this.isSelectingDlgByMe = false;
        }

        private void highlightsDialog(Vector aliases) {
            this.isSelectingDlgByMe = true;
            Vector<Integer> indexs = new Vector<Integer>();
            ListOfCompartments list = SBModelHighlighter.this.model.getListOfCompartments();
            int i = 0;
            while (i < aliases.size()) {
                CompartmentAlias alias;
                Compartment compartment;
                Object obj = aliases.get(i);
                if (obj instanceof CompartmentAlias && (compartment = (alias = (CompartmentAlias)obj).getOriginalCompartment()) != null) {
                    Integer val;
                    int index = -1;
                    int k = 0;
                    while ((long)k < list.size()) {
                        Compartment c = (Compartment)list.get((long)k);
                        if (compartment.getId().equals(c.getId())) {
                            index = k;
                            break;
                        }
                        ++k;
                    }
                    if (index != -1 && !indexs.contains(val = new Integer(index))) {
                        indexs.add(val);
                    }
                }
                ++i;
            }
            if (indexs.size() > 0 && this.pnl != null) {
                int[] idarray = new int[indexs.size()];
                int i2 = 0;
                while (i2 < indexs.size()) {
                    Integer id = (Integer)indexs.get(i2);
                    idarray[i2] = id;
                    ++i2;
                }
                this.pnl.setFromCanvasEvent(true);
                this.pnl.setFromTreeEvent(false);
                this.pnl.selectElement(idarray);
            }
            this.isSelectingDlgByMe = false;
        }

        private void highlightsDialog_orgn(Vector aliases) {
            this.isSelectingDlgByMe = true;
            Vector ids = new Vector();
            int j = 0;
            while (j < aliases.size()) {
                CompartmentAlias alias;
                Compartment compartment;
                if (!(aliases.elementAt(j) instanceof CompartmentAlias) || (compartment = (alias = (CompartmentAlias)aliases.elementAt(j)).getOriginalCompartment()) == null) {
                    // empty if block
                }
                ++j;
            }
            this.isSelectingDlgByMe = false;
        }

        private void clearHighlightDialog() {
            this.pnl.clearSelectElement();
        }

        @Override
        public void elementMousePressed(SBase sb) {
            if (MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure() != SBModelHighlighter.this.gStructure) {
                return;
            }
            Compartment c = (Compartment)sb;
            this.setChanged();
            this.notifyObservers(new ObservableAspect(4, c));
            this.clearChanged();
            SBModelHighlighter.this.notifyComponentSelectionChanged();
        }
    }

    private class ParameterHighlighter
    extends Observable
    implements SBaseListPanelListener {
        private SBaseListPanel pnl;

        private ParameterHighlighter(SBaseListPanel pnl, KineticLawDialog kld) {
            this.pnl = pnl;
            this.addObserver(kld.getMathEditPanel());
            pnl.addSBaseListPanelListener(this);
        }

        private ParameterHighlighter(SBaseListPanel pnl, Vector mathEditors) {
            this.pnl = pnl;
            int i = 0;
            while (i < mathEditors.size()) {
                MathEditor me = (MathEditor)mathEditors.elementAt(i);
                this.addObserver(me.getMathEditPanel());
                ++i;
            }
            pnl.addSBaseListPanelListener(this);
        }

        private void dispose() {
            this.pnl.removeSBaseListPanelListener(this);
            this.deleteObservers();
            this.pnl = null;
        }

        @Override
        public void elementAdded(SBase sbase) {
        }

        @Override
        public void elementUpdated(SBase sbase, String[] oldValues) {
        }

        @Override
        public void elementsRemoved(SBase[] sbases, int[] index) {
        }

        @Override
        public void elementsSelected(SBase[] sbases) {
        }

        @Override
        public void elementsDeselected() {
            this.setChanged();
            this.notifyObservers(new ObservableAspect(9));
            this.clearChanged();
        }

        @Override
        public void elementsDeselectedByList() {
            this.setChanged();
            this.notifyObservers(new ObservableAspect(9));
            this.clearChanged();
        }

        @Override
        public void elementMousePressed(SBase sb) {
            if (MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure() != SBModelHighlighter.this.gStructure) {
                return;
            }
            Parameter p = (Parameter)sb;
            this.setChanged();
            this.notifyObservers(new ObservableAspect(2, p));
            this.clearChanged();
        }
    }

    private class ReactionHighlighter
    extends Observable
    implements SBaseListPanelListener {
        SBaseListPanel pnl;
        private boolean isSelectingDlgByMe = false;

        private ReactionHighlighter(SBaseListPanel pnl) {
            this.pnl = pnl;
            pnl.addSBaseListPanelListener(this);
        }

        private void dispose() {
            this.pnl.removeSBaseListPanelListener(this);
            this.pnl = null;
        }

        @Override
        public void elementAdded(SBase sbase) {
        }

        @Override
        public void elementUpdated(SBase sbase, String[] oldValues) {
        }

        @Override
        public void elementsRemoved(SBase[] sbases, int[] index) {
        }

        @Override
        public void elementsDeselected() {
            this.setChanged();
            this.notifyObservers(new ObservableAspect(9));
            this.clearChanged();
            SBModelHighlighter.this.notifyComponentSelectionChanged();
        }

        @Override
        public void elementsDeselectedByList() {
            SBModelHighlighter.this.gStructure.deselectAll();
            this.setChanged();
            this.notifyObservers(new ObservableAspect(9));
            this.clearChanged();
            SBModelHighlighter.this.notifyComponentSelectionChanged();
        }

        @Override
        public void elementsSelected(SBase[] sbases) {
            if (MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure() != SBModelHighlighter.this.gStructure) {
                return;
            }
            try {
                MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure();
            }
            catch (Exception myErr) {
                return;
            }
            SBModelFrame sbmdfrm = MainWindow.getLastInstance().getCurrentModel();
            SBModel sbmd = sbmdfrm.getSBModel();
            GStructure gstru = sbmd.getGStructure();
            if (!SBModelHighlighter.this.isSameGStructure(gstru)) {
                return;
            }
            if (!this.isSelectingDlgByMe) {
                boolean deselectflg = true;
                int i = 0;
                while (i < sbases.length) {
                    Reaction r = (Reaction)sbases[i];
                    this.higlightLink(r, deselectflg);
                    deselectflg = false;
                    ++i;
                }
            }
            SBModelHighlighter.this.notifyComponentSelectionChanged();
        }

        private void higlightLink(Reaction reaction, boolean deselectflg) {
            SBModelHighlighter.this.isSelectingStructureByMe = true;
            Vector links = SBModelHighlighter.this.gStructure.getLinks();
            int i = 0;
            while (i < links.size()) {
                ReactionLink link = (ReactionLink)links.elementAt(i);
                Reaction r = link.getParentReaction();
                if (r != null && reaction.getId().equals(r.getId())) {
                    SBModelHighlighter.this.sbframe.scrollToShow(link, deselectflg);
                    break;
                }
                ++i;
            }
            SBModelHighlighter.this.isSelectingStructureByMe = false;
        }

        private void highlightDialog(ReactionLink link) {
            this.isSelectingDlgByMe = true;
            Reaction reaction = link.getParentReaction();
            if (reaction == null) {
                return;
            }
            ListOfReactions list = SBModelHighlighter.this.model.getListOfReactions();
            int index = -1;
            int k = 0;
            while ((long)k < list.size()) {
                Reaction r = (Reaction)list.get((long)k);
                if (reaction.getId().equals(r.getId())) {
                    index = k;
                    break;
                }
                ++k;
            }
            if (index != -1) {
                this.pnl.setFromCanvasEvent(true);
                this.pnl.setFromTreeEvent(false);
                this.pnl.selectElement(new int[]{index});
            }
            this.isSelectingDlgByMe = false;
        }

        private void highlightsDialog(Vector link) {
            this.isSelectingDlgByMe = true;
            Vector ids = new Vector();
            Vector<Integer> indexs = new Vector<Integer>();
            ListOfReactions list = SBModelHighlighter.this.model.getListOfReactions();
            int idbg = link.size();
            int i = 0;
            while (i < link.size()) {
                ReactionLink alias;
                Reaction reaction;
                Object obj = link.get(i);
                if (obj instanceof ReactionLink && (reaction = (alias = (ReactionLink)obj).getParentReaction()) != null) {
                    Integer val;
                    int index = -1;
                    int k = 0;
                    while ((long)k < list.size()) {
                        Reaction r = (Reaction)list.get((long)k);
                        if (reaction.getId().equals(r.getId())) {
                            index = k;
                            break;
                        }
                        ++k;
                    }
                    if (index != -1 && !indexs.contains(val = new Integer(index))) {
                        indexs.add(val);
                    }
                }
                ++i;
            }
            if (indexs.size() > 0 && this.pnl != null) {
                int[] idarray = new int[indexs.size()];
                int i2 = 0;
                while (i2 < indexs.size()) {
                    Integer id = (Integer)indexs.get(i2);
                    idarray[i2] = id;
                    ++i2;
                }
                this.pnl.setFromCanvasEvent(true);
                this.pnl.setFromTreeEvent(false);
                this.pnl.selectElement(idarray);
            }
            this.isSelectingDlgByMe = false;
        }

        private void clearHighlightDialog() {
            this.pnl.clearSelectElement();
        }

        @Override
        public void elementMousePressed(SBase sb) {
            if (MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure() != SBModelHighlighter.this.gStructure) {
                return;
            }
            SBModelHighlighter.this.notifyComponentSelectionChanged();
        }
    }

    private class SpeciesHighlighter
    extends Observable
    implements SBaseListPanelListener {
        SBaseListPanel pnl;
        SBaseListPanel pnl2;
        private boolean isSelectingDlgByMe = false;

        private SpeciesHighlighter(SBaseListPanel pnl, SBaseListPanel pnl2, Vector mathEditors) {
            this.pnl = pnl;
            this.pnl2 = pnl2;
            int i = 0;
            while (i < mathEditors.size()) {
                MathEditor me = (MathEditor)mathEditors.elementAt(i);
                this.addObserver(me.getMathEditPanel());
                ++i;
            }
            pnl.addSBaseListPanelListener(this);
            pnl2.addSBaseListPanelListener(this);
        }

        private void dispose() {
            this.pnl.removeSBaseListPanelListener(this);
            this.deleteObservers();
            this.pnl = null;
            this.pnl2.removeSBaseListPanelListener(this);
            this.deleteObservers();
            this.pnl2 = null;
        }

        @Override
        public void elementAdded(SBase sbase) {
        }

        @Override
        public void elementUpdated(SBase sbase, String[] oldValues) {
        }

        @Override
        public void elementsRemoved(SBase[] sbases, int[] index) {
        }

        @Override
        public void elementsDeselected() {
            this.setChanged();
            this.notifyObservers(new ObservableAspect(9));
            this.clearChanged();
            SBModelHighlighter.this.notifyComponentSelectionChanged();
        }

        @Override
        public void elementsDeselectedByList() {
            SBModelHighlighter.this.gStructure.deselectAll();
            this.setChanged();
            this.notifyObservers(new ObservableAspect(9));
            this.clearChanged();
            SBModelHighlighter.this.notifyComponentSelectionChanged();
        }

        @Override
        public void elementsSelected(SBase[] sbases) {
            if (MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure() != SBModelHighlighter.this.gStructure) {
                return;
            }
            if (!this.isSelectingDlgByMe) {
                Rectangle2D.Double rect = null;
                boolean deselectflg = true;
                int i = 0;
                while (i < sbases.length) {
                    Species s = (Species)sbases[i];
                    rect = GUtil.union(this.higlightAliases(s, deselectflg), rect);
                    deselectflg = false;
                    ++i;
                }
                SBModelHighlighter.this.isSelectingStructureByMe = true;
                rect = GUtil.union(SBModelHighlighter.this.gStructure.highlightChainedLinks(), rect);
                SBModelHighlighter.this.gStructure.notifyChangeSelected();
                SBModelHighlighter.this.sbframe.needsRepaint(rect);
                SBModelHighlighter.this.isSelectingStructureByMe = false;
            }
            if (!MainWindow.isFocusedKineticLaw()) {
                Species s = (Species)sbases[sbases.length - 1];
                this.setChanged();
                this.notifyObservers(new ObservableAspect(1, s));
                this.clearChanged();
            }
            SBModelHighlighter.this.notifyComponentSelectionChanged();
        }

        private Rectangle2D higlightAliases(Species species, boolean deselectflg) {
            SBModelHighlighter.this.isSelectingStructureByMe = true;
            if (deselectflg) {
                SBModelHighlighter.this.gStructure.deselectAll();
            }
            Rectangle2D.Double rect = null;
            Vector aliases = ((SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null)).getReferingAliases();
            int i = 0;
            while (i < aliases.size()) {
                SpeciesAlias alias = (SpeciesAlias)aliases.elementAt(i);
                rect = GUtil.union(SBModelHighlighter.this.gStructure.select(alias, false, false, false), rect);
                ++i;
            }
            SBModelHighlighter.this.isSelectingStructureByMe = false;
            return rect;
        }

        private void highlightDialog(SpeciesAlias alias) {
            this.isSelectingDlgByMe = true;
            Species species = alias.getOriginalSpecies();
            if (species == null) {
                return;
            }
            ArrayList list = LibSBMLUtil.getListOfIndependentSpecies((ListOf)SBModelHighlighter.this.model.getListOfSpecies());
            int index = -1;
            int k = 0;
            while (k < list.size()) {
                Species sp = (Species)list.get(k);
                if (sp.getId().equals(species.getId())) {
                    index = k;
                    break;
                }
                ++k;
            }
            if (index != -1 && this.pnl != null) {
                this.pnl.setFromTreeEvent(false);
                this.pnl.selectElement(new int[]{index});
            }
            SBModelHighlighter.this.proteinListPanel.selectElement(SBModelHighlighter.this.sbframe.getSelectedProteinEtcVector("Protein"));
            SBModelHighlighter.this.geneListPanel.selectElement(SBModelHighlighter.this.sbframe.getSelectedProteinEtcVector("Gene"));
            SBModelHighlighter.this.rnaListPanel.selectElement(SBModelHighlighter.this.sbframe.getSelectedProteinEtcVector("RNA"));
            SBModelHighlighter.this.antisensernaListPanel.selectElement(SBModelHighlighter.this.sbframe.getSelectedProteinEtcVector("AntiSenseRNA"));
            this.isSelectingDlgByMe = false;
        }

        private void highlightsDialog(Vector aliases) {
            this.isSelectingDlgByMe = true;
            Vector<Integer> indexs = new Vector<Integer>();
            ArrayList list = new ArrayList();
            if (this.pnl instanceof SpeciesListPanel) {
                list = ((SpeciesListPanel)this.pnl).getDisplayList();
            }
            int i = 0;
            while (i < aliases.size()) {
                SpeciesAlias alias;
                Species species;
                Object obj = aliases.get(i);
                if (obj instanceof SpeciesAlias && (species = (alias = (SpeciesAlias)obj).getOriginalSpecies()) != null) {
                    Integer val;
                    int index = -1;
                    int k = 0;
                    while (k < list.size()) {
                        Species sp = (Species)list.get(k);
                        if (sp.getId().equals(species.getId())) {
                            index = k;
                            break;
                        }
                        ++k;
                    }
                    if (index != -1 && !indexs.contains(val = new Integer(index))) {
                        indexs.add(val);
                    }
                }
                ++i;
            }
            if (!indexs.isEmpty() && this.pnl != null) {
                int[] idarray = new int[indexs.size()];
                int i2 = 0;
                while (i2 < indexs.size()) {
                    Integer id = (Integer)indexs.get(i2);
                    idarray[i2] = id;
                    ++i2;
                }
                this.pnl.setFromTreeEvent(false);
                this.pnl.selectElement(idarray);
            }
            SBModelHighlighter.this.proteinListPanel.selectElement(SBModelHighlighter.this.sbframe.getSelectedProteinEtcVector("Protein"));
            SBModelHighlighter.this.geneListPanel.selectElement(SBModelHighlighter.this.sbframe.getSelectedProteinEtcVector("Gene"));
            SBModelHighlighter.this.rnaListPanel.selectElement(SBModelHighlighter.this.sbframe.getSelectedProteinEtcVector("RNA"));
            SBModelHighlighter.this.antisensernaListPanel.selectElement(SBModelHighlighter.this.sbframe.getSelectedProteinEtcVector("AntiSenseRNA"));
            this.isSelectingDlgByMe = false;
        }

        private void clearHighlightDialog() {
            this.pnl.clearSelectElement();
        }

        @Override
        public void elementMousePressed(SBase sb) {
            if (!(sb instanceof Species)) {
                return;
            }
            if (MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure() != SBModelHighlighter.this.gStructure) {
                return;
            }
            Species s = (Species)sb;
            this.setChanged();
            this.notifyObservers(new ObservableAspect(1, s));
            this.clearChanged();
            SBModelHighlighter.this.notifyComponentSelectionChanged();
        }

        public void reNotifyObservers(ObservableAspect obsv) {
            if (obsv == null) {
                return;
            }
            this.setChanged();
            this.notifyObservers(obsv);
            this.clearChanged();
        }
    }
}

