/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jp.co.mki.celldesigner.simulation.controlpanel.ControlPanelMainWindow;
import jp.fric.graphics.draw.GCreasePoint;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GGroup;
import jp.fric.graphics.draw.GGroupTarget;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GMouseInterpreter;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GStructureEditor;
import jp.fric.graphics.draw.GStructurePainter;
import jp.fric.graphics.draw.GStructureReporter;
import jp.fric.graphics.draw.event.GEvent;
import jp.fric.graphics.multiwindow.StatusBar;
import jp.fric.graphics.multiwindow.ZoomFrame;
import jp.fric.io.util.FilePather;
import jp.fric.ui.DocumentDialog;
import jp.fric.util.Debug;
import jp.fric.util.StopWatch;
import jp.fric.util.WeakReferenceMonitor;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.CompartmentAliasDialog;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.FindSpecieDialog;
import jp.sbi.celldesigner.InformationBoxDialog;
import jp.sbi.celldesigner.LinkedCreaseLine;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MainWindowAccess;
import jp.sbi.celldesigner.ModelDescriptionFrm;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesPropertyDialog;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.PagePrinter;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.ReactionLinkDialog;
import jp.sbi.celldesigner.SBEventRecorder;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SBSymbolEditDialog;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.SpeciesShape;
import jp.sbi.celldesigner.layer.LayerManager;
import jp.sbi.celldesigner.layer.swing.LayerTagNameInputDialog;
import jp.sbi.celldesigner.layer.swing.LayerTextInputDialog;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerClosedCompartmentAlias;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerCompartmentAlias;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionLink;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerTagFreeLineSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerMonoSpeciesShape;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesAlias;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerTagSymbol;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNA;
import jp.sbi.celldesigner.sbmlExtension.Gene;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.celldesigner.sbmlExtension.Notes;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.RNA;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.celldesigner.symbol.reaction.DirectSingleLine;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.celldesigner.symbol.species.ComplexBrief;
import jp.sbi.celldesigner.util.CelldUtil;
import jp.sbi.sbml.autoLayout.y.CircularLayoutModule;
import jp.sbi.sbml.autoLayout.y.HierarchicLayoutModule;
import jp.sbi.sbml.autoLayout.y.IncrementalHierarchicLayoutModule;
import jp.sbi.sbml.autoLayout.y.OrganicEdgeRouterModule;
import jp.sbi.sbml.autoLayout.y.OrganicLayoutModule;
import jp.sbi.sbml.autoLayout.y.OrthogonalEdgeRouterModule;
import jp.sbi.sbml.autoLayout.y.OrthogonalLayoutModule;
import jp.sbi.sbml.autoLayout.y.TreeLayoutModule;
import jp.sbi.sbml.autoLayout.y.YAutoLayout;
import jp.sbi.sbml.autoLayout.y.option.CircularLayoutDialog;
import jp.sbi.sbml.autoLayout.y.option.ClassicOrganicLayoutDialog;
import jp.sbi.sbml.autoLayout.y.option.HierarchicLayoutDialog;
import jp.sbi.sbml.autoLayout.y.option.IncrementalHierarchicLayoutDialog;
import jp.sbi.sbml.autoLayout.y.option.OptionHandler;
import jp.sbi.sbml.autoLayout.y.option.OrganicEdgeRouterDialog;
import jp.sbi.sbml.autoLayout.y.option.OrthogonalEdgeRouterDialog;
import jp.sbi.sbml.autoLayout.y.option.OrthogonalLayoutDialog;
import jp.sbi.sbml.autoLayout.y.option.SmartOrganicLayoutDialog;
import jp.sbi.sbml.autoLayout.y.option.TreeLayoutDialog;
import jp.sbi.sbml.autoLayout.y.option.YDialog;
import jp.sbi.sbml.autoLayout.y.runtime.IProgressMonitor;
import jp.sbi.sbml.autoLayout.y.runtime.IRunnableWithProgress;
import jp.sbi.sbml.autoLayout.y.runtime.LayoutProgressMonitor;
import jp.sbi.sbml.autoLayout.y.runtime.LayoutTask;
import jp.sbi.sbml.autoLayout.y.runtime.ProgressMonitorDialog;
import jp.sbi.sbml.util.ConstraintDialog;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.NotesDialog;
import jp.sbi.sbml.util.ResourceOfDescriptionOfReactionDialog;
import jp.sbi.sbml.util.SBMLPanelLists;
import jp.sbi.sbml.util.SBaseListPanel;
import jp.sbi.sbml.util.SpeciesListPanel;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.AlgebraicRule;
import org.sbml.libsbml.AssignmentRule;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.CompartmentType;
import org.sbml.libsbml.Constraint;
import org.sbml.libsbml.Event;
import org.sbml.libsbml.FunctionDefinition;
import org.sbml.libsbml.InitialAssignment;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.RateRule;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.Rule;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesType;
import org.sbml.libsbml.UnitDefinition;
import org.sbml.libsbml.libsbml;
import org.w3c.dom.DOMImplementation;

public class SBModelFrame
extends ZoomFrame
implements KeyListener,
GStructurePainter {
    private JFrame ownerframe = null;
    private SBModel sbmodel;
    private GStructureEditor editor;
    private MonoSpeciesPropertyDialog monoPropertyDialog;
    private MonoSpeciesPropertyDialog monoPropertyDialogForComplex;
    private CompartmentAliasDialog caDlg;
    private InformationBoxDialog csDlg;
    private ReactionLinkDialog rlDlg;
    private FindSpecieDialog findDialog;
    private NotesDialog modelNotesDialog;
    private NotesDialog notesDialog;
    private NotesDialog proteinNotesDialog;
    private SBSymbolEditDialog symbolShapeDialog;
    private MonoSpeciesPropertyDialog tagPropertyDialog;
    private ResourceOfDescriptionOfReactionDialog descriptionDlg;
    private ModelDescriptionFrm modeldescriptionFrm;
    private boolean isGridShowing = false;
    private boolean isGridSnaped = false;
    private GMouseInterpreter mouseInterpreter = null;
    public static final Color GRID_COLOR = new Color(0x66999999, true);
    private boolean isWindowDeactivatedIgnored = false;
    private GStructureReporter reporter;
    boolean expandmodeh = false;
    boolean expandmodev = false;
    boolean initmodeflg = false;
    int original_mode;
    boolean temporal_mode = false;
    public static final int NONE_SELECTED = 0;
    public static final int SINGLE_COMPARTMENT_SELECTED = 1;
    public static final int SINGLE_SPECIES_SELECTED = 2;
    public static final int REACTION_SELECTED = 3;
    public static final int SINGLE_PARAMETER_SELECTED = 4;
    public static final int SINGLE_FUNCTIONDEFINITION_SELECTED = 5;
    public static final int SINGLE_UNIT_SELECTED = 6;
    public static final int SINGLE_RULE_SELECTED = 7;
    public static final int SINGLE_EVENT_SELECTED = 8;
    public static final int SINGLE_SPECIES_TYPE_SELECTED = 9;
    public static final int SINGLE_COMPARTMENT_TYPE_SELECTED = 10;
    public static final int SINGLE_INITIAL_ASSIGNMENT_SELECTED = 11;
    public static final int SINGLE_CONSTRAINT_SELECTED = 12;
    public static final int MULTIPLE_COMPARTMENT_SELECTED = 101;
    public static final int MULTIPLE_SPECIES_SELECTED = 102;
    public static final int MULTIPLE_REACTIONS_SELECTED = 103;
    public static final int MULTIPLE_PARAMETER_SELECTED = 104;
    public static final int MULTIPLE_FUNCTIONDEFINITION_SELECTED = 105;
    public static final int MULTIPLE_UNIT_SELECTED = 106;
    public static final int MULTIPLE_RULE_SELECTED = 107;
    public static final int MULTIPLE_EVENT_SELECTED = 108;
    public static final int MULTIPLE_SPECIES_TYPE_SELECTED = 109;
    public static final int MULTIPLE_COMPARTMENT_TYPE_SELECTED = 110;
    public static final int MULTIPLE_INITIAL_ASSIGNMENT_SELECTED = 111;
    public static final int MULTIPLE_CONSTRAINT_SELECTED = 112;
    public static final int MULTIPLE_SPECIES_BUT_SINGLE_PROTEIN_SELECTED = 201;
    public static final int MULTIPLE_SPECIES_BUT_SINGLE_GENE_SELECTED = 202;
    public static final int MULTIPLE_SPECIES_BUT_SINGLE_RNA_SELECTED = 203;
    public static final int MULTIPLE_SPECIES_BUT_SINGLE_ASRNA_SELECTED = 204;
    public static final int MULTIPLE_SELECTED = 999;
    private static final String ModelNotesTiltle = "Model Notes";
    private static final String ModelDescriptionFrmTiltle = "Model Description";
    private static final String CompartmentNotesTitle = "Compartment Notes";
    private static final String SpeciesNotesTitle = "Species Notes";
    private static final String ReactionNotesTilte = "Reaction Notes";
    private static final String ProteinNotesTitle = "Protein Notes";
    private static final String GeneNotesTitle = "Gene Notes";
    private static final String RNANotesTitle = "RNA Notes";
    private static final String asRNANotesTitle = "asRNA Notes";
    private static final String ParameterNotesTitle = "Parameter Notes";
    private static final String FunctionDefinitionNotesTitle = "Function Notes";
    private static final String UnitNotesTitle = "UnitDefinition Notes";
    private static final String RuleNotesTitle = "Rule Notes";
    private static final String EventNotesTitle = "Event Notes";
    private static final String SpeciesTypeNotesTitle = "SpeciesType Notes";
    private static final String CompartmentTypeNotesTitle = "CompartmentType Notes";
    private static final String InitialAssignmentNotesTitle = "InitialAssignment Notes";
    private static final String ConstraintNotesTitle = "Constraint Notes";
    private String strOutputPicFileDirName;
    private String strOutputPicFileName;
    private String strOutputPicFileExtention;
    private int uiType = 1;
    private Vector sbModelFrameDialogList = new Vector();
    private SBase selectedsbase = null;
    protected static final int NONE = 0;
    protected static final int CREATE_GROUP = 1;
    protected static final int RELEASE_GROUP = 2;
    boolean isAltPressed = false;
    boolean isShiftPressed = false;
    private Vector controlPanelList = new Vector();
    public static final int compartmentAliasSelected = 0;
    public static final int speciesAliasSelected = 1;

    public SBModelFrame(JFrame ownerframe, Dimension size, SBModel sbmodel) {
        super(size.width, size.height);
        this.sbmodel = sbmodel;
        this.ownerframe = ownerframe;
        this.findDialog = new FindSpecieDialog(this, "Find Species");
        this.monoPropertyDialog = new MonoSpeciesPropertyDialog(ownerframe, sbmodel, "Change identity of the species", true);
        this.tagPropertyDialog = new MonoSpeciesPropertyDialog(ownerframe, sbmodel, "Change identity of the species", true);
        this.monoPropertyDialogForComplex = new MonoSpeciesPropertyDialog(ownerframe, sbmodel, "Change identity of the complex", false);
        this.caDlg = new CompartmentAliasDialog(ownerframe, sbmodel, "Change identity of the compartment");
        this.csDlg = new InformationBoxDialog(ownerframe, sbmodel, "Edit Information");
        this.rlDlg = new ReactionLinkDialog(this, sbmodel, "Change properties of the reaction");
        this.descriptionDlg = new ResourceOfDescriptionOfReactionDialog(ownerframe, sbmodel, "Change description of the reaction");
        this.modelNotesDialog = new NotesDialog((Frame)this.getMyFrame(), ModelNotesTiltle);
        this.modeldescriptionFrm = new ModelDescriptionFrm((Frame)this.getMyFrame(), ModelDescriptionFrmTiltle);
        this.notesDialog = new NotesDialog((Frame)this.getMyFrame(), "Notes");
        this.proteinNotesDialog = new NotesDialog((Frame)this.getMyFrame(), ProteinNotesTitle);
        this.symbolShapeDialog = new SBSymbolEditDialog(ownerframe, sbmodel, "Change color and shape");
        this.setSBModelFrameDialogList();
        sbmodel.setSBModelFrame(this);
        GStructure gStructure = sbmodel.getGStructure();
        gStructure.addStructurePainter(this);
        this.reporter = new GStructureReporter(gStructure);
        this.reporter.setReportON(false);
        super.addKeyListener(this);
        super.setHandMoveEnabled(true);
        Debug.println("[SBModelFrame] constructed <" + super.toString() + ">");
        this.addAdjustmentListenerH(new MyAdjustmentListenerH());
        this.addAdjustmentListenerV(new MyAdjustmentListenerV());
        this.setStructure(gStructure);
    }

    public SBModelFrame(SBModel sbmodel) {
        super(0.0, 0.0);
        this.sbmodel = sbmodel;
        GStructure gStructure = sbmodel.getGStructure();
        gStructure.addStructurePainter(this);
        this.reporter = new GStructureReporter(gStructure);
        this.reporter.setReportON(false);
        Debug.println("[SBModelFrame] constructed <" + super.toString() + ">");
        this.setStructure(gStructure);
    }

    public int getSelectedNum() {
        return this.editor.getSelecteds().size();
    }

    protected void setGStructureEditor(GStructureEditor editor) {
        this.editor = editor;
    }

    @Override
    public void releaseAll() {
        Debug.println("[SBModelFrame] releaseAll() <" + super.toString() + ">");
        if (Preference.isDebug) {
            WeakReferenceMonitor.monitor(this);
            WeakReferenceMonitor.monitor(this.sbmodel);
        }
        this.ownerframe = null;
        this.mouseInterpreter = null;
        this.editor = null;
        super.removeKeyListener(this);
        this.sbmodel.getGStructure().removeStructurePainter(this);
        this.reporter.dispose();
        this.reporter = null;
        this.modelNotesDialog.dispose();
        this.modelNotesDialog.releaseAll();
        this.modelNotesDialog = null;
        this.modeldescriptionFrm.dispose();
        this.modeldescriptionFrm.releaseAll();
        this.modeldescriptionFrm = null;
        this.findDialog.dispose();
        this.findDialog.releaseFrame();
        this.findDialog = null;
        this.notesDialog.releaseAll();
        this.notesDialog.dispose();
        this.notesDialog = null;
        this.proteinNotesDialog.releaseAll();
        this.proteinNotesDialog.dispose();
        this.proteinNotesDialog = null;
        this.symbolShapeDialog.setPanel(null);
        this.symbolShapeDialog.dispose();
        this.symbolShapeDialog = null;
        this.monoPropertyDialog.releaseAll();
        this.monoPropertyDialog = null;
        this.tagPropertyDialog.releaseAll();
        this.tagPropertyDialog = null;
        this.monoPropertyDialogForComplex.releaseAll();
        this.monoPropertyDialogForComplex = null;
        this.caDlg.dispose();
        this.caDlg.releaseFrame();
        this.caDlg = null;
        this.csDlg.dispose();
        this.csDlg.releaseFrame();
        this.csDlg = null;
        this.rlDlg.dispose();
        this.rlDlg.releaseFrame();
        this.rlDlg = null;
        this.sbmodel.releaseAll();
        this.sbmodel = null;
        int i = 0;
        while (i < this.controlPanelList.size()) {
            ControlPanelMainWindow controlPanel = (ControlPanelMainWindow)this.controlPanelList.get(i);
            if (controlPanel != null) {
                controlPanel.dispose();
            }
            ++i;
        }
        this.controlPanelList.clear();
        super.releaseAll();
    }

    @Override
    protected void finalize() throws Throwable {
        Debug.println("[SBModelFrame] finalize() <" + super.toString() + ">");
        super.finalize();
    }

    public void resizeZoomFrame(Dimension size) {
        super.setLogicalSize(size.width, size.height);
    }

    @Override
    public void saveDone() {
        try {
            this.controlPanelList.clear();
            if (((MainWindow)this.ownerframe).getTargetControlPanelWindow() != null) {
                this.addToControlPanelList(((MainWindow)this.ownerframe).getTargetControlPanelWindow());
                ((MainWindow)this.ownerframe).getTargetControlPanelWindow().setChanged(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sbmodel.getRecorder().clearEvents();
        this.setHasAnySBaseChangedFlg(false);
        super.getStatusBar().setString1("document saved.");
    }

    @Override
    public void paintLogicalContents(Graphics2D g2) {
        Dimension d = this.sbmodel.getModelSize();
        if (g2 == null || d == null) {
            return;
        }
        g2.setColor(Color.white);
        g2.fillRect(0, 0, d.width, d.height);
        if (this.isGridShowing && this.mouseInterpreter != null) {
            this.mouseInterpreter.drawGrids(g2);
        }
        this.sbmodel.getGStructure().draw(g2);
        this.notifyLogicalContentsRepainted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintSymbol(Graphics2D g2, double ratioval) {
        Dimension d = this.sbmodel.getModelSize();
        if (g2 == null || d == null) {
            return;
        }
        SBModelFrame sBModelFrame = this;
        synchronized (sBModelFrame) {
            this.sbmodel.getGStructure().drawLoupeSymbol(g2, ratioval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintSymbol(Graphics2D g2, AffineTransform transform) {
        Dimension d = this.sbmodel.getModelSize();
        if (g2 == null || d == null) {
            return;
        }
        SBModelFrame sBModelFrame = this;
        synchronized (sBModelFrame) {
            this.sbmodel.getGStructure().drawLoupeSymbol(g2, transform);
        }
    }

    public void setInitModeFlg(boolean val) {
    }

    public double getZoomScale() {
        return this.transformer.getScalingVal();
    }

    public void notifyLogicalContentsRepainted() {
        ((MainWindowAccess)this.mainwindowaccess).logicalContentsRepainted(this);
    }

    public void setGMouseInterpreter(GMouseInterpreter mouseInterpreter) {
        this.mouseInterpreter = mouseInterpreter;
        this.scrollbarH.setUnitIncrement((int)mouseInterpreter.getGridHeight());
        this.scrollbarH.setBlockIncrement((int)mouseInterpreter.getGridHeight() * 10);
        this.scrollbarV.setUnitIncrement((int)mouseInterpreter.getGridWidth());
        this.scrollbarV.setBlockIncrement((int)mouseInterpreter.getGridWidth() * 10);
    }

    public void setGridShowing(boolean isShowing) {
        this.isGridShowing = isShowing;
    }

    public void setGridSnaped(boolean isSnaped) {
        this.isGridSnaped = isSnaped;
        if (this.isGridSnaped) {
            super.getStatusBar().setString2("Grid Snap ON");
        } else {
            super.getStatusBar().setString2("Grid Snap OFF");
        }
    }

    public boolean isGridShowing() {
        return this.isGridShowing;
    }

    public boolean isGridSnaped() {
        return this.isGridSnaped;
    }

    public void setWindowDeactivatedIgnored(boolean b) {
        this.isWindowDeactivatedIgnored = b;
    }

    public boolean isWindowDeactivatedIgnored() {
        return this.isWindowDeactivatedIgnored;
    }

    @Override
    public void needsRepaint(Rectangle2D bounds) {
        this.needsRepaint(bounds, true);
    }

    @Override
    public void needsRepaint(Rectangle2D bounds, boolean repaint) {
        if (bounds != null) {
            double x = Math.floor(bounds.getX());
            double y = Math.floor(bounds.getY());
            double w = Math.ceil(bounds.getX() + bounds.getWidth() - x);
            double h = Math.ceil(bounds.getY() + bounds.getHeight() - y);
            bounds.setRect(x - 5.0, y - 5.0, w + 10.0, h + 10.0);
            this.repaintLogicalArea(bounds, repaint);
        }
    }

    protected boolean isAbleToShowIdentityDialog() {
        if (this.editor.getSelecteds().size() != 1) {
            return false;
        }
        Object obj = this.editor.getSelecteds().elementAt(0);
        return !(obj instanceof GGroup);
    }

    public void showIdentityDialog() {
        Vector selecteds = this.editor.getSelecteds();
        if (selecteds.size() == 1) {
            Object selected = selecteds.elementAt(0);
            if (selected instanceof SpeciesAlias) {
                SpeciesShape shape = (SpeciesShape)((Object)((SpeciesAlias)selected).getGFramedShape());
                if (shape instanceof MonoSpeciesShape) {
                    SpeciesAlias spa = (SpeciesAlias)selected;
                    String name = spa.getName();
                    if (selected instanceof ElementSpeciesAlias) {
                        Object vTag;
                        boolean isSourceOfDirectSingleLine = this.sbmodel.getGStructure().isSourceOfDirectSingleLine((ElementSpeciesAlias)selected);
                        if (!isSourceOfDirectSingleLine) {
                            vTag = new Vector();
                            Species orgSpecies = ((ElementSpeciesAlias)selected).getOriginalSpecies();
                            Vector atoms = this.sbmodel.getGStructure().getAtoms();
                            int m = 0;
                            while (orgSpecies != null && m < atoms.size()) {
                                Species orgSpeciesTmp;
                                Object aObj = atoms.get(m);
                                if (aObj instanceof ElementSpeciesAlias && (orgSpeciesTmp = ((ElementSpeciesAlias)aObj).getOriginalSpecies()) != null && orgSpeciesTmp.getId().equals(orgSpecies.getId()) && !((Vector)vTag).contains(aObj)) {
                                    ((Vector)vTag).add(aObj);
                                }
                                ++m;
                            }
                            int n = 0;
                            while (n < ((Vector)vTag).size()) {
                                try {
                                    this.sbmodel.getGStructure().isSourceOfDirectSingleLine((ElementSpeciesAlias)((Vector)vTag).get(n));
                                }
                                catch (Exception myErr) {
                                    return;
                                }
                                ++n;
                            }
                        }
                        this.sbmodel.showSpeciesPropertyDialog(this.monoPropertyDialog);
                        vTag = this.monoPropertyDialog.getNewName();
                    } else if (selected instanceof ComplexSpeciesAlias) {
                        this.sbmodel.showSpeciesPropertyDialog(this.monoPropertyDialogForComplex);
                        String isSourceOfDirectSingleLine = this.monoPropertyDialogForComplex.getNewName();
                    }
                    this.sbmodel.getGStructure().deselectAll();
                } else {
                    JOptionPane.showMessageDialog(this, "Heterodimer has no property to change.", "No property", 2);
                }
                return;
            }
            if (selected instanceof CompartmentAlias) {
                this.caDlg.showAliasProperty((CompartmentAlias)selected);
                this.sbmodel.getGStructure().deselectAll();
                return;
            }
            if (selected instanceof ReactionLink) {
                GLinkedShape lnkshp = ((ReactionLink)selected).getGLinkedShape();
                if (lnkshp instanceof DirectSingleLine) {
                    return;
                }
                this.rlDlg.showLinkProperty((ReactionLink)selected);
                this.sbmodel.getGStructure().deselectAll();
                return;
            }
            if (selected instanceof LayerSpeciesAlias) {
                LayerSpeciesAlias s = (LayerSpeciesAlias)selected;
                boolean isTagLayer = false;
                try {
                    if (((LayerSpeciesAlias)selected).getBelong_layer_id() == -99) {
                        isTagLayer = true;
                    }
                }
                catch (Exception e) {
                    return;
                }
                if (isTagLayer) {
                    boolean isChangedText;
                    String strLayername = ((LayerSpeciesAlias)selected).getText();
                    LayerTagNameInputDialog dialog = new LayerTagNameInputDialog(strLayername);
                    dialog.setVisible(true);
                    if (dialog.isCanceled()) {
                        return;
                    }
                    boolean bl = isChangedText = !strLayername.equals(dialog.getText());
                    if (isChangedText) {
                        this.sbmodel.changeTagText(s, dialog.getText());
                    }
                    return;
                }
                LayerTextInputDialog dialog = new LayerTextInputDialog(s);
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    return;
                }
                s.setText(dialog.getText());
                s.update();
                s.getGFramedShape().updateShape(s.getFrameBounds().x, s.getFrameBounds().y, s.getFrameBounds().width, s.getFrameBounds().height);
                this.repaintLogicalArea(s.getRepaintBounds());
            }
        }
    }

    public void editIdentityDialog(String tname) {
        Vector selecteds = this.editor.getSelecteds();
        if (selecteds.size() > 0) {
            Object selected = selecteds.elementAt(0);
            if (selected instanceof CompartmentAlias) {
                this.caDlg.setAliasProperty((CompartmentAlias)selected, tname);
            } else if (selected instanceof ReactionLink) {
                this.rlDlg.setLinkProperty((ReactionLink)selected, tname);
            }
        }
    }

    public Object getSelectedObject() {
        Vector selecteds = this.editor.getSelecteds();
        if (selecteds.size() > 0) {
            Object selected = selecteds.elementAt(0);
            if (selected instanceof SpeciesAlias) {
                SpeciesShape shape = (SpeciesShape)((Object)((SpeciesAlias)selected).getGFramedShape());
                if (shape instanceof MonoSpeciesShape) {
                    return selected;
                }
                return selected;
            }
            if (selected instanceof CompartmentAlias) {
                return selected;
            }
            if (selected instanceof ReactionLink) {
                return selected;
            }
        }
        return null;
    }

    public void showFindDialog() {
        if (!this.findDialog.isVisible()) {
            this.findDialog.resetMatched();
            this.findDialog.setVisible(true);
        }
    }

    public Dimension getModelSize() {
        return this.sbmodel.getModelSize();
    }

    public void showModelDialog() {
        DocumentDialog dlg = new DocumentDialog();
        dlg.setDialogTitle("SBML Model Information");
        dlg.setDocumentName(this.sbmodel.getModelName());
        dlg.setDocumentSize(this.sbmodel.getModelSize());
        int rtn = dlg.showDialog(MainWindow.getLastInstance());
        if (rtn == 1) {
            this.sbmodel.changeModelInformation(dlg.getDocumentName(), dlg.getDocumentSize());
        }
    }

    public void showModelNotesDialog() {
        Model model = this.sbmodel.getModel();
        Notes notes = (Notes)LibSBMLUtil.getNotes((SBase)model, null);
        this.modelNotesDialog.setTitle("Model Notes (id=" + model.getId() + "; " + this.getFilename() + ")");
        this.modelNotesDialog.setEditingNotes(notes);
        this.modelNotesDialog.setTarget((SBase)model);
        this.modelNotesDialog.showDialog();
    }

    public void showNotesDialog() {
        Vector selected = this.editor.getSelecteds();
        String title = null;
        Notes notes = null;
        SBase target = null;
        if (this.selectedsbase != null) {
            if (this.selectedsbase instanceof Parameter) {
                notes = (Notes)LibSBMLUtil.getNotes(this.selectedsbase, null);
                title = "Parameter Notes (id=" + this.selectedsbase.getId() + "; " + this.getFilename() + ")";
            } else if (this.selectedsbase instanceof FunctionDefinition) {
                notes = (Notes)LibSBMLUtil.getNotes(this.selectedsbase, null);
                title = "Function Notes (id=" + this.selectedsbase.getId() + "; " + this.getFilename() + ")";
            } else if (this.selectedsbase instanceof UnitDefinition) {
                notes = (Notes)LibSBMLUtil.getNotes(this.selectedsbase, null);
                title = "UnitDefinition Notes (id=" + this.selectedsbase.getId() + "; " + this.getFilename() + ")";
            } else if (this.selectedsbase instanceof Rule) {
                notes = (Notes)LibSBMLUtil.getNotes(this.selectedsbase, null);
                Rule rRule = (Rule)this.selectedsbase;
                title = "Rule Notes (math=" + rRule.getFormula() + "; " + this.getFilename() + ")";
            } else if (this.selectedsbase instanceof Event) {
                notes = (Notes)LibSBMLUtil.getNotes(this.selectedsbase, null);
                title = "Event Notes (id=" + this.selectedsbase.getId() + "; " + this.getFilename() + ")";
            } else if (this.selectedsbase instanceof SpeciesType) {
                notes = (Notes)LibSBMLUtil.getNotes(this.selectedsbase, null);
                title = "SpeciesType Notes (id=" + this.selectedsbase.getId() + "; " + this.getFilename() + ")";
            } else if (this.selectedsbase instanceof CompartmentType) {
                notes = (Notes)LibSBMLUtil.getNotes(this.selectedsbase, null);
                title = "CompartmentType Notes (id=" + this.selectedsbase.getId() + "; " + this.getFilename() + ")";
            } else if (this.selectedsbase instanceof InitialAssignment) {
                notes = (Notes)LibSBMLUtil.getNotes(this.selectedsbase, null);
                InitialAssignment initialAssignment = (InitialAssignment)this.selectedsbase;
                title = "InitialAssignment Notes (symbol=" + initialAssignment.getSymbol() + "; " + this.getFilename() + ")";
            } else if (this.selectedsbase instanceof Constraint) {
                notes = (Notes)LibSBMLUtil.getNotes(this.selectedsbase, null);
                Constraint constraint = (Constraint)this.selectedsbase;
                ASTNode math = constraint.getMath();
                String strMath = "";
                if (math != null) {
                    strMath = libsbml.formulaToString((ASTNode)math);
                }
                title = "Constraint Notes (math=" + strMath + "; " + this.getFilename() + ")";
            } else {
                return;
            }
            target = this.selectedsbase;
            SBase[] sbases = new SBase[]{this.selectedsbase};
            this.sbmodel.setPanelSelectedSbase(sbases);
            this.notesDialog.setTitle(title);
            if (notes != null) {
                this.notesDialog.setEditingNotes(notes);
            } else {
                Notes notes1 = new Notes();
                notes1.setText("");
                this.notesDialog.setEditingNotes(notes1);
            }
            if (target != null) {
                this.notesDialog.setTarget(target);
            }
            this.notesDialog.showDialog();
            return;
        }
        if (selected == null || selected.size() == 0) {
            return;
        }
        Object obj = selected.elementAt(0);
        if (obj instanceof SpeciesAlias) {
            Species species = ((SpeciesAlias)obj).getOriginalSpecies();
            int i = 1;
            while (i < selected.size()) {
                Object obj2 = selected.elementAt(i);
                if (obj2 instanceof SpeciesAlias) {
                    Species species2 = ((SpeciesAlias)obj2).getOriginalSpecies();
                    if (species != species2) {
                        return;
                    }
                } else {
                    return;
                }
                ++i;
            }
            notes = (Notes)LibSBMLUtil.getNotes((SBase)species, null);
            title = "Species Notes (id=" + species.getId() + "; " + this.getFilename() + ")";
            target = species;
        } else if (obj instanceof CompartmentAlias) {
            Compartment compartment = ((CompartmentAlias)obj).getOriginalCompartment();
            int i = 1;
            while (i < selected.size()) {
                Object obj2 = selected.elementAt(i);
                if (obj2 instanceof CompartmentAlias) {
                    Compartment compartment2 = ((CompartmentAlias)obj2).getOriginalCompartment();
                    if (compartment != compartment2) {
                        return;
                    }
                } else {
                    return;
                }
                ++i;
            }
            notes = (Notes)LibSBMLUtil.getNotes((SBase)compartment, null);
            title = "Compartment Notes (id=" + compartment.getId() + "; " + this.getFilename() + ")";
            target = compartment;
        } else if (obj instanceof ReactionLink) {
            if (selected.size() == 1) {
                Reaction reaction = ((ReactionLink)obj).getParentReaction();
                notes = (Notes)LibSBMLUtil.getNotes((SBase)reaction, null);
                title = "Reaction Notes (id=" + reaction.getId() + "; " + this.getFilename() + ")";
                target = reaction;
            } else {
                return;
            }
        }
        if (notes != null) {
            this.notesDialog.setTitle(title);
            this.notesDialog.setEditingNotes(notes);
        }
        if (target != null) {
            this.notesDialog.setTarget(target);
        }
        this.notesDialog.showDialog();
    }

    public int getSelectedObjectSignature() {
        SBModel sbmodel = this.getSBModel();
        Vector selected = null;
        this.selectedsbase = null;
        SBase[] sBase = sbmodel.getPanelSelectedSbase();
        if (sBase == null || sBase.length == 0) {
            if (sbmodel.isPluralInSbaseListPanel()) {
                return 999;
            }
            selected = this.editor.getSelecteds();
        } else {
            SBase obj0 = sBase[0];
            if (obj0 instanceof Parameter) {
                if (sBase.length == 1) {
                    this.selectedsbase = obj0;
                    return 4;
                }
                int i = 1;
                while (i < sBase.length) {
                    SBase obj3 = sBase[i];
                    if (!(obj3 instanceof Parameter)) {
                        return 999;
                    }
                    ++i;
                }
                this.selectedsbase = obj0;
                return 104;
            }
            if (obj0 instanceof FunctionDefinition) {
                if (sBase.length == 1) {
                    this.selectedsbase = obj0;
                    return 5;
                }
                int i = 1;
                while (i < sBase.length) {
                    SBase obj3 = sBase[i];
                    if (!(obj3 instanceof FunctionDefinition)) {
                        return 999;
                    }
                    ++i;
                }
                this.selectedsbase = obj0;
                return 105;
            }
            if (obj0 instanceof UnitDefinition) {
                if (sBase.length == 1) {
                    this.selectedsbase = obj0;
                    return 6;
                }
                int i = 1;
                while (i < sBase.length) {
                    SBase obj3 = sBase[i];
                    if (!(obj3 instanceof UnitDefinition)) {
                        return 999;
                    }
                    ++i;
                }
                this.selectedsbase = obj0;
                return 106;
            }
            if (obj0 instanceof Rule) {
                if (sBase.length == 1) {
                    this.selectedsbase = obj0;
                    return 7;
                }
                int i = 1;
                while (i < sBase.length) {
                    SBase obj3 = sBase[i];
                    if (!(obj3 instanceof Rule)) {
                        return 999;
                    }
                    ++i;
                }
                this.selectedsbase = obj0;
                return 107;
            }
            if (obj0 instanceof Event) {
                if (sBase.length == 1) {
                    this.selectedsbase = obj0;
                    return 8;
                }
                int i = 1;
                while (i < sBase.length) {
                    SBase obj3 = sBase[i];
                    if (!(obj3 instanceof Event)) {
                        return 999;
                    }
                    ++i;
                }
                this.selectedsbase = obj0;
                return 108;
            }
            if (obj0 instanceof SpeciesType) {
                if (sBase.length == 1) {
                    this.selectedsbase = obj0;
                    return 9;
                }
                int i = 1;
                while (i < sBase.length) {
                    SBase obj3 = sBase[i];
                    if (!(obj3 instanceof SpeciesType)) {
                        return 999;
                    }
                    ++i;
                }
                this.selectedsbase = obj0;
                return 109;
            }
            if (obj0 instanceof CompartmentType) {
                if (sBase.length == 1) {
                    this.selectedsbase = obj0;
                    return 10;
                }
                int i = 1;
                while (i < sBase.length) {
                    SBase obj3 = sBase[i];
                    if (!(obj3 instanceof CompartmentType)) {
                        return 999;
                    }
                    ++i;
                }
                this.selectedsbase = obj0;
                return 110;
            }
            if (obj0 instanceof InitialAssignment) {
                if (sBase.length == 1) {
                    this.selectedsbase = obj0;
                    return 11;
                }
                int i = 1;
                while (i < sBase.length) {
                    SBase obj3 = sBase[i];
                    if (!(obj3 instanceof InitialAssignment)) {
                        return 999;
                    }
                    ++i;
                }
                this.selectedsbase = obj0;
                return 111;
            }
            if (obj0 instanceof Constraint) {
                if (sBase.length == 1) {
                    this.selectedsbase = obj0;
                    return 12;
                }
                int i = 1;
                while (i < sBase.length) {
                    SBase obj3 = sBase[i];
                    if (!(obj3 instanceof Constraint)) {
                        return 999;
                    }
                    ++i;
                }
                this.selectedsbase = obj0;
                return 112;
            }
        }
        if (selected == null || selected.size() == 0) {
            return 0;
        }
        Object obj = selected.elementAt(0);
        if (obj instanceof SpeciesAlias) {
            SpeciesAlias alias = (SpeciesAlias)obj;
            Species species = alias.getOriginalSpecies();
            if (species == null) {
                return 0;
            }
            if (selected.size() == 1) {
                return 2;
            }
            boolean single_species = true;
            SpeciesProperty sp = ((SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null)).getSpeciesProperty();
            Species p = null;
            if (alias.isMonoProtein()) {
                p = ((MonoSpeciesProperty)sp).getProtein();
            } else if (alias.isMonoGene()) {
                p = ((MonoSpeciesProperty)sp).getGene();
            } else if (alias.isMonoRNA()) {
                p = ((MonoSpeciesProperty)sp).getRNA();
            } else if (alias.isMonoAntiSenseRNA()) {
                p = ((MonoSpeciesProperty)sp).getAntiSenseRNA();
            }
            int i = 1;
            while (i < selected.size()) {
                Object obj2 = selected.elementAt(i);
                if (obj2 instanceof SpeciesAlias) {
                    Species species2 = ((SpeciesAlias)obj2).getOriginalSpecies();
                    if (species.getId() == null || !species.getId().equals(species2.getId())) {
                        single_species = false;
                        SpeciesAlias alias2 = (SpeciesAlias)obj2;
                        SpeciesProperty sp2 = ((SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species2, null)).getSpeciesProperty();
                        Species p2 = null;
                        if (alias2.isMonoProtein()) {
                            p2 = ((MonoSpeciesProperty)sp2).getProtein();
                        } else if (alias2.isMonoGene()) {
                            p2 = ((MonoSpeciesProperty)sp2).getGene();
                        } else if (alias2.isMonoRNA()) {
                            p2 = ((MonoSpeciesProperty)sp2).getRNA();
                        } else if (alias2.isMonoAntiSenseRNA()) {
                            p2 = ((MonoSpeciesProperty)sp2).getAntiSenseRNA();
                        }
                        if (p != p2) {
                            return 999;
                        }
                    }
                } else {
                    return 999;
                }
                ++i;
            }
            if (single_species) {
                return 2;
            }
            if (p == null) {
                return 999;
            }
            if (p instanceof Protein) {
                return 201;
            }
            if (p instanceof Gene) {
                return 202;
            }
            if (p instanceof RNA) {
                return 203;
            }
            if (p instanceof AntiSenseRNA) {
                return 204;
            }
            return 999;
        }
        if (obj instanceof CompartmentAlias) {
            if (selected.size() == 1) {
                return 1;
            }
            Compartment compartment = ((CompartmentAlias)obj).getOriginalCompartment();
            int i = 1;
            while (i < selected.size()) {
                Object obj2 = selected.elementAt(i);
                if (obj2 instanceof CompartmentAlias) {
                    Compartment compartment2 = ((CompartmentAlias)obj2).getOriginalCompartment();
                    if (compartment != compartment2) {
                        return 999;
                    }
                } else {
                    return 999;
                }
                ++i;
            }
            return 1;
        }
        if (obj instanceof ReactionLink) {
            if (selected.size() == 1) {
                return 3;
            }
            int i = 1;
            while (i < selected.size()) {
                Object obj2 = selected.elementAt(i);
                if (!(obj2 instanceof ReactionLink)) {
                    return 999;
                }
                ++i;
            }
            return 103;
        }
        return 0;
    }

    public void showProteinNotesDialog() {
        Vector selected = this.editor.getSelecteds();
        if (selected == null || selected.size() == 0) {
            return;
        }
        Notes notes = null;
        Object obj = selected.elementAt(0);
        if (!(obj instanceof SpeciesAlias)) {
            return;
        }
        SpeciesAlias sa = (SpeciesAlias)obj;
        SpeciesAnnotation sp = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)sa.getOriginalSpecies(), null);
        Species p = null;
        String title = "";
        String id = "";
        if (sa.isMonoProtein()) {
            p = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getProtein();
            title = ProteinNotesTitle;
            id = p.getId();
        } else if (sa.isMonoGene()) {
            p = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getGene();
            title = GeneNotesTitle;
            id = ((Gene)p).getId();
        } else if (sa.isMonoRNA()) {
            p = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getRNA();
            title = RNANotesTitle;
            id = ((RNA)p).getId();
        } else if (sa.isMonoAntiSenseRNA()) {
            p = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getAntiSenseRNA();
            title = asRNANotesTitle;
            id = ((AntiSenseRNA)p).getId();
        }
        if (p == null) {
            return;
        }
        notes = (Notes)LibSBMLUtil.getNotes((SBase)p, null);
        if (notes != null) {
            this.proteinNotesDialog.setTitle(String.valueOf(title) + " (id=" + id + "; " + this.getFilename() + ")");
            this.proteinNotesDialog.setEditingNotes(notes);
        }
        if (p != null) {
            this.proteinNotesDialog.setTarget((SBase)p);
        }
        this.proteinNotesDialog.showDialog();
    }

    public SBase getSelectedProteinEtc() {
        Species rtnsbase = null;
        Vector selected = this.editor.getSelecteds();
        if (selected == null || selected.size() == 0) {
            return rtnsbase;
        }
        Object notes = null;
        Object obj = selected.elementAt(0);
        if (!(obj instanceof SpeciesAlias)) {
            return rtnsbase;
        }
        SpeciesAlias sa = (SpeciesAlias)obj;
        SpeciesAnnotation sp = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)sa.getOriginalSpecies(), null);
        Object listPanel = null;
        if (sa.isMonoProtein()) {
            rtnsbase = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getProtein();
        } else if (sa.isMonoGene()) {
            rtnsbase = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getGene();
        } else if (sa.isMonoRNA()) {
            rtnsbase = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getRNA();
        } else if (sa.isMonoAntiSenseRNA()) {
            rtnsbase = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getAntiSenseRNA();
        }
        return rtnsbase;
    }

    public String getSelectedObjectsName() {
        Vector selected = this.editor.getSelecteds();
        String information = "";
        int signature = this.getSelectedObjectSignature();
        if (this.selectedsbase != null) {
            if (signature == 4) {
                information = this.selectedsbase.getName();
            } else if (signature == 5) {
                information = this.selectedsbase.getName();
            } else if (signature == 6) {
                information = this.selectedsbase.getName();
            } else if (signature == 7) {
                information = this.selectedsbase.getName();
            } else if (signature == 8) {
                information = this.selectedsbase.getName();
            } else if (signature == 9) {
                information = this.selectedsbase.getName();
            } else if (signature == 10) {
                information = this.selectedsbase.getName();
            } else if (signature == 11) {
                information = this.selectedsbase.getName();
            } else if (signature == 12) {
                information = this.selectedsbase.getName();
            }
            return information;
        }
        if (selected == null || selected.size() == 0) {
            return "";
        }
        if (signature == 0 || signature == 999) {
            return "";
        }
        Object obj = selected.elementAt(0);
        if (signature == 2) {
            Species species = ((SpeciesAlias)obj).getOriginalSpecies();
            if (species == null) {
                return "";
            }
            information = species.getName();
        } else if (signature == 1) {
            Compartment compartment = ((CompartmentAlias)obj).getOriginalCompartment();
            information = compartment.getName();
        } else if (signature == 3) {
            Reaction reaction = ((ReactionLink)obj).getParentReaction();
            information = reaction.getName();
        } else if (signature == 201) {
            Species species = ((SpeciesAlias)obj).getOriginalSpecies();
            if (species == null) {
                return "";
            }
            SpeciesAnnotation sp = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null);
            Protein p = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getProtein();
            information = p.getName();
        }
        return information;
    }

    public String getSelectedObjectsInfomation() {
        Vector selected = this.editor.getSelecteds();
        int signature = this.getSelectedObjectSignature();
        Notes notes = null;
        StringBuffer information = new StringBuffer();
        if (this.selectedsbase != null) {
            if (signature == 4) {
                information.append("Parameter (id=").append(this.selectedsbase.getId());
                information.append(", name=").append(this.selectedsbase.getName()).append("; ");
            } else if (signature == 5) {
                information.append("Function (id=").append(this.selectedsbase.getId());
                information.append(", name=").append(this.selectedsbase.getName()).append("; ");
            } else if (signature == 6) {
                information.append("UnitDefinition (id=").append(this.selectedsbase.getId());
                information.append(", name=").append(this.selectedsbase.getName()).append("; ");
            } else if (signature == 7) {
                if (this.selectedsbase instanceof AlgebraicRule) {
                    AlgebraicRule algebraicRule = (AlgebraicRule)this.selectedsbase;
                    information.append("Rule (math=").append(algebraicRule.getFormula());
                    information.append(", subtype=").append("Algebraic").append("; ");
                } else if (this.selectedsbase instanceof AssignmentRule) {
                    AssignmentRule assignmentRule = (AssignmentRule)this.selectedsbase;
                    information.append("Rule (math=").append(assignmentRule.getFormula());
                    information.append(", subtype=").append("Assignment").append("; ");
                } else if (this.selectedsbase instanceof RateRule) {
                    RateRule rateRule = (RateRule)this.selectedsbase;
                    information.append("Rule (math=").append(rateRule.getFormula());
                    information.append(", subtype=").append("Rate").append("; ");
                }
            } else if (signature == 8) {
                information.append("Event (id=").append(this.selectedsbase.getId());
                information.append(", name=").append(this.selectedsbase.getName()).append("; ");
            } else if (signature == 9) {
                information.append("SpeciesType (id=").append(this.selectedsbase.getId());
                information.append(", name=").append(this.selectedsbase.getName()).append("; ");
            } else if (signature == 10) {
                information.append("CompartmentType (id=").append(this.selectedsbase.getId());
                information.append(", name=").append(this.selectedsbase.getName()).append("; ");
            } else if (signature == 11) {
                InitialAssignment initialAssignment = (InitialAssignment)this.selectedsbase;
                ASTNode math = initialAssignment.getMath();
                String strMath = "";
                if (math != null) {
                    strMath = libsbml.formulaToString((ASTNode)math);
                }
                information.append("InitialAssignment (symbol=").append(initialAssignment.getSymbol());
                information.append(", math=").append(strMath).append("; ");
            } else if (signature == 12) {
                String strMsg;
                Constraint constraint = (Constraint)this.selectedsbase;
                ASTNode math = constraint.getMath();
                String strMath = "";
                if (math != null) {
                    strMath = libsbml.formulaToString((ASTNode)math);
                }
                if ((strMsg = ConstraintDialog.getMsgStringOfConstraint(constraint)) == null) {
                    strMsg = "";
                }
                information.append("Constraint (math=").append(strMath);
                information.append(", message=").append(strMsg).append("; ");
            }
            if (information.toString().trim().equals("")) {
                return "";
            }
            notes = (Notes)LibSBMLUtil.getNotes(this.selectedsbase, null);
            if (notes == null) {
                notes = new Notes();
                notes.setText("");
            }
            String ntext = notes.getText();
            information.append(this.getFilename()).append(")\n").append(ntext);
            return information.toString();
        }
        if (selected == null || selected.size() == 0) {
            return "";
        }
        if (signature == 0 || signature == 999) {
            return "";
        }
        Object obj = selected.elementAt(0);
        if (signature == 2) {
            Species species = ((SpeciesAlias)obj).getOriginalSpecies();
            if (species == null) {
                return "";
            }
            information.append("Species (id=").append(species.getId()).append(", name=").append(species.getName()).append("; ").append(this.getFilename()).append(")\n");
            notes = (Notes)LibSBMLUtil.getNotes((SBase)species, null);
            if (notes.hasValue()) {
                information.append(notes.getText().trim()).append("\n");
            }
            Species p = null;
            SpeciesAlias sa = (SpeciesAlias)obj;
            SpeciesAnnotation sp = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null);
            String type = "";
            String name = "";
            String id = "";
            if (sa.isMonoProtein()) {
                p = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getProtein();
                if (p != null) {
                    name = p.getName();
                    id = p.getId();
                }
                type = "Protein";
            } else if (sa.isMonoGene()) {
                p = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getGene();
                if (p != null) {
                    name = ((Gene)p).getName();
                    id = ((Gene)p).getId();
                }
                type = "Gene";
            } else if (sa.isMonoRNA()) {
                p = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getRNA();
                if (p != null) {
                    name = ((RNA)p).getName();
                    id = ((RNA)p).getId();
                }
                type = "RNA";
            } else if (sa.isMonoAntiSenseRNA()) {
                p = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getAntiSenseRNA();
                if (p != null) {
                    name = ((AntiSenseRNA)p).getName();
                    id = ((AntiSenseRNA)p).getId();
                }
                type = "asRNA";
            }
            if (p != null) {
                notes = (Notes)LibSBMLUtil.getNotes((SBase)p, null);
                String ntext = notes.getText();
                information.append("\n").append(type).append(" (id=").append(id).append(", name=").append(name).append(")\n").append(ntext);
            }
        } else if (signature == 1) {
            Compartment compartment = ((CompartmentAlias)obj).getOriginalCompartment();
            if (compartment == null) {
                return "";
            }
            notes = (Notes)LibSBMLUtil.getNotes((SBase)compartment, null);
            String ntext = notes.getText();
            information.append("Compartment (id=").append(compartment.getId()).append(", name=").append(compartment.getName()).append("; ").append(this.getFilename()).append(")\n").append(ntext);
        } else if (signature == 3) {
            Reaction reaction = ((ReactionLink)obj).getParentReaction();
            notes = (Notes)LibSBMLUtil.getNotes((SBase)reaction, null);
            String ntext = notes.getText();
            information.append("Reaction (id=").append(reaction.getId()).append(", name=").append(reaction.getName()).append("; ").append(this.getFilename()).append(")\n").append(ntext);
        } else if (signature == 201) {
            Species species = ((SpeciesAlias)obj).getOriginalSpecies();
            if (species == null) {
                return "";
            }
            SpeciesAnnotation sp = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null);
            Protein p = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getProtein();
            notes = (Notes)LibSBMLUtil.getNotes((SBase)p, null);
            String ntext = notes.getText();
            information.append("Protein (id=").append(p.getId()).append(", name=").append(p.getName()).append(")\n").append(ntext);
        } else if (signature == 202) {
            Species species = ((SpeciesAlias)obj).getOriginalSpecies();
            if (species == null) {
                return "";
            }
            SpeciesAnnotation sp = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null);
            Gene p = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getGene();
            notes = (Notes)LibSBMLUtil.getNotes((SBase)p, null);
            String ntext = notes.getText();
            information.append("Gene (id=").append(p.getId()).append(", name=").append(p.getName()).append(")\n").append(ntext);
        } else if (signature == 203) {
            Species species = ((SpeciesAlias)obj).getOriginalSpecies();
            if (species == null) {
                return "";
            }
            SpeciesAnnotation sp = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null);
            RNA p = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getRNA();
            notes = (Notes)LibSBMLUtil.getNotes((SBase)p, null);
            String ntext = notes.getText();
            information.append("RNA (id=").append(p.getId()).append(", name=").append(p.getName()).append(")\n").append(ntext);
        } else if (signature == 204) {
            Species species = ((SpeciesAlias)obj).getOriginalSpecies();
            if (species == null) {
                return "";
            }
            SpeciesAnnotation sp = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null);
            AntiSenseRNA p = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getAntiSenseRNA();
            notes = (Notes)LibSBMLUtil.getNotes((SBase)p, null);
            String ntext = notes.getText();
            information.append("asRNA (id=").append(p.getId()).append(", name=").append(p.getName()).append(")\n").append(ntext);
        }
        return information.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAbleToShowProteinNotes() {
        if (this.selectedsbase != null) {
            return false;
        }
        if (this.sbmodel.isPluralInSbaseListPanel()) {
            return false;
        }
        Vector selected = this.editor.getSelecteds();
        if (selected == null || selected.size() == 0) {
            return false;
        }
        Object obj = selected.elementAt(0);
        if (!(obj instanceof SpeciesAlias)) {
            return false;
        }
        if (!((SpeciesAlias)obj).isMonoProtein()) {
            return false;
        }
        if (selected.size() == 1) {
            return true;
        }
        SpeciesAnnotation spa = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)((SpeciesAlias)obj).getOriginalSpecies(), null);
        Protein p = ((MonoSpeciesProperty)spa.getSpeciesProperty()).getProtein();
        int i = 1;
        while (i < selected.size()) {
            Object obj2 = selected.elementAt(i);
            if (!(obj2 instanceof SpeciesAlias)) return false;
            if (!((SpeciesAlias)obj2).isMonoProtein()) return false;
            SpeciesAnnotation spa2 = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)((SpeciesAlias)obj2).getOriginalSpecies(), null);
            Protein p2 = ((MonoSpeciesProperty)spa2.getSpeciesProperty()).getProtein();
            if (p != p2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAbleToShowGeneNotes() {
        if (this.selectedsbase != null) {
            return false;
        }
        if (this.sbmodel.isPluralInSbaseListPanel()) {
            return false;
        }
        Vector selected = this.editor.getSelecteds();
        if (selected == null || selected.size() == 0) {
            return false;
        }
        Object obj = selected.elementAt(0);
        if (!(obj instanceof SpeciesAlias)) {
            return false;
        }
        if (!((SpeciesAlias)obj).isMonoGene()) {
            return false;
        }
        if (selected.size() == 1) {
            return true;
        }
        SpeciesAnnotation spa = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)((SpeciesAlias)obj).getOriginalSpecies(), null);
        Gene p = ((MonoSpeciesProperty)spa.getSpeciesProperty()).getGene();
        int i = 1;
        while (i < selected.size()) {
            Object obj2 = selected.elementAt(i);
            if (!(obj2 instanceof SpeciesAlias)) return false;
            if (!((SpeciesAlias)obj2).isMonoGene()) return false;
            SpeciesAnnotation spa2 = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)((SpeciesAlias)obj2).getOriginalSpecies(), null);
            Gene p2 = ((MonoSpeciesProperty)spa2.getSpeciesProperty()).getGene();
            if (p != p2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAbleToShowRNANotes() {
        if (this.selectedsbase != null) {
            return false;
        }
        if (this.sbmodel.isPluralInSbaseListPanel()) {
            return false;
        }
        Vector selected = this.editor.getSelecteds();
        if (selected == null || selected.size() == 0) {
            return false;
        }
        Object obj = selected.elementAt(0);
        if (!(obj instanceof SpeciesAlias)) {
            return false;
        }
        if (!((SpeciesAlias)obj).isMonoRNA()) {
            return false;
        }
        if (selected.size() == 1) {
            return true;
        }
        SpeciesAnnotation spa = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)((SpeciesAlias)obj).getOriginalSpecies(), null);
        RNA p = ((MonoSpeciesProperty)spa.getSpeciesProperty()).getRNA();
        int i = 1;
        while (i < selected.size()) {
            Object obj2 = selected.elementAt(i);
            if (!(obj2 instanceof SpeciesAlias)) return false;
            if (!((SpeciesAlias)obj2).isMonoRNA()) return false;
            SpeciesAnnotation spa2 = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)((SpeciesAlias)obj2).getOriginalSpecies(), null);
            RNA p2 = ((MonoSpeciesProperty)spa2.getSpeciesProperty()).getRNA();
            if (p != p2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAbleToShowAntisenseRNANotes() {
        if (this.selectedsbase != null) {
            return false;
        }
        if (this.sbmodel.isPluralInSbaseListPanel()) {
            return false;
        }
        Vector selected = this.editor.getSelecteds();
        if (selected == null || selected.size() == 0) {
            return false;
        }
        Object obj = selected.elementAt(0);
        if (!(obj instanceof SpeciesAlias)) {
            return false;
        }
        if (!((SpeciesAlias)obj).isMonoAntiSenseRNA()) {
            return false;
        }
        if (selected.size() == 1) {
            return true;
        }
        SpeciesAnnotation spa = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)((SpeciesAlias)obj).getOriginalSpecies(), null);
        AntiSenseRNA p = ((MonoSpeciesProperty)spa.getSpeciesProperty()).getAntiSenseRNA();
        int i = 1;
        while (i < selected.size()) {
            Object obj2 = selected.elementAt(i);
            if (!(obj2 instanceof SpeciesAlias)) return false;
            if (!((SpeciesAlias)obj2).isMonoAntiSenseRNA()) return false;
            SpeciesAnnotation spa2 = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)((SpeciesAlias)obj2).getOriginalSpecies(), null);
            AntiSenseRNA p2 = ((MonoSpeciesProperty)spa2.getSpeciesProperty()).getAntiSenseRNA();
            if (p != p2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void showChangeShapeDialog(boolean isChangeFont) {
        boolean uitypeflag = this.uiType == 2;
        Vector selected = this.editor.getSelecteds();
        if (selected == null || selected.size() <= 0) {
            return;
        }
        this.symbolShapeDialog.setShapeAndColorEnable(true, true);
        this.symbolShapeDialog.setChangeSpeciesNameFontSizeFlag(isChangeFont);
        if (selected.size() == 1) {
            Object obj = selected.elementAt(0);
            if (obj instanceof SpeciesAlias) {
                SpeciesShape sshape = (SpeciesShape)((Object)((SpeciesAlias)obj).getGFramedShape());
                if (sshape instanceof MonoSpeciesShape) {
                    if (this.symbolShapeDialog.isChangeSpeciesNameFontSize()) {
                        String strBackUp = new String(this.symbolShapeDialog.getTitle());
                        this.symbolShapeDialog.setTitle("Change Species Name Font");
                        this.symbolShapeDialog.setPanel(obj);
                        this.symbolShapeDialog.show();
                        this.symbolShapeDialog.setTitle(strBackUp);
                        return;
                    }
                    this.symbolShapeDialog.setPanel(obj);
                    this.symbolShapeDialog.show();
                }
            } else if (obj instanceof CompartmentAlias) {
                this.symbolShapeDialog.setPanel(obj);
                this.symbolShapeDialog.show();
            } else if (obj instanceof ReactionLink) {
                ReactionLink rl = (ReactionLink)obj;
                if (rl.getGLinkedShape() != null) {
                    LinkedCreaseLine lcsln;
                    rl.getGLinkedShape().setIsInSBGNViewer(uitypeflag);
                    if (rl.getGLinkedShape() instanceof GLinkedLineComplex3) {
                        GLinkedLineComplex3 cmplx3 = (GLinkedLineComplex3)rl.getGLinkedShape();
                        cmplx3.getProcessNode().setIsInSBGNViewer(uitypeflag);
                    } else if (rl.getGLinkedShape() instanceof GLogicGate && (lcsln = ((GLogicGate)rl.getGLinkedShape()).getRealLine()) != null) {
                        lcsln.setIsInSBGNViewer(uitypeflag);
                    }
                }
                this.symbolShapeDialog.setPanel(obj);
                this.symbolShapeDialog.show();
            } else if (obj instanceof LayerSpeciesAlias) {
                this.symbolShapeDialog.setPanel(obj);
                this.symbolShapeDialog.show();
            } else if (obj instanceof LayerCompartmentAlias) {
                this.symbolShapeDialog.setInnerFlg(false);
                this.symbolShapeDialog.setPanel(obj);
                this.symbolShapeDialog.show();
            } else if (obj instanceof LayerReactionLink) {
                this.symbolShapeDialog.setPanel(obj);
                this.symbolShapeDialog.show();
            }
        } else if (selected.size() > 1) {
            if (SBSymbolEditDialog.canChangeLayerComponentShapeColorAllOf(selected)) {
                Object obj0 = selected.elementAt(0);
                if (obj0 instanceof LayerSpeciesAlias) {
                    this.symbolShapeDialog.setPanel(obj0, selected);
                    this.symbolShapeDialog.show();
                } else if (obj0 instanceof LayerCompartmentAlias) {
                    this.symbolShapeDialog.setPanel(obj0, selected);
                    this.symbolShapeDialog.show();
                } else if (obj0 instanceof LayerReactionLink) {
                    this.symbolShapeDialog.setPanel(obj0, selected);
                    this.symbolShapeDialog.show();
                }
                return;
            }
            if (this.symbolShapeDialog.isChangeSpeciesNameFontSize()) {
                SpeciesShape sshape;
                Object obj0 = selected.elementAt(0);
                if (obj0 instanceof SpeciesAlias && (sshape = (SpeciesShape)((Object)((SpeciesAlias)obj0).getGFramedShape())) instanceof MonoSpeciesShape) {
                    String strBackUp = new String(this.symbolShapeDialog.getTitle());
                    this.symbolShapeDialog.setTitle("Change Species Name Font");
                    this.symbolShapeDialog.setPanel(obj0, selected);
                    this.symbolShapeDialog.show();
                    this.symbolShapeDialog.setTitle(strBackUp);
                }
                return;
            }
            Object type = null;
            Vector objs = new Vector();
            int i = 0;
            while (i < selected.size()) {
                LayerMonoSpeciesShape monoShape;
                Object obj = selected.elementAt(i);
                if (i == 0) {
                    type = selected.elementAt(0);
                    objs.add(obj);
                } else if (obj instanceof SpeciesAlias && type instanceof SpeciesAlias) {
                    SpeciesShape sshape = (SpeciesShape)((Object)((SpeciesAlias)obj).getGFramedShape());
                    if (sshape instanceof MonoSpeciesShape) {
                        objs.add(obj);
                    }
                } else if (obj instanceof CompartmentAlias && type instanceof CompartmentAlias) {
                    objs.add(obj);
                } else if (obj instanceof ReactionLink && type instanceof ReactionLink) {
                    objs.add(obj);
                } else if (obj instanceof LayerSpeciesAlias && (monoShape = (LayerMonoSpeciesShape)((LayerSpeciesAlias)obj).getGFramedShape()).getSpeciesSymbol() instanceof LayerTagSymbol) {
                    objs.add(obj);
                }
                ++i;
            }
            if (objs.size() > 1) {
                this.symbolShapeDialog.setPanel(objs.get(0), objs);
                this.symbolShapeDialog.show();
            } else if (objs.size() == 1) {
                this.symbolShapeDialog.setPanel(objs.get(0));
                this.symbolShapeDialog.show();
            }
        }
    }

    public void showChangeShapeDialogForLayerCompartmentInner() {
        block11: {
            if (this.editor == null) {
                return;
            }
            Vector selected = this.editor.getSelecteds();
            if (selected == null || selected.size() <= 0) {
                return;
            }
            Object obj = selected.elementAt(0);
            if (!(obj instanceof LayerCompartmentAlias)) {
                return;
            }
            if (selected.size() > 1 && !SBSymbolEditDialog.canChangeLayerComponentShapeColorAllOf(selected)) {
                return;
            }
            this.symbolShapeDialog.setTitle("Change Inner color and shape");
            this.symbolShapeDialog.setShapeAndColorEnable(true, true);
            this.symbolShapeDialog.resetChangeSpeciesNameFontSizeFlag();
            try {
                try {
                    this.symbolShapeDialog.setInnerFlg(true);
                    obj = selected.elementAt(0);
                    if (selected.size() == 1) {
                        this.symbolShapeDialog.setPanel(obj);
                        this.symbolShapeDialog.show();
                    } else {
                        this.symbolShapeDialog.setPanel(obj, selected);
                        this.symbolShapeDialog.show();
                    }
                }
                catch (Exception exception) {
                    this.symbolShapeDialog.setInnerFlg(false);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                this.symbolShapeDialog.setInnerFlg(false);
                throw throwable;
            }
            this.symbolShapeDialog.setInnerFlg(false);
        }
        this.symbolShapeDialog.setTitle("Change color and shape");
    }

    public boolean isAbleToShowChangeInnerShapeDialog() {
        Vector selected = this.editor.getSelecteds();
        if (selected == null) {
            return false;
        }
        int i = 0;
        while (i < selected.size()) {
            Object obj = selected.elementAt(i);
            if (!(obj instanceof LayerCompartmentAlias)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isAbleToShowChangeSpeciesNameFontSizeDialog() {
        Vector selected = this.editor.getSelecteds();
        if (selected == null || selected.size() == 0) {
            return false;
        }
        if (selected.size() == 1) {
            Object obj = selected.elementAt(0);
            return obj instanceof SpeciesAlias;
        }
        int i = 0;
        while (i < selected.size()) {
            Object obj = selected.get(i);
            if (!(obj instanceof SpeciesAlias)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAbleToShowChangeShapeDialog() {
        MonoSpeciesShape monoShape0;
        Vector selected = this.editor.getSelecteds();
        if (selected == null) {
            return false;
        }
        if (selected.size() == 1) {
            Object obj = selected.elementAt(0);
            if (obj instanceof SpeciesAlias) {
                return ((SpeciesAlias)obj).getGFramedShape() instanceof MonoSpeciesShape;
            }
            if (obj instanceof CompartmentAlias) {
                return true;
            }
            if (!(obj instanceof LayerCompartmentAlias) && !(obj instanceof LayerSpeciesAlias) && !(obj instanceof LayerReactionLink)) return obj instanceof ReactionLink;
            try {
                LayerTagFreeLineSymbol symbol = (LayerTagFreeLineSymbol)((LayerReactionLink)obj).getSymbol();
                if (!(symbol instanceof LayerTagFreeLineSymbol)) return true;
                return false;
            }
            catch (Exception symbol) {
                // empty catch block
            }
            return true;
        }
        if (selected.size() <= 1) return false;
        Object obj0 = selected.elementAt(0);
        try {
            LayerTagFreeLineSymbol symbol = (LayerTagFreeLineSymbol)((LayerReactionLink)obj0).getSymbol();
            if (symbol instanceof LayerTagFreeLineSymbol) {
                return false;
            }
        }
        catch (Exception symbol) {
            // empty catch block
        }
        SBSymbol symbol0 = null;
        String type0 = null;
        int view0 = -1;
        if (obj0 instanceof SpeciesAlias && ((SpeciesAlias)obj0).getGFramedShape() instanceof MonoSpeciesShape && (monoShape0 = (MonoSpeciesShape)((SpeciesAlias)obj0).getGFramedShape()).getSpeciesSymbol() instanceof SBSymbol) {
            symbol0 = (SBSymbol)((Object)monoShape0.getSpeciesSymbol());
            type0 = symbol0.getCode();
            if (obj0 instanceof ComplexSpeciesAlias) {
                view0 = ((ComplexSpeciesAlias)obj0).getCurrentView();
            }
        }
        LayerSpeciesSymbol layerTagSymbol0 = null;
        if (obj0 instanceof LayerSpeciesAlias && ((LayerSpeciesAlias)obj0).getGFramedShape() instanceof LayerMonoSpeciesShape) {
            LayerMonoSpeciesShape monoShape = (LayerMonoSpeciesShape)((LayerSpeciesAlias)obj0).getGFramedShape();
            layerTagSymbol0 = monoShape.getSpeciesSymbol();
        }
        int i = 1;
        while (i < selected.size()) {
            block36: {
                GFramedShape monoShape;
                Object obj = selected.elementAt(i);
                if (obj0 instanceof ElementSpeciesAlias && !(obj instanceof ElementSpeciesAlias)) {
                    return false;
                }
                if (obj0 instanceof ComplexSpeciesAlias && !(obj instanceof ComplexSpeciesAlias)) {
                    return false;
                }
                if (obj0 instanceof CompartmentAlias && !(obj instanceof CompartmentAlias)) {
                    return false;
                }
                if (obj0 instanceof ReactionLink && !(obj instanceof ReactionLink)) {
                    return false;
                }
                if (obj0 instanceof LayerSpeciesAlias && !(obj instanceof LayerSpeciesAlias)) {
                    return false;
                }
                if (obj0 instanceof LayerClosedCompartmentAlias && !(obj instanceof LayerClosedCompartmentAlias)) {
                    return false;
                }
                if (obj0 instanceof LayerReactionLink && !(obj instanceof LayerReactionLink)) {
                    return false;
                }
                try {
                    LayerTagFreeLineSymbol symbol = (LayerTagFreeLineSymbol)((LayerReactionLink)obj).getSymbol();
                    if (symbol instanceof LayerTagFreeLineSymbol) {
                        return false;
                    }
                }
                catch (Exception symbol) {
                    // empty catch block
                }
                if (obj instanceof SpeciesAlias && obj0 instanceof SpeciesAlias) {
                    if (((SpeciesAlias)obj).getGFramedShape() instanceof MonoSpeciesShape && !(((SpeciesAlias)obj0).getGFramedShape() instanceof MonoSpeciesShape)) {
                        return false;
                    }
                    if (!(((SpeciesAlias)obj).getGFramedShape() instanceof MonoSpeciesShape) || type0 == null) return false;
                    monoShape = (MonoSpeciesShape)((SpeciesAlias)obj).getGFramedShape();
                    if (!(((MonoSpeciesShape)monoShape).getSpeciesSymbol() instanceof SBSymbol)) return false;
                    SBSymbol symbol = (SBSymbol)((Object)((MonoSpeciesShape)monoShape).getSpeciesSymbol());
                    String type = symbol.getCode();
                    if (symbol0 instanceof ComplexBrief) {
                        type0 = "COMPLEX";
                    }
                    if (symbol instanceof ComplexBrief) {
                        type = "COMPLEX";
                    }
                    if (!type0.equals(type)) {
                        return false;
                    }
                    if (view0 != -1 && obj instanceof ComplexSpeciesAlias && view0 != ((ComplexSpeciesAlias)obj).getCurrentView()) {
                        return false;
                    }
                } else {
                    if (obj instanceof SpeciesAlias && !(obj0 instanceof SpeciesAlias)) {
                        return false;
                    }
                    if (obj instanceof CompartmentAlias && !(obj0 instanceof CompartmentAlias)) {
                        return false;
                    }
                    if (obj instanceof ReactionLink && !(obj0 instanceof ReactionLink)) {
                        return false;
                    }
                    try {
                        monoShape = (LayerMonoSpeciesShape)((LayerSpeciesAlias)obj).getGFramedShape();
                        LayerTagSymbol layerTagSymbol = (LayerTagSymbol)((LayerMonoSpeciesShape)monoShape).getSpeciesSymbol();
                        if (layerTagSymbol instanceof LayerTagSymbol && !(layerTagSymbol0 instanceof LayerTagSymbol)) {
                            return false;
                        }
                    }
                    catch (Exception ex) {
                        if (!(layerTagSymbol0 instanceof LayerTagSymbol)) break block36;
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public void showErrorMessage(String msg) {
        String title = "Error";
        JOptionPane.showMessageDialog(this, msg, title, 2);
    }

    public SBModel getSBModel() {
        return this.sbmodel;
    }

    public void eventRecorded(GEvent event) {
        super.setChanged(this.sbmodel.getRecorder().isAbleToUndo());
        super.getStatusBar().setString1("");
    }

    public void undoPerformed(GEvent event) {
        super.setChanged(this.sbmodel.getRecorder().isAbleToUndo());
        if (!this.sbmodel.getRecorder().isAbleToUndo()) {
            super.getStatusBar().setString1("cannot undo more.");
        } else {
            super.getStatusBar().setString1("");
        }
    }

    public void redoPerformed(GEvent event) {
        super.setChanged(this.sbmodel.getRecorder().isAbleToUndo());
        if (!this.sbmodel.getRecorder().isAbleToRedo()) {
            super.getStatusBar().setString1("cannot redo more.");
        } else {
            super.getStatusBar().setString1("");
        }
    }

    public void eventsCleared() {
        super.setChanged(this.sbmodel.getRecorder().isAbleToUndo());
    }

    protected boolean isAbleToGetName() {
        Object obj;
        return this.editor.getSelecteds().size() == 1 && ((obj = this.editor.getSelecteds().elementAt(0)) instanceof SpeciesAlias || obj instanceof CompartmentAlias || obj instanceof ReactionLink);
    }

    protected boolean isAbleToCopy() {
        Vector v = this.editor.getSelecteds();
        if (v.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < v.size()) {
            Object obj = v.elementAt(i);
            if (!(obj instanceof GCreasePoint && ((GCreasePoint)obj).isLogicGateHeaderPoint() || obj instanceof SpeciesAlias || obj instanceof GGroup || obj instanceof LayerSpeciesAlias || obj instanceof LayerCompartmentAlias || obj instanceof LayerReactionLink)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void doCut() {
        if (this.isAbleToCopy()) {
            this.editor.cutSelecteds(this.sbmodel);
        }
    }

    protected void doCopy() {
        if (this.isAbleToCopy()) {
            this.editor.copySelecteds(this.sbmodel);
        }
    }

    protected boolean isAbleToPaste() {
        return GStructureEditor.getCopies().size() > 0;
    }

    protected void doPaste() {
        if (this.isAbleToPaste()) {
            this.editor.checkNotesBeforePast(this, true);
            try {
                try {
                    this.editor.pasteCopies(super.getLogicalViewArea());
                }
                catch (Exception exception) {
                    GStructureEditor.pasteSBModel.isPastedFromOtherSBModel = false;
                }
            }
            finally {
                GStructureEditor.pasteSBModel.isPastedFromOtherSBModel = false;
            }
        }
    }

    protected void releasePrevPasteArea() {
        this.editor.releasePrevPasteArea();
    }

    protected boolean isAbleToDelete() {
        return this.editor.getSelecteds().size() > 0;
    }

    protected void doDelete() {
        if (this.mainwindowaccess != null && ((MainWindow)this.mainwindowaccess).getTargetControlPanelWindow() != null) {
            if (JOptionPane.showConfirmDialog(null, "It becomes impossible to take ControlPanel and adjustment. ControlPanel is shutdown. Is it all right?") != 0) {
                return;
            }
            MainWindow win = (MainWindow)this.mainwindowaccess;
            win.removeListOfCP(win.getTargetControlPanelWindow());
        }
        Vector v = this.editor.getSelecteds();
        int i = 0;
        while (i < v.size()) {
            GGroup group;
            if (v.elementAt(i) instanceof GGroupTarget && (group = this.sbmodel.getGStructure().getParentGroup((GElement)v.elementAt(i))) != null) {
                this.showErrorMessage("cannot delete members in a group");
                return;
            }
            ++i;
        }
        this.editor.removeSelecteds();
    }

    protected int getPossibleActionToGroup() {
        Vector v = this.editor.getSelecteds();
        if (v.size() < 1) {
            return 0;
        }
        if (v.size() == 1) {
            if (v.elementAt(0) instanceof GGroup) {
                return 2;
            }
            return 0;
        }
        int i = 0;
        while (i < v.size()) {
            GElement elem = (GElement)v.elementAt(i);
            if (!(elem instanceof GGroupTarget)) {
                return 0;
            }
            if (elem instanceof ElementSpeciesAlias && ((ElementSpeciesAlias)elem).getContainer() instanceof ComplexSpeciesAlias) {
                return 0;
            }
            ++i;
        }
        return 1;
    }

    protected void doCreateOrReleaseGroup() {
        try {
            Vector selecteds = this.sbmodel.getGStructure().getSelecteds();
            String errMsgTitle = "Member type error";
            String showErrMsg = "Layer Component can not be a Group Member.";
            String tagErrMsg = "Tag can not be a Group Member.";
            boolean bHaveGroupMemberErr = false;
            int i = 0;
            while (selecteds != null && i < selecteds.size()) {
                GElement gelement = (GElement)selecteds.elementAt(i);
                if (gelement instanceof LayerCompartmentAlias) {
                    bHaveGroupMemberErr = true;
                    break;
                }
                if (gelement instanceof LayerReactionLink) {
                    if (((LayerReactionLink)gelement).getBelong_layer_id() == -99) {
                        showErrMsg = tagErrMsg.toString();
                    }
                    bHaveGroupMemberErr = true;
                    break;
                }
                if (gelement instanceof LayerSpeciesAlias) {
                    if (((LayerSpeciesAlias)gelement).getBelong_layer_id() == -99) {
                        showErrMsg = tagErrMsg.toString();
                    }
                    bHaveGroupMemberErr = true;
                    break;
                }
                ++i;
            }
            if (bHaveGroupMemberErr) {
                JOptionPane.showMessageDialog(MainWindow.getLastInstance(), showErrMsg, errMsgTitle, 0);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getPossibleActionToGroup() == 0) {
            JOptionPane.showMessageDialog(MainWindow.getLastInstance(), "Cannot create a group of the selected elements.\nA group can include SpeciesAliases not contained in a Complex or in another group.", "Cannot create a group", 2);
        } else {
            this.editor.createOrReleaseGroup();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.isShiftPressed = false;
        this.isAltPressed = false;
        if (e.getModifiers() == 1) {
            if (!this.mouseInterpreter.isMultiSelectMode()) {
                this.mouseInterpreter.setMultiSelectMode(true);
            }
            this.isShiftPressed = true;
            return;
        }
        if (e.getModifiers() == 2) {
            switch (e.getKeyCode()) {
                case 68: {
                    PrintStream s = Debug.err;
                    if (s == null) {
                        s = System.err;
                    }
                    this.sbmodel.getGStructure().dump(s);
                    break;
                }
                case 80: {
                    this.sbmodel.dumpProteins();
                }
            }
            return;
        }
        if (e.getModifiers() == 0) {
            switch (e.getKeyCode()) {
                case 83: {
                    if (this.mouseInterpreter.checkMode() != 1) {
                        this.original_mode = this.mouseInterpreter.checkMode();
                        this.mouseInterpreter.setMode(1);
                    }
                    this.isAltPressed = true;
                    break;
                }
                case 114: {
                    this.reporter.setReportON(true);
                    break;
                }
                case 115: {
                    this.reporter.setReportON(false);
                    break;
                }
                case 116: {
                    Preference.isDebug = !Preference.isDebug;
                    this.repaintFrameContents();
                    break;
                }
                case 10: {
                    break;
                }
                case 38: {
                    this.doFinetuning(1);
                    break;
                }
                case 40: {
                    this.doFinetuning(2);
                    break;
                }
                case 39: {
                    this.doFinetuning(3);
                    break;
                }
                case 37: {
                    this.doFinetuning(4);
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.isShiftPressed && this.mouseInterpreter.isMultiSelectMode()) {
            this.mouseInterpreter.setMultiSelectMode(false);
        }
        if (this.isAltPressed) {
            this.mouseInterpreter.setMode(this.original_mode);
            this.original_mode = 1;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getModifiers() == 0 && (e.getKeyChar() == 'c' || e.getKeyChar() == 'C') && this.ownerframe instanceof MainWindow) {
            MainWindow m = (MainWindow)this.ownerframe;
            if (m == null) {
                return;
            }
            if (!m.getAction(MainWindow.ChangeComplexViewAction.class).isEnabled()) {
                return;
            }
            JCheckBoxMenuItem[] checkBoxMenuItems = m.getChangeComplexMenuItems();
            if (checkBoxMenuItems == null) {
                return;
            }
            if (checkBoxMenuItems.length != 3) {
                return;
            }
            ActionEvent actionEvent = null;
            String actionCommand = "from key";
            if (checkBoxMenuItems[0].isSelected()) {
                actionEvent = new ActionEvent(checkBoxMenuItems[1], 1001, actionCommand);
                checkBoxMenuItems[0].setSelected(false);
            } else if (checkBoxMenuItems[1].isSelected()) {
                actionEvent = new ActionEvent(checkBoxMenuItems[2], 1001, actionCommand);
                checkBoxMenuItems[1].setSelected(false);
            } else if (checkBoxMenuItems[2].isSelected()) {
                actionEvent = new ActionEvent(checkBoxMenuItems[0], 1001, actionCommand);
                checkBoxMenuItems[2].setSelected(false);
            } else {
                actionEvent = new ActionEvent(checkBoxMenuItems[0], 1001, actionCommand);
            }
            m.getAction(MainWindow.ChangeComplexViewAction.class).actionPerformed(actionEvent);
        }
    }

    protected boolean isAbleToAlignmentOf2Points() {
        return this.editor.getSelecteds().size() > 1;
    }

    protected boolean isAbleToAlignmentOf3Points() {
        return this.editor.getSelecteds().size() > 2;
    }

    public void doAlignmentLeft() {
        GStructure gStructure = this.sbmodel.getGStructure();
        Vector selectedVector = gStructure.getSelecteds();
        Vector<Point2D.Double> v = new Vector<Point2D.Double>();
        int i = 0;
        while (i < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i);
            Point2D.Double pos = GStructure.getPosition(elem);
            v.add(new Point2D.Double(pos.x, pos.y));
            ++i;
        }
        double minX = 0.0;
        i = 0;
        while (i < v.size()) {
            Point2D.Double pos = (Point2D.Double)v.elementAt(i);
            if (i == 0) {
                minX = pos.x;
            } else if (minX > pos.x) {
                minX = pos.x;
            }
            ++i;
        }
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        int i2 = 0;
        while (i2 < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i2);
            Point2D.Double pos = GStructure.getPosition(elem);
            vector.add(new Point2D.Double(minX, pos.y));
            ++i2;
        }
        gStructure.move(selectedVector, vector);
    }

    public void doAlignmentHorizontalCenter() {
        GStructure gStructure = this.sbmodel.getGStructure();
        Vector selectedVector = gStructure.getSelecteds();
        Vector<Point2D.Double> v1 = new Vector<Point2D.Double>();
        Vector<Point2D.Double> v2 = new Vector<Point2D.Double>();
        int i = 0;
        while (i < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i);
            Point2D.Double pos = GStructure.getPosition(elem);
            Rectangle2D.Double frm = elem.getBounds();
            v1.add(new Point2D.Double(pos.x, pos.y));
            v2.add(new Point2D.Double(pos.x + frm.width, pos.y + frm.height));
            ++i;
        }
        double minX = 0.0;
        double maxX = 0.0;
        i = 0;
        while (i < v1.size()) {
            Point2D.Double pos = (Point2D.Double)v1.elementAt(i);
            Point2D.Double frm = (Point2D.Double)v2.elementAt(i);
            if (i == 0) {
                minX = pos.x;
                maxX = frm.x;
            } else {
                if (minX > pos.x) {
                    minX = pos.x;
                }
                if (maxX < frm.x) {
                    maxX = frm.x;
                }
            }
            ++i;
        }
        double ctrX = minX + (maxX - minX) * 0.5;
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        int i2 = 0;
        while (i2 < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i2);
            Point2D.Double pos = GStructure.getPosition(elem);
            Rectangle2D.Double frm = elem.getBounds();
            vector.add(new Point2D.Double(pos.x + ctrX - frm.getCenterX(), pos.y));
            ++i2;
        }
        gStructure.move(selectedVector, vector);
    }

    public void doAlignmentRight() {
        GStructure gStructure = this.sbmodel.getGStructure();
        Vector selectedVector = gStructure.getSelecteds();
        Vector<Point2D.Double> v = new Vector<Point2D.Double>();
        int i = 0;
        while (i < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i);
            Point2D.Double pos = GStructure.getPosition(elem);
            Rectangle2D.Double frm = elem.getBounds();
            v.add(new Point2D.Double(pos.x + frm.width, pos.y + frm.height));
            ++i;
        }
        double maxX = 0.0;
        i = 0;
        while (i < v.size()) {
            Point2D.Double pos = (Point2D.Double)v.elementAt(i);
            if (i == 0) {
                maxX = pos.x;
            } else if (maxX < pos.x) {
                maxX = pos.x;
            }
            ++i;
        }
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        int i2 = 0;
        while (i2 < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i2);
            Point2D.Double pos = GStructure.getPosition(elem);
            Rectangle2D.Double frm = elem.getBounds();
            vector.add(new Point2D.Double(pos.x + maxX - pos.x - frm.width, pos.y));
            ++i2;
        }
        gStructure.move(selectedVector, vector);
    }

    public void doAlignmentTop() {
        GStructure gStructure = this.sbmodel.getGStructure();
        Vector selectedVector = gStructure.getSelecteds();
        Vector<Point2D.Double> v = new Vector<Point2D.Double>();
        int i = 0;
        while (i < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i);
            Point2D.Double pos = GStructure.getPosition(elem);
            v.add(new Point2D.Double(pos.x, pos.y));
            ++i;
        }
        double minY = 0.0;
        i = 0;
        while (i < v.size()) {
            Point2D.Double pos = (Point2D.Double)v.elementAt(i);
            if (i == 0) {
                minY = pos.y;
            } else if (minY > pos.y) {
                minY = pos.y;
            }
            ++i;
        }
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        int i2 = 0;
        while (i2 < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i2);
            Point2D.Double pos = GStructure.getPosition(elem);
            vector.add(new Point2D.Double(pos.x, minY));
            ++i2;
        }
        gStructure.move(selectedVector, vector);
    }

    public void doAlignmentVerticalCenter() {
        GStructure gStructure = this.sbmodel.getGStructure();
        Vector selectedVector = gStructure.getSelecteds();
        Vector<Point2D.Double> v1 = new Vector<Point2D.Double>();
        Vector<Point2D.Double> v2 = new Vector<Point2D.Double>();
        int i = 0;
        while (i < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i);
            Point2D.Double pos = GStructure.getPosition(elem);
            Rectangle2D.Double frm = elem.getBounds();
            v1.add(new Point2D.Double(pos.x, pos.y));
            v2.add(new Point2D.Double(pos.x + frm.width, pos.y + frm.height));
            ++i;
        }
        double minY = 0.0;
        double maxY = 0.0;
        i = 0;
        while (i < v1.size()) {
            Point2D.Double pos = (Point2D.Double)v1.elementAt(i);
            Point2D.Double frm = (Point2D.Double)v2.elementAt(i);
            if (i == 0) {
                minY = pos.y;
                maxY = frm.y;
            } else {
                if (minY > pos.y) {
                    minY = pos.y;
                }
                if (maxY < frm.y) {
                    maxY = frm.y;
                }
            }
            ++i;
        }
        double ctrY = minY + (maxY - minY) * 0.5;
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        int i2 = 0;
        while (i2 < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i2);
            Point2D.Double pos = GStructure.getPosition(elem);
            Rectangle2D.Double frm = elem.getBounds();
            vector.add(new Point2D.Double(pos.x, pos.y + ctrY - frm.getCenterY()));
            ++i2;
        }
        gStructure.move(selectedVector, vector);
    }

    public void doAlignmentBottom() {
        GStructure gStructure = this.sbmodel.getGStructure();
        Vector selectedVector = gStructure.getSelecteds();
        Vector<Point2D.Double> v = new Vector<Point2D.Double>();
        int i = 0;
        while (i < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i);
            Point2D.Double pos = GStructure.getPosition(elem);
            Rectangle2D.Double frm = elem.getBounds();
            v.add(new Point2D.Double(pos.x + frm.width, pos.y + frm.height));
            ++i;
        }
        double maxY = 0.0;
        i = 0;
        while (i < v.size()) {
            Point2D.Double pos = (Point2D.Double)v.elementAt(i);
            if (i == 0) {
                maxY = pos.y;
            } else if (maxY < pos.y) {
                maxY = pos.y;
            }
            ++i;
        }
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        int i2 = 0;
        while (i2 < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i2);
            Point2D.Double pos = GStructure.getPosition(elem);
            Rectangle2D.Double frm = elem.getBounds();
            vector.add(new Point2D.Double(pos.x, pos.y + maxY - pos.y - frm.height));
            ++i2;
        }
        gStructure.move(selectedVector, vector);
    }

    public void doAlignmentHorizontal() {
        GStructure gStructure = this.sbmodel.getGStructure();
        Vector selectedVector = gStructure.getSelecteds();
        Vector<Point2D.Double> v1 = new Vector<Point2D.Double>();
        Vector<Point2D.Double> v2 = new Vector<Point2D.Double>();
        Vector<Point2D.Double> v3 = new Vector<Point2D.Double>();
        Vector<Point2D.Double> v4 = new Vector<Point2D.Double>();
        int i = 0;
        while (i < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i);
            Point2D.Double pos = GStructure.getPosition(elem);
            Rectangle2D.Double frm = elem.getBounds();
            v1.add(new Point2D.Double(pos.x, pos.y));
            v2.add(new Point2D.Double(pos.x + frm.width, pos.y + frm.height));
            v3.add(new Point2D.Double(pos.x + frm.width * 0.5, pos.y + frm.height * 0.5));
            v4.add(new Point2D.Double(frm.width, frm.height));
            ++i;
        }
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        i = 0;
        while (i < v1.size()) {
            Point2D.Double pos1 = (Point2D.Double)v1.elementAt(i);
            Point2D.Double pos2 = (Point2D.Double)v2.elementAt(i);
            if (minX > pos1.x) {
                minX = pos1.x;
            }
            if (maxX < pos2.x) {
                maxX = pos2.x;
            }
            ++i;
        }
        i = 0;
        while (i < v1.size()) {
            Point2D.Double ctr1 = (Point2D.Double)v3.elementAt(i);
            Point2D.Double frm1 = (Point2D.Double)v4.elementAt(i);
            GElement elm1 = (GElement)selectedVector.elementAt(i);
            int j = i;
            while (j < v1.size()) {
                Point2D.Double ctr2 = (Point2D.Double)v3.elementAt(j);
                Point2D.Double frm2 = (Point2D.Double)v4.elementAt(j);
                GElement elm2 = (GElement)selectedVector.elementAt(j);
                if (ctr1.x > ctr2.x) {
                    v3.setElementAt(ctr2, i);
                    v3.setElementAt(ctr1, j);
                    v4.setElementAt(frm2, i);
                    v4.setElementAt(frm1, j);
                    selectedVector.setElementAt(elm2, i);
                    selectedVector.setElementAt(elm1, j);
                    ctr1 = ctr2;
                    frm1 = frm2;
                    elm1 = elm2;
                }
                ++j;
            }
            ++i;
        }
        double leng = 0.0;
        Point2D.Double frm1 = (Point2D.Double)v4.elementAt(0);
        Point2D.Double frm2 = (Point2D.Double)v4.elementAt(selectedVector.size() - 1);
        leng = maxX - frm2.x - minX - frm1.x;
        int i2 = 1;
        while (i2 < selectedVector.size() - 1) {
            GElement elem = (GElement)selectedVector.elementAt(i2);
            Rectangle2D.Double frm = elem.getBounds();
            leng -= frm.width;
            ++i2;
        }
        leng /= (double)(selectedVector.size() - 1);
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        double dstX = 0.0;
        int i3 = 0;
        while (i3 < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i3);
            Point2D.Double pos = GStructure.getPosition(elem);
            Rectangle2D.Double frm = elem.getBounds();
            if (i3 == 0) {
                dstX = minX;
                vector.add(new Point2D.Double(dstX, pos.y));
                dstX += frm.width;
            } else if (i3 == selectedVector.size() - 1) {
                dstX = pos.x + maxX - pos.x - frm.width;
                vector.add(new Point2D.Double(dstX, pos.y));
            } else {
                vector.add(new Point2D.Double(dstX += leng, pos.y));
                dstX += frm.width;
            }
            ++i3;
        }
        gStructure.move(selectedVector, vector);
    }

    public void doAlignmentVertical() {
        GStructure gStructure = this.sbmodel.getGStructure();
        Vector selectedVector = gStructure.getSelecteds();
        Vector<Point2D.Double> v1 = new Vector<Point2D.Double>();
        Vector<Point2D.Double> v2 = new Vector<Point2D.Double>();
        Vector<Point2D.Double> v3 = new Vector<Point2D.Double>();
        Vector<Point2D.Double> v4 = new Vector<Point2D.Double>();
        int i = 0;
        while (i < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i);
            Point2D.Double pos = GStructure.getPosition(elem);
            Rectangle2D.Double frm = elem.getBounds();
            v1.add(new Point2D.Double(pos.x, pos.y));
            v2.add(new Point2D.Double(pos.x + frm.width, pos.y + frm.height));
            v3.add(new Point2D.Double(pos.x + frm.width * 0.5, pos.y + frm.height * 0.5));
            v4.add(new Point2D.Double(frm.width, frm.height));
            ++i;
        }
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        i = 0;
        while (i < v1.size()) {
            Point2D.Double pos1 = (Point2D.Double)v1.elementAt(i);
            Point2D.Double pos2 = (Point2D.Double)v2.elementAt(i);
            if (minY > pos1.y) {
                minY = pos1.y;
            }
            if (maxY < pos2.y) {
                maxY = pos2.y;
            }
            ++i;
        }
        i = 0;
        while (i < v1.size()) {
            Point2D.Double ctr1 = (Point2D.Double)v3.elementAt(i);
            Point2D.Double frm1 = (Point2D.Double)v4.elementAt(i);
            GElement elm1 = (GElement)selectedVector.elementAt(i);
            int j = i;
            while (j < v1.size()) {
                Point2D.Double ctr2 = (Point2D.Double)v3.elementAt(j);
                Point2D.Double frm2 = (Point2D.Double)v4.elementAt(j);
                GElement elm2 = (GElement)selectedVector.elementAt(j);
                if (ctr1.y > ctr2.y) {
                    v3.setElementAt(ctr2, i);
                    v3.setElementAt(ctr1, j);
                    v4.setElementAt(frm2, i);
                    v4.setElementAt(frm1, j);
                    selectedVector.setElementAt(elm2, i);
                    selectedVector.setElementAt(elm1, j);
                    ctr1 = ctr2;
                    frm1 = frm2;
                    elm1 = elm2;
                }
                ++j;
            }
            ++i;
        }
        double leng = 0.0;
        Point2D.Double frm1 = (Point2D.Double)v4.elementAt(0);
        Point2D.Double frm2 = (Point2D.Double)v4.elementAt(selectedVector.size() - 1);
        leng = maxY - frm2.y - minY - frm1.y;
        int i2 = 1;
        while (i2 < selectedVector.size() - 1) {
            GElement elem = (GElement)selectedVector.elementAt(i2);
            Rectangle2D.Double frm = elem.getBounds();
            leng -= frm.height;
            ++i2;
        }
        leng /= (double)(selectedVector.size() - 1);
        Vector<Point2D.Double> vector = new Vector<Point2D.Double>();
        double dstY = 0.0;
        int i3 = 0;
        while (i3 < selectedVector.size()) {
            GElement elem = (GElement)selectedVector.elementAt(i3);
            Point2D.Double pos = GStructure.getPosition(elem);
            Rectangle2D.Double frm = elem.getBounds();
            if (i3 == 0) {
                dstY = minY;
                vector.add(new Point2D.Double(pos.x, dstY));
                dstY += frm.height;
            } else if (i3 == selectedVector.size() - 1) {
                dstY = pos.y + maxY - pos.y - frm.height;
                vector.add(new Point2D.Double(pos.x, dstY));
            } else {
                vector.add(new Point2D.Double(pos.x, dstY += leng));
                dstY += frm.height;
            }
            ++i3;
        }
        gStructure.move(selectedVector, vector);
    }

    protected boolean isAbleToFinetuning() {
        return this.editor.getSelecteds().size() > 0;
    }

    public void doFinetuning(int e) {
        GStructure gStructure = this.sbmodel.getGStructure();
        if (gStructure.getSelecteds().isEmpty()) {
            return;
        }
        double dx = 1.0;
        double dy = 1.0;
        double x = 0.0;
        double y = 0.0;
        switch (e) {
            case 1: {
                x = 0.0;
                y = -dy;
                break;
            }
            case 2: {
                x = 0.0;
                y = dy;
                break;
            }
            case 3: {
                x = dx;
                y = 0.0;
                break;
            }
            case 4: {
                x = -dx;
                y = 0.0;
            }
        }
        StopWatch.start("key move");
        gStructure.moveSelectedElements(x, y);
        StopWatch.stop("key move");
    }

    public void doSelectAll() {
        GStructure structure = this.sbmodel.getGStructure();
        structure.selectAll();
        this.repaintFrameContents();
        this.sbmodel.fireComponentSelectionChanged();
    }

    public Vector findSpecies(String searchingfor, boolean bID, boolean casesensitive, String matchFlag, boolean single) {
        Vector complexs;
        GStructure gStructure = this.sbmodel.getGStructure();
        gStructure.deselectAll();
        Vector objs = new Vector();
        Vector atoms = gStructure.getAtoms();
        if (atoms != null) {
            objs.addAll(atoms);
        }
        if ((complexs = gStructure.getContainableAtoms()) != null) {
            objs.addAll(complexs);
        }
        Vector<SpeciesAlias> matched = new Vector<SpeciesAlias>();
        int i = 0;
        while (i < objs.size()) {
            String some = null;
            SpeciesAlias alias = (SpeciesAlias)objs.elementAt(i);
            if (bID) {
                some = alias.getOriginalSpecies().getId();
            } else {
                SpeciesProperty property = ((SpeciesShape)((Object)alias.getGFramedShape())).getProperty();
                if (property instanceof MonoSpeciesProperty) {
                    some = ((MonoSpeciesProperty)property).getName();
                }
            }
            if (some != null && CelldUtil.isMatch(some, searchingfor, casesensitive, matchFlag)) {
                matched.add(alias);
            }
            ++i;
        }
        return matched;
    }

    public void scrollToShow(GElement element, boolean deselectflg) {
        GStructure gStructure = this.sbmodel.getGStructure();
        if (deselectflg) {
            gStructure.deselectAll();
        }
        gStructure.select(element);
        this.getSBModel().fireComponentSelectionChanged();
        Rectangle2D.Double elemRect = element.getBounds();
        Rectangle2D.Double viewRect = super.getLogicalViewArea();
        boolean toScroll = false;
        double x = viewRect.x;
        double y = viewRect.y;
        if (elemRect.x < viewRect.x) {
            x = elemRect.x;
            toScroll = true;
        } else if (elemRect.x + elemRect.width > viewRect.x + viewRect.width) {
            x = elemRect.x + elemRect.width - viewRect.width;
            toScroll = true;
        }
        if (elemRect.y < viewRect.y) {
            y = elemRect.y;
            toScroll = true;
        } else if (elemRect.y + elemRect.height > viewRect.y + viewRect.height) {
            y = elemRect.y + elemRect.height - viewRect.height;
            toScroll = true;
        }
        if (toScroll) {
            super.scrollView(x, y);
        } else {
            super.repaintFrameContents();
        }
    }

    public void exportImage(FilePather imageFilePather, String strOutputFileDirName, String strOutputFileName, String strOutputFileExtention) {
        this.exportImage(imageFilePather, strOutputFileDirName, strOutputFileName, strOutputFileExtention, 1.0);
    }

    public void exportImage(FilePather imageFilePather, String strOutputFileDirName, String strOutputFileName, String strOutputFileExtention, double outputscale) {
        if (imageFilePather == null && (strOutputFileDirName == null || strOutputFileName == null || strOutputFileExtention == null)) {
            return;
        }
        int dotposition = 0;
        String modelname = "";
        File file = null;
        String[] formats = ImageIO.getWriterFormatNames();
        if (strOutputFileName != null) {
            String strSeparator = File.separator;
            if (strOutputFileDirName.lastIndexOf(strSeparator) != strOutputFileDirName.length()) {
                strOutputFileDirName = String.valueOf(strOutputFileDirName) + strSeparator;
            }
            if (!(file = new File(String.valueOf(strOutputFileDirName) + strOutputFileName + "." + strOutputFileExtention)).exists()) {
                File dir = new File(strOutputFileDirName);
                if (!dir.exists() && !dir.mkdirs()) {
                    return;
                }
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    return;
                }
            }
        } else {
            modelname = this.getFilename();
            dotposition = modelname.lastIndexOf(".");
            if (dotposition != -1) {
                modelname = modelname.substring(0, dotposition);
            }
            file = imageFilePather.getUserSelection(this, 2, new int[]{203, 201, 200, 204, 202, 999}, modelname);
        }
        if (file == null) {
            return;
        }
        String filepath = file.getPath();
        String extention = "";
        dotposition = filepath.lastIndexOf(".");
        if (dotposition != -1) {
            extention = filepath.substring(dotposition + 1);
        }
        boolean support = false;
        int i = 0;
        while (i < formats.length) {
            if (extention.equals(formats[i])) {
                support = true;
                break;
            }
            ++i;
        }
        boolean isSVG = false;
        if (extention.matches("(s|S)(v|V)(g|G)")) {
            support = true;
            isSVG = true;
        }
        boolean isPDF = false;
        if (extention.matches("(p|P)(d|D)(f|F)")) {
            support = true;
            isPDF = true;
        }
        boolean isEPS = false;
        if (extention.matches("(e|E)(p|P)(s|S)")) {
            support = true;
            isEPS = true;
        }
        if (!support) {
            return;
        }
        Dimension d = this.sbmodel.getModelSize();
        int iOutputW = (int)(d.getWidth() * outputscale);
        int iOutputH = (int)(d.getHeight() * outputscale);
        Rectangle2D.Double clip = new Rectangle2D.Double(0.0, 0.0, iOutputW, iOutputH);
        MainWindow.startProgressBarTask("Exporting Image");
        if (isSVG) {
            DOMImplementation domImpl = SVGDOMImplementation.getDOMImplementation();
            String svgNS = "http://www.w3.org/2000/svg";
            org.w3c.dom.Document doc = domImpl.createDocument(svgNS, "svg", null);
            SVGGraphics2D svg2 = new SVGGraphics2D(doc);
            svg2.setClip((Shape)clip);
            if (Preference.antialias) {
                svg2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            svg2.setColor(Color.white);
            svg2.fillRect(0, 0, iOutputW, iOutputH);
            svg2.scale(outputscale, outputscale);
            this.paintLogicalContents((Graphics2D)svg2);
            boolean useCSS = true;
            try {
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                svg2.stream((Writer)out, useCSS);
                out.flush();
                out.close();
            }
            catch (IOException out) {}
        } else if (isPDF) {
            double dpi = 300.0;
            double scale = 72.0 / dpi;
            Document document = new Document();
            Rectangle angle = new Rectangle((float)((int)((double)iOutputW * scale)), (float)((int)((double)iOutputH * scale)));
            document.setPageSize(angle);
            try {
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                Graphics2D g2 = cb.createGraphicsShapes((float)((int)((double)iOutputW * scale)), (float)((int)((double)iOutputH * scale)));
                g2.scale(outputscale * scale, outputscale * scale);
                this.paintLogicalContents(g2);
                g2.dispose();
                document.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (DocumentException documentException) {}
        } else if (isEPS) {
            Properties p = new Properties();
            p.setProperty("PageSize", "A4");
            try {
                PSGraphics2D g2 = new PSGraphics2D(file, new Dimension(iOutputW, iOutputH));
                g2.setProperties(p);
                g2.startExport();
                g2.setClip((Shape)clip);
                g2.scale(outputscale, outputscale);
                this.paintLogicalContents((Graphics2D)g2);
                g2.endExport();
            }
            catch (Exception g2) {}
        } else {
            BufferedImage img = null;
            if (extention.matches("(p|P)(n|N)(g|G)")) {
                img = new BufferedImage(iOutputW, iOutputH, 3);
            } else if (extention.matches("(j|J)(p|P)(e|E)?(g|G)")) {
                img = new BufferedImage(iOutputW, iOutputH, 1);
            }
            Graphics2D g2 = img.createGraphics();
            g2.setClip(clip);
            if (Preference.antialias) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g2.setColor(Color.white);
            g2.fillRect(0, 0, iOutputW, iOutputH);
            g2.scale(outputscale, outputscale);
            this.paintLogicalContents(g2);
            try {
                ImageIO.write((RenderedImage)img, extention, file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        MainWindow.stopProgressBarTask();
        try {
            String log = "";
            log = imageFilePather != null ? "Export " + this.getFilename() + " as Image" : "Export " + strOutputFileDirName + strOutputFileName + "." + strOutputFileExtention + " as Image";
            SBEventRecorder.addLog(log);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printOut() {
        PagePrinter pp = new PagePrinter(this.sbmodel.getGStructure(), this.sbmodel.getModelSize());
        pp.printOut();
    }

    @Override
    public StatusBar getStatusBar() {
        return super.getStatusBar();
    }

    public JFrame getMyFrame() {
        return this.ownerframe;
    }

    public void resetComboBox() {
        if (this.mainwindowaccess == null) {
            return;
        }
        ((MainWindowAccess)this.mainwindowaccess).resetComboBox();
    }

    public boolean inqSetNameFlg() {
        if (this.mainwindowaccess == null) {
            return false;
        }
        return ((MainWindowAccess)this.mainwindowaccess).inqSetNameFlg();
    }

    public void zoomFit() {
        this.transformer.fitScale();
    }

    public void zoomReset() {
        this.transformer.resetScale();
    }

    public boolean isEditingNotesDialog() {
        return this.notesDialog.isEditing();
    }

    public void cancelNotesDialog() {
        this.notesDialog.cancelButton_selected();
    }

    public boolean isEditingModelNotesDialog() {
        return this.modelNotesDialog.isEditing();
    }

    public boolean isEditingProteinNotesDialog() {
        return this.proteinNotesDialog.isEditing();
    }

    public boolean isComplexViewChangiable() {
        return this.sbmodel.getComplexWithChangableView().size() > 0;
    }

    public void changeSelectedComplexView(int viewInt) {
        GElement processedElem;
        if (!this.isComplexViewChangiable()) {
            return;
        }
        Vector complexes = this.sbmodel.getComplexWithChangableView();
        Vector groups = this.sbmodel.getGStructure().getGroups();
        int i = 0;
        while (i < complexes.size()) {
            ComplexSpeciesAlias csa = (ComplexSpeciesAlias)complexes.elementAt(i);
            if (csa.getCurrentView() != 1) {
                Vector targets = csa.getTargets();
                int j = 0;
                while (j < groups.size()) {
                    GGroup group = (GGroup)groups.elementAt(j);
                    Vector members = group.getMembers();
                    int k = 0;
                    while (k < targets.size()) {
                        if (members.contains(targets.elementAt(k))) {
                            Species cs = csa.getOriginalSpecies();
                            Species es = ((SpeciesAlias)targets.elementAt(k)).getOriginalSpecies();
                            JOptionPane.showMessageDialog(MainWindow.getLastInstance(), "The selected Complex (id=" + cs.getId() + ", name=" + cs.getName() + ") includes " + "a Species (id=" + es.getId() + ", name=" + es.getName() + "), which is also a member of another group.\n" + "Please release the group before changing view of the selected complex.", "Cannot change complex view", 2);
                            return;
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.sbmodel.changeSelectedComplexView(viewInt);
        if (this.mouseInterpreter != null && (processedElem = this.mouseInterpreter.getComplexForChangeView()) != null) {
            Point2D.Double point = GStructure.getPosition(processedElem);
            this.mouseInterpreter.setStartXStartYForChangeView(point);
        }
    }

    public void doIncrementalHierarchicLayout() {
        this.doLayout((YDialog)new IncrementalHierarchicLayoutDialog(this.ownerframe), (YAutoLayout)new IncrementalHierarchicLayoutModule());
    }

    public void doHierarchicLayout() {
        this.doLayout((YDialog)new HierarchicLayoutDialog(this.ownerframe), (YAutoLayout)new HierarchicLayoutModule());
    }

    public void doSmartOrganicLayout() {
        this.doLayout((YDialog)new SmartOrganicLayoutDialog(this.ownerframe), (YAutoLayout)new OrganicLayoutModule());
    }

    public void doOrganicLayout() {
        this.doLayout((YDialog)new ClassicOrganicLayoutDialog(this.ownerframe), (YAutoLayout)new OrganicLayoutModule());
    }

    public void doOrthogonalLayout() {
        this.doLayout((YDialog)new OrthogonalLayoutDialog(this.ownerframe, this.sbmodel.getGStructure()), (YAutoLayout)new OrthogonalLayoutModule());
    }

    public void doOrthogonalEdgeRouter() {
        this.doLayout((YDialog)new OrthogonalEdgeRouterDialog(this.ownerframe), (YAutoLayout)new OrthogonalEdgeRouterModule());
    }

    public void doOrganicEdgeRouter() {
        this.doLayout((YDialog)new OrganicEdgeRouterDialog(this.ownerframe), (YAutoLayout)new OrganicEdgeRouterModule());
    }

    public void doCircularLayout() {
        this.doLayout((YDialog)new CircularLayoutDialog(this.ownerframe), (YAutoLayout)new CircularLayoutModule());
    }

    public void doTreeLayout() {
        this.doLayout((YDialog)new TreeLayoutDialog(this.ownerframe), (YAutoLayout)new TreeLayoutModule());
    }

    private void doLayout(YDialog dialog, YAutoLayout layout) {
        if (dialog.showDialog() == 1) {
            OptionHandler oh = dialog.getOptionHandler();
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog((JComponent)this, dialog.getTitle());
            monitorDialog.setMonitor((IProgressMonitor)new LayoutProgressMonitor(monitorDialog));
            monitorDialog.run((IRunnableWithProgress)new LayoutTask(layout, oh, this));
        }
    }

    public Vector getSelectedProteinEtcVector(String type) {
        Vector<Species> rtnsbase = new Vector<Species>();
        Vector selected = this.getSBModel().getGStructure().getSelecteds();
        if (selected == null || selected.size() == 0) {
            return rtnsbase;
        }
        for (Object obj : selected) {
            if (!(obj instanceof SpeciesAlias)) continue;
            SpeciesAlias sa = (SpeciesAlias)obj;
            SpeciesAnnotation sp = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)sa.getOriginalSpecies(), null);
            if (type.equalsIgnoreCase("Protein") && sa.isMonoProtein()) {
                rtnsbase.add(((MonoSpeciesProperty)sp.getSpeciesProperty()).getProtein());
            }
            if (type.equalsIgnoreCase("Gene") && sa.isMonoGene()) {
                rtnsbase.add(((MonoSpeciesProperty)sp.getSpeciesProperty()).getGene());
            }
            if (type.equalsIgnoreCase("RNA") && sa.isMonoRNA()) {
                rtnsbase.add(((MonoSpeciesProperty)sp.getSpeciesProperty()).getRNA());
            }
            if (!type.equalsIgnoreCase("AntiSenseRNA") || !sa.isMonoAntiSenseRNA()) continue;
            rtnsbase.add(((MonoSpeciesProperty)sp.getSpeciesProperty()).getAntiSenseRNA());
        }
        return rtnsbase;
    }

    public Vector getSelectedProteinEtcByID(SBase[] selected, String type) {
        GStructure gStructure = this.sbmodel.getGStructure();
        Vector atoms = gStructure.getAtoms();
        Vector<Species> rtnsbase = new Vector<Species>();
        Protein pn = null;
        Gene gn = null;
        RNA rna = null;
        AntiSenseRNA sRNA = null;
        SpeciesAlias sa = null;
        Species species = null;
        SpeciesAnnotation sp = null;
        boolean havevalue = false;
        int i = 0;
        while (i < atoms.size()) {
            int k;
            int j;
            havevalue = false;
            sa = (SpeciesAlias)atoms.elementAt(i);
            species = sa.getOriginalSpecies();
            sp = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)sa.getOriginalSpecies(), null);
            if (type.equalsIgnoreCase("Protein") && sa.isMonoProtein()) {
                pn = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getProtein();
                j = 0;
                while (j < selected.length) {
                    if (((Species)selected[j]).getId().equals(pn.getId())) {
                        k = 0;
                        while (k < rtnsbase.size()) {
                            if (((Species)rtnsbase.get(k)).getId().equals(species.getId())) {
                                havevalue = true;
                            }
                            ++k;
                        }
                        if (!havevalue) {
                            rtnsbase.add(species);
                        }
                    }
                    ++j;
                }
            }
            if (type.equalsIgnoreCase("Gene") && sa.isMonoGene()) {
                gn = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getGene();
                j = 0;
                while (j < selected.length) {
                    if (((Species)selected[j]).getId().equals(gn.getId())) {
                        k = 0;
                        while (k < rtnsbase.size()) {
                            if (((Species)rtnsbase.get(k)).getId().equals(species.getId())) {
                                havevalue = true;
                            }
                            ++k;
                        }
                        if (!havevalue) {
                            rtnsbase.add(species);
                        }
                    }
                    ++j;
                }
            }
            if (type.equalsIgnoreCase("RNA") && sa.isMonoRNA()) {
                rna = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getRNA();
                j = 0;
                while (j < selected.length) {
                    if (((Species)selected[j]).getId().equals(rna.getId())) {
                        k = 0;
                        while (k < rtnsbase.size()) {
                            if (((Species)rtnsbase.get(k)).getId().equals(species.getId())) {
                                havevalue = true;
                            }
                            ++k;
                        }
                        if (!havevalue) {
                            rtnsbase.add(species);
                        }
                    }
                    ++j;
                }
            }
            if (type.equalsIgnoreCase("AntiSenseRNA") && sa.isMonoAntiSenseRNA()) {
                sRNA = ((MonoSpeciesProperty)sp.getSpeciesProperty()).getAntiSenseRNA();
                j = 0;
                while (j < selected.length) {
                    if (((Species)selected[j]).getId().equals(sRNA.getId())) {
                        k = 0;
                        while (k < rtnsbase.size()) {
                            if (((Species)rtnsbase.get(k)).getId().equals(species.getId())) {
                                havevalue = true;
                            }
                            ++k;
                        }
                        if (!havevalue) {
                            rtnsbase.add(species);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return rtnsbase;
    }

    public void addLayerTextSymbol(Object selectedObj, LayerManager layer) {
        this.mouseInterpreter.addLayerTextSymbol(selectedObj, layer);
    }

    public void setExportPicImageFileName(String strOutputFileDirName, String strOutputFileName, String strOutputFileExtention) {
        this.strOutputPicFileDirName = strOutputFileDirName;
        this.strOutputPicFileName = strOutputFileName;
        this.strOutputPicFileExtention = strOutputFileExtention;
    }

    public void clearExportPicImageFileName() {
        this.strOutputPicFileDirName = null;
        this.strOutputPicFileName = null;
        this.strOutputPicFileExtention = null;
    }

    public void exportImage(boolean bHaveFileName) {
        this.exportImage(bHaveFileName, 1.0);
    }

    public void exportImage(boolean bHaveFileName, double outputscale) {
        if (!bHaveFileName) {
            return;
        }
        if (this.strOutputPicFileDirName == null || this.strOutputPicFileName == null || this.strOutputPicFileExtention == null) {
            this.clearExportPicImageFileName();
            return;
        }
        try {
            this.exportImage(null, this.strOutputPicFileDirName, this.strOutputPicFileName, this.strOutputPicFileExtention, outputscale);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clearExportPicImageFileName();
    }

    public int getUIType() {
        return this.uiType;
    }

    public void setUIType(int type) {
        this.uiType = type;
    }

    public Vector getSBModelFrameDialogList() {
        this.setSBModelFrameDialogList();
        return this.sbModelFrameDialogList;
    }

    private void setSBModelFrameDialogList() {
        this.sbModelFrameDialogList = new Vector();
        this.sbModelFrameDialogList.add(this.monoPropertyDialog);
        this.sbModelFrameDialogList.add(this.monoPropertyDialogForComplex);
        this.sbModelFrameDialogList.add(this.caDlg);
        this.sbModelFrameDialogList.add(this.rlDlg);
        this.sbModelFrameDialogList.add(this.findDialog);
        this.sbModelFrameDialogList.add(this.modelNotesDialog);
        this.sbModelFrameDialogList.add(this.notesDialog);
        this.sbModelFrameDialogList.add(this.proteinNotesDialog);
        this.sbModelFrameDialogList.add(this.symbolShapeDialog);
        this.sbModelFrameDialogList.add(this.tagPropertyDialog);
        this.sbModelFrameDialogList.add(this.modeldescriptionFrm);
    }

    public void addToControlPanelList(ControlPanelMainWindow controlPanel) {
        this.controlPanelList.add(controlPanel);
    }

    public boolean isControlPanelChanged() {
        boolean isChanged = false;
        int i = 0;
        while (i < this.controlPanelList.size()) {
            ControlPanelMainWindow controlPanel = (ControlPanelMainWindow)this.controlPanelList.get(i);
            if (controlPanel != null) {
                boolean bl = isChanged = isChanged || controlPanel.isChanged();
                if (isChanged) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public void showResourceOfDescriptionOfReactionDialog() {
        Object selected;
        Vector selecteds = this.editor.getSelecteds();
        if (selecteds.size() == 1 && (selected = selecteds.elementAt(0)) instanceof ReactionLink) {
            GLinkedShape lnkshp = ((ReactionLink)selected).getGLinkedShape();
            if (lnkshp instanceof DirectSingleLine) {
                return;
            }
            this.descriptionDlg.showResourceOfDescriptionOfReaction((ReactionLink)selected);
            return;
        }
    }

    public void doSBOTermValueChange(JCheckBoxMenuItem sboTermNotCareItem, JCheckBoxMenuItem sboTermSetItem, JCheckBoxMenuItem sboTermRemoveItem, int sboTermValueView) {
        Preference.SBOTERMVALUE_VIEW = sboTermValueView;
        sboTermNotCareItem.setSelected(Preference.isSelected_SBOTermNotCare());
        sboTermSetItem.setSelected(Preference.isSelected_SBOTermSET());
        sboTermRemoveItem.setSelected(Preference.isSelected_SBOTermREMOVE());
        if (sboTermValueView != 0) {
            Model model = null;
            try {
                model = this.getSBModel().getModel();
                if (model == null) {
                    return;
                }
            }
            catch (Exception myErr) {
                return;
            }
            this.getSBModel().setSBOTerm(model);
        }
    }

    public void showModelDescriptionFrm() {
        Model model = this.sbmodel.getModel();
        this.modeldescriptionFrm.setTitle("Model Description (id=" + model.getId() + "; " + this.getFilename() + ")");
        ModelAnnotation mExt = (ModelAnnotation)LibSBMLUtil.getAnnotation(this.sbmodel, (SBase)model, null);
        this.modeldescriptionFrm.showInitializedWin(mExt.getModelDescription());
    }

    public boolean IsModelDescriptionFrmBeenUsing() {
        return this.modeldescriptionFrm.IsWinBeenUsing();
    }

    public SBase getSelectedSBase() {
        int signature = this.getSelectedObjectSignature();
        Vector selecteds = this.editor.getSelecteds();
        if (signature == 4) {
            String strScope = LibSBMLUtil.getParameterScope((Parameter)this.selectedsbase);
            if ("global".equals(strScope)) {
                return this.selectedsbase;
            }
        } else {
            Object selected;
            if (signature == 5) {
                return this.selectedsbase;
            }
            if (signature == 6) {
                return this.selectedsbase;
            }
            if (signature == 7) {
                return this.selectedsbase;
            }
            if (signature == 8) {
                return this.selectedsbase;
            }
            if (signature == 2) {
                String strPanelName = MainWindow.getLastInstance().getSelectedPanelName();
                if ("Proteins".equals(strPanelName) || "Genes".equals(strPanelName) || "RNAs".equals(strPanelName) || "asRNAs".equals(strPanelName)) {
                    return null;
                }
                Object selected2 = selecteds.elementAt(0);
                if (selected2 instanceof SpeciesAlias) {
                    SpeciesListPanel speciesListPanel;
                    ArrayList diaplay;
                    SpeciesAlias speciesAlias = (SpeciesAlias)selected2;
                    Species species = speciesAlias.getOriginalSpecies();
                    SBMLPanelLists sbmlpanellists = this.getSBModel().getSBMLPanelLists();
                    SBaseListPanel sBaseListPanelOfSpecies = sbmlpanellists.getSBaseListPanel(3);
                    if (sBaseListPanelOfSpecies instanceof SpeciesListPanel && (diaplay = (speciesListPanel = (SpeciesListPanel)sBaseListPanelOfSpecies).getDisplayList()) != null) {
                        int cnt = 0;
                        while (cnt < diaplay.size()) {
                            Species speciestemp = (Species)diaplay.get(cnt);
                            if (speciestemp != null && speciestemp.getId() != null && speciestemp.getId().equals(species.getId())) {
                                return species;
                            }
                            ++cnt;
                        }
                    }
                }
            } else if (signature == 1) {
                Object selected3 = selecteds.elementAt(0);
                if (selected3 instanceof CompartmentAlias) {
                    CompartmentAlias compartmentAlias = (CompartmentAlias)selected3;
                    Compartment compartment = compartmentAlias.getOriginalCompartment();
                    return compartment;
                }
            } else if (signature == 3 && (selected = selecteds.elementAt(0)) instanceof ReactionLink) {
                GLinkedShape lnkshp = ((ReactionLink)selected).getGLinkedShape();
                if (lnkshp instanceof DirectSingleLine) {
                    return null;
                }
                ReactionLink reactionLink = (ReactionLink)selected;
                return reactionLink.getParentReaction();
            }
        }
        return null;
    }

    public void showUnitInfoDialog() {
        Vector selecteds = this.editor.getSelecteds();
        if (selecteds.size() == 1) {
            Object selected = selecteds.elementAt(0);
            if (selected == null) {
                return;
            }
            if (selected instanceof CompartmentAlias) {
                this.csDlg.showAliasProperty(selected, 0);
                this.sbmodel.getGStructure().deselectAll();
            } else if (selected instanceof SpeciesAlias) {
                this.csDlg.showAliasProperty(selected, 1);
                this.sbmodel.getGStructure().deselectAll();
            }
        }
    }

    public BufferedImage getExportBufferedImage(double outputscale) {
        Dimension dim = this.sbmodel.getModelSize();
        int iOutputW = (int)(dim.getWidth() * outputscale);
        int iOutputH = (int)(dim.getHeight() * outputscale);
        Rectangle2D.Double clip = new Rectangle2D.Double(0.0, 0.0, iOutputW, iOutputH);
        BufferedImage img = new BufferedImage(iOutputW, iOutputH, 6);
        Graphics2D g2 = img.createGraphics();
        g2.setClip(clip);
        if (Preference.antialias) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2.setColor(Color.white);
        g2.fillRect(0, 0, iOutputW, iOutputH);
        g2.scale(outputscale, outputscale);
        this.paintLogicalContents(g2);
        return img;
    }

    private class MyAdjustmentListenerH
    implements AdjustmentListener {
        private MyAdjustmentListenerH() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent evt) {
        }
    }

    private class MyAdjustmentListenerV
    implements AdjustmentListener {
        private MyAdjustmentListenerV() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent evt) {
        }
    }
}

