/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.util.Vector;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GContainerTarget;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelNamespace;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.ListOfSpecies;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class SBModelConverter {
    public static boolean convertToS22(SBModel sbmodel, SBModelNamespace namespace) {
        GElement container;
        Model model = sbmodel.getModel();
        GStructure gStructure = sbmodel.getGStructure();
        boolean isC1 = true;
        Vector aliases = gStructure.getAtoms();
        GContainer one_container = null;
        boolean isFirst = true;
        int i = 0;
        while (i < aliases.size()) {
            int pos;
            GContainerTarget atom = (GContainerTarget)aliases.elementAt(i);
            GContainer container2 = atom.getContainer();
            if (isFirst) {
                one_container = container2;
                if (container2 != null && (pos = container2.includes(atom)) != 4) {
                    if (Preference.isDebug) {
                        System.out.println("reading 1.0, isC1=false, isFirst, pos=" + pos);
                    }
                    isC1 = false;
                    break;
                }
                isFirst = false;
            } else if (one_container == null) {
                if (container2 != null) {
                    if (Preference.isDebug) {
                        System.out.println("reading 1.0, isC1=false, one_container==null && container != null)");
                    }
                    isC1 = false;
                    break;
                }
            } else {
                if (container2 == null) {
                    if (Preference.isDebug) {
                        System.out.println("reading 1.0, isC1=false, one_container!=null but container == null");
                    }
                    isC1 = false;
                    break;
                }
                if (one_container != container2) {
                    if (Preference.isDebug) {
                        System.out.println("reading 1.0, isC1=false, one_container != container");
                    }
                    isC1 = false;
                    break;
                }
                pos = container2.includes(atom);
                if (pos != 4) {
                    if (Preference.isDebug) {
                        System.out.println("reading 1.0, isC1=false, pos=" + pos);
                    }
                    isC1 = false;
                    break;
                }
            }
            ++i;
        }
        if (isC1) {
            if (Preference.isDebug) {
                System.out.println("reading 1.0, isC1==true");
            }
            ListOfSpecies listOfSpecies = model.getListOfSpecies();
            int i2 = 0;
            while ((long)i2 < listOfSpecies.size()) {
                Species s = (Species)listOfSpecies.get((long)i2);
                SpeciesAnnotation sExt = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)s, null);
                sExt.setPositionToCompartment(4);
                ++i2;
            }
            return true;
        }
        Vector links = (Vector)gStructure.getLinks().clone();
        int i3 = links.size() - 1;
        while (i3 >= 0) {
            GElement link = (GElement)links.elementAt(i3);
            gStructure.remove(link);
            --i3;
        }
        Vector atoms = (Vector)gStructure.getAtoms().clone();
        int i4 = atoms.size() - 1;
        while (i4 >= 0) {
            GElement atom = (GElement)atoms.elementAt(i4);
            gStructure.remove(atom);
            --i4;
        }
        Vector containers = (Vector)gStructure.getContainers().clone();
        int i5 = containers.size() - 1;
        while (i5 >= 0) {
            container = (GElement)containers.elementAt(i5);
            gStructure.remove(container);
            --i5;
        }
        i5 = 0;
        while (i5 < containers.size()) {
            container = (GElement)containers.elementAt(i5);
            gStructure.add(container);
            ++i5;
        }
        i5 = 0;
        while (i5 < atoms.size()) {
            GElement atom = (GElement)atoms.elementAt(i5);
            gStructure.add(atom);
            ++i5;
        }
        i5 = 0;
        while (i5 < links.size()) {
            GElement link = (GElement)links.elementAt(i5);
            gStructure.add(link);
            ++i5;
        }
        sbmodel.getRecorder().clearEvents();
        i5 = 0;
        while (i5 < atoms.size()) {
            SpeciesAlias alias = (SpeciesAlias)atoms.elementAt(i5);
            namespace.changeSpeciesReferenceIds(alias);
            ++i5;
        }
        return false;
    }

    public static void fixSpeciesReference(SBModel sbmodel, SBModelNamespace namespace) {
        Model model = sbmodel.getModel();
        GStructure gStructure = sbmodel.getGStructure();
        Vector atoms = (Vector)gStructure.getAtoms().clone();
        int i = 0;
        while (i < atoms.size()) {
            SpeciesAlias alias = (SpeciesAlias)atoms.elementAt(i);
            namespace.changeSpeciesReferenceIds(alias);
            ++i;
        }
    }
}

