/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import jp.fric.graphics.multiwindow.ContentsFiler;
import jp.fric.graphics.multiwindow.MultiWindowFrame;
import jp.fric.io.util.FilePather;
import jp.fric.io.util.FileSuffixFilter;
import jp.fric.ui.DocumentDialog;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MiriamMainPanel;
import jp.sbi.celldesigner.MyTreePanel;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SBModelListener;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.celldesigner.util.CelldUtil;
import jp.sbi.sbml.SIdFormatException;
import jp.sbi.sbml.SpecInfo;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.SBMLPanelLists;
import jp.sbi.sbml.util.SBMLValidator;
import jp.sbi.sbml.util.SBaseListPanel;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBMLDocument;
import org.sbml.libsbml.SBMLReader;
import org.sbml.libsbml.SBMLWriter;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.XMLNode;
import org.sbml.libsbml.libsbml;

public class SBMLFiler
implements ContentsFiler {
    static final String[] SUFFIX = new String[]{"xml", "sbml"};
    static final FileSuffixFilter suffixFilter = new FileSuffixFilter(SUFFIX);
    SBFactory factory;
    SBMLPanelLists sbmlPanelLists = null;
    SBaseListPanel proteinListPanel = null;
    SBaseListPanel geneListPanel = null;
    SBaseListPanel rnaListPanel = null;
    SBaseListPanel antisensernaListPanel = null;
    JFrame ownerFrame = null;
    MyTreePanel myTreePanel = null;
    public static final boolean DEFAULT_VALIDATION_ENABLED_FLAG = true;
    public static final boolean DEFAULT_IGNORE_WARNING_FLAG = false;
    private boolean isValidationEnabled = true;
    private boolean ignoreWarning = false;
    public static SpecInfo outputSpec = new SpecInfo();
    private static final String USE_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890()-_+:.%*/\\ ";

    public SBMLFiler(SBFactory factory) {
        this.factory = factory;
    }

    public void setSBMLPanelLists(SBMLPanelLists sbmlPanelLists, SBaseListPanel proteinListPanel, SBaseListPanel geneListPanel, SBaseListPanel rnaListPanel, SBaseListPanel antisensernaListPanel, MyTreePanel myTree) {
        this.sbmlPanelLists = sbmlPanelLists;
        this.proteinListPanel = proteinListPanel;
        this.geneListPanel = geneListPanel;
        this.rnaListPanel = rnaListPanel;
        this.antisensernaListPanel = antisensernaListPanel;
        this.myTreePanel = myTree;
    }

    public void setOwnerFrame(JFrame owner) {
        this.ownerFrame = owner;
    }

    @Override
    public String[] openingSuffixes() {
        return SUFFIX;
    }

    @Override
    public String openingDescription() {
        return "XML files";
    }

    @Override
    public String[] savingSuffixes() {
        return SUFFIX;
    }

    @Override
    public String savingDescription() {
        return "XML files";
    }

    @Override
    public MultiWindowFrame read(File filepath) throws Exception {
        return this.read(filepath, false);
    }

    public MultiWindowFrame read(File filepath, boolean inProcessPluginOpenNewModelCmd) throws Exception {
        Model model;
        SBMLDocument sbmlDocument;
        block21: {
            if (!suffixFilter.accept(filepath)) {
                throw new Exception("unknown suffix");
            }
            sbmlDocument = null;
            if (!SBMLFiler.isAllowedFileName(filepath.getAbsolutePath())) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filepath), "UTF-8"));
                StringBuffer buf = new StringBuffer();
                while ((line = in.readLine()) != null) {
                    buf.append(line);
                    buf.append("\n");
                }
                in.close();
                sbmlDocument = libsbml.readSBMLFromString((String)buf.toString());
                buf = null;
                in = null;
                line = null;
            } else {
                SBMLReader reader = new SBMLReader();
                sbmlDocument = reader.readSBML(filepath.getAbsolutePath());
                reader.delete();
            }
            model = sbmlDocument.getModel();
            if (model != null) break block21;
            if (!MainWindow.isIgnorAllCheckAndMessageNotice()) {
                LibSBMLUtil.checkSBMLFatalErrorAndShowErrorMessage(sbmlDocument, this.ownerFrame, new String[]{"Close"});
            }
            return null;
        }
        long level = model.getLevel();
        long version = model.getVersion();
        if (level == 2L && version > 4L || level > 2L) {
            String errmsg = filepath + "\n" + "SBML Level " + level + " version " + version + " is not supported";
            throw new Exception(errmsg);
        }
        if (!MainWindow.isIgnorAllCheckAndMessageNotice() && this.isValidationEnabled) {
            if (!this.ignoreWarning) {
                LibSBMLUtil.checkSBMLConsistencyAndShowMessage(sbmlDocument, this.ownerFrame, new String[]{"OK"});
            } else {
                LibSBMLUtil.checkSBMLConsistencyAndShowErrorMessage(sbmlDocument, this.ownerFrame, new String[]{"OK"});
            }
        }
        LibSBMLUtil.setParameterAnnotation((ListOf)sbmlDocument.getModel().getListOfReactions());
        if (sbmlDocument.getLevel() == 1L) {
            sbmlDocument.setLevelAndVersion(2L, 4L);
        }
        if (Preference.isDebug) {
            System.out.println("create SBModel");
        }
        SBModel sbmodel = new SBModel(sbmlDocument, this.factory, this.sbmlPanelLists, this.proteinListPanel, this.geneListPanel, this.rnaListPanel, this.antisensernaListPanel, this.myTreePanel);
        sbmodel.addSBModelListener((SBModelListener)((Object)this.ownerFrame));
        if (Preference.isDebug) {
            System.out.println("created SBModel");
        }
        Dimension size = this.defaultSize();
        boolean hasSize = false;
        Dimension dispSize = sbmodel.getModelSize();
        if (dispSize != null && dispSize.width != 0 && dispSize.height != 0) {
            size = dispSize;
            hasSize = true;
        }
        if (!hasSize) {
            sbmodel.setModelSize(size);
        }
        if (Preference.isDebug) {
            System.out.println("create SBModelFrame");
        }
        SBModelFrame sbframe = new SBModelFrame(this.ownerFrame, size, sbmodel);
        if (inProcessPluginOpenNewModelCmd) {
            sbframe.setPath(filepath, "newModel");
        } else {
            sbframe.setPath(filepath);
        }
        if (Preference.isDebug) {
            System.out.println("created SBModelFrame");
        }
        System.gc();
        return sbframe;
    }

    @Override
    public MultiWindowFrame read(StringBuffer sbuf) throws Exception {
        Model model;
        SBMLDocument sbmlDocument;
        block15: {
            sbmlDocument = new SBMLDocument();
            sbmlDocument = libsbml.readSBMLFromString((String)sbuf.toString());
            LibSBMLUtil.setParameterAnnotation((ListOf)sbmlDocument.getModel().getListOfReactions());
            model = sbmlDocument.getModel();
            if (model != null) break block15;
            if (!MainWindow.isIgnorAllCheckAndMessageNotice()) {
                LibSBMLUtil.checkSBMLFatalErrorAndShowErrorMessage(sbmlDocument, this.ownerFrame, new String[]{"Close"});
            }
            return null;
        }
        long level = model.getLevel();
        long version = model.getVersion();
        if (level == 2L && version > 4L || level > 2L) {
            String errmsg = "SBML Level " + level + " version " + version + " is not supported";
            throw new Exception(errmsg);
        }
        if (!MainWindow.isIgnorAllCheckAndMessageNotice() && this.isValidationEnabled) {
            if (!this.ignoreWarning) {
                LibSBMLUtil.checkSBMLConsistencyAndShowMessage(sbmlDocument, this.ownerFrame, new String[]{"OK"});
            } else {
                LibSBMLUtil.checkSBMLConsistencyAndShowErrorMessage(sbmlDocument, this.ownerFrame, new String[]{"OK"});
            }
        }
        if (sbmlDocument.getLevel() == 1L) {
            sbmlDocument.setLevelAndVersion(2L, 4L);
        }
        if (Preference.isDebug) {
            System.out.println("create SBModel");
        }
        SBModel sbmodel = new SBModel(sbmlDocument, this.factory, this.sbmlPanelLists, this.proteinListPanel, this.geneListPanel, this.rnaListPanel, this.antisensernaListPanel, this.myTreePanel);
        sbmodel.addSBModelListener((SBModelListener)((Object)this.ownerFrame));
        if (Preference.isDebug) {
            System.out.println("created SBModel");
        }
        Dimension size = this.defaultSize();
        boolean hasSize = false;
        Dimension dispSize = sbmodel.getModelSize();
        if (dispSize != null && dispSize.width != 0 && dispSize.height != 0) {
            size = dispSize;
            hasSize = true;
        }
        if (!hasSize) {
            sbmodel.setModelSize(size);
        }
        if (Preference.isDebug) {
            System.out.println("create SBModelFrame");
        }
        SBModelFrame sbframe = new SBModelFrame(this.ownerFrame, size, sbmodel);
        if (Preference.isDebug) {
            System.out.println("created SBModelFrame");
        }
        System.gc();
        return sbframe;
    }

    @Override
    public MultiWindowFrame read(InputStream is, int level, int version) throws Exception {
        int b;
        SBMLDocument sbmlDocument = new SBMLDocument();
        Model model = sbmlDocument.getModel();
        if (model == null) {
            if (!MainWindow.isIgnorAllCheckAndMessageNotice()) {
                LibSBMLUtil.checkSBMLFatalErrorAndShowErrorMessage(sbmlDocument, this.ownerFrame, new String[]{"Close"});
            }
            return null;
        }
        if (level == 2 && version > 4 || level > 2) {
            String errmsg = "SBML Level " + level + " version " + version + " is not supported";
            throw new Exception(errmsg);
        }
        if (!MainWindow.isIgnorAllCheckAndMessageNotice() && this.isValidationEnabled) {
            if (!this.ignoreWarning) {
                LibSBMLUtil.checkSBMLConsistencyAndShowMessage(sbmlDocument, this.ownerFrame, new String[]{"OK"});
            } else {
                LibSBMLUtil.checkSBMLConsistencyAndShowErrorMessage(sbmlDocument, this.ownerFrame, new String[]{"OK"});
            }
        }
        StringBuffer buf = new StringBuffer();
        while ((b = is.read()) != -1) {
            buf.append(Integer.toBinaryString(b));
        }
        SBMLReader reader = new SBMLReader();
        sbmlDocument = reader.readSBMLFromString(buf.toString());
        if (sbmlDocument.getLevel() == 1L) {
            sbmlDocument.setLevelAndVersion(2L, 4L);
        }
        SBModel sbmodel = new SBModel(sbmlDocument, this.factory, this.sbmlPanelLists, this.proteinListPanel, this.geneListPanel, this.rnaListPanel, this.antisensernaListPanel, this.myTreePanel);
        sbmodel.addSBModelListener((SBModelListener)((Object)this.ownerFrame));
        Dimension size = this.defaultSize();
        boolean hasSize = false;
        Dimension dispSize = sbmodel.getModelSize();
        if (dispSize != null && dispSize.width != 0 && dispSize.height != 0) {
            size = dispSize;
            hasSize = true;
        }
        if (!hasSize) {
            sbmodel.setModelSize(size);
        }
        SBModelFrame sbframe = new SBModelFrame(this.ownerFrame, size, sbmodel);
        boolean initOK = sbmodel.start(this.ownerFrame);
        if (this.ownerFrame != null) {
            this.ownerFrame.repaint();
        }
        if (initOK) {
            return sbframe;
        }
        return null;
    }

    private void setXMLNamespace(SBMLDocument sbmlDocument) {
        String ns = ModelAnnotation.getOutputNamespace();
        String uri = "http://www.sbml.org/2001/ns/celldesigner";
        sbmlDocument.getNamespaces().add(ns, uri);
    }

    @Override
    public void write(File filepath, MultiWindowFrame mwframe) throws Exception {
        Throwable throwable;
        block61: {
            SBModel sbmodel;
            block60: {
                if (!suffixFilter.accept(filepath)) {
                    throw new Exception("unknown suffix");
                }
                SBModelFrame sbframe = (SBModelFrame)mwframe;
                sbmodel = sbframe.getSBModel();
                SBMLDocument sbmlDocument = sbmodel.getSBMLDocument();
                SpecInfo currentDocumentSpec = new SpecInfo(sbmlDocument.getLevel(), sbmlDocument.getVersion());
                sbmlDocument.setLevelAndVersion((long)outputSpec.getLevel(), (long)outputSpec.getVersion());
                throwable = null;
                try {
                    try {
                        SBMLWriter writer;
                        OutputStreamWriter out;
                        int choice;
                        Model model;
                        sbmodel.prepareSave();
                        SBMLDocument outputsbmlDocument = LibSBMLUtil.updateNotesAndAnnotation(sbmlDocument, sbmodel);
                        if (outputSpec.getLevel() == 1) {
                            sbmodel.prepareSaveForLevel1();
                        }
                        if ((model = outputsbmlDocument.getModel()) == null) {
                            if (!MainWindow.isIgnorAllCheckAndMessageNotice()) {
                                LibSBMLUtil.checkSBMLFatalErrorAndShowErrorMessage(outputsbmlDocument, this.ownerFrame, new String[]{"Close"});
                            }
                            throw new Exception("canceled");
                        }
                        if (!MainWindow.isIgnorAllCheckAndMessageNotice() && this.isValidationEnabled && (!this.ignoreWarning ? (choice = LibSBMLUtil.checkSBMLConsistencyAndShowMessage(outputsbmlDocument, this.ownerFrame, new String[]{"Save", "Cancel"})) == 1 : (choice = LibSBMLUtil.checkSBMLConsistencyAndShowErrorMessage(outputsbmlDocument, this.ownerFrame, new String[]{"Save", "Cancel"})) == 1)) {
                            throw new Exception("canceled");
                        }
                        if (!SBMLFiler.isAllowedFileName(filepath.getAbsolutePath())) {
                            try {
                                out = new OutputStreamWriter((OutputStream)new FileOutputStream(filepath.getAbsolutePath()), "UTF-8");
                                writer = new SBMLWriter();
                                out.write(this.deleteIndent(writer.writeToString(outputsbmlDocument)));
                                out.close();
                                out = null;
                            }
                            catch (Exception out2) {}
                        } else {
                            out = new OutputStreamWriter((OutputStream)new FileOutputStream(filepath.getAbsolutePath()), "UTF-8");
                            writer = new SBMLWriter();
                            out.write(this.deleteIndent(writer.writeToString(outputsbmlDocument)));
                            out.close();
                            out = null;
                        }
                        LibSBMLUtil.setParameterAnnotation((ListOf)sbmodel.getModel().getListOfReactions());
                        outputsbmlDocument.getModel().unsetAnnotation();
                        int i = 0;
                        while ((long)i < outputsbmlDocument.getModel().getNumSpecies()) {
                            outputsbmlDocument.getModel().getSpecies((long)i).unsetAnnotation();
                            outputsbmlDocument.getModel().getSpecies((long)i).unsetNotes();
                            ++i;
                        }
                        i = 0;
                        while ((long)i < outputsbmlDocument.getModel().getNumReactions()) {
                            outputsbmlDocument.getModel().getReaction((long)i).unsetAnnotation();
                            outputsbmlDocument.getModel().getReaction((long)i).unsetNotes();
                            ++i;
                        }
                        i = 0;
                        while ((long)i < outputsbmlDocument.getModel().getNumCompartments()) {
                            outputsbmlDocument.getModel().getCompartment((long)i).unsetAnnotation();
                            outputsbmlDocument.getModel().getCompartment((long)i).unsetNotes();
                            ++i;
                        }
                        i = 0;
                        while ((long)i < outputsbmlDocument.getModel().getNumParameters()) {
                            outputsbmlDocument.getModel().getParameter((long)i).unsetAnnotation();
                            outputsbmlDocument.getModel().getParameter((long)i).unsetNotes();
                            ++i;
                        }
                        i = 0;
                        while ((long)i < outputsbmlDocument.getModel().getNumFunctionDefinitions()) {
                            outputsbmlDocument.getModel().getFunctionDefinition((long)i).unsetAnnotation();
                            outputsbmlDocument.getModel().getFunctionDefinition((long)i).unsetNotes();
                            ++i;
                        }
                        i = 0;
                        while ((long)i < outputsbmlDocument.getModel().getNumUnitDefinitions()) {
                            outputsbmlDocument.getModel().getUnitDefinition((long)i).unsetAnnotation();
                            outputsbmlDocument.getModel().getUnitDefinition((long)i).unsetNotes();
                            ++i;
                        }
                        i = 0;
                        while ((long)i < outputsbmlDocument.getModel().getNumRules()) {
                            outputsbmlDocument.getModel().getRule((long)i).unsetAnnotation();
                            outputsbmlDocument.getModel().getRule((long)i).unsetNotes();
                            ++i;
                        }
                        i = 0;
                        while ((long)i < outputsbmlDocument.getModel().getNumEvents()) {
                            outputsbmlDocument.getModel().getEvent((long)i).unsetAnnotation();
                            outputsbmlDocument.getModel().getEvent((long)i).unsetNotes();
                            ++i;
                        }
                        i = 0;
                        while ((long)i < outputsbmlDocument.getModel().getNumSpeciesTypes()) {
                            outputsbmlDocument.getModel().getSpeciesType((long)i).unsetAnnotation();
                            outputsbmlDocument.getModel().getSpeciesType((long)i).unsetNotes();
                            ++i;
                        }
                        i = 0;
                        while ((long)i < outputsbmlDocument.getModel().getNumCompartmentTypes()) {
                            outputsbmlDocument.getModel().getCompartmentType((long)i).unsetAnnotation();
                            outputsbmlDocument.getModel().getCompartmentType((long)i).unsetNotes();
                            ++i;
                        }
                        i = 0;
                        while ((long)i < outputsbmlDocument.getModel().getNumInitialAssignments()) {
                            outputsbmlDocument.getModel().getInitialAssignment((long)i).unsetAnnotation();
                            outputsbmlDocument.getModel().getInitialAssignment((long)i).unsetNotes();
                            ++i;
                        }
                        i = 0;
                        while ((long)i < outputsbmlDocument.getModel().getNumConstraints()) {
                            outputsbmlDocument.getModel().getConstraint((long)i).unsetAnnotation();
                            outputsbmlDocument.getModel().getConstraint((long)i).unsetNotes();
                            ++i;
                        }
                        outputsbmlDocument.delete();
                        outputsbmlDocument = null;
                        System.gc();
                        break block60;
                    }
                    catch (Throwable t) {
                        String message = t.getMessage();
                        if (message != null && message.equals("canceled")) {
                            throw (Exception)t;
                        }
                        throwable = t;
                        try {
                            int i = 0;
                            while ((long)i < sbmodel.getModel().getNumReactions()) {
                                try {
                                    SBMLFiler.resetAnnotationOfMiriam((SBase)sbmodel.getModel().getReaction((long)i));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ++i;
                            }
                            i = 0;
                            while ((long)i < sbmodel.getModel().getNumSpecies()) {
                                try {
                                    SBMLFiler.resetAnnotationOfMiriam((SBase)sbmodel.getModel().getSpecies((long)i));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ++i;
                            }
                            i = 0;
                            while ((long)i < sbmodel.getModel().getNumCompartments()) {
                                try {
                                    SBMLFiler.resetAnnotationOfMiriam((SBase)sbmodel.getModel().getCompartment((long)i));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ++i;
                            }
                            break block61;
                        }
                        catch (Exception i) {}
                        break block61;
                    }
                }
                catch (Throwable throwable2) {
                    try {
                        int i = 0;
                        while ((long)i < sbmodel.getModel().getNumReactions()) {
                            try {
                                SBMLFiler.resetAnnotationOfMiriam((SBase)sbmodel.getModel().getReaction((long)i));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++i;
                        }
                        i = 0;
                        while ((long)i < sbmodel.getModel().getNumSpecies()) {
                            try {
                                SBMLFiler.resetAnnotationOfMiriam((SBase)sbmodel.getModel().getSpecies((long)i));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++i;
                        }
                        i = 0;
                        while ((long)i < sbmodel.getModel().getNumCompartments()) {
                            try {
                                SBMLFiler.resetAnnotationOfMiriam((SBase)sbmodel.getModel().getCompartment((long)i));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++i;
                        }
                    }
                    catch (Exception i) {
                        // empty catch block
                    }
                }
                throw throwable2;
            }
            try {
                int i = 0;
                while ((long)i < sbmodel.getModel().getNumReactions()) {
                    try {
                        SBMLFiler.resetAnnotationOfMiriam((SBase)sbmodel.getModel().getReaction((long)i));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                i = 0;
                while ((long)i < sbmodel.getModel().getNumSpecies()) {
                    try {
                        SBMLFiler.resetAnnotationOfMiriam((SBase)sbmodel.getModel().getSpecies((long)i));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                i = 0;
                while ((long)i < sbmodel.getModel().getNumCompartments()) {
                    try {
                        SBMLFiler.resetAnnotationOfMiriam((SBase)sbmodel.getModel().getCompartment((long)i));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (throwable != null) {
            throw new Exception(throwable);
        }
    }

    private String deleteIndent(String sbmlString) {
        StringTokenizer tokenizer = new StringTokenizer(sbmlString, "\n");
        StringBuffer writeBuf = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String tokenLine = tokenizer.nextToken();
            int index = 0;
            index = tokenLine.indexOf("<");
            if (index > 0) {
                writeBuf.append(String.valueOf(tokenLine.substring(index, tokenLine.length())) + "\n");
                continue;
            }
            writeBuf.append(String.valueOf(tokenLine) + "\n");
        }
        return writeBuf.toString();
    }

    @Override
    public MultiWindowFrame createNewFrame(Frame frame) {
        DocumentDialog dlg = new DocumentDialog();
        dlg.setDocumentName(this.defaultName());
        dlg.setDocumentSize(this.defaultSize());
        dlg.setDialogTitle("New Document");
        int rtn = dlg.showDialog(frame);
        if (rtn == 1) {
            SBMLDocument sbmlDocument = new SBMLDocument();
            sbmlDocument.createModel();
            sbmlDocument.setLevelAndVersion(2L, 4L);
            sbmlDocument.getNamespaces().add("http://www.sbml.org/2001/ns/celldesigner", "celldesigner");
            sbmlDocument.getModel().setAnnotation("<annotation xmlns:celldesigner=\"http://www.sbml.org/2001/ns/celldesigner\">\n<celldesigner:extension><celldesigner:modelVersion>0.0</celldesigner:modelVersion>\n<celldesigner:modelDisplay sizeX=\"600\" sizeY=\"400\"/>\n</celldesigner:extension></annotation>");
            sbmlDocument.getModel().setId(dlg.getDocumentName());
            SBModel sbmodel = null;
            try {
                sbmodel = new SBModel(sbmlDocument, this.factory, this.sbmlPanelLists, this.proteinListPanel, this.geneListPanel, this.rnaListPanel, this.antisensernaListPanel, this.myTreePanel);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sbmodel.addSBModelListener((SBModelListener)((Object)this.ownerFrame));
            String name = dlg.getDocumentName();
            try {
                sbmodel.setModelName(name);
            }
            catch (SIdFormatException e) {
                JOptionPane.showMessageDialog(frame, e.getMessage(), "Confirmation", 2);
                return null;
            }
            Dimension size = dlg.getDocumentSize();
            sbmodel.setModelSize(size);
            SBModelFrame sbframe = new SBModelFrame(this.ownerFrame, size, sbmodel);
            sbframe.setFilename(dlg.getDocumentName());
            sbmodel.start(this.ownerFrame);
            return sbframe;
        }
        return null;
    }

    @Override
    public String defaultName() {
        return "untitled";
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(600, 400);
    }

    public void export(SBModelFrame sbframe, FilePather pather, SpecInfo spec) {
        File file = pather.getUserSelection((Component)sbframe, 2, this.savingSuffixes(), this.savingDescription(), this.defaultName());
        this.export(sbframe, file, spec);
    }

    public void export(SBModelFrame sbframe, File file, SpecInfo spec) {
        if (file == null) {
            return;
        }
        SpecInfo currentOutputSpec = outputSpec;
        outputSpec = spec;
        try {
            if (!suffixFilter.accept(file)) {
                throw new Exception("unknown suffix");
            }
            SBModel sbmodel = sbframe.getSBModel();
            SBMLDocument sbmlDocument = sbmodel.getSBMLDocument();
            SBMLDocument targetDoc = null;
            try {
                targetDoc = outputSpec.getLevel() >= 2 ? LibSBMLUtil.getPureSBMLAnnotationDocument(sbmlDocument, outputSpec, false, true) : LibSBMLUtil.getPureSBMLAnnotationDocument(sbmlDocument, outputSpec, true, true);
            }
            catch (Exception e) {
                throw new Exception();
            }
            sbmodel.setSBOTerm(sbmlDocument.getModel());
            CelldUtil.resetMetaidAndAnnotationOfMiriam(sbmodel);
            if (Preference.isDebug) {
                System.out.println("outputSpec.getLevel() = " + outputSpec.getLevel());
                System.out.println("outputSpec.getVersion() = " + outputSpec.getVersion());
            }
            if (outputSpec.getLevel() == 1 && targetDoc.checkL1Compatibility() > 0L) {
                String[] msg = LibSBMLUtil.getSBMLErrorMessages(targetDoc);
                throw new Exception(String.valueOf(msg[0]) + msg[1]);
            }
            targetDoc.setLevelAndVersion((long)outputSpec.getLevel(), (long)outputSpec.getVersion());
            Throwable throwable = null;
            try {
                sbmodel.prepareSave();
                if (outputSpec.getLevel() == 1) {
                    sbmodel.prepareSaveForLevel1();
                }
                if (!MainWindow.isIgnorAllCheckAndMessageNotice() && this.isValidationEnabled) {
                    int choice = Integer.MIN_VALUE;
                    choice = !this.ignoreWarning ? LibSBMLUtil.checkSBMLConsistencyAndShowMessage(targetDoc, this.ownerFrame, new String[]{"Save", "Cancel"}) : LibSBMLUtil.checkSBMLConsistencyAndShowErrorMessage(targetDoc, this.ownerFrame, new String[]{"Save", "Cancel"});
                    if (choice != -1 && choice != 0) {
                        return;
                    }
                }
                if (!SBMLFiler.isAllowedFileName(file.getAbsolutePath())) {
                    try {
                        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath()), "UTF-8");
                        SBMLWriter writer = new SBMLWriter();
                        out.write(this.deleteIndent(writer.writeToString(targetDoc)));
                        out.close();
                        out = null;
                    }
                    catch (Exception out) {}
                } else {
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath()), "UTF-8");
                    SBMLWriter writer = new SBMLWriter();
                    out.write(this.deleteIndent(writer.writeToString(targetDoc)));
                    out.close();
                    out = null;
                }
                targetDoc.delete();
                targetDoc = null;
                System.gc();
            }
            catch (Throwable t) {
                throwable = t;
            }
            if (throwable != null) {
                throw new Exception(throwable);
            }
        }
        catch (Throwable e) {
            String errmsg = "Cannot export to SBML Level " + outputSpec.getLevel() + " Version " + outputSpec.getVersion() + " due to the following errors: \n\n";
            ((MainWindow)this.ownerFrame).showMessageDialog("Export Error", String.valueOf(errmsg) + e.getMessage(), 0);
        }
        outputSpec = currentOutputSpec;
    }

    public static boolean isAllowedFileName(String fileName) {
        int nameLen = fileName.length();
        int intUseStringLen = USE_STRING.length();
        int i = 0;
        while (i < nameLen) {
            boolean exist = false;
            char c = fileName.charAt(i);
            int j = 0;
            while (j < intUseStringLen) {
                char cd = USE_STRING.charAt(j);
                if (c == cd) {
                    exist = true;
                    break;
                }
                ++j;
            }
            if (!exist) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void checkValidationResult(SBMLValidator.SBMLValidationMessage validationMessage) throws Exception {
        if (validationMessage == null) {
            throw new Exception("[FATAL ERROR]  SBML file cannot be opened");
        }
        if (validationMessage.getNumErrors() + validationMessage.getNumFatals() > 0L) {
            String errMessage = SBMLValidator.getValidationResultMessage(validationMessage);
            throw new Exception(errMessage);
        }
        if (validationMessage.getNumWarnings() > 0L) {
            String warnMessage = SBMLValidator.getValidationResultMessage(validationMessage);
            JOptionPane.showMessageDialog(this.ownerFrame, warnMessage, "Warning", 2);
        }
    }

    public void setValidationEnabled(boolean b) {
        this.isValidationEnabled = b;
    }

    public void setIgnoreWarning(boolean b) {
        this.ignoreWarning = b;
    }

    public boolean isValidationEnabled() {
        return this.isValidationEnabled;
    }

    public boolean isIgnoreWarning() {
        return this.ignoreWarning;
    }

    public static final void resetAnnotationOfMiriam(SBase sbase) {
        XMLNode annotation = sbase.getAnnotation();
        if (annotation != null && annotation.getNumChildren() > 0L) {
            int i = 0;
            while ((long)i < annotation.getNumChildren()) {
                XMLNode dnode = annotation.getChild((long)i);
                String strTag = String.valueOf(dnode.getPrefix()) + ":" + dnode.getName();
                if (strTag != null && strTag.equals("rdf:RDF")) {
                    Vector vecData = MiriamMainPanel.getMiriamsFromXMLNode(new Vector(), dnode, null);
                    StringBuffer strannotation = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), sbase, vecData, true);
                    XMLNode nodeMiriam = XMLNode.convertStringToXMLNode((String)strannotation.toString());
                    sbase.unsetAnnotation();
                    sbase.setAnnotation(nodeMiriam);
                    sbase.setAnnotation(strannotation.toString());
                    break;
                }
                ++i;
            }
        }
    }
}

