/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.Vector;
import jp.fric.graphics.draw.GAtomImpl;
import jp.fric.graphics.draw.GCreater;
import jp.fric.graphics.draw.GElementFactory;
import jp.fric.graphics.draw.GElementImpl;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GPointedShape;
import jp.sbi.celldesigner.ClosedCompartmentAlias;
import jp.sbi.celldesigner.CompartmentSymbol;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.ElementSpeciesAlias;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.OpenedCompartmentAlias;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.ReactionSymbol;
import jp.sbi.celldesigner.ReactionSymbolCreater;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.SpeciesSymbolCreater;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerClosedCompartmentAlias;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerCompartmentSymbol;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerOvalSymbol;
import jp.sbi.celldesigner.layer.symbol.compartment.LayerSquareSymbol;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerFreeLineArrowSymbol;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerFreeLineSymbol;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionLink;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerReactionSymbol;
import jp.sbi.celldesigner.layer.symbol.reaction.LayerTagFreeLineSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerMonoSpeciesShape;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesAlias;
import jp.sbi.celldesigner.layer.symbol.species.LayerSpeciesSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerTagSymbol;
import jp.sbi.celldesigner.layer.symbol.species.LayerTextSymbol;
import jp.sbi.celldesigner.symbol.color.ReactionColorScheme;
import jp.sbi.celldesigner.symbol.compartment.CompartmentOval;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquare;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareE;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareN;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareNE;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareNW;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareS;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareSE;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareSW;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareW;
import jp.sbi.celldesigner.symbol.creator.CreateHeterodimer;
import jp.sbi.celldesigner.symbol.creator.CreateLayerTagWithLine;
import jp.sbi.celldesigner.symbol.creator.Degradation;
import jp.sbi.celldesigner.symbol.creator.HomodimerFormation;
import jp.sbi.celldesigner.symbol.creator.ReleaseHeterodimer;
import jp.sbi.celldesigner.symbol.reaction.AddProduct;
import jp.sbi.celldesigner.symbol.reaction.AddReactant;
import jp.sbi.celldesigner.symbol.reaction.Catalysis;
import jp.sbi.celldesigner.symbol.reaction.DimerFormation;
import jp.sbi.celldesigner.symbol.reaction.DirectSingleLine;
import jp.sbi.celldesigner.symbol.reaction.Dissociation;
import jp.sbi.celldesigner.symbol.reaction.GBooleanLogicGateAnd;
import jp.sbi.celldesigner.symbol.reaction.GBooleanLogicGateNot;
import jp.sbi.celldesigner.symbol.reaction.GBooleanLogicGateOr;
import jp.sbi.celldesigner.symbol.reaction.GBooleanLogicGateUnknown;
import jp.sbi.celldesigner.symbol.reaction.Inhibition;
import jp.sbi.celldesigner.symbol.reaction.KnownTransitionOmitted;
import jp.sbi.celldesigner.symbol.reaction.Modulation;
import jp.sbi.celldesigner.symbol.reaction.PhysicalStimulation;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;
import jp.sbi.celldesigner.symbol.reaction.Transcription;
import jp.sbi.celldesigner.symbol.reaction.Translation;
import jp.sbi.celldesigner.symbol.reaction.Transport;
import jp.sbi.celldesigner.symbol.reaction.Trigger;
import jp.sbi.celldesigner.symbol.reaction.Truncation;
import jp.sbi.celldesigner.symbol.reaction.UnknownCatalysis;
import jp.sbi.celldesigner.symbol.reaction.UnknownInhibition;
import jp.sbi.celldesigner.symbol.reaction.UnknownTransition;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.LinkedCreaseLineMixedNotation;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.MixedModulation;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.MixedPhysicalStimulation;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.MixedTrigger;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.NegativeInference;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.PositiveInference;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.UnknownModulation;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.UnknownNegativeInference;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.UnknownPhysicalStimulation;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.UnknownPositiveInference;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.UnknownTrigger;
import jp.sbi.celldesigner.symbol.species.AntiSenseRNA;
import jp.sbi.celldesigner.symbol.species.Complex;
import jp.sbi.celldesigner.symbol.species.ComplexBrief;
import jp.sbi.celldesigner.symbol.species.Degraded;
import jp.sbi.celldesigner.symbol.species.Drug;
import jp.sbi.celldesigner.symbol.species.Gene;
import jp.sbi.celldesigner.symbol.species.GeneralBrief;
import jp.sbi.celldesigner.symbol.species.Generic;
import jp.sbi.celldesigner.symbol.species.Ion;
import jp.sbi.celldesigner.symbol.species.IonChannel;
import jp.sbi.celldesigner.symbol.species.Phenotype;
import jp.sbi.celldesigner.symbol.species.RNA;
import jp.sbi.celldesigner.symbol.species.Receptor;
import jp.sbi.celldesigner.symbol.species.SimpleMolecule;
import jp.sbi.celldesigner.symbol.species.Truncated;
import jp.sbi.celldesigner.symbol.species.Unknown;

public class SBFactory
implements GElementFactory {
    public static final String NONE = "";
    public static final String PROTEIN = "PROTEIN";
    public static final String DEFAULT_PROTEIN = "GENERIC";
    public static final String DEFAULT_GENE = "GENE";
    public static final String GENE = "GENE";
    public static final String DEFAULT_ANTISENSERNA = "ANTISENSE_RNA";
    public static final String ANTISENSERNA = "ANTISENSE_RNA";
    public static final String DEFAULT_RNA = "RNA";
    public static final String NRNA = "RNA";
    public static final String AUTO_LAYOUT_DEFAULT_SPECIES = "UNKNOWN";
    public static final String AUTO_LAYOUT_DEFAULT_REACTION = "STATE_TRANSITION";
    public static final String AUTO_LAYOUT_DEFAULT_MODIFIER = "CATALYSIS";
    public static final String AUTO_LAYOUT_DEFAULT_COMPARTMENT = "SQUARE";
    private static Vector list = null;
    private static Degraded degraded = null;
    private static DirectSingleLine directsingleline = null;
    private static LayerTagFreeLineSymbol tagfreeline = null;
    private static final PositiveInference positiveinference = new PositiveInference();
    private static final NegativeInference negativeinference = new NegativeInference();

    static {
        list = new Vector();
        list.add(new Generic());
        list.add(new Receptor());
        list.add(new IonChannel());
        list.add(new Truncated());
        list.add(new Gene());
        list.add(new RNA());
        list.add(new AntiSenseRNA());
        list.add(new Phenotype());
        list.add(new Ion());
        list.add(new SimpleMolecule());
        list.add(new Drug());
        list.add(new Unknown());
        list.add(new Complex());
        list.add(new ComplexBrief());
        list.add(new GeneralBrief());
        list.add(new CreateHeterodimer());
        list.add(new ReleaseHeterodimer());
        list.add(new CompartmentSquare());
        list.add(new CompartmentOval());
        list.add(new CompartmentSquareNW());
        list.add(new CompartmentSquareNE());
        list.add(new CompartmentSquareSW());
        list.add(new CompartmentSquareSE());
        list.add(new CompartmentSquareN());
        list.add(new CompartmentSquareE());
        list.add(new CompartmentSquareW());
        list.add(new CompartmentSquareS());
        list.add(new StateTransition());
        list.add(new KnownTransitionOmitted());
        list.add(new UnknownTransition());
        list.add(new Transcription());
        list.add(new Translation());
        list.add(new Transport());
        list.add(new DimerFormation());
        list.add(new Dissociation());
        list.add(new Truncation());
        list.add(new AddReactant());
        list.add(new AddProduct());
        list.add(new Catalysis());
        list.add(new UnknownCatalysis());
        list.add(new Inhibition());
        list.add(new UnknownInhibition());
        list.add(new PhysicalStimulation());
        list.add(new Modulation());
        list.add(new Trigger());
        list.add(new GBooleanLogicGateAnd());
        list.add(new GBooleanLogicGateOr());
        list.add(new GBooleanLogicGateNot());
        list.add(new GBooleanLogicGateUnknown());
        list.add(new HomodimerFormation());
        list.add(new Degradation());
        list.add(new Degraded());
        list.add(new CreateLayerTagWithLine());
        degraded = new Degraded();
        directsingleline = new DirectSingleLine();
        list.add(new LayerTextSymbol());
        list.add(new LayerOvalSymbol());
        list.add(new LayerSquareSymbol());
        list.add(new LayerFreeLineSymbol());
        list.add(new LayerFreeLineArrowSymbol());
        list.add(new LayerTagSymbol());
        tagfreeline = new LayerTagFreeLineSymbol();
        list.add(new PositiveInference());
        list.add(new NegativeInference());
        list.add(new MixedPhysicalStimulation());
        list.add(new MixedModulation());
        list.add(new MixedTrigger());
        list.add(new UnknownPositiveInference());
        list.add(new UnknownNegativeInference());
        list.add(new UnknownPhysicalStimulation());
        list.add(new UnknownModulation());
        list.add(new UnknownTrigger());
    }

    public static String filterSynonym(String code) {
        if (code.equals("DIMER_FORMATION")) {
            return "HETERODIMER_ASSOCIATION";
        }
        if (code.equals("HETERODIMER_FORMATION")) {
            return "HETERODIMER_ASSOCIATION";
        }
        if (code.equals("CREATE_HETERODIMER")) {
            return "CREATE_HETEROMULTIMER";
        }
        if (code.equals("RELEASE_HETERODIMER")) {
            return "RELEASE_HETEROMULTIMER";
        }
        if (code.equals("ANTI_SENSE_RNA")) {
            return "ANTISENSE_RNA";
        }
        if (code.equals("TRANSCRIPTIONAL_ACTIVATION") || code.equals("TRANSLATIONAL_ACTIVATION")) {
            return "POSITIVE_INFLUENCE";
        }
        if (code.equals("TRANSCRIPTIONAL_INHIBITION") || code.equals("TRANSLATIONAL_INHIBITION")) {
            return "NEGATIVE_INFLUENCE";
        }
        return code;
    }

    @Override
    public String nullcode() {
        return NONE;
    }

    @Override
    public boolean isFramed(String code) {
        boolean rtn = false;
        int i = 0;
        while (i < list.size()) {
            SBSymbol s = (SBSymbol)list.elementAt(i);
            if (s.getCode().equals(code) && s instanceof SpeciesSymbol) {
                rtn = true;
                break;
            }
            if (s.getCode().equals(code) && s instanceof GFramedShape) {
                rtn = true;
                break;
            }
            if (s.getCode().equals(code) && s instanceof LayerSpeciesSymbol) {
                rtn = true;
                break;
            }
            if (s.getCode().equals(code) && s instanceof LayerCompartmentSymbol) {
                rtn = true;
                break;
            }
            ++i;
        }
        return rtn;
    }

    public static boolean isProtein(String code) {
        boolean rtn = false;
        int i = 0;
        while (i < list.size()) {
            SBSymbol s = (SBSymbol)list.elementAt(i);
            if (s.getCode().equals(code) && s instanceof SpeciesSymbol) {
                rtn = ((SpeciesSymbol)((Object)s)).isProtein();
                break;
            }
            ++i;
        }
        return rtn;
    }

    public static boolean isGene(String code) {
        boolean rtn = false;
        int i = 0;
        while (i < list.size()) {
            SBSymbol s = (SBSymbol)list.elementAt(i);
            if (s.getCode().equals(code) && s instanceof SpeciesSymbol) {
                rtn = ((SpeciesSymbol)((Object)s)).isGene();
                break;
            }
            ++i;
        }
        return rtn;
    }

    public static boolean isRNA(String code) {
        boolean rtn = false;
        int i = 0;
        while (i < list.size()) {
            SBSymbol s = (SBSymbol)list.elementAt(i);
            if (s.getCode().equals(code) && s instanceof SpeciesSymbol) {
                rtn = ((SpeciesSymbol)((Object)s)).isRNA();
                break;
            }
            ++i;
        }
        return rtn;
    }

    public static boolean isAntiSenseRNA(String code) {
        boolean rtn = false;
        int i = 0;
        while (i < list.size()) {
            SBSymbol s = (SBSymbol)list.elementAt(i);
            if (s.getCode().equals(code) && s instanceof SpeciesSymbol) {
                rtn = ((SpeciesSymbol)((Object)s)).isAntiSenseRNA();
                break;
            }
            ++i;
        }
        return rtn;
    }

    @Override
    public boolean isPointed(String code) {
        boolean rtn = false;
        int i = 0;
        while (i < list.size()) {
            SBSymbol s = (SBSymbol)list.elementAt(i);
            if (s.getCode().equals(code) && s instanceof GPointedShape) {
                rtn = true;
                break;
            }
            ++i;
        }
        return rtn;
    }

    @Override
    public boolean isLinkable(String code) {
        boolean rtn = false;
        int i = 0;
        while (i < list.size()) {
            SBSymbol s = (SBSymbol)list.elementAt(i);
            if (s.getCode().equals(code) && s instanceof GLinkedShape && !s.getCode().equals("DIRECT_SINGLE_LINE")) {
                rtn = true;
                break;
            }
            ++i;
        }
        return rtn;
    }

    @Override
    public boolean isCreater(String code) {
        boolean rtn = false;
        int i = 0;
        while (i < list.size()) {
            SBSymbol s = (SBSymbol)list.elementAt(i);
            if (s.getCode().equals(code) && s instanceof GCreater) {
                rtn = true;
                break;
            }
            ++i;
        }
        return rtn;
    }

    @Override
    public Object createObject(String code) {
        SBSymbol symbol = SBFactory.createSymbol(code);
        if (symbol == null) {
            return null;
        }
        if (symbol instanceof ComplexBrief || symbol instanceof GeneralBrief) {
            return null;
        }
        if (symbol instanceof SpeciesSymbol) {
            MonoSpeciesShape mono = new MonoSpeciesShape(code);
            GAtomImpl alias = code.equals("COMPLEX") ? new ComplexSpeciesAlias() : new ElementSpeciesAlias();
            alias.setGFramedShape(mono);
            String briefType = SBFactory.getBriefViewType(code);
            Dimension d = (Dimension)Preference.defaultSpeciesSize.get(briefType);
            if (d == null) {
                SpeciesSymbol briefSymbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(briefType));
                d = briefSymbol.defaultSize();
            }
            alias.setFrameSize(1, d.width, d.height);
            alias.setInnerPosition(1, new Point2D.Double(0.0, 0.0));
            return alias;
        }
        if (symbol instanceof CompartmentSymbol) {
            GElementImpl alias = symbol instanceof GFramedShape ? new ClosedCompartmentAlias() : new OpenedCompartmentAlias();
            try {
                alias.setSymbol(symbol);
            }
            catch (Exception alias2) {
                // empty catch block
            }
            return alias;
        }
        if (symbol instanceof ReactionSymbol) {
            int s = ((ReactionSymbol)((Object)symbol)).sourceSize();
            int t = ((ReactionSymbol)((Object)symbol)).destinationSize();
            ReactionLink link = new ReactionLink(s, t);
            try {
                link.setSymbol(symbol);
            }
            catch (Exception d) {
                // empty catch block
            }
            ((GLinkedShape)((Object)symbol)).setColor(ReactionColorScheme.getColor(symbol.getCode()));
            ((GLinkedShape)((Object)symbol)).setLineWidth(ReactionColorScheme.getLineWidth(symbol.getCode()));
            ((GLinkedShape)((Object)symbol)).setLineType(ReactionColorScheme.getLineType(symbol.getCode()));
            return link;
        }
        if (symbol instanceof SpeciesSymbolCreater) {
            return symbol;
        }
        if (symbol instanceof ReactionSymbolCreater) {
            return symbol;
        }
        if (symbol instanceof LayerSpeciesSymbol) {
            LayerMonoSpeciesShape mono = new LayerMonoSpeciesShape(code);
            LayerSpeciesAlias alias3 = new LayerSpeciesAlias();
            alias3.setGFramedShape(mono);
            LayerSpeciesSymbol briefSymbol = (LayerSpeciesSymbol)((Object)SBFactory.createSymbol(code));
            Dimension d = briefSymbol.defaultSize();
            alias3.setFrameSize(1, d.width, d.height);
            alias3.setInnerPosition(1, new Point2D.Double(0.0, 0.0));
            return alias3;
        }
        if (symbol instanceof LayerCompartmentSymbol) {
            LayerClosedCompartmentAlias alias = new LayerClosedCompartmentAlias();
            try {
                alias.setSymbol(symbol);
            }
            catch (Exception alias3) {
                // empty catch block
            }
            return alias;
        }
        if (symbol instanceof LayerReactionSymbol) {
            int s = ((LayerReactionSymbol)((Object)symbol)).sourceSize();
            int t = ((LayerReactionSymbol)((Object)symbol)).destinationSize();
            LayerReactionLink link = new LayerReactionLink(s, t);
            try {
                link.setSymbol(symbol);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((GLinkedShape)((Object)symbol)).setColor(ReactionColorScheme.getColor(symbol.getCode()));
            ((GLinkedShape)((Object)symbol)).setLineWidth(ReactionColorScheme.getLineWidth(symbol.getCode()));
            return link;
        }
        return null;
    }

    public static SBSymbol createSymbol(String code) {
        SBSymbol symbol = null;
        int i = 0;
        while (i < list.size()) {
            SBSymbol s = (SBSymbol)list.elementAt(i);
            if (s.getCode().equals(code)) {
                symbol = s;
                break;
            }
            ++i;
        }
        if (symbol == null && degraded.getCode().equals(code)) {
            symbol = degraded;
        }
        if (symbol == null && directsingleline.getCode().equals(code)) {
            symbol = directsingleline;
        }
        if (symbol == null && tagfreeline.getCode().equals(code)) {
            symbol = tagfreeline;
        }
        if (symbol == null && ("TRANSCRIPTIONAL_ACTIVATION".equals(code) || "TRANSLATIONAL_ACTIVATION".equals(code))) {
            symbol = positiveinference;
        }
        if (symbol == null && ("TRANSCRIPTIONAL_INHIBITION".equals(code) || "TRANSLATIONAL_INHIBITION".equals(code))) {
            symbol = negativeinference;
        }
        if (symbol == null) {
            return null;
        }
        try {
            if (code != null && (code.equals("LAYER_ARROW") || code.equals("TAG_LINE") || code.equals("LAYER_LINE"))) {
                int policy = GLinkedLine.getDefaultConnectPolicy();
                GLinkedLine.setDefaultConnectPolicy(0);
                int iCreasePointNumber = GLinkedLine.getDefaultCreasePointNumber();
                GLinkedLine.setDefaultCreasePointNumber(0);
                SBSymbol rtn = (SBSymbol)symbol.getClass().newInstance();
                GLinkedLine.setDefaultCreasePointNumber(iCreasePointNumber);
                GLinkedLine.setDefaultConnectPolicy(policy);
                return rtn;
            }
            return (SBSymbol)symbol.getClass().newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Vector getSpeciesCodesOnToolbar() {
        Vector<String> rtn = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            SBSymbol symbol = (SBSymbol)list.elementAt(i);
            if (!(symbol instanceof ComplexBrief) && !(symbol instanceof GeneralBrief) && !(symbol instanceof LayerTagSymbol) && symbol instanceof SpeciesSymbol) {
                rtn.add(symbol.getCode());
            }
            ++i;
        }
        return rtn;
    }

    public static Vector getSpeciesSymbolCreator() {
        Vector<String> rtn = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            SBSymbol symbol = (SBSymbol)list.elementAt(i);
            if (symbol instanceof SpeciesSymbolCreater) {
                rtn.add(symbol.getCode());
            }
            ++i;
        }
        return rtn;
    }

    public static Vector getSpeciesCodesForPalette() {
        Vector<String> rtn = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            SBSymbol symbol = (SBSymbol)list.elementAt(i);
            if (symbol instanceof SpeciesSymbol || symbol instanceof SpeciesSymbolCreater) {
                rtn.add(symbol.getCode());
            }
            ++i;
        }
        return rtn;
    }

    public static Vector getProteinCodes() {
        Vector<String> rtn = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            SBSymbol symbol = (SBSymbol)list.elementAt(i);
            if (symbol instanceof SpeciesSymbol && ((SpeciesSymbol)((Object)symbol)).isProtein()) {
                rtn.add(symbol.getCode());
            }
            ++i;
        }
        return rtn;
    }

    public static Vector getSpeciesCodesExceptProtein() {
        Vector<String> rtn = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            SBSymbol symbol = (SBSymbol)list.elementAt(i);
            if (symbol instanceof SpeciesSymbol && !((SpeciesSymbol)((Object)symbol)).isProtein() && !(symbol instanceof GeneralBrief)) {
                rtn.add(symbol.getCode());
            }
            ++i;
        }
        return rtn;
    }

    public static Vector getGeneCodes() {
        Vector<String> rtn = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            SBSymbol symbol = (SBSymbol)list.elementAt(i);
            if (symbol instanceof SpeciesSymbol && ((SpeciesSymbol)((Object)symbol)).isGene()) {
                rtn.add(symbol.getCode());
            }
            ++i;
        }
        return rtn;
    }

    public static Vector getSpeciesCodesExceptGene() {
        Vector<String> rtn = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            SBSymbol symbol = (SBSymbol)list.elementAt(i);
            if (symbol instanceof SpeciesSymbol && !((SpeciesSymbol)((Object)symbol)).isGene() && !(symbol instanceof GeneralBrief)) {
                rtn.add(symbol.getCode());
            }
            ++i;
        }
        return rtn;
    }

    public static Vector getCompartmentCodes() {
        Vector<String> rtn = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            SBSymbol symbol = (SBSymbol)list.elementAt(i);
            if (symbol instanceof CompartmentSymbol) {
                rtn.add(symbol.getCode());
            }
            ++i;
        }
        return rtn;
    }

    public static Vector getReactionCodes() {
        Vector<String> rtn = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            SBSymbol symbol = (SBSymbol)list.elementAt(i);
            if (symbol instanceof ReactionSymbol && !(symbol instanceof LinkedCreaseLineMixedNotation)) {
                rtn.add(symbol.getCode());
            }
            ++i;
        }
        return rtn;
    }

    public static Vector getReactionSymbolCreator() {
        Vector<String> rtn = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            SBSymbol symbol = (SBSymbol)list.elementAt(i);
            if (symbol instanceof ReactionSymbolCreater) {
                rtn.add(symbol.getCode());
            }
            ++i;
        }
        return rtn;
    }

    public static Vector getReactionCodesForPalette() {
        Vector<String> rtn = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            SBSymbol symbol = (SBSymbol)list.elementAt(i);
            if (symbol instanceof ReactionSymbol || symbol instanceof ReactionSymbolCreater) {
                rtn.add(symbol.getCode());
            }
            ++i;
        }
        return rtn;
    }

    public static Vector getLayerSymbolCodes() {
        Vector<String> rtn = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            SBSymbol symbol = (SBSymbol)list.elementAt(i);
            if ((symbol instanceof LayerSpeciesSymbol || symbol instanceof LayerCompartmentSymbol || symbol instanceof LayerReactionSymbol) && !(symbol instanceof LayerTagSymbol)) {
                rtn.add(symbol.getCode());
            }
            ++i;
        }
        return rtn;
    }

    public static Vector getCompatibleSymbolCodes(String code) {
        boolean isClosed;
        Vector<String> rtn = new Vector<String>();
        if (code.equals(NONE)) {
            return rtn;
        }
        if (code.equals("ADD_REACTANT") || code.equals("ADD_PRODUCT")) {
            rtn.add(code);
            return rtn;
        }
        SBSymbol symbol = SBFactory.createSymbol(code);
        if (symbol == null) {
            return rtn;
        }
        if (code.equals("TAG")) {
            rtn.add(code);
            return rtn;
        }
        if (symbol instanceof CompartmentSymbol && !(isClosed = ((CompartmentSymbol)((Object)symbol)).isClosed())) {
            rtn.add(code);
            return rtn;
        }
        int i = 0;
        while (i < list.size()) {
            SBSymbol s = (SBSymbol)list.elementAt(i);
            String scode = s.getCode();
            if (!scode.equals("TAG")) {
                if (symbol instanceof Complex || symbol instanceof ComplexBrief) {
                    if (s instanceof Complex || s instanceof ComplexBrief) {
                        rtn.add(scode);
                    }
                } else if (symbol instanceof GeneralBrief) {
                    if (s instanceof GeneralBrief) {
                        rtn.add(scode);
                    }
                } else if (symbol instanceof SpeciesSymbol && s instanceof SpeciesSymbol) {
                    if (!(s instanceof Complex || s instanceof ComplexBrief || s instanceof GeneralBrief)) {
                        rtn.add(scode);
                    }
                } else if (symbol instanceof CompartmentSymbol && s instanceof CompartmentSymbol) {
                    boolean isClosed2 = ((CompartmentSymbol)((Object)s)).isClosed();
                    if (isClosed2) {
                        rtn.add(scode);
                    }
                } else if (symbol instanceof ReactionSymbol && s instanceof ReactionSymbol && !(s instanceof AddReactant) && !(s instanceof AddProduct) && !(s instanceof DirectSingleLine)) {
                    int src1 = ((ReactionSymbol)((Object)symbol)).sourceSize();
                    int dist1 = ((ReactionSymbol)((Object)symbol)).destinationSize();
                    int src2 = ((ReactionSymbol)((Object)s)).sourceSize();
                    int dist2 = ((ReactionSymbol)((Object)s)).destinationSize();
                    if (src1 == src2 && dist1 == dist2) {
                        rtn.add(scode);
                    }
                }
            }
            ++i;
        }
        return rtn;
    }

    public static String codenameToExplanation(String codename) {
        if (codename != null && codename.startsWith("MACRO#TOOLTIP#PREFIX:")) {
            return codename.substring("MACRO#TOOLTIP#PREFIX:".length());
        }
        if (codename.equals(DEFAULT_PROTEIN)) {
            return "Generic Protein";
        }
        if (codename.equals("TRUNCATED")) {
            return "Truncated Protein";
        }
        if (codename.equals("REDUCED_PHYSICAL_STIMULATION")) {
            return "Reduced Physical Stimulation";
        }
        if (codename.equals("REDUCED_MODULATION")) {
            return "Reduced Modulation";
        }
        if (codename.equals("REDUCED_TRIGGER")) {
            return "Reduced Trigger";
        }
        String explanationText = NONE;
        String[] words = codename.split("_");
        int i = 0;
        while (i < words.length) {
            if (i != 0) {
                explanationText = String.valueOf(explanationText) + " ";
            }
            String head = words[i].substring(0, 1).toUpperCase();
            String body = words[i].substring(1).toLowerCase();
            explanationText = String.valueOf(explanationText) + head + body;
            ++i;
        }
        return explanationText;
    }

    public static String getBriefViewType(String codename) {
        SBSymbol symbol = SBFactory.createSymbol(codename);
        if (!(symbol instanceof SpeciesSymbol) && !(symbol instanceof LayerSpeciesSymbol)) {
            return NONE;
        }
        if (symbol instanceof ComplexBrief || symbol instanceof GeneralBrief) {
            return NONE;
        }
        if (symbol instanceof Complex) {
            return "COMPLEX_PACKED";
        }
        return "GENERAL_BRIEF_VIEW";
    }

    public static Vector getMixedNotationCodes() {
        Vector<String> rtn = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            SBSymbol symbol = (SBSymbol)list.elementAt(i);
            if (symbol instanceof LinkedCreaseLineMixedNotation) {
                rtn.add(symbol.getCode());
            }
            ++i;
        }
        return rtn;
    }
}

