/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.util.Vector;
import jp.sbi.celldesigner.SBEvent;

class SBEventVector
extends Vector {
    private int lastIndex = -1;

    public void dispose() {
        int i = 0;
        while (i < super.size()) {
            SBEvent sbe = (SBEvent)super.elementAt(i);
            sbe.dispose();
            ++i;
        }
        super.clear();
    }

    public void deleteAll() {
        super.clear();
        this.lastIndex = -1;
    }

    public synchronized void insertNewEvent(SBEvent sbe) {
        int i = super.size() - 1;
        while (i > this.lastIndex) {
            SBEvent ev = (SBEvent)super.remove(i);
            ev.dispose();
            --i;
        }
        super.add(sbe);
        this.lastIndex = super.size() - 1;
    }

    public synchronized boolean hasPrevEvent() {
        boolean hasevent;
        boolean bl = hasevent = this.lastIndex >= 0;
        if (hasevent) {
            hasevent = !this.canSeemAsIgnoreRecords();
        }
        return hasevent;
    }

    public synchronized boolean hasNextEvent() {
        return this.lastIndex < super.size() - 1;
    }

    public synchronized void deletedLastEvent() {
        this.remove(this.lastIndex);
        this.lastIndex = super.size() - 1;
    }

    public synchronized SBEvent prevEvent() {
        if (this.lastIndex < 0) {
            return null;
        }
        SBEvent sbe = (SBEvent)super.elementAt(this.lastIndex);
        --this.lastIndex;
        return sbe;
    }

    public synchronized SBEvent nextEvent() {
        if (this.lastIndex >= super.size() - 1) {
            return null;
        }
        ++this.lastIndex;
        SBEvent sbe = (SBEvent)super.elementAt(this.lastIndex);
        return sbe;
    }

    public synchronized void deleteNoContentGroupEvent() {
        SBEvent sbevent;
        SBEvent event;
        if (this.lastIndex > 0 && (event = (SBEvent)super.elementAt(this.lastIndex)).getCode() == -2 && (sbevent = (SBEvent)super.get(this.lastIndex - 1)).getCode() == -1) {
            this.deletedLastEvent();
            this.deletedLastEvent();
        }
    }

    public synchronized boolean canSeemAsIgnoreRecords() {
        int i = this.lastIndex;
        while (i >= 0) {
            SBEvent event = (SBEvent)super.elementAt(i);
            int code = event.getCode();
            if (code != -1 && code != -2) {
                return false;
            }
            --i;
        }
        return true;
    }
}

