/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.sbi.celldesigner.MainWindow;

public class ReactionTargetDialog
extends JDialog {
    private JPanel jContentPane = null;
    private JLabel relationLabel = null;
    private JComboBox countComboBox = null;
    private JButton okButton = null;
    private JButton cancleButton = null;
    private int reactionCountRange = 10;
    private boolean isOK = false;
    private static ReactionTargetDialog instance;
    private JLabel speceisTypeLabel = null;
    private JComboBox speciesTypeComboBox = null;
    protected static final String[] ClassNames;
    private String strSelectedSpeciesType;
    private String strSelectedReactionCount;

    static {
        ClassNames = new String[]{"Generic", "Receptor", "Ion_Channel", "Truncated", "Gene", "RNA", "AntiSense_RNA", "Phenotype", "Ion", "Simple_Molecule", "Drug", "Unknown", "Complex", "Degraded"};
    }

    public ReactionTargetDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 130);
        this.setModal(true);
        this.setLocation(350, 300);
        this.setResizable(false);
        this.setTitle("Select XXXX");
        this.setContentPane(this.getJContentPane());
        this.setSelectedReactionCount(null);
        this.setSelectedSpeciesType(null);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.speceisTypeLabel = new JLabel();
            this.speceisTypeLabel.setBounds(new Rectangle(10, 10, 80, 20));
            this.speceisTypeLabel.setText("speciesType");
            this.relationLabel = new JLabel();
            this.relationLabel.setBounds(new Rectangle(10, 35, 80, 20));
            this.relationLabel.setText("reaction");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.relationLabel, null);
            this.jContentPane.add((Component)this.getCountComboBox(), null);
            this.jContentPane.add((Component)this.getOkButton(), null);
            this.jContentPane.add((Component)this.getCancleButton(), null);
            this.jContentPane.add((Component)this.speceisTypeLabel, null);
            this.jContentPane.add((Component)this.getSpeciesTypeComboBox(), null);
        }
        return this.jContentPane;
    }

    private JComboBox getSpeciesTypeComboBox() {
        if (this.speciesTypeComboBox == null) {
            this.speciesTypeComboBox = new JComboBox();
            this.speciesTypeComboBox.setBounds(new Rectangle(95, 10, 185, 20));
        }
        this.setValueOfSpeciesTypeComboBox();
        return this.speciesTypeComboBox;
    }

    private void setValueOfSpeciesTypeComboBox() {
        if (this.speciesTypeComboBox == null) {
            return;
        }
        this.speciesTypeComboBox.removeAllItems();
        int i = 0;
        while (i < ClassNames.length) {
            this.speciesTypeComboBox.addItem(ClassNames[i]);
            ++i;
        }
    }

    private JComboBox getCountComboBox() {
        if (this.countComboBox == null) {
            this.countComboBox = new JComboBox();
            this.countComboBox.setBounds(new Rectangle(95, 35, 185, 20));
        }
        this.setValueOfCountComboBox();
        return this.countComboBox;
    }

    private void setValueOfCountComboBox() {
        if (this.countComboBox == null) {
            return;
        }
        this.countComboBox.removeAllItems();
        int i = 0;
        while (i < this.reactionCountRange) {
            this.countComboBox.addItem(String.valueOf(i + 1));
            ++i;
        }
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancleButton_actionPerformed();
            return;
        }
        super.processWindowEvent(e);
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setBounds(new Rectangle(55, 65, 75, 20));
            this.okButton.setText("Ok");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactionTargetDialog.this.okButton_actionPerformed();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancleButton() {
        if (this.cancleButton == null) {
            this.cancleButton = new JButton();
            this.cancleButton.setBounds(new Rectangle(145, 65, 75, 20));
            this.cancleButton.setText("Cancle");
            this.cancleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReactionTargetDialog.this.cancleButton_actionPerformed();
                }
            });
        }
        return this.cancleButton;
    }

    public boolean isOk() {
        return this.isOK;
    }

    private void cancleButton_actionPerformed() {
        this.isOK = false;
        this.resetComboBox();
        this.dispose();
    }

    private void resetComboBox() {
        MainWindow mWin = MainWindow.getLastInstance();
        mWin.resetComboBox();
    }

    private void okButton_actionPerformed() {
        if (this.speciesTypeComboBox != null) {
            this.setSelectedSpeciesType(this.speciesTypeComboBox.getSelectedItem().toString());
        } else {
            this.setSelectedSpeciesType(null);
        }
        if (this.countComboBox != null) {
            this.setSelectedReactionCount(this.countComboBox.getSelectedItem().toString());
        } else {
            this.setSelectedReactionCount(null);
        }
        this.isOK = true;
        this.setVisible(false);
    }

    public String getSelectedSpeciesType() {
        if (this.strSelectedSpeciesType == null || "".equals(this.strSelectedSpeciesType)) {
            this.strSelectedSpeciesType = ClassNames[0];
        }
        return this.strSelectedSpeciesType;
    }

    public void setSelectedSpeciesType(String selectedSpeciesType) {
        this.strSelectedSpeciesType = selectedSpeciesType;
    }

    public String getSelectedReactionCount() {
        if (this.strSelectedReactionCount == null || "".equals(this.strSelectedReactionCount)) {
            this.strSelectedReactionCount = "1";
        }
        return this.strSelectedReactionCount;
    }

    public void setSelectedReactionCount(String selectedReactionCount) {
        this.strSelectedReactionCount = selectedReactionCount;
    }

    public static ReactionTargetDialog getInstance(Frame frame) {
        if (instance == null) {
            instance = new ReactionTargetDialog(frame);
        }
        return instance;
    }

    public static void main(String[] args) {
        ReactionTargetDialog tem = new ReactionTargetDialog(null);
        tem.show();
    }
}

