/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import jp.fric.graphics.draw.GEditable;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedCurveAndLine;
import jp.fric.graphics.draw.GLinkedLineComplex3;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.CreasePoint;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;

public class ReactionLinkPopupMenu
extends JPopupMenu {
    private static ReactionLinkPopupMenu uniqueInstance = null;
    private HashMap menuReservoir = null;
    public static final Object[][] actionStatus = new Object[][]{{AddAnchorPointAction.class, true, false}, {RemoveAnchorPointAction.class, true, false}};

    private ReactionLinkPopupMenu() {
    }

    public static ReactionLinkPopupMenu getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new ReactionLinkPopupMenu();
            uniqueInstance.initItems();
            int menucount = uniqueInstance.getComponentCount();
            int i = 0;
            while (i < menucount) {
                uniqueInstance.getComponent(i).setVisible(true);
                ++i;
            }
        }
        return uniqueInstance;
    }

    public Action getAction(Class cl) {
        return ((JMenuItem)this.menuReservoir.get(cl)).getAction();
    }

    public void setItemText(Class cl, String text) {
        JMenuItem menu = (JMenuItem)this.menuReservoir.get(cl);
        if (menu != null) {
            menu.setText(text);
        }
    }

    private void initItems() {
        MainWindow mw = MainWindow.getLastInstance();
        if (mw == null) {
            return;
        }
        this.menuReservoir = new HashMap();
        Class[] actionClasses = new Class[]{AddAnchorPointAction.class, RemoveAnchorPointAction.class, MainWindow.ReformReactionAction.class, MainWindow.ChangeReactionConnectionPolicyAction.class, MainWindow.ChangeIdentityAction.class, MainWindow.OpenSBMLEditDialogAction.class, MainWindow.OpenKineticLawEditDialogAction.class, MainWindow.GeneralNotesAction.class, MainWindow.ChangeColorAndShapeAction.class, MainWindow.AddTextAction.class, MainWindow.ConnectToSabioRKAction.class};
        int i = 0;
        while (i < actionClasses.length) {
            AbstractAction action = null;
            action = i == 0 ? new AddAnchorPointAction("Add Anchor Point", "Add an anchor point here.", null) : (i == 1 ? new RemoveAnchorPointAction("Remove Anchor Point", "Remove this anchor point.", null) : mw.getAction(actionClasses[i]));
            if (action != null) {
                JMenuItem menu = new JMenuItem(action);
                if (actionClasses[i] == MainWindow.ConnectToSabioRKAction.class) {
                    menu.setText("Import KineticLaw from SABIO-RK...");
                }
                this.add(menu);
                this.menuReservoir.put(actionClasses[i], menu);
            }
            if (i == 1 || i == 3 || i == 8 || i == 9) {
                this.addSeparator();
            }
            ++i;
        }
        this.setItemText(MainWindow.OpenSBMLEditDialogAction.class, "Edit Reaction...");
        this.setItemText(MainWindow.GeneralNotesAction.class, "Reaction Notes...");
    }

    public void resetActionStatas(int type) {
        int i = 0;
        while (i < actionStatus.length) {
            Action action;
            Object key = actionStatus[i][0];
            boolean enabled = (Boolean)actionStatus[i][type];
            if (this.menuReservoir != null && (action = ((JMenuItem)this.menuReservoir.get(key)).getAction()) != null) {
                action.setEnabled(enabled);
            }
            ++i;
        }
    }

    public void resetResourceofDescriptionOfReactionDialog(boolean enabled) {
    }

    public class AddAnchorPointAction
    extends MyAbstractAction {
        private ReactionLink reactionLink;
        private GStructure gstructure;
        private double x;
        private double y;

        public AddAnchorPointAction(String text, String description, KeyStroke accelarator) {
            super(text, description, accelarator);
            this.reactionLink = null;
            this.gstructure = null;
            this.x = 0.0;
            this.y = 0.0;
        }

        public void setUp(ReactionLink reactionLink, double x, double y, GStructure gstructure) {
            this.reactionLink = reactionLink;
            this.gstructure = gstructure;
            this.x = x;
            this.y = y;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.reactionLink.addCreasePoint(this.x, this.y, this.gstructure);
        }
    }

    public abstract class MyAbstractAction
    extends AbstractAction {
        public MyAbstractAction(String text, String description, KeyStroke accelarator) {
            super(text);
            this.putValue("ShortDescription", description);
            if (accelarator != null) {
                this.putValue("AcceleratorKey", accelarator);
            }
        }
    }

    public class RemoveAnchorPointAction
    extends MyAbstractAction {
        private CreasePoint creasePoint;
        private GStructure gstructure;

        public RemoveAnchorPointAction(String text, String description, KeyStroke accelarator) {
            super(text, description, accelarator);
            this.creasePoint = null;
            this.gstructure = null;
        }

        public void setUp(CreasePoint creasePoint, GStructure gstructure) {
            this.creasePoint = creasePoint;
            this.gstructure = gstructure;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Rectangle2D.Double updateRect = null;
            Rectangle2D updateRect1 = null;
            Rectangle2D updateRect2 = null;
            Rectangle2D updateRect3 = null;
            GEditable editable = this.creasePoint.getOwner();
            if (editable instanceof GLinkedCreaseLine) {
                updateRect1 = ((GLinkedCreaseLine)editable).removeCreasePoint(this.creasePoint, this.gstructure);
                GLink gl = null;
                GLinkedLineComplex3 parentComplex3 = ((GLinkedCreaseLine)editable).getcomplex3Parent();
                gl = parentComplex3 != null ? parentComplex3.getReactionLink(this.gstructure) : ((GLinkedCreaseLine)editable).getReactionLink(this.gstructure);
                if (gl instanceof ReactionLink) {
                    updateRect2 = this.gstructure.autoAjustLinkLineConn((ReactionLink)gl);
                    updateRect3 = this.gstructure.repaintLinkandAllLinksWhichlinkingtome((ReactionLink)gl, false);
                }
            } else if (editable instanceof GLogicGate) {
                updateRect1 = ((GLogicGate)editable).getRealLine().removeCreasePoint(this.creasePoint, this.gstructure);
            } else if (editable instanceof GLinkedCurveAndLine) {
                updateRect1 = ((GLinkedCurveAndLine)editable).removeCreasePoint(this.creasePoint, this.gstructure);
            }
            updateRect = GUtil.union(updateRect, updateRect1);
            updateRect = GUtil.union(updateRect, updateRect2);
            updateRect = GUtil.union(updateRect, updateRect3);
            this.gstructure.callbyuserRepaint(updateRect);
        }
    }
}

