/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import jp.co.mki.celldesigner.simulation.controlpanel.ControlPanelMainWindow;
import jp.fric.util.LogFactory;
import jp.sbi.celldesigner.LinkedCreaseLineModification;
import jp.sbi.celldesigner.LinkedLineComplex3;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.ReactionLink;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.symbol.reaction.DirectSingleLine;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.LinkedCreaseLineMixedNotation;
import org.sbml.libsbml.Reaction;

public class ReactionLinkDialog
extends JDialog {
    private static final int iDialogDefaultWidth = 370;
    private static final int iDialogDefaultHeight = 180;
    private int iDialogRealWidth = 370;
    private int iDialogRealtHeight = 180;
    public static final String strReactionLinkDialogDefaultPattern = "default";
    public static final String strReactionLinkDialogLogicGatePattern = "gate";
    private static final String strIhasNOname = "(Have no name.)";
    private static final String strSuccessUpdated = "Info@[ReactionLinkDialog]: GLink has been Successfully Updated.";
    private static final String strGLinkHavingNoChanged = "Info@[ReactionLinkDialog]: GLink has no changed.";
    private static final String strErrMsgHaveNoObjLink = "Error@[ReactionLinkDialog]: GLink has not been Selected.";
    private static final String strErrMsgParentReactionIsNull = "Error@[ReactionLinkDialog]: [parent reaction] is null.";
    private JLabel labelReactionName = new JLabel("Name");
    private JLabel labelGateType = new JLabel("");
    private JLabel labelType = new JLabel("");
    private JLabel labelReversible = new JLabel("Reversible");
    private JTextField textfieldName;
    private JComboBox logicgatetypeCombo;
    private JComboBox typeCombo;
    private JRadioButton reversibleYesButton;
    private JRadioButton reversibleNoButton;
    private ButtonGroup groupReversible;
    private JButton okButton;
    private JButton cancelButton;
    private boolean isFirstShowing = true;
    ReactionLink showingReactionLink = null;
    SBModelFrame sbframe;
    SBModel sbmodel;
    private Logger log = LogFactory.getLogger(ReactionLinkDialog.class);

    public ReactionLinkDialog(SBModelFrame sbframe, SBModel sbmodel, String title) {
        this.setResizable(false);
        this.setSize(this.iDialogRealWidth, this.iDialogRealtHeight);
        this.sbframe = sbframe;
        this.sbmodel = sbmodel;
        this.setModal(true);
        final JRootPane rootPane = this.getRootPane();
        JPanel panel = new JPanel();
        panel.setLayout(null);
        this.labelReactionName.setBounds(new Rectangle(20, 20, 60, 20));
        this.textfieldName = new JTextField();
        this.textfieldName.setBounds(new Rectangle(100, 20, 220, 20));
        this.textfieldName.setEditable(true);
        this.textfieldName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(ReactionLinkDialog.this.okButton);
            }
        });
        this.labelGateType.setBounds(new Rectangle(20, 45, 60, 20));
        this.logicgatetypeCombo = new JComboBox();
        this.logicgatetypeCombo.setBounds(new Rectangle(100, 45, 220, 20));
        this.logicgatetypeCombo.setEditable(false);
        this.logicgatetypeCombo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(ReactionLinkDialog.this.okButton);
            }
        });
        this.labelType.setBounds(new Rectangle(20, 45, 60, 20));
        this.typeCombo = new JComboBox();
        this.typeCombo.setBounds(new Rectangle(100, 45, 220, 20));
        this.typeCombo.setEditable(false);
        this.typeCombo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(ReactionLinkDialog.this.okButton);
            }
        });
        int labelReversibleWidth = (int)this.labelReversible.getPreferredSize().getWidth();
        this.labelReversible.setBounds(new Rectangle(20, 70, labelReversibleWidth, 20));
        this.reversibleYesButton = new JRadioButton("True");
        this.reversibleYesButton.setMnemonic(84);
        this.reversibleYesButton.setBounds(new Rectangle(100, 70, 80, 20));
        this.reversibleYesButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(ReactionLinkDialog.this.okButton);
            }
        });
        this.reversibleNoButton = new JRadioButton("False");
        this.reversibleNoButton.setMnemonic(70);
        this.reversibleNoButton.setBounds(new Rectangle(180, 70, 80, 20));
        this.reversibleNoButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(ReactionLinkDialog.this.okButton);
            }
        });
        this.groupReversible = new ButtonGroup();
        this.groupReversible.add(this.reversibleYesButton);
        this.groupReversible.add(this.reversibleNoButton);
        this.reversibleNoButton.setSelected(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (ReactionLinkDialog.this.reversibleYesButton.hasFocus() || ReactionLinkDialog.this.reversibleNoButton.hasFocus()) {
                    switch (e.getKeyCode()) {
                        case 39: {
                            ReactionLinkDialog.this.reversibleNoButton.setSelected(true);
                            ReactionLinkDialog.this.reversibleNoButton.grabFocus();
                            break;
                        }
                        case 37: {
                            ReactionLinkDialog.this.reversibleYesButton.setSelected(true);
                            ReactionLinkDialog.this.reversibleYesButton.grabFocus();
                        }
                    }
                }
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic(83);
        this.okButton.setBounds(new Rectangle(100, 110, 80, 25));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReactionLinkDialog.this.okButton_actionPerformed(e);
            }
        });
        this.okButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(ReactionLinkDialog.this.okButton);
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setBounds(new Rectangle(195, 110, 120, 25));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReactionLinkDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.cancelButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(ReactionLinkDialog.this.cancelButton);
            }
        });
        this.textfieldName.setText("");
        this.textfieldName.setCaretPosition(0);
        this.getContentPane().add(panel);
        panel.add((Component)this.labelReactionName, null);
        panel.add((Component)this.labelGateType, null);
        panel.add((Component)this.labelType, null);
        panel.add((Component)this.textfieldName, null);
        panel.add((Component)this.logicgatetypeCombo, null);
        panel.add((Component)this.typeCombo, null);
        panel.add((Component)this.labelReversible, null);
        if (this.reversibleYesButton.isSelected()) {
            panel.add((Component)this.reversibleYesButton, null);
            panel.add((Component)this.reversibleNoButton, null);
        } else {
            panel.add((Component)this.reversibleNoButton, null);
            panel.add((Component)this.reversibleYesButton, null);
        }
        panel.add((Component)this.okButton, null);
        panel.add((Component)this.cancelButton, null);
        this.setTitle(title);
        this.setSize(this.iDialogRealWidth, this.iDialogRealtHeight);
        this.setLocationRelativeTo(sbframe);
    }

    private void setComponentsEnabled(boolean enable) {
        this.textfieldName.setEditable(enable);
        this.logicgatetypeCombo.setEnabled(enable);
        this.typeCombo.setEnabled(enable);
        this.reversibleYesButton.setEnabled(enable);
        this.reversibleNoButton.setEnabled(enable);
        this.okButton.setEnabled(enable);
    }

    public void releaseFrame() {
        this.showingReactionLink = null;
        this.sbmodel = null;
        this.sbframe = null;
    }

    @Override
    public void show() {
        this.rootPane.setDefaultButton(this.okButton);
        super.show();
    }

    public void showLinkProperty(ReactionLink link) {
        LinkedCreaseLineMixedNotation mixednotation;
        Reaction parent = link.getParentReaction();
        if (parent == null) {
            JOptionPane.showMessageDialog(this.sbframe, "parent reaction is null", "Error", 2);
            return;
        }
        if (link.getGLinkedShape() instanceof GLogicGate) {
            this.showLogicGageAndMemberLinkProperty(link);
            return;
        }
        if (link.getGLinkedShape() instanceof LinkedCreaseLineModification) {
            LinkedCreaseLineModification modificationline = (LinkedCreaseLineModification)link.getGLinkedShape();
            if (modificationline.isMemberofBooleanLogicGate()) {
                this.showLogicGageAndMemberLinkProperty(link);
                return;
            }
        } else if (link.getGLinkedShape() instanceof LinkedCreaseLineMixedNotation && (mixednotation = (LinkedCreaseLineMixedNotation)link.getGLinkedShape()).isMemberofBooleanLogicGate()) {
            this.showLogicGageAndMemberLinkProperty(link);
            return;
        }
        this.initComponetsPostionsForPattern(strReactionLinkDialogDefaultPattern);
        String name = parent.getName();
        boolean isReversible = parent.getReversible();
        if (link.getGLinkedShape() instanceof StateTransition || link.getGLinkedShape() instanceof LinkedLineComplex3) {
            this.textfieldName.setText(name);
            this.reversibleYesButton.setSelected(isReversible);
            this.reversibleNoButton.setSelected(!isReversible);
            this.textfieldName.setEnabled(true);
            this.reversibleYesButton.setEnabled(true);
            this.reversibleNoButton.setEnabled(true);
        } else {
            this.textfieldName.setText(strIhasNOname);
            this.reversibleYesButton.setSelected(false);
            this.reversibleNoButton.setEnabled(true);
            this.textfieldName.setEnabled(false);
            this.reversibleYesButton.setEnabled(false);
            this.reversibleNoButton.setEnabled(false);
        }
        this.typeCombo.enable();
        this.typeCombo.removeAllItems();
        Vector types = SBFactory.getCompatibleSymbolCodes(link.getSymbol().getCode());
        int index = 0;
        int i = 0;
        while (i < types.size()) {
            block18: {
                boolean b2;
                boolean b1;
                String type;
                block17: {
                    block16: {
                        if (link.getGLinkedShape() instanceof DirectSingleLine) {
                            this.typeCombo.insertItemAt("DIRECT_SINGLE_LINE", index);
                            this.typeCombo.setSelectedIndex(index);
                            this.typeCombo.disable();
                        }
                        type = (String)types.elementAt(i);
                        if (!(link.getGLinkedShape() instanceof GLogicGate)) break block16;
                        if (GLogicGate.isGLogicGateType(type)) break block17;
                        break block18;
                    }
                    if (!GLogicGate.isModification(link.getGLinkedShape()) ? GLogicGate.isGLogicGateType(type) || GLogicGate.isModificationType(type) : !GLogicGate.isModificationType(type)) break block18;
                }
                if ((b1 = GLogicGate.isMixedNotationModificationType(link.getSymbol().getCode())) == (b2 = GLogicGate.isMixedNotationModificationType(type))) {
                    this.typeCombo.insertItemAt(type, index);
                    if (link.getSymbol().getCode().equals(type)) {
                        this.typeCombo.setSelectedIndex(index);
                    }
                    ++index;
                }
            }
            ++i;
        }
        this.showingReactionLink = link;
        this.show();
    }

    private void okButton_actionPerformed(ActionEvent e) {
        ControlPanelMainWindow target;
        String strMsgAfterUpdated = this.updatingLinkData();
        if (strMsgAfterUpdated.equals(strErrMsgParentReactionIsNull)) {
            this.log.info(strErrMsgParentReactionIsNull);
        }
        this.dispose();
        this.showingReactionLink = null;
        MainWindow lastInstance = MainWindow.getLastInstance();
        if (lastInstance != null && (target = lastInstance.getTargetControlPanelWindow()) != null) {
            target.processTableReload(false);
        }
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
        this.showingReactionLink = null;
    }

    public void setLinkProperty(ReactionLink link, String tname) {
        Reaction parent = link.getParentReaction();
        if (parent == null) {
            JOptionPane.showMessageDialog(this.sbframe, "parent reaction is null", "Error", 2);
            return;
        }
        boolean isReversible = parent.getReversible();
        if (link.getGLinkedShape() instanceof StateTransition || link.getGLinkedShape() instanceof LinkedLineComplex3) {
            this.textfieldName.setText(tname);
            this.reversibleYesButton.setSelected(isReversible);
            this.reversibleNoButton.setSelected(!isReversible);
            this.textfieldName.setEnabled(true);
            this.reversibleYesButton.setEnabled(true);
            this.reversibleNoButton.setEnabled(true);
        } else {
            this.textfieldName.setText("(modification needs no name)");
            this.reversibleYesButton.setSelected(false);
            this.reversibleNoButton.setEnabled(true);
            this.textfieldName.setEnabled(false);
            this.reversibleYesButton.setEnabled(false);
            this.reversibleNoButton.setEnabled(false);
        }
        this.typeCombo.removeAllItems();
        Vector types = SBFactory.getCompatibleSymbolCodes(link.getSymbol().getCode());
        boolean index = false;
        int i = 0;
        while (i < types.size()) {
            String type = (String)types.elementAt(i);
            this.typeCombo.insertItemAt(type, i);
            if (link.getSymbol().getCode().equals(type)) {
                this.typeCombo.setSelectedIndex(i);
            }
            ++i;
        }
        this.showingReactionLink = link;
        this.update_actionPerformed();
    }

    public void update_actionPerformed() {
        String strMsgAfterUpdated = this.updatingLinkData();
        if (strMsgAfterUpdated.equals(strErrMsgParentReactionIsNull)) {
            System.out.println(strErrMsgParentReactionIsNull);
        }
        this.showingReactionLink = null;
    }

    public void initComponetsPostionsForPattern() {
        this.initComponetsPostionsForPattern(strReactionLinkDialogDefaultPattern);
    }

    public void initComponetsPostionsForPattern(String pattern) {
        if (pattern == null) {
            this.initComponetsPostionsToDefaultPattern();
        } else if (pattern.trim().toUpperCase().equals(strReactionLinkDialogLogicGatePattern.toUpperCase())) {
            this.initComponetsPostionsToLogicGatePattern();
        } else {
            this.initComponetsPostionsToDefaultPattern();
        }
    }

    private void initComponetsPostionsToLogicGatePattern() {
        int dltW = 60;
        int dltX = 40;
        int dltY = 25;
        this.setSize(390, 190);
        this.labelReactionName.setBounds(new Rectangle(15, 15, 60, 20));
        this.textfieldName.setBounds(new Rectangle(140, 15, 230, 20));
        this.labelGateType.setText("LogicGate Type");
        this.labelGateType.setBounds(new Rectangle(15, 40, 120, 20));
        this.logicgatetypeCombo.setBounds(new Rectangle(140, 40, 230, 20));
        this.labelGateType.setVisible(true);
        this.logicgatetypeCombo.setVisible(true);
        this.labelType.setText("Modification Type");
        this.labelType.setBounds(new Rectangle(15, 40 + dltY, 120, 20));
        this.typeCombo.setBounds(new Rectangle(140, 40 + dltY, 230, 20));
        int labelReversibleWidth = (int)this.labelReversible.getPreferredSize().getWidth();
        this.labelReversible.setBounds(new Rectangle(15, 65 + dltY, labelReversibleWidth, 20));
        this.reversibleYesButton.setBounds(new Rectangle(140, 65 + dltY, 80, 20));
        this.reversibleNoButton.setBounds(new Rectangle(220, 65 + dltY, 80, 20));
        this.okButton.setBounds(new Rectangle(140, 95 + dltY, 80, 25));
        this.cancelButton.setBounds(new Rectangle(235, 95 + dltY, 120, 25));
    }

    private void initComponetsPostionsToDefaultPattern() {
        this.setSize(370, 180);
        this.labelReactionName.setBounds(new Rectangle(20, 20, 60, 20));
        this.textfieldName.setBounds(new Rectangle(100, 20, 240, 20));
        this.labelGateType.setVisible(false);
        this.logicgatetypeCombo.setVisible(false);
        this.labelType.setText("Type");
        this.labelType.setBounds(new Rectangle(20, 45, 60, 20));
        this.typeCombo.setBounds(new Rectangle(100, 45, 240, 20));
        int labelReversibleWidth = (int)this.labelReversible.getPreferredSize().getWidth();
        this.labelReversible.setBounds(new Rectangle(20, 70, labelReversibleWidth, 20));
        this.reversibleYesButton.setBounds(new Rectangle(100, 70, 80, 20));
        this.reversibleNoButton.setBounds(new Rectangle(180, 70, 80, 20));
        this.okButton.setBounds(new Rectangle(100, 110, 80, 25));
        this.cancelButton.setBounds(new Rectangle(195, 110, 120, 25));
    }

    public void showLogicGageAndMemberLinkProperty(ReactionLink link) {
        GLogicGate gate;
        ReactionLink gateLink;
        boolean isLinkingToSpeciesGate = false;
        boolean isLinkingToPhenotypeGate = false;
        boolean isMixedNotationModificationType = GLogicGate.isMixedNotationModificationType(link.getSymbol().getCode());
        String strGatetype = "";
        String strModificationtype = "";
        if (link.getGLinkedShape() instanceof GLogicGate) {
            GLogicGate gt = (GLogicGate)link.getGLinkedShape();
            if (gt.getRealLine() instanceof LinkedCreaseLineMixedNotation) {
                isMixedNotationModificationType = true;
            }
            if (gt.getRealLine().getEndTarget() instanceof SpeciesAlias) {
                isLinkingToSpeciesGate = true;
                if (((SpeciesAlias)gt.getRealLine().getEndTarget()).isPhenotype()) {
                    isLinkingToPhenotypeGate = true;
                }
            }
            strGatetype = ((GLogicGate)link.getGLinkedShape()).getCode();
            strModificationtype = GLogicGate.getModificationTypeString(((GLogicGate)link.getGLinkedShape()).getModificationType());
        } else if (link.getGLinkedShape() instanceof LinkedCreaseLineModification) {
            LinkedCreaseLineModification modificationline = (LinkedCreaseLineModification)link.getGLinkedShape();
            if (!modificationline.isMemberofBooleanLogicGate()) {
                return;
            }
            gateLink = (ReactionLink)modificationline.getEndTarget();
            gate = (GLogicGate)gateLink.getGLinkedShape();
            strGatetype = gate.getCode();
            strModificationtype = GLogicGate.getModificationTypeString(gate.getModificationType());
            if (gate.getRealLine().getEndTarget() instanceof SpeciesAlias) {
                isLinkingToSpeciesGate = true;
                if (((SpeciesAlias)gate.getRealLine().getEndTarget()).isPhenotype()) {
                    isLinkingToPhenotypeGate = true;
                }
            }
        } else if (link.getGLinkedShape() instanceof LinkedCreaseLineMixedNotation) {
            LinkedCreaseLineMixedNotation mixednotaion = (LinkedCreaseLineMixedNotation)link.getGLinkedShape();
            if (!mixednotaion.isMemberofBooleanLogicGate()) {
                return;
            }
            isMixedNotationModificationType = true;
            gateLink = (ReactionLink)mixednotaion.getEndTarget();
            gate = (GLogicGate)gateLink.getGLinkedShape();
            strGatetype = gate.getCode();
            strModificationtype = GLogicGate.getModificationTypeString(gate.getModificationType());
            if (gate.getRealLine().getEndTarget() instanceof SpeciesAlias) {
                isLinkingToSpeciesGate = true;
                if (((SpeciesAlias)gate.getRealLine().getEndTarget()).isPhenotype()) {
                    isLinkingToPhenotypeGate = true;
                }
            }
        } else {
            return;
        }
        this.initComponetsPostionsForPattern(strReactionLinkDialogLogicGatePattern);
        this.textfieldName.setText(strIhasNOname);
        this.textfieldName.setEnabled(false);
        this.logicgatetypeCombo.setEnabled(true);
        this.typeCombo.setEnabled(true);
        this.reversibleYesButton.setSelected(false);
        this.reversibleYesButton.setEnabled(false);
        this.reversibleNoButton.setEnabled(true);
        this.reversibleNoButton.setEnabled(false);
        this.logicgatetypeCombo.removeAllItems();
        this.typeCombo.removeAllItems();
        Vector vdefaulttypes = SBFactory.getCompatibleSymbolCodes(link.getSymbol().getCode());
        int indexGate = 0;
        int indexModification = 0;
        int typeComboWidth = this.typeCombo.getWidth();
        int logicgatetypeComboWidth = this.logicgatetypeCombo.getWidth();
        int i = 0;
        while (i < vdefaulttypes.size()) {
            String type = (String)vdefaulttypes.elementAt(i);
            if (GLogicGate.isGLogicGateType(type)) {
                this.logicgatetypeCombo.insertItemAt(type, indexGate);
                if (type.equals(strGatetype)) {
                    this.logicgatetypeCombo.setSelectedIndex(indexGate);
                }
                ++indexGate;
            } else if (GLogicGate.isModificationType(type)) {
                boolean bSameType = isMixedNotationModificationType == GLogicGate.isMixedNotationModificationType(type);
                boolean add = false;
                if (isLinkingToPhenotypeGate) {
                    add = true;
                } else if (bSameType && (!isLinkingToSpeciesGate || isMixedNotationModificationType)) {
                    add = true;
                }
                if (add) {
                    this.typeCombo.insertItemAt(type, indexModification);
                    if (type.equals(strModificationtype)) {
                        this.typeCombo.setSelectedIndex(indexModification);
                    }
                    ++indexModification;
                }
            }
            ++i;
        }
        int typeComboPreferredWidth = (int)this.typeCombo.getPreferredSize().getWidth();
        int logicgatetypeComboPreferredWidth = (int)this.logicgatetypeCombo.getPreferredSize().getWidth();
        if (typeComboPreferredWidth > typeComboWidth || logicgatetypeComboPreferredWidth > logicgatetypeComboWidth) {
            int iDelta = 0;
            int iDelta1 = typeComboPreferredWidth - typeComboWidth;
            int iDelta2 = logicgatetypeComboPreferredWidth - logicgatetypeComboWidth;
            iDelta = iDelta1 >= iDelta2 ? iDelta1 : iDelta2;
            this.typeCombo.setBounds(new Rectangle(this.typeCombo.getX(), this.typeCombo.getY(), typeComboWidth + (iDelta += 10), this.typeCombo.getHeight()));
            this.logicgatetypeCombo.setBounds(this.logicgatetypeCombo.getX(), this.logicgatetypeCombo.getY(), logicgatetypeComboWidth + iDelta, this.logicgatetypeCombo.getHeight());
            this.textfieldName.setBounds(this.textfieldName.getX(), this.textfieldName.getY(), this.textfieldName.getWidth() + iDelta, this.textfieldName.getHeight());
            this.setSize(this.getWidth() + iDelta, this.getHeight());
        }
        this.showingReactionLink = link;
        this.show();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String updatingLinkData() {
        Vector members;
        GLogicGate gate;
        LinkedCreaseLineMixedNotation mixednotation;
        GLogicGate gate2;
        if (this.showingReactionLink == null) return strErrMsgHaveNoObjLink;
        Reaction parent = this.showingReactionLink.getParentReaction();
        if (parent == null) {
            return strErrMsgParentReactionIsNull;
        }
        boolean isChanged = false;
        String oldName = parent.getName();
        String newName = null;
        if ((this.showingReactionLink.getGLinkedShape() instanceof StateTransition || this.showingReactionLink.getGLinkedShape() instanceof LinkedLineComplex3) && (newName = this.textfieldName.getText()) != null && !newName.equals(strIhasNOname) && !oldName.equals(newName)) {
            isChanged = true;
        }
        String newgateType = (String)this.logicgatetypeCombo.getSelectedItem();
        String oldType = this.showingReactionLink.getSymbol().getCode();
        String newType = (String)this.typeCombo.getSelectedItem();
        boolean isGate = false;
        boolean isMemberofGate = false;
        boolean gateTypeNotBeenChanged = true;
        boolean memberofgateTypeNotBeenChanged = true;
        String stroldGatetype = "";
        String stroldModificationtype = "";
        ReactionLink gateLink = null;
        if (this.showingReactionLink.getGLinkedShape() instanceof GLogicGate) {
            isGate = true;
            gateLink = this.showingReactionLink;
            stroldGatetype = ((GLogicGate)this.showingReactionLink.getGLinkedShape()).getCode();
            stroldModificationtype = GLogicGate.getModificationTypeString(((GLogicGate)this.showingReactionLink.getGLinkedShape()).getModificationType());
        } else if (this.showingReactionLink.getGLinkedShape() instanceof LinkedCreaseLineModification) {
            LinkedCreaseLineModification modificationline = (LinkedCreaseLineModification)this.showingReactionLink.getGLinkedShape();
            if (modificationline.isMemberofBooleanLogicGate()) {
                isMemberofGate = true;
                gateLink = (ReactionLink)modificationline.getEndTarget();
                gate2 = (GLogicGate)gateLink.getGLinkedShape();
                stroldGatetype = gate2.getCode();
                stroldModificationtype = GLogicGate.getModificationTypeString(gate2.getModificationType());
            }
        } else if (this.showingReactionLink.getGLinkedShape() instanceof LinkedCreaseLineMixedNotation && (mixednotation = (LinkedCreaseLineMixedNotation)this.showingReactionLink.getGLinkedShape()).isMemberofBooleanLogicGate()) {
            isMemberofGate = true;
            gateLink = (ReactionLink)mixednotation.getEndTarget();
            gate2 = (GLogicGate)gateLink.getGLinkedShape();
            stroldGatetype = gate2.getCode();
            stroldModificationtype = GLogicGate.getModificationTypeString(gate2.getModificationType());
        }
        if (isGate || isMemberofGate) {
            if (newgateType != null && !stroldGatetype.equals(newgateType)) {
                isChanged = true;
                gateTypeNotBeenChanged = false;
            }
            if (newType != null && !stroldModificationtype.equals(newType)) {
                isChanged = true;
                memberofgateTypeNotBeenChanged = false;
            }
        } else if (!oldType.equals(newType)) {
            isChanged = true;
        }
        if (newType == null || newType.trim().equals("")) {
            boolean benable = this.typeCombo.isEnabled();
            this.typeCombo.setEnabled(true);
            newType = (String)this.typeCombo.getSelectedItem();
            if (newType == null || newType.trim().equals("")) {
                newType = this.showingReactionLink.getGLinkedShape() instanceof DirectSingleLine ? "DIRECT_SINGLE_LINE" : "";
            }
            this.typeCombo.setEnabled(benable);
        }
        boolean oldReversible = parent.getReversible();
        boolean newRebersible = this.reversibleYesButton.isSelected();
        if (oldReversible && !newRebersible || !oldReversible && newRebersible) {
            isChanged = true;
        }
        Color newColor = this.showingReactionLink.getGLinkedShape().getColor();
        double newLineWidth = this.showingReactionLink.getGLinkedShape().getLineWidth();
        Color newGateColor = null;
        Color newMemberColor = null;
        double newGateLineWidth = 0.0;
        double newMemberLineWidth = 0.0;
        if (isGate) {
            newGateColor = newColor;
            newGateLineWidth = newLineWidth;
            gate = (GLogicGate)gateLink.getGLinkedShape();
            members = gate.getChildrenLink();
            ReactionLink memberLink = (ReactionLink)members.get(0);
            newMemberColor = memberLink.getGLinkedShape().getColor();
            newMemberLineWidth = memberLink.getGLinkedShape().getLineWidth();
        } else if (isMemberofGate) {
            newMemberColor = newColor;
            newMemberLineWidth = newLineWidth;
            newGateColor = gateLink.getGLinkedShape().getColor();
            newGateLineWidth = gateLink.getGLinkedShape().getLineWidth();
        }
        if (!isChanged) return strGLinkHavingNoChanged;
        if (isGate || isMemberofGate) {
            newName = "";
            newRebersible = false;
            gate = (GLogicGate)gateLink.getGLinkedShape();
            members = gate.getChildrenLink();
            Object[][] oldLinewidthLineColorBak = new Object[members.size() + 1][2];
            int j = 0;
            oldLinewidthLineColorBak[j][0] = new Double(gateLink.getGLinkedShape().getLineWidth());
            oldLinewidthLineColorBak[j][1] = gateLink.getGLinkedShape().getColor();
            ++j;
            while (j < oldLinewidthLineColorBak.length) {
                ReactionLink oldmemberLink = (ReactionLink)members.get(j - 1);
                oldLinewidthLineColorBak[j][0] = new Double(oldmemberLink.getGLinkedShape().getLineWidth());
                oldLinewidthLineColorBak[j][1] = oldmemberLink.getGLinkedShape().getColor();
                ++j;
            }
            try {
                try {
                    this.sbmodel.eventGroupBegan(null);
                    if (isGate && memberofgateTypeNotBeenChanged) {
                        this.sbmodel.changeLinkProperty(this.showingReactionLink, newName, newgateType, newRebersible, newLineWidth, newColor, null);
                        return strSuccessUpdated;
                    }
                    if (isMemberofGate && gateTypeNotBeenChanged) {
                        this.sbmodel.changeLinkProperty(this.showingReactionLink, newName, newType, newRebersible, newLineWidth, newColor, null);
                        return strSuccessUpdated;
                    }
                    this.sbmodel.changeLinkProperty(gateLink, newName, newgateType, newRebersible, newGateLineWidth, newGateColor, null);
                    ReactionLink memberLink = (ReactionLink)members.get(0);
                    this.sbmodel.changeLinkProperty(memberLink, newName, newType, newRebersible, newMemberLineWidth, newMemberColor, null);
                    return strSuccessUpdated;
                }
                catch (Exception exception) {
                    this.sbmodel.eventGroupEnded(null);
                }
                return strSuccessUpdated;
            }
            finally {
                this.sbmodel.eventGroupEnded(null);
            }
        } else {
            if (newName == null) {
                newName = "";
            }
            this.sbmodel.changeLinkProperty(this.showingReactionLink, newName, newType, newRebersible, newLineWidth, newColor, null);
        }
        return strSuccessUpdated;
    }
}

