/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GLink;
import jp.fric.graphics.draw.GLinkConnectSchemeOwner;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GLinkTarget;
import jp.fric.graphics.draw.GLinkedCreaseLine;
import jp.fric.graphics.draw.GLinkedCurveAndLine;
import jp.fric.graphics.draw.GLinkedLineIndex;
import jp.fric.graphics.draw.GLinkedShape;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.LinkedCreaseLineModification;
import jp.sbi.celldesigner.LinkedLineComplex3;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.ReactionLinkPopupMenu;
import jp.sbi.celldesigner.ReactionSymbol;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SBSymbolized;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.layer.LayerManager;
import jp.sbi.celldesigner.symbol.reaction.AddProduct;
import jp.sbi.celldesigner.symbol.reaction.AddReactant;
import jp.sbi.celldesigner.symbol.reaction.DirectSingleLine;
import jp.sbi.celldesigner.symbol.reaction.GLogicGate;
import jp.sbi.celldesigner.symbol.reaction.StateTransition;
import jp.sbi.celldesigner.symbol.reaction.mixednotation.LinkedCreaseLineMixedNotation;
import org.sbml.libsbml.Reaction;

public class ReactionLink
extends GLink
implements SBSymbolized {
    private int prevReactionIndex = -1;
    private Reaction parentReaction = null;
    private int reactantSize;
    private int ri;
    private int pi;
    private SBSymbol symbol = null;
    private String tmpInfo = "";
    private String resourceOfDescriptionOfReaction = "";
    private String TagName = "";

    public ReactionLink() {
    }

    public ReactionLink(int reactantSize, int productSize) {
        super(reactantSize + productSize);
        this.reactantSize = reactantSize;
        this.ri = 0;
        this.pi = reactantSize;
    }

    public void setSizes(int reactantSize, int productSize) {
        super.setTargetSize(reactantSize + productSize);
        this.reactantSize = reactantSize;
        this.ri = 0;
        this.pi = reactantSize;
    }

    public void setParentReaction(Reaction reaction) {
        this.parentReaction = reaction;
    }

    public Reaction getParentReaction() {
        return this.parentReaction;
    }

    public void setPrevReactionIndex(int index) {
        this.prevReactionIndex = index;
    }

    public int getPrevReactionIndex() {
        return this.prevReactionIndex;
    }

    public void setTmpInfo(String tmpInfo) {
        this.tmpInfo = tmpInfo;
    }

    public String getTmpInfo() {
        return this.tmpInfo;
    }

    public void setResourceOfDescriptionOfReaction(String resourceOfDescriptionOfReaction) {
        this.resourceOfDescriptionOfReaction = resourceOfDescriptionOfReaction;
    }

    public String getResourceOfDescriptionOfReaction() {
        return this.resourceOfDescriptionOfReaction;
    }

    public void setTagName(String TagName) {
        this.TagName = TagName;
    }

    public String getTagName() {
        return this.TagName;
    }

    @Override
    public void setSymbol(SBSymbol symbol) throws Exception {
        if (symbol instanceof ReactionSymbol) {
            super.setGLinkedShape((GLinkedShape)((Object)symbol));
        } else {
            throw new Exception("symbol must be ReactionSymbol, code=" + symbol.getCode());
        }
        this.symbol = symbol;
    }

    @Override
    public SBSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public void setGLinkedShape(GLinkedShape linkedShape) throws Exception {
        super.setGLinkedShape(linkedShape);
        this.symbol = (SBSymbol)((Object)linkedShape);
    }

    @Override
    public GElement createCopy() {
        ReactionLink link = (ReactionLink)super.createCopy();
        link.ri = 0;
        link.reactantSize = this.reactantSize;
        link.reactantSize = this.targetSize() - this.reactantSize;
        Reaction r = this.parentReaction.cloneObject();
        try {
            r.setId("");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int count = (int)r.getNumReactants();
        int i = 0;
        while (i < count) {
            r.getListOfReactants().remove(0L);
            ++i;
        }
        count = (int)r.getNumProducts();
        i = 0;
        while (i < count) {
            r.getListOfProducts().remove(0L);
            ++i;
        }
        count = (int)r.getNumModifiers();
        i = 0;
        while (i < count) {
            r.getListOfModifiers().remove(0L);
            ++i;
        }
        link.setParentReaction(r);
        link.setTmpInfo(this.tmpInfo);
        link.setResourceOfDescriptionOfReaction(new String(this.resourceOfDescriptionOfReaction));
        return link;
    }

    @Override
    public boolean isLinkable(GLinkTarget elem, int index) {
        if (this.symbol == null) {
            return false;
        }
        return ((ReactionSymbol)((Object)this.symbol)).isLinkable(elem, index);
    }

    public boolean isBaseLink() {
        boolean rtn = true;
        int i = 0;
        while (i < this.targetSize()) {
            try {
                GLinkTarget elem = this.getTargetAt(i);
                if (elem instanceof GLink) {
                    rtn = false;
                    break;
                }
            }
            catch (Exception e) {
                return false;
            }
            ++i;
        }
        return rtn;
    }

    public boolean isAddReactantLink() {
        return this.symbol instanceof AddReactant;
    }

    public boolean isAddProductLink() {
        return this.symbol instanceof AddProduct;
    }

    public boolean isModificationLink() {
        return !this.isBaseLink() && !this.isAddReactantLink() && !this.isAddProductLink();
    }

    @Override
    public Vector getSources() {
        Vector<GLinkTarget> v = new Vector<GLinkTarget>();
        int i = 0;
        while (i < this.targetSize()) {
            if (this.isSourceIndex(i)) {
                try {
                    if (super.getTargetAt(i) instanceof SpeciesAlias || this.getGLinkedShape() instanceof AddProduct) {
                        v.add(super.getTargetAt(i));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return v;
    }

    public Vector getSourcesLinkPositionInfo() {
        Vector<GLinkPositionInfo> v = new Vector<GLinkPositionInfo>();
        int i = 0;
        while (i < this.targetSize()) {
            if (this.isSourceIndex(i)) {
                try {
                    v.add(super.getTargetLinkPositionInfoAt(i));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return v;
    }

    @Override
    public Vector getDistinations() {
        Vector<GLinkTarget> v = new Vector<GLinkTarget>();
        int i = 0;
        while (i < this.targetSize()) {
            if (this.isDestinationIndex(i)) {
                try {
                    v.add(super.getTargetAt(i));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return v;
    }

    public Vector getDistinationsLinkPositionInfo() {
        Vector<GLinkPositionInfo> v = new Vector<GLinkPositionInfo>();
        int i = 0;
        while (i < this.targetSize()) {
            if (this.isDestinationIndex(i)) {
                try {
                    v.add(super.getTargetLinkPositionInfoAt(i));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return v;
    }

    public boolean isSourceIndex(int i) {
        return i >= 0 && i < this.reactantSize;
    }

    public boolean isDestinationIndex(int i) {
        return this.reactantSize <= i && i < this.targetSize();
    }

    public void addSource(GLinkTarget target, GLinkPositionInfo lpi) {
        try {
            if (this.ri < this.reactantSize) {
                this.setTargetAt(target, this.ri, lpi);
                ++this.ri;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addSource(GLinkTarget target, GLinkedLineIndex lineIndex) {
        try {
            if (this.ri < this.reactantSize) {
                if (this.getGLinkedShape() instanceof AddProduct && target instanceof GLink && ((GLink)target).getGLinkedShape() instanceof StateTransition) {
                    GLinkPositionInfo lpi = new GLinkPositionInfo(-1, 0.0);
                    if (lineIndex != null) {
                        lpi.setArm(lineIndex.arm);
                        lpi.setPosition(lineIndex.line);
                        if (lpi.getPosition() != 1) {
                            lpi.setPosition(1);
                        }
                        this.setTargetAt(target, this.ri, lpi);
                        ++this.ri;
                        return;
                    }
                }
                if (lineIndex == null) {
                    this.setTargetAt(target, this.ri, (GLinkPositionInfo)null);
                } else {
                    this.setTargetAt(target, this.ri, lineIndex);
                }
                ++this.ri;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addDestination(GLinkTarget target, GLinkPositionInfo lpi) {
        try {
            if (this.pi < this.targetSize()) {
                this.setTargetAt(target, this.pi, lpi);
                ++this.pi;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addDestination(GLinkTarget target, GLinkedLineIndex lineIndex) {
        try {
            if (this.pi < this.targetSize()) {
                if (target instanceof GLink) {
                    if (((GLink)target).getGLinkedShape() instanceof StateTransition) {
                        GLinkPositionInfo lpi = new GLinkPositionInfo(-1, 0.0);
                        lpi.setArm(lineIndex.arm);
                        lpi.setPosition(lineIndex.line);
                        if (this.getGLinkedShape() instanceof AddReactant && lpi.getPosition() != 0) {
                            lpi.setPosition(0);
                        }
                        this.setTargetAt(target, this.pi, lpi);
                    } else {
                        this.setTargetAt(target, this.pi, lineIndex);
                    }
                }
                ++this.pi;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean popupAvailable() {
        return true;
    }

    boolean isSquarePolicy() {
        GLinkedShape shape = this.getGLinkedShape();
        return shape instanceof GLinkConnectSchemeOwner && ((GLinkConnectSchemeOwner)((Object)shape)).getConnectPolicy() == 1;
    }

    protected boolean canTogglePolicy(GStructure st) {
        GLinkedShape shape = this.getGLinkedShape();
        if (shape instanceof GLinkConnectSchemeOwner) {
            return ((GLinkConnectSchemeOwner)((Object)shape)).canTogglePolicy(st);
        }
        return false;
    }

    @Override
    public void showPopup(MouseEvent e, double x, double y, GStructure structure) {
        ReactionLinkPopupMenu popup = ReactionLinkPopupMenu.getInstance();
        int menucount = popup.getComponentCount();
        int i = 0;
        while (i < menucount) {
            popup.getComponent(i).setVisible(true);
            ++i;
        }
        if (this.getGLinkedShape() instanceof DirectSingleLine) {
            i = 0;
            while (i < menucount) {
                popup.getComponent(i).setVisible(false);
                ++i;
            }
            MenuElement[] senuElement = popup.getSubElements();
            int i2 = 0;
            while (i2 < senuElement.length) {
                if (senuElement[i2] instanceof JMenuItem && ((JMenuItem)senuElement[i2]).getAction() instanceof MainWindow.ChangeColorAndShapeAction) {
                    ((JMenuItem)senuElement[i2]).setVisible(true);
                }
                ++i2;
            }
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
        Action addanchor = popup.getAction(ReactionLinkPopupMenu.AddAnchorPointAction.class);
        if (this.isSquarePolicy()) {
            addanchor.setEnabled(false);
        } else {
            ((ReactionLinkPopupMenu.AddAnchorPointAction)addanchor).setUp(this, x, y, structure);
            addanchor.setEnabled(true);
        }
        Action removeanchor = popup.getAction(ReactionLinkPopupMenu.RemoveAnchorPointAction.class);
        removeanchor.setEnabled(false);
        String text = this.isSquarePolicy() ? "To Polyline" : "To Orthogonal";
        popup.setItemText(MainWindow.ChangeReactionConnectionPolicyAction.class, text);
        Action connectionPolicy = popup.getAction(MainWindow.ChangeReactionConnectionPolicyAction.class);
        connectionPolicy.setEnabled(true);
        if (text.equals("To Polyline")) {
            removeanchor.setEnabled(false);
        } else {
            popup.getAction(MainWindow.ReformReactionAction.class).setEnabled(false);
            GLinkedShape shape = this.getGLinkedShape();
            if (shape instanceof GLinkedShape && shape.getLineType() == 0) {
                connectionPolicy.setEnabled(false);
            }
        }
        if (!this.isBaseLink()) {
            popup.resetResourceofDescriptionOfReactionDialog(false);
        } else {
            popup.resetResourceofDescriptionOfReactionDialog(true);
        }
        try {
            if (MainWindow.getLastInstance().getCurrentModel().getUIType() == 2) {
                popup.resetActionStatas(MainWindow.getLastInstance().getCurrentModel().getUIType());
            }
        }
        catch (Exception ex) {
            return;
        }
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    public void addCreasePoint(double x, double y, GStructure structure) {
        Rectangle2D.Double updateRect = null;
        Rectangle2D updateRect1 = null;
        Rectangle2D updateRect2 = null;
        Rectangle2D updateRect3 = null;
        GLinkedShape glinkedshape = this.getGLinkedShape();
        if (glinkedshape instanceof GLinkedCreaseLine) {
            GLinkedCreaseLine glcln = (GLinkedCreaseLine)glinkedshape;
            updateRect1 = glcln.addCreasePoint(x, y, structure);
            updateRect2 = structure.autoAjustLinkLineConn(this);
        } else if (glinkedshape instanceof LinkedLineComplex3) {
            LinkedLineComplex3 cmp3ln = (LinkedLineComplex3)glinkedshape;
            updateRect1 = cmp3ln.addCreasePoint(x, y, structure);
            updateRect2 = structure.autoAjustLinkLineConn(this);
        } else if (glinkedshape instanceof GLogicGate) {
            GLogicGate gate = (GLogicGate)glinkedshape;
            updateRect1 = gate.getRealLine().addCreasePoint(x, y, structure);
        } else if (glinkedshape instanceof GLinkedCurveAndLine) {
            GLinkedCurveAndLine cmpglcl = (GLinkedCurveAndLine)glinkedshape;
            updateRect1 = cmpglcl.addCreasePoint(x, y, structure);
            updateRect2 = structure.autoAjustLinkLineConn(this);
            LayerManager.updateLayerSymbolLinkPostion(structure.getLayers(), this);
        } else {
            return;
        }
        updateRect3 = structure.repaintLinkandAllLinksWhichlinkingtome(this, false);
        updateRect = GUtil.union(updateRect, updateRect1);
        updateRect = GUtil.union(updateRect, updateRect2);
        updateRect = GUtil.union(updateRect, updateRect3);
        structure.callbyuserRepaint(updateRect);
    }

    public void reformSquareLines(GStructure structure) {
        GLinkedShape glinkedshape = this.getGLinkedShape();
        if (glinkedshape instanceof GLinkConnectSchemeOwner) {
            GLinkConnectSchemeOwner link = (GLinkConnectSchemeOwner)((Object)glinkedshape);
            link.reformSquareLines(structure);
        }
    }

    public void toggleConnectPolicy(GStructure structure) {
        GLinkedShape glinkedshape = this.getGLinkedShape();
        if (glinkedshape instanceof GLinkConnectSchemeOwner) {
            GLinkConnectSchemeOwner link = (GLinkConnectSchemeOwner)((Object)glinkedshape);
            link.toggleConnectPolicy(structure);
        }
    }

    public Vector getBaseLinkGateSource() {
        Vector v = new Vector();
        Vector memberLinks = this.getBaseLinkGateMembers();
        int j = 0;
        while (j < memberLinks.size()) {
            ReactionLink memberlink = (ReactionLink)memberLinks.get(j);
            v.add(memberlink.getSources().get(0));
            ++j;
        }
        return v;
    }

    public Vector getBaseLinkGateMembers() {
        Vector v = new Vector();
        GLinkedShape linkshp = this.getGLinkedShape();
        if (linkshp instanceof GLogicGate) {
            GLogicGate gate = (GLogicGate)linkshp;
            v = gate.getChildrenLink();
        }
        return v;
    }

    public boolean isRealBaseLink() {
        return this.isBaseLink() && !(this.getGLinkedShape() instanceof GLogicGate) && !(this.getGLinkedShape() instanceof LinkedCreaseLineModification) && !(this.getGLinkedShape() instanceof LinkedCreaseLineMixedNotation);
    }

    public boolean isBaseLinkGate() {
        return this.getGLinkedShape() instanceof GLogicGate && this.isBaseLink();
    }

    public boolean isPartOfBaseLinkGate() {
        boolean bPartOfBaseLinkGate = false;
        int i = 0;
        while (i < this.getTargets().length) {
            try {
                GLinkTarget target = this.getTargetAt(i);
                if (target instanceof ReactionLink && ((ReactionLink)target).isBaseLinkGate()) {
                    bPartOfBaseLinkGate = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return bPartOfBaseLinkGate;
    }

    private class AddCreasePointActionListener
    implements ActionListener {
        private GStructure structure;
        private double x;
        private double y;

        AddCreasePointActionListener(double x, double y, GStructure st) {
            this.x = x;
            this.y = y;
            this.structure = st;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReactionLink.this.addCreasePoint(this.x, this.y, this.structure);
        }
    }

    private class ChangeColorShapeActionListener
    implements ActionListener {
        private ChangeColorShapeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow mw = MainWindow.getLastInstance();
            mw.getCurrentModel().showChangeShapeDialog(false);
        }
    }

    private class ReformActionListener
    implements ActionListener {
        private GStructure structure;

        ReformActionListener(GStructure st) {
            this.structure = st;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReactionLink.this.reformSquareLines(this.structure);
        }
    }

    private class TogglePolicyActionListener
    implements ActionListener {
        private GStructure structure;

        TogglePolicyActionListener(GStructure st) {
            this.structure = st;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReactionLink.this.toggleConnectPolicy(this.structure);
        }
    }
}

