/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import jp.fric.graphics.draw.GLinkedLine;
import jp.fric.graphics.draw.PaintScheme;
import jp.fric.graphics.draw.PaintSchemeFactory;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.PopupSpeciesNameFontDialog;
import jp.sbi.celldesigner.symbol.color.CompartmentColorScheme;
import jp.sbi.celldesigner.symbol.color.ReactionColorScheme;
import jp.sbi.celldesigner.symbol.color.SpeciesColorScheme;
import jp.sbi.celldesigner.symbol.compartment.Membrane;
import jp.sbi.celldesigner.util.RecentFiles;

public class Preference
extends jp.sbi.sbml.util.Preference {
    private static final int GENERAL_SETTINGS = 0;
    private static final int SPECIES_SETTINGS = 1;
    private static final int COMPARTMENT_SETTINGS = 2;
    private static final int RECENT_FILES = 3;
    private static final int REACTION_SETTINGS = 4;
    private static final int EDITOR_UI_SETTING = 5;
    private static final int MACRO_UI_SETTING = 6;
    private static final int WINDOW_LAYOUT_SETTING = 7;
    private static final int MAINWIN_TOOLBAR_SETTING = 8;
    private static final String beginOfGeneralSetting = "//GENERAL SETTINGS";
    private static final String beginOfSpeciesSetting = "//SPECIES SETTINGS";
    private static final String beginOfCompartmentSetting = "//COMPARTMENT SETTINGS";
    private static final String beginOfReactionSetting = "//REACTION SETTINGS";
    private static final String beginOfRecentFiles = "//RECENT FILES";
    private static final String beginOfEditorUISetting = "//EDITOR UI SETTING";
    private static final String beginOfMacroUISetting = "//MACRO UI SETTING";
    private static final String beginOfMainWinToolbarSetting = "//MAINWIN TOOLBAR SETTING";
    private static final String endOfPreference = "//END OF PREFERENCE";
    private static int iomode = 0;
    public static Point windowPosition = null;
    public static Dimension windowSize = null;
    public static int windowState = 0;
    public static String openingPath = null;
    public static String savingPath = null;
    public static RecentFiles recentFiles = null;
    public static boolean showPDCaution = true;
    public static boolean showSpeciesRemovedCaution = true;
    public static Rectangle[] sbmlDlgBounds = new Rectangle[12];
    public static boolean[] isSbmlDlgOpen = new boolean[12];
    public static String sbwJarPath = null;
    public static Hashtable defaultSpeciesSize = new Hashtable();
    public static Hashtable defaultSpeciesColor = new Hashtable();
    public static boolean isGridSnaped = false;
    public static Point2D.Double gridSnapSize = null;
    public static boolean isGridShowing = false;
    public static boolean inputRepeatOn = false;
    public static boolean antialias = true;
    public static boolean showReaction = true;
    public static boolean isAutoTagShowingSystemDefault;
    public static boolean isAutoTagShowing;
    private static String autoTagOutput;
    public static final int ICON_SMALL_SIZE = 16;
    public static final int ICON_LARGE_SIZE = 24;
    public static final int ICON_DEFAULT_SIZE = 16;
    public static int iconSize;
    public static final boolean defaultShowingSpeciesRemovedDialogInPlugin = false;
    public static boolean isShowingSpeciesRemovedDialogInPlugin;
    private static final String showSpeciesRemovedDialogInPlugin = "showSpeciesRemovedDialogInPlugin";
    public static final int defaultSpeciesNameSize = 12;
    public static int speciesNameFont;
    private static final String speciesNameFontSizeSetting = "SpeciesNameFont";
    public static final int iGLogicGateMinSrcNums = 2;
    public static final int iGLogicGateMaxSrcNums = 10;
    public static final int iGLogicGateDefaultSrcNums = 2;
    public static int iGLogicGateSrcNums;
    public static boolean showTree;
    public static final int LIST_HIDE_MODE = 0;
    public static final int LIST_RIGHT_MODE = 1;
    public static final int LIST_BOTTOM_MODE = 2;
    public static int listPositionMode;
    public static int dividepos1;
    public static int dividepos2;
    public static boolean isWinLayoutInfoReaded;
    public static boolean[] panesVisibles;
    public static int[] panesOrientations;
    public static int[] dividerLocations;
    private static final String beginOfWindowLayoutSetting = "//WINDOWS LAYOUT SETTING";
    private static final String panesVisiblesString = "panesVisibles";
    private static final String panesOrientationsString = "panesOrientations";
    private static final String dividerLocationsString = "dividerLocations";
    private static final String showTreeString = "showTree";
    private static final String listPositionModeString = "listPositionMode";
    private static final String divideposString = "divideposes";
    public static boolean AUTO_LAYOUT_MODE;
    public static final boolean JAVA_WEB_START_MODE = false;
    public static final String cdVersion;
    public static final String prefDirPath;
    private static final String filename;
    public static String speciesRemovedCaution;
    public static final boolean bSystemDefaultShowCompartmentAllToolbarbuttons = false;
    public static boolean bUserDefaultShowCompartmentAllToolbarbuttons;
    private static final String strShowCompartmentAllToolbarbuttons = "showCompartmentAllToolbarbuttons";
    private static final String MainWinToolbarNameDeclarator = "TOOLBARNAME";
    private static final String MainWinToolbarVisibleDeclarator = "VISIBLE";
    private static String[] readedMainWinToolbarNameSET;
    public static final int SBOTERMNOTCARE_SELECTED = 0;
    public static final int SBOTERMSET_SELECTED = 1;
    public static final int SBOTERMREMOVE_SELECTED = 2;
    public static final int SBOTERMDEFAULT = 0;
    public static int SBOTERMVALUE_VIEW;
    private static final String strShowSBOTermValue = "SBOTermValue";
    private static final String InputRepeatModeDeclarator = "input_repeat_mode";
    private static final String On = "ON";
    private static final String MacroNameDeclarator = "NAME";
    private static final String MacroShowOrderDeclarator = "ORDER";
    private static boolean bReadedMacroShowNameSET;
    private static boolean bReadedMacroShowOrderSET;
    private static final String DEFAULT_CREASE_POINT_NUMBER = "default_crease_point_number ";
    private static final String DEFAULT_CONNECT_POLICY = "default_connect_policy ";
    private static final String CONNECT_POLICY_DIRECT = "direct";
    private static final String CONNECT_POLICY_SQUARE = "square";
    private static final String DEFAULT_GLogicGate_Src_NUMBER = "default_glogicgate_src_number ";

    static {
        isAutoTagShowing = isAutoTagShowingSystemDefault = true;
        autoTagOutput = "showCloneMarkerFlag";
        iconSize = 16;
        isShowingSpeciesRemovedDialogInPlugin = false;
        speciesNameFont = 12;
        iGLogicGateSrcNums = 2;
        showTree = true;
        listPositionMode = 2;
        dividepos1 = 0;
        dividepos2 = 0;
        isWinLayoutInfoReaded = false;
        panesVisibles = Preference.getDefaultSplitPanesVisibles();
        panesOrientations = Preference.getDefaultSplitPanesOrientations();
        dividerLocations = Preference.getDefaultSplitPanesDividerLocations();
        AUTO_LAYOUT_MODE = true;
        cdVersion = String.valueOf(43000).substring(0, 2);
        prefDirPath = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".celldesigner";
        filename = String.valueOf(prefDirPath) + System.getProperty("file.separator") + "celldesigner_preference-" + cdVersion + ".txt";
        speciesRemovedCaution = "In the previous action, a SpeciesAlias (an object on the canvas) changed its reference from a Species to another, \nor was removed from the canvas with the referring Species.\nAs a result, the original Species, and its attributes and notes as well, were removed from the current SBML model.\n\nNote that Undo (from Edit menu or by CTRL-Z) will restore the Species.";
        bUserDefaultShowCompartmentAllToolbarbuttons = false;
        readedMainWinToolbarNameSET = null;
        SBOTERMVALUE_VIEW = 0;
        recentFiles = new RecentFiles();
        Preference.readFile();
        bReadedMacroShowNameSET = false;
        bReadedMacroShowOrderSET = false;
    }

    private static boolean[] getDefaultSplitPanesVisibles() {
        return new boolean[]{true, true, true, true};
    }

    private static int[] getDefaultSplitPanesOrientations() {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = 1;
        return nArray;
    }

    private static int[] getDefaultSplitPanesDividerLocations() {
        return new int[]{150, 399, 576, 293};
    }

    private static void setDefaultSplitPaneProperties() {
        panesVisibles = Preference.getDefaultSplitPanesVisibles();
        panesOrientations = Preference.getDefaultSplitPanesOrientations();
        dividerLocations = Preference.getDefaultSplitPanesDividerLocations();
    }

    public static final Color getNotCompliantSBGNViewerColor() {
        return new Color(192, 192, 192);
    }

    private static boolean readFile() {
        boolean status;
        boolean rtn = false;
        File file = null;
        File dir = new File(prefDirPath);
        if (!dir.isDirectory() && !(status = dir.mkdirs())) {
            JOptionPane.showOptionDialog(MainWindow.getLastInstance(), "Can't make directory " + prefDirPath + ". Please check the directory permission.", "Can't make directory" + prefDirPath, -1, 0, null, new Object[]{"OK"}, "Close");
            System.exit(1);
        }
        if ((file = new File(filename)).exists()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader(fis);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while (!(line = br.readLine()).equals(endOfPreference) && line != null) {
                    if (line.equals(beginOfSpeciesSetting)) {
                        iomode = 1;
                        continue;
                    }
                    if (line.equals(beginOfCompartmentSetting)) {
                        iomode = 2;
                        continue;
                    }
                    if (line.equals(beginOfRecentFiles)) {
                        iomode = 3;
                        continue;
                    }
                    if (line.equals(beginOfReactionSetting)) {
                        iomode = 4;
                        continue;
                    }
                    if (line.equals(beginOfEditorUISetting)) {
                        iomode = 5;
                        continue;
                    }
                    if (line.equals(beginOfMacroUISetting)) {
                        iomode = 6;
                        continue;
                    }
                    if (line.equals(beginOfMainWinToolbarSetting)) {
                        iomode = 8;
                        continue;
                    }
                    if (line.equals(beginOfWindowLayoutSetting)) {
                        iomode = 7;
                        continue;
                    }
                    if (iomode == 0) {
                        Preference.parseLine(line);
                        continue;
                    }
                    if (iomode == 1) {
                        Preference.parseLineForSpecies(line);
                        continue;
                    }
                    if (iomode == 2) {
                        Preference.parseLineForCompartment(line);
                        continue;
                    }
                    if (iomode == 3) {
                        Preference.parseLineForRecentFiles(line);
                        continue;
                    }
                    if (iomode == 4) {
                        Preference.parseLineForReaction(line);
                        continue;
                    }
                    if (iomode == 5) {
                        Preference.parseLineForEditorUI(line);
                        continue;
                    }
                    if (iomode == 6) {
                        Preference.parseLineForMacroUI(line);
                        continue;
                    }
                    if (iomode == 8) {
                        Preference.parseLineForMainWinToolbarSetting(line);
                        continue;
                    }
                    if (iomode != 7) continue;
                    isWinLayoutInfoReaded = true;
                    Preference.parseLineForWindowsLayout(line);
                }
                br.close();
                isr.close();
                fis.close();
                rtn = true;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(MainWindow.getLastInstance(), "Error occurred when reading \"" + filename + "\".\n" + e.getMessage(), "Preference read error", 0);
            }
        } else {
            openingPath = System.getProperty("user.dir");
            savingPath = System.getProperty("user.home");
        }
        return rtn;
    }

    private static void parseLineForEditorUI(String line) {
        String[] items = line.split("\\s");
        String declarator = items[0];
        String value1 = items[1];
        if (declarator.equals(InputRepeatModeDeclarator)) {
            inputRepeatOn = value1 != null || value1.equals(On);
        }
    }

    private static void parseLineForMacroUI(String line) {
        String[] items = line.split("\\s");
        String declarator = items[0];
        String value1 = "";
        try {
            if (declarator == null || declarator.equals("")) {
                return;
            }
            if (declarator.equals(MacroNameDeclarator)) {
                value1 = line.substring(MacroNameDeclarator.length() + 1);
            } else if (declarator.equals(MacroShowOrderDeclarator)) {
                value1 = line.substring(MacroShowOrderDeclarator.length() + 1);
            }
        }
        catch (Exception e) {
            value1 = null;
        }
        if (value1 == null || value1.trim().equals("")) {
            return;
        }
        if (declarator.equals(MacroNameDeclarator)) {
            bReadedMacroShowNameSET = true;
            if (value1 != null) {
                MainWindow.readedMacroShowNameSET = value1.split(",");
            }
        } else if (declarator.equals(MacroShowOrderDeclarator)) {
            bReadedMacroShowOrderSET = true;
            if (value1 != null) {
                String[] tmp = value1.split(",");
                if (tmp == null) {
                    return;
                }
                MainWindow.readedMacroShowOrderSET = new int[tmp.length];
                int i = 0;
                while (i < tmp.length) {
                    int iTmp;
                    try {
                        iTmp = Integer.parseInt(tmp[i].trim());
                        if (iTmp < 0) {
                            iTmp = 0;
                            MainWindow.bSavedMacroUIDataHaveErrFlg = true;
                        }
                    }
                    catch (Exception e) {
                        iTmp = 0;
                        MainWindow.bSavedMacroUIDataHaveErrFlg = true;
                    }
                    MainWindow.readedMacroShowOrderSET[i] = iTmp;
                    ++i;
                }
            }
        }
        if (bReadedMacroShowNameSET && bReadedMacroShowOrderSET) {
            MainWindow.bHaveSavedMacroUIDataFlg = true;
        }
    }

    private static void parseLineForMainWinToolbarSetting(String line) {
        String[] items = line.split("\\s");
        String declarator = items[0];
        String value1 = "";
        try {
            if (declarator == null || declarator.equals("")) {
                return;
            }
            if (declarator.equals(MainWinToolbarNameDeclarator)) {
                value1 = line.substring(MainWinToolbarNameDeclarator.length() + 1);
                readedMainWinToolbarNameSET = null;
            } else if (declarator.equals(MainWinToolbarVisibleDeclarator)) {
                value1 = line.substring(MainWinToolbarVisibleDeclarator.length() + 1);
            }
        }
        catch (Exception myErr) {
            value1 = null;
        }
        if (value1 == null || value1.trim().equals("")) {
            return;
        }
        if (declarator.equals(MainWinToolbarNameDeclarator)) {
            if (value1 != null) {
                readedMainWinToolbarNameSET = value1.split(",");
            }
        } else if (declarator.equals(MainWinToolbarVisibleDeclarator) && value1 != null) {
            String[] tmp = value1.split(",");
            if (tmp == null) {
                return;
            }
            if (readedMainWinToolbarNameSET == null) {
                return;
            }
            if (tmp.length != readedMainWinToolbarNameSET.length) {
                return;
            }
            int i = 0;
            while (i < tmp.length) {
                try {
                    boolean bState = true;
                    if (tmp[i].trim().toLowerCase().equals("false".toLowerCase())) {
                        bState = false;
                    }
                    MainWindow.setToolbarVisibleStateFlgOnly(readedMainWinToolbarNameSET[i], bState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    private static void parseLineForSpecies(String line) {
        String[] items = line.split("\\s");
        String[] values = items[1].split(",");
        Color color = new Color(Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]), Integer.parseInt(values[3]));
        SpeciesColorScheme.setColor(items[0], color);
        PaintScheme paint = PaintSchemeFactory.create(values[4]);
        SpeciesColorScheme.setScheme(items[0], paint);
        SpeciesColorScheme.setLineWidth(items[0], Double.parseDouble(values[5]));
    }

    private static void parseLineForCompartment(String line) {
        String[] items = line.split("\\s");
        String[] values = items[1].split(",");
        Color color = new Color(Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]), Integer.parseInt(values[3]));
        CompartmentColorScheme.setColor(items[0], color);
        PaintScheme paint = PaintSchemeFactory.create(values[4]);
        CompartmentColorScheme.setScheme(items[0], paint);
        Membrane m = new Membrane(Double.parseDouble(values[5]), Double.parseDouble(values[6]), Double.parseDouble(values[7]));
        CompartmentColorScheme.setMembrane(items[0], m);
    }

    private static void parseLineForRecentFiles(String line) {
        if (line.startsWith("max_recent_file_items ")) {
            String[] words = line.split(" ");
            if (words.length > 1) {
                recentFiles.setMaxItemNumber(Integer.parseInt(words[1]));
            }
        } else {
            recentFiles.add(line);
        }
    }

    private static void parseLineForReaction(String line) {
        if (line.startsWith(DEFAULT_CREASE_POINT_NUMBER)) {
            String[] words = line.split(" ");
            if (words.length > 1) {
                try {
                    int value = Integer.parseInt(words[1]);
                    GLinkedLine.setDefaultCreasePointNumber(value);
                }
                catch (NumberFormatException value) {}
            }
        } else if (line.startsWith(DEFAULT_CONNECT_POLICY)) {
            String[] words = line.split(" ");
            if (words.length > 1) {
                if (words[1].equals(CONNECT_POLICY_SQUARE)) {
                    GLinkedLine.setDefaultConnectPolicy(1);
                } else {
                    GLinkedLine.setDefaultConnectPolicy(0);
                }
            }
        } else if (line.startsWith(DEFAULT_GLogicGate_Src_NUMBER)) {
            String[] words = line.split(" ");
            if (words.length > 1) {
                try {
                    int value;
                    iGLogicGateSrcNums = value = Integer.parseInt(words[1]);
                }
                catch (Exception value) {}
            }
        } else {
            String[] items = line.split("\\s");
            String[] values = items[1].split(",");
            Color color = new Color(Integer.parseInt(values[0]), Integer.parseInt(values[1]), Integer.parseInt(values[2]), Integer.parseInt(values[3]));
            ReactionColorScheme.setColor(items[0], color);
            ReactionColorScheme.setLineWidth(items[0], Double.parseDouble(values[4]));
            if (values.length > 5) {
                ReactionColorScheme.setLineType(items[0], Integer.parseInt(values[5]));
            }
        }
    }

    private static void parseLine(String line) {
        block64: {
            StringTokenizer st = new StringTokenizer(line);
            String item = st.nextToken();
            if (item.equals("openingPath")) {
                String value;
                if (line.indexOf("\"") != -1) {
                    String dummy = st.nextToken("\"");
                    value = st.nextToken("\"");
                } else {
                    value = st.nextToken();
                }
                openingPath = value;
            } else if (item.equals("savingPath")) {
                String value;
                if (line.indexOf("\"") != -1) {
                    String dummy = st.nextToken("\"");
                    value = st.nextToken("\"");
                } else {
                    value = st.nextToken();
                }
                savingPath = value;
            } else if (item.equals("windowPosition")) {
                String value = st.nextToken();
                String x_str = value.substring(0, value.indexOf(","));
                String y_str = value.substring(value.indexOf(",") + 1);
                try {
                    int x = Integer.parseInt(x_str);
                    int y = Integer.parseInt(y_str);
                    windowPosition = new Point(x, y);
                }
                catch (NumberFormatException x) {}
            } else if (item.equals("windowSize")) {
                String value = st.nextToken();
                String swidth = value.substring(0, value.indexOf(","));
                String sheight = value.substring(value.indexOf(",") + 1);
                try {
                    int width = Integer.parseInt(swidth);
                    int height = Integer.parseInt(sheight);
                    windowSize = new Dimension(width, height);
                }
                catch (NumberFormatException width) {}
            } else if (item.equals("windowState")) {
                String value = st.nextToken();
                try {
                    windowState = Integer.parseInt(value);
                }
                catch (NumberFormatException swidth) {}
            } else if (item.equals("showPDCaution")) {
                String value = st.nextToken();
                showPDCaution = Boolean.valueOf(value);
            } else if (item.equals("showSpeciesRemovedCaution")) {
                String value = st.nextToken();
                showSpeciesRemovedCaution = Boolean.valueOf(value);
            } else if (item.equals("defaultSpeciesSize")) {
                String value;
                String type = value = st.nextToken();
                try {
                    String value2 = st.nextToken();
                    StringTokenizer st2 = new StringTokenizer(value2, ",");
                    String w_str = st2.nextToken();
                    String h_str = st2.nextToken();
                    int w = Integer.parseInt(w_str);
                    int h = Integer.parseInt(h_str);
                    Dimension d = new Dimension(w, h);
                    defaultSpeciesSize.put(type, d);
                }
                catch (NumberFormatException value2) {}
            } else if (item.equals("isGridSnaped")) {
                String value = st.nextToken();
                isGridSnaped = Boolean.valueOf(value);
            } else if (item.equals("gridSnapSize")) {
                String value = st.nextToken();
                String x_str = value.substring(0, value.indexOf(","));
                String y_str = value.substring(value.indexOf(",") + 1);
                try {
                    double x = Double.parseDouble(x_str);
                    double y = Double.parseDouble(y_str);
                    gridSnapSize = new Point2D.Double(x, y);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (item.equals("isGridShowing")) {
                String value = st.nextToken();
                isGridShowing = Boolean.valueOf(value);
            } else if (item.equals("antialias")) {
                String value = st.nextToken();
                antialias = Boolean.valueOf(value);
            } else if (item.equals("showReanctionId")) {
                String value = st.nextToken();
                showReaction = Boolean.valueOf(value);
            } else if (item.equals(autoTagOutput)) {
                isAutoTagShowing = isAutoTagShowingSystemDefault;
                String value = st.nextToken();
                if (value != null) {
                    isAutoTagShowing = value.trim().toLowerCase().equals("true".toLowerCase());
                }
            } else if (item.equals(strShowCompartmentAllToolbarbuttons)) {
                String value = st.nextToken();
                if (value != null) {
                    bUserDefaultShowCompartmentAllToolbarbuttons = value.trim().toLowerCase().equals("true".toLowerCase());
                }
            } else if (item.equals("ToolbarIconimageSize")) {
                String value = st.nextToken();
                try {
                    iconSize = Integer.parseInt(value);
                    if (iconSize != 16 && iconSize != 24) {
                        iconSize = 16;
                    }
                }
                catch (Exception ex) {
                    iconSize = 16;
                }
            } else if (item.equals(speciesNameFontSizeSetting)) {
                String value = st.nextToken();
                try {
                    speciesNameFont = Integer.parseInt(value);
                    if (!PopupSpeciesNameFontDialog.checkerFontSizeEffectiveness(speciesNameFont)) {
                        throw new Exception();
                    }
                }
                catch (Exception ex) {
                    speciesNameFont = 12;
                }
            } else if (item.equals(showSpeciesRemovedDialogInPlugin)) {
                String value = st.nextToken();
                try {
                    if (value.trim().toLowerCase().equals("true".toLowerCase())) {
                        isShowingSpeciesRemovedDialogInPlugin = true;
                        break block64;
                    }
                    isShowingSpeciesRemovedDialogInPlugin = false;
                }
                catch (Exception ex) {
                    isShowingSpeciesRemovedDialogInPlugin = false;
                }
            } else if (item.equals(strShowSBOTermValue)) {
                String value = st.nextToken();
                try {
                    SBOTERMVALUE_VIEW = Integer.parseInt(value);
                }
                catch (Exception ex) {
                    SBOTERMVALUE_VIEW = 0;
                }
            }
        }
    }

    private static void parseLineForWindowsLayout(String line) {
        try {
            StringTokenizer st = new StringTokenizer(line);
            String item = st.nextToken();
            String value = "";
            if (line.indexOf("\"") != -1) {
                st.nextToken("\"");
                value = st.nextToken("\"");
            } else {
                value = st.nextToken();
            }
            if (item.equals(panesVisiblesString)) {
                String[] array = value.split(",", 0);
                panesVisibles = new boolean[array.length];
                int i = 0;
                while (i < array.length) {
                    Preference.panesVisibles[i] = Boolean.valueOf(array[i]);
                    ++i;
                }
            } else if (item.equals(panesOrientationsString)) {
                String[] array = value.split(",", 0);
                panesOrientations = new int[array.length];
                int i = 0;
                while (i < array.length) {
                    Preference.panesOrientations[i] = Integer.parseInt(array[i].trim());
                    ++i;
                }
            } else if (item.equals(dividerLocationsString)) {
                String[] array = value.split(",", 0);
                dividerLocations = new int[array.length];
                int i = 0;
                while (i < array.length) {
                    Preference.dividerLocations[i] = Integer.parseInt(array[i].trim());
                    ++i;
                }
            } else if (item.equals(divideposString)) {
                String[] array = value.split(",", 0);
                dividepos1 = Integer.parseInt(array[0].trim());
                dividepos2 = Integer.parseInt(array[1].trim());
            } else if (item.equals(showTreeString)) {
                showTree = Boolean.valueOf(value);
            } else if (item.equals(listPositionModeString)) {
                listPositionMode = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            Preference.setDefaultSplitPaneProperties();
            showTree = true;
            listPositionMode = 2;
            dividepos1 = 0;
            dividepos2 = 0;
            isWinLayoutInfoReaded = false;
        }
    }

    public static void saveWindowLayoutInfo(MainWindow window) {
        JSplitPane[] panes = window.getSplitPanes();
        int length = panes.length;
        panesVisibles = new boolean[length];
        panesOrientations = new int[length];
        dividerLocations = new int[length];
        int i = 0;
        while (i < length) {
            Preference.panesVisibles[i] = panes[i].isOneTouchExpandable();
            Preference.panesOrientations[i] = panes[i].getOrientation();
            Preference.dividerLocations[i] = panes[i].getDividerLocation();
            ++i;
        }
    }

    public static void save() {
        try {
            String key;
            File file = null;
            file = new File(filename);
            if (file.exists() && !file.canWrite()) {
                JOptionPane.showOptionDialog(MainWindow.getLastInstance(), "Can't write " + filename + ". Please check the file permission.", "Can't write " + filename, -1, 0, null, new Object[]{"OK"}, "Close");
                return;
            }
            FileOutputStream fos = new FileOutputStream(file);
            PrintWriter pw = new PrintWriter(fos);
            String line = "";
            if (windowPosition != null) {
                line = "windowPosition " + Preference.windowPosition.x + "," + Preference.windowPosition.y;
                pw.println(line);
            }
            if (windowSize != null) {
                line = "windowSize " + Preference.windowSize.width + "," + Preference.windowSize.height;
                pw.println(line);
            }
            pw.println("windowState " + windowState);
            if (openingPath != null) {
                line = "openingPath \"" + openingPath + "\"";
                pw.println(line);
            }
            if (savingPath != null) {
                line = "savingPath \"" + savingPath + "\"";
                pw.println(line);
            }
            if (!showPDCaution) {
                line = "showPDCaution false";
                pw.println(line);
            }
            if (!showSpeciesRemovedCaution) {
                line = "showSpeciesRemovedCaution false";
                pw.println(line);
            }
            int i = 0;
            while (i < sbmlDlgBounds.length) {
                if (sbmlDlgBounds[i] != null) {
                    line = "sbmlDlgBounds " + i + " " + Preference.sbmlDlgBounds[i].x + "," + Preference.sbmlDlgBounds[i].y + "," + Preference.sbmlDlgBounds[i].width + "," + Preference.sbmlDlgBounds[i].height;
                }
                ++i;
            }
            i = 0;
            while (i < isSbmlDlgOpen.length) {
                if (isSbmlDlgOpen[i]) {
                    line = "isSbmlDlgOpen " + i + " true";
                }
                ++i;
            }
            if (sbwJarPath != null) {
                line = "sbwJarPath \"" + sbwJarPath + "\"";
                pw.println(line);
            }
            Enumeration enumeration = defaultSpeciesSize.keys();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                Dimension d = (Dimension)defaultSpeciesSize.get(key);
                line = "defaultSpeciesSize " + key + " " + d.width + "," + d.height;
                pw.println(line);
            }
            enumeration = defaultSpeciesColor.keys();
            while (enumeration.hasMoreElements()) {
                key = (String)enumeration.nextElement();
                Color c = (Color)defaultSpeciesColor.get(key);
                line = "defaultSpeciesColor " + key + " " + c.getRed() + "," + c.getGreen() + "," + c.getBlue();
                pw.println(line);
            }
            if (isGridSnaped) {
                line = "isGridSnaped true";
                pw.println(line);
            }
            if (gridSnapSize != null) {
                line = "gridSnapSize " + Preference.gridSnapSize.x + "," + Preference.gridSnapSize.y;
                pw.println(line);
            }
            if (isGridShowing) {
                line = "isGridShowing true";
                pw.println(line);
            }
            pw.println("SBOTermValue " + SBOTERMVALUE_VIEW);
            pw.println("antialias " + antialias);
            pw.println("showReanctionId " + showReaction);
            pw.println(String.valueOf(autoTagOutput) + " " + isAutoTagShowing);
            pw.println("showCompartmentAllToolbarbuttons " + bUserDefaultShowCompartmentAllToolbarbuttons);
            line = "ToolbarIconimageSize " + iconSize;
            pw.println(line);
            line = "SpeciesNameFont " + speciesNameFont;
            pw.println(line);
            pw.println(beginOfEditorUISetting);
            if (inputRepeatOn) {
                pw.println("input_repeat_mode ON");
            }
            pw.println(beginOfSpeciesSetting);
            pw.println(SpeciesColorScheme.serialize());
            pw.println(beginOfCompartmentSetting);
            pw.println(CompartmentColorScheme.serialize());
            pw.println(beginOfRecentFiles);
            pw.println("max_recent_file_items " + recentFiles.getMaxItemNumber());
            String rfiles = recentFiles.serialize();
            if (!rfiles.equals("")) {
                pw.println(recentFiles.serialize());
            }
            pw.println(beginOfReactionSetting);
            pw.println(DEFAULT_CREASE_POINT_NUMBER + GLinkedLine.getDefaultCreasePointNumber());
            pw.println(DEFAULT_GLogicGate_Src_NUMBER + iGLogicGateSrcNums);
            if (GLinkedLine.getDefaultConnectPolicy() == 1) {
                pw.println("default_connect_policy square");
            } else {
                pw.println("default_connect_policy direct");
            }
            pw.println(ReactionColorScheme.serialize());
            if (MainWindow.SystemMacroNumbers > 1) {
                pw.println(beginOfMacroUISetting);
                String strOutputMacroNameLine = "NAME ";
                int i2 = 0;
                while (i2 < MainWindow.SystemMacroNumbers - 1) {
                    strOutputMacroNameLine = String.valueOf(strOutputMacroNameLine) + MainWindow.SystemMacroNameSET[i2] + ",";
                    ++i2;
                }
                strOutputMacroNameLine = String.valueOf(strOutputMacroNameLine) + MainWindow.SystemMacroNameSET[MainWindow.SystemMacroNumbers - 1];
                String strOutputMacroOrderLine = "ORDER ";
                int i3 = 0;
                while (i3 < MainWindow.SystemMacroNumbers - 1) {
                    strOutputMacroOrderLine = String.valueOf(strOutputMacroOrderLine) + MainWindow.currMacroShowOrderSET[i3] + ",";
                    ++i3;
                }
                strOutputMacroOrderLine = String.valueOf(strOutputMacroOrderLine) + MainWindow.currMacroShowOrderSET[MainWindow.SystemMacroNumbers - 1];
                pw.println(strOutputMacroNameLine);
                pw.println(strOutputMacroOrderLine);
            }
            if (MainWindow.strToolbarVisibleMenuMsg.length > 1) {
                pw.println(beginOfMainWinToolbarSetting);
                String strOutputMainWinToolbarLine = "TOOLBARNAME ";
                String strOutputMainWinToolbarVisibleLine = "VISIBLE ";
                boolean[] bState = MainWindow.getToolbarVisibleStates();
                int i4 = 0;
                while (i4 < MainWindow.strToolbarVisibleMenuMsg.length - 1) {
                    String strName = MainWindow.strToolbarVisibleMenuMsg[i4][0];
                    strOutputMainWinToolbarLine = String.valueOf(strOutputMainWinToolbarLine) + strName + ",";
                    strOutputMainWinToolbarVisibleLine = String.valueOf(strOutputMainWinToolbarVisibleLine) + bState[i4] + ",";
                    ++i4;
                }
                strOutputMainWinToolbarLine = String.valueOf(strOutputMainWinToolbarLine) + MainWindow.strToolbarVisibleMenuMsg[MainWindow.strToolbarVisibleMenuMsg.length - 1][0];
                strOutputMainWinToolbarVisibleLine = String.valueOf(strOutputMainWinToolbarVisibleLine) + bState[MainWindow.strToolbarVisibleMenuMsg.length - 1];
                pw.println(strOutputMainWinToolbarLine);
                pw.println(strOutputMainWinToolbarVisibleLine);
            }
            pw.println(beginOfWindowLayoutSetting);
            String value = "";
            int i5 = 0;
            while (i5 < panesVisibles.length) {
                if (i5 > 0) {
                    value = String.valueOf(value) + ",";
                }
                value = String.valueOf(value) + String.valueOf(panesVisibles[i5]);
                ++i5;
            }
            pw.println("panesVisibles " + value);
            value = "";
            i5 = 0;
            while (i5 < panesOrientations.length) {
                if (i5 > 0) {
                    value = String.valueOf(value) + ",";
                }
                value = String.valueOf(value) + String.valueOf(panesOrientations[i5]);
                ++i5;
            }
            pw.println("panesOrientations " + value);
            value = "";
            i5 = 0;
            while (i5 < dividerLocations.length) {
                if (i5 > 0) {
                    value = String.valueOf(value) + ",";
                }
                value = String.valueOf(value) + String.valueOf(dividerLocations[i5]);
                ++i5;
            }
            pw.println("dividerLocations " + value);
            pw.println("showTree " + showTree);
            pw.println("listPositionMode " + listPositionMode);
            pw.println("divideposes " + dividepos1 + "," + dividepos2);
            pw.println(endOfPreference);
            pw.close();
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isSelected_SBOTermNotCare() {
        return SBOTERMVALUE_VIEW == 0;
    }

    public static boolean isSelected_SBOTermSET() {
        return SBOTERMVALUE_VIEW == 1;
    }

    public static boolean isSelected_SBOTermREMOVE() {
        return SBOTERMVALUE_VIEW == 2;
    }
}

