/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.util.ArrayList;
import jp.fric.graphics.draw.GLinkedShape;
import jp.sbi.celldesigner.plugin.PluginAlgebraicRule;
import jp.sbi.celldesigner.plugin.PluginAssignmentRule;
import jp.sbi.celldesigner.plugin.PluginCompartment;
import jp.sbi.celldesigner.plugin.PluginCompartmentType;
import jp.sbi.celldesigner.plugin.PluginConstraint;
import jp.sbi.celldesigner.plugin.PluginEvent;
import jp.sbi.celldesigner.plugin.PluginEventAssignment;
import jp.sbi.celldesigner.plugin.PluginFunctionDefinition;
import jp.sbi.celldesigner.plugin.PluginInitialAssignment;
import jp.sbi.celldesigner.plugin.PluginKineticLaw;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginModel;
import jp.sbi.celldesigner.plugin.PluginParameter;
import jp.sbi.celldesigner.plugin.PluginRateRule;
import jp.sbi.celldesigner.plugin.PluginReaction;
import jp.sbi.celldesigner.plugin.PluginRule;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSimpleSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginSpecies;
import jp.sbi.celldesigner.plugin.PluginSpeciesReference;
import jp.sbi.celldesigner.plugin.PluginSpeciesType;
import jp.sbi.celldesigner.plugin.PluginUnit;
import jp.sbi.celldesigner.plugin.PluginUnitDefinition;
import jp.sbi.celldesigner.sbmlExtension.CompartmentAnnotation;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.celldesigner.sbmlExtension.ReactionAnnotation;
import jp.sbi.celldesigner.sbmlExtension.SpeciesAnnotation;
import jp.sbi.sbml.util.ConstraintDialog;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.ASTNode;
import org.sbml.libsbml.AlgebraicRule;
import org.sbml.libsbml.AssignmentRule;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.CompartmentType;
import org.sbml.libsbml.Constraint;
import org.sbml.libsbml.Event;
import org.sbml.libsbml.EventAssignment;
import org.sbml.libsbml.FunctionDefinition;
import org.sbml.libsbml.InitialAssignment;
import org.sbml.libsbml.KineticLaw;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.ModifierSpeciesReference;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.RateRule;
import org.sbml.libsbml.Reaction;
import org.sbml.libsbml.Rule;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;
import org.sbml.libsbml.SpeciesReference;
import org.sbml.libsbml.SpeciesType;
import org.sbml.libsbml.StoichiometryMath;
import org.sbml.libsbml.Unit;
import org.sbml.libsbml.UnitDefinition;
import org.sbml.libsbml.XMLNode;
import org.sbml.libsbml.libsbml;

public final class PluginSBaseConverter {
    public static final Model convertToModel(PluginModel pmodel, Model targetModel) {
        CompartmentType ct;
        PluginSBase pct;
        Rule rl;
        PluginSBase prl;
        targetModel.setId(pmodel.getId());
        targetModel.setName(pmodel.getName());
        targetModel.setNotes(pmodel.getNotes());
        ModelAnnotation.setAnnotationOfSBase(pmodel, (SBase)targetModel, null);
        int i = 0;
        while (i < pmodel.getNumSpecies()) {
            PluginSpecies psp = pmodel.getSpecies(i);
            Species sp = PluginSBaseConverter.convertToSpecies(psp, new Species());
            targetModel.addSpecies(sp);
            ++i;
        }
        i = 0;
        while (i < pmodel.getNumReactions()) {
            PluginReaction pre = pmodel.getReaction(i);
            Reaction re = PluginSBaseConverter.convertToReaction(pre, new Reaction());
            targetModel.addReaction(re);
            ++i;
        }
        i = 0;
        while (i < pmodel.getNumCompartments()) {
            PluginCompartment pcom = pmodel.getCompartment(i);
            Compartment com = PluginSBaseConverter.convertToCompartment(pcom, new Compartment());
            targetModel.addCompartment(com);
            ++i;
        }
        i = 0;
        while (i < pmodel.getNumEvents()) {
            PluginEvent pev = pmodel.getEvent(i);
            Event ev = PluginSBaseConverter.convertToEvent(pev);
            targetModel.addEvent(ev);
            ++i;
        }
        i = 0;
        while (i < pmodel.getNumParameters()) {
            PluginParameter ppm = pmodel.getParameter(i);
            Parameter pm = PluginSBaseConverter.convertToParameter(ppm);
            targetModel.addParameter(pm);
            ++i;
        }
        i = 0;
        while (i < pmodel.getNumFunctionDefinitions()) {
            PluginFunctionDefinition pfd = pmodel.getFunctionDefinition(i);
            FunctionDefinition fd = PluginSBaseConverter.convertToFunctionDefinition(pfd);
            targetModel.addFunctionDefinition(fd);
            ++i;
        }
        i = 0;
        while (i < pmodel.getNumRules()) {
            prl = pmodel.getRule(i);
            rl = PluginSBaseConverter.convertToRule(prl);
            targetModel.addRule(rl);
            ++i;
        }
        i = 0;
        while (i < pmodel.getNumUnitDefinitions()) {
            prl = pmodel.getUnitDefinition(i);
            rl = PluginSBaseConverter.convertToUnitDefinition((PluginUnitDefinition)prl);
            targetModel.addUnitDefinition((UnitDefinition)rl);
            ++i;
        }
        i = 0;
        while (i < pmodel.getNumSpeciesTypes()) {
            PluginSpeciesType pst = pmodel.getSpeciesType(i);
            SpeciesType st = PluginSBaseConverter.convertToSpeciesType(pst);
            targetModel.addSpeciesType(st);
            ++i;
        }
        i = 0;
        while (i < pmodel.getNumCompartmentTypes()) {
            pct = pmodel.getCompartmentType(i);
            ct = PluginSBaseConverter.convertToCompartmentType(pct);
            targetModel.addCompartmentType(ct);
            ++i;
        }
        i = 0;
        while (i < pmodel.getNumInitialAssignments()) {
            PluginInitialAssignment pia = pmodel.getInitialAssignment(i);
            InitialAssignment ia = PluginSBaseConverter.convertToInitialAssignment(pia);
            targetModel.addInitialAssignment(ia);
            ++i;
        }
        i = 0;
        while (i < pmodel.getNumConstraints()) {
            pct = pmodel.getConstraint(i);
            ct = PluginSBaseConverter.convertToConstraint((PluginConstraint)pct);
            targetModel.addConstraint((Constraint)ct);
            ++i;
        }
        return targetModel;
    }

    public static final Species convertToSpecies(PluginSpecies pspecies, Species species) {
        species.setId(pspecies.getId());
        species.setName(pspecies.getName());
        species.setSpeciesType(pspecies.getSpeciesType());
        species.setNotes(pspecies.getNotes());
        species.setBoundaryCondition(pspecies.getBoundaryCondition());
        species.setCharge(pspecies.getCharge());
        species.setCompartment(pspecies.getCompartment());
        species.setConstant(pspecies.getConstant());
        species.setHasOnlySubstanceUnits(pspecies.getHasOnlySubstanceUnits());
        species.setSubstanceUnits(pspecies.getSubstanceUnits());
        species.setUnits(pspecies.getUnits());
        ModelAnnotation.setAnnotationOfSBase(pspecies, (SBase)species, null);
        if (pspecies.isSetInitialAmount()) {
            species.setInitialAmount(pspecies.getInitialAmount());
        } else {
            species.setInitialConcentration(pspecies.getInitialConcentration());
        }
        SpeciesAnnotation annotation = (SpeciesAnnotation)LibSBMLUtil.getAnnotation((SBase)species, null);
        annotation.setPositionFromString(pspecies.getPositionToCompartment());
        return species;
    }

    public static final Reaction convertToReaction(PluginReaction preaction, Reaction reaction) {
        SpeciesReference ref;
        PluginSimpleSpeciesReference pref;
        reaction.setId(preaction.getId());
        reaction.setName(preaction.getName());
        reaction.setNotes(preaction.getNotes());
        reaction.setFast(preaction.getFast());
        reaction.setReversible(preaction.getReversible());
        ModelAnnotation.setAnnotationOfSBase(preaction, (SBase)reaction, null);
        int i = 0;
        while (i < preaction.getNumReactants()) {
            pref = preaction.getReactant(i);
            ref = PluginSBaseConverter.convertToSpeciesReference(pref);
            reaction.addReactant(ref);
            ++i;
        }
        i = 0;
        while (i < preaction.getNumProducts()) {
            pref = preaction.getProduct(i);
            ref = PluginSBaseConverter.convertToSpeciesReference(pref);
            reaction.addProduct(ref);
            ++i;
        }
        i = 0;
        while (i < preaction.getNumModifiers()) {
            pref = preaction.getModifier(i);
            ref = PluginSBaseConverter.convertToModifierSpeciesReference(pref);
            reaction.addModifier((ModifierSpeciesReference)ref);
            ++i;
        }
        if (reaction.getKineticLaw() != null) {
            reaction.setKineticLaw(PluginSBaseConverter.convertToKineticLaw(preaction.getKineticLaw()));
        }
        ReactionAnnotation annotation = (ReactionAnnotation)LibSBMLUtil.getAnnotation((SBase)reaction, null);
        annotation.setType(preaction.getReactionType());
        GLinkedShape symbol = (GLinkedShape)((Object)annotation.getBaseLink().getSymbol());
        symbol.setColor(preaction.getLineColor());
        symbol.setLineWidth(preaction.getLineWidth());
        return reaction;
    }

    public static final Compartment convertToCompartment(PluginCompartment pcompartment, Compartment compartment) {
        compartment.setId(pcompartment.getId());
        compartment.setName(pcompartment.getName());
        compartment.setCompartmentType(pcompartment.getCompartmentTypeOfPanel());
        compartment.setNotes(pcompartment.getNotes());
        compartment.setConstant(pcompartment.getConstant());
        compartment.setOutside(pcompartment.getOutside());
        compartment.setSize(pcompartment.getSize());
        compartment.setSpatialDimensions(pcompartment.getSpatialDimensions());
        compartment.setUnits(pcompartment.getUnits());
        compartment.setVolume(pcompartment.getVolume());
        ModelAnnotation.setAnnotationOfSBase(pcompartment, (SBase)compartment, null);
        CompartmentAnnotation annotation = (CompartmentAnnotation)LibSBMLUtil.getAnnotation((SBase)compartment, null);
        annotation.setCompartmentName(pcompartment.getName());
        return compartment;
    }

    public static final Event convertToEvent(PluginEvent event) {
        Event newEvent = new Event();
        if (event.getDelay() != null) {
            newEvent.setDelay(event.getDelay().cloneObject());
            LibSBMLUtil.changetoAstTimeNode(newEvent.getDelay().getMath());
        }
        newEvent.setId(event.getId());
        newEvent.setName(event.getName());
        newEvent.setNotes(event.getNotes());
        newEvent.setTimeUnits(event.getTimeUnits());
        newEvent.setUseValuesFromTriggerTime(event.getUseValuesFromTriggerTime());
        ModelAnnotation.setAnnotationOfSBase(event, (SBase)newEvent, null);
        if (event.getTrigger() != null) {
            newEvent.setTrigger(event.getTrigger().cloneObject());
            LibSBMLUtil.changetoAstTimeNode(newEvent.getTrigger().getMath());
        }
        int i = 0;
        while (i < event.getNumEventAssignments()) {
            PluginEventAssignment pev = event.getEventAssignment(i);
            EventAssignment ev = PluginSBaseConverter.convertToEventAssignment(pev);
            if (ev != null) {
                LibSBMLUtil.changetoAstTimeNode(ev.getMath());
            }
            newEvent.addEventAssignment(ev);
            ++i;
        }
        return newEvent;
    }

    public static final EventAssignment convertToEventAssignment(PluginEventAssignment event) {
        EventAssignment newEvent = new EventAssignment();
        newEvent.setNotes(event.getNotes());
        if (event.getMath() != null) {
            newEvent.setMath(libsbml.parseFormula((String)libsbml.formulaToString((ASTNode)event.getMath())));
        }
        newEvent.setVariable(event.getVariable());
        ModelAnnotation.setAnnotationOfSBase(event, (SBase)newEvent, null);
        return newEvent;
    }

    public static final KineticLaw convertToKineticLaw(PluginKineticLaw law) {
        KineticLaw newLaw = new KineticLaw();
        newLaw.setFormula(law.getFormula());
        newLaw.setNotes(law.getNotes());
        newLaw.setSubstanceUnits(law.getSubstanceUnits());
        newLaw.setTimeUnits(law.getTimeUnits());
        newLaw.setAnnotation(LibSBMLUtil.addEnclosedAnnotationTags(law.getParentReactionID()));
        ModelAnnotation.setAnnotationOfSBase(law, (SBase)newLaw, null);
        int i = 0;
        while (i < law.getNumParameters()) {
            PluginParameter pparam = law.getParameter(i);
            Parameter param = PluginSBaseConverter.convertToParameter(pparam, law);
            newLaw.addParameter(param);
            ++i;
        }
        LibSBMLUtil.changetoAstTimeNode(newLaw.getMath());
        return newLaw;
    }

    public static final Parameter convertToParameter(PluginParameter param, PluginKineticLaw parent) {
        Parameter newParam = new Parameter();
        newParam.setId(param.getId());
        newParam.setName(param.getName());
        newParam.setNotes(param.getNotes());
        newParam.setUnits(param.getUnits());
        newParam.setValue(param.getValue());
        newParam.setConstant(param.getConstant());
        newParam.setAnnotation(LibSBMLUtil.addEnclosedAnnotationTags(parent.getParentReactionID()));
        ModelAnnotation.setAnnotationOfSBase(param, (SBase)newParam, parent);
        return newParam;
    }

    public static final Parameter convertToParameter(PluginParameter param) {
        Parameter newParam = new Parameter();
        newParam.setId(param.getId());
        newParam.setName(param.getName());
        newParam.setNotes(param.getNotes());
        newParam.setUnits(param.getUnits());
        newParam.setValue(param.getValue());
        newParam.setConstant(param.getConstant());
        if (param.getParentReaction() != null) {
            newParam.setAnnotation(LibSBMLUtil.addEnclosedAnnotationTags(param.getParentSBaseID()));
        }
        ModelAnnotation.setAnnotationOfSBase(param, (SBase)newParam, null);
        return newParam;
    }

    public static final SpeciesReference convertToSpeciesReference(PluginSimpleSpeciesReference ref) {
        SpeciesReference newRef = new SpeciesReference();
        PluginSpeciesReference pRef = (PluginSpeciesReference)ref;
        newRef.setNotes(pRef.getNotes());
        newRef.setSpecies(pRef.getSpecies());
        newRef.setStoichiometry(pRef.getStoichiometry());
        if (pRef.getStoichiometryMath() != null) {
            newRef.setStoichiometryMath(new StoichiometryMath(pRef.getStoichiometryMath()));
        }
        return newRef;
    }

    public static final ModifierSpeciesReference convertToModifierSpeciesReference(PluginSimpleSpeciesReference ref) {
        ModifierSpeciesReference newRef = new ModifierSpeciesReference();
        newRef.setNotes(ref.getNotes());
        newRef.setSpecies(ref.getSpecies());
        return newRef;
    }

    public static final FunctionDefinition convertToFunctionDefinition(PluginFunctionDefinition function) {
        FunctionDefinition newFunction = new FunctionDefinition();
        newFunction.setId(function.getId());
        if (function.getMath() != null) {
            newFunction.setMath(libsbml.parseFormula((String)libsbml.formulaToString((ASTNode)function.getMath())));
        } else {
            newFunction.setMath(libsbml.parseFormula((String)"lambda(test,test)"));
        }
        newFunction.setName(function.getName());
        newFunction.setNotes(function.getNotes());
        ModelAnnotation.setAnnotationOfSBase(function, (SBase)newFunction, null);
        return newFunction;
    }

    public static final Rule convertToRule(PluginRule rule) {
        if (rule instanceof PluginAlgebraicRule) {
            AlgebraicRule newRule2 = new AlgebraicRule();
            PluginAlgebraicRule arule = (PluginAlgebraicRule)rule;
            newRule2.setNotes(arule.getNotes());
            newRule2.setFormula(arule.getFormula());
            ModelAnnotation.setAnnotationOfSBase(rule, (SBase)newRule2, null);
            return newRule2;
        }
        if (rule instanceof PluginAssignmentRule) {
            AssignmentRule newRule2 = new AssignmentRule();
            PluginAssignmentRule arule = (PluginAssignmentRule)rule;
            newRule2.setNotes(arule.getNotes());
            newRule2.setFormula(arule.getFormula());
            newRule2.setL1TypeCode(arule.getL1TypeCode());
            newRule2.setVariable(arule.getVariable());
            ModelAnnotation.setAnnotationOfSBase(arule, (SBase)newRule2, null);
            return newRule2;
        }
        if (rule instanceof PluginRateRule) {
            RateRule newRule2 = new RateRule();
            PluginRateRule arule = (PluginRateRule)rule;
            newRule2.setNotes(arule.getNotes());
            newRule2.setFormula(arule.getFormula());
            newRule2.setVariable(arule.getVariable());
            ModelAnnotation.setAnnotationOfSBase(arule, (SBase)newRule2, null);
            return newRule2;
        }
        return null;
    }

    public static final UnitDefinition convertToUnitDefinition(PluginUnitDefinition unit) {
        UnitDefinition newUnit = new UnitDefinition();
        newUnit.setName(unit.getName());
        newUnit.setId(unit.getId());
        newUnit.setNotes(unit.getNotes());
        ModelAnnotation.setAnnotationOfSBase(unit, (SBase)newUnit, null);
        int i = 0;
        while (i < unit.getNumUnits()) {
            PluginUnit pun = unit.getUnit(i);
            Unit un = PluginSBaseConverter.convertToUnit(pun);
            newUnit.addUnit(un);
            ++i;
        }
        return newUnit;
    }

    public static final Unit convertToUnit(PluginUnit unit) {
        Unit newUnit = new Unit();
        newUnit.setExponent(unit.getExponent());
        newUnit.setKind(unit.getKind());
        newUnit.setMultiplier(unit.getMultiplier());
        newUnit.setNotes(unit.getNotes());
        newUnit.setOffset(unit.getOffset());
        newUnit.setScale(unit.getScale());
        ModelAnnotation.setAnnotationOfSBase(unit, (SBase)newUnit, null);
        return newUnit;
    }

    public static final SpeciesType convertToSpeciesType(PluginSpeciesType speciesType) {
        if (speciesType == null) {
            return null;
        }
        SpeciesType newSpeciesType = new SpeciesType();
        newSpeciesType.setId(speciesType.getId());
        newSpeciesType.setName(speciesType.getName());
        XMLNode xn = XMLNode.convertStringToXMLNode((String)speciesType.getNotesString());
        newSpeciesType.setNotes(speciesType.getNotesString());
        newSpeciesType.setNotes(LibSBMLUtil.convertNotesToCDNotes(xn));
        ModelAnnotation.setAnnotationOfSBase(speciesType, (SBase)newSpeciesType, null);
        return newSpeciesType;
    }

    public static final CompartmentType convertToCompartmentType(PluginCompartmentType compartmentType) {
        if (compartmentType == null) {
            return null;
        }
        CompartmentType newCompartmentType = new CompartmentType();
        newCompartmentType.setId(compartmentType.getId());
        newCompartmentType.setName(compartmentType.getName());
        XMLNode xn = XMLNode.convertStringToXMLNode((String)compartmentType.getNotesString());
        newCompartmentType.setNotes(compartmentType.getNotesString());
        newCompartmentType.setNotes(LibSBMLUtil.convertNotesToCDNotes(xn));
        ModelAnnotation.setAnnotationOfSBase(compartmentType, (SBase)newCompartmentType, null);
        return newCompartmentType;
    }

    public static final InitialAssignment convertToInitialAssignment(PluginInitialAssignment initialAssignment) {
        if (initialAssignment == null) {
            return null;
        }
        InitialAssignment newInitialAssignment = new InitialAssignment();
        newInitialAssignment.setSymbol(initialAssignment.getSymbol());
        newInitialAssignment.setMath(libsbml.parseFormula((String)initialAssignment.getMath()));
        XMLNode xn = XMLNode.convertStringToXMLNode((String)initialAssignment.getNotesString());
        newInitialAssignment.setNotes(initialAssignment.getNotesString());
        newInitialAssignment.setNotes(LibSBMLUtil.convertNotesToCDNotes(xn));
        ModelAnnotation.setAnnotationOfSBase(initialAssignment, (SBase)newInitialAssignment, null);
        return newInitialAssignment;
    }

    public static final Constraint convertToConstraint(PluginConstraint constraint) {
        if (constraint == null) {
            return null;
        }
        Constraint newConstraint = new Constraint();
        newConstraint.setMath(libsbml.parseFormula((String)constraint.getMath()));
        try {
            ConstraintDialog.resetMsgStringOfConstraint(newConstraint, constraint.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        XMLNode xn = XMLNode.convertStringToXMLNode((String)constraint.getNotesString());
        newConstraint.setNotes(constraint.getNotesString());
        newConstraint.setNotes(LibSBMLUtil.convertNotesToCDNotes(xn));
        ModelAnnotation.setAnnotationOfSBase(constraint, (SBase)newConstraint, null);
        return newConstraint;
    }

    public static final ArrayList convertToListOf(PluginListOf pListOf) {
        ArrayList<Rule> listOf = new ArrayList<Rule>();
        int i = 0;
        while (i < pListOf.size()) {
            PluginSBase pSBase = pListOf.get(i);
            Rule sbase = null;
            if (pSBase instanceof PluginRule) {
                sbase = PluginSBaseConverter.convertToRule((PluginRule)pSBase);
            } else if (pSBase instanceof PluginEventAssignment) {
                sbase = PluginSBaseConverter.convertToEventAssignment((PluginEventAssignment)pSBase);
            } else if (pSBase instanceof PluginUnit) {
                sbase = PluginSBaseConverter.convertToUnit((PluginUnit)pSBase);
            }
            if (sbase != null) {
                listOf.add(sbase);
            }
            ++i;
        }
        return listOf;
    }
}

