/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JFrame;
import jp.sbi.celldesigner.CellDToolBar;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.PaletteToolBarButton;

public class PaletteToolBar
extends CellDToolBar
implements ActionListener,
ItemSelectable {
    private static final Insets buttonInsets = MainWindow.toolBarButtonInsets;
    private Vector itemlisteners = null;
    protected PaletteToolBarButton[] toggleButtons = null;

    public PaletteToolBar(JFrame owner) {
        this.setRollover(true);
        owner.getContentPane().add((Component)this, "North");
    }

    public void setButtons(PaletteToolBarButton[] buttons) {
        if (buttons == null) {
            return;
        }
        this.toggleButtons = buttons;
        int i = 0;
        while (i < this.toggleButtons.length) {
            this.toggleButtons[i].addActionListener(this);
            this.toggleButtons[i].setMargin(buttonInsets);
            this.toggleButtons[i].setRolloverEnabled(true);
            this.add(this.toggleButtons[i]);
            if (this.toggleButtons[i].getCodename() != null && (this.toggleButtons[i].getCodename().equals("ADD_PRODUCT") || this.toggleButtons[i].getCodename().equals("TRIGGER"))) {
                this.addSeparator();
            }
            ++i;
        }
    }

    public void setEnabledAllButtons(boolean enableflag) {
        if (this.toggleButtons == null) {
            return;
        }
        int i = 0;
        while (i < this.toggleButtons.length) {
            this.toggleButtons[i].setEnabled(enableflag);
            ++i;
        }
    }

    public void releaseAll() {
        if (this.toggleButtons == null) {
            return;
        }
        int i = 0;
        while (i < this.toggleButtons.length) {
            this.toggleButtons[i].setSelected(false);
            ++i;
        }
    }

    public void setSelected(String codename) {
        if (this.toggleButtons == null) {
            return;
        }
        int i = 0;
        while (i < this.toggleButtons.length) {
            if (this.toggleButtons[i].getCodename().equals(codename)) {
                this.toggleButtons[i].setSelected(true);
                return;
            }
            ++i;
        }
        this.releaseAll();
    }

    @Override
    public void addItemListener(ItemListener listener) {
        if (this.itemlisteners == null) {
            this.itemlisteners = new Vector();
        } else if (this.itemlisteners.contains(listener)) {
            return;
        }
        this.itemlisteners.addElement(listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        if (this.itemlisteners == null) {
            return;
        }
        this.itemlisteners.removeElement(listener);
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.toggleButtons == null) {
            return null;
        }
        Vector<PaletteToolBarButton> v = new Vector<PaletteToolBarButton>();
        int i = 0;
        while (i < this.toggleButtons.length) {
            if (this.toggleButtons[i].isSelected()) {
                v.addElement(this.toggleButtons[i]);
            }
            ++i;
        }
        return v.toArray();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireItemSelected(e);
    }

    protected void fireItemSelected(ActionEvent e) {
        if (this.itemlisteners == null) {
            return;
        }
        ItemEvent ie = new ItemEvent(this, e.getID(), e.getSource(), 1);
        int i = 0;
        while (i < this.itemlisteners.size()) {
            ((ItemListener)this.itemlisteners.elementAt(i)).itemStateChanged(ie);
            ++i;
        }
    }
}

