/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jp.sbi.celldesigner.PainterChangeListener;

public class PainterChooser
extends JPanel
implements ActionListener {
    private static final String gradationString = "Gradation";
    private static final String colorString = "Color";
    private Vector listeners = null;
    private JRadioButton gradationButton;
    private JRadioButton colorButton;
    private ButtonGroup group;
    private String button1;
    private String button2;

    public PainterChooser() {
        super(new GridLayout(0, 1));
        this.gradationButton = new JRadioButton(gradationString);
        this.gradationButton.setMnemonic(71);
        this.gradationButton.setActionCommand(gradationString);
        this.gradationButton.setSelected(false);
        this.colorButton = new JRadioButton(colorString);
        this.colorButton.setMnemonic(67);
        this.colorButton.setActionCommand(colorString);
        this.gradationButton.setSelected(true);
        this.group = new ButtonGroup();
        this.group.add(this.gradationButton);
        this.group.add(this.colorButton);
        this.gradationButton.addActionListener(this);
        this.colorButton.addActionListener(this);
        this.add(this.gradationButton);
        this.add(this.colorButton);
    }

    public PainterChooser(String button1, String button2) {
        super(new GridLayout(0, 1));
        this.button1 = button1;
        this.button2 = button2;
        this.gradationButton = new JRadioButton(button1);
        this.gradationButton.setMnemonic(71);
        this.gradationButton.setActionCommand(button1);
        this.gradationButton.setSelected(false);
        this.colorButton = new JRadioButton(button2);
        this.colorButton.setMnemonic(67);
        this.colorButton.setActionCommand(button2);
        this.gradationButton.setSelected(true);
        this.group = new ButtonGroup();
        this.group.add(this.gradationButton);
        this.group.add(this.colorButton);
        this.gradationButton.addActionListener(this);
        this.colorButton.addActionListener(this);
        this.add(this.gradationButton);
        this.add(this.colorButton);
    }

    public void setSelected(String code) {
        if (code == null) {
            this.gradationButton.setSelected(true);
            return;
        }
        Enumeration<AbstractButton> e = this.group.getElements();
        while (e.hasMoreElements()) {
            JRadioButton b = (JRadioButton)e.nextElement();
            if (!code.equals(b.getActionCommand())) continue;
            b.setSelected(true);
            return;
        }
        this.gradationButton.setSelected(true);
    }

    public String getSelectedCode() {
        Object[] obj = ((ItemSelectable)((Object)this.group)).getSelectedObjects();
        if (obj == null || obj.length != 1) {
            return gradationString;
        }
        return ((JRadioButton)obj[0]).getActionCommand();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (this.listeners == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            ((PainterChangeListener)this.listeners.elementAt(i)).painterChanged(command);
            ++i;
        }
    }

    public void addPainterChangeListener(PainterChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public void removeAllListener() {
        this.listeners = null;
    }

    public void setGradationButtonEnable(boolean enable) {
        this.gradationButton.setEnabled(enable);
    }

    public void setColorButtonEnable(boolean enable) {
        this.colorButton.setEnabled(enable);
    }
}

