/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import jp.fric.graphics.draw.GStructure;
import jp.sbi.celldesigner.Preference;

public class PagePainter
implements Printable {
    private GStructure m_gStructure;
    private Dimension m_dim;

    public void setStructure(GStructure gStructure, Dimension dim) {
        this.m_gStructure = gStructure;
        this.m_dim = dim;
    }

    @Override
    public int print(Graphics gr, PageFormat fmt, int pageIndex) {
        if (pageIndex >= 1) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)gr;
        g2d.setClip(0, 0, this.m_dim.width, this.m_dim.height);
        if (Preference.antialias) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        double offx = 30.0;
        double offy = 30.0;
        double fmt_x1 = fmt.getImageableX();
        double fmt_y1 = fmt.getImageableY();
        g2d.translate(offx + fmt_x1, offy + fmt_y1);
        double fmt_w0 = fmt.getWidth();
        double fmt_h0 = fmt.getHeight();
        double fmt_w1 = fmt.getImageableWidth();
        double fmt_h1 = fmt.getImageableHeight();
        double scale_x = (fmt_w1 - 2.0 * offx) / (double)this.m_dim.width;
        double scale_y = (fmt_h1 - 2.0 * offy) / (double)this.m_dim.height;
        double scale = scale_x;
        if (scale_y < scale_x) {
            scale = scale_y;
        }
        AffineTransform aft01 = g2d.getTransform();
        AffineTransform aft02 = AffineTransform.getScaleInstance(scale, scale);
        aft01.concatenate(aft02);
        g2d.setTransform(aft01);
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, this.m_dim.width, this.m_dim.height);
        this.m_gStructure.draw(g2d);
        return 0;
    }
}

