/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.fric.graphics.draw.GColoredShape;
import jp.fric.graphics.draw.GContainer;
import jp.fric.graphics.draw.GContainerTarget;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GPointedContainer;
import jp.fric.graphics.draw.GPointedShape;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.PaintSchemeFactory;
import jp.fric.util.Debug;
import jp.sbi.celldesigner.ClosedCompartmentAlias;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.CompartmentAliasPopupMenu;
import jp.sbi.celldesigner.CompartmentShapePainting;
import jp.sbi.celldesigner.CompartmentSymbol;
import jp.sbi.celldesigner.InformationBox;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.NameImage;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.sbmlExtension.CompartmentAnnotation;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.celldesigner.symbol.color.CompartmentColorScheme;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareE;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareN;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareNE;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareNW;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareS;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareSE;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareSW;
import jp.sbi.celldesigner.symbol.compartment.CompartmentSquareW;
import jp.sbi.celldesigner.symbol.compartment.Membrane;
import jp.sbi.celldesigner.symbol.compartment.OpenedCompartment;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.Compartment;
import org.sbml.libsbml.Model;
import org.sbml.libsbml.SBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OpenedCompartmentAlias
extends GPointedContainer
implements CompartmentAlias {
    private NameImage nameImage = null;
    private double namedx = 0.0;
    private double namedy = 0.0;
    private int prevCompartmentIndex = -1;
    private Compartment originalCompartment = null;
    private Compartment historicalCompartment = null;
    private SBSymbol symbol = null;
    private double compartmentInitSize = 1.0;
    private boolean isNamePositionBuilded = false;
    private boolean bIsCompartmentHasInitSize = false;
    private InformationBox infoBox = new InformationBox(this);

    @Override
    public void setSymbol(SBSymbol symbol) throws Exception {
        if (symbol instanceof CompartmentSymbol) {
            this.symbol = symbol;
            super.setGPointedShape((GPointedShape)((Object)symbol));
        } else {
            throw new Exception("symbol must be CompartmentSymbol, code=" + symbol.getCode());
        }
    }

    @Override
    public SBSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public void setCompartmentName(String name) {
        if (this.nameImage == null) {
            this.nameImage = new NameImage(name, this);
            Point2D.Double defaultPosition = this.getDefaultCompartmentNamePostion();
            this.setNameImagePosition(defaultPosition.x, defaultPosition.y);
        } else {
            this.nameImage = new NameImage(name, this);
        }
    }

    @Override
    public String getCompartmentName() {
        if (this.nameImage == null) {
            return "";
        }
        return this.nameImage.getString();
    }

    @Override
    public void setPrevCompartmentIndex(int index) {
        this.prevCompartmentIndex = index;
    }

    @Override
    public int getPrevCompartmentIndex() {
        return this.prevCompartmentIndex;
    }

    @Override
    public void setOriginalCompartment(Compartment compartment) {
        this.originalCompartment = compartment;
    }

    @Override
    public Compartment getOriginalCompartment() {
        return this.originalCompartment;
    }

    @Override
    public void setHistoricalCompartment(Compartment compartment) {
        this.historicalCompartment = compartment;
    }

    @Override
    public Compartment getHistoricalCompartment() {
        return this.historicalCompartment;
    }

    @Override
    public void setGPointedShape(GPointedShape pointedShape) throws Exception {
        super.setGPointedShape(pointedShape);
        this.symbol = (SBSymbol)((Object)pointedShape);
    }

    @Override
    public GElement createCopy() {
        OpenedCompartmentAlias alias = (OpenedCompartmentAlias)super.createCopy();
        Compartment c = this.originalCompartment.cloneObject();
        alias.setOriginalCompartment(c);
        alias.setCompartmentName(this.getCompartmentName());
        alias.namedx = this.namedx;
        alias.namedy = this.namedy;
        if (this.getInfoBox() != null) {
            alias.setInfoBox((InformationBox)this.getInfoBox().createCopy());
        } else {
            alias.setInfoBox(null);
        }
        LibSBMLUtil.updateInfoParent(alias);
        return alias;
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        if (this.nameImage == null) {
            return super.getRepaintBounds();
        }
        if (this.infoBox == null) {
            return GUtil.union(super.getRepaintBounds(), this.nameImage.getRepaintBounds());
        }
        Rectangle2D.Double area = null;
        area = GUtil.union(super.getRepaintBounds(), this.nameImage.getRepaintBounds());
        area = GUtil.union(area, this.infoBox.getRepaintBounds());
        return area;
    }

    @Override
    public Rectangle2D update() {
        if (this.symbol == null) {
            return null;
        }
        Rectangle2D rtn = super.update();
        Rectangle2D.Double rtn2 = null;
        if (this.nameImage != null) {
            this.nameImage.setFramePosition(this.namedx, this.namedy);
            rtn2 = (Rectangle2D.Double)this.nameImage.update();
        }
        Rectangle2D.Double rtn3 = null;
        if (this.infoBox != null) {
            this.infoBox.resetCenterPointByAngle();
            rtn3 = this.infoBox.getRepaintBounds();
        }
        return GUtil.union(rtn, GUtil.union(rtn2, rtn3));
    }

    @Override
    public void draw(Graphics2D g2) {
        if (this.symbol == null) {
            return;
        }
        super.draw(g2);
        if (this.nameImage != null) {
            this.nameImage.setFramePosition(this.namedx, this.namedy);
            this.nameImage.draw(g2);
        }
        if (this.infoBox != null) {
            this.infoBox.draw(g2);
        }
    }

    @Override
    public void readDOMTree(Element element, Model model) {
        if (element == null) {
            Debug.println("[CompartmentAlias]readDOMTree(), element==null");
            return;
        }
        String id = element.getAttributeNS(null, "id");
        super.setName(id);
        String compartmentId = element.getAttributeNS(null, "compartment");
        Compartment sbase = model.getCompartment(compartmentId);
        if (sbase != null) {
            Compartment c = sbase;
            this.setOriginalCompartment(c);
            CompartmentAnnotation cExt = (CompartmentAnnotation)LibSBMLUtil.getAnnotation((SBase)c, null);
            if (cExt != null) {
                cExt.addReference(this);
                String name = cExt.getCompartmentName();
                if (name.equals("")) {
                    name = c.getName();
                    if (name.equals("")) {
                        name = c.getId();
                    }
                    cExt.setCompartmentName(name);
                }
                this.setCompartmentName(name);
                if (c.getName().equals("")) {
                    c.setName(name);
                }
            } else {
                Debug.println("[CompartmentAlias]readDOMTree(), CompartmentAnnotation==null, compartmentId=" + compartmentId);
            }
        } else {
            Debug.println("[CompartmentAlias]readDOMTree(), compartment==null, compartmentId=" + compartmentId);
            return;
        }
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        boolean pointExist = false;
        int i = 0;
        while (i < childsize) {
            block38: {
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                    Element elem = (Element)node;
                    String tag = elem.getLocalName();
                    if (tag.equals("class")) {
                        String type = elem.getFirstChild().getNodeValue();
                        SBSymbol symbol = SBFactory.createSymbol(SBFactory.filterSynonym(type));
                        if (symbol != null) {
                            try {
                                this.setSymbol(symbol);
                            }
                            catch (Exception e) {
                                Debug.println("[CompartmentAlias]readDOMTree()," + e.getMessage());
                            }
                            CompartmentShapePainting painting = new CompartmentShapePainting(CompartmentColorScheme.getMembrane(type), CompartmentColorScheme.getColor(type), CompartmentColorScheme.getScheme(type));
                            ((CompartmentSymbol)((Object)symbol)).setCompartmentShapePainting(painting);
                        } else {
                            Debug.println("[CompartmentAlias]readDOMTree(), createSymbol==null, compartmentId=" + compartmentId + ", type=" + type);
                        }
                    } else if (tag.equals("point")) {
                        String str_x = elem.getAttributeNS(null, "x");
                        String str_y = elem.getAttributeNS(null, "y");
                        try {
                            double x = Double.parseDouble(str_x);
                            double y = Double.parseDouble(str_y);
                            super.setPoint(x, y);
                        }
                        catch (Exception e) {
                            Debug.println("[CompartmentAlias]readDOMTree(), e=" + e.getMessage());
                        }
                        pointExist = true;
                    } else if (tag.equals("doubleLine")) {
                        if (this.getSymbol() == null) {
                            Debug.println("[CompartmentAlias]readDOMTree(), Symbol not set yet. compartmentId=" + compartmentId);
                        } else {
                            String str_thick = elem.getAttributeNS(null, "thickness");
                            String str_outer = elem.getAttributeNS(null, "outerWidth");
                            String str_inner = elem.getAttributeNS(null, "innerWidth");
                            Membrane m = new Membrane(Double.parseDouble(str_thick), Double.parseDouble(str_outer), Double.parseDouble(str_inner));
                            ((CompartmentSymbol)((Object)this.getSymbol())).setMembrane(m);
                        }
                    } else if (tag.equals("paint")) {
                        if (this.getSymbol() == null) {
                            Debug.println("[CompartmentAlias]readDOMTree(), Symbol not set yet. compartmentId=" + compartmentId);
                        } else {
                            String str_color = elem.getAttributeNS(null, "color");
                            String str_scheme = elem.getAttributeNS(null, "scheme");
                            long l = Long.parseLong(str_color, 16);
                            GColoredShape cshape = (GColoredShape)((Object)this.getSymbol());
                            cshape.setColor(new Color((int)l, true));
                            cshape.setPaintScheme(PaintSchemeFactory.createByCode(str_scheme));
                        }
                    } else if (tag.equals("info") && this.symbol != null) {
                        String state = elem.getAttributeNS(null, "state");
                        String label1 = elem.getAttributeNS(null, "prefix");
                        String label2 = elem.getAttributeNS(null, "label");
                        String angle = elem.getAttributeNS(null, "angle");
                        try {
                            if (InformationBox.isValidForInfo(state, label1, label2)) {
                                this.infoBox = new InformationBox(state, label1, label2, this);
                                try {
                                    this.infoBox.setAngle(Double.valueOf(angle));
                                }
                                catch (Exception ex) {
                                    this.infoBox.setAngle(-1.5707963267948966);
                                    if (this.symbol != null) {
                                        this.infoBox.setAngle(((CompartmentSymbol)((Object)this.symbol)).getDefaultAngle());
                                    }
                                }
                            } else if (this.infoBox != null) {
                                this.infoBox.resetStateString();
                            }
                        }
                        catch (Exception ex) {
                            if (this.infoBox == null) break block38;
                            this.infoBox.resetStateString();
                        }
                    }
                }
            }
            ++i;
        }
        if (!pointExist) {
            Debug.println("[CompartmentAlias]readDOMTree(), lack of \"point\" tag");
        }
    }

    public void readDOMTree(SBModel sbModel, Element element, Model model) {
        if (element == null) {
            Debug.println("[CompartmentAlias]readDOMTree(), element==null");
            return;
        }
        String id = element.getAttributeNS(null, "id");
        super.setName(id);
        String compartmentId = element.getAttributeNS(null, "compartment");
        Compartment sbase = model.getCompartment(compartmentId);
        if (sbase != null) {
            Compartment c = sbase;
            this.setOriginalCompartment(c);
            CompartmentAnnotation cExt = (CompartmentAnnotation)LibSBMLUtil.getAnnotation(sbModel, (SBase)c, null);
            if (cExt != null) {
                cExt.addReference(this);
                String name = cExt.getCompartmentName();
                if (name.equals("")) {
                    name = c.getName();
                    if (name.equals("")) {
                        name = c.getId();
                    }
                    cExt.setCompartmentName(name);
                }
                this.setCompartmentName(name);
                if (c.getName().equals("")) {
                    c.setName(name);
                }
            } else {
                Debug.println("[CompartmentAlias]readDOMTree(), CompartmentAnnotation==null, compartmentId=" + compartmentId);
            }
        } else {
            Debug.println("[CompartmentAlias]readDOMTree(), compartment==null, compartmentId=" + compartmentId);
            return;
        }
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        boolean namepositionGetted = false;
        double dnamex = 0.0;
        double dnamey = 0.0;
        boolean pointExist = false;
        int i = 0;
        while (i < childsize) {
            block44: {
                Node node = childlist.item(i);
                if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                    Element elem = (Element)node;
                    String tag = elem.getLocalName();
                    if (tag.equals("class")) {
                        String type = elem.getFirstChild().getNodeValue();
                        SBSymbol symbol = SBFactory.createSymbol(SBFactory.filterSynonym(type));
                        if (symbol != null) {
                            try {
                                this.setSymbol(symbol);
                            }
                            catch (Exception e) {
                                Debug.println("[CompartmentAlias]readDOMTree()," + e.getMessage());
                            }
                            CompartmentShapePainting painting = new CompartmentShapePainting(CompartmentColorScheme.getMembrane(type), CompartmentColorScheme.getColor(type), CompartmentColorScheme.getScheme(type));
                            ((CompartmentSymbol)((Object)symbol)).setCompartmentShapePainting(painting);
                        } else {
                            Debug.println("[CompartmentAlias]readDOMTree(), createSymbol==null, compartmentId=" + compartmentId + ", type=" + type);
                        }
                    } else if (tag.equals("point")) {
                        String str_x = elem.getAttributeNS(null, "x");
                        String str_y = elem.getAttributeNS(null, "y");
                        try {
                            double x = Double.parseDouble(str_x);
                            double y = Double.parseDouble(str_y);
                            super.setPoint(x, y);
                        }
                        catch (Exception e) {
                            Debug.println("[CompartmentAlias]readDOMTree(), e=" + e.getMessage());
                        }
                        pointExist = true;
                    } else if (tag.equals("doubleLine")) {
                        if (this.getSymbol() == null) {
                            Debug.println("[CompartmentAlias]readDOMTree(), Symbol not set yet. compartmentId=" + compartmentId);
                        } else {
                            String str_thick = elem.getAttributeNS(null, "thickness");
                            String str_outer = elem.getAttributeNS(null, "outerWidth");
                            String str_inner = elem.getAttributeNS(null, "innerWidth");
                            Membrane m = new Membrane(Double.parseDouble(str_thick), Double.parseDouble(str_outer), Double.parseDouble(str_inner));
                            ((CompartmentSymbol)((Object)this.getSymbol())).setMembrane(m);
                            if (namepositionGetted) {
                                this.namedx = dnamex;
                                this.namedy = dnamey;
                            } else {
                                this.setNameImagePosition(dnamex, dnamey);
                            }
                        }
                    } else if (tag.equals("paint")) {
                        if (this.getSymbol() == null) {
                            Debug.println("[CompartmentAlias]readDOMTree(), Symbol not set yet. compartmentId=" + compartmentId);
                        } else {
                            String str_color = elem.getAttributeNS(null, "color");
                            String str_scheme = elem.getAttributeNS(null, "scheme");
                            long l = Long.parseLong(str_color, 16);
                            GColoredShape cshape = (GColoredShape)((Object)this.getSymbol());
                            cshape.setColor(new Color((int)l, true));
                            cshape.setPaintScheme(PaintSchemeFactory.createByCode(str_scheme));
                        }
                    } else if (tag.equals("namePoint")) {
                        String namex = elem.getAttributeNS(null, "x");
                        String namey = elem.getAttributeNS(null, "y");
                        try {
                            dnamex = Double.parseDouble(namex);
                            dnamey = Double.parseDouble(namey);
                            namepositionGetted = true;
                            this.namePositionBuilded();
                        }
                        catch (Exception e) {
                            dnamex = 0.0;
                            dnamey = 0.0;
                        }
                    } else if (tag.equals("info") && this.symbol != null) {
                        String state = elem.getAttributeNS(null, "state");
                        String label1 = elem.getAttributeNS(null, "prefix");
                        String label2 = elem.getAttributeNS(null, "label");
                        String angle = elem.getAttributeNS(null, "angle");
                        try {
                            if (InformationBox.isValidForInfo(state, label1, label2)) {
                                this.infoBox = new InformationBox(state, label1, label2, this);
                                try {
                                    this.infoBox.setAngle(Double.valueOf(angle));
                                }
                                catch (Exception ex) {
                                    this.infoBox.setAngle(-1.5707963267948966);
                                    if (this.symbol != null) {
                                        this.infoBox.setAngle(((CompartmentSymbol)((Object)this.symbol)).getDefaultAngle());
                                    }
                                }
                            } else if (this.infoBox != null) {
                                this.infoBox.resetStateString();
                            }
                        }
                        catch (Exception ex) {
                            if (this.infoBox == null) break block44;
                            this.infoBox.resetStateString();
                        }
                    }
                }
            }
            ++i;
        }
        if (!pointExist) {
            Debug.println("[CompartmentAlias]readDOMTree(), lack of \"point\" tag");
        }
    }

    @Override
    public void buildOutside(GStructure structure) {
        GContainer outsideAlias = structure.getOutside(this);
        if (outsideAlias != null) {
            GStructure.setContainerTarget(outsideAlias, this);
        }
    }

    @Override
    public void writeDOMTree(Node node) {
        if (this.getOriginalCompartment() == null) {
            Debug.println("[CompartmentAlias]writeDOMTree(), originalCompartment=null, id=" + super.getName());
            return;
        }
        Point2D.Double point = super.getPoint();
        if (point == null) {
            Debug.println("[CompartmentAlias]writeDOMTree(), getPoint()=null, name=" + super.getName());
            return;
        }
        String ns = ModelAnnotation.getOutputNamespace();
        Document doc = node.getOwnerDocument();
        String myId = super.getName();
        String compartmentId = this.getOriginalCompartment().getId();
        String type = "";
        if (this.symbol != null) {
            type = this.symbol.getCode();
        }
        String tag = String.valueOf(ns) + ":compartmentAlias";
        String typeTag = String.valueOf(ns) + ":class";
        String childtag = String.valueOf(ns) + ":point";
        Element elem = doc.createElementNS("http://www.sbml.org/2001/ns/celldesigner", tag);
        node.appendChild(elem);
        elem.setAttributeNS(null, "id", myId);
        elem.setAttributeNS(null, "compartment", compartmentId);
        Element telem = doc.createElementNS("http://www.sbml.org/2001/ns/celldesigner", typeTag);
        elem.appendChild(telem);
        telem.appendChild(doc.createTextNode(type));
        Element belem = doc.createElementNS("http://www.sbml.org/2001/ns/celldesigner", childtag);
        elem.appendChild(belem);
        belem.setAttributeNS(null, "x", Double.toString(point.x));
        belem.setAttributeNS(null, "y", Double.toString(point.y));
        CompartmentSymbol symbol = (CompartmentSymbol)((Object)this.getSymbol());
        this.writePaintingDOMTree(elem, symbol.getComparmentShapePainting());
    }

    public static void updateAnnotation(StringBuffer buf, OpenedCompartmentAlias alias) {
        if (alias.getOriginalCompartment() == null) {
            Debug.println("[CompartmentAlias]writeDOMTree(), originalCompartment=null, id=" + alias.getName());
            return;
        }
        Point2D.Double point = alias.getPoint();
        if (point == null) {
            Debug.println("[CompartmentAlias]writeDOMTree(), getPoint()=null, name=" + alias.getName());
            return;
        }
        String ns = ModelAnnotation.getOutputNamespace();
        String myId = alias.getName();
        String compartmentId = alias.getOriginalCompartment().getId();
        String type = "";
        if (alias.getSymbol() != null) {
            type = alias.getSymbol().getCode();
        }
        buf.append("<celldesigner:compartmentAlias id=\"" + myId + "\" compartment=\"" + compartmentId + "\">\n");
        buf.append("<celldesigner:class>" + type + "</celldesigner:" + "class>\n");
        buf.append("<celldesigner:point x=\"" + point.x + "\" y=\"" + point.y + "\"/>\n");
        Point2D.Double namePoint = alias.getCompartmentNameImage().getFramePosition();
        if (namePoint != null) {
            buf.append("<celldesigner:namePoint x=\"" + namePoint.x + "\" y=\"" + namePoint.y + "\"/>\n");
        }
        CompartmentSymbol symbol = (CompartmentSymbol)((Object)alias.getSymbol());
        OpenedCompartmentAlias.writePaintingDOMTree(buf, symbol.getComparmentShapePainting());
        InformationBox ib = alias.getInfoBox();
        try {
            if (InformationBox.isValidForInfo(ib)) {
                String state = ib.getStateString();
                String label1 = ib.getLabel1String();
                String label2 = ib.getLabel2String();
                double angle = ib.getAngle();
                buf.append("<celldesigner:info state=\"" + state + "\" " + "prefix" + "=\"" + label1 + "\" " + "label" + "=\"" + StringTool.toEscape(label2) + "\" " + "angle" + "=\"" + Double.toString(angle) + "\" " + "/>\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        buf.append("</celldesigner:compartmentAlias>\n");
    }

    private static void writePaintingDOMTree(StringBuffer buf, CompartmentShapePainting painting) {
        Membrane m = painting.getMembrane();
        buf.append("<celldesigner:doubleLine thickness=\"" + m.getThickness() + "\" outerWidth=\"" + m.getOuterLineWidth() + "\" innerWidth=\"" + m.getInnerLineWidth() + "\"/>\n");
        buf.append("<celldesigner:paint color=\"" + Integer.toHexString(painting.getColor().getRGB()) + "\" scheme=\"" + painting.getPaintScheme().getCode() + "\"/>\n");
    }

    private void writePaintingDOMTree(Node node, CompartmentShapePainting painting) {
        String ns = ModelAnnotation.getOutputNamespace();
        Document doc = node.getOwnerDocument();
        String URI2 = node.getNamespaceURI();
        Element lelem = doc.createElementNS(URI2, String.valueOf(ns) + ":doubleLine");
        node.appendChild(lelem);
        Membrane m = painting.getMembrane();
        lelem.setAttributeNS(null, "thickness", Double.toString(m.getThickness()));
        lelem.setAttributeNS(null, "outerWidth", Double.toString(m.getOuterLineWidth()));
        lelem.setAttributeNS(null, "innerWidth", Double.toString(m.getInnerLineWidth()));
        Element pelem = doc.createElementNS(URI2, String.valueOf(ns) + ":paint");
        node.appendChild(pelem);
        pelem.setAttributeNS(null, "color", Integer.toHexString(painting.getColor().getRGB()));
        pelem.setAttributeNS(null, "scheme", painting.getPaintScheme().getCode());
    }

    @Override
    public boolean popupAvailable() {
        return true;
    }

    @Override
    public void showPopup(MouseEvent e, double x, double y, GStructure structure) {
        CompartmentAliasPopupMenu popup = CompartmentAliasPopupMenu.getInstance();
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public NameImage getCompartmentNameImage() {
        return this.nameImage;
    }

    @Override
    public void setNameImagePosition(double x, double y) {
        this.namedx = x;
        this.namedy = y;
    }

    public Point2D.Double setNameImagePosition(Point2D.Double pos) {
        this.setNameImagePosition(pos.x, pos.y);
        return pos;
    }

    @Override
    public Point2D.Double getDefaultCompartmentNamePostion() {
        Point2D.Double position = new Point2D.Double(0.0, 0.0);
        if (this.symbol == null) {
            return position;
        }
        if (this.nameImage == null) {
            return position;
        }
        Dimension nameImageSize = this.nameImage.getNameImageSize();
        if (nameImageSize.width == 0 || nameImageSize.height == 0) {
            return position;
        }
        Rectangle2D.Double myBounds = super.getBounds();
        if (myBounds == null) {
            return position;
        }
        double x = 0.0;
        double y = 0.0;
        int location = ((GPointedShape)((Object)this.symbol)).getHandleLocation();
        switch (location) {
            case 1: {
                x = myBounds.x + myBounds.width - (double)nameImageSize.width;
                y = myBounds.y + myBounds.height - (double)nameImageSize.height;
                break;
            }
            case 2: {
                x = myBounds.x;
                y = myBounds.y + myBounds.height - (double)nameImageSize.height;
                break;
            }
            case 3: {
                x = myBounds.x + myBounds.width - (double)nameImageSize.width;
                y = myBounds.y;
                break;
            }
            case 4: {
                x = myBounds.x;
                y = myBounds.y;
                break;
            }
            case 5: {
                x = myBounds.x + (myBounds.width - (double)nameImageSize.width) / 2.0;
                y = myBounds.y + myBounds.height - (double)nameImageSize.height;
                break;
            }
            case 7: {
                x = myBounds.x + myBounds.width - (double)nameImageSize.width;
                y = myBounds.y + (myBounds.height - (double)nameImageSize.height) / 2.0;
                break;
            }
            case 8: {
                x = myBounds.x + (myBounds.width - (double)nameImageSize.width) / 2.0;
                y = myBounds.y;
                break;
            }
            case 6: {
                x = myBounds.x;
                y = myBounds.y + (myBounds.height - (double)nameImageSize.height) / 2.0;
                break;
            }
            default: {
                return null;
            }
        }
        return new Point2D.Double(x, y);
    }

    public double getNameImageAvailableDrawAreaTop() {
        Rectangle2D.Double myBounds = super.getBounds();
        double dRtn = myBounds.y;
        int location = ((GPointedShape)((Object)this.symbol)).getHandleLocation();
        Point2D.Double pntHandlepoint = ((OpenedCompartment)this.symbol).getHandleppointPostion();
        switch (location) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                dRtn = pntHandlepoint.y + ((CompartmentSymbol)((Object)this.symbol)).getThickness() + ((CompartmentSymbol)((Object)this.symbol)).getMembrane().getInnerLineWidth() / 2.0;
            }
        }
        return dRtn;
    }

    public double getNameImageAvailableDrawAreaBottom() {
        Dimension nameImageSize = this.nameImage.getNameImageSize();
        double dRtn = 0.0;
        Rectangle2D.Double myMaxArea = this.getMaxArea();
        if (myMaxArea != null && myMaxArea.height > 0.0) {
            dRtn = myMaxArea.height - (double)nameImageSize.height;
        } else {
            try {
                dRtn = MainWindow.getLastInstance().getCurrentModel().getModelSize().getHeight() - (double)nameImageSize.height;
            }
            catch (Exception myErr) {
                return dRtn;
            }
        }
        int location = ((GPointedShape)((Object)this.symbol)).getHandleLocation();
        Point2D.Double pntHandlepoint = ((OpenedCompartment)this.symbol).getHandleppointPostion();
        switch (location) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                dRtn = pntHandlepoint.y - ((CompartmentSymbol)((Object)this.symbol)).getThickness() - ((CompartmentSymbol)((Object)this.symbol)).getMembrane().getInnerLineWidth() / 2.0 - (double)nameImageSize.height;
            }
        }
        return dRtn;
    }

    public double getNameImageAvailableDrawAreaLeft() {
        double dMin;
        double dRtn = dMin = 0.0;
        Dimension nameImageSize = this.nameImage.getNameImageSize();
        Dimension realNameImageSize = (Dimension)nameImageSize.clone();
        if (nameImageSize.width > NameImage.getVirtualMoveableNameImageFrameDimension().width) {
            nameImageSize.width = NameImage.getVirtualMoveableNameImageFrameDimension().width;
        }
        Dimension movableareaNameImageSize = (Dimension)nameImageSize.clone();
        int location = ((GPointedShape)((Object)this.symbol)).getHandleLocation();
        Point2D.Double pntHandlepoint = ((OpenedCompartment)this.symbol).getHandleppointPostion();
        switch (location) {
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                dRtn = pntHandlepoint.x + ((CompartmentSymbol)((Object)this.symbol)).getThickness() + ((CompartmentSymbol)((Object)this.symbol)).getMembrane().getInnerLineWidth() / 2.0 + (double)movableareaNameImageSize.width / 2.0 - (double)realNameImageSize.width / 2.0;
                if (!(dRtn < dMin)) break;
                dRtn = dMin;
            }
        }
        return dRtn;
    }

    public double getNameImageAvailableDrawAreaRight() {
        Dimension nameImageSize = this.nameImage.getNameImageSize();
        Dimension realNameImageSize = (Dimension)nameImageSize.clone();
        if (nameImageSize.width > NameImage.getVirtualMoveableNameImageFrameDimension().width) {
            nameImageSize.width = NameImage.getVirtualMoveableNameImageFrameDimension().width;
        }
        Dimension movableareaNameImageSize = (Dimension)nameImageSize.clone();
        double dMax = 0.0;
        Rectangle2D.Double myMaxArea = this.getMaxArea();
        if (myMaxArea != null && myMaxArea.width > 0.0) {
            dMax = myMaxArea.width - (double)realNameImageSize.width;
        } else {
            try {
                dMax = MainWindow.getLastInstance().getCurrentModel().getModelSize().getWidth() - (double)realNameImageSize.width;
            }
            catch (Exception myErr) {
                return dMax;
            }
        }
        double dRtn = dMax;
        int location = ((GPointedShape)((Object)this.symbol)).getHandleLocation();
        Point2D.Double pntHandlepoint = ((OpenedCompartment)this.symbol).getHandleppointPostion();
        switch (location) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                dRtn = pntHandlepoint.x - ((CompartmentSymbol)((Object)this.symbol)).getThickness() - ((CompartmentSymbol)((Object)this.symbol)).getMembrane().getInnerLineWidth() / 2.0 - (double)movableareaNameImageSize.width / 2.0 - (double)realNameImageSize.width / 2.0;
                if (!(dRtn > dMax)) break;
                dRtn = dMax;
            }
        }
        return dRtn;
    }

    public String enoughtoPlaceNameString(double dTop, double dBottom, double dLeft, double dRight) {
        String strW = "1";
        String strH = "1";
        if (dLeft > dRight) {
            strW = "0";
        }
        if (dBottom < dTop) {
            strH = "0";
        }
        return String.valueOf(strW) + strH;
    }

    private Point2D.Double getNewMaxXY(Point2D.Double pos) {
        if (pos == null) {
            return pos;
        }
        double d = ((CompartmentSymbol)((Object)this.symbol)).getThickness() + ((CompartmentSymbol)((Object)this.symbol)).getMembrane().getInnerLineWidth() / 2.0;
        double r = 40.0 - d;
        Dimension nameImageSize = this.nameImage.getNameImageSize();
        boolean bRecalWithMovableArea = false;
        Dimension realNameImageSize = (Dimension)nameImageSize.clone();
        if (nameImageSize.width > NameImage.getVirtualMoveableNameImageFrameDimension().width) {
            nameImageSize.width = NameImage.getVirtualMoveableNameImageFrameDimension().width;
            bRecalWithMovableArea = true;
        }
        Dimension movableareaNameImageSize = (Dimension)nameImageSize.clone();
        int location = ((GPointedShape)((Object)this.symbol)).getHandleLocation();
        Point2D.Double pntHandlepoint = ((OpenedCompartment)this.symbol).getHandleppointPostion();
        double dX40 = 0.0;
        double dY40 = 0.0;
        Point2D.Double posInputBak = (Point2D.Double)pos.clone();
        if (bRecalWithMovableArea) {
            pos = new Point2D.Double(pos.x + (double)realNameImageSize.width / 2.0 - (double)movableareaNameImageSize.width / 2.0, pos.y);
        }
        switch (location) {
            case 1: {
                double dLen;
                dX40 = pntHandlepoint.x + 40.0;
                dY40 = pntHandlepoint.y + 40.0;
                if (!(d < 40.0) || !(pos.x < dX40) || !(pos.y < dY40) || !((dLen = (pos.x - dX40) * (pos.x - dX40) + (pos.y - dY40) * (pos.y - dY40)) > r * r)) break;
                double k = r / Math.sqrt(dLen);
                double dXr = (pos.x - dX40) * k;
                double dYr = (pos.y - dY40) * k;
                return this.setNameImagePositionWithOffset(new Point2D.Double(dXr + dX40, dYr + dY40), realNameImageSize, movableareaNameImageSize);
            }
            case 2: {
                double dLen;
                dX40 = pntHandlepoint.x - 40.0;
                dY40 = pntHandlepoint.y + 40.0;
                if (!(d < 40.0) || !(pos.x + (double)nameImageSize.width > dX40) || !(pos.y < dY40) || !((dLen = (pos.x + (double)nameImageSize.width - dX40) * (pos.x + (double)nameImageSize.width - dX40) + (pos.y - dY40) * (pos.y - dY40)) > r * r)) break;
                double k = r / Math.sqrt(dLen);
                double dXr = (pos.x + (double)nameImageSize.width - dX40) * k;
                double dYr = (pos.y - dY40) * k;
                return this.setNameImagePositionWithOffset(new Point2D.Double(dXr - (double)nameImageSize.width + dX40, dYr + dY40), realNameImageSize, movableareaNameImageSize);
            }
            case 3: {
                double dLen;
                dX40 = pntHandlepoint.x + 40.0;
                dY40 = pntHandlepoint.y - 40.0;
                if (!(d < 40.0) || !(pos.x < dX40) || !(pos.y + (double)nameImageSize.height > dY40) || !((dLen = (pos.x - dX40) * (pos.x - dX40) + (pos.y + (double)nameImageSize.height - dY40) * (pos.y + (double)nameImageSize.height - dY40)) > r * r)) break;
                double k = r / Math.sqrt(dLen);
                double dXr = (pos.x - dX40) * k;
                double dYr = (pos.y + (double)nameImageSize.height - dY40) * k;
                return this.setNameImagePositionWithOffset(new Point2D.Double(dXr + dX40, dYr - (double)nameImageSize.height + dY40), realNameImageSize, movableareaNameImageSize);
            }
            case 4: {
                double dLen;
                dX40 = pntHandlepoint.x - 40.0;
                dY40 = pntHandlepoint.y - 40.0;
                if (!(d < 40.0) || !(pos.x + (double)nameImageSize.width > dX40) || !(pos.y + (double)nameImageSize.height > dY40) || !((dLen = (pos.x + (double)nameImageSize.width - dX40) * (pos.x + (double)nameImageSize.width - dX40) + (pos.y + (double)nameImageSize.height - dY40) * (pos.y + (double)nameImageSize.height - dY40)) > r * r)) break;
                double k = r / Math.sqrt(dLen);
                double dXr = (pos.x + (double)nameImageSize.width - dX40) * k;
                double dYr = (pos.y + (double)nameImageSize.height - dY40) * k;
                return this.setNameImagePositionWithOffset(new Point2D.Double(dXr - (double)nameImageSize.width + dX40, dYr - (double)nameImageSize.height + dY40), realNameImageSize, movableareaNameImageSize);
            }
        }
        return null;
    }

    @Override
    public Point2D.Double recalCompartmentNameDisplayPostion(Point2D.Double pos) {
        double newX = pos.x;
        double newY = pos.y;
        if (super.getBounds() == null) {
            return this.setNameImagePosition(new Point2D.Double(newX, newY));
        }
        if (MainWindow.getLastInstance() == null || MainWindow.getLastInstance().getCurrentModel() == null || MainWindow.getLastInstance().getCurrentModel().getModelSize() == null) {
            return this.setNameImagePosition(new Point2D.Double(newX, newY));
        }
        double dLeft = this.getNameImageAvailableDrawAreaLeft();
        double dRight = this.getNameImageAvailableDrawAreaRight();
        double dTop = this.getNameImageAvailableDrawAreaTop();
        double dBottom = this.getNameImageAvailableDrawAreaBottom();
        Point2D.Double newNewMaxXY = this.getNewMaxXY(pos);
        if (newNewMaxXY != null) {
            int location = ((GPointedShape)((Object)this.symbol)).getHandleLocation();
            switch (location) {
                case 1: {
                    if (dRight > dLeft) {
                        dLeft = newNewMaxXY.x;
                    }
                    if (!(dTop > dBottom)) break;
                    dTop = newNewMaxXY.y;
                    break;
                }
                case 2: {
                    if (dRight > dLeft) {
                        dRight = newNewMaxXY.x;
                    }
                    if (!(dTop > dBottom)) break;
                    dTop = newNewMaxXY.y;
                    break;
                }
                case 3: {
                    if (dRight > dLeft) {
                        dLeft = newNewMaxXY.x;
                    }
                    if (!(dTop > dBottom)) break;
                    dBottom = newNewMaxXY.y;
                    break;
                }
                case 4: {
                    if (dRight > dLeft) {
                        dRight = newNewMaxXY.x;
                    }
                    if (!(dTop > dBottom)) break;
                    dBottom = newNewMaxXY.y;
                }
            }
        }
        if (this.enoughtoPlaceNameString(dTop, dBottom, dLeft, dRight).equals("00")) {
            newX = this.getDefaultCompartmentNamePostion().x;
            newY = this.getDefaultCompartmentNamePostion().y;
        } else if (this.enoughtoPlaceNameString(dTop, dBottom, dLeft, dRight).equals("01")) {
            newX = this.getDefaultCompartmentNamePostion().x;
            if (pos.y < dTop) {
                newY = dTop;
            }
            if (pos.y > dBottom) {
                newY = dBottom;
            }
        } else if (this.enoughtoPlaceNameString(dTop, dBottom, dLeft, dRight).equals("10")) {
            if (pos.x < dLeft) {
                newX = dLeft;
            }
            if (pos.x > dRight) {
                newX = dRight;
            }
            newY = this.getDefaultCompartmentNamePostion().y;
        } else {
            if (pos.x < dLeft) {
                newX = dLeft;
            }
            if (pos.x > dRight) {
                newX = dRight;
            }
            if (pos.y < dTop) {
                newY = dTop;
            }
            if (pos.y > dBottom) {
                newY = dBottom;
            }
        }
        return this.setNameImagePosition(new Point2D.Double(newX, newY));
    }

    @Override
    public Rectangle2D.Double getInnerBound() {
        CompartmentSymbol csymbol = (CompartmentSymbol)((Object)this.symbol);
        double thickness = csymbol.getThickness();
        Rectangle2D.Double bounds = (Rectangle2D.Double)this.getBounds().clone();
        thickness += csymbol.getMembrane().getInnerLineWidth() + csymbol.getMembrane().getOuterLineWidth();
        int location = ((GPointedShape)((Object)this.symbol)).getHandleLocation();
        double x = bounds.x;
        double y = bounds.y;
        double width = bounds.width;
        double height = bounds.height;
        switch (location) {
            case 1: {
                x = bounds.x + thickness;
                y = bounds.y + thickness;
                width = bounds.width - thickness;
                height = bounds.height - thickness;
                break;
            }
            case 2: {
                y = bounds.y + thickness;
                height = bounds.height - thickness;
                width = bounds.width - thickness;
                break;
            }
            case 3: {
                x = bounds.x + thickness;
                width = bounds.width - thickness;
                height = bounds.height - thickness;
                break;
            }
            case 4: {
                width = bounds.width - thickness;
                height = bounds.height - thickness;
                break;
            }
            case 5: {
                y = bounds.y + thickness;
                height = bounds.height - thickness;
                break;
            }
            case 7: {
                x = bounds.x + thickness;
                width = bounds.width - thickness;
                break;
            }
            case 8: {
                height = bounds.height - thickness;
                break;
            }
            case 6: {
                width = bounds.width - thickness;
            }
        }
        return new Rectangle2D.Double(x, y, width, height);
    }

    public Rectangle2D.Double[] getCornerExceptWhichIsCircle() {
        Rectangle2D.Double innerBound = this.getInnerBound();
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double width1 = 0.0;
        double width2 = 0.0;
        double height1 = 0.0;
        double height2 = 0.0;
        double exceptR = 10.0;
        int location = ((GPointedShape)((Object)this.symbol)).getHandleLocation();
        switch (location) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return null;
            }
            case 1: {
                x1 = innerBound.x + exceptR;
                y1 = innerBound.y;
                width1 = innerBound.width - exceptR;
                height1 = innerBound.height;
                x2 = innerBound.x;
                y2 = innerBound.y + exceptR;
                width2 = innerBound.width;
                height2 = innerBound.height - exceptR;
                break;
            }
            case 2: {
                x1 = innerBound.x;
                y1 = innerBound.y;
                width1 = innerBound.width - exceptR;
                height1 = innerBound.height;
                x2 = innerBound.x;
                y2 = innerBound.y + exceptR;
                width2 = innerBound.width;
                height2 = innerBound.height - exceptR;
                break;
            }
            case 3: {
                x1 = innerBound.x;
                y1 = innerBound.y;
                width1 = innerBound.width;
                height1 = innerBound.height - exceptR;
                x2 = innerBound.x + exceptR;
                y2 = innerBound.y;
                width2 = innerBound.width - exceptR;
                height2 = innerBound.height;
                break;
            }
            case 4: {
                x1 = innerBound.x;
                y1 = innerBound.y;
                width1 = innerBound.width - exceptR;
                height1 = innerBound.height;
                x2 = innerBound.x;
                y2 = innerBound.y;
                width2 = innerBound.width;
                height2 = innerBound.height - exceptR;
                break;
            }
            default: {
                return null;
            }
        }
        Rectangle2D.Double[] corners = new Rectangle2D.Double[]{new Rectangle2D.Double(x1, y1, width1, height1), new Rectangle2D.Double(x2, y2, width2, height2)};
        return corners;
    }

    public void backupNameImagePosition() {
        if (this.nameImage != null) {
            this.nameImage.backupPosition();
        }
        Vector targets = this.getTargets();
        int size = targets.size();
        int i = 0;
        while (i < size) {
            if (targets.elementAt(i) instanceof OpenedCompartmentAlias) {
                ((OpenedCompartmentAlias)targets.elementAt(i)).backupNameImagePosition();
            }
            ++i;
        }
    }

    public void resetNameImagePosition() {
        if (this.nameImage != null) {
            this.nameImage.resetPosition();
        }
        Vector targets = this.getTargets();
        int size = targets.size();
        int i = 0;
        while (i < size) {
            if (targets.elementAt(i) instanceof OpenedCompartmentAlias) {
                ((OpenedCompartmentAlias)targets.elementAt(i)).resetNameImagePosition();
            }
            ++i;
        }
    }

    public void restoreNameImagePosition() {
        if (this.nameImage != null) {
            this.nameImage.restorePosition();
            if (this.nameImage.getUndoRedoFlg()) {
                this.nameImage.setUndoRedoFlg(false);
            }
        }
        Vector targets = this.getTargets();
        int size = targets.size();
        int i = 0;
        while (i < size) {
            if (targets.elementAt(i) instanceof OpenedCompartmentAlias) {
                ((OpenedCompartmentAlias)targets.elementAt(i)).restoreNameImagePosition();
            }
            ++i;
        }
    }

    public Vector getAllChildrenOpenedCompartment() {
        Vector<OpenedCompartmentAlias> vector = new Vector<OpenedCompartmentAlias>();
        vector.add(this);
        Vector targets = this.getTargets();
        int size = targets.size();
        int i = 0;
        while (i < size) {
            if (targets.elementAt(i) instanceof OpenedCompartmentAlias) {
                vector.addAll(((OpenedCompartmentAlias)targets.elementAt(i)).getAllChildrenOpenedCompartment());
            }
            ++i;
        }
        return vector;
    }

    public boolean isNamePositionBuilded() {
        return this.isNamePositionBuilded;
    }

    private void namePositionBuilded() {
        this.isNamePositionBuilded = true;
    }

    private void setNamePositionBuildedFlg(boolean flg) {
        this.isNamePositionBuilded = flg;
    }

    @Override
    public void backupNameImagePositionBeforeChangeCompartment() {
        if (this.nameImage != null) {
            this.nameImage.backupPositionBeforeChangeCompartment();
        }
        Vector targets = this.getTargets();
        int size = targets.size();
        int i = 0;
        while (i < size) {
            if (targets.elementAt(i) instanceof CompartmentAlias) {
                ((CompartmentAlias)targets.elementAt(i)).backupNameImagePositionBeforeChangeCompartment();
            }
            ++i;
        }
    }

    @Override
    public Rectangle2D restoreNameImagePositionAfterChangeCompartmentCancled() {
        Rectangle2D.Double redrawArea = null;
        Rectangle2D rec = null;
        if (this.nameImage != null) {
            rec = this.nameImage.restorePositionAfterChangeCompartmentCancled();
            redrawArea = GUtil.union(redrawArea, rec);
        }
        Vector targets = this.getTargets();
        int size = targets.size();
        int i = 0;
        while (i < size) {
            if (targets.elementAt(i) instanceof CompartmentAlias) {
                rec = ((CompartmentAlias)targets.elementAt(i)).restoreNameImagePositionAfterChangeCompartmentCancled();
                redrawArea = GUtil.union(redrawArea, rec);
            }
            ++i;
        }
        return redrawArea;
    }

    @Override
    public Rectangle2D.Double getCompartmentMaxRepaintBounds() {
        Rectangle2D.Double rectUnBounds = null;
        Rectangle2D.Double rectCmpFrm = this.getBounds();
        Rectangle2D.Double rectNmImgBounds = null;
        try {
            rectNmImgBounds = this.getCompartmentNameImage().getBounds();
            rectUnBounds = GUtil.union(rectCmpFrm, rectNmImgBounds);
            Vector targets = this.getTargets();
            int i = 0;
            while (targets != null && i < targets.size()) {
                GContainerTarget target = (GContainerTarget)targets.get(i);
                if (target instanceof ClosedCompartmentAlias) {
                    rectUnBounds = GUtil.union(rectUnBounds, ((ClosedCompartmentAlias)target).getCompartmentMaxRepaintBounds());
                }
                ++i;
            }
            if (this.infoBox != null) {
                rectUnBounds = GUtil.union(rectUnBounds, this.infoBox.getRepaintBounds());
            }
        }
        catch (Exception myErr) {
            rectUnBounds = rectCmpFrm;
        }
        return rectUnBounds;
    }

    public Rectangle2D.Double getCompartmentMaxRepaintBoundsWithoutOpenedCompartmentAliasBounds() {
        Rectangle2D.Double rectUnBounds = null;
        try {
            Vector targets = this.getTargets();
            int i = 0;
            while (targets != null && i < targets.size()) {
                GContainerTarget target = (GContainerTarget)targets.get(i);
                if (target instanceof ClosedCompartmentAlias) {
                    rectUnBounds = GUtil.union(rectUnBounds, ((ClosedCompartmentAlias)target).getCompartmentMaxRepaintBounds());
                } else if (target instanceof OpenedCompartmentAlias) {
                    rectUnBounds = GUtil.union(rectUnBounds, ((OpenedCompartmentAlias)target).getCompartmentMaxRepaintBoundsWithoutOpenedCompartmentAliasBounds());
                }
                ++i;
            }
        }
        catch (Exception myErr) {
            rectUnBounds = null;
        }
        return rectUnBounds;
    }

    public Point2D.Double setNameImagePositionWithOffset(Point2D.Double pos, Dimension realNameImageSize, Dimension movableareaNameImageSize) {
        if (pos == null) {
            return null;
        }
        if (realNameImageSize == null) {
            return null;
        }
        if (movableareaNameImageSize == null) {
            return null;
        }
        double dNewX = pos.x + (double)movableareaNameImageSize.width / 2.0 - (double)realNameImageSize.width / 2.0;
        double dNewY = pos.y + (double)movableareaNameImageSize.height / 2.0 - (double)realNameImageSize.height / 2.0;
        Point2D.Double newPnt = this.makeNameImageLeftTopPointInDrawAreaDimension(new Point2D.Double(dNewX, dNewY));
        return newPnt;
    }

    private Point2D.Double makeNameImageLeftTopPointInDrawAreaDimension(Point2D.Double inputPnt) {
        Point2D.Double rtn = null;
        Dimension dimsion = null;
        try {
            dimsion = new Dimension((int)this.getMaxArea().width, (int)this.getMaxArea().height);
            rtn = GStructure.makeGElementLeftTopPointInDrawAreaDimension(dimsion, this.nameImage, inputPnt, dimsion);
        }
        catch (Exception myErr) {
            return inputPnt;
        }
        return rtn;
    }

    @Override
    public void setCompartmentInitSize(double size) {
        this.compartmentInitSize = size;
    }

    @Override
    public double getCompartmentInitSize() {
        return this.compartmentInitSize;
    }

    @Override
    public void setCompartmentHasInitSizeFlg(boolean flg) {
        this.bIsCompartmentHasInitSize = flg;
    }

    @Override
    public boolean IsCompartmentHasInitSize() {
        return this.bIsCompartmentHasInitSize;
    }

    @Override
    public InformationBox getInfoBox() {
        return this.infoBox;
    }

    @Override
    public void setInfoBox(InformationBox infoBox) {
        this.infoBox = infoBox;
    }

    @Override
    public Point2D.Double getInfoBoxCenterPointByAngle(double agl) {
        double inputangle = LibSBMLUtil.changetoStandandAngle(agl);
        Area areaSearching = new Area(((CompartmentSymbol)((Object)this.symbol)).getOutterShape());
        Rectangle2D.Double myBounds = super.getBounds();
        double dWidthOfInputArea = areaSearching.getBounds2D().getWidth();
        double dHeightOfInputArea = areaSearching.getBounds2D().getHeight();
        double dRofInputArea = Math.sqrt(dWidthOfInputArea * dWidthOfInputArea + dHeightOfInputArea * dHeightOfInputArea);
        double dNewX = Math.cos(inputangle) * dRofInputArea + myBounds.getCenterX();
        double dNewY = Math.sin(inputangle) * dRofInputArea + myBounds.getCenterY();
        Point2D.Double pnt01 = new Point2D.Double(dNewX, dNewY);
        Rectangle2D.Double rectangle2D = InformationBox.getOutterRectangle2DSize(this, null);
        Point2D.Double pntInClosedEdgeOfAreaBy1Pnts = LibSBMLUtil.calPntInEdgeOfAreaBy1Pnts(areaSearching, null, pnt01, 0.5, 1);
        return this.getValidAngleByAnFreeAngle((OpenedCompartment)this.symbol, rectangle2D, pntInClosedEdgeOfAreaBy1Pnts);
    }

    @Override
    public Point2D.Double recalInfoBoxDisplayPostion(Point2D.Double pos) {
        try {
            Area areaSearching = new Area(((CompartmentSymbol)((Object)this.symbol)).getOutterShape());
            Rectangle2D.Double rectangle2D = InformationBox.getOutterRectangle2DSize(this, null);
            Point2D.Double pntInClosedEdgeOfAreaBy1Pnts = LibSBMLUtil.calPntInEdgeOfAreaBy1Pnts(areaSearching, null, new Point2D.Double(pos.x, pos.y), 0.5, 1);
            return this.getValidAngleByAnFreeAngle((OpenedCompartment)this.symbol, rectangle2D, pntInClosedEdgeOfAreaBy1Pnts);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Point2D.Double getValidAngleByAnFreeAngle(OpenedCompartment cptmtSymbol, Rectangle2D.Double freeshp, Point2D.Double pntInClosedEdgeOfAreaBy1Pnts) {
        double dAnglePntInClosedEdge = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntInClosedEdgeOfAreaBy1Pnts, 0.0);
        Point2D.Double handlePoint = cptmtSymbol.getHandleppointPostion();
        double dEllW = freeshp.getBounds2D().getWidth();
        double dEllH = freeshp.getBounds2D().getHeight();
        if (cptmtSymbol instanceof CompartmentSquareNE) {
            Point2D.Double pntXTop = new Point2D.Double(dEllW / 2.0, handlePoint.getY());
            Point2D.Double pntYTop = new Point2D.Double(handlePoint.getX(), this.getMaxArea().height - dEllH / 2.0);
            double dAngleXTop = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntXTop, 0.0);
            double dAngleYTop = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntYTop, 0.0);
            if (!(dAnglePntInClosedEdge >= dAngleYTop) || !(dAnglePntInClosedEdge <= dAngleXTop)) {
                return pntInClosedEdgeOfAreaBy1Pnts;
            }
            return OpenedCompartmentAlias.getNearestPointOfAngleBetween2Pnts(pntXTop, dAngleXTop, dAnglePntInClosedEdge, pntYTop, dAngleYTop);
        }
        if (cptmtSymbol instanceof CompartmentSquareNW) {
            Point2D.Double pntXTop = new Point2D.Double(this.getMaxArea().width - dEllW / 2.0, handlePoint.getY());
            Point2D.Double pntYTop = new Point2D.Double(handlePoint.getX(), this.getMaxArea().height - dEllH / 2.0);
            double dAngleXTop = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntXTop, 0.0);
            double dAngleYTop = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntYTop, 0.0);
            if (dAnglePntInClosedEdge >= dAngleYTop && dAnglePntInClosedEdge <= dAngleXTop) {
                return pntInClosedEdgeOfAreaBy1Pnts;
            }
            return OpenedCompartmentAlias.getNearestPointOfAngleBetween2Pnts(pntXTop, dAngleXTop, dAnglePntInClosedEdge, pntYTop, dAngleYTop);
        }
        if (cptmtSymbol instanceof CompartmentSquareSE) {
            Point2D.Double pntXTop = new Point2D.Double(dEllW / 2.0, handlePoint.getY());
            Point2D.Double pntYTop = new Point2D.Double(handlePoint.getX(), dEllH / 2.0);
            double dAngleXTop = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntXTop, 0.0);
            double dAngleYTop = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntYTop, 0.0);
            if (dAnglePntInClosedEdge <= dAngleXTop || dAnglePntInClosedEdge >= dAngleYTop) {
                return pntInClosedEdgeOfAreaBy1Pnts;
            }
            return OpenedCompartmentAlias.getNearestPointOfAngleBetween2Pnts(pntXTop, dAngleXTop, dAnglePntInClosedEdge, pntYTop, dAngleYTop);
        }
        if (cptmtSymbol instanceof CompartmentSquareSW) {
            Point2D.Double pntXTop = new Point2D.Double(this.getMaxArea().width - dEllW / 2.0, handlePoint.getY());
            Point2D.Double pntYTop = new Point2D.Double(handlePoint.getX(), dEllH / 2.0);
            double dAngleXTop = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntXTop, 0.0);
            double dAngleYTop = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntYTop, 0.0);
            if (dAnglePntInClosedEdge >= dAngleXTop && dAnglePntInClosedEdge <= dAngleYTop) {
                return pntInClosedEdgeOfAreaBy1Pnts;
            }
            return OpenedCompartmentAlias.getNearestPointOfAngleBetween2Pnts(pntXTop, dAngleXTop, dAnglePntInClosedEdge, pntYTop, dAngleYTop);
        }
        if (cptmtSymbol instanceof CompartmentSquareE) {
            Point2D.Double pntYTop = new Point2D.Double(handlePoint.getX(), dEllH / 2.0);
            Point2D.Double pntYBottom = new Point2D.Double(handlePoint.getX(), this.getMaxArea().height - dEllH / 2.0);
            double dAngleYTop = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntYTop, 0.0);
            double dAngleYBottom = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntYBottom, 0.0);
            if (dAnglePntInClosedEdge >= dAngleYTop && dAnglePntInClosedEdge <= Math.PI * 2 || dAnglePntInClosedEdge <= dAngleYBottom && dAnglePntInClosedEdge >= 0.0) {
                return pntInClosedEdgeOfAreaBy1Pnts;
            }
            return OpenedCompartmentAlias.getNearestPointOfAngleBetween2Pnts(pntYTop, dAngleYTop, dAnglePntInClosedEdge, pntYBottom, dAngleYBottom);
        }
        if (cptmtSymbol instanceof CompartmentSquareW) {
            Point2D.Double pntYTop = new Point2D.Double(handlePoint.getX(), dEllH / 2.0);
            Point2D.Double pntYBottom = new Point2D.Double(handlePoint.getX(), this.getMaxArea().height - dEllH / 2.0);
            double dAngleYTop = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntYTop, 0.0);
            double dAngleYBottom = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntYBottom, 0.0);
            if (dAnglePntInClosedEdge <= dAngleYTop && dAnglePntInClosedEdge >= dAngleYBottom) {
                return pntInClosedEdgeOfAreaBy1Pnts;
            }
            return OpenedCompartmentAlias.getNearestPointOfAngleBetween2Pnts(pntYTop, dAngleYTop, dAnglePntInClosedEdge, pntYBottom, dAngleYBottom);
        }
        if (cptmtSymbol instanceof CompartmentSquareN) {
            Point2D.Double pntXLeft = new Point2D.Double(dEllW / 2.0, handlePoint.getY());
            Point2D.Double pntXRight = new Point2D.Double(this.getMaxArea().width - dEllW / 2.0, handlePoint.getY());
            double dAngleXLeft = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntXLeft, 0.0);
            double dAngleXRight = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntXRight, 0.0);
            if (dAnglePntInClosedEdge >= dAngleXLeft && dAnglePntInClosedEdge <= dAngleXRight) {
                return pntInClosedEdgeOfAreaBy1Pnts;
            }
            return OpenedCompartmentAlias.getNearestPointOfAngleBetween2Pnts(pntXLeft, dAngleXLeft, dAnglePntInClosedEdge, pntXRight, dAngleXRight);
        }
        if (cptmtSymbol instanceof CompartmentSquareS) {
            Point2D.Double pntXLeft = new Point2D.Double(dEllW / 2.0, handlePoint.getY());
            Point2D.Double pntXRight = new Point2D.Double(this.getMaxArea().width - dEllW / 2.0, handlePoint.getY());
            double dAngleXLeft = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntXLeft, 0.0);
            double dAngleXRight = LibSBMLUtil.getAngleByInfoCenterPoint(this, pntXRight, 0.0);
            if (dAnglePntInClosedEdge <= dAngleXLeft && dAnglePntInClosedEdge >= dAngleXRight) {
                return pntInClosedEdgeOfAreaBy1Pnts;
            }
            return OpenedCompartmentAlias.getNearestPointOfAngleBetween2Pnts(pntXLeft, dAngleXLeft, dAnglePntInClosedEdge, pntXRight, dAngleXRight);
        }
        return pntInClosedEdgeOfAreaBy1Pnts;
    }

    public static final Point2D.Double getNearestPointOfAngleBetween2Pnts(Point2D.Double pnt1, double dAngle1, double dFreeAngle, Point2D.Double pnt2, double dAngle2) {
        double dDltaDgdToAngle2;
        double dDltaDgdToAngle1 = Math.abs(dAngle1 - dFreeAngle);
        if (dDltaDgdToAngle1 <= (dDltaDgdToAngle2 = Math.abs(dAngle2 - dFreeAngle))) {
            return pnt1;
        }
        return pnt2;
    }
}

