/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import jp.sbi.celldesigner.NameExpression;
import jp.sbi.celldesigner.NameExpressionDictionary;

public class NameTranslator {
    public static final int SBEDIT_RULE = 1;
    public static final int SNAME_RULE = 2;
    public static final int LATEX_RULE = 3;

    public static String translate(String str, int from_rule, int to_rule) {
        if (from_rule == 2 && to_rule == 1) {
            return NameTranslator.sname2sbedit(str);
        }
        return "";
    }

    public static String sname2sbedit(String str) {
        char[] original = str.toCharArray();
        char[] buffer = new char[original.length];
        int i = 0;
        int index = 0;
        while (i < original.length) {
            String key;
            char c = original[i];
            if (c != '_') {
                buffer[index++] = c;
                ++i;
                continue;
            }
            int j = i + 1;
            while (j < original.length) {
                if (original[j] == '_') break;
                ++j;
            }
            try {
                key = str.substring(i + 1, j);
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
            NameExpression entry = NameExpressionDictionary.getEntry(key);
            if (entry != null) {
                if (entry.isGreek) {
                    buffer[index++] = 36;
                    buffer[index++] = entry.sbChar;
                } else {
                    buffer[index++] = entry.sbChar;
                }
                i = j + 1;
                continue;
            }
            buffer[index++] = 95;
            ++i;
        }
        String expression = "";
        try {
            expression = new String(buffer, 0, index);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return expression;
    }
}

