/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import jp.fric.graphics.draw.GColor;
import jp.fric.graphics.draw.GElement;
import jp.fric.graphics.draw.GFramed;
import jp.fric.graphics.draw.GPointedShape;
import jp.fric.graphics.draw.GResizeHandle;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.draw.GUtil;
import jp.sbi.celldesigner.ClosedCompartmentAlias;
import jp.sbi.celldesigner.CompartmentAlias;
import jp.sbi.celldesigner.CompartmentSymbol;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.NameExpression;
import jp.sbi.celldesigner.NameExpressionDictionary;
import jp.sbi.celldesigner.NameTranslator;
import jp.sbi.celldesigner.OpenedCompartmentAlias;
import jp.sbi.celldesigner.Preference;

public class NameImage
implements GElement,
GFramed {
    private String labelStr = "";
    private String sbexp = "";
    private Rectangle2D.Double oldBound = null;
    private Point2D.Double pos = null;
    private GElement parent = null;
    private Point2D.Double backupPos = null;
    private boolean isUodoRedo = false;
    private static final int blankForX = 5;
    private static final int blankForY = 8;
    private Point2D.Double backupPosWhenBeforeChangeCompartment = null;
    private String labelIDStr = "";
    private int id_x = 0;
    private int id_y = 0;
    private int iLayerTextFntSize = 11;
    private int iNameFntSize = Preference.speciesNameFont;
    protected boolean isHighlighted = false;
    private static final int iMaxNumbersOfDisplayingCharacters = 30;
    private static final Dimension dimVirtualMoveableNameImageFrame = new Dimension(30, 20);

    public int getLayerTextFontSize() {
        return this.iLayerTextFntSize;
    }

    public void setLayerTextFontSize(int s) {
        this.iLayerTextFntSize = s;
    }

    public int getNameFontSize() {
        return this.iNameFntSize;
    }

    public void setNameFontSize(int s) {
        this.iNameFntSize = s;
    }

    public static Dimension getVirtualMoveableNameImageFrameDimension() {
        return (Dimension)dimVirtualMoveableNameImageFrame.clone();
    }

    public NameImage() {
    }

    public NameImage(String nameString, GElement parent) {
        this.setString(nameString);
        this.parent = parent;
    }

    public void setString(String labelStr) {
        this.labelStr = labelStr;
        this.sbexp = NameTranslator.translate(labelStr, 2, 1);
    }

    public void setIDString(String id) {
        this.labelIDStr = id;
    }

    public int getId_x() {
        return this.id_x;
    }

    public void setId_x(int id_x) {
        this.id_x = id_x;
    }

    public int getId_y() {
        return this.id_y;
    }

    public void setId_y(int id_y) {
        this.id_y = id_y;
    }

    public String getString() {
        return this.labelStr;
    }

    public Dimension getNameImageSize() {
        Point2D.Double size = this.getFrameSize();
        return new Dimension((int)size.getX(), (int)size.getY());
    }

    protected String getIDString() {
        return this.labelIDStr;
    }

    public void draw(Graphics2D graphics2d, int x, int y) {
        this.setFramePosition(x, y);
        this.draw(graphics2d);
    }

    @Override
    public GElement createCopy() {
        NameImage nameImage = new NameImage(this.labelStr, this.parent);
        nameImage.setIDString(this.labelIDStr);
        nameImage.setId_x(this.id_x);
        nameImage.setId_y(this.id_y);
        nameImage.setNameFontSize(this.iNameFntSize);
        nameImage.setFramePosition(this.pos.x, this.pos.y);
        return nameImage;
    }

    @Override
    public void draw(Graphics2D graphics2d) {
        this.reconfirmFramePosition();
        if (this.pos == null) {
            return;
        }
        RenderingHints backup = graphics2d.getRenderingHints();
        graphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font fontOld = graphics2d.getFont();
        if (this.parent == null || !(this.parent instanceof CompartmentAlias)) {
            Font fontNew = new Font(fontOld.getName(), fontOld.getStyle(), this.getNameFontSize());
            graphics2d.setFont(fontNew);
        }
        FontMetrics fm = graphics2d.getFontMetrics();
        boolean isHigh = false;
        boolean isLow = false;
        boolean isGreek = false;
        int y_base = fm.getAscent() + 4;
        int y_upper = y_base - 4;
        int y_lower = y_base + 4;
        int x = 0;
        int w = 0;
        int h = 0;
        double xpos = this.pos.x;
        double ypos = this.pos.y;
        char[] array = this.sbexp.toCharArray();
        Color originalcolor = graphics2d.getColor();
        graphics2d.setColor(Color.BLACK);
        if (this.parent != null && this.parent instanceof CompartmentAlias && this.isHighlighted) {
            BasicStroke org_stroke = (BasicStroke)graphics2d.getStroke();
            BasicStroke stroke = new BasicStroke(1.0f, 0, 0);
            graphics2d.setStroke(stroke);
            graphics2d.setColor(Color.MAGENTA);
            double dBoundsWidth = this.getBounds().width;
            if (dBoundsWidth > (double)NameImage.getVirtualMoveableNameImageFrameDimension().width) {
                dBoundsWidth = NameImage.getVirtualMoveableNameImageFrameDimension().width;
            }
            int iX = (int)(this.getBounds().getCenterX() - dBoundsWidth / 2.0);
            int iY = (int)this.getBounds().y + 2;
            int iW = (int)dBoundsWidth;
            int iH = (int)this.getBounds().height - 4;
            graphics2d.setColor(Color.ORANGE);
            graphics2d.setStroke(org_stroke);
            graphics2d.setColor(GColor.HIGHLIGHTED_COLOR);
        }
        int iCharacterCounter = 0;
        int i = 0;
        while (i < array.length) {
            if (this.parentIsInstanceofCompartmentAlias() && iCharacterCounter >= 30) break;
            char c = array[i];
            if (c == '~') {
                x = 0;
                h += y_base;
            } else if (c == '^') {
                isHigh = !isHigh;
            } else if (c == '%') {
                isLow = !isLow;
            } else if (c == '$') {
                isGreek = true;
            } else {
                String str = "";
                if (isGreek) {
                    NameExpression exp = NameExpressionDictionary.getEntry(c);
                    if (exp != null) {
                        str = exp.printExp;
                    }
                } else {
                    str = String.valueOf(c);
                }
                if (isHigh) {
                    graphics2d.drawString(str, (int)(xpos + (double)x), (int)(ypos + (double)h + (double)y_upper));
                } else if (isLow) {
                    graphics2d.drawString(str, (int)(xpos + (double)x), (int)(ypos + (double)h + (double)y_lower));
                } else {
                    graphics2d.drawString(str, (int)(xpos + (double)x), (int)(ypos + (double)h + (double)y_base));
                }
                ++iCharacterCounter;
                isGreek = false;
                if ((x += fm.charWidth(c)) > w) {
                    w = x;
                }
            }
            ++i;
        }
        if (!this.labelIDStr.equals("")) {
            graphics2d.drawString(this.labelIDStr, this.id_x, this.id_y);
        }
        this.oldBound = new Rectangle2D.Double(xpos, ypos, this.getFrameSize().x, this.getFrameSize().y);
        graphics2d.setFont(fontOld);
        graphics2d.setColor(originalcolor);
        graphics2d.setRenderingHints(backup);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return this.getFrameBounds();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        Rectangle2D.Double bounds = this.getBounds();
        if (bounds == null) {
            return null;
        }
        return new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth() + 4.0, bounds.getHeight() + 4.0);
    }

    @Override
    public boolean inShape(double x, double y) {
        Rectangle2D.Double bounds = this.getBounds();
        if (bounds == null) {
            return false;
        }
        return bounds.contains(x, y);
    }

    @Override
    public boolean intersects(Rectangle2D.Double selectArea) {
        Rectangle2D.Double bounds = this.getBounds();
        if (bounds == null) {
            return false;
        }
        return bounds.intersects(selectArea);
    }

    @Override
    public boolean onEdge(double x, double y) {
        if (this.pos == null) {
            return false;
        }
        double xpos = this.pos.x;
        double ypos = this.pos.y;
        if ((double)((int)x) == xpos && y >= ypos && y <= ypos + this.getFrameSize().getY()) {
            return true;
        }
        if ((double)((int)y) == ypos && x >= xpos && x <= xpos + this.getFrameSize().getX()) {
            return true;
        }
        if ((double)((int)x) == xpos + this.getFrameSize().getX() && y >= ypos && y <= ypos + this.getFrameSize().getY()) {
            return true;
        }
        return (double)((int)y) == ypos + this.getFrameSize().getY() && x >= xpos && x <= xpos + this.getFrameSize().getX();
    }

    @Override
    public boolean popupAvailable() {
        return false;
    }

    @Override
    public void setHighlighted(boolean highlight) {
        if (this.parent != null && this.parent instanceof CompartmentAlias) {
            this.isHighlighted = highlight;
            return;
        }
        this.isHighlighted = false;
    }

    @Override
    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public void showPopup(MouseEvent e, double x, double y, GStructure structure) {
    }

    @Override
    public Rectangle2D update() {
        Rectangle2D.Double newBound = this.getBounds();
        Rectangle2D.Double union = GUtil.union(this.oldBound, newBound);
        this.oldBound = newBound;
        if (this.parent == null) {
            return union;
        }
        if (this.parent instanceof CompartmentAlias) {
            CompartmentAlias parent = (CompartmentAlias)((Object)this.parent);
            if (newBound == null) {
                return union;
            }
        }
        return union;
    }

    @Override
    public Rectangle2D.Double getFrameBounds() {
        if (this.pos == null) {
            return null;
        }
        Point2D.Double size = this.getFrameSize();
        Rectangle2D.Double bounds = new Rectangle2D.Double(this.pos.x, this.pos.y, size.x, size.y);
        return bounds;
    }

    @Override
    public Point2D.Double getFramePosition() {
        return this.pos;
    }

    @Override
    public Point2D.Double getFrameSize() {
        Point2D.Double size = new Point2D.Double(0.0, 0.0);
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics2D g2 = img.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Font fontOld = g2.getFont();
        if (this.parent == null || !(this.parent instanceof CompartmentAlias)) {
            Font fontNew = new Font(fontOld.getName(), fontOld.getStyle(), this.getNameFontSize());
            g2.setFont(fontNew);
        }
        FontMetrics fm = g2.getFontMetrics();
        int y_base = fm.getAscent() + 4;
        int y_lower = y_base + 4;
        int x = 0;
        int w = 0;
        int h = 0;
        char[] array = this.sbexp.toCharArray();
        int iCharacterCounter = 0;
        int i = 0;
        while (i < array.length) {
            if (this.parentIsInstanceofCompartmentAlias() && iCharacterCounter >= 30) break;
            char c = array[i];
            if (c == '~') {
                x = 0;
                h += y_base;
            } else if (c != '^' && c != '%' && c != '$') {
                ++iCharacterCounter;
                if ((x += fm.charWidth(c)) > w) {
                    w = x;
                }
            }
            ++i;
        }
        g2.setFont(fontOld);
        size.setLocation(w + 2, h + y_lower + fm.getDescent());
        return size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reconfirmFramePosition() {
        if (this.pos == null) {
            if (this.getNameImageSize() == null || this.parent == null) return;
            if (!(this.parent instanceof OpenedCompartmentAlias) && !(this.parent instanceof ClosedCompartmentAlias)) return;
            try {
                GStructure gstructure = MainWindow.getLastInstance().getCurrentModel().getSBModel().getGStructure();
                if (gstructure == null) {
                    return;
                }
                if (this.parent instanceof OpenedCompartmentAlias) {
                    OpenedCompartmentAlias compartment = (OpenedCompartmentAlias)this.parent;
                    this.pos = compartment.getDefaultCompartmentNamePostion();
                } else {
                    if (!(this.parent instanceof ClosedCompartmentAlias)) return;
                    ClosedCompartmentAlias compartment = (ClosedCompartmentAlias)this.parent;
                    Dimension nameImageSize = this.getNameImageSize();
                    Dimension realNameImageSize = (Dimension)nameImageSize.clone();
                    if (nameImageSize.width > NameImage.getVirtualMoveableNameImageFrameDimension().width) {
                        nameImageSize.width = NameImage.getVirtualMoveableNameImageFrameDimension().width;
                    }
                    Dimension movableareaNameImageSize = (Dimension)nameImageSize.clone();
                    this.pos = compartment.setNameImagePositionWithOffset(compartment.getDefaultCompartmentNamePostion(), realNameImageSize, movableareaNameImageSize);
                }
            }
            catch (Exception myErr) {
                return;
            }
        }
        this.setFramePosition(this.pos.x, this.pos.y);
    }

    @Override
    public void setFramePosition(double x, double y) {
        if (this.parent instanceof CompartmentAlias) {
            CompartmentAlias p = (CompartmentAlias)((Object)this.parent);
            boolean bRecal = true;
            if (p instanceof ClosedCompartmentAlias) {
                if (((ClosedCompartmentAlias)p).isHighlighted()) {
                    bRecal = false;
                } else if (((ClosedCompartmentAlias)p).isHighlightedAsTarget()) {
                    bRecal = false;
                }
            }
            this.pos = bRecal ? p.recalCompartmentNameDisplayPostion(new Point2D.Double(x, y)) : new Point2D.Double(x, y);
        } else {
            this.pos = new Point2D.Double(x, y);
        }
    }

    @Override
    public void setFrameSize(double width, double height) {
    }

    @Override
    public void activateHandle(boolean active) {
    }

    @Override
    public GResizeHandle getHandle(double x, double y) {
        return null;
    }

    private boolean isInParent(Point2D.Double pos) {
        if (!(this.parent instanceof CompartmentAlias)) {
            return false;
        }
        if (this.parent instanceof OpenedCompartmentAlias) {
            return this.openedCompartmentIsInParent(pos);
        }
        double thickness = 0.0;
        CompartmentSymbol symbol = (CompartmentSymbol)((Object)((CompartmentAlias)((Object)this.parent)).getSymbol());
        thickness = symbol.getThickness();
        Point2D.Double size = this.getFrameSize();
        Point2D.Double[] edges = new Point2D.Double[]{new Point2D.Double(pos.x - thickness, pos.y - thickness + 8.0), new Point2D.Double(pos.x + size.x + thickness - 5.0, pos.y - thickness + 8.0), new Point2D.Double(pos.x - thickness, pos.y + size.y + thickness - 8.0), new Point2D.Double(pos.x + size.x + thickness - 5.0, pos.y + size.y + thickness - 8.0)};
        int i = 0;
        while (i < 4) {
            if (!this.parent.inShape(edges[i].x, edges[i].y)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean openedCompartmentIsInParent(Point2D.Double pos) {
        if (!(this.parent instanceof OpenedCompartmentAlias)) {
            return false;
        }
        Point2D.Double[] edges = new Point2D.Double[4];
        Point2D.Double size = this.getFrameSize();
        edges[0] = new Point2D.Double(pos.x, pos.y + 8.0);
        edges[1] = new Point2D.Double(pos.x + size.x - 5.0, pos.y + 8.0);
        edges[2] = new Point2D.Double(pos.x, pos.y + size.y - 8.0);
        edges[3] = new Point2D.Double(pos.x + size.x - 5.0, pos.y + size.y - 8.0);
        OpenedCompartmentAlias openCompartment = (OpenedCompartmentAlias)this.parent;
        int location = ((GPointedShape)((Object)openCompartment.getSymbol())).getHandleLocation();
        Rectangle2D.Double bounds = openCompartment.getInnerBound();
        switch (location) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                Rectangle2D.Double[] corners = openCompartment.getCornerExceptWhichIsCircle();
                boolean cornerContains = true;
                int i = 0;
                while (i < 4) {
                    if (!corners[0].contains(edges[i].x, edges[i].y) && !corners[1].contains(edges[i].x, edges[i].y)) {
                        cornerContains = false;
                        break;
                    }
                    ++i;
                }
                if (cornerContains) {
                    return true;
                }
                RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width, bounds.height, 40.0, 40.0);
                int i2 = 0;
                while (i2 < 4) {
                    if (!roundRect.contains(edges[i2].x, edges[i2].y)) {
                        return false;
                    }
                    ++i2;
                }
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                int i = 0;
                while (i < 4) {
                    if (!bounds.contains(edges[i].x, edges[i].y)) {
                        return false;
                    }
                    ++i;
                }
                break;
            }
        }
        return true;
    }

    private Point2D.Double getCenterPoint() {
        double centerx = this.getFramePosition().x + this.getFrameSize().x / 2.0;
        double centery = this.getFramePosition().y + this.getFrameSize().y / 2.0;
        if (this.parent instanceof CompartmentAlias) {
            Rectangle2D.Double bounds = ((CompartmentAlias)((Object)this.parent)).getInnerBound();
            centerx = bounds.x + bounds.width / 2.0;
            centery = bounds.y + bounds.height / 2.0;
        }
        return new Point2D.Double(centerx, centery);
    }

    private double getNearestX(Point2D.Double pos) {
        Point2D.Double centerPoint = this.getCenterPoint();
        double absolute = Math.abs(centerPoint.x - pos.x);
        double plusOrMinus = (centerPoint.x - pos.x) / absolute;
        double nearestX = pos.x;
        int i = 0;
        while ((double)i <= absolute) {
            nearestX = pos.x + (double)i * plusOrMinus;
            if (this.isInParent(new Point2D.Double(nearestX, pos.y))) {
                return nearestX;
            }
            ++i;
        }
        return centerPoint.x - this.getFrameSize().x / 2.0;
    }

    private double getNearestY(Point2D.Double pos) {
        Point2D.Double centerPoint = this.getCenterPoint();
        double absolute = Math.abs(centerPoint.y - pos.y);
        double plusOrMinus = (centerPoint.y - pos.y) / absolute;
        double nearestY = pos.y;
        int i = 0;
        while ((double)i <= absolute) {
            nearestY = pos.y + (double)i * plusOrMinus;
            if (this.isInParent(new Point2D.Double(pos.x, nearestY))) {
                return nearestY;
            }
            ++i;
        }
        return centerPoint.y - this.getFrameSize().y / 2.0;
    }

    public Point2D.Double getNearestPointInParent(Point2D.Double pos) {
        if (this.parent instanceof CompartmentAlias) {
            return pos;
        }
        if (this.isInParent(pos)) {
            return pos;
        }
        int centerx = (int)(this.getCenterPoint().x - this.getFrameSize().x / 2.0);
        int centery = (int)(this.getCenterPoint().y - this.getFrameSize().y / 2.0);
        if (centerx == (int)pos.x || centery == (int)pos.y) {
            if (centerx == (int)pos.x) {
                return new Point2D.Double(centerx, this.getNearestY(new Point2D.Double(centerx, pos.y)));
            }
            return new Point2D.Double(this.getNearestX(new Point2D.Double(pos.x, centery)), centery);
        }
        double x0 = this.getCenterPoint().x;
        double y0 = this.getCenterPoint().y;
        double x1 = pos.x + this.getFrameSize().x / 2.0;
        double y1 = pos.y + this.getFrameSize().y / 2.0;
        double distance = Math.sqrt((x0 - x1) * (x0 - x1) + (y0 - y1) * (y0 - y1));
        double sin = (y0 - y1) / distance;
        double cos = (x0 - x1) / distance;
        double newx = x1;
        double newy = y1;
        int i = 0;
        while ((double)i < distance) {
            newx = x1 + (double)i * cos - this.getFrameSize().x / 2.0;
            newy = y1 + (double)i * sin - this.getFrameSize().y / 2.0;
            if (this.isInParent(new Point2D.Double(newx, newy))) {
                return new Point2D.Double(newx, newy);
            }
            ++i;
        }
        return new Point2D.Double(centerx, centery);
    }

    public Rectangle2D resetPosition() {
        Point2D.Double point = this.getFramePosition();
        if (this.isInParent(point)) {
            return this.getBounds();
        }
        point = this.getNearestPointInParent(point);
        this.setFramePosition(point.x, point.y);
        return this.update();
    }

    public void backupPosition() {
        this.backupPos = (Point2D.Double)this.pos.clone();
    }

    public Rectangle2D restorePosition() {
        if (this.backupPos == null) {
            return null;
        }
        this.setFramePosition(this.backupPos.x, this.backupPos.y);
        return this.update();
    }

    public Point2D.Double getBackupPosition() {
        return this.backupPos;
    }

    public void setBackupPosition(Point2D.Double backupPosition) {
        this.backupPos = (Point2D.Double)backupPosition.clone();
    }

    public boolean getUndoRedoFlg() {
        return this.isUodoRedo;
    }

    public void setUndoRedoFlg(boolean flg) {
        this.isUodoRedo = flg;
    }

    public Object getNameImageParent() {
        return this.parent;
    }

    public void backupPositionBeforeChangeCompartment() {
        this.backupPosWhenBeforeChangeCompartment = this.pos == null ? null : (Point2D.Double)this.pos.clone();
    }

    public Rectangle2D restorePositionAfterChangeCompartmentCancled() {
        if (this.backupPosWhenBeforeChangeCompartment == null) {
            return null;
        }
        this.setFramePosition(this.backupPosWhenBeforeChangeCompartment.x, this.backupPosWhenBeforeChangeCompartment.y);
        return this.update();
    }

    public void setFramePositionWithoutRecalcPostion(double x, double y) {
        this.pos = new Point2D.Double(x, y);
    }

    public boolean parentIsInstanceofCompartmentAlias() {
        return this.parent != null && (this.parent instanceof OpenedCompartmentAlias || this.parent instanceof ClosedCompartmentAlias);
    }
}

