/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jp.fric.graphics.draw.GMouseInterpreter;
import jp.sbi.sbml.Notes;
import jp.sbi.sbml.SpecInfo;
import jp.sbi.sbml.util.LibSBMLUtil;
import jp.sbi.sbml.util.SBMLPanelLists;
import jp.sbi.sbml.util.SBaseListPanel;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class MyTreePanel
extends JTree
implements KeyListener {
    GMouseInterpreter mouseInterpreter = null;
    SBMLPanelLists sbmlPanelLists = null;
    static final String MODEL = "Model";
    static final String COMPARTMENT = "Compartments";
    static final String SPECIES = "Species";
    static final String REACTION = "Reactions";
    Vector selectedCompartment = null;
    Vector selectedSpecies = null;
    Vector selectedReaction = null;
    TreePath compartmentPath = null;
    TreePath speciesPath = null;
    TreePath reactionPath = null;
    DefaultMutableTreeNode rootNode = null;
    DefaultMutableTreeNode compartmentNode = null;
    DefaultMutableTreeNode speciesNode = null;
    DefaultMutableTreeNode reactionNode = null;
    boolean eventontree = true;
    boolean fromListEvent = false;

    public MyTreePanel(GMouseInterpreter mouseinterpreter) {
        this.setCellRenderer(new MyTreeCellRenderer1());
        this.mouseInterpreter = mouseinterpreter;
        this.selectedCompartment = new Vector();
        this.selectedSpecies = new Vector();
        this.selectedReaction = new Vector();
        this.rootNode = new DefaultMutableTreeNode(MODEL);
        this.compartmentNode = new DefaultMutableTreeNode(COMPARTMENT);
        this.rootNode.add(this.compartmentNode);
        this.compartmentPath = new TreePath(this.compartmentNode.getPath());
        this.speciesNode = new DefaultMutableTreeNode(SPECIES);
        this.rootNode.add(this.speciesNode);
        this.speciesPath = new TreePath(this.speciesNode.getPath());
        this.reactionNode = new DefaultMutableTreeNode(REACTION);
        this.rootNode.add(this.reactionNode);
        this.reactionPath = new TreePath(this.reactionNode.getPath());
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.expandRow(0);
        this.setModel(new DefaultTreeModel(this.rootNode));
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.reload();
    }

    public void setFromListEvent(boolean flg) {
        this.fromListEvent = flg;
    }

    public boolean isFromListEvent() {
        return this.fromListEvent;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.mouseInterpreter.setMultiSelectMode(false);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void setPanelLists(SBMLPanelLists sbmlPanelLists) {
        this.sbmlPanelLists = sbmlPanelLists;
    }

    public boolean isEventOnTree() {
        return this.eventontree;
    }

    public void setEventOnTree(boolean flg) {
        this.eventontree = flg;
    }

    public void setTreeNode() {
        SBase base;
        String name;
        String id;
        this.eventontree = false;
        boolean component_expandflg = this.isExpanded(this.compartmentPath);
        this.compartmentNode.removeAllChildren();
        SBaseListPanel listpanel = this.sbmlPanelLists.getSBaseListPanel(2);
        int i = 0;
        while (i < listpanel.getRowCount()) {
            id = (String)listpanel.getValueAt(i, "id");
            name = (String)listpanel.getValueAt(i, "name");
            base = listpanel.getSBaseList().get((long)i);
            DefaultMutableTreeNode compartment = new DefaultMutableTreeNode(new MyTreeLeafObject(COMPARTMENT, id, name, base), false);
            this.compartmentNode.add(compartment);
            ++i;
        }
        boolean species_expandflg = this.isExpanded(this.speciesPath);
        this.speciesNode.removeAllChildren();
        listpanel = this.sbmlPanelLists.getSBaseListPanel(3);
        int i2 = 0;
        while (i2 < listpanel.getRowCount()) {
            id = (String)listpanel.getValueAt(i2, "id");
            name = (String)listpanel.getValueAt(i2, "name");
            base = listpanel.getSBaseList().get((long)i2);
            DefaultMutableTreeNode species = new DefaultMutableTreeNode(new MyTreeLeafObject(SPECIES, id, name, base), false);
            this.speciesNode.add(species);
            ++i2;
        }
        boolean reaction_expandflg = this.isExpanded(this.reactionPath);
        this.reactionNode.removeAllChildren();
        listpanel = this.sbmlPanelLists.getSBaseListPanel(6);
        int i3 = 0;
        while (i3 < listpanel.getRowCount()) {
            id = (String)listpanel.getValueAt(i3, "id");
            name = (String)listpanel.getValueAt(i3, "name");
            base = listpanel.getSBaseList().get((long)i3);
            DefaultMutableTreeNode reactions = new DefaultMutableTreeNode(new MyTreeLeafObject(REACTION, id, name, base), false);
            this.reactionNode.add(reactions);
            ++i3;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.reload();
        if (component_expandflg) {
            this.expandPath(this.compartmentPath);
        }
        if (species_expandflg) {
            this.expandPath(this.speciesPath);
        }
        if (reaction_expandflg) {
            this.expandPath(this.reactionPath);
        }
        this.resetSelectedNode();
        this.eventontree = true;
        this.fromListEvent = false;
    }

    public void setCompartmentTreeNode() {
        this.eventontree = false;
        boolean exp = this.isExpanded(this.compartmentPath);
        this.compartmentNode.removeAllChildren();
        SBaseListPanel listpanel = this.sbmlPanelLists.getSBaseListPanel(2);
        int i = 0;
        while (i < listpanel.getRowCount()) {
            String id = (String)listpanel.getValueAt(i, "id");
            String name = (String)listpanel.getValueAt(i, "name");
            SBase base = listpanel.getSBaseList().get((long)i);
            DefaultMutableTreeNode compartment = new DefaultMutableTreeNode(new MyTreeLeafObject(COMPARTMENT, id, name, base), false);
            this.compartmentNode.add(compartment);
            ++i;
        }
        ((DefaultTreeModel)this.getModel()).reload(this.compartmentNode);
        if (exp) {
            this.expandPath(this.compartmentPath);
        }
        this.resetSelectedNode();
        this.eventontree = true;
        this.fromListEvent = false;
    }

    public void setSpeciesTreeNode() {
        this.eventontree = false;
        boolean exp = this.isExpanded(this.speciesPath);
        this.speciesNode.removeAllChildren();
        SBaseListPanel listpanel = this.sbmlPanelLists.getSBaseListPanel(3);
        int i = 0;
        while (i < listpanel.getRowCount()) {
            String id = (String)listpanel.getValueAt(i, "id");
            String name = (String)listpanel.getValueAt(i, "name");
            SBase base = listpanel.getSBaseList().get((long)i);
            DefaultMutableTreeNode species = new DefaultMutableTreeNode(new MyTreeLeafObject(SPECIES, id, name, base), false);
            this.speciesNode.add(species);
            ++i;
        }
        ((DefaultTreeModel)this.getModel()).reload(this.speciesNode);
        if (exp) {
            this.expandPath(this.speciesPath);
        }
        this.resetSelectedNode();
        this.eventontree = true;
        this.fromListEvent = false;
    }

    public void setReactionTreeNode() {
        this.eventontree = false;
        boolean exp = this.isExpanded(this.reactionPath);
        this.reactionNode.removeAllChildren();
        SBaseListPanel listpanel = this.sbmlPanelLists.getSBaseListPanel(6);
        int i = 0;
        while (i < listpanel.getRowCount()) {
            String id = (String)listpanel.getValueAt(i, "id");
            String name = (String)listpanel.getValueAt(i, "name");
            SBase base = listpanel.getSBaseList().get((long)i);
            DefaultMutableTreeNode reactions = new DefaultMutableTreeNode(new MyTreeLeafObject(REACTION, id, name, base), false);
            this.reactionNode.add(reactions);
            ++i;
        }
        ((DefaultTreeModel)this.getModel()).reload(this.reactionNode);
        if (exp) {
            this.expandPath(this.reactionPath);
        }
        this.resetSelectedNode();
        this.eventontree = true;
        this.fromListEvent = false;
    }

    private int getStartLineNo(int type) {
        int lineno = 0;
        if (type == 2) {
            lineno = 0;
            ++lineno;
        } else if (type == 3) {
            lineno = 0;
            ++lineno;
            if (this.isExpanded(this.compartmentPath)) {
                lineno += this.compartmentNode.getChildCount();
            }
            ++lineno;
        } else if (type == 6) {
            lineno = 0;
            ++lineno;
            ++lineno;
            if (this.isExpanded(this.compartmentPath)) {
                lineno += this.compartmentNode.getChildCount();
            }
            if (this.isExpanded(this.speciesPath)) {
                lineno += this.speciesNode.getChildCount();
            }
            ++lineno;
        }
        return lineno;
    }

    public void addSelectedNode(int type, String id, String name) {
        if (type == 2) {
            this.selectedCompartment.add(new MyTreeLeafObject(COMPARTMENT, id, name));
        } else if (type == 3) {
            this.selectedSpecies.add(new MyTreeLeafObject(SPECIES, id, name));
        } else if (type == 6) {
            this.selectedReaction.add(new MyTreeLeafObject(REACTION, id, name));
        }
    }

    private String getSelectedId(String type, int idx) {
        if (type.compareTo(COMPARTMENT) == 0) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.compartmentNode.getChildAt(idx);
            MyTreeLeafObject obj = (MyTreeLeafObject)node.getUserObject();
            return obj.getId();
        }
        if (type.compareTo(SPECIES) == 0) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.speciesNode.getChildAt(idx);
            MyTreeLeafObject obj = (MyTreeLeafObject)((Object)this.speciesNode.getChildAt(idx));
            return obj.getId();
        }
        if (type.compareTo(REACTION) == 0) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.reactionNode.getChildAt(idx);
            MyTreeLeafObject obj = (MyTreeLeafObject)((Object)this.reactionNode.getChildAt(idx));
            return obj.getId();
        }
        return null;
    }

    public void selectNode(int type, String id) {
        int startrow = this.getStartLineNo(type);
        this.eventontree = false;
        if (type == 2) {
            if (this.isExpanded(this.compartmentPath)) {
                int size = this.compartmentNode.getChildCount();
                int i = 0;
                while (i < size) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.compartmentNode.getChildAt(i);
                    MyTreeLeafObject obj = (MyTreeLeafObject)node.getUserObject();
                    if (id.compareTo(obj.getId()) == 0) {
                        this.addSelectionRow(startrow + i + 1);
                        this.eventontree = true;
                        return;
                    }
                    ++i;
                }
            }
        } else if (type == 3) {
            if (this.isExpanded(this.speciesPath)) {
                int size = this.speciesNode.getChildCount();
                int i = 0;
                while (i < size) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.speciesNode.getChildAt(i);
                    MyTreeLeafObject obj = (MyTreeLeafObject)node.getUserObject();
                    if (id.compareTo(obj.getId()) == 0) {
                        this.addSelectionRow(startrow + i + 1);
                        this.eventontree = true;
                        return;
                    }
                    ++i;
                }
            }
        } else if (type == 6 && this.isExpanded(this.reactionPath)) {
            int size = this.reactionNode.getChildCount();
            int i = 0;
            while (i < size) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.reactionNode.getChildAt(i);
                MyTreeLeafObject obj = (MyTreeLeafObject)node.getUserObject();
                if (id.compareTo(obj.getId()) == 0) {
                    this.addSelectionRow(startrow + i + 1);
                    this.eventontree = true;
                    return;
                }
                ++i;
            }
        }
        this.eventontree = true;
    }

    public void clearSelectedNode() {
        this.selectedCompartment.clear();
        this.selectedSpecies.clear();
        this.selectedReaction.clear();
    }

    public void clearSelecteElement() {
        this.selectedCompartment.clear();
        this.selectedSpecies.clear();
        this.selectedReaction.clear();
        this.clearSelection();
    }

    public void resetSelectedNode() {
        MyTreeLeafObject node;
        this.eventontree = false;
        int i = 0;
        while (i < this.selectedCompartment.size()) {
            node = (MyTreeLeafObject)this.selectedCompartment.elementAt(i);
            this.selectNode(2, node.getId());
            ++i;
        }
        i = 0;
        while (i < this.selectedSpecies.size()) {
            node = (MyTreeLeafObject)this.selectedSpecies.elementAt(i);
            this.selectNode(3, node.getId());
            ++i;
        }
        i = 0;
        while (i < this.selectedReaction.size()) {
            node = (MyTreeLeafObject)this.selectedReaction.elementAt(i);
            this.selectNode(6, node.getId());
            ++i;
        }
        this.eventontree = true;
    }

    public Vector getSelectedNode(TreePath path) {
        Vector<Object> rtnval = new Vector<Object>();
        int pathnum = path.getPathCount();
        if (pathnum < 2) {
            return rtnval;
        }
        String type = path.getPathComponent(pathnum - 2).toString();
        if (type == null) {
            return rtnval;
        }
        String name = path.getLastPathComponent().toString();
        int noderow = this.getRowForPath(path);
        int titlerow = 0;
        int totalcount = 0;
        if (type.compareTo(SPECIES) == 0) {
            titlerow = this.getRowForPath(this.speciesPath);
            totalcount = this.speciesNode.getChildCount();
        } else if (type.compareTo(COMPARTMENT) == 0) {
            titlerow = this.getRowForPath(this.compartmentPath);
            totalcount = this.compartmentNode.getChildCount();
        } else if (type.compareTo(REACTION) == 0) {
            titlerow = this.getRowForPath(this.reactionPath);
            totalcount = this.reactionNode.getChildCount();
        } else {
            return rtnval;
        }
        rtnval.add(type);
        rtnval.add(new Integer(noderow - titlerow - 1));
        rtnval.add(new Integer(titlerow));
        rtnval.add(new Integer(totalcount));
        return rtnval;
    }

    public Vector getSelectedDirNode(TreePath path) {
        Vector<Object> rtnval = new Vector<Object>();
        int pathnum = path.getPathCount();
        String type = path.getPathComponent(1).toString();
        if (type == null) {
            return rtnval;
        }
        String name = path.getLastPathComponent().toString();
        int totalcount = 0;
        if (type.compareTo(SPECIES) == 0) {
            totalcount = this.speciesNode.getChildCount();
        } else if (type.compareTo(COMPARTMENT) == 0) {
            totalcount = this.compartmentNode.getChildCount();
        } else if (type.compareTo(REACTION) == 0) {
            totalcount = this.reactionNode.getChildCount();
        }
        rtnval.add(type);
        rtnval.add(new Integer(totalcount));
        return rtnval;
    }

    public String getSelectedType(TreePath path) {
        int pathnum = path.getPathCount();
        if (pathnum > 1) {
            String type = path.getPathComponent(1).toString();
            return type;
        }
        return null;
    }

    public void setProteinEtcSelectNode(Object[] obj) {
        Species sbase = null;
        int i = 0;
        while (i < obj.length) {
            sbase = (Species)obj[i];
            this.selectedSpecies.add(new MyTreeLeafObject(SPECIES, sbase.getId(), sbase.getName()));
            ++i;
        }
    }

    class MyTreeCellRenderer1
    extends DefaultTreeCellRenderer {
        MyTreeCellRenderer1() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Object object = ((DefaultMutableTreeNode)value).getUserObject();
            if (MyTreePanel.this.sbmlPanelLists == null || !(object instanceof MyTreeLeafObject)) {
                this.setToolTipText(null);
                return this;
            }
            MyTreeLeafObject obj = (MyTreeLeafObject)object;
            this.setToolTipText(this.getToolTip(obj.base));
            return this;
        }

        private String getToolTip(SBase base) {
            Notes notes = (Notes)LibSBMLUtil.getNotes(base, new SpecInfo());
            if (notes != null && !notes.getText().equals("")) {
                String text = notes.getText();
                return "<html><body>" + text + "</body></html>";
            }
            return null;
        }
    }

    class MyTreeLeafObject {
        private String type = "";
        private String id = "";
        private String name = "";
        private SBase base;

        public MyTreeLeafObject(String type, String id, String name) {
            this(type, id, name, null);
        }

        public MyTreeLeafObject(String type, String id, String name, SBase base) {
            this.type = type;
            this.id = id;
            this.name = name;
            this.base = base;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public SBase getBase() {
            return this.base;
        }

        public String toString() {
            return String.valueOf(this.name) + " (id = " + this.id + ")";
        }
    }
}

