/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import jp.fric.graphics.draw.GStructure;
import jp.fric.graphics.multiwindow.ContentsFiler;
import jp.fric.graphics.multiwindow.FileManager;
import jp.fric.graphics.multiwindow.MultiWindowFrame;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MainWindowAccess;
import jp.sbi.celldesigner.SBEventRecorder;
import jp.sbi.celldesigner.SBMLFiler;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.util.RecentFiles;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.SBase;

public class MyFileManager
extends FileManager {
    public MainWindowAccess mainwindowaccess;
    private RecentFiles recentFiles = null;
    private boolean isSaveEnabled;
    private MainWindow window;
    private boolean isJWSStart = false;

    public MyFileManager(ContentsFiler contentsfiler, String openDirectory, String saveDirectory) {
        super(contentsfiler, openDirectory, saveDirectory);
    }

    public MyFileManager(ContentsFiler contentsfiler) {
        super(contentsfiler);
    }

    public MyFileManager(ContentsFiler contentsfiler, String openDirectory, String saveDirectory, MainWindow window) {
        this(contentsfiler, openDirectory, saveDirectory);
        this.window = window;
    }

    public MyFileManager(ContentsFiler contentsfiler, MainWindow window) {
        this(contentsfiler);
        this.window = window;
    }

    public void setRecentFiles(RecentFiles recentFiles) {
        this.recentFiles = recentFiles;
    }

    public void appendMenuItem(JMenu menu, Action action, int menuId) {
        switch (menuId) {
            case 1: {
                this.isAppendedNew = true;
                break;
            }
            case 2: {
                this.isAppendedOpen = true;
                break;
            }
            case 8: {
                this.isAppendedOpenInSBGNViewer = true;
                break;
            }
            case 3: {
                this.isAppendedClose = true;
                break;
            }
            case 4: {
                this.isAppendedCloseAll = true;
                break;
            }
            case 5: {
                this.isAppendedSave = true;
                break;
            }
            case 6: {
                this.isAppendedSaveAs = true;
                break;
            }
            case 7: {
                this.isAppendedSaveAll = true;
            }
        }
        this.appendItem(menu, action);
    }

    public void appendItem(JMenu menu, Action action) {
        JMenuItem menuitem = new JMenuItem(action);
        menuitem.setIcon(null);
        menuitem.setToolTipText(null);
        menu.add(menuitem);
    }

    @Override
    protected void appendCloseAllItem(JMenu jmenu, String string, int i) {
    }

    @Override
    protected void appendCloseItem(JMenu jmenu, String string, int i) {
    }

    public void fileClose() {
        SBModelFrame jpanel = this.mainwindowaccess.getCurrentModel();
        try {
            this.getCloseCommand(jpanel, true, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void appendNewItem(JMenu jmenu, String string, int i) {
        this.isAppendedNew = true;
        JMenuItem jmenuitem = new JMenuItem(string, i);
        jmenu.add(jmenuitem);
        jmenuitem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jmenuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                MyFileManager.this.getNewCommand();
            }
        });
    }

    @Override
    protected void appendOpenItem(JMenu jmenu, String string, int i) {
        this.isAppendedOpen = true;
        JMenuItem jmenuitem = new JMenuItem(string, i);
        jmenu.add(jmenuitem);
        jmenuitem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jmenuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                MyFileManager.this.getOpenCommand();
            }
        });
    }

    @Override
    protected void appendOpenInSBGNViewerItem(JMenu jmenu, String string, int i) {
    }

    public void fileOpen() {
        this.getOpenCommand();
    }

    public void getOpenCommand(StringBuffer sbuf, String modelId) {
        MultiWindowFrame multiwindowframe;
        MainWindow.startProgressBarTask("Loading SBML");
        try {
            multiwindowframe = this.filer.read(sbuf);
            multiwindowframe.setMainWindowAccess(this.mainwindowaccess);
            ((SBModelFrame)multiwindowframe).getSBModel().start(this.window);
            multiwindowframe.setFilenameIgnoreSetTitle(modelId);
            this.openingFrame(multiwindowframe);
        }
        catch (Exception exception) {
            this.window.showMessageDialog("Exception Error", exception.getMessage(), 0);
            MainWindow.stopProgressBarTask();
            return;
        }
        SBModel sbmodel = ((SBModelFrame)multiwindowframe).getSBModel();
        LibSBMLUtil.checkCompartmentDimensionAndUnits((ListOf)sbmodel.getModel().getListOfCompartments(), this.window);
        LibSBMLUtil.checkCompartmentSize((ListOf)sbmodel.getModel().getListOfCompartments(), this.window);
        MainWindow.stopProgressBarTask();
    }

    public void getOpenCommand(InputStream is, int level, int version, String modelId) {
        MultiWindowFrame multiwindowframe;
        try {
            multiwindowframe = this.filer.read(is, level, version);
        }
        catch (Exception exception) {
            this.window.showMessageDialog("Exception Error", exception.getMessage(), 0);
            return;
        }
        if (multiwindowframe != null) {
            multiwindowframe.setMainWindowAccess(this.mainwindowaccess);
            multiwindowframe.setFilenameIgnoreSetTitle(modelId);
            this.openingFrame(multiwindowframe);
        }
    }

    @Override
    protected void appendSaveAllItem(JMenu jmenu, String string, int i) {
    }

    @Override
    protected void appendSaveAsItem(JMenu jmenu, String string, int i) {
    }

    @Override
    protected void appendSaveItem(JMenu jmenu, String string, int i) {
    }

    public boolean closeAllDocuments(boolean msgflg) {
        try {
            this.getCloseAllCommand(false, msgflg);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    protected void getCloseCommand(MultiWindowFrame frame, boolean b) {
    }

    protected void getCloseCommand(MultiWindowFrame multiwindowframe, boolean bool, boolean msgflg) throws Exception {
        block16: {
            try {
                if (multiwindowframe == null) break block16;
                if (multiwindowframe.hasChangedInSBModelOrControlPanel() && this.isSaveEnabled) {
                    String title = "Confirmation";
                    String message = "\"" + multiwindowframe.getFilename() + "\" has been modified. Save the changes\uff1f";
                    int optiontype = 1;
                    int selectedoption = JOptionPane.showConfirmDialog(multiwindowframe, message, title, optiontype, 3, null);
                    switch (selectedoption) {
                        case 0: {
                            this.getSaveCommand(multiwindowframe);
                            break;
                        }
                        case 2: {
                            this.window.setDefaultCloseOperation(0);
                            throw new Exception("Saving change canceled");
                        }
                    }
                }
                if (((SBModelFrame)multiwindowframe).getSBModel() != null) {
                    MainWindow.getLastInstance().modelClosed((SBase)((SBModelFrame)multiwindowframe).getSBModel().getModel());
                }
                this.mainwindowaccess.removePanelToTabbedPane(multiwindowframe);
                this.windowManager.modelClosed(multiwindowframe);
                try {
                    String log = "Close " + multiwindowframe.getFilename();
                    SBEventRecorder.addLog(log);
                }
                catch (NullPointerException log) {
                    // empty catch block
                }
                MainWindow.getLastInstance().removeListOfCP((SBModelFrame)multiwindowframe);
                multiwindowframe.releaseAll();
                this.fireListeners(2, multiwindowframe);
            }
            finally {
                if (bool) {
                    this.startGC();
                }
            }
        }
    }

    @Override
    public void getNewCommand() {
        MultiWindowFrame multiwindowframe = this.filer.createNewFrame(this.mainwindowaccess.getMyFrame());
        if (multiwindowframe != null) {
            multiwindowframe.setMainWindowAccess(this.mainwindowaccess);
            if (multiwindowframe.getFilename() == null) {
                multiwindowframe.setFilename(this.filer.defaultName());
            }
            this.openingFrame(multiwindowframe);
            boolean cfr_ignored_0 = multiwindowframe instanceof SBModelFrame;
        }
    }

    @Override
    public void getOpenCommand() {
        String[] suffices = this.filer.openingSuffixes();
        String description = this.filer.openingDescription();
        File file = this.filePather.getUserSelection((Component)this.mainwindowaccess.getMyFrame(), 1, suffices, description, null);
        MainWindow.startProgressBarTask("Loading...");
        this.getOpenCommand(file);
        MainWindow.stopProgressBarTask();
    }

    @Override
    public void getOpenInSBGNViewerCommand(File file) {
        try {
            block11: {
                if (file == null) {
                    return;
                }
                this.window.backupListPanelColWidth();
                boolean validationFlag = ((SBMLFiler)this.filer).isValidationEnabled();
                try {
                    try {
                        ((SBMLFiler)this.filer).setValidationEnabled(false);
                        this.getOpenCommand(file, 2);
                    }
                    catch (Exception exception) {
                        ((SBMLFiler)this.filer).setValidationEnabled(validationFlag);
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    ((SBMLFiler)this.filer).setValidationEnabled(validationFlag);
                    throw throwable;
                }
                ((SBMLFiler)this.filer).setValidationEnabled(validationFlag);
            }
            MainWindow.removeGelementsWhichNotFitSBGNViewer(this.window);
            this.window.setSBFrameViewModeForGAtom(this.window.getCurrentModel(), 2);
            this.window.getCurrentModel().getSBModel().updateBoundsForSBGNViewer();
            this.window.getCurrentModel().getSBModel().updatingreactionsfitSBGNViewer();
            if (this.mainwindowaccess instanceof MainWindow) {
                ((MainWindow)this.mainwindowaccess).componentSelectionChanged();
            }
            try {
                this.window.setSBFrameViewModeForGLinks(this.window.getCurrentModel(), 2);
                GStructure gstr = this.window.getCurrentModel().getSBModel().getGStructure();
                Rectangle2D rectangle2D = gstr.updateLinks(true);
            }
            catch (Exception myErr) {
                return;
            }
            this.window.getCurrentModel().repaintLogicalArea(this.window.getCurrentModel().getCurrentLogicalViewArea());
            this.window.resizeSbasePanelColWidthToFitSBGNViewer();
        }
        catch (Exception ex) {
            String errorMessage = "Can not convert to SBGN-Viewer mode.";
            String errorTitle = "Error";
            JOptionPane.showMessageDialog(this.window, errorMessage, errorTitle, 0);
        }
    }

    public void getOpenCommand(File file) {
        this.getOpenCommand(file, 1);
    }

    public MultiWindowFrame getOpenCommand(File file, int currentViewType) {
        return this.getOpenCommand(file, currentViewType, false, true);
    }

    public MultiWindowFrame getOpenCommand(File file, int currentViewType, boolean inProcessPluginOpenNewModelCmd, boolean addtoRecentFiles) {
        MultiWindowFrame multiwindowframe;
        block21: {
            if (file == null) {
                return null;
            }
            System.gc();
            MainWindow.startProgressBarTask("Loading SBML");
            multiwindowframe = this.filer instanceof SBMLFiler ? ((SBMLFiler)this.filer).read(file, inProcessPluginOpenNewModelCmd) : this.filer.read(file);
            if (multiwindowframe != null) break block21;
            MainWindow.stopProgressBarTask();
            return null;
        }
        try {
            ((SBModelFrame)multiwindowframe).setUIType(currentViewType);
        }
        catch (OutOfMemoryError e) {
            MainWindow.stopProgressBarTask();
            this.window.showMessageDialog("Out of Memory Error", e.getMessage(), 0);
            return null;
        }
        catch (NullPointerException e) {
            String errorMessage = "Invalid file: cannot open the file caused by ";
            this.window.showMessageDialog("Invalid File error", String.valueOf(errorMessage) + e.toString(), 0);
            e.printStackTrace();
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MainWindow.stopProgressBarTask();
            this.window.showMessageDialog("Exception Error", exception.toString(), 0);
            return null;
        }
        if (currentViewType == 1) {
            SBModel sbmodel = ((SBModelFrame)multiwindowframe).getSBModel();
            LibSBMLUtil.checkCompartmentDimensionAndUnits((ListOf)sbmodel.getModel().getListOfCompartments(), this.window);
            LibSBMLUtil.checkCompartmentSize((ListOf)sbmodel.getModel().getListOfCompartments(), this.window);
        }
        MainWindow.stopProgressBarTask();
        if (multiwindowframe != null) {
            boolean init = ((SBModelFrame)multiwindowframe).getSBModel().start(this.window);
            if (this.window != null) {
                this.window.repaint();
            }
            if (init) {
                multiwindowframe.setMainWindowAccess(this.mainwindowaccess);
                if (inProcessPluginOpenNewModelCmd) {
                    multiwindowframe.setPath(null, "newModel");
                } else {
                    multiwindowframe.setPath(file);
                }
                this.openingFrame(multiwindowframe);
                try {
                    SBModel sbmodel = this.window.getCurrentModel().getSBModel();
                    sbmodel.reconfirmSpeciesIDafterSBModelhavebeenbuilded(99);
                    LibSBMLUtil.createProteinGeneRNAAntiSenseRNANotes(sbmodel);
                    LibSBMLUtil.creatListPanelsNotes(sbmodel);
                }
                catch (Exception exception) {}
            } else {
                try {
                    this.getCloseCommand(multiwindowframe, true, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (currentViewType == 2) {
            return multiwindowframe;
        }
        if (addtoRecentFiles) {
            this.recentFiles.add(file.getAbsolutePath());
            try {
                String log = "Open " + file.getName();
                SBEventRecorder.addLog(log);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return multiwindowframe;
    }

    protected void getSaveAllCommand() {
        Vector vector = this.mainwindowaccess.getModels();
        int i = 0;
        while (i < vector.size()) {
            MultiWindowFrame multiwindowframe = (MultiWindowFrame)vector.elementAt(i);
            try {
                this.getSaveCommand(multiwindowframe);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    protected void getSaveAsCommand(MultiWindowFrame multiwindowframe) throws Exception {
        if (multiwindowframe != null && this.isSaveEnabled) {
            String filename;
            String description;
            String[] suffices = this.filer.savingSuffixes();
            File file = this.filePather.getUserSelection((Component)multiwindowframe, 2, suffices, description = this.filer.savingDescription(), filename = multiwindowframe.getFilename());
            if (file == null) {
                throw new Exception("UserSelection canceled");
            }
            try {
                MainWindow.startProgressBarTask("Saving...");
                this.filer.write(file, multiwindowframe);
                MainWindow.stopProgressBarTask();
            }
            catch (Exception exception) {
                MainWindow.stopProgressBarTask();
                if (exception.getMessage().equals("canceled")) {
                    return;
                }
                StringWriter sr = new StringWriter();
                exception.printStackTrace(new PrintWriter(sr));
                this.window.showMessageDialog("Exception Error", sr.toString(), 0);
                return;
            }
            multiwindowframe.setPath(file);
            this.recentFiles.add(file.getAbsolutePath());
            multiwindowframe.saveDone();
            this.window.resetPanelTooltip(multiwindowframe, file.getName());
            this.windowManager.documentRenamed(multiwindowframe);
            try {
                String log = String.valueOf(filename) + " Save as " + file.getName();
                SBEventRecorder.addLog(log);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void getSaveCommand(MultiWindowFrame multiwindowframe) throws Exception {
        if (multiwindowframe != null && this.isSaveEnabled) {
            File file = multiwindowframe.getPath();
            if (file != null && !this.isJWSStart) {
                try {
                    try {
                        MainWindow.startProgressBarTask("Saving...");
                        this.filer.write(file, multiwindowframe);
                    }
                    catch (Exception exception) {
                        StringWriter sr = new StringWriter();
                        exception.printStackTrace(new PrintWriter(sr));
                        this.window.showMessageDialog("Exception Error", sr.toString(), 0);
                        ((SBMLFiler)this.filer).setIgnoreWarning(false);
                        MainWindow.stopProgressBarTask();
                        return;
                    }
                }
                finally {
                    MainWindow.stopProgressBarTask();
                }
                this.recentFiles.add(file.getAbsolutePath());
                multiwindowframe.saveDone();
            } else {
                this.getSaveAsCommand(multiwindowframe);
                this.isJWSStart = false;
            }
            try {
                String log = "Save " + multiwindowframe.getFilename();
                SBEventRecorder.addLog(log);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    protected void getSaveCommandInSBGNViewer(MultiWindowFrame multiwindowframe, File file) throws Exception {
        if (multiwindowframe != null && file != null) {
            try {
                boolean validationFlag = ((SBMLFiler)this.filer).isValidationEnabled();
                try {
                    try {
                        ((SBMLFiler)this.filer).setValidationEnabled(false);
                        this.filer.write(file, multiwindowframe);
                    }
                    catch (Exception exception) {
                        ((SBMLFiler)this.filer).setValidationEnabled(validationFlag);
                    }
                }
                finally {
                    ((SBMLFiler)this.filer).setValidationEnabled(validationFlag);
                }
            }
            catch (Exception exception) {
                StringWriter sr = new StringWriter();
                exception.printStackTrace(new PrintWriter(sr));
                this.window.showMessageDialog("Exception Error", sr.toString(), 0);
                return;
            }
        }
    }

    @Override
    public void hideAll() {
        this.windowManager.hideAll();
    }

    private void openingFrame(MultiWindowFrame multiwindowframe) {
        SBModelFrame modelframe = (SBModelFrame)multiwindowframe;
        this.mainwindowaccess.addPanelToTabbedPane(multiwindowframe);
        multiwindowframe.setMainWindowAccess(this.mainwindowaccess);
        this.fireListeners(1, multiwindowframe);
        this.windowManager.modelOpened(multiwindowframe);
    }

    @Override
    public JPanel getCurrentModel() {
        return this.mainwindowaccess.getCurrentModel();
    }

    @Override
    public Vector getModels() {
        return this.mainwindowaccess.getModels();
    }

    public void closeModelByTab(MultiWindowFrame model) {
        try {
            this.getCloseCommand(model, true, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMainWindowAccess(MainWindowAccess access) {
        this.mainwindowaccess = access;
    }

    @Override
    public void changeActiveModel(String panelstring) {
        this.mainwindowaccess.changeActiveModel(panelstring);
    }

    public void getCloseAllCommand(boolean bool, boolean msgflg) throws Exception {
        SBModelFrame model;
        while ((model = this.mainwindowaccess.getCurrentModel()) != null) {
            this.getCloseCommand(model, bool, msgflg);
        }
    }

    @Override
    public void resumeAll() {
    }

    @Override
    public boolean closeAllDocuments() {
        return false;
    }

    public void setSaveEnabled(boolean isSaveEnabled) {
        this.isSaveEnabled = isSaveEnabled;
    }

    public void saveXmlFile(MultiWindowFrame multiwindowframe, File file, boolean validation) throws Exception {
        block6: {
            if (multiwindowframe != null && file != null && this.filer != null) {
                boolean validationFlag = ((SBMLFiler)this.filer).isValidationEnabled();
                try {
                    ((SBMLFiler)this.filer).setValidationEnabled(validation);
                    this.filer.write(file, multiwindowframe);
                    break block6;
                }
                finally {
                    ((SBMLFiler)this.filer).setValidationEnabled(validationFlag);
                }
            }
            throw new Exception();
        }
    }

    public MultiWindowFrame openXmlFile(File file, int currentViewType, boolean validation, boolean inProcessPluginOpenNewModelCmd, boolean addtoRecentFiles) throws Exception {
        if (file != null && this.filer != null) {
            boolean validationFlag = ((SBMLFiler)this.filer).isValidationEnabled();
            try {
                ((SBMLFiler)this.filer).setValidationEnabled(validation);
                MultiWindowFrame multiWindowFrame = this.getOpenCommand(file, currentViewType, inProcessPluginOpenNewModelCmd, addtoRecentFiles);
                return multiWindowFrame;
            }
            catch (Exception myErr) {
                throw myErr;
            }
            finally {
                ((SBMLFiler)this.filer).setValidationEnabled(validationFlag);
            }
        }
        throw new Exception();
    }
}

