/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import jp.fric.graphics.draw.GColoredShape;
import jp.fric.graphics.draw.GFramedShape;
import jp.fric.graphics.draw.GLinkPositionInfo;
import jp.fric.graphics.draw.GUtil;
import jp.fric.graphics.draw.PaintScheme;
import jp.fric.graphics.draw.ShapeUtil;
import jp.sbi.celldesigner.ComplexProperty;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.NameImage;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBSymbol;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.SpeciesShape;
import jp.sbi.celldesigner.SpeciesShapePainting;
import jp.sbi.celldesigner.SpeciesSymbol;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNA;
import jp.sbi.celldesigner.sbmlExtension.BindingRegion;
import jp.sbi.celldesigner.sbmlExtension.Gene;
import jp.sbi.celldesigner.sbmlExtension.GenePanel;
import jp.sbi.celldesigner.sbmlExtension.Modification;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegion;
import jp.sbi.celldesigner.sbmlExtension.ModificationResidue;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.SameIDAutoTag;
import jp.sbi.celldesigner.sbmlExtension.StructuralState;
import jp.sbi.celldesigner.symbol.color.SpeciesColorScheme;
import jp.sbi.celldesigner.symbol.species.Complex;
import jp.sbi.celldesigner.symbol.species.Degraded;
import jp.sbi.celldesigner.symbol.species.GeneralBrief;
import jp.sbi.celldesigner.symbol.species.IonChannel;
import jp.sbi.celldesigner.symbol.species.RNA;
import jp.sbi.celldesigner.symbol.species.SpeciesSymbolImpl;
import jp.sbi.celldesigner.symbol.species.Tag;

public class MonoSpeciesShape
implements GFramedShape,
GColoredShape,
SpeciesShape {
    private MonoSpeciesProperty property = null;
    private boolean isActive = false;
    protected int showLinkAnchorMode = 0;
    protected GLinkPositionInfo linkPositionInfo = null;
    private Color color = new Color(0, 0, 0);
    private Stroke stroke = new BasicStroke(1.0f, 0, 1);
    public static final Color residueColor = Color.BLACK;
    public static final Stroke residueStroke = new BasicStroke(1.0f, 0, 2);
    private PaintScheme painter = null;
    private NameImage nameImage = new NameImage();
    private SpeciesSymbol symbol = null;
    private Protein protein = null;
    private Gene gene = null;
    private jp.sbi.celldesigner.sbmlExtension.RNA rna = null;
    private AntiSenseRNA asrna = null;
    private Vector mShapes = null;
    private ModificationShape selectedModificationResidueShape = null;
    private static final double HO = 6.0;
    private Rectangle2D.Double frameBounds = null;
    private Rectangle2D.Double repaintBounds = null;
    private Dimension nameImageSize = null;
    private Rectangle2D.Double nameImageBounds = null;
    private static float[] PATTERN_HYPOTHETICAL = new float[]{6.0f, 3.0f};
    private boolean drawFlg = true;
    private static BasicStroke STROKE_HYPOTHETICAL = new BasicStroke(1.0f, 0, 0, 10.0f, PATTERN_HYPOTHETICAL, 0.0f);
    private int currentView = 0;
    private static HashSet viewSet = null;
    private HashMap symbolReservoir = new HashMap();
    private HashMap strokeReservoir = new HashMap();
    private HashMap colorReservoir = new HashMap();
    private HashMap painterReservoir = new HashMap();
    private SameIDAutoTag autotag = new SameIDAutoTag();
    private double structuralStateAngle = 1.5707963267948966;
    private StructuralState activedStateShowOnlyInSBGNViewer = new StructuralState("Active", 4.71238898038469, true);
    private ModificationShape activedStatemShapeShowOnlyInSBGNViewer = new ModificationShape();
    public static String[] typesSBGN;

    static {
        viewSet = new HashSet();
        viewSet.add(new Integer(0));
        viewSet.add(new Integer(1));
        typesSBGN = new String[]{"CodingRegion", "RegulatoryRegion", "proteinBindingDomain", "transcriptionStartingSiteL", "transcriptionStartingSiteR", "Modification Site"};
    }

    public MonoSpeciesShape() {
        MonoSpeciesProperty property = new MonoSpeciesProperty();
        this.setProperty(property);
    }

    public MonoSpeciesShape(String type) {
        MonoSpeciesProperty property = new MonoSpeciesProperty();
        if (type.equals("COMPLEX") || type.equals("COMPLEX_PACKED")) {
            property = new ComplexProperty();
        }
        property.setType(type);
        this.setProperty(property);
        this.buildPaintingsForType(type);
        this.buildShape();
        this.changeView(new Integer(0));
    }

    public SpeciesSymbol getSpeciesSymbol() {
        return this.symbol;
    }

    public void buildPaintingsForType(String type) {
        Integer uInt = new Integer(0);
        this.colorReservoir.put(uInt, SpeciesColorScheme.getColor(type));
        BasicStroke st = new BasicStroke((float)SpeciesColorScheme.getLineWidth(type), 0, 1);
        this.strokeReservoir.put(uInt, st);
        this.painterReservoir.put(uInt, SpeciesColorScheme.getScheme(type));
        String briefType = SBFactory.getBriefViewType(type);
        Integer bInt = new Integer(1);
        this.colorReservoir.put(bInt, SpeciesColorScheme.getColor(briefType));
        BasicStroke bst = new BasicStroke((float)SpeciesColorScheme.getLineWidth(briefType), 0, 1);
        this.strokeReservoir.put(bInt, bst);
        this.painterReservoir.put(bInt, SpeciesColorScheme.getScheme(briefType));
    }

    private void buildShape() {
        Integer uInt = new Integer(0);
        Integer bInt = new Integer(1);
        String type = this.property.getType();
        String briefType = SBFactory.getBriefViewType(type);
        this.symbolReservoir.put(uInt, SBFactory.createSymbol(type));
        this.symbolReservoir.put(bInt, SBFactory.createSymbol(briefType));
    }

    private void rebuildShape() {
        Vector modifications;
        int i;
        String type;
        Integer viewInt = new Integer(this.currentView);
        if (this.property == null) {
            return;
        }
        String normalType = type = this.property.getType();
        if (type.equals("PROTEIN")) {
            this.protein = this.property.getProtein();
            if (this.protein == null) {
                return;
            }
            type = this.protein.getType();
        }
        if (type.equals("GENE")) {
            this.gene = this.property.getGene();
            if (this.gene == null) {
                return;
            }
            type = this.gene.getType();
        }
        if (type.equals("RNA")) {
            this.rna = this.property.getRNA();
            if (this.rna == null) {
                return;
            }
            type = this.rna.getType();
        }
        if (type.equals("ANTISENSE_RNA")) {
            this.asrna = this.property.getAntiSenseRNA();
            if (this.asrna == null) {
                return;
            }
            type = this.asrna.getType();
        }
        if (this.currentView == 1) {
            type = SBFactory.getBriefViewType(type);
        }
        if (this.painter == null) {
            if (Preference.isDebug) {
                System.err.println("MonoSpeciesShape.rebuildShape() painter==null; " + this.property.getType() + " " + this);
            }
            this.painter = SpeciesColorScheme.getScheme(type);
            this.painter.setColor(this.color);
            this.painter.setStroke(this.stroke);
            this.painterReservoir.put(viewInt, this.painter);
        }
        this.symbol = (SpeciesSymbol)((Object)SBFactory.createSymbol(type));
        this.symbol.setPaintScheme(this.painter);
        this.symbolReservoir.put(viewInt, this.symbol);
        String code = ((SBSymbol)((Object)this.symbol)).getCode();
        if ("COMPLEX".equals(code) || "COMPLEX_PACKED".equals(code)) {
            this.mShapes = new Vector();
            ModificationShape tagShape = new ModificationShape();
            tagShape.setSpeciesSymbol(this.symbol);
            tagShape.setSameIDAutoTag(this.autotag);
            this.mShapes.add(tagShape);
            Vector structuralStates = this.property.getStructuralStates();
            if (structuralStates != null && structuralStates.size() > 0) {
                i = 0;
                while (i < structuralStates.size()) {
                    StructuralState structuralState = new StructuralState();
                    structuralState.setState(((StructuralState)structuralStates.elementAt(i)).getState());
                    structuralState.setAngle(this.structuralStateAngle);
                    ModificationShape mShape = new ModificationShape();
                    mShape.setSpeciesSymbol(this.symbol);
                    mShape.setStructuralState(structuralState);
                    this.mShapes.add(mShape);
                    ++i;
                }
            }
        }
        if (!(this.symbol.isProtein() || this.symbol.isGene() || this.symbol.isRNA() || this.symbol.isAntiSenseRNA() || "PROTEIN".equals(normalType) || "GENE".equals(normalType) || "RNA".equals(normalType) || "ANTISENSE_RNA".equals(normalType))) {
            return;
        }
        if (this.symbol.isProtein() || "PROTEIN".equals(normalType)) {
            ModificationShape mShape;
            Vector residues = this.protein.getListOfModificationResidues();
            modifications = this.property.getModifications();
            this.mShapes = new Vector();
            ModificationShape tagShape = new ModificationShape();
            tagShape.setSpeciesSymbol(this.symbol);
            tagShape.setSameIDAutoTag(this.autotag);
            this.mShapes.add(tagShape);
            int i2 = 0;
            while (i2 < residues.size()) {
                ModificationResidue residue = (ModificationResidue)residues.get(i2);
                String residueId = residue.getId();
                Modification m = null;
                int k = 0;
                while (k < modifications.size()) {
                    Modification modification = (Modification)modifications.elementAt(k);
                    if (modification.getResidue().equals(residueId)) {
                        m = modification;
                        break;
                    }
                    ++k;
                }
                if (m == null) {
                    m = new Modification();
                }
                mShape = new ModificationShape();
                mShape.setSpeciesSymbol(this.symbol);
                mShape.setModificationResidue(residue);
                mShape.setModification(m);
                this.mShapes.add(mShape);
                ++i2;
            }
            Vector bindingRegiones = this.protein.getListOfBindingRegiones();
            int i3 = 0;
            while (i3 < bindingRegiones.size()) {
                BindingRegion bindingRegion = (BindingRegion)bindingRegiones.get(i3);
                String bindingRegionId = bindingRegion.getId();
                Modification m = null;
                int k = 0;
                while (k < modifications.size()) {
                    Modification modification = (Modification)modifications.elementAt(k);
                    if (modification.getBindingRegion().equals(bindingRegionId)) {
                        m = modification;
                        break;
                    }
                    ++k;
                }
                if (m == null) {
                    m = new Modification();
                }
                ModificationShape mShape2 = new ModificationShape();
                mShape2.setSpeciesSymbol(this.symbol);
                mShape2.setBindingRegion(bindingRegion);
                mShape2.setModification(m);
                this.mShapes.add(mShape2);
                ++i3;
            }
            Vector structuralStates = this.property.getStructuralStates();
            int i4 = 0;
            while (i4 < structuralStates.size()) {
                StructuralState structuralState = new StructuralState();
                structuralState.setState(((StructuralState)structuralStates.elementAt(i4)).getState());
                structuralState.setAngle(this.structuralStateAngle);
                mShape = new ModificationShape();
                mShape.setSpeciesSymbol(this.symbol);
                mShape.setStructuralState(structuralState);
                this.mShapes.add(mShape);
                ++i4;
            }
        } else {
            Vector regions = null;
            if (this.symbol.isGene() || "GENE".equals(normalType)) {
                regions = this.gene.getListOfRegions();
            } else if (this.symbol.isRNA() || "RNA".equals(normalType)) {
                regions = this.rna.getListOfRegions();
            } else if (this.symbol.isAntiSenseRNA() || "ANTISENSE_RNA".equals(normalType)) {
                regions = this.asrna.getListOfRegions();
            }
            modifications = this.property.getModifications();
            this.mShapes = new Vector();
            i = 0;
            while (i < regions.size()) {
                ModificationRegion region = (ModificationRegion)regions.get(i);
                String regionId = region.getId();
                Modification m = null;
                int k = 0;
                while (k < modifications.size()) {
                    Modification modification = (Modification)modifications.elementAt(k);
                    if (modification.getResidue().equals(regionId)) {
                        m = modification;
                        break;
                    }
                    ++k;
                }
                if (m == null) {
                    m = new Modification();
                }
                ModificationShape mShape = new ModificationShape();
                mShape.setSpeciesSymbol(this.symbol);
                mShape.setModificationRegion(region);
                mShape.setModification(m);
                this.mShapes.add(mShape);
                ++i;
            }
        }
    }

    @Override
    public Rectangle2D.Double setProperty(SpeciesProperty property) {
        if (property instanceof MonoSpeciesProperty) {
            String sMonoDirect = "";
            boolean isTag = false;
            if (property != null && ((MonoSpeciesProperty)property).type.equals("TAG")) {
                isTag = true;
                sMonoDirect = ((MonoSpeciesProperty)property).getMonoDirect();
            }
            MonoSpeciesProperty oldProperty = this.property;
            this.property = (MonoSpeciesProperty)property;
            this.resetShape();
            if (oldProperty != null && !oldProperty.getName().equals(this.property.getName())) {
                this.nameImageBounds = null;
                this.nameImageSize = null;
            }
            int oldHomodimer = 1;
            if (oldProperty != null) {
                oldHomodimer = oldProperty.getHomodimer();
            }
            int newHomodimer = this.property.getHomodimer();
            if ("COMPLEX".equals(this.property.type) || "COMPLEX_PACKED".equals(this.property.type)) {
                this.buildShape();
            }
            if (isTag) {
                try {
                    if (this.symbol != null && this.symbol instanceof Tag) {
                        if (this.frameBounds != null) {
                            ((Tag)this.symbol).resetSymbolBounds(this.frameBounds.x, this.frameBounds.y, this.frameBounds.width, this.frameBounds.height, sMonoDirect);
                        } else {
                            ((Tag)this.symbol).resetSymbolBounds(0.0, 0.0, 0.0, 0.0, sMonoDirect);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.frameBounds == null) {
                return null;
            }
            double dw = 6.0 * (double)(newHomodimer - oldHomodimer);
            return new Rectangle2D.Double(this.frameBounds.x, this.frameBounds.y, this.frameBounds.width + dw, this.frameBounds.height + dw);
        }
        return null;
    }

    @Override
    public SpeciesProperty getProperty() {
        return this.property;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public SpeciesShape duplicate() {
        MonoSpeciesShape mono = new MonoSpeciesShape();
        this.copyReservoirsTo(mono);
        mono.changePaintingsForView(new Integer(this.currentView));
        String sMonoDirect = "";
        boolean isTag = false;
        if (this.symbol != null && this.symbol instanceof Tag) {
            isTag = true;
            sMonoDirect = ((Tag)this.symbol).getTagDirect();
            if (!(this.property == null || this.property.getMonoDirect() != null && this.property.getMonoDirect().equals(sMonoDirect))) {
                this.property.setMonoDirect(new Tag(), sMonoDirect);
            }
        } else if (this.property != null && this.property.type.equals("TAG")) {
            isTag = true;
            sMonoDirect = this.property.getMonoDirect();
        }
        mono.setProperty(this.property.deepClone());
        if (isTag) {
            try {
                if (mono.symbol != null && mono.symbol instanceof Tag) {
                    if (this.frameBounds != null) {
                        ((Tag)mono.symbol).resetSymbolBounds(this.frameBounds.x, this.frameBounds.y, this.frameBounds.width, this.frameBounds.height, sMonoDirect);
                    } else {
                        ((Tag)mono.symbol).resetSymbolBounds(0.0, 0.0, 0.0, 0.0, sMonoDirect);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.symbol != null && ((SpeciesSymbolImpl)this.symbol).isInSBGNViewer() && mono.symbol == null) {
            mono.rebuildShape();
            ((SpeciesSymbolImpl)mono.symbol).setIsInSBGNViewer(((SpeciesSymbolImpl)this.symbol).isInSBGNViewer());
        }
        mono.getSameIDAutoTag().setAngle(this.autotag.getAngle());
        mono.setStructuralStateAngle(this.structuralStateAngle);
        if (this.nameImage != null) {
            mono.setNameFontSize(this.nameImage.getNameFontSize());
        }
        return mono;
    }

    @Override
    public Rectangle2D.Double getRepaintBounds() {
        if (this.symbol != null && this.symbol instanceof SpeciesSymbolImpl && ((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
            return GUtil.union(this.repaintBounds, this.updateActivedStatemShapeShowOnlyInSBGNViewer());
        }
        return this.repaintBounds;
    }

    @Override
    public Rectangle2D.Double getFrameBounds() {
        return this.frameBounds;
    }

    @Override
    public void resetShape() {
        String sMonoDirect = "";
        boolean isTag = false;
        if (this.symbol != null && this.symbol instanceof Tag) {
            isTag = true;
            sMonoDirect = ((Tag)this.symbol).getTagDirect();
            if (!(this.property == null || this.property.getMonoDirect() != null && this.property.getMonoDirect().equals(sMonoDirect))) {
                this.property.setMonoDirect(new Tag(), sMonoDirect);
            }
        } else if (this.property != null && this.property.type.equals("TAG")) {
            isTag = true;
            sMonoDirect = this.property.getMonoDirect();
        }
        SpeciesSymbol oldsymbol = this.symbol;
        this.symbol = null;
        this.symbolReservoir.put(new Integer(this.currentView), this.symbol);
        this.mShapes = null;
        if (this.frameBounds != null) {
            this.updateShape(this.frameBounds.x, this.frameBounds.y, this.frameBounds.width, this.frameBounds.height);
        }
        try {
            this.setSymbolUserSpecifiedColorFormOtherSymbolView(this.symbol, oldsymbol);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isTag) {
            try {
                if (this.symbol != null && this.symbol instanceof Tag) {
                    if (this.frameBounds != null) {
                        ((Tag)this.symbol).resetSymbolBounds(this.frameBounds.x, this.frameBounds.y, this.frameBounds.width, this.frameBounds.height, sMonoDirect);
                    } else {
                        ((Tag)this.symbol).resetSymbolBounds(0.0, 0.0, 0.0, 0.0, sMonoDirect);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Point2D.Double[] getEdgePoints() {
        if (this.symbol == null) {
            return null;
        }
        return this.symbol.getEdgePoints();
    }

    @Override
    public boolean inShape(double x, double y) {
        boolean isIn;
        int i;
        ModificationShape mShape;
        int k;
        this.selectedModificationResidueShape = null;
        if (this.property == null || this.symbol == null) {
            return false;
        }
        int homodimer = this.property.getHomodimer();
        if (this.symbol.isProtein() && this.mShapes != null) {
            k = this.mShapes.size() - 1;
            while (k >= 0) {
                mShape = (ModificationShape)this.mShapes.elementAt(k);
                i = 0;
                while (i < homodimer) {
                    isIn = mShape.inShape(x - (double)i * 6.0, y - (double)i * 6.0);
                    if (isIn) {
                        if (i == 0 && mShape.getModificationResidue() != null) {
                            this.selectedModificationResidueShape = mShape;
                        }
                        return true;
                    }
                    ++i;
                }
                --k;
            }
        }
        if (((SpeciesSymbolImpl)this.symbol).isInSBGNViewer() && (this.symbol.isGene() || this.symbol.isRNA() || this.symbol.isAntiSenseRNA()) && this.mShapes != null) {
            k = this.mShapes.size() - 1;
            while (k >= 0) {
                mShape = (ModificationShape)this.mShapes.elementAt(k);
                i = 0;
                while (i < homodimer) {
                    isIn = mShape.inShape(x - (double)i * 6.0, y - (double)i * 6.0);
                    if (isIn) {
                        return true;
                    }
                    ++i;
                }
                --k;
            }
        }
        int i2 = 0;
        while (i2 < homodimer) {
            boolean isIn2 = this.symbol.inShape(x - (double)i2 * 6.0, y - (double)i2 * 6.0, this.isActive);
            if (isIn2) {
                return true;
            }
            ++i2;
        }
        String code = ((SBSymbol)((Object)this.symbol)).getCode();
        if (("COMPLEX".equals(code) || "COMPLEX_PACKED".equals(code)) && this.mShapes != null) {
            int k2 = 0;
            while (k2 < this.mShapes.size()) {
                ModificationShape mShape2 = (ModificationShape)this.mShapes.elementAt(k2);
                int i3 = 0;
                while (i3 < homodimer) {
                    boolean isIn3 = mShape2.inShape(x - (double)i3 * 6.0, y - (double)i3 * 6.0);
                    if (isIn3) {
                        return true;
                    }
                    ++i3;
                }
                ++k2;
            }
        }
        return false;
    }

    public Vector getMShapes() {
        return this.mShapes;
    }

    public ModificationShape getSelectedModificationResidueShape() {
        return this.selectedModificationResidueShape;
    }

    public void resetNameImageSize() {
        this.nameImageSize = null;
        this.symbol = null;
    }

    @Override
    public Rectangle2D.Double updateShape(double x, double y, double w, double h) {
        ModificationShape mShape;
        String code;
        String code2;
        if (this.property == null) {
            return null;
        }
        String sMonoDirect = "";
        boolean isTag = false;
        if (this.symbol != null && this.symbol instanceof Tag) {
            isTag = true;
            sMonoDirect = ((Tag)this.symbol).getTagDirect();
        } else if (this.property.type.equals("TAG")) {
            isTag = true;
            sMonoDirect = this.property.getMonoDirect();
        }
        if (this.symbol == null || this.mShapes == null && (this.symbol.isProtein() && this.protein != null || this.symbol.isGene() && this.gene != null || this.symbol.isRNA() && this.rna != null || this.symbol.isAntiSenseRNA() && this.asrna != null)) {
            this.rebuildShape();
        }
        if (this.symbol == null) {
            return null;
        }
        if (isTag) {
            try {
                if (this.symbol != null && this.symbol instanceof Tag) {
                    if (this.frameBounds != null) {
                        ((Tag)this.symbol).resetSymbolBounds(this.frameBounds.x, this.frameBounds.y, this.frameBounds.width, this.frameBounds.height, sMonoDirect);
                    } else {
                        ((Tag)this.symbol).resetSymbolBounds(x, y, w, h, sMonoDirect);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (("COMPLEX".equals(code2 = ((SBSymbol)((Object)this.symbol)).getCode()) || "COMPLEX_PACKED".equals(code2)) && this.mShapes == null) {
            this.rebuildShape();
        }
        if (this.symbol != null && this.symbol instanceof IonChannel) {
            ((IonChannel)this.symbol).setOpen(this.isActive);
        }
        int homodimer = this.property.getHomodimer();
        this.frameBounds = new Rectangle2D.Double(x, y, w, h);
        Rectangle2D.Double symbolBounds = this.createSymbolBounds(x, y, w, h, homodimer);
        this.symbol.setSymbolBounds(symbolBounds.x, symbolBounds.y, symbolBounds.width, symbolBounds.height);
        String name = "";
        name = this.symbol.isProtein() && this.protein != null ? this.protein.getName() : (this.symbol.isGene() && this.gene != null ? this.gene.getName() : (this.symbol.isRNA() && this.rna != null ? this.rna.getName() : (this.symbol.isAntiSenseRNA() && this.asrna != null ? this.asrna.getName() : this.property.getName())));
        this.nameImage.setString(name);
        this.nameImageSize = this.nameImage.getNameImageSize();
        if (this.nameImageSize != null && symbolBounds != null) {
            this.nameImageBounds = this.symbol instanceof IonChannel ? this.createLabelBounds(((IonChannel)this.symbol).getLeftBounds(), this.nameImageSize) : this.createLabelBounds(symbolBounds, this.nameImageSize);
        }
        if (this.symbol.isProtein() && this.mShapes != null) {
            int i = 0;
            while (i < this.mShapes.size()) {
                ModificationShape mShape2 = (ModificationShape)this.mShapes.elementAt(i);
                mShape2.setSpeciesSymbol(this.symbol);
                if (mShape2.getStructuralState() != null) {
                    mShape2.getStructuralState().setAngle(this.structuralStateAngle);
                }
                mShape2.updateCircleBounds();
                ++i;
            }
        }
        if (("COMPLEX".equals(code = ((SBSymbol)((Object)this.symbol)).getCode()) || "COMPLEX_PACKED".equals(code)) && this.mShapes != null) {
            int i = 0;
            while (i < this.mShapes.size()) {
                mShape = (ModificationShape)this.mShapes.elementAt(i);
                mShape.setSpeciesSymbol(this.symbol);
                if (mShape.getStructuralState() != null) {
                    mShape.getStructuralState().setAngle(this.structuralStateAngle);
                }
                mShape.updateCircleBounds();
                ++i;
            }
        }
        if ((this.symbol.isGene() || this.symbol.isRNA() || this.symbol.isAntiSenseRNA()) && this.mShapes != null) {
            int i = 0;
            while (i < this.mShapes.size()) {
                mShape = (ModificationShape)this.mShapes.elementAt(i);
                mShape.setSpeciesSymbol(this.symbol);
                mShape.updateCircleBounds();
                ++i;
            }
        }
        this.repaintBounds = symbolBounds;
        if (this.symbol.isActivable() && this.isActive) {
            this.repaintBounds = GUtil.union(this.repaintBounds, this.symbol.getActiveSymbolBounds());
        }
        if (this.symbol.isProtein() && this.mShapes != null) {
            int i = 0;
            while (i < this.mShapes.size()) {
                mShape = (ModificationShape)this.mShapes.elementAt(i);
                if (mShape.getSameIDAutoTag() != null) {
                    mShape.setSpeciesSymbol(this.symbol);
                    this.repaintBounds = GUtil.union(this.repaintBounds, mShape.rebulidTagShape());
                } else {
                    this.repaintBounds = GUtil.union(this.repaintBounds, mShape.getCircleBounds());
                    this.repaintBounds = GUtil.union(this.repaintBounds, mShape.getNameBounds(this.nameImageBounds));
                }
                ++i;
            }
        }
        if (("COMPLEX".equals(code = ((SBSymbol)((Object)this.symbol)).getCode()) || "COMPLEX_PACKED".equals(code)) && this.mShapes != null) {
            int i = 0;
            while (i < this.mShapes.size()) {
                mShape = (ModificationShape)this.mShapes.elementAt(i);
                if (mShape.getSameIDAutoTag() != null) {
                    mShape.setSpeciesSymbol(this.symbol);
                    this.repaintBounds = GUtil.union(this.repaintBounds, mShape.rebulidTagShape());
                } else {
                    this.repaintBounds = GUtil.union(this.repaintBounds, mShape.getCircleBounds());
                    this.repaintBounds = GUtil.union(this.repaintBounds, mShape.getNameBounds(this.nameImageBounds));
                }
                ++i;
            }
        }
        if ((this.symbol.isGene() || this.symbol.isRNA() || this.symbol.isAntiSenseRNA()) && this.mShapes != null) {
            int i = 0;
            while (i < this.mShapes.size()) {
                mShape = (ModificationShape)this.mShapes.elementAt(i);
                this.repaintBounds = GUtil.union(this.repaintBounds, mShape.getCircleBounds());
                this.repaintBounds = GUtil.union(this.repaintBounds, mShape.getNameBounds(this.nameImageBounds));
                ++i;
            }
        }
        this.repaintBounds = (Rectangle2D.Double)this.getRepaintBounds().clone();
        int i = 1;
        while (i < homodimer) {
            this.repaintBounds.width += 6.0;
            this.repaintBounds.height += 6.0;
            ++i;
        }
        int linewidth = 2 + (int)((BasicStroke)this.stroke).getLineWidth();
        this.repaintBounds.x -= (double)(linewidth /= 2);
        this.repaintBounds.y -= (double)linewidth;
        this.repaintBounds.width += (double)(2 * linewidth);
        this.repaintBounds.height += (double)(2 * linewidth);
        if (this.nameImageBounds != null) {
            this.repaintBounds = GUtil.union(this.repaintBounds, this.nameImageBounds);
        }
        return (Rectangle2D.Double)this.repaintBounds.clone();
    }

    private Rectangle2D.Double createSymbolBounds(double x, double y, double w, double h, int homodimer) {
        return new Rectangle2D.Double(x, y, w - (double)(homodimer - 1) * 6.0, h - (double)(homodimer - 1) * 6.0);
    }

    private Rectangle2D.Double createLabelBounds(Rectangle2D.Double targetBounds, Dimension labelSize) {
        if (this.symbol == null) {
            return null;
        }
        double x = targetBounds.x + (targetBounds.width - (double)labelSize.width) / 2.0;
        double y = 0.0;
        y = this.symbol instanceof Complex ? targetBounds.y + targetBounds.height - (double)labelSize.height : targetBounds.y + (targetBounds.height - (double)labelSize.height) / 2.0;
        return new Rectangle2D.Double(x, y, labelSize.width, labelSize.height);
    }

    protected Rectangle2D.Double getActiveShapeBounds() {
        ModificationShape mShape;
        String code;
        if (this.property == null || this.symbol == null) {
            return null;
        }
        int homodimer = this.property.getHomodimer();
        Rectangle2D.Double activeBounds = this.symbol.getActiveSymbolBounds();
        if (this.symbol.isProtein()) {
            int i = 0;
            while (i < this.mShapes.size()) {
                ModificationShape mShape2 = (ModificationShape)this.mShapes.elementAt(i);
                activeBounds = GUtil.union(activeBounds, mShape2.getCircleBounds());
                ++i;
            }
        }
        if (("COMPLEX".equals(code = ((SBSymbol)((Object)this.symbol)).getCode()) || "COMPLEX_PACKED".equals(code)) && this.mShapes != null) {
            int i = 0;
            while (i < this.mShapes.size()) {
                mShape = (ModificationShape)this.mShapes.elementAt(i);
                activeBounds = GUtil.union(activeBounds, mShape.getCircleBounds());
                ++i;
            }
        }
        if (this.symbol.isGene() || this.symbol.isRNA() || this.symbol.isAntiSenseRNA()) {
            int i = 0;
            while (i < this.mShapes.size()) {
                mShape = (ModificationShape)this.mShapes.elementAt(i);
                activeBounds = GUtil.union(activeBounds, mShape.getCircleBounds());
                ++i;
            }
        }
        int i = 1;
        while (i < homodimer) {
            activeBounds.width += 6.0;
            activeBounds.height += 6.0;
            ++i;
        }
        return activeBounds;
    }

    @Override
    public void drawShape(Graphics2D g2, int colorflg) {
        if (this.property == null || this.symbol == null) {
            return;
        }
        if (this.isActive && !(this.symbol instanceof IonChannel)) {
            g2.setStroke(STROKE_ACTIVE);
            g2.setColor(Color.BLACK);
            this.drawActiveEdge(g2);
            g2.setColor(Color.white);
            this.fillActiveEdge(g2);
        }
        this.drawInner(g2, colorflg);
        if (this.showLinkAnchorMode != 0) {
            boolean drawOnlyActive = this.showLinkAnchorMode == 2;
            this.drawLinkAnchors(g2, drawOnlyActive);
        }
    }

    public void drawShape(Graphics2D g2, int colorflg, boolean drawFlg) {
        this.drawFlg = drawFlg;
        this.drawShape(g2, colorflg);
    }

    protected Point2D.Double[] setupLinkAnchorCoord() {
        return this.symbol.setupLinkAnchorCoord();
    }

    protected void drawLinkAnchors(Graphics2D g2, GLinkPositionInfo lpi, boolean drawOnlyActive) {
        if (this.symbol != null) {
            this.symbol.drawLinkAnchors(g2, lpi, drawOnlyActive);
        }
    }

    private void drawLinkAnchors(Graphics2D g2, boolean drawOnlyActive) {
        this.drawLinkAnchors(g2, this.linkPositionInfo, drawOnlyActive);
    }

    protected void drawActiveEdge(Graphics2D g2) {
        if (this.property == null || this.symbol == null) {
            return;
        }
        int homodimer = this.property.getHomodimer();
        int i = homodimer - 1;
        while (i >= 0) {
            g2.translate((double)i * 6.0, (double)i * 6.0);
            this.symbol.drawActiveEdge(g2);
            g2.translate((double)(-i) * 6.0, (double)(-i) * 6.0);
            --i;
        }
    }

    protected void fillActiveEdge(Graphics2D g2) {
        if (this.property == null || this.symbol == null) {
            return;
        }
        int homodimer = this.property.getHomodimer();
        int i = homodimer - 1;
        while (i >= 0) {
            g2.translate((double)i * 6.0, (double)i * 6.0);
            this.symbol.fillActiveEdge(g2);
            g2.translate((double)(-i) * 6.0, (double)(-i) * 6.0);
            --i;
        }
    }

    protected void drawInner(Graphics2D g2, int colorflg) {
        if (this.property == null || this.symbol == null) {
            return;
        }
        boolean isHypothetical = this.property.getHypothetical();
        int homodimer = this.property.getHomodimer();
        int i = homodimer - 1;
        while (i >= 0) {
            ModificationShape mShape;
            String code;
            g2.translate((double)i * 6.0, (double)i * 6.0);
            if (isHypothetical) {
                this.painter.setStroke(this.getHypotheticalStroke());
            }
            this.symbol.drawInner(g2, colorflg);
            if (isHypothetical) {
                this.painter.setStroke(this.stroke);
            }
            if (this.symbol.isProtein() && this.mShapes != null) {
                g2.setColor(residueColor);
                g2.setStroke(residueStroke);
                int k = 0;
                while (k < this.mShapes.size()) {
                    ModificationShape mShape2 = (ModificationShape)this.mShapes.elementAt(k);
                    if (mShape2.isSoloHighlighted() && i > 0) {
                        mShape2.setSoloHighlighted(false);
                        mShape2.draw(g2);
                        mShape2.setSoloHighlighted(true);
                    } else {
                        mShape2.draw(g2);
                    }
                    ++k;
                }
            }
            if (("COMPLEX".equals(code = ((SBSymbol)((Object)this.symbol)).getCode()) || "COMPLEX_PACKED".equals(code)) && this.mShapes != null && this.drawFlg) {
                g2.setColor(residueColor);
                g2.setStroke(residueStroke);
                int k = 0;
                while (k < this.mShapes.size()) {
                    mShape = (ModificationShape)this.mShapes.elementAt(k);
                    mShape.draw(g2);
                    ++k;
                }
            }
            if (this.symbol.isGene() && this.mShapes != null) {
                g2.setColor(residueColor);
                g2.setStroke(residueStroke);
                if (((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
                    GenePanel.sortModificationShapes(typesSBGN, this.mShapes);
                } else {
                    GenePanel.sortModificationShapes(this.mShapes);
                }
                int k = 0;
                while (k < this.mShapes.size()) {
                    mShape = (ModificationShape)this.mShapes.elementAt(k);
                    if (mShape.getSameIDAutoTag() == null) {
                        mShape.draw(g2);
                    }
                    ++k;
                }
            }
            if (this.symbol.isRNA() && this.mShapes != null && !((RNA)this.symbol).symbolBoundsIsNG()) {
                g2.setColor(residueColor);
                g2.setStroke(residueStroke);
                if (((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
                    GenePanel.sortModificationShapes(typesSBGN, this.mShapes);
                }
                int k = 0;
                while (k < this.mShapes.size()) {
                    mShape = (ModificationShape)this.mShapes.elementAt(k);
                    if (mShape.getSameIDAutoTag() == null) {
                        mShape.draw(g2);
                    }
                    ++k;
                }
            }
            if (this.symbol.isAntiSenseRNA() && this.mShapes != null && !((jp.sbi.celldesigner.symbol.species.AntiSenseRNA)this.symbol).symbolBoundsIsNG()) {
                g2.setColor(residueColor);
                g2.setStroke(residueStroke);
                if (((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
                    GenePanel.sortModificationShapes(typesSBGN, this.mShapes);
                }
                int k = 0;
                while (k < this.mShapes.size()) {
                    mShape = (ModificationShape)this.mShapes.elementAt(k);
                    if (mShape.getSameIDAutoTag() == null) {
                        mShape.draw(g2);
                    }
                    ++k;
                }
            }
            if (this.symbol instanceof SpeciesSymbolImpl && this.isActive && ((SpeciesSymbolImpl)this.symbol).isInSBGNViewer()) {
                this.getActivedStatemShapeShowOnlyInSBGNViewer().draw(g2);
            }
            g2.translate((double)(-i) * 6.0, (double)(-i) * 6.0);
            --i;
        }
        if (this.symbol instanceof GeneralBrief) {
            return;
        }
        if (this.nameImageSize == null || this.nameImage.getString().length() == 0) {
            String name = "";
            name = this.symbol.isProtein() && this.protein != null ? this.protein.getName() : this.property.getName();
            name = this.symbol.isGene() && this.gene != null ? this.gene.getName() : this.property.getName();
            name = this.symbol.isRNA() && this.rna != null ? this.rna.getName() : this.property.getName();
            name = this.symbol.isAntiSenseRNA() && this.asrna != null ? this.asrna.getName() : this.property.getName();
            this.nameImage.setString(name);
            this.nameImageSize = this.nameImage.getNameImageSize();
        }
        this.nameImageBounds = this.symbol instanceof IonChannel ? this.createLabelBounds(((IonChannel)this.symbol).getLeftBounds(), this.nameImageSize) : this.createLabelBounds(this.symbol.getSymbolBounds(), this.nameImageSize);
        if (this.symbol instanceof Degraded) {
            this.nameImage.setString("");
        }
        this.nameImage.draw(g2, (int)this.nameImageBounds.x, (int)this.nameImageBounds.y);
    }

    public void setNameFontSize(int s) {
        this.nameImage.setNameFontSize(s);
    }

    public int getNameFontSize() {
        return this.nameImage.getNameFontSize();
    }

    @Override
    public GFramedShape createCopy() {
        return (GFramedShape)((Object)this.duplicate());
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        this.colorReservoir.put(new Integer(this.currentView), color);
        if (this.painter != null) {
            this.painter.setColor(color);
            this.painterReservoir.put(new Integer(this.currentView), this.painter);
        }
    }

    @Override
    public PaintScheme getPaintScheme() {
        return this.painter;
    }

    @Override
    public void setPaintScheme(PaintScheme painterin) {
        this.painter = painterin;
        this.painter.setColor(this.color);
        this.painter.setStroke(this.stroke);
        this.painterReservoir.put(new Integer(this.currentView), this.painter);
        if (this.symbol != null) {
            this.symbol.setPaintScheme(this.painter);
            this.symbolReservoir.put(new Integer(this.currentView), this.symbol);
        }
    }

    @Override
    public double getLineWidth() {
        return ((BasicStroke)this.stroke).getLineWidth();
    }

    public void setLineWidth(double linewidth) {
        this.stroke = new BasicStroke((float)linewidth, 0, 1);
        this.strokeReservoir.put(new Integer(this.currentView), this.stroke);
        if (this.painter != null) {
            this.painter.setStroke(this.stroke);
            this.painterReservoir.put(new Integer(this.currentView), this.painter);
        }
    }

    private Stroke getHypotheticalStroke() {
        return new BasicStroke(((BasicStroke)this.stroke).getLineWidth(), 0, 0, 10.0f, PATTERN_HYPOTHETICAL, 0.0f);
    }

    public SpeciesShapePainting getSpeciesShapePainting() {
        return new SpeciesShapePainting(((BasicStroke)this.stroke).getLineWidth(), this.color, this.painter);
    }

    public void setSpeciesShapePainting(SpeciesShapePainting painting) {
        this.setLineWidth(painting.getLineWidth());
        this.setColor(painting.getColor());
        this.setPaintScheme(painting.getPaintScheme());
    }

    @Override
    public void showLinkAnchors(GLinkPositionInfo lpi, boolean drawOnlyActive) {
        this.showLinkAnchorMode = drawOnlyActive ? 2 : 1;
        this.linkPositionInfo = (GLinkPositionInfo)lpi.clone();
    }

    @Override
    public void hideLinkAnchors() {
        this.showLinkAnchorMode = 0;
        this.linkPositionInfo = null;
    }

    @Override
    public GLinkPositionInfo getPointedLinkPosition(double x, double y) {
        if (!this.repaintBounds.contains(x, y)) {
            return null;
        }
        Point2D.Double[] array = this.setupLinkAnchorCoord();
        return ShapeUtil.getNearLinkAnchorPosition(array, x, y);
    }

    @Override
    public Point2D.Double getCoordinatesOfLinkPosition(GLinkPositionInfo lpi) {
        return this.symbol.getCoordinatesOfLinkPosition(lpi);
    }

    public void changeView(Integer viewInt) {
        SpeciesSymbol oldsymbol = this.symbol;
        this.currentView = viewInt;
        this.changePaintingsForView(viewInt);
        if (this.currentView == 2) {
            if (this.symbolReservoir != null && this.symbolReservoir.get(new Integer(0)) != null) {
                this.symbol = (SpeciesSymbol)this.symbolReservoir.get(new Integer(0));
                this.symbol.setPaintScheme(this.painter);
            }
            this.setSymbolUserSpecifiedColorFormOtherSymbolView(this.symbol, oldsymbol);
            return;
        }
        if (this.currentView == 3) {
            if (this.symbolReservoir != null && this.symbolReservoir.get(new Integer(1)) != null) {
                this.symbol = (SpeciesSymbol)this.symbolReservoir.get(new Integer(1));
                this.symbol.setPaintScheme(this.painter);
            }
            this.setSymbolUserSpecifiedColorFormOtherSymbolView(this.symbol, oldsymbol);
            return;
        }
        this.symbol = this.symbolReservoir != null && this.symbolReservoir.get(viewInt) != null ? (SpeciesSymbol)this.symbolReservoir.get(viewInt) : (SpeciesSymbol)this.symbolReservoir.get(new Integer(0));
        if (this.symbol != null) {
            this.symbol.setPaintScheme(this.painter);
            this.setSymbolUserSpecifiedColorFormOtherSymbolView(this.symbol, oldsymbol);
        }
    }

    private void changePaintingsForView(Integer viewInt) {
        if (viewInt == 2) {
            this.color = (Color)this.colorReservoir.get(new Integer(0));
            this.stroke = (Stroke)this.strokeReservoir.get(new Integer(0));
            this.painter = (PaintScheme)this.painterReservoir.get(new Integer(0));
            if (this.painter != null) {
                this.painter.setColor(this.color);
                this.painter.setStroke(this.stroke);
            }
            return;
        }
        if (viewInt == 3) {
            this.color = (Color)this.colorReservoir.get(new Integer(1));
            this.stroke = (Stroke)this.strokeReservoir.get(new Integer(1));
            this.painter = (PaintScheme)this.painterReservoir.get(new Integer(1));
            if (this.painter != null) {
                this.painter.setColor(this.color);
                this.painter.setStroke(this.stroke);
            }
            return;
        }
        this.color = (Color)this.colorReservoir.get(viewInt);
        this.stroke = (Stroke)this.strokeReservoir.get(viewInt);
        this.painter = (PaintScheme)this.painterReservoir.get(viewInt);
        if (this.painter != null) {
            this.painter.setColor(this.color);
            this.painter.setStroke(this.stroke);
        }
    }

    private void copyReservoirsTo(MonoSpeciesShape copy) {
        for (Integer key : this.strokeReservoir.keySet()) {
            Stroke st = (Stroke)this.strokeReservoir.get(key);
            BasicStroke stcopy = new BasicStroke(((BasicStroke)st).getLineWidth(), 0, 1);
            copy.strokeReservoir.put(key, stcopy);
        }
        for (Integer key : this.colorReservoir.keySet()) {
            Color cl = (Color)this.colorReservoir.get(key);
            Color clcopy = new Color(cl.getRed(), cl.getGreen(), cl.getBlue(), cl.getAlpha());
            copy.colorReservoir.put(key, clcopy);
        }
        for (Integer key : this.painterReservoir.keySet()) {
            PaintScheme ps = (PaintScheme)this.painterReservoir.get(key);
            try {
                PaintScheme pscopy = (PaintScheme)ps.getClass().newInstance();
                copy.painterReservoir.put(key, pscopy);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setIDString(String id) {
        this.nameImage.setIDString(id);
    }

    public void setIDStringPosition(int x, int y) {
        this.nameImage.setId_x(x);
        this.nameImage.setId_y(y);
    }

    public SameIDAutoTag getSameIDAutoTag() {
        return this.autotag;
    }

    public void setMShapes(Vector newShapes) {
        this.mShapes = newShapes;
    }

    public void addMShapesMember(ModificationShape member) {
        if (member == null) {
            return;
        }
        if (this.mShapes == null) {
            this.mShapes = new Vector();
        }
        this.mShapes.add(member);
    }

    public double getStructuralStateAngle() {
        return this.structuralStateAngle;
    }

    public void setStructuralStateAngle(double structuralStateAngle) {
        this.structuralStateAngle = structuralStateAngle;
    }

    private void setSymbolUserSpecifiedColorFormOtherSymbolView(SpeciesSymbol symbol, SpeciesSymbol oldsymbol) {
        if (symbol != null && symbol instanceof SpeciesSymbolImpl && oldsymbol != null && oldsymbol instanceof SpeciesSymbolImpl) {
            ((SpeciesSymbolImpl)symbol).setPaintSymbolFrameUsingSpecifiedColorFlg(((SpeciesSymbolImpl)oldsymbol).isPaintSymbolFrameUsingSpecifiedColor());
            ((SpeciesSymbolImpl)symbol).setUserSpecifiedColor(((SpeciesSymbolImpl)oldsymbol).getUserSpecifiedColor());
        }
    }

    public ModificationShape getActivedStatemShapeShowOnlyInSBGNViewer() {
        this.updateActivedStatemShapeShowOnlyInSBGNViewer();
        return this.activedStatemShapeShowOnlyInSBGNViewer;
    }

    public Rectangle2D.Double updateActivedStatemShapeShowOnlyInSBGNViewer() {
        this.activedStatemShapeShowOnlyInSBGNViewer.setSpeciesSymbol(this.symbol);
        this.activedStatemShapeShowOnlyInSBGNViewer.setStructuralState(this.activedStateShowOnlyInSBGNViewer);
        this.activedStatemShapeShowOnlyInSBGNViewer.getNameBounds(null);
        return this.activedStatemShapeShowOnlyInSBGNViewer.updateCircleBounds();
    }

    public ModificationShape getModificationShapeOfSpeciesInformatBoxWhithPoint(double x, double y) {
        return this.getModificationShapeOfSpeciesInformatBoxWhithPoint(new Point2D.Double(x, y));
    }

    public ModificationShape getModificationShapeOfSpeciesInformatBoxWhithPoint(Point2D pointA) {
        block6: {
            if (pointA == null) {
                return null;
            }
            if (this.mShapes != null) break block6;
            return null;
        }
        try {
            int i = this.mShapes.size() - 1;
            while (i >= 0) {
                ModificationShape msp = (ModificationShape)this.mShapes.get(i);
                if (msp.isDotInShapeOfSpeciesInformatBox(pointA)) {
                    return msp;
                }
                --i;
            }
            return null;
        }
        catch (Exception myErr) {
            return null;
        }
    }

    public NameImage getNameImage() {
        return this.nameImage;
    }
}

