/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import jp.co.mki.celldesigner.simulation.controlpanel.ControlPanelMainWindow;
import jp.fric.graphics.draw.PaintScheme;
import jp.sbi.celldesigner.ComplexProperty;
import jp.sbi.celldesigner.ComplexSpeciesAlias;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MonoSpeciesProperty;
import jp.sbi.celldesigner.MonoSpeciesShape;
import jp.sbi.celldesigner.Preference;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SpeciesAlias;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.SpeciesPropertyDialog;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNA;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNAPanel;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNAPanelListener;
import jp.sbi.celldesigner.sbmlExtension.Biomolecule;
import jp.sbi.celldesigner.sbmlExtension.ComplexPanel;
import jp.sbi.celldesigner.sbmlExtension.ComplexPanelListener;
import jp.sbi.celldesigner.sbmlExtension.Gene;
import jp.sbi.celldesigner.sbmlExtension.GenePanel;
import jp.sbi.celldesigner.sbmlExtension.GenePanelListener;
import jp.sbi.celldesigner.sbmlExtension.Modification;
import jp.sbi.celldesigner.sbmlExtension.ModificationRegionDialog2;
import jp.sbi.celldesigner.sbmlExtension.ModificationResidueDialog2;
import jp.sbi.celldesigner.sbmlExtension.ModificationShape;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.ProteinPanel;
import jp.sbi.celldesigner.sbmlExtension.ProteinPanelListener;
import jp.sbi.celldesigner.sbmlExtension.RNA;
import jp.sbi.celldesigner.sbmlExtension.RNAPanel;
import jp.sbi.celldesigner.sbmlExtension.RNAPanelListener;
import jp.sbi.celldesigner.sbmlExtension.SameIDAutoTag;
import jp.sbi.celldesigner.sbmlExtension.StructuralState;
import org.sbml.libsbml.ListOf;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.Species;

public class MonoSpeciesPropertyDialog
extends SpeciesPropertyDialog
implements ActionListener,
ProteinPanelListener,
GenePanelListener,
RNAPanelListener,
AntiSenseRNAPanelListener,
ComplexPanelListener {
    private String newNameString = null;
    ListOf listOfProteins = null;
    ListOf listOfGenes = null;
    ListOf listOfRNAs = null;
    ListOf listOfAntiSenseRNAs = null;
    private MonoSpeciesProperty editingProperty = null;
    private boolean isPrevProtein = false;
    private boolean isPrevGene = false;
    private boolean isPrevRNA = false;
    private boolean isPrevAntiSenseRNA = false;
    private ModificationShape selected = null;
    private final String[] STATE_STRS = new String[]{"empty", "phosphorylated", "acetylated", "ubiquitinated", "methylated", "hydroxylated", "don't care", "unknown", "histone1", "histone2", "glycosylated", "myristoylated", "palmytoylated", "prenylated", "protonated", "sulfated"};
    private final String[] STRUCTURALSTATE_STRS = new String[]{"empty", "open", "closed", "user defined text"};
    private final String[] STATE_PROTEIN_SPECIFIC = new String[]{"empty", "phosphorylated", "acetylated", "ubiquitinated", "methylated", "hydroxylated", "glycosylated", "myristoylated", "palmytoylated", "prenylated", "protonated", "sulfated", "don't care", "unknown"};
    private final String[] STATE_GENE_SPECIFIC = new String[]{"empty", "phosphorylated", "acetylated", "methylated", "don't care", "unknown"};
    public static final String NEW_PROTEIN_LABEL = "[New Protein]";
    public static final String NEW_GENE_LABEL = "[New Gene]";
    public static final String NEW_RNA_LABEL = "[New RNA]";
    public static final String NEW_ANTISENSERNA_LABEL = "[New AntiSenseRNA]";
    protected JComboBox typeCombo;
    protected JRadioButton hypotheticalRadio;
    protected JTextField speciesNameField;
    protected JTextField homodimerTextField;
    protected JComboBox proteinRefCombo;
    protected JComboBox geneRefCombo;
    protected JComboBox rnaRefCombo;
    protected JComboBox antisensernaRefCombo;
    protected JComboBox stateCombo;
    protected JButton applyButton;
    protected JButton resetButton;
    protected JButton closeButton;
    protected JPanel peditPanel;
    protected JPanel geditPanel;
    protected JPanel reditPanel;
    protected JPanel asreditPanel;
    protected JPanel ceditPanel;
    protected ProteinPanel proteinPanel;
    protected GenePanel genePanel;
    protected RNAPanel rnaPanel;
    protected AntiSenseRNAPanel antisensernaPanel;
    protected ComplexPanel complexPanel;
    protected ModificationResidueDialog2 mDialog;
    protected ModificationRegionDialog2 tDialog;
    protected JComboBox structuralStateCombo;
    protected JTextField inputTextField;
    private MyComponentListener cautionShower;
    private JPanel panel;
    private boolean isEditPanelVisible = true;
    private PaintScheme painter = null;
    public static boolean isSelectedOriginal;

    public MonoSpeciesPropertyDialog(JFrame owner, SBModel sbmodel, String title, boolean forMono) {
        super(owner, sbmodel);
        this.setTitle(title);
        this.setModal(true);
        this.mDialog = new ModificationResidueDialog2(this);
        this.tDialog = new ModificationRegionDialog2(this);
        this.initFrame();
        this.initComboItems(forMono);
        this.proteinPanel.setEditable(false);
        this.proteinPanel.setProteinPanelListener(this);
        this.genePanel.setEditable(false);
        this.genePanel.setGenePanelListener(this);
        this.rnaPanel.setEditable(false);
        this.rnaPanel.setRNAPanelListener(this);
        this.antisensernaPanel.setEditable(false);
        this.antisensernaPanel.setAntiSenseRNAPanelListener(this);
        this.complexPanel.setComplexPanelListener(this);
        if (forMono) {
            this.typeCombo.addActionListener(this);
        }
        this.proteinRefCombo.addActionListener(this);
        this.geneRefCombo.addActionListener(this);
        this.rnaRefCombo.addActionListener(this);
        this.antisensernaRefCombo.addActionListener(this);
        this.stateCombo.addActionListener(this);
        this.structuralStateCombo.addActionListener(this);
        this.cautionShower = new MyComponentListener();
        this.addComponentListener(this.cautionShower);
    }

    public void setListOfProteins(ListOf listOfProteins) {
        this.listOfProteins = listOfProteins;
    }

    public void setListOfGenes(ListOf listOfGenes) {
        this.listOfGenes = listOfGenes;
    }

    public void setListOfRNAs(ListOf listOfRNAs) {
        this.listOfRNAs = listOfRNAs;
    }

    public void setListOfAntiSenseRNAs(ListOf listOfAntiSenseRNAs) {
        this.listOfAntiSenseRNAs = listOfAntiSenseRNAs;
    }

    @Override
    public void releaseAll() {
        this.removeComponentListener(this.cautionShower);
        this.proteinPanel.setProteinPanelListener(null);
        this.genePanel.setGenePanelListener(null);
        this.rnaPanel.setRNAPanelListener(null);
        this.antisensernaPanel.setAntiSenseRNAPanelListener(null);
        this.complexPanel.setComplexPanelListener(null);
        this.typeCombo.removeActionListener(this);
        this.stateCombo.removeActionListener(this);
        this.structuralStateCombo.removeActionListener(this);
        this.proteinRefCombo.removeActionListener(this);
        this.geneRefCombo.removeActionListener(this);
        this.rnaRefCombo.removeActionListener(this);
        this.antisensernaRefCombo.removeActionListener(this);
        this.proteinPanel.releaseAll();
        this.proteinPanel = null;
        this.genePanel.releaseAll();
        this.genePanel = null;
        this.rnaPanel.releaseAll();
        this.rnaPanel = null;
        this.antisensernaPanel.releaseAll();
        this.antisensernaPanel = null;
        this.complexPanel.releaseAll();
        this.complexPanel = null;
        this.mDialog.releaseAll();
        this.mDialog = null;
        this.tDialog.releaseAll();
        this.tDialog = null;
        this.selected = null;
        this.editingProperty = null;
        this.listOfProteins = null;
        this.listOfGenes = null;
        this.listOfRNAs = null;
        this.listOfAntiSenseRNAs = null;
        super.releaseAll();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.typeCombo)) {
            this.typeCombo_performed();
            return;
        }
        if (e.getSource().equals(this.proteinRefCombo)) {
            this.proteinRefCombo_performed();
            return;
        }
        if (e.getSource().equals(this.geneRefCombo)) {
            this.geneRefCombo_performed();
            return;
        }
        if (e.getSource().equals(this.rnaRefCombo)) {
            this.rnaRefCombo_performed();
            return;
        }
        if (e.getSource().equals(this.antisensernaRefCombo)) {
            this.antisensernaRefCombo_performed();
            return;
        }
        if (e.getSource().equals(this.stateCombo)) {
            this.stateCombo_performed();
            return;
        }
        if (e.getSource().equals(this.structuralStateCombo)) {
            this.structuralStateCombo_performed();
            return;
        }
    }

    private void initFrame() {
        final JRootPane rootPane = this.getRootPane();
        FocusAdapter applyButtonFocuser = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                rootPane.setDefaultButton(MonoSpeciesPropertyDialog.this.applyButton);
            }
        };
        this.panel = new JPanel();
        this.panel.setLayout(null);
        JLabel labelMax = new JLabel("residues/regions");
        int labelWidth = (int)labelMax.getPreferredSize().getWidth();
        int inputX = labelWidth + 20;
        int labelX = 12;
        int inputW = 200;
        int proteinPanelX = 2;
        int editPanelX = -2;
        int eidtPanelW = inputX + inputW + 20;
        JLabel labelType = new JLabel("class");
        labelType.setBounds(new Rectangle(10, 4, labelWidth, 20));
        this.panel.add((Component)labelType, null);
        this.typeCombo = new JComboBox();
        this.typeCombo.setBounds(new Rectangle(inputX, 4, inputW, 20));
        this.typeCombo.addFocusListener(applyButtonFocuser);
        this.panel.add((Component)this.typeCombo, null);
        JLabel labelHypothetical = new JLabel("hypothetical");
        labelHypothetical.setBounds(new Rectangle(10, 28, labelWidth, 20));
        this.panel.add((Component)labelHypothetical, null);
        this.hypotheticalRadio = new JRadioButton();
        this.hypotheticalRadio.setBounds(new Rectangle(inputX, 28, 40, 20));
        this.hypotheticalRadio.addFocusListener(applyButtonFocuser);
        this.panel.add((Component)this.hypotheticalRadio, null);
        JLabel labelSpeciesName = new JLabel("name");
        labelSpeciesName.setBounds(new Rectangle(10, 52, labelWidth, 20));
        this.panel.add((Component)labelSpeciesName, null);
        this.speciesNameField = new JTextField();
        this.speciesNameField.setBounds(new Rectangle(inputX, 52, 200, 20));
        this.speciesNameField.addFocusListener(applyButtonFocuser);
        this.panel.add((Component)this.speciesNameField, null);
        JLabel labelHomodimer = new JLabel("homomultimer");
        labelHomodimer.setBounds(new Rectangle(10, 76, labelWidth, 20));
        this.panel.add((Component)labelHomodimer, null);
        this.homodimerTextField = new JTextField();
        this.homodimerTextField.setBounds(new Rectangle(inputX, 76, inputW, 20));
        this.homodimerTextField.addFocusListener(applyButtonFocuser);
        this.panel.add((Component)this.homodimerTextField, null);
        this.peditPanel = new JPanel();
        this.peditPanel.setLayout(null);
        this.peditPanel.setBounds(new Rectangle(editPanelX, 110, eidtPanelW + 5, 192));
        Border etched = BorderFactory.createEtchedBorder();
        this.peditPanel.setBorder(etched);
        this.panel.add((Component)this.peditPanel, null);
        JLabel labelProteinRef = new JLabel("protein");
        labelProteinRef.setBounds(new Rectangle(labelX, 8, labelWidth, 20));
        this.peditPanel.add((Component)labelProteinRef, null);
        this.proteinRefCombo = new JComboBox();
        this.proteinRefCombo.setBounds(new Rectangle(inputX + 2, 8, inputW, 20));
        this.proteinRefCombo.addFocusListener(applyButtonFocuser);
        this.peditPanel.add((Component)this.proteinRefCombo, null);
        this.proteinPanel = new ProteinPanel(this, this.mDialog);
        this.proteinPanel.setBounds(new Rectangle(proteinPanelX, 28, this.proteinPanel.getWidth(), this.proteinPanel.getHeight()));
        this.peditPanel.add((Component)this.proteinPanel, null);
        this.geditPanel = new JPanel();
        this.geditPanel.setLayout(null);
        this.geditPanel.setBounds(new Rectangle(editPanelX, 110, eidtPanelW + 5, 192));
        Border getched = BorderFactory.createEtchedBorder();
        this.geditPanel.setBorder(getched);
        this.panel.add((Component)this.geditPanel, null);
        JLabel labelGeneRef = new JLabel("gene");
        labelGeneRef.setBounds(new Rectangle(labelX, 8, labelWidth, 20));
        this.geditPanel.add((Component)labelGeneRef, null);
        this.geneRefCombo = new JComboBox();
        this.geneRefCombo.setBounds(new Rectangle(inputX + 2, 8, inputW, 20));
        this.geneRefCombo.addFocusListener(applyButtonFocuser);
        this.geditPanel.add((Component)this.geneRefCombo, null);
        this.genePanel = new GenePanel(this, this.tDialog);
        this.genePanel.setBounds(new Rectangle(proteinPanelX, 28, this.genePanel.getWidth(), this.genePanel.getHeight()));
        this.geditPanel.add((Component)this.genePanel, null);
        this.reditPanel = new JPanel();
        this.reditPanel.setLayout(null);
        this.reditPanel.setBounds(new Rectangle(editPanelX, 110, eidtPanelW + 5, 192));
        Border retched = BorderFactory.createEtchedBorder();
        this.reditPanel.setBorder(retched);
        this.panel.add((Component)this.reditPanel, null);
        JLabel labelRNARef = new JLabel("RNA");
        labelRNARef.setBounds(new Rectangle(labelX, 8, labelWidth, 20));
        this.reditPanel.add((Component)labelRNARef, null);
        this.rnaRefCombo = new JComboBox();
        this.rnaRefCombo.setBounds(new Rectangle(inputX + 2, 8, inputW, 20));
        this.rnaRefCombo.addFocusListener(applyButtonFocuser);
        this.reditPanel.add((Component)this.rnaRefCombo, null);
        this.rnaPanel = new RNAPanel(this, this.tDialog);
        this.rnaPanel.setBounds(new Rectangle(proteinPanelX, 28, this.rnaPanel.getWidth(), this.rnaPanel.getHeight()));
        this.reditPanel.add((Component)this.rnaPanel, null);
        this.asreditPanel = new JPanel();
        this.asreditPanel.setLayout(null);
        this.asreditPanel.setBounds(new Rectangle(editPanelX, 110, eidtPanelW + 5, 192));
        Border asretched = BorderFactory.createEtchedBorder();
        this.asreditPanel.setBorder(asretched);
        this.panel.add((Component)this.asreditPanel, null);
        JLabel labelAntiSenseRNARef = new JLabel("antisense RNA");
        labelAntiSenseRNARef.setBounds(new Rectangle(labelX, 8, labelWidth, 20));
        this.asreditPanel.add((Component)labelAntiSenseRNARef, null);
        this.antisensernaRefCombo = new JComboBox();
        this.antisensernaRefCombo.setBounds(new Rectangle(inputX + 2, 8, inputW, 20));
        this.antisensernaRefCombo.addFocusListener(applyButtonFocuser);
        this.asreditPanel.add((Component)this.antisensernaRefCombo, null);
        this.antisensernaPanel = new AntiSenseRNAPanel(this, this.tDialog);
        this.antisensernaPanel.setBounds(new Rectangle(proteinPanelX, 28, this.antisensernaPanel.getWidth(), this.antisensernaPanel.getHeight()));
        this.asreditPanel.add((Component)this.antisensernaPanel, null);
        this.ceditPanel = new JPanel();
        this.ceditPanel.setLayout(null);
        this.ceditPanel.setBounds(new Rectangle(editPanelX, 110, eidtPanelW + 5, 115));
        Border cetched = BorderFactory.createEtchedBorder();
        this.ceditPanel.setBorder(cetched);
        this.panel.add((Component)this.ceditPanel, null);
        this.complexPanel = new ComplexPanel(this);
        this.complexPanel.setBounds(new Rectangle(proteinPanelX, 2, this.complexPanel.getWidth(), this.complexPanel.getHeight()));
        this.ceditPanel.add((Component)this.complexPanel, null);
        JLabel stateLabel = new JLabel("modification");
        stateLabel.setBounds(new Rectangle(10, 314, 120, 20));
        this.panel.add((Component)stateLabel, null);
        this.stateCombo = new JComboBox();
        this.stateCombo.setBounds(new Rectangle(inputX, 314, inputW, 20));
        this.panel.add((Component)this.stateCombo, null);
        int dy = 24;
        JLabel structuralStateLabel = new JLabel("state");
        structuralStateLabel.setBounds(new Rectangle(10, 314 + dy, 120, 20));
        this.panel.add((Component)structuralStateLabel, null);
        this.structuralStateCombo = new JComboBox();
        this.structuralStateCombo.setBounds(new Rectangle(inputX, 314 + dy, inputW, 20));
        this.panel.add((Component)this.structuralStateCombo, null);
        JLabel inputLabel = new JLabel("text input");
        inputLabel.setBounds(new Rectangle(10, 314 + dy + dy, 120, 20));
        this.panel.add((Component)inputLabel, null);
        this.inputTextField = new JTextField();
        this.inputTextField.setBounds(new Rectangle(inputX, 314 + dy + dy, inputW, 20));
        this.inputTextField.setEnabled(false);
        this.inputTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String type = "";
                try {
                    type = (String)MonoSpeciesPropertyDialog.this.typeCombo.getSelectedItem();
                    if (type == null) {
                        type = "";
                    }
                }
                catch (Exception myErr) {
                    type = "";
                }
                if (!"PROTEIN".equals(type) && !"COMPLEX".equals(type)) {
                    return;
                }
                String state = (String)MonoSpeciesPropertyDialog.this.structuralStateCombo.getSelectedItem();
                if (!"user defined text".equals(state)) {
                    return;
                }
                StructuralState structuralState = new StructuralState();
                state = MonoSpeciesPropertyDialog.this.inputTextField.getText();
                structuralState.setState(state);
                if ("PROTEIN".equals(type) && MonoSpeciesPropertyDialog.this.proteinPanel != null) {
                    MonoSpeciesPropertyDialog.this.setAngleFromStructuralState(MonoSpeciesPropertyDialog.this.proteinPanel.getStructuralStates(), structuralState);
                } else if ("COMPLEX".equals(type) && MonoSpeciesPropertyDialog.this.complexPanel != null) {
                    MonoSpeciesPropertyDialog.this.setAngleFromStructuralState(MonoSpeciesPropertyDialog.this.complexPanel.getStructuralStates(), structuralState);
                }
                MonoSpeciesPropertyDialog.this.resetStructuralState(type, structuralState);
                MonoSpeciesPropertyDialog.this.repaint();
            }
        });
        this.inputTextField.addFocusListener(applyButtonFocuser);
        this.panel.add((Component)this.inputTextField, null);
        this.applyButton = new JButton("Apply");
        int applyButtonX = 50;
        int applyButtonWidth = (int)this.applyButton.getPreferredSize().getWidth();
        this.applyButton.setBounds(new Rectangle(applyButtonX, 348 + dy * 2, applyButtonWidth, 20));
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonoSpeciesPropertyDialog.this.apply_performed();
            }
        });
        this.panel.add((Component)this.applyButton, null);
        this.resetButton = new JButton("Reset");
        int resetButtonWidth = (int)this.resetButton.getPreferredSize().getWidth();
        int resetButtonX = applyButtonX + applyButtonWidth + 5;
        this.resetButton.setBounds(new Rectangle(resetButtonX, 348 + dy * 2, resetButtonWidth, 20));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonoSpeciesPropertyDialog.this.reset_performed();
            }
        });
        this.panel.add((Component)this.resetButton, null);
        this.closeButton = new JButton("Cancel");
        int closeButtonWidth = (int)this.closeButton.getPreferredSize().getWidth();
        int closeButtonX = resetButtonX + resetButtonWidth + 5;
        this.closeButton.setBounds(new Rectangle(closeButtonX, 348 + dy * 2, closeButtonWidth, 20));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonoSpeciesPropertyDialog.this.close_performed();
            }
        });
        this.panel.add((Component)this.closeButton, null);
        this.getContentPane().add(this.panel);
        this.setSize(eidtPanelW, 405 + dy * 2);
        this.setResizable(false);
        this.changeLayout();
        this.validate();
    }

    private void initComboItems(boolean forMono) {
        this.initTypeComboItems(forMono);
        int i = 0;
        while (i < this.STATE_STRS.length) {
            this.stateCombo.addItem(this.STATE_STRS[i]);
            ++i;
        }
        this.stateCombo.setSelectedItem("empty");
        i = 0;
        while (i < this.STRUCTURALSTATE_STRS.length) {
            this.structuralStateCombo.addItem(this.STRUCTURALSTATE_STRS[i]);
            ++i;
        }
        this.structuralStateCombo.setSelectedItem("empty");
    }

    private void initTypeComboItems(boolean forMono) {
        if (forMono) {
            this.typeCombo.addItem("PROTEIN");
            this.typeCombo.addItem("GENE");
            this.typeCombo.addItem("RNA");
            this.typeCombo.addItem("ANTISENSE_RNA");
            Vector codes = SBFactory.getCompatibleSymbolCodes("GENERIC");
            int i = 0;
            while (i < codes.size()) {
                String code = (String)codes.elementAt(i);
                if (!(SBFactory.isProtein(code) || SBFactory.isGene(code) || SBFactory.isRNA(code) || SBFactory.isAntiSenseRNA(code))) {
                    this.typeCombo.addItem(code);
                }
                ++i;
            }
        } else {
            this.typeCombo.addItem("COMPLEX");
            this.typeCombo.setSelectedIndex(0);
        }
    }

    @Override
    public void show() {
        this.rootPane.setDefaultButton(this.applyButton);
        super.show();
    }

    public String getNewName() {
        return this.newNameString;
    }

    @Override
    public boolean setTarget(SpeciesAlias alias) {
        MonoSpeciesShape shape = (MonoSpeciesShape)alias.getGFramedShape();
        try {
            this.painter = (PaintScheme)shape.getPaintScheme().getClass().newInstance();
        }
        catch (Exception e) {
            System.out.println("MonoSpeciesPropertyDialog.setTarget() :" + e.getLocalizedMessage());
        }
        Color color = shape.getColor();
        BasicStroke stroke = new BasicStroke((float)shape.getLineWidth(), 0, 1);
        this.painter.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        this.painter.setStroke(stroke);
        this.proteinPanel.setPaintScheme(this.painter);
        this.genePanel.setPaintScheme(this.painter);
        this.rnaPanel.setPaintScheme(this.painter);
        this.antisensernaPanel.setPaintScheme(this.painter);
        this.complexPanel.setPaintScheme(this.painter);
        Rectangle2D.Double bounds = shape.getFrameBounds();
        if (alias instanceof ComplexSpeciesAlias) {
            this.complexPanel.setSymbolBounds(bounds);
        } else {
            this.proteinPanel.setSymbolBounds(bounds);
        }
        return super.setTarget(alias);
    }

    @Override
    public boolean setSpeciesProperty(SpeciesProperty property) {
        if (property instanceof MonoSpeciesProperty) {
            this.editingProperty = (MonoSpeciesProperty)property;
            return true;
        }
        this.editingProperty = null;
        return false;
    }

    @Override
    public void updateDialog() {
        String name;
        Species s;
        if (this.editingProperty == null) {
            return;
        }
        MonoSpeciesProperty copy = (MonoSpeciesProperty)this.editingProperty.deepClone();
        String type = copy.getType();
        boolean isHypothetical = copy.getHypothetical();
        boolean isProtein = type.equals("PROTEIN");
        boolean isGene = type.equals("GENE");
        boolean isRNA = type.equals("RNA");
        boolean isAntiSenseRNA = type.equals("ANTISENSE_RNA");
        boolean isComplex = type.equals("COMPLEX");
        this.isPrevProtein = isProtein;
        this.isPrevGene = isGene;
        this.isPrevRNA = isRNA;
        this.isPrevAntiSenseRNA = isAntiSenseRNA;
        this.peditPanel.setVisible(isProtein);
        this.geditPanel.setVisible(isGene);
        this.reditPanel.setVisible(isRNA);
        this.asreditPanel.setVisible(isAntiSenseRNA);
        this.ceditPanel.setVisible(isComplex);
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        this.proteinRefCombo.removeAllItems();
        int i = 0;
        while ((long)i < this.listOfProteins.size()) {
            s = (Species)this.listOfProteins.get((long)i);
            Protein p = sbModel.getProtein(s.getId());
            this.proteinRefCombo.addItem(p.getName());
            ++i;
        }
        this.proteinRefCombo.addItem(NEW_PROTEIN_LABEL);
        this.geneRefCombo.removeAllItems();
        i = 0;
        while ((long)i < this.listOfGenes.size()) {
            s = (Species)this.listOfGenes.get((long)i);
            Gene g = sbModel.getGene(s.getId());
            this.geneRefCombo.addItem(g.getName());
            ++i;
        }
        this.geneRefCombo.addItem(NEW_GENE_LABEL);
        this.rnaRefCombo.removeAllItems();
        i = 0;
        while ((long)i < this.listOfRNAs.size()) {
            s = (Species)this.listOfRNAs.get((long)i);
            RNA r = sbModel.getRNA(s.getId());
            this.rnaRefCombo.addItem(r.getName());
            ++i;
        }
        this.rnaRefCombo.addItem(NEW_RNA_LABEL);
        this.antisensernaRefCombo.removeAllItems();
        i = 0;
        while ((long)i < this.listOfAntiSenseRNAs.size()) {
            s = (Species)this.listOfAntiSenseRNAs.get((long)i);
            AntiSenseRNA asrna = sbModel.getAntiSenseRNA(s.getId());
            this.antisensernaRefCombo.addItem(asrna.getName());
            ++i;
        }
        this.antisensernaRefCombo.addItem(NEW_ANTISENSERNA_LABEL);
        if (!type.equals("COMPLEX")) {
            this.typeCombo.removeAllItems();
            if (type.equals("TAG")) {
                Vector codes = SBFactory.getCompatibleSymbolCodes("TAG");
                int i2 = 0;
                while (i2 < codes.size()) {
                    String code = (String)codes.elementAt(i2);
                    this.typeCombo.addItem(code);
                    ++i2;
                }
            } else {
                this.initTypeComboItems(true);
            }
            this.typeCombo.setSelectedItem(type);
        }
        this.changeLayout();
        this.hypotheticalRadio.setEnabled(true);
        this.hypotheticalRadio.setSelected(isHypothetical);
        this.homodimerTextField.setText("" + copy.getHomodimer());
        this.homodimerTextField.setEnabled(true);
        this.resetSpeciesNameField(copy.getName(), isProtein, isGene, isRNA, isAntiSenseRNA);
        this.resetProteinRefCombo(isProtein);
        this.proteinPanel.setEnabled(isProtein);
        this.resetGeneRefCombo(isGene);
        this.genePanel.setEnabled(isGene);
        this.resetRNARefCombo(isRNA);
        this.rnaPanel.setEnabled(isRNA);
        this.resetAntiSenseRNARefCombo(isAntiSenseRNA);
        this.antisensernaPanel.setEnabled(isAntiSenseRNA);
        this.complexPanel.setEnabled(isComplex);
        if (isProtein || isGene || isRNA || isAntiSenseRNA) {
            this.resetStateCombo(true);
        }
        if (isProtein) {
            this.structuralStateCombo.setEnabled(true);
        } else if (type.equals("COMPLEX")) {
            this.structuralStateCombo.setEnabled(true);
        } else if (type.toUpperCase().equals("TAG".toUpperCase())) {
            this.structuralStateCombo.setSelectedIndex(0);
            this.structuralStateCombo.setEnabled(false);
        } else {
            this.structuralStateCombo.setSelectedIndex(0);
            this.structuralStateCombo.setEnabled(false);
        }
        if (!(isProtein || isGene || isRNA || isAntiSenseRNA || isComplex)) {
            return;
        }
        SameIDAutoTag autag = null;
        if (isProtein || isComplex) {
            SpeciesAlias alias = super.getShowingSpecieAlias();
            MonoSpeciesShape shape = (MonoSpeciesShape)alias.getGFramedShape();
            autag = shape.getSameIDAutoTag();
        }
        if (isProtein) {
            Protein p = copy.getProtein();
            Vector modifications = copy.getModifications();
            if (p != null) {
                name = p.getName();
                this.proteinRefCombo.setSelectedItem(name);
                Vector structuralStates = copy.getStructuralStates();
                if (copy.getStructuralStates() != null && copy.getStructuralStates().size() > 0) {
                    StructuralState state = (StructuralState)copy.getStructuralStates().get(0);
                    MonoSpeciesShape monoShape = (MonoSpeciesShape)this.getShowingSpecieAlias().getGFramedShape();
                    state.setAngle(monoShape.getStructuralStateAngle());
                }
                this.proteinPanel.setProtein(p, modifications, structuralStates, autag);
                if (structuralStates != null && structuralStates.size() > 0) {
                    StructuralState structuralState = (StructuralState)structuralStates.get(0);
                    String strState = structuralState.getState();
                    int i3 = 0;
                    i3 = 0;
                    while (i3 < this.STRUCTURALSTATE_STRS.length) {
                        if (strState.equals(this.STRUCTURALSTATE_STRS[i3])) {
                            this.structuralStateCombo.setSelectedIndex(i3);
                            break;
                        }
                        ++i3;
                    }
                    if (i3 >= this.STRUCTURALSTATE_STRS.length) {
                        this.inputTextField.setEditable(true);
                        if (strState == null || strState.length() == 0) {
                            strState = "";
                        }
                        this.inputTextField.setText(strState);
                        this.structuralStateCombo.setSelectedIndex(this.STRUCTURALSTATE_STRS.length - 1);
                    }
                }
            } else {
                this.proteinRefCombo.setSelectedItem(NEW_PROTEIN_LABEL);
            }
        }
        if (isGene) {
            Gene g = copy.getGene();
            Vector gmodifications = copy.getModifications();
            if (g != null) {
                name = g.getName();
                this.geneRefCombo.setSelectedItem(name);
                this.genePanel.setGene(g, gmodifications);
            } else {
                this.geneRefCombo.setSelectedItem(NEW_GENE_LABEL);
            }
        }
        if (isRNA) {
            RNA r = copy.getRNA();
            Vector rmodifications = copy.getModifications();
            if (r != null) {
                name = r.getName();
                this.rnaRefCombo.setSelectedItem(name);
                this.rnaPanel.setRNA(r, rmodifications);
            } else {
                this.rnaRefCombo.setSelectedItem(NEW_RNA_LABEL);
            }
        }
        if (isAntiSenseRNA) {
            AntiSenseRNA asr = copy.getAntiSenseRNA();
            Vector asrmodifications = copy.getModifications();
            if (asr != null) {
                name = asr.getName();
                this.antisensernaRefCombo.setSelectedItem(name);
                this.antisensernaPanel.setAntiSenseRNA(asr, asrmodifications);
            } else {
                this.antisensernaRefCombo.setSelectedItem(NEW_ANTISENSERNA_LABEL);
            }
        }
        if (isComplex) {
            Vector structuralStates = copy.getStructuralStates();
            if (copy.getStructuralStates() != null && copy.getStructuralStates().size() > 0) {
                StructuralState state = (StructuralState)copy.getStructuralStates().get(0);
                MonoSpeciesShape monoShape = (MonoSpeciesShape)this.getShowingSpecieAlias().getGFramedShape();
                state.setAngle(monoShape.getStructuralStateAngle());
            }
            this.complexPanel.setComplexProperty((ComplexProperty)copy, structuralStates, autag);
            if (structuralStates != null && structuralStates.size() > 0) {
                StructuralState structuralState = (StructuralState)structuralStates.get(0);
                String strState = structuralState.getState();
                int i4 = 0;
                i4 = 0;
                while (i4 < this.STRUCTURALSTATE_STRS.length) {
                    if (strState.equals(this.STRUCTURALSTATE_STRS[i4])) {
                        this.structuralStateCombo.setSelectedIndex(i4);
                        break;
                    }
                    ++i4;
                }
                if (i4 >= this.STRUCTURALSTATE_STRS.length) {
                    this.inputTextField.setEditable(true);
                    if (strState == null || strState.length() == 0) {
                        strState = "";
                    }
                    this.inputTextField.setText(strState);
                    this.structuralStateCombo.setSelectedIndex(this.STRUCTURALSTATE_STRS.length - 1);
                }
            }
        }
        this.repaint();
    }

    public void apply_performed() {
        ControlPanelMainWindow target;
        MainWindow lastInstance;
        Modification m;
        Vector<Object> noEmpties;
        Vector modifications;
        Species r;
        Species selectedOriginal;
        Species sp;
        int i;
        String newName;
        isSelectedOriginal = false;
        if (this.editingProperty == null) {
            return;
        }
        MonoSpeciesProperty copy = (MonoSpeciesProperty)this.editingProperty.deepClone();
        String type = copy.getType();
        boolean isPrevProtein = type.equals("PROTEIN");
        boolean isPrevGene = type.equals("GENE");
        boolean isPrevRNA = type.equals("RNA");
        boolean isPrevAntiSenseRNA = type.equals("ANTISENSE_RNA");
        MonoSpeciesProperty newProperty = null;
        SameIDAutoTag newautotag = null;
        String newType = "";
        try {
            newType = (String)this.typeCombo.getSelectedItem();
            if (newType == null) {
                return;
            }
        }
        catch (Exception myErr) {
            return;
        }
        Species beforeComplexSpecies = this.getShowingSpecieAlias().getOriginalSpecies();
        if (newType.equals("COMPLEX")) {
            newProperty = new ComplexProperty();
            Vector structuralStates = this.complexPanel.getStructuralStates();
            Vector<StructuralState> noEmpties2 = new Vector<StructuralState>();
            int i2 = 0;
            while (i2 < structuralStates.size()) {
                StructuralState s = (StructuralState)structuralStates.elementAt(i2);
                if (!s.getState().equals("empty")) {
                    noEmpties2.add(s);
                }
                ++i2;
            }
            newProperty.setStructuralStates(noEmpties2);
        } else {
            newProperty = new MonoSpeciesProperty();
        }
        newProperty.setType(newType);
        boolean isProtein = newType.equals("PROTEIN");
        boolean isGene = newType.equals("GENE");
        boolean isRNA = newType.equals("RNA");
        boolean isAntiSenseRNA = newType.equals("ANTISENSE_RNA");
        boolean isComplex = newType.equals("COMPLEX");
        if (isProtein) {
            newautotag = this.proteinPanel.getSameIDAutoTag();
        } else if (isComplex) {
            newautotag = this.complexPanel.getSameIDAutoTag();
        }
        boolean isHypothetical = this.hypotheticalRadio.isSelected();
        newProperty.setHypothetical(isHypothetical);
        String homodimerString = this.homodimerTextField.getText();
        int homodimer = 0;
        try {
            homodimer = Integer.parseInt(homodimerString);
            if (homodimer < 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Homomultimer value should be a positive integer.", "Warning", 2);
            return;
        }
        newProperty.setHomodimer(homodimer);
        if (!(isProtein || isGene || isRNA || isAntiSenseRNA)) {
            this.newNameString = "";
            String newName2 = this.speciesNameField.getText();
            if (newName2.equals("")) {
                JOptionPane.showMessageDialog(this, "Name is void.\n Please input name.", "Warning", 2);
                return;
            }
            newProperty.setName(newName2);
            this.newNameString = newName2;
        } else {
            newProperty.setName("");
        }
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        if (isProtein) {
            Protein selectedProtein = this.proteinPanel.getProtein();
            if (selectedProtein.getId().equals("")) {
                this.newNameString = "";
                newName = selectedProtein.getName();
                if (newName.equals("")) {
                    JOptionPane.showMessageDialog(this, "Name is void.\n Please input name.", "Warning", 2);
                    return;
                }
                i = 0;
                while ((long)i < this.listOfProteins.size()) {
                    sp = (Species)this.listOfProteins.get((long)i);
                    Protein p = sbModel.getProtein(sp.getId());
                    if (p.getName().equals(newName)) {
                        JOptionPane.showMessageDialog(this, "Same name already exists.\n Please change name.", "Warning", 2);
                        return;
                    }
                    ++i;
                }
                newProperty.setProtein(selectedProtein);
                this.newNameString = newName;
            } else {
                selectedOriginal = sbModel.getProtein(selectedProtein.getId());
                if (selectedOriginal == null) {
                    return;
                }
                newProperty.setProtein((Protein)selectedOriginal);
                isSelectedOriginal = true;
            }
        } else {
            newProperty.setProtein(null);
        }
        if (isGene) {
            Gene selectedGene = this.genePanel.getGene();
            if (selectedGene.getId().equals("")) {
                this.newNameString = "";
                newName = selectedGene.getName();
                if (newName.equals("")) {
                    JOptionPane.showMessageDialog(this, "Name is void.\n Please input name.", "Warning", 2);
                    return;
                }
                i = 0;
                while ((long)i < this.listOfGenes.size()) {
                    sp = (Species)this.listOfGenes.get((long)i);
                    Gene g = sbModel.getGene(sp.getId());
                    if (g.getName().equals(newName)) {
                        JOptionPane.showMessageDialog(this, "Same name already exists.\n Please change name.", "Warning", 2);
                        return;
                    }
                    ++i;
                }
                newProperty.setGene(selectedGene);
                this.newNameString = newName;
            } else {
                selectedOriginal = sbModel.getGene(selectedGene.getId());
                if (selectedOriginal == null) {
                    return;
                }
                newProperty.setGene((Gene)selectedOriginal);
                isSelectedOriginal = true;
            }
        } else {
            newProperty.setGene(null);
        }
        if (isRNA) {
            RNA selectedRNA = this.rnaPanel.getRNA();
            if (selectedRNA.getId().equals("")) {
                this.newNameString = "";
                newName = selectedRNA.getName();
                if (newName.equals("")) {
                    JOptionPane.showMessageDialog(this, "Name is void.\n Please input name.", "Warning", 2);
                    return;
                }
                i = 0;
                while ((long)i < this.listOfRNAs.size()) {
                    sp = (Species)this.listOfRNAs.get((long)i);
                    r = sbModel.getRNA(sp.getId());
                    if (r.getName().equals(newName)) {
                        JOptionPane.showMessageDialog(this, "Same name already exists.\n Please change name.", "Warning", 2);
                        return;
                    }
                    ++i;
                }
                newProperty.setRNA(selectedRNA);
                this.newNameString = newName;
            } else {
                selectedOriginal = sbModel.getRNA(selectedRNA.getId());
                if (selectedOriginal == null) {
                    return;
                }
                newProperty.setRNA((RNA)selectedOriginal);
                isSelectedOriginal = true;
            }
        } else {
            newProperty.setRNA(null);
        }
        if (isAntiSenseRNA) {
            AntiSenseRNA selectedAntiSenseRNA = this.antisensernaPanel.getAntiSenseRNA();
            if (selectedAntiSenseRNA.getId().equals("")) {
                this.newNameString = "";
                newName = selectedAntiSenseRNA.getName();
                if (newName.equals("")) {
                    JOptionPane.showMessageDialog(this, "Name is void.\n Please input name.", "Warning", 2);
                    return;
                }
                i = 0;
                while ((long)i < this.listOfAntiSenseRNAs.size()) {
                    sp = (Species)this.listOfAntiSenseRNAs.get((long)i);
                    r = sbModel.getAntiSenseRNA(sp.getId());
                    if (r.getName().equals(newName)) {
                        JOptionPane.showMessageDialog(this, "Same name already exists.\n Please change name.", "Warning", 2);
                        return;
                    }
                    ++i;
                }
                newProperty.setAntiSenseRNA(selectedAntiSenseRNA);
                this.newNameString = newName;
            } else {
                selectedOriginal = sbModel.getAntiSenseRNA(selectedAntiSenseRNA.getId());
                if (selectedOriginal == null) {
                    return;
                }
                newProperty.setAntiSenseRNA((AntiSenseRNA)selectedOriginal);
                isSelectedOriginal = true;
            }
        } else {
            newProperty.setAntiSenseRNA(null);
        }
        if (isProtein) {
            modifications = this.proteinPanel.getModifications();
            noEmpties = new Vector<Object>();
            i = 0;
            while (i < modifications.size()) {
                m = (Modification)modifications.elementAt(i);
                if (!m.getState().equals("empty")) {
                    noEmpties.add(m);
                }
                ++i;
            }
            newProperty.setModifications(noEmpties);
            Vector structuralStates = this.proteinPanel.getStructuralStates();
            noEmpties = new Vector();
            int i3 = 0;
            while (i3 < structuralStates.size()) {
                StructuralState s = (StructuralState)structuralStates.elementAt(i3);
                if (!s.getState().equals("empty")) {
                    noEmpties.add(s);
                }
                ++i3;
            }
            newProperty.setStructuralStates(noEmpties);
        } else if (isGene) {
            modifications = this.genePanel.getModifications();
            noEmpties = new Vector();
            i = 0;
            while (i < modifications.size()) {
                m = (Modification)modifications.elementAt(i);
                if (!m.getState().equals("empty")) {
                    noEmpties.add(m);
                }
                ++i;
            }
            newProperty.setModifications(noEmpties);
        } else if (isRNA) {
            modifications = this.rnaPanel.getModifications();
            noEmpties = new Vector();
            i = 0;
            while (i < modifications.size()) {
                m = (Modification)modifications.elementAt(i);
                if (!m.getState().equals("empty")) {
                    noEmpties.add(m);
                }
                ++i;
            }
            newProperty.setModifications(noEmpties);
        } else if (isAntiSenseRNA) {
            modifications = this.antisensernaPanel.getModifications();
            noEmpties = new Vector();
            i = 0;
            while (i < modifications.size()) {
                m = (Modification)modifications.elementAt(i);
                if (!m.getState().equals("empty")) {
                    noEmpties.add(m);
                }
                ++i;
            }
            newProperty.setModifications(noEmpties);
        } else {
            newProperty.setModifications(new Vector());
        }
        boolean toClose = super.notifyApply(newProperty, newautotag);
        if (toClose) {
            this.close_performed();
        }
        if ((lastInstance = MainWindow.getLastInstance()) != null && (target = lastInstance.getTargetControlPanelWindow()) != null) {
            target.processTableReload(false);
        }
        MainWindow.getLastInstance().SBaseChanged((SBase)this.getShowingSpecieAlias().getOriginalSpecies());
        isSelectedOriginal = false;
    }

    public void reset_performed() {
        this.updateDialog();
    }

    public void close_performed() {
        this.setVisible(false);
        this.editingProperty = null;
    }

    private void resetSpeciesNameField(String name, boolean isProtein, boolean isGene, boolean isRNA, boolean isAntiSenseRNA) {
        if (isProtein) {
            this.speciesNameField.setText("(equals the name of protein)");
            this.speciesNameField.setEnabled(false);
        } else if (isGene) {
            this.speciesNameField.setText("(equals the name of gene)");
            this.speciesNameField.setEnabled(false);
        } else if (isRNA) {
            this.speciesNameField.setText("(equals the name of RNA)");
            this.speciesNameField.setEnabled(false);
        } else if (isAntiSenseRNA) {
            this.speciesNameField.setText("(equals the name of antisense RNA)");
            this.speciesNameField.setEnabled(false);
        } else {
            this.speciesNameField.setText(name);
            this.speciesNameField.setEnabled(true);
        }
    }

    private void resetProteinRefCombo(boolean isProtein) {
        this.proteinRefCombo.setSelectedItem(NEW_PROTEIN_LABEL);
        this.proteinRefCombo.setEnabled(isProtein);
    }

    private void resetGeneRefCombo(boolean isGene) {
        this.geneRefCombo.setSelectedItem(NEW_GENE_LABEL);
        this.geneRefCombo.setEnabled(isGene);
    }

    private void resetRNARefCombo(boolean isRNA) {
        this.rnaRefCombo.setSelectedItem(NEW_RNA_LABEL);
        this.rnaRefCombo.setEnabled(isRNA);
    }

    private void resetAntiSenseRNARefCombo(boolean isAntiSenseRNA) {
        this.antisensernaRefCombo.setSelectedItem(NEW_ANTISENSERNA_LABEL);
        this.antisensernaRefCombo.setEnabled(isAntiSenseRNA);
    }

    private void resetStateCombo(boolean dummy) {
        String currentType = "";
        try {
            currentType = (String)this.typeCombo.getSelectedItem();
            if (currentType == null) {
                return;
            }
        }
        catch (Exception myErr) {
            return;
        }
        boolean isProtein = currentType.equals("PROTEIN");
        boolean isGene = currentType.equals("GENE");
        if (isProtein || isGene) {
            String[] specific_item = isProtein ? this.STATE_PROTEIN_SPECIFIC : this.STATE_GENE_SPECIFIC;
            this.stateCombo.removeAllItems();
            int i = 0;
            while (i < specific_item.length) {
                this.stateCombo.addItem(specific_item[i]);
                ++i;
            }
        }
        this.selected = null;
        this.stateCombo.setSelectedItem("empty");
        this.stateCombo.setEnabled(false);
        this.structuralStateCombo.setSelectedItem("empty");
    }

    private void typeCombo_performed() {
        String currentType = "";
        try {
            currentType = (String)this.typeCombo.getSelectedItem();
            if (currentType == null) {
                return;
            }
        }
        catch (Exception myErr) {
            return;
        }
        if (currentType.equals("")) {
            return;
        }
        if (this.typeCombo.getItemCount() <= 1) {
            return;
        }
        boolean isProtein = currentType.equals("PROTEIN");
        boolean isGene = currentType.equals("GENE");
        boolean isRNA = currentType.equals("RNA");
        boolean isAntiSenseRNA = currentType.equals("ANTISENSE_RNA");
        boolean isPrevNonBiomolecule = !this.isPrevProtein && !this.isPrevGene && !this.isPrevRNA && !this.isPrevAntiSenseRNA;
        boolean isNonBiomolecule = !isProtein && !isGene && !isRNA && !isAntiSenseRNA;
        String name = "";
        if (!(this.isPrevProtein && isProtein || this.isPrevGene && isGene || this.isPrevRNA && isRNA || this.isPrevAntiSenseRNA && isAntiSenseRNA || isPrevNonBiomolecule && isNonBiomolecule || isPrevNonBiomolecule || !isNonBiomolecule)) {
            Species p = null;
            if (this.isPrevProtein) {
                p = this.proteinPanel.getProtein();
            } else if (this.isPrevGene) {
                p = this.genePanel.getGene();
            } else if (this.isPrevRNA) {
                p = this.rnaPanel.getRNA();
            } else if (this.isPrevAntiSenseRNA) {
                p = this.antisensernaPanel.getAntiSenseRNA();
            }
            if (p != null) {
                name = ((Biomolecule)p).getName();
            }
        }
        this.resetSpeciesNameField(name, isProtein, isGene, isRNA, isAntiSenseRNA);
        this.resetProteinRefCombo(isProtein);
        this.resetGeneRefCombo(isGene);
        this.resetRNARefCombo(isRNA);
        this.resetAntiSenseRNARefCombo(isAntiSenseRNA);
        this.proteinPanel.setEnabled(isProtein);
        this.genePanel.setEnabled(isGene);
        this.rnaPanel.setEnabled(isRNA);
        this.antisensernaPanel.setEnabled(isAntiSenseRNA);
        this.peditPanel.setVisible(isProtein);
        this.geditPanel.setVisible(isGene);
        this.reditPanel.setVisible(isRNA);
        this.asreditPanel.setVisible(isAntiSenseRNA);
        this.resetStateCombo(false);
        if (isProtein) {
            this.structuralStateCombo.setEnabled(true);
        } else {
            this.inputTextField.setText("");
            this.inputTextField.setEnabled(false);
            this.structuralStateCombo.setSelectedIndex(0);
            this.structuralStateCombo.setEnabled(false);
        }
        this.isPrevProtein = isProtein;
        this.isPrevGene = isGene;
        this.isPrevRNA = isRNA;
        this.isPrevAntiSenseRNA = isAntiSenseRNA;
        this.changeLayout();
        this.repaint();
    }

    private void proteinRefCombo_performed() {
        String name = (String)this.proteinRefCombo.getSelectedItem();
        if (name == null) {
            return;
        }
        SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
        Protein selectedProtein = null;
        if (name.equals(NEW_PROTEIN_LABEL)) {
            selectedProtein = new Protein();
            selectedProtein.setType(null);
            this.proteinPanel.setEditable(true);
        } else {
            if (this.isShowing()) {
                this.showCaution();
            }
            int i = 0;
            while ((long)i < this.listOfProteins.size()) {
                Species s = (Species)this.listOfProteins.get((long)i);
                Protein p = sbModel.getProtein(s.getId());
                if (p.getName().equals(name)) {
                    selectedProtein = p.deepClone();
                }
                ++i;
            }
            this.proteinPanel.setEditable(false);
        }
        this.proteinPanel.setProtein(selectedProtein);
        this.resetStateCombo(true);
    }

    private void stateCombo_performed() {
        if (this.selected != null && this.selected.getModification() != null) {
            String state = (String)this.stateCombo.getSelectedItem();
            this.selected.getModification().setState(state);
            this.repaint();
        }
    }

    public ProteinPanel getProteinPanel() {
        return this.proteinPanel;
    }

    private void structuralStateCombo_performed() {
        String type = "";
        try {
            type = (String)this.typeCombo.getSelectedItem();
            if (type == null) {
                type = "";
            }
        }
        catch (Exception myErr) {
            type = "";
        }
        if (!"PROTEIN".equals(type) && !"COMPLEX".equals(type)) {
            return;
        }
        String state = (String)this.structuralStateCombo.getSelectedItem();
        if ("user defined text".equals(state)) {
            this.inputTextField.setEnabled(true);
            state = this.inputTextField.getText();
        } else {
            this.inputTextField.setText("");
            this.inputTextField.setEnabled(false);
        }
        StructuralState structuralState = new StructuralState();
        structuralState.setState(state);
        if ("PROTEIN".equals(type) && this.proteinPanel != null) {
            this.setAngleFromStructuralState(this.proteinPanel.getStructuralStates(), structuralState);
        } else if ("COMPLEX".equals(type) && this.complexPanel != null) {
            this.setAngleFromStructuralState(this.complexPanel.getStructuralStates(), structuralState);
        }
        this.resetStructuralState(type, structuralState);
        this.repaint();
    }

    private void setAngleFromStructuralState(Vector vctStruState, StructuralState structuralState) {
        if (vctStruState.size() > 0) {
            StructuralState struState = (StructuralState)vctStruState.get(0);
            structuralState.setAngle(struState.getAngle());
        }
    }

    private void resetStructuralState(String type, StructuralState structuralState) {
        ModificationShape mShape = new ModificationShape();
        mShape.setStructuralState(structuralState);
        Vector<ModificationShape> structuralStateShapes = new Vector<ModificationShape>();
        structuralStateShapes.add(mShape);
        if ("PROTEIN".equals(type)) {
            this.proteinPanel.setStructuralStateShapes(structuralStateShapes);
            this.proteinPanel.getStructuralStates().clear();
            this.proteinPanel.getStructuralStates().add(structuralState);
        } else if ("COMPLEX".equals(type)) {
            this.complexPanel.setStructuralStateShapes(structuralStateShapes);
            this.complexPanel.getStructuralStates().clear();
            this.complexPanel.getStructuralStates().add(structuralState);
        }
    }

    @Override
    public void mShapeSelected(ModificationShape mShape) {
        this.selected = mShape;
        Modification m = mShape.getModification();
        if (m == null) {
            return;
        }
        this.stateCombo.setSelectedItem(m.getState());
        this.stateCombo.setEnabled(true);
        if (this.selected.getModificationResidue() == null) {
            this.stateCombo.setEnabled(false);
        }
        if (this.selected.getModificationRegion() != null && this.selected.getModificationRegion().getType().equals("Modification Site")) {
            this.stateCombo.setEnabled(true);
        }
    }

    @Override
    public void mShapeDeselected(ModificationShape mShape) {
        this.selected = null;
        this.stateCombo.setSelectedItem("empty");
        this.stateCombo.setEnabled(false);
    }

    @Override
    public void panelStateChanged() {
        this.rootPane.setDefaultButton(this.applyButton);
    }

    private void geneRefCombo_performed() {
        String name = (String)this.geneRefCombo.getSelectedItem();
        if (name == null) {
            return;
        }
        Gene selectedGene = null;
        if (name.equals(NEW_GENE_LABEL)) {
            selectedGene = new Gene();
            selectedGene.setType(null);
            this.genePanel.setEditable(true);
        } else {
            if (this.isShowing()) {
                this.showCaution();
            }
            SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            int i = 0;
            while ((long)i < this.listOfGenes.size()) {
                Species sp = (Species)this.listOfGenes.get((long)i);
                Gene p = sbModel.getGene(sp.getId());
                if (p.getName().equals(name)) {
                    selectedGene = p.deepClone();
                }
                ++i;
            }
            this.genePanel.setEditable(false);
        }
        this.genePanel.setGene(selectedGene);
        this.resetStateCombo(true);
    }

    private void rnaRefCombo_performed() {
        String name = (String)this.rnaRefCombo.getSelectedItem();
        if (name == null) {
            return;
        }
        RNA selectedRNA = null;
        if (name.equals(NEW_RNA_LABEL)) {
            selectedRNA = new RNA();
            selectedRNA.setType(null);
            this.rnaPanel.setEditable(true);
        } else {
            if (this.isShowing()) {
                this.showCaution();
            }
            SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            int i = 0;
            while ((long)i < this.listOfRNAs.size()) {
                Species sp = (Species)this.listOfRNAs.get((long)i);
                RNA p = sbModel.getRNA(sp.getId());
                if (p.getName().equals(name)) {
                    selectedRNA = p.deepClone();
                }
                ++i;
            }
            this.rnaPanel.setEditable(false);
        }
        this.rnaPanel.setRNA(selectedRNA);
        this.resetStateCombo(true);
    }

    private void antisensernaRefCombo_performed() {
        String name = (String)this.antisensernaRefCombo.getSelectedItem();
        if (name == null) {
            return;
        }
        AntiSenseRNA selectedAntiSenseRNA = null;
        if (name.equals(NEW_ANTISENSERNA_LABEL)) {
            selectedAntiSenseRNA = new AntiSenseRNA();
            selectedAntiSenseRNA.setType(null);
            this.antisensernaPanel.setEditable(true);
        } else {
            if (this.isShowing()) {
                this.showCaution();
            }
            SBModel sbModel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
            int i = 0;
            while ((long)i < this.listOfAntiSenseRNAs.size()) {
                Species sp = (Species)this.listOfAntiSenseRNAs.get((long)i);
                AntiSenseRNA p = sbModel.getAntiSenseRNA(sp.getId());
                if (p.getName().equals(name)) {
                    selectedAntiSenseRNA = p.deepClone();
                }
                ++i;
            }
            this.antisensernaPanel.setEditable(false);
        }
        this.antisensernaPanel.setAntiSenseRNA(selectedAntiSenseRNA);
        this.resetStateCombo(true);
    }

    private void showCaution() {
        if (!Preference.showPDCaution) {
            return;
        }
        String msg = "To add/edit/remove residues, please use the dialog to appear\n";
        msg = String.valueOf(msg) + "by double-clicking a line in the \"Proteins\" list.\n";
        msg = String.valueOf(msg) + "All you can do about protein residues on this dialog is to change\n";
        msg = String.valueOf(msg) + "their modification states, except when assigning [New Protein].\n";
        int ans = JOptionPane.showOptionDialog(this, msg, "Residues Caution", 0, 1, null, new Object[]{"Never show this", "Close"}, "Close");
        if (ans == 0) {
            Preference.showPDCaution = false;
        }
    }

    private void changeLayout() {
        boolean isVisible;
        String type = "";
        try {
            type = (String)this.typeCombo.getSelectedItem();
            if (type == null) {
                type = "";
            }
        }
        catch (Exception myErr) {
            type = "";
        }
        boolean bl = isVisible = type.equals("PROTEIN") || type.equals("GENE") || type.equals("RNA") || type.equals("ANTISENSE_RNA") || type.equals("COMPLEX");
        if (isVisible) {
            if (type.equals("COMPLEX")) {
                this.setSize(this.getSize().width, 390);
            } else {
                this.setSize(this.getSize().width, 465);
            }
        } else {
            this.setSize(this.getSize().width, 261);
        }
        if (isVisible == this.isEditPanelVisible) {
            return;
        }
        Component[] components = this.panel.getComponents();
        int size = this.panel.getComponentCount();
        int i = 0;
        while (i < size) {
            Component c = components[i];
            if (c.getY() >= this.peditPanel.getY() && c != this.peditPanel && c != this.geditPanel && c != this.reditPanel && c != this.asreditPanel && c != this.ceditPanel) {
                if (isVisible) {
                    if (type.equals("COMPLEX")) {
                        c.setBounds(c.getX(), c.getY() + this.ceditPanel.getHeight() + 12, c.getWidth(), c.getHeight());
                    } else {
                        c.setBounds(c.getX(), c.getY() + this.peditPanel.getHeight() + 12, c.getWidth(), c.getHeight());
                    }
                } else {
                    c.setBounds(c.getX(), c.getY() - this.peditPanel.getHeight() - 12, c.getWidth(), c.getHeight());
                }
            }
            ++i;
        }
        this.isEditPanelVisible = isVisible;
    }

    private class MyComponentListener
    extends ComponentAdapter {
        private MyComponentListener() {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            String name;
            boolean isProtein;
            if (!MonoSpeciesPropertyDialog.this.typeCombo.isEnabled()) {
                return;
            }
            String currentType = "";
            try {
                currentType = (String)MonoSpeciesPropertyDialog.this.typeCombo.getSelectedItem();
                if (currentType == null) {
                    currentType = "";
                }
            }
            catch (Exception myErr) {
                currentType = "";
            }
            if (currentType.length() > 0 && (isProtein = currentType.equals("PROTEIN")) && !(name = (String)MonoSpeciesPropertyDialog.this.proteinRefCombo.getSelectedItem()).equals(MonoSpeciesPropertyDialog.NEW_PROTEIN_LABEL)) {
                MonoSpeciesPropertyDialog.this.showCaution();
            }
        }
    }
}

