/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.util.Vector;
import jp.co.mki.celldesigner.simulation.util.StringTool;
import jp.sbi.celldesigner.SBFactory;
import jp.sbi.celldesigner.SpeciesProperty;
import jp.sbi.celldesigner.sbmlExtension.AntiSenseRNA;
import jp.sbi.celldesigner.sbmlExtension.Gene;
import jp.sbi.celldesigner.sbmlExtension.ModelAnnotation;
import jp.sbi.celldesigner.sbmlExtension.Modification;
import jp.sbi.celldesigner.sbmlExtension.Protein;
import jp.sbi.celldesigner.sbmlExtension.RNA;
import jp.sbi.celldesigner.sbmlExtension.StructuralState;
import jp.sbi.celldesigner.symbol.species.Tag;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MonoSpeciesProperty
implements SpeciesProperty {
    protected String type = "";
    protected String name = "";
    protected int homodimer = 1;
    protected boolean hypothetical = false;
    private Protein protein = null;
    private Vector modifications = new Vector();
    protected Vector structuralStates = new Vector();
    private Gene gene = null;
    private RNA rna = null;
    private AntiSenseRNA antisenserna = null;
    protected String monoDirect = "";
    private String readingSomeId = "";

    public void setMonoDirect(Object obj, String direct) {
        if (obj == null) {
            return;
        }
        if (direct == null) {
            return;
        }
        if (obj instanceof Tag && !Tag.AllAagDirect.contains(direct)) {
            return;
        }
        this.monoDirect = direct;
    }

    private void setMonoDirect(String direct) {
        this.monoDirect = direct;
    }

    public String getMonoDirect() {
        return this.monoDirect;
    }

    public String toString() {
        return this.type + "," + this.name + "," + this.homodimer + "," + this.hypothetical + "," + "protein=" + this.protein;
    }

    public void setType(String type) {
        this.type = SBFactory.filterSynonym(type);
    }

    public String getType() {
        return this.type;
    }

    public String getExtensionType() {
        if (this.protein != null) {
            return this.protein.getType();
        }
        if (this.rna != null) {
            return this.rna.getType();
        }
        if (this.gene != null) {
            return this.gene.getType();
        }
        if (this.antisenserna != null) {
            return this.antisenserna.getType();
        }
        return this.type;
    }

    public String getExtensionId() {
        if (this.protein != null) {
            return this.protein.getId();
        }
        if (this.rna != null) {
            return this.rna.getId();
        }
        if (this.gene != null) {
            return this.gene.getId();
        }
        if (this.antisenserna != null) {
            return this.antisenserna.getId();
        }
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setHomodimer(int homodimer) {
        this.homodimer = homodimer;
    }

    public int getHomodimer() {
        return this.homodimer;
    }

    public void setHypothetical(boolean hypothetical) {
        this.hypothetical = hypothetical;
    }

    public boolean getHypothetical() {
        return this.hypothetical;
    }

    public void setProtein(Protein protein) {
        this.protein = protein;
        if (protein != null) {
            this.name = protein.getName();
        }
    }

    public Protein getProtein() {
        return this.protein;
    }

    public void setGene(Gene gene) {
        this.gene = gene;
        if (gene != null) {
            this.name = gene.getName();
        }
    }

    public Gene getGene() {
        return this.gene;
    }

    public void setRNA(RNA rna) {
        this.rna = rna;
        if (rna != null) {
            this.name = rna.getName();
        }
    }

    public RNA getRNA() {
        return this.rna;
    }

    public void setAntiSenseRNA(AntiSenseRNA antisenserna) {
        this.antisenserna = antisenserna;
        if (antisenserna != null) {
            this.name = antisenserna.getName();
        }
    }

    public AntiSenseRNA getAntiSenseRNA() {
        return this.antisenserna;
    }

    public void setModifications(Vector modifications) {
        this.modifications = modifications;
    }

    public Vector getModifications() {
        return this.modifications;
    }

    public void setStructuralStates(Vector structuralStates) {
        this.structuralStates = structuralStates;
    }

    public Vector getStructuralStates() {
        return this.structuralStates;
    }

    @Override
    public SpeciesProperty deepClone() {
        MonoSpeciesProperty property = new MonoSpeciesProperty();
        property.setType(this.type);
        property.setName(this.name);
        property.setHomodimer(this.homodimer);
        property.setHypothetical(this.hypothetical);
        property.setMonoDirect(this.monoDirect);
        property.setProtein(this.protein);
        property.setGene(this.gene);
        property.setRNA(this.rna);
        property.setAntiSenseRNA(this.antisenserna);
        Vector<Object> v = new Vector<Object>();
        int i = 0;
        while (i < this.modifications.size()) {
            Modification m = (Modification)this.modifications.elementAt(i);
            Modification m2 = (Modification)m.clone();
            v.add(m2);
            ++i;
        }
        property.setModifications(v);
        v = new Vector();
        i = 0;
        while (i < this.structuralStates.size()) {
            StructuralState s = (StructuralState)this.structuralStates.elementAt(i);
            StructuralState s2 = (StructuralState)s.clone();
            v.add(s2);
            ++i;
        }
        property.setStructuralStates(v);
        return property;
    }

    @Override
    public boolean equals(SpeciesProperty property) {
        Object m2;
        Object m1;
        Object m;
        if (!(property instanceof MonoSpeciesProperty)) {
            return false;
        }
        MonoSpeciesProperty target = (MonoSpeciesProperty)property;
        if (!target.getType().equals(this.type)) {
            return false;
        }
        if (!target.getName().equals(this.name)) {
            return false;
        }
        if (target.getHomodimer() != this.homodimer) {
            return false;
        }
        if (target.getHypothetical() != this.hypothetical) {
            return false;
        }
        if (target.getProtein() == null && this.protein != null) {
            return false;
        }
        if (target.getProtein() != null && this.protein == null) {
            return false;
        }
        if (target.getGene() == null && this.gene != null) {
            return false;
        }
        if (target.getGene() != null && this.gene == null) {
            return false;
        }
        if (target.getRNA() == null && this.rna != null) {
            return false;
        }
        if (target.getRNA() != null && this.rna == null) {
            return false;
        }
        if (target.getAntiSenseRNA() == null && this.antisenserna != null) {
            return false;
        }
        if (target.getAntiSenseRNA() != null && this.antisenserna == null) {
            return false;
        }
        if (target.getProtein() != null && this.protein != null && !target.getProtein().getName().equals(this.protein.getName())) {
            return false;
        }
        if (target.getGene() != null && this.gene != null && !target.getGene().getName().equals(this.gene.getName())) {
            return false;
        }
        if (target.getRNA() != null && this.rna != null && !target.getRNA().getName().equals(this.rna.getName())) {
            return false;
        }
        if (target.getAntiSenseRNA() != null && this.antisenserna != null && !target.getAntiSenseRNA().getName().equals(this.antisenserna.getName())) {
            return false;
        }
        Vector targetModifications = target.getModifications();
        Vector<Object> realModifications1 = new Vector<Object>();
        int i = 0;
        while (i < targetModifications.size()) {
            Modification m3 = (Modification)targetModifications.elementAt(i);
            if (!m3.getState().equals("empty")) {
                realModifications1.add(m3);
            }
            ++i;
        }
        Vector<Object> realModifications2 = new Vector<Object>();
        int i2 = 0;
        while (i2 < this.modifications.size()) {
            m = (Modification)this.modifications.elementAt(i2);
            if (!((Modification)m).getState().equals("empty")) {
                realModifications2.add(m);
            }
            ++i2;
        }
        if (realModifications1.size() != realModifications2.size()) {
            return false;
        }
        i2 = 0;
        while (i2 < realModifications1.size()) {
            m1 = (Modification)realModifications1.elementAt(i2);
            m2 = null;
            int k = 0;
            while (k < realModifications2.size()) {
                Modification m4 = (Modification)realModifications2.elementAt(k);
                if (m4.equals((Modification)m1)) {
                    m2 = m4;
                    break;
                }
                ++k;
            }
            if (m2 == null) {
                return false;
            }
            ++i2;
        }
        targetModifications = target.getStructuralStates();
        realModifications1 = new Vector();
        i2 = 0;
        while (i2 < targetModifications.size()) {
            m = (StructuralState)targetModifications.elementAt(i2);
            if (!((StructuralState)m).getState().equals("empty")) {
                realModifications1.add(m);
            }
            ++i2;
        }
        realModifications2 = new Vector();
        i2 = 0;
        while (i2 < this.structuralStates.size()) {
            m = (StructuralState)this.structuralStates.elementAt(i2);
            if (!((StructuralState)m).getState().equals("empty")) {
                realModifications2.add(m);
            }
            ++i2;
        }
        if (realModifications1.size() != realModifications2.size()) {
            return false;
        }
        i2 = 0;
        while (i2 < realModifications1.size()) {
            m1 = (StructuralState)realModifications1.elementAt(i2);
            if (!((StructuralState)m1).equals((StructuralState)(m2 = (StructuralState)realModifications2.elementAt(i2)))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public boolean resetModificationsSize() {
        int prevSize = this.modifications.size();
        if (this.protein == null) {
            this.modifications.clear();
        } else {
            int rSize;
            int mSize = this.modifications.size();
            if (mSize > (rSize = this.protein.getListOfModificationResidues().size())) {
                this.modifications.setSize(rSize);
            }
        }
        int afterSize = this.modifications.size();
        return afterSize < prevSize;
    }

    public boolean resetStructuralStatesSize() {
        int prevSize = this.structuralStates.size();
        if (this.protein == null) {
            this.structuralStates.clear();
        } else {
            int rSize;
            int mSize = this.structuralStates.size();
            if (mSize > (rSize = this.protein.getListOfStructuralStates().size())) {
                this.structuralStates.setSize(rSize);
            }
        }
        int afterSize = this.structuralStates.size();
        return afterSize < prevSize;
    }

    public boolean resetModificationsTranscriptionsSize() {
        int afterSize;
        int mSize;
        int prevSize = this.modifications.size();
        if (this.gene != null) {
            int rSize;
            mSize = this.modifications.size();
            if (mSize > (rSize = this.gene.getListOfRegions().size())) {
                this.modifications.setSize(rSize);
            }
        } else if (this.rna != null) {
            int rSize;
            mSize = this.modifications.size();
            if (mSize > (rSize = this.rna.getListOfRegions().size())) {
                this.modifications.setSize(rSize);
            }
        } else if (this.antisenserna != null) {
            int rSize;
            mSize = this.modifications.size();
            if (mSize > (rSize = this.antisenserna.getListOfRegions().size())) {
                this.modifications.setSize(rSize);
            }
        } else {
            this.modifications.clear();
        }
        return (afterSize = this.modifications.size()) < prevSize;
    }

    @Override
    public void readDOMTree(Element element) {
        NodeList childlist = element.getChildNodes();
        int childsize = childlist.getLength();
        int i = 0;
        while (i < childsize) {
            Node node = childlist.item(i);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                String str;
                Element elem = (Element)node;
                String tag = elem.getLocalName();
                if (tag.equals("class")) {
                    str = elem.getFirstChild().getNodeValue();
                    this.setType(SBFactory.filterSynonym(str));
                } else if (tag.equals("name")) {
                    str = elem.getFirstChild().getNodeValue();
                    this.setName(str);
                } else if (tag.equals("hypothetical")) {
                    str = elem.getFirstChild().getNodeValue();
                    boolean b = Boolean.valueOf(str);
                    this.setHypothetical(b);
                } else if (tag.equals("proteinReference")) {
                    this.readingSomeId = elem.getFirstChild().getNodeValue();
                } else if (tag.equals("geneReference")) {
                    this.readingSomeId = elem.getFirstChild().getNodeValue();
                } else if (tag.equals("rnaReference")) {
                    this.readingSomeId = elem.getFirstChild().getNodeValue();
                } else if (tag.equals("antisensernaReference")) {
                    this.readingSomeId = elem.getFirstChild().getNodeValue();
                } else if (tag.equals("state")) {
                    NodeList grandchild = elem.getChildNodes();
                    int grandchildsize = grandchild.getLength();
                    int j = 0;
                    while (j < grandchildsize) {
                        Node gnode = grandchild.item(j);
                        if (gnode.getNodeType() == 1 && gnode.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner")) {
                            Element ggelem;
                            Node ggnode;
                            int k;
                            int ggchildsize;
                            NodeList grandgrandchild;
                            if (gnode.getLocalName().equals("homodimer")) {
                                String str2 = gnode.getFirstChild().getNodeValue();
                                try {
                                    int homodimer = Integer.parseInt(str2);
                                    if (homodimer > 1) {
                                        this.setHomodimer(homodimer);
                                    }
                                }
                                catch (Exception homodimer) {}
                            } else if (gnode.getLocalName().equals("listOfModification") || gnode.getLocalName().equals("listOfModifications")) {
                                grandgrandchild = gnode.getChildNodes();
                                ggchildsize = grandgrandchild.getLength();
                                k = 0;
                                while (k < ggchildsize) {
                                    ggnode = grandgrandchild.item(k);
                                    if (ggnode.getNodeType() == 1 && ggnode.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && ggnode.getLocalName().equals("modification")) {
                                        String state;
                                        ggelem = (Element)ggnode;
                                        Modification m = new Modification();
                                        String residue = ggelem.getAttributeNS(null, "residue");
                                        if (!residue.equals("")) {
                                            m.setResidue(residue);
                                        }
                                        if (!(state = ggelem.getAttributeNS(null, "state")).equals("")) {
                                            if (state.trim().toLowerCase().startsWith("histon")) {
                                                m.setState("empty");
                                            } else {
                                                m.setState(state);
                                            }
                                        }
                                        this.modifications.add(m);
                                    }
                                    ++k;
                                }
                            } else if (gnode.getLocalName().equals("listOfStructuralState") || gnode.getLocalName().equals("listOfStructuralStates")) {
                                grandgrandchild = gnode.getChildNodes();
                                ggchildsize = grandgrandchild.getLength();
                                k = 0;
                                while (k < ggchildsize) {
                                    ggnode = grandgrandchild.item(k);
                                    if (ggnode.getNodeType() == 1 && ggnode.getNamespaceURI().equals("http://www.sbml.org/2001/ns/celldesigner") && ggnode.getLocalName().equals("structuralState")) {
                                        ggelem = (Element)ggnode;
                                        StructuralState s = new StructuralState();
                                        String state = ggelem.getAttributeNS(null, "structuralState");
                                        s.setState(state);
                                        this.structuralStates.add(s);
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public String getReadingSomeId() {
        return this.readingSomeId;
    }

    public void clearReadingSomeId() {
        this.readingSomeId = "";
    }

    public void setReadingSomeId(String id) {
        this.readingSomeId = id;
    }

    @Override
    public void writeDOMTree(Node node) {
        Element melem;
        Object m;
        int i;
        Element listelem;
        Element pelem;
        Document doc = node.getOwnerDocument();
        String URI2 = node.getNamespaceURI();
        String ns = ModelAnnotation.getOutputNamespace();
        Element celem = doc.createElementNS(URI2, String.valueOf(ns) + ":class");
        node.appendChild(celem);
        celem.appendChild(doc.createTextNode(this.type));
        if (this.hypothetical) {
            Element helem = doc.createElementNS(URI2, String.valueOf(ns) + ":hypothetical");
            node.appendChild(helem);
            helem.appendChild(doc.createTextNode(Boolean.toString(this.hypothetical)));
        }
        if (!(this.type.equals("PROTEIN") || this.type.equals("GENE") || this.type.equals("RNA") || this.type.equals("ANTISENSE_RNA"))) {
            Element nelem = doc.createElementNS(URI2, String.valueOf(ns) + ":name");
            node.appendChild(nelem);
            nelem.appendChild(doc.createTextNode(this.name));
        }
        if (this.type.equals("PROTEIN")) {
            String proteinId = "";
            if (this.protein != null) {
                proteinId = this.protein.getId();
            }
            pelem = doc.createElementNS(URI2, String.valueOf(ns) + ":proteinReference");
            node.appendChild(pelem);
            pelem.appendChild(doc.createTextNode(proteinId));
        }
        if (this.type.equals("GENE")) {
            String geneId = "";
            if (this.gene != null) {
                geneId = this.gene.getId();
            }
            pelem = doc.createElementNS(URI2, String.valueOf(ns) + ":geneReference");
            node.appendChild(pelem);
            pelem.appendChild(doc.createTextNode(geneId));
        }
        if (this.type.equals("RNA")) {
            String rnaId = "";
            if (this.rna != null) {
                rnaId = this.rna.getId();
            }
            pelem = doc.createElementNS(URI2, String.valueOf(ns) + ":rnaReference");
            node.appendChild(pelem);
            pelem.appendChild(doc.createTextNode(rnaId));
        }
        if (this.type.equals("ANTISENSE_RNA")) {
            String antisensernaId = "";
            if (this.antisenserna != null) {
                antisensernaId = this.antisenserna.getId();
            }
            pelem = doc.createElementNS(URI2, String.valueOf(ns) + ":antisensernaReference");
            node.appendChild(pelem);
            pelem.appendChild(doc.createTextNode(antisensernaId));
        }
        boolean hasState = false;
        if (this.homodimer > 1) {
            hasState = true;
        } else if (this.type.equals("PROTEIN") && this.modifications.size() > 0) {
            hasState = true;
        } else if (this.type.equals("GENE") && this.modifications.size() > 0) {
            hasState = true;
        } else if (this.type.equals("RNA") && this.modifications.size() > 0) {
            hasState = true;
        } else if (this.type.equals("ANTISENSE_RNA") && this.modifications.size() > 0) {
            hasState = true;
        }
        if (!hasState) {
            return;
        }
        Element selem = doc.createElementNS(URI2, String.valueOf(ns) + ":state");
        node.appendChild(selem);
        if (this.homodimer > 1) {
            Element homo = doc.createElementNS(URI2, String.valueOf(ns) + ":homodimer");
            selem.appendChild(homo);
            homo.appendChild(doc.createTextNode(Integer.toString(this.homodimer)));
        }
        if (this.type.equals("PROTEIN")) {
            if (this.modifications.size() > 0) {
                listelem = doc.createElementNS(URI2, String.valueOf(ns) + ":listOfModifications");
                selem.appendChild(listelem);
                i = 0;
                while (i < this.modifications.size()) {
                    m = (Modification)this.modifications.elementAt(i);
                    melem = doc.createElementNS(URI2, String.valueOf(ns) + ":modification");
                    listelem.appendChild(melem);
                    melem.setAttributeNS(null, "residue", ((Modification)m).getResidue());
                    melem.setAttributeNS(null, "state", ((Modification)m).getState());
                    ++i;
                }
            }
            if (this.structuralStates.size() > 0) {
                listelem = doc.createElementNS(URI2, String.valueOf(ns) + ":listOfStructuralStates");
                selem.appendChild(listelem);
                i = 0;
                while (i < this.structuralStates.size()) {
                    m = (StructuralState)this.modifications.elementAt(i);
                    melem = doc.createElementNS(URI2, String.valueOf(ns) + ":structuralState");
                    listelem.appendChild(melem);
                    melem.setAttributeNS(null, "structuralState", ((StructuralState)m).getState());
                    ++i;
                }
            }
        }
        if ((this.type.equals("GENE") || this.type.equals("RNA") || this.type.equals("ANTISENSE_RNA")) && this.modifications.size() > 0) {
            listelem = doc.createElementNS(URI2, String.valueOf(ns) + ":listOfModifications");
            selem.appendChild(listelem);
            i = 0;
            while (i < this.modifications.size()) {
                m = (Modification)this.modifications.elementAt(i);
                melem = doc.createElementNS(URI2, String.valueOf(ns) + ":modification");
                listelem.appendChild(melem);
                melem.setAttributeNS(null, "residue", ((Modification)m).getResidue());
                melem.setAttributeNS(null, "state", ((Modification)m).getState());
                ++i;
            }
        }
    }

    public Modification findModification(String residue) {
        Modification modification = null;
        int i = 0;
        while (i < this.modifications.size()) {
            String id = ((Modification)this.modifications.get(i)).getResidue();
            if (residue.equals(id)) {
                modification = (Modification)this.modifications.get(i);
                break;
            }
            ++i;
        }
        return modification;
    }

    public void updateAnnotation(StringBuffer buf) {
        StructuralState s;
        Modification mod;
        int k;
        buf.append("<celldesigner:speciesIdentity>\n");
        buf.append("<celldesigner:class>" + this.getType() + "</celldesigner:" + "class" + ">\n");
        if (this.getHypothetical()) {
            buf.append("<celldesigner:hypothetical>" + this.getHypothetical() + "</celldesigner:" + "hypothetical" + ">\n");
        }
        if (!(this.type.equals("PROTEIN") || this.type.equals("GENE") || this.type.equals("RNA") || this.type.equals("ANTISENSE_RNA"))) {
            buf.append("<celldesigner:name>" + StringTool.toEscape(this.getName()) + "</celldesigner:" + "name>\n");
        }
        if (this.type.equals("PROTEIN")) {
            String proteinId = "";
            if (this.getProtein() != null) {
                proteinId = this.getProtein().getId();
            }
            buf.append("<celldesigner:proteinReference>" + proteinId + "</celldesigner:" + "proteinReference" + ">\n");
        }
        if (this.type.equals("GENE")) {
            String geneId = "";
            if (this.getGene() != null) {
                geneId = this.getGene().getId();
            }
            buf.append("<celldesigner:geneReference>" + geneId + "</celldesigner:" + "geneReference" + ">\n");
        }
        if (this.type.equals("RNA")) {
            String rnaId = "";
            if (this.getRNA() != null) {
                rnaId = this.getRNA().getId();
            }
            buf.append("<celldesigner:rnaReference>" + rnaId + "</celldesigner:" + "rnaReference" + ">\n");
        }
        if (this.type.equals("ANTISENSE_RNA")) {
            String antisensernaId = "";
            if (this.getAntiSenseRNA() != null) {
                antisensernaId = this.getAntiSenseRNA().getId();
            }
            buf.append("<celldesigner:antisensernaReference>" + antisensernaId + "</celldesigner:" + "antisensernaReference" + ">\n");
        }
        boolean hasState = false;
        if (this.homodimer > 1) {
            hasState = true;
        } else if (this.type.equals("PROTEIN") && this.modifications.size() > 0) {
            hasState = true;
        } else if (this.type.equals("PROTEIN") && this.structuralStates.size() > 0) {
            hasState = true;
        } else if (this.type.equals("COMPLEX") && this.structuralStates.size() > 0) {
            hasState = true;
        } else if (this.type.equals("GENE") && this.modifications.size() > 0) {
            hasState = true;
        } else if (this.type.equals("RNA") && this.modifications.size() > 0) {
            hasState = true;
        } else if (this.type.equals("ANTISENSE_RNA") && this.modifications.size() > 0) {
            hasState = true;
        }
        if (!hasState) {
            buf.append("</celldesigner:speciesIdentity>\n");
            return;
        }
        buf.append("<celldesigner:state>\n");
        if (this.homodimer > 1) {
            buf.append("<celldesigner:homodimer>" + this.homodimer + "</celldesigner:" + "homodimer" + ">\n");
        }
        if (this.type.equals("PROTEIN")) {
            if (this.modifications.size() > 0) {
                buf.append("<celldesigner:listOfModifications>\n");
                k = 0;
                while (k < this.modifications.size()) {
                    mod = (Modification)this.modifications.elementAt(k);
                    buf.append("<celldesigner:modification residue=\"" + mod.getResidue() + "\" " + "state" + "=\"" + mod.getState() + "\"/>\n");
                    ++k;
                }
                buf.append("</celldesigner:listOfModifications>\n");
            }
            if (this.structuralStates.size() > 0) {
                buf.append("<celldesigner:listOfStructuralStates>\n");
                k = 0;
                while (k < this.structuralStates.size()) {
                    s = (StructuralState)this.structuralStates.elementAt(k);
                    buf.append("<celldesigner:structuralState structuralState=\"" + s.getState() + "\"/>\n");
                    ++k;
                }
                buf.append("</celldesigner:listOfStructuralStates>\n");
            }
        }
        if ((this.type.equals("GENE") || this.type.equals("RNA") || this.type.equals("ANTISENSE_RNA")) && this.modifications.size() > 0) {
            buf.append("<celldesigner:listOfModifications>\n");
            k = 0;
            while (k < this.modifications.size()) {
                mod = (Modification)this.modifications.elementAt(k);
                buf.append("<celldesigner:modification residue=\"" + mod.getResidue() + "\" " + "state" + "=\"" + mod.getState() + "\"/>\n");
                ++k;
            }
            buf.append("</celldesigner:listOfModifications>\n");
        }
        if (this.type.equals("COMPLEX") && this.structuralStates.size() > 0 && this.structuralStates.size() > 0) {
            buf.append("<celldesigner:listOfStructuralStates>\n");
            k = 0;
            while (k < this.structuralStates.size()) {
                s = (StructuralState)this.structuralStates.elementAt(k);
                buf.append("<celldesigner:structuralState structuralState=\"" + s.getState() + "\"/>\n");
                ++k;
            }
            buf.append("</celldesigner:listOfStructuralStates>\n");
        }
        buf.append("</celldesigner:state>\n");
        buf.append("</celldesigner:speciesIdentity>\n");
    }

    @Override
    public String createSpeciesName() {
        if (this.type.equals("PROTEIN")) {
            if (this.protein == null) {
                return "";
            }
            return this.protein.getName();
        }
        if (this.type.equals("GENE")) {
            if (this.gene == null) {
                return "";
            }
            return this.gene.getName();
        }
        if (this.type.equals("RNA")) {
            if (this.rna == null) {
                return "";
            }
            return this.rna.getName();
        }
        if (this.type.equals("ANTISENSE_RNA")) {
            if (this.antisenserna == null) {
                return "";
            }
            return this.antisenserna.getName();
        }
        return this.name;
    }
}

