/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ModelDescription {
    private String strCreatorFamilyName = "";
    private String strCreatorGivenName = "";
    private String strCreatorOrganization = "";
    private String strCreatorEMAIL = "";
    private String strFileCreatedDate = "";
    private String strFileModifiedDate = "";

    public String getCreatorFamilyName() {
        return this.strCreatorFamilyName;
    }

    public void setCreatorFamilyName(String str) {
        this.strCreatorFamilyName = str;
    }

    public String getCreatorGivenName() {
        return this.strCreatorGivenName;
    }

    public void setCreatorGivenName(String str) {
        this.strCreatorGivenName = str;
    }

    public String getCreatorOrganization() {
        return this.strCreatorOrganization;
    }

    public void setCreatorOrganization(String str) {
        this.strCreatorOrganization = str;
    }

    public String getCreatorEMAIL() {
        return this.strCreatorEMAIL;
    }

    public void setCreatorEMAIL(String str) {
        this.strCreatorEMAIL = str;
    }

    public String getFileCreatedDate() {
        return this.strFileCreatedDate;
    }

    public void setFileCreatedDate(String str) {
        this.strFileCreatedDate = str;
    }

    public String getFileModifiedDate() {
        return this.strFileModifiedDate;
    }

    public void setFileModifiedDate(String str) {
        this.strFileModifiedDate = str;
    }

    public static final String getStandardDateStrFromW3CDTF(String strInput) {
        String returnValue = "";
        if (strInput == null) {
            return returnValue;
        }
        String strW3cDate = strInput.trim();
        if (strW3cDate.matches("(\\d{4})-(\\d{1,2})-(\\d{1,2})T(\\d{1,2}):(\\d{1,2}):(\\d{1,2})")) {
            return strW3cDate;
        }
        if (strW3cDate.matches("(\\d{4})-(\\d{1,2})-(\\d{1,2})T(\\d{1,2}):(\\d{1,2}):(\\d{1,2})(z|Z)")) {
            return strW3cDate.substring(0, strW3cDate.length() - 1);
        }
        return returnValue;
    }

    public static final String checkDateExist(String strInput) {
        String[] itemsTime;
        String strStandardDate = ModelDescription.getStandardDateStrFromW3CDTF(strInput);
        if (strStandardDate == null || strStandardDate.equals("") || strStandardDate.length() < 4) {
            return null;
        }
        int iYear = 0;
        int iMonth = 1;
        int iDay = 1;
        int iHour = 0;
        int iMinute = 0;
        int iSecond = 0;
        boolean iMisSecond = false;
        String[] items = strStandardDate.split("T");
        if (items == null || items.length == 0) {
            return null;
        }
        String[] itemsDate = items[0].split("-");
        if (itemsDate == null || itemsDate.length == 0) {
            return null;
        }
        iYear = Integer.parseInt(itemsDate[0]);
        if (itemsDate.length >= 2) {
            iMonth = Integer.parseInt(itemsDate[1]);
        }
        if (itemsDate.length >= 3) {
            iDay = Integer.parseInt(itemsDate[2]);
        }
        if (items.length >= 2 && ((itemsTime = items[1].split(":")) != null || itemsTime.length > 0)) {
            iHour = Integer.parseInt(itemsTime[0]);
            if (itemsTime.length >= 2) {
                iMinute = Integer.parseInt(itemsTime[1]);
            }
            if (itemsTime.length >= 3 && itemsTime[2] != null) {
                iSecond = (int)Double.parseDouble(itemsTime[2]);
            }
        }
        if (iYear < 1900 || iYear > 2050) {
            return null;
        }
        if (iMonth < 1 || iMonth > 12) {
            return null;
        }
        if (iDay < 1 || iDay > 31) {
            return null;
        }
        if (iMonth == 4 || iMonth == 6 || iMonth == 9 || iMonth == 11 ? iDay > 30 : iMonth == 2 && (iYear % 100 == 0 && iYear % 400 == 0 || iYear % 100 != 0 && iYear % 4 == 0 ? iDay > 29 : iDay > 28)) {
            return null;
        }
        if (iHour < 0 || iHour > 23) {
            return null;
        }
        if (iMinute < 0 || iMinute > 59) {
            return null;
        }
        if (iSecond < 0 || iSecond > 59) {
            return null;
        }
        String strDate = iYear + "-";
        strDate = iMonth < 10 ? String.valueOf(strDate) + "0" + iMonth + "-" : String.valueOf(strDate) + iMonth + "-";
        strDate = iDay < 10 ? String.valueOf(strDate) + "0" + iDay + " " : String.valueOf(strDate) + iDay + " ";
        strDate = iHour < 10 ? String.valueOf(strDate) + "0" + iHour + ":" : String.valueOf(strDate) + iHour + ":";
        strDate = iMinute < 10 ? String.valueOf(strDate) + "0" + iMinute + ":" : String.valueOf(strDate) + iMinute + ":";
        strDate = iSecond < 10 ? String.valueOf(strDate) + "0" + iSecond : String.valueOf(strDate) + iSecond;
        try {
            Calendar cld = Calendar.getInstance();
            cld.setLenient(false);
            cld.set(iYear, iMonth - 1, iDay, iHour, iMinute, iSecond);
            if (cld.get(1) != iYear || cld.get(2) != iMonth - 1 || cld.get(5) != iDay || cld.get(11) != iHour || cld.get(12) != iMinute || cld.get(13) != iSecond) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return strDate;
    }

    public static final String getCurrentTimeChangeToW3CDTF(Date input) {
        Date date = new Date();
        if (input != null) {
            date = input;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd*HH:mm:ss");
        String temp = df.format(date);
        String rtn = temp.replace("*", "T");
        return rtn;
    }

    public static final String changeToW3CDTF(String input) {
        if (input == null) {
            return null;
        }
        String rtn = input.replace(" ", "T");
        return rtn;
    }

    public static final boolean isThisDataCanSeemAsNull(ModelDescription input) {
        if (input == null) {
            return true;
        }
        return ModelDescription.isCreatorDescriptionOfThisDataCanSeemAsNull(input) && ModelDescription.isCreatedModifiedDescriptionOfThisDataCanSeemAsNull(input);
    }

    public static final boolean isCreatorDescriptionOfThisDataCanSeemAsNull(ModelDescription input) {
        if (input == null) {
            return true;
        }
        return !(input.strCreatorFamilyName != null && !input.strCreatorFamilyName.trim().equals("") || input.strCreatorGivenName != null && !input.strCreatorGivenName.trim().equals("") || input.strCreatorOrganization != null && !input.strCreatorOrganization.trim().equals("") || input.strCreatorEMAIL != null && !input.strCreatorEMAIL.trim().equals(""));
    }

    public static final boolean isCreatedModifiedDescriptionOfThisDataCanSeemAsNull(ModelDescription input) {
        if (input == null) {
            return true;
        }
        return !(input.strFileCreatedDate != null && !input.strFileCreatedDate.trim().equals("") || input.strFileModifiedDate != null && !input.strFileModifiedDate.trim().equals(""));
    }
}

