/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MiriamEditDialog;
import jp.sbi.celldesigner.MiriamMainDialog;
import jp.sbi.celldesigner.SBModel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.miriam.MIRIAM;
import jp.sbi.celldesigner.miriam.MiriamDatatype;
import jp.sbi.celldesigner.miriam.MiriamResource;
import jp.sbi.celldesigner.miriam.MiriamUtils;
import jp.sbi.celldesigner.util.OpenURLThread;
import jp.sbi.sbml.MiriamDefinition;
import jp.sbi.sbml.MiriamSubDefinition;
import jp.sbi.sbml.util.LibSBMLUtil;
import org.sbml.libsbml.ListOfParameters;
import org.sbml.libsbml.Parameter;
import org.sbml.libsbml.SBase;
import org.sbml.libsbml.XMLNode;

public class MiriamMainPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private AbstractTableModel dataModel = null;
    private JButton jButtonNew = null;
    private JButton jButtonEdit = null;
    private JButton jButtonRemove = null;
    private JButton jButtonClearAll = null;
    private JScrollPane jScrollPaneSub = null;
    private JTable jTableSub = null;
    private AbstractTableModel subdataModel = null;
    private JButton jButtonSubNew = null;
    private JButton jButtonSubEdit = null;
    private JButton jButtonSubRemove = null;
    private JPanel jPanel = null;
    private Vector vecMiriam;
    private MiriamDefinition miriam;
    private MiriamEditDialog bms;
    private SBase sbase;
    protected boolean haveParentDialog = false;
    private static final String title = "Warning";
    private static final String messageForRemove = "Are you sure to REMOVE.";
    private static final String messageForClearAll = "Are you sure to CLEAR ALL.";
    private static final String strHtmlBr = "<BR>";
    private static final String strInfo = "Info: ";
    private static final String strInstitution = "Institution: ";
    private static final String strLocation = "Location: ";

    public MiriamMainPanel() {
        this.initialize();
    }

    private void initialize() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(null);
        Border etched = BorderFactory.createEmptyBorder();
        this.jPanel.setBorder(etched);
        this.jPanel.setSize(370, 260);
        this.jPanel.setLayout(null);
        this.jPanel.setAutoscrolls(true);
        this.jPanel.add((Component)this.getJScrollPane(), null);
        this.jPanel.add((Component)this.getJButtonNew(), null);
        this.jPanel.add((Component)this.getJButtonEdit(), null);
        this.jPanel.add((Component)this.getJButtonRemove(), null);
        this.jPanel.add((Component)this.getJButtonClearAll(), null);
        this.jPanel.add((Component)this.getJScrollPaneSub(), null);
        this.jPanel.add((Component)this.getJButtonSubNew(), null);
        this.jPanel.add((Component)this.getJButtonSubEdit(), null);
        this.jPanel.add((Component)this.getJButtonSubRemove(), null);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(etched);
        scrollPane.setViewportView(this.jPanel);
        scrollPane.setPreferredSize(new Dimension(370, 260));
        scrollPane.setAutoscrolls(true);
        this.add((Component)scrollPane, null);
        this.setLayout(new FlowLayout(0));
        this.setBorder(etched);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBounds(new Rectangle(5, 5, 360, 90));
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JScrollPane getJScrollPaneSub() {
        if (this.jScrollPaneSub == null) {
            this.jScrollPaneSub = new JScrollPane();
            this.jScrollPaneSub.setBounds(new Rectangle(5, 150, 360, 70));
            this.jScrollPaneSub.setViewportView(this.getJTableSub());
        }
        return this.jScrollPaneSub;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.dataModel = new AbstractTableModel(){
                String[] columnNames = new String[]{"Relation"};

                @Override
                public String getColumnName(int column) {
                    if (this.columnNames[column] != null) {
                        return this.columnNames[column];
                    }
                    return "";
                }

                @Override
                public int getRowCount() {
                    if (MiriamMainPanel.this.vecMiriam == null) {
                        return 0;
                    }
                    return MiriamMainPanel.this.vecMiriam.size();
                }

                @Override
                public int getColumnCount() {
                    return this.columnNames.length;
                }

                @Override
                public Object getValueAt(int row, int col) {
                    if (MiriamMainPanel.this.vecMiriam == null) {
                        return null;
                    }
                    MiriamDefinition mr = (MiriamDefinition)MiriamMainPanel.this.vecMiriam.elementAt(row);
                    if (col == 0) {
                        return mr.getRelation();
                    }
                    return null;
                }
            };
            this.jTable = new JTable(this.dataModel);
            this.jTable.setSelectionMode(2);
            this.jTable.getTableHeader().setReorderingAllowed(false);
            this.jTable.getTableHeader().setResizingAllowed(true);
            ListSelectionModel rowSM = this.jTable.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int[] cnt = MiriamMainPanel.this.jTable.getSelectedRows();
                    if (cnt == null || cnt.length < 1) {
                        return;
                    }
                    if (cnt.length == 1) {
                        MiriamDefinition miriamselected = MiriamMainPanel.this.getMainSelectedElements()[0];
                        MiriamMainPanel.this.setSubObject(miriamselected);
                    } else {
                        MiriamMainPanel.this.setSubObject(null);
                    }
                    if (MiriamMainPanel.this.subdataModel != null) {
                        MiriamMainPanel.this.subdataModel.fireTableDataChanged();
                    }
                    MiriamMainPanel.this.changeButtonsEnability();
                    MiriamMainPanel.this.changeSubButtonsEnability();
                }
            });
        }
        return this.jTable;
    }

    private JTable getJTableSub() {
        if (this.jTableSub == null) {
            this.subdataModel = new AbstractTableModel(){
                String[] columnNames = new String[]{"DataType", "ID"};

                @Override
                public String getColumnName(int column) {
                    if (this.columnNames[column] != null) {
                        return this.columnNames[column];
                    }
                    return "";
                }

                @Override
                public int getRowCount() {
                    if (MiriamMainPanel.this.miriam == null) {
                        return 0;
                    }
                    return MiriamMainPanel.this.miriam.getDatas().size();
                }

                @Override
                public int getColumnCount() {
                    return this.columnNames.length;
                }

                @Override
                public Object getValueAt(int row, int col) {
                    if (MiriamMainPanel.this.miriam == null) {
                        return null;
                    }
                    if (MiriamMainPanel.this.miriam.getDatas() == null) {
                        return null;
                    }
                    if (MiriamMainPanel.this.miriam.getDatas().get(row) == null) {
                        return null;
                    }
                    MiriamSubDefinition miriamSubDefinition = (MiriamSubDefinition)MiriamMainPanel.this.miriam.getDatas().get(row);
                    String strDataType = new String(miriamSubDefinition.strDataType);
                    String strId = new String(miriamSubDefinition.strId);
                    String asciiId = MiriamUtils.changeMiriamIdFormat(strId, false);
                    if (col == 0) {
                        return strDataType;
                    }
                    if (col == 1) {
                        return asciiId;
                    }
                    return null;
                }
            };
            this.jTableSub = new JTable(this.subdataModel);
            this.jTableSub.setSelectionMode(2);
            this.jTableSub.getTableHeader().setReorderingAllowed(false);
            this.jTableSub.getTableHeader().setResizingAllowed(true);
            this.jTableSub.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getModifiers() == 16) {
                        e.getClickCount();
                    }
                }
            });
            this.jTableSub.addMouseListener(new PopupMenuListener());
            ListSelectionModel rowSM = this.jTableSub.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    MiriamMainPanel.this.changeSubButtonsEnability();
                }
            });
        }
        return this.jTableSub;
    }

    private void accessWebSite() {
        MiriamSubDefinition selecteddata;
        MiriamSubDefinition[] vecSelectedSubData = this.getSubSelectedElements();
        if (vecSelectedSubData != null && vecSelectedSubData.length > 0 && (selecteddata = vecSelectedSubData[0]) != null) {
            String strDataType = new String(selecteddata.strDataType);
            String strID = new String(selecteddata.strId);
            MIRIAM miriamtemp = MainWindow.getInstanceOfMIRIAM();
            String strURL = MiriamUtils.makeDataEntryUsingNameAndID(miriamtemp, strDataType, strID, 0);
            try {
                OpenURLThread ourlt = new OpenURLThread(strURL);
                Thread t = new Thread(ourlt);
                t.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private JButton getJButtonNew() {
        if (this.jButtonNew == null) {
            this.jButtonNew = new JButton();
            this.jButtonNew.setBounds(new Rectangle(5, 100, 75, 30));
            this.jButtonNew.setText("New");
            this.jButtonNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MiriamMainPanel.this.newbtn_actionPerformed();
                }
            });
        }
        return this.jButtonNew;
    }

    private JButton getJButtonEdit() {
        if (this.jButtonEdit == null) {
            this.jButtonEdit = new JButton();
            this.jButtonEdit.setBounds(new Rectangle(85, 100, 75, 30));
            this.jButtonEdit.setText("Edit");
            this.jButtonEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MiriamMainPanel.this.editbtn_actionPerformed();
                }
            });
        }
        return this.jButtonEdit;
    }

    private JButton getJButtonRemove() {
        if (this.jButtonRemove == null) {
            this.jButtonRemove = new JButton();
            this.jButtonRemove.setBounds(new Rectangle(165, 100, 95, 30));
            this.jButtonRemove.setText("Remove");
            this.jButtonRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] cnt = MiriamMainPanel.this.jTable.getSelectedRows();
                    if (cnt == null || cnt.length < 1) {
                        return;
                    }
                    if (JOptionPane.showConfirmDialog(null, MiriamMainPanel.messageForRemove, MiriamMainPanel.title, 0) != 0) {
                        return;
                    }
                    int i = cnt.length - 1;
                    while (i >= 0) {
                        MiriamMainPanel.this.vecMiriam.remove(cnt[i]);
                        MiriamMainPanel.this.miriam = null;
                        --i;
                    }
                    MiriamMainPanel.updateSBaseAnnotation(MiriamMainPanel.this.getSBase(), MiriamMainPanel.this.getMainObject());
                    MiriamMainPanel.this.dataModel.fireTableDataChanged();
                    MiriamMainPanel.this.subdataModel.fireTableDataChanged();
                    MiriamMainPanel.this.changeButtonsEnability();
                    MiriamMainPanel.this.changeSubButtonsEnability();
                    try {
                        SBModelFrame sbmfrm = MainWindow.getLastInstance().getCurrentModel();
                        sbmfrm.setHasAnySBaseChangedFlg(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.jButtonRemove;
    }

    private JButton getJButtonClearAll() {
        if (this.jButtonClearAll == null) {
            this.jButtonClearAll = new JButton();
            this.jButtonClearAll.setBounds(new Rectangle(265, 100, 100, 30));
            this.jButtonClearAll.setText("Clear All");
            this.jButtonClearAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JOptionPane.showConfirmDialog(null, MiriamMainPanel.messageForClearAll, MiriamMainPanel.title, 0) != 0) {
                        return;
                    }
                    MiriamMainPanel.this.vecMiriam.removeAllElements();
                    MiriamMainPanel.this.miriam = null;
                    MiriamMainPanel.updateSBaseAnnotation(MiriamMainPanel.this.getSBase(), MiriamMainPanel.this.getMainObject());
                    MiriamMainPanel.this.dataModel.fireTableDataChanged();
                    MiriamMainPanel.this.subdataModel.fireTableDataChanged();
                    MiriamMainPanel.this.changeButtonsEnability();
                    MiriamMainPanel.this.changeSubButtonsEnability();
                    try {
                        SBModelFrame sbmfrm = MainWindow.getLastInstance().getCurrentModel();
                        sbmfrm.setHasAnySBaseChangedFlg(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.jButtonClearAll;
    }

    private JButton getJButtonSubNew() {
        if (this.jButtonSubNew == null) {
            this.jButtonSubNew = new JButton();
            this.jButtonSubNew.setBounds(new Rectangle(5, 225, 75, 30));
            this.jButtonSubNew.setText("New");
            this.jButtonSubNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MiriamMainPanel.this.subnewbtn_actionPerformed();
                }
            });
        }
        return this.jButtonSubNew;
    }

    private JButton getJButtonSubEdit() {
        if (this.jButtonSubEdit == null) {
            this.jButtonSubEdit = new JButton();
            this.jButtonSubEdit.setBounds(new Rectangle(85, 225, 75, 30));
            this.jButtonSubEdit.setText("Edit");
            this.jButtonSubEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MiriamMainPanel.this.subeditbtn_actionPerformed();
                }
            });
        }
        return this.jButtonSubEdit;
    }

    private JButton getJButtonSubRemove() {
        if (this.jButtonSubRemove == null) {
            this.jButtonSubRemove = new JButton();
            this.jButtonSubRemove.setBounds(new Rectangle(165, 225, 95, 30));
            this.jButtonSubRemove.setText("Remove");
            this.jButtonSubRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String message = "It becomes to have no data in some [Relation], when REMOVE is done.\nBecause the [Relation], which have no list data, can not exist,\nremove the [Relation] together?\n\n[YES] will remove together.\n[NO] will do nothing.\n\n";
                    int[] cnt = MiriamMainPanel.this.jTableSub.getSelectedRows();
                    if (cnt == null || cnt.length < 1) {
                        return;
                    }
                    boolean bRemoveRel = false;
                    if (cnt.length == MiriamMainPanel.this.miriam.getDatas().size()) {
                        if (JOptionPane.showConfirmDialog(null, message, MiriamMainPanel.title, 0) != 0) {
                            return;
                        }
                        bRemoveRel = true;
                    } else if (JOptionPane.showConfirmDialog(null, MiriamMainPanel.messageForRemove, MiriamMainPanel.title, 0) != 0) {
                        return;
                    }
                    int i = cnt.length - 1;
                    while (i >= 0) {
                        MiriamMainPanel.this.miriam.getDatas().remove(cnt[i]);
                        --i;
                    }
                    if (bRemoveRel) {
                        i = 0;
                        while (i < MiriamMainPanel.this.vecMiriam.size()) {
                            if (MiriamMainPanel.this.vecMiriam.get(i) == MiriamMainPanel.this.miriam) {
                                MiriamMainPanel.this.vecMiriam.remove(i);
                                break;
                            }
                            ++i;
                        }
                        MiriamMainPanel.this.miriam = null;
                    }
                    MiriamMainPanel.updateSBaseAnnotation(MiriamMainPanel.this.getSBase(), MiriamMainPanel.this.getMainObject());
                    if (bRemoveRel) {
                        MiriamMainPanel.this.dataModel.fireTableDataChanged();
                    }
                    MiriamMainPanel.this.subdataModel.fireTableDataChanged();
                    MiriamMainPanel.this.changeButtonsEnability();
                    MiriamMainPanel.this.changeSubButtonsEnability();
                    try {
                        SBModelFrame sbmfrm = MainWindow.getLastInstance().getCurrentModel();
                        sbmfrm.setHasAnySBaseChangedFlg(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.jButtonSubRemove;
    }

    public void setSBase(SBase sbase) {
        this.sbase = sbase;
    }

    public SBase getSBase() {
        return this.sbase;
    }

    public void setMainObject(Vector vecMiriam) {
        this.vecMiriam = vecMiriam;
    }

    public Vector getMainObject() {
        return this.vecMiriam;
    }

    public void setSubObject(MiriamDefinition miriam) {
        this.miriam = miriam;
    }

    public MiriamDefinition getSubObject() {
        return this.miriam;
    }

    public void repaintPanelForMain() {
        if (this.dataModel != null) {
            this.dataModel.fireTableDataChanged();
        }
        if (this.subdataModel != null) {
            this.subdataModel.fireTableDataChanged();
        }
        this.changeButtonsEnability();
        this.changeSubButtonsEnability();
    }

    public void repaintPanelForSub() {
        this.subdataModel.fireTableDataChanged();
        if (this.isShowing()) {
            this.repaint();
        }
        this.changeSubButtonsEnability();
    }

    public void changeButtonsEnability() {
        this.jButtonNew.setEnabled(false);
        this.jButtonEdit.setEnabled(false);
        this.jButtonRemove.setEnabled(false);
        this.jButtonClearAll.setEnabled(false);
        if (this.getSBase() == null) {
            return;
        }
        this.jButtonNew.setEnabled(true);
        if (this.vecMiriam != null && this.vecMiriam.size() > 0) {
            this.jButtonClearAll.setEnabled(true);
            int[] index = this.jTable.getSelectedRows();
            if (index.length > 0) {
                this.jButtonRemove.setEnabled(true);
                if (index.length == 1) {
                    this.jButtonEdit.setEnabled(true);
                }
            }
        }
    }

    public void changeSubButtonsEnability() {
        int[] index;
        this.jButtonSubNew.setEnabled(false);
        this.jButtonSubEdit.setEnabled(false);
        this.jButtonSubRemove.setEnabled(false);
        if (this.miriam == null || this.miriam.getDatas() == null) {
            return;
        }
        this.jButtonSubNew.setEnabled(true);
        if (this.miriam.getDatas().size() > 0 && (index = this.jTableSub.getSelectedRows()).length > 0) {
            this.jButtonSubRemove.setEnabled(true);
            if (index.length == 1) {
                this.jButtonSubEdit.setEnabled(true);
            }
        }
    }

    public MiriamDefinition[] getMainSelectedElements() {
        if (this.vecMiriam == null) {
            MiriamDefinition[] array = new MiriamDefinition[]{};
            return array;
        }
        int[] cnt = this.jTable.getSelectedRows();
        MiriamDefinition[] array = new MiriamDefinition[cnt.length];
        int i = 0;
        while (i < cnt.length) {
            int index = cnt[i];
            array[i] = (MiriamDefinition)this.vecMiriam.get(index);
            ++i;
        }
        return array;
    }

    public MiriamSubDefinition[] getSubSelectedElements() {
        if (this.miriam == null || this.miriam.getDatas() == null || this.miriam.getDatas().size() == 0) {
            MiriamSubDefinition[] array = new MiriamSubDefinition[]{};
            return array;
        }
        int[] cnt = this.jTableSub.getSelectedRows();
        MiriamSubDefinition[] array = new MiriamSubDefinition[cnt.length];
        int i = 0;
        while (i < cnt.length) {
            int index = cnt[i];
            array[i] = (MiriamSubDefinition)this.miriam.getDatas().get(index);
            ++i;
        }
        return array;
    }

    private void newbtn_actionPerformed() {
        if (!this.haveParentDialog) {
            this.bms = MainWindow.getMiriamEditDialog();
        }
        this.bms.resetDialog();
        this.bms.setObject(new MiriamDefinition());
        this.bms.setNewMainFlag1(true);
        this.bms.updateDialog();
        this.bms.setLocation(300, 200);
        this.bms.setVisible(true);
    }

    private void editbtn_actionPerformed() {
        if (!this.haveParentDialog) {
            this.bms = MainWindow.getMiriamEditDialog();
        }
        this.bms.resetDialog();
        this.bms.setObject(this.miriam);
        this.bms.setEditMainFlag(true);
        this.bms.updateDialog();
        this.bms.setLocation(300, 200);
        this.bms.setVisible(true);
    }

    private void subnewbtn_actionPerformed() {
        if (!this.haveParentDialog) {
            this.bms = MainWindow.getMiriamEditDialog();
        }
        this.bms.resetDialog();
        this.bms.setObject(this.miriam);
        this.bms.setNewSubFlag(true);
        this.bms.updateDialog();
        this.bms.setLocation(300, 200);
        this.bms.setVisible(true);
    }

    private void subeditbtn_actionPerformed() {
        MiriamDefinition miriam = this.getMainSelectedElements()[0];
        MiriamSubDefinition selectedData = this.getSubSelectedElements()[0];
        if (selectedData != null) {
            if (!this.haveParentDialog) {
                this.bms = MainWindow.getMiriamEditDialog();
            }
            this.bms.resetDialog();
            this.bms.setObject(miriam);
            this.bms.setSelectedData(selectedData);
            this.bms.setEditSubFlag(true);
            this.bms.updateDialog();
            this.bms.setLocation(300, 200);
            this.bms.setVisible(true);
        }
    }

    public static void updateSBaseAnnotation(SBase sbase, Vector vecDatas) {
        block7: {
            if (sbase == null) {
                return;
            }
            if (vecDatas == null) {
                return;
            }
            StringBuffer strannotation = LibSBMLUtil.getMiriamValueFromMiriams(new StringBuffer(), sbase, vecDatas, true);
            XMLNode annotation = XMLNode.convertStringToXMLNode((String)strannotation.toString());
            sbase.setAnnotation(annotation);
            sbase.setAnnotation(strannotation.toString());
            if (sbase instanceof Parameter) {
                Parameter selectedParameter = (Parameter)sbase;
                String strSelectedParameterKey = String.valueOf(LibSBMLUtil.getParameterScope(selectedParameter)) + selectedParameter.getId();
                try {
                    SBModel sbmodel = MainWindow.getLastInstance().getCurrentModel().getSBModel();
                    ListOfParameters listParameter = sbmodel.getModel().getListOfParameters();
                    if (listParameter == null) break block7;
                    int i = 0;
                    while ((long)i < listParameter.size()) {
                        Parameter parameter = (Parameter)listParameter.get((long)i);
                        String strParameterKey = String.valueOf(LibSBMLUtil.getParameterScope(parameter)) + parameter.getId();
                        if (strSelectedParameterKey != null && strSelectedParameterKey.equals(strParameterKey)) {
                            parameter.setAnnotation(annotation);
                            parameter.setAnnotation(strannotation.toString());
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void resetPanelData(boolean repaint) {
        this.setPanelData();
        if (repaint) {
            this.repaintPanelForMain();
        }
    }

    private Vector setPanelData() {
        SBase sbasetemp = this.getSBase();
        if (sbasetemp == null) {
            this.setMainObject(null);
            this.setSubObject(null);
            return null;
        }
        XMLNode node = sbasetemp.getAnnotation();
        if (node != null && node.getNumChildren() > 0L) {
            XMLNode dnode = null;
            if (node.getNumChildren() > 1L) {
                int i = 0;
                while ((long)i < node.getNumChildren()) {
                    XMLNode child = node.getChild((long)i);
                    String strTag = String.valueOf(child.getPrefix()) + ":" + child.getName();
                    if (strTag != null && strTag.equals("rdf:RDF")) {
                        dnode = child;
                        break;
                    }
                    ++i;
                }
            } else {
                dnode = node.getChild(0L);
            }
            Vector vecData = MiriamMainPanel.getMiriamsFromXMLNode(new Vector(), dnode, null);
            this.setMainObject(vecData);
            this.setSubObject(null);
            return vecData;
        }
        this.setMainObject(null);
        this.setSubObject(null);
        return null;
    }

    public static Vector getMiriamsFromXMLNode(Vector vecMiriam, XMLNode elem, MiriamDefinition miriam) {
        if (vecMiriam == null) {
            return new Vector();
        }
        if (elem == null) {
            return new Vector();
        }
        boolean miriamaddedflag = false;
        int ui = 0;
        while ((long)ui < elem.getNumChildren()) {
            block11: {
                String strTag;
                XMLNode n;
                block14: {
                    String[] dataTypeAndID;
                    block13: {
                        block12: {
                            block10: {
                                n = elem.getChild((long)ui);
                                strTag = String.valueOf(n.getPrefix()) + ":" + n.getName();
                                if (!strTag.equals("rdf:RDF")) break block10;
                                Vector vector1 = MiriamMainPanel.getMiriamsFromXMLNode(vecMiriam, n, miriam);
                                if (vector1 != null && vector1.size() > 0) {
                                    vecMiriam = vector1;
                                }
                                break block11;
                            }
                            if (!strTag.equals("rdf:Description")) break block12;
                            Vector vector1 = MiriamMainPanel.getMiriamsFromXMLNode(vecMiriam, n, miriam);
                            if (vector1 != null && vector1.size() > 0) {
                                vecMiriam = vector1;
                            }
                            break block11;
                        }
                        if (!strTag.equals("rdf:Bag")) break block13;
                        Vector vector2 = MiriamMainPanel.getMiriamsFromXMLNode(vecMiriam, n, miriam);
                        if (vector2 != null && vector2.size() > 0) {
                            vecMiriam = vector2;
                        }
                        break block11;
                    }
                    if (!strTag.equals("rdf:li")) break block14;
                    if (n.getAttributes().getLength() < 1) break block11;
                    String value = n.getAttributes().getValue(0).toString();
                    if (miriam == null || miriam.getRelation() == null || miriam.getRelation().equals("") || (dataTypeAndID = MiriamUtils.makeDataTypeAndIDUsingUri(value)) == null) break block11;
                    miriamaddedflag = true;
                    String strURL = dataTypeAndID[0];
                    String strID = dataTypeAndID[1];
                    if (strURL == null || strURL.equals("") || strID == null || strID.equals("")) break block11;
                    Vector<MiriamSubDefinition> vecData = miriam.getDatas();
                    if (vecData == null) {
                        vecData = new Vector<MiriamSubDefinition>();
                    }
                    MiriamSubDefinition singleDate = new MiriamSubDefinition();
                    MIRIAM miriamtemp = MainWindow.getInstanceOfMIRIAM();
                    String strDataTypename = MiriamUtils.getNameOfMiriamDatatypeUsingUri(miriamtemp, strURL);
                    singleDate.strDataType = new String(strDataTypename);
                    singleDate.strId = new String(strID);
                    int iUrlLen = strURL.length();
                    singleDate.strUri = new String(String.valueOf(strURL) + value.substring(iUrlLen, iUrlLen + 1) + strID);
                    vecData.add(singleDate);
                    miriam.setDatas(vecData);
                    break block11;
                }
                int count = 0;
                while (count < MIRIAM.vectEnumerationRelationOfMIRIAM.size()) {
                    String tagName = MIRIAM.vectEnumerationRelationOfMIRIAM.get(count);
                    if (strTag.equals(tagName)) {
                        MiriamDefinition miriamtemp = new MiriamDefinition();
                        miriamtemp.setRelation(strTag);
                        vecMiriam = MiriamMainPanel.getMiriamsFromXMLNode(vecMiriam, n, miriamtemp);
                        break;
                    }
                    ++count;
                }
            }
            ++ui;
        }
        if (miriamaddedflag) {
            vecMiriam.add(miriam);
        }
        return vecMiriam;
    }

    protected void doActionOfShowPopupMenu(MouseEvent e) {
        String strid;
        String strDataType;
        JPopupMenu popMenu;
        int pressedRow;
        if (!e.isPopupTrigger()) {
            return;
        }
        if (this.jTableSub == null) {
            return;
        }
        MiriamSubDefinition[] selected = this.getSubSelectedElements();
        if (selected.length != 1) {
            return;
        }
        int[] index = this.jTableSub.getSelectedRows();
        if (index[0] != (pressedRow = this.jTableSub.rowAtPoint(e.getPoint()))) {
            return;
        }
        MiriamSubDefinition selectedData = selected[0];
        if (selectedData != null && (popMenu = MiriamMainPanel.makePopupMenu(strDataType = new String(selectedData.strDataType), strid = new String(selectedData.strId))) != null) {
            popMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public static final JPopupMenu makePopupMenu(String strDataType, String strid) {
        JPopupMenu popMenu = new JPopupMenu();
        MIRIAM miriamtemp = MainWindow.getInstanceOfMIRIAM();
        int indexDataType = MiriamUtils.getIndexOfNameInMiriam(miriamtemp, strDataType);
        Vector<MiriamDatatype> vecDataType = miriamtemp.getDatatypes();
        Vector<MiriamResource> vecResources = null;
        if (vecDataType != null && vecDataType.size() > 0) {
            vecResources = miriamtemp.getDatatype(indexDataType).getResources();
        }
        if (vecResources != null && vecResources.size() > 0) {
            Vector<String> vDataResourcesOfMiriamDatatype = MiriamUtils.getDataResourcesOfMiriamDatatype(miriamtemp, strDataType);
            int cnt = 0;
            while (cnt < vecResources.size()) {
                MiriamResource miriamResource = vecResources.get(cnt);
                JMenuItem menuItem = new JMenuItem(miriamResource.getId());
                String strDataEntry = MiriamUtils.makeDataEntryUsingNameAndID(miriamtemp, strDataType, strid, cnt);
                if (strid == null || strid.trim().equals("")) {
                    strDataEntry = vDataResourcesOfMiriamDatatype.get(cnt);
                }
                menuItem.addActionListener(new BrowseMiriamInfoAction(strDataEntry));
                String tooltiptext = "";
                tooltiptext = "<html>\t<body>Info: " + miriamResource.getDataInfo() + strHtmlBr + strInstitution + miriamResource.getDataInstitution() + strHtmlBr + strLocation + miriamResource.getDataLocation() + "\t</body>" + "</html>";
                menuItem.setToolTipText(tooltiptext);
                popMenu.add(menuItem);
                ++cnt;
            }
            return popMenu;
        }
        return null;
    }

    protected static void doActionOfBrowseMiriamInfo(String url) {
        if (url == null || url.equals("")) {
            return;
        }
        try {
            OpenURLThread ourlt = new OpenURLThread(url);
            Thread t = new Thread(ourlt);
            t.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDialogFromObject(SBase sbase) {
        this.setSBase(sbase);
        this.setPanelData();
        this.repaintPanelForMain();
    }

    public void initEditDialog(MiriamMainDialog jdialog) {
        this.bms = new MiriamEditDialog(jdialog);
        this.haveParentDialog = true;
    }

    static class BrowseMiriamInfoAction
    implements ActionListener {
        private String url;

        public BrowseMiriamInfoAction(String strUrl) {
            this.url = strUrl;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MiriamMainPanel.doActionOfBrowseMiriamInfo(this.url);
        }
    }

    class PopupMenuListener
    extends MouseAdapter {
        PopupMenuListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showPopupMenu(e);
        }

        private void showPopupMenu(MouseEvent e) {
            MiriamMainPanel.this.doActionOfShowPopupMenu(e);
        }
    }
}

