/*
 * Decompiled with CFR 0.152.
 */
package jp.sbi.celldesigner;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jp.sbi.celldesigner.MainWindow;
import jp.sbi.celldesigner.MiriamEditDialog;
import jp.sbi.celldesigner.MiriamMainDialog;
import jp.sbi.celldesigner.MiriamMainPanel;
import jp.sbi.celldesigner.SBModelFrame;
import jp.sbi.celldesigner.miriam.MIRIAM;
import jp.sbi.celldesigner.miriam.MiriamUtils;
import jp.sbi.sbml.MiriamDefinition;
import jp.sbi.sbml.MiriamSubDefinition;

public class MiriamEditPanel2
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel jLabelID = null;
    private JTextField jTextFieldID = null;
    private JButton jButtonNextRecord = null;
    private JButton jButtonOk = null;
    private JButton jButtonCancel = null;
    private JButton jButtonUpdate = null;
    private JLabel jLabeDataType = null;
    private JComboBox jComboBoxDataType = null;
    private JLabel jLabelDefinition = null;
    private JTextArea jTextArea = null;
    private MiriamEditDialog jdialog = null;
    private boolean editFlag = false;
    private String previousSelectedDataType = null;
    private JButton jButtonAccess = null;

    public MiriamEditPanel2() {
        this.initialize();
    }

    public void initialize() {
        this.jLabeDataType = new JLabel();
        this.jLabeDataType.setBounds(new Rectangle(10, 10, 70, 20));
        this.jLabeDataType.setText("DataType");
        this.jLabelDefinition = new JLabel();
        this.jLabelDefinition.setBounds(new Rectangle(10, 35, 70, 20));
        this.jLabelDefinition.setText("Definition");
        this.jLabelID = new JLabel();
        this.jLabelID.setBounds(new Rectangle(390, 10, 20, 20));
        this.jLabelID.setText("ID");
        this.setLayout(null);
        this.setBounds(new Rectangle(0, 0, 600, 180));
        this.add((Component)this.jLabelID, null);
        this.add((Component)this.getJTextFieldID(), null);
        this.add((Component)this.getJButtonNextRecord(), null);
        this.add((Component)this.getJButtonOk(), null);
        this.add((Component)this.getJButtonCancel(), null);
        this.add((Component)this.getJButtonUpdate(), null);
        this.add((Component)this.jLabeDataType, null);
        this.add((Component)this.getJComboBoxDataType(), null);
        this.add((Component)this.jLabelDefinition, null);
        this.add((Component)this.getJTextArea(), null);
        this.add((Component)this.getJButtonAccess(), null);
        this.initComboBoxDataTypeValue();
    }

    private JTextField getJTextFieldID() {
        if (this.jTextFieldID == null) {
            this.jTextFieldID = new JTextField();
            this.jTextFieldID.setBounds(new Rectangle(415, 10, 170, 20));
        }
        return this.jTextFieldID;
    }

    private JButton getJButtonNextRecord() {
        if (this.jButtonNextRecord == null) {
            this.jButtonNextRecord = new JButton();
            this.jButtonNextRecord.setBounds(new Rectangle(80, 140, 130, 30));
            this.jButtonNextRecord.setText("Next Record");
            this.jButtonNextRecord.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MiriamEditPanel2.this.nextRecordbtn_actionPerformed();
                }
            });
        }
        return this.jButtonNextRecord;
    }

    private JButton getJButtonOk() {
        if (this.jButtonOk == null) {
            this.jButtonOk = new JButton();
            this.jButtonOk.setBounds(new Rectangle(365, 140, 80, 30));
            this.jButtonOk.setText("OK");
            this.jButtonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MiriamEditPanel2.this.okbtn_actionPerformed();
                }
            });
        }
        return this.jButtonOk;
    }

    private JButton getJButtonUpdate() {
        if (this.jButtonUpdate == null) {
            this.jButtonUpdate = new JButton();
            this.jButtonUpdate.setBounds(new Rectangle(350, 140, 110, 30));
            this.jButtonUpdate.setText("Update");
            this.jButtonUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MiriamEditPanel2.this.updateAndAddbtnForSingleData_actionPerformed();
                }
            });
        }
        return this.jButtonUpdate;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setBounds(new Rectangle(480, 140, 100, 30));
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MiriamEditPanel2.this.closebtn_actionPerformed();
                }
            });
        }
        return this.jButtonCancel;
    }

    public void setDialogData() {
        MiriamSubDefinition selectedData;
        if (this.getSubDataEditFlag()) {
            this.jButtonUpdate.setText("Update");
        } else {
            this.jButtonUpdate.setText("Add");
        }
        MIRIAM miriam = MainWindow.getInstanceOfMIRIAM();
        MiriamEditDialog dialog = this.getJDialog();
        if (dialog != null && (selectedData = dialog.getSelectedData()) != null) {
            String strSelectedID = new String(selectedData.strId);
            String strDataTypeName = new String(selectedData.strDataType);
            if (strSelectedID == null) {
                return;
            }
            String utfId = MiriamUtils.changeMiriamIdFormat(strSelectedID, false);
            this.jTextFieldID.setText(utfId);
            this.jComboBoxDataType.setSelectedIndex(0);
            if (this.previousSelectedDataType != null && !this.previousSelectedDataType.equals("")) {
                this.jComboBoxDataType.setSelectedItem(this.previousSelectedDataType);
                this.previousSelectedDataType = null;
            } else if (strDataTypeName != null) {
                if ("".equals(strDataTypeName)) {
                    String strDT = this.getLastDataType(dialog);
                    this.jComboBoxDataType.setSelectedItem(strDT);
                } else {
                    this.jComboBoxDataType.setSelectedItem(strDataTypeName);
                }
            }
            String strDefinition = MiriamUtils.getDefinitionOfMiriamDatatype(miriam, this.jComboBoxDataType.getSelectedItem().toString());
            this.setJLabelDefinition(strDefinition);
        }
    }

    public void setJButtonNextRecordVisable(boolean showflag) {
        this.jButtonNextRecord.setVisible(showflag);
    }

    public void setJButtonOkVisable(boolean showflag) {
        this.jButtonOk.setVisible(showflag);
    }

    public void setJButtonUpdateVisable(boolean showflag) {
        this.jButtonUpdate.setVisible(showflag);
    }

    public void setButtonVisable(boolean nextrecordbtnflag, boolean nextbtnflag, boolean updatebtnflag) {
        this.setJButtonNextRecordVisable(nextrecordbtnflag);
        this.setJButtonOkVisable(nextbtnflag);
        this.setJButtonUpdateVisable(updatebtnflag);
    }

    public void setSubDataEditFlag(boolean editFlag) {
        this.editFlag = editFlag;
    }

    public boolean getSubDataEditFlag() {
        return this.editFlag;
    }

    private void closebtn_actionPerformed() {
        MiriamEditDialog dialog = this.getJDialog();
        if (dialog != null) {
            dialog.setVisible(false);
        }
    }

    private void updateAndAddbtnForSingleData_actionPerformed() {
        String strID;
        boolean hasChanged = false;
        MiriamEditDialog dialog = this.getJDialog();
        if (dialog == null) {
            return;
        }
        MiriamDefinition miriam = dialog.getObject();
        if (miriam == null) {
            return;
        }
        MIRIAM miriamtemp = MainWindow.getInstanceOfMIRIAM();
        if (this.getSubDataEditFlag()) {
            strID = this.jTextFieldID.getText();
            Vector vecData = miriam.getDatas();
            if (vecData == null) {
                return;
            }
            MiriamSubDefinition selectedData = dialog.getSelectedData();
            if (selectedData == null) {
                return;
            }
            String oldSelectedID = new String(selectedData.strId);
            if (oldSelectedID == null) {
                return;
            }
            String oldDataType = new String(selectedData.strDataType);
            if (oldDataType == null) {
                return;
            }
            String datatype = this.jComboBoxDataType.getSelectedItem().toString();
            if (!oldDataType.equals(datatype) || !oldSelectedID.equals(strID)) {
                try {
                    MiriamEditPanel2.checkID(miriamtemp, strID, datatype, vecData);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
                    return;
                }
                hasChanged = true;
            }
            Vector<MiriamSubDefinition> newList = new Vector<MiriamSubDefinition>();
            int cnt = 0;
            while (cnt < vecData.size()) {
                MiriamSubDefinition newsingle = new MiriamSubDefinition();
                MiriamSubDefinition singleData = (MiriamSubDefinition)vecData.get(cnt);
                if (singleData == null) {
                    return;
                }
                String strIDtemp = new String(singleData.strId);
                String strDataTypetemp = new String(singleData.strDataType);
                String strUri = new String(singleData.strUri);
                if (oldDataType.equals(strDataTypetemp) && oldSelectedID.equals(strIDtemp)) {
                    newsingle.strDataType = new String(datatype);
                    String asciiId = MiriamUtils.changeMiriamIdFormat(strID, true);
                    newsingle.strId = new String(asciiId);
                    if (strDataTypetemp != null && !strDataTypetemp.equals(datatype)) {
                        String strNewUri = MiriamUtils.makeUriUsingNameAndID(miriamtemp, datatype, asciiId);
                        newsingle.strUri = new String(strNewUri);
                    } else if (strUri != null) {
                        strUri = String.valueOf(strUri.substring(0, strUri.lastIndexOf(oldSelectedID))) + asciiId;
                        newsingle.strUri = new String(strUri);
                    }
                } else {
                    newsingle = singleData;
                }
                newList.add(newsingle);
                ++cnt;
            }
            miriam.setDatas(newList);
        } else {
            strID = this.jTextFieldID.getText();
            String datatype = this.jComboBoxDataType.getSelectedItem().toString();
            Vector<MiriamSubDefinition> vecData = miriam.getDatas();
            if (vecData == null) {
                vecData = new Vector<MiriamSubDefinition>();
            }
            try {
                MiriamEditPanel2.checkID(miriamtemp, strID, datatype, vecData);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
                return;
            }
            MiriamSubDefinition singleData = new MiriamSubDefinition();
            singleData.strDataType = new String(datatype);
            singleData.strId = new String(strID);
            String strNewUri = MiriamUtils.makeUriUsingNameAndID(miriamtemp, datatype, strID);
            singleData.strUri = new String(strNewUri);
            vecData.add(singleData);
            miriam.setDatas(vecData);
            hasChanged = true;
        }
        MiriamMainPanel miriamMainPanel = null;
        if (dialog.getParent() instanceof MainWindow) {
            miriamMainPanel = MainWindow.getMiriamMainPanel();
        } else if (dialog.getParent() instanceof MiriamMainDialog) {
            MiriamMainDialog miriamMainDialog = (MiriamMainDialog)dialog.getParent();
            miriamMainPanel = miriamMainDialog.getMiriamMainPanel();
        }
        if (miriamMainPanel != null) {
            MiriamMainPanel.updateSBaseAnnotation(miriamMainPanel.getSBase(), miriamMainPanel.getMainObject());
            miriamMainPanel.repaintPanelForSub();
        }
        dialog.setShowFlag(false, false, false, false, false);
        if (hasChanged) {
            try {
                SBModelFrame sbmfrm = MainWindow.getLastInstance().getCurrentModel();
                sbmfrm.setHasAnySBaseChangedFlg(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.closebtn_actionPerformed();
    }

    private void okbtn_actionPerformed() {
        MiriamEditDialog dialog = this.getJDialog();
        MIRIAM miriamtemp = MainWindow.getInstanceOfMIRIAM();
        if (dialog != null) {
            MiriamDefinition miriam = dialog.getObject();
            if (miriam == null) {
                return;
            }
            String strID = this.jTextFieldID.getText();
            String datatype = this.jComboBoxDataType.getSelectedItem().toString();
            Vector<MiriamSubDefinition> vecData = miriam.getDatas();
            if (vecData == null) {
                vecData = new Vector<MiriamSubDefinition>();
            }
            try {
                MiriamEditPanel2.checkID(miriamtemp, strID, datatype, vecData);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
                return;
            }
            MiriamSubDefinition singleData = new MiriamSubDefinition();
            singleData.strDataType = new String(datatype);
            String asciiId = MiriamUtils.changeMiriamIdFormat(strID, true);
            singleData.strId = new String(asciiId);
            String strNewUri = MiriamUtils.makeUriUsingNameAndID(miriamtemp, datatype, strID);
            singleData.strUri = new String(strNewUri);
            vecData.add(singleData);
            miriam.setDatas(vecData);
            MiriamMainPanel miriamMainPanel = null;
            if (dialog.getParent() instanceof MainWindow) {
                miriamMainPanel = MainWindow.getMiriamMainPanel();
            } else if (dialog.getParent() instanceof MiriamMainDialog) {
                MiriamMainDialog miriamMainDialog = (MiriamMainDialog)dialog.getParent();
                miriamMainPanel = miriamMainDialog.getMiriamMainPanel();
            }
            if (miriamMainPanel != null && dialog.getNewMainFlag2()) {
                Vector<MiriamDefinition> vecMiriam = miriamMainPanel.getMainObject();
                if (vecMiriam == null) {
                    vecMiriam = new Vector<MiriamDefinition>();
                }
                vecMiriam.add(miriam);
                miriamMainPanel.setMainObject(vecMiriam);
                miriamMainPanel.setSubObject(null);
                MiriamMainPanel.updateSBaseAnnotation(miriamMainPanel.getSBase(), miriamMainPanel.getMainObject());
                miriamMainPanel.repaintPanelForMain();
            }
            dialog.setShowFlag(false, false, false, false, false);
            try {
                SBModelFrame sbmfrm = MainWindow.getLastInstance().getCurrentModel();
                sbmfrm.setHasAnySBaseChangedFlg(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.closebtn_actionPerformed();
    }

    private void nextRecordbtn_actionPerformed() {
        MiriamEditDialog dialog = this.getJDialog();
        MIRIAM miriamtemp = MainWindow.getInstanceOfMIRIAM();
        if (dialog != null) {
            MiriamDefinition miriam = dialog.getObject();
            if (miriam == null) {
                return;
            }
            String strID = this.jTextFieldID.getText();
            String datatype = this.jComboBoxDataType.getSelectedItem().toString();
            Vector<MiriamSubDefinition> vecData = miriam.getDatas();
            if (vecData == null) {
                vecData = new Vector<MiriamSubDefinition>();
            }
            try {
                MiriamEditPanel2.checkID(miriamtemp, strID, datatype, vecData);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
                return;
            }
            MiriamSubDefinition singleData = new MiriamSubDefinition();
            singleData.strDataType = new String(datatype);
            singleData.strId = new String(strID);
            String strNewUri = MiriamUtils.makeUriUsingNameAndID(miriamtemp, datatype, strID);
            singleData.strUri = new String(strNewUri);
            this.previousSelectedDataType = new String(datatype);
            vecData.add(singleData);
            miriam.setDatas(vecData);
            dialog.setShowFlag(false, true, false, false, false);
            dialog.updateDialog();
        }
    }

    public void setJDialog(MiriamEditDialog jdialog) {
        this.jdialog = jdialog;
    }

    public MiriamEditDialog getJDialog() {
        return this.jdialog;
    }

    private JComboBox getJComboBoxDataType() {
        if (this.jComboBoxDataType == null) {
            this.jComboBoxDataType = new JComboBox();
            this.jComboBoxDataType.setBounds(new Rectangle(80, 10, 285, 20));
            this.jComboBoxDataType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object obj = MiriamEditPanel2.this.jComboBoxDataType.getSelectedItem();
                    if (obj != null) {
                        String dateType = obj.toString();
                        MIRIAM miriam = MainWindow.getInstanceOfMIRIAM();
                        String strDefinition = MiriamUtils.getDefinitionOfMiriamDatatype(miriam, dateType);
                        MiriamEditPanel2.this.setJLabelDefinition(strDefinition);
                    }
                }
            });
        }
        return this.jComboBoxDataType;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setBounds(new Rectangle(80, 35, 505, 95));
            this.jTextArea.setLineWrap(true);
            this.jTextArea.setWrapStyleWord(true);
            this.jTextArea.setEditable(false);
        }
        return this.jTextArea;
    }

    public void setJLabelDefinition(String strstrDefinition) {
        this.jTextArea.setText(strstrDefinition);
    }

    public static void checkID(MIRIAM miriam, String strID, String strDataType, Vector vecData) throws Exception {
        if (strDataType == null) {
            return;
        }
        if (vecData == null) {
            return;
        }
        if (strID == null || strID.equals("")) {
            throw new Exception("[ID] must be input.");
        }
        if (!MiriamUtils.checkMiriamDatatypeID(miriam, strDataType, strID)) {
            throw new Exception("[ID] is not satisfied.");
        }
        int cnt = 0;
        while (cnt < vecData.size()) {
            MiriamSubDefinition data = (MiriamSubDefinition)vecData.get(cnt);
            if (data == null) {
                return;
            }
            String strIDtemp = new String(data.strId);
            String strDataTypetemp = new String(data.strDataType);
            if (strID.equals(strIDtemp) && strDataType.equals(strDataTypetemp)) {
                throw new Exception("Same [ID] exists.");
            }
            ++cnt;
        }
    }

    public void initComboBoxDataTypeValue() {
        this.jComboBoxDataType.removeAllItems();
        MIRIAM miriam = MainWindow.getInstanceOfMIRIAM();
        Vector<String> datatypenames = MiriamUtils.getNamesOfMIRIAM(miriam);
        if (datatypenames != null) {
            this.jComboBoxDataType.removeAllItems();
            int i = 0;
            while (i < datatypenames.size()) {
                String strdatatype = datatypenames.get(i).toString();
                this.jComboBoxDataType.addItem(strdatatype);
                ++i;
            }
            if (this.jComboBoxDataType.getSelectedIndex() == -1) {
                this.jComboBoxDataType.setSelectedIndex(0);
            }
        }
    }

    public void resetDialog() {
        this.editFlag = false;
        this.jdialog = null;
    }

    public String getLastDataType(MiriamEditDialog dialog) {
        MiriamSubDefinition miriamSubDefinition;
        Vector vecSub;
        MiriamDefinition miriamDefinition;
        if (dialog == null) {
            return "";
        }
        MiriamMainPanel miriamMainPanel = null;
        if (dialog.getParent() instanceof MainWindow) {
            miriamMainPanel = MainWindow.getMiriamMainPanel();
        } else if (dialog.getParent() instanceof MiriamMainDialog) {
            MiriamMainDialog miriamMainDialog = (MiriamMainDialog)dialog.getParent();
            miriamMainPanel = miriamMainDialog.getMiriamMainPanel();
        }
        Vector vecMain = miriamMainPanel.getMainObject();
        if (vecMain != null && vecMain.size() > 0 && (miriamDefinition = (MiriamDefinition)vecMain.get(vecMain.size() - 1)) != null && (vecSub = miriamDefinition.getDatas()) != null && vecSub.size() > 0 && (miriamSubDefinition = (MiriamSubDefinition)vecSub.get(vecSub.size() - 1)) != null && miriamSubDefinition.strDataType != null) {
            return miriamSubDefinition.strDataType;
        }
        return "";
    }

    private JButton getJButtonAccess() {
        if (this.jButtonAccess == null) {
            this.jButtonAccess = new JButton();
            this.jButtonAccess.setBounds(new Rectangle(230, 140, 100, 30));
            this.jButtonAccess.setText("Access");
            this.jButtonAccess.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String strID = MiriamEditPanel2.this.jTextFieldID.getText();
                    String datatype = MiriamEditPanel2.this.jComboBoxDataType.getSelectedItem().toString();
                    JPopupMenu popMenu = MiriamMainPanel.makePopupMenu(datatype, MiriamUtils.changeMiriamIdFormat(strID, true));
                    if (popMenu != null) {
                        popMenu.show(MiriamEditPanel2.this.jButtonAccess, MiriamEditPanel2.this.jButtonAccess.getWidth() / 2, MiriamEditPanel2.this.jButtonAccess.getHeight() / 2);
                    }
                }
            });
        }
        return this.jButtonAccess;
    }

    private boolean isTypeOrIdChanged() {
        if (this.getSubDataEditFlag()) {
            String datatype = this.jComboBoxDataType.getSelectedItem().toString();
            String strID = this.jTextFieldID.getText();
            MiriamEditDialog dialog = this.getJDialog();
            MiriamSubDefinition selectedData = dialog.getSelectedData();
            String oldSelectedID = new String(selectedData.strId);
            String oldDataType = new String(selectedData.strDataType);
            if (!oldDataType.equals(datatype) || !oldSelectedID.equals(strID)) {
                return true;
            }
        }
        return false;
    }

    private boolean inputCheck(String strID, String datatype, boolean showMsg) {
        if (this.isTypeOrIdChanged() || !this.editFlag) {
            MIRIAM miriamtemp = MainWindow.getInstanceOfMIRIAM();
            MiriamEditDialog dialog = this.getJDialog();
            MiriamDefinition miriam = dialog.getObject();
            Vector vecData = miriam.getDatas();
            if (vecData == null) {
                vecData = new Vector();
            }
            try {
                MiriamEditPanel2.checkID(miriamtemp, strID, datatype, vecData);
            }
            catch (Exception ex) {
                if (showMsg) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
                }
                return false;
            }
        }
        return true;
    }
}

